/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.AttributeConfigHelper;
import fr.esrf.Tango.AttributeConfig_3Helper;
import fr.esrf.Tango.AttributeValueHelper;
import fr.esrf.Tango.AttributeValue_3Helper;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevErrorListHelper;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.ErrSeverity;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.CallBack;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.IORdump;
import fr.esrf.TangoApi.events.DbEventImportInfo;
import fr.esrf.TangoApi.events.EventCallBackStruct;
import fr.esrf.TangoApi.events.EventChannelStruct;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UserException;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventChannelAdmin.TypeError;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.EventChannelHelper;
import org.omg.CosNotifyChannelAdmin.ProxySupplier;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushSupplier;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushSupplierHelper;
import org.omg.CosNotifyComm.InvalidEventType;
import org.omg.CosNotifyComm.StructuredPushConsumerPOA;
import org.omg.CosNotifyFilter.ConstraintExp;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterFactory;
import org.omg.CosNotifyFilter.FilterNotFound;
import org.omg.CosNotifyFilter.InvalidConstraint;
import org.omg.CosNotifyFilter.InvalidGrammar;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;

public class EventConsumer
extends StructuredPushConsumerPOA
implements TangoConst,
Runnable {
    private static EventConsumer instance = null;
    private static int subscribe_event_id = 0;
    private static final long EVENT_HEARTBEAT_PERIOD = 10000L;
    private static final long EVENT_RESUBSCRIBE_PERIOD = 600000L;
    private EventChannel eventChannel;
    private ConsumerAdmin consumerAdmin;
    private ProxySupplier proxySupplier;
    private StructuredProxyPushSupplier structuredProxyPushSupplier;
    private ORB orb = ApiUtil.get_orb();
    private Hashtable channel_map;
    private Hashtable device_channel_map = null;
    private Hashtable event_callback_map;
    private Thread runner;
    private Timer keepAliveTimer;
    private boolean orbRunning = false;

    public static EventConsumer create() throws DevFailed {
        if (instance != null) {
            return instance;
        }
        return new EventConsumer();
    }

    public void updateDatabaseObject() throws DevFailed {
        System.out.println("updateDatabaseObject()  is deprecated !");
    }

    public void disconnect_structured_push_consumer() {
        System.out.println("calling EventConsumer.disconnect_structured_push_consumer()");
    }

    public void offer_change(EventType[] added, EventType[] removed) throws InvalidEventType {
        System.out.println("calling EventConsumer.offer_change()");
    }

    private void push_structured_event_heartbeat(String domain_name, String event_name) {
        try {
            if (this.channel_map.containsKey(domain_name)) {
                EventChannelStruct event_channel_struct = (EventChannelStruct)this.channel_map.get(domain_name);
                event_channel_struct.last_heartbeat = System.currentTimeMillis();
            } else {
                Enumeration keys = this.channel_map.keys();
                boolean found = false;
                while (keys.hasMoreElements() && !found) {
                    String name = (String)keys.nextElement();
                    EventChannelStruct event_channel_struct = (EventChannelStruct)this.channel_map.get(name);
                    if (!event_channel_struct.adm_device_proxy.name().equals(domain_name)) continue;
                    event_channel_struct.last_heartbeat = System.currentTimeMillis();
                    found = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private java.lang.Object extractAttributeObject(StructuredEvent notification) throws BadKind {
        TypeCode ty = notification.remainder_of_body.type();
        if (ty.kind().equals(TCKind.tk_struct)) {
            String ty_name = ty.name();
            if (ty_name.equals("AttributeConfig_3")) {
                return new AttributeInfoEx(AttributeConfig_3Helper.extract(notification.remainder_of_body));
            }
            if (ty_name.equals("AttributeConfig_2")) {
                return new AttributeInfoEx(AttributeConfigHelper.extract(notification.remainder_of_body));
            }
            if (ty_name.equals("AttributeValue_3")) {
                return new DeviceAttribute(AttributeValue_3Helper.extract(notification.remainder_of_body));
            }
            if (ty_name.equals("AttributeValue")) {
                return new DeviceAttribute(AttributeValueHelper.extract(notification.remainder_of_body));
            }
            DevError[] dev_err_list = new DevError[]{new DevError("API_IncompatibleAttrDataType", ErrSeverity.ERR, "Unknown structure used to pass attribute value (Need compilation ?)", "EventConsumer::extractAttributeObject()")};
            return dev_err_list;
        }
        return DevErrorListHelper.extract(notification.remainder_of_body);
    }

    public void push_structured_event(StructuredEvent notification) {
        String domain_name = notification.header.fixed_header.event_type.domain_name;
        String event_name = notification.header.fixed_header.event_name;
        try {
            if (event_name.equals("heartbeat")) {
                this.push_structured_event_heartbeat(domain_name, event_name);
                return;
            }
            String attr_event_name = domain_name + "." + event_name;
            if (this.event_callback_map.containsKey(attr_event_name)) {
                EventCallBackStruct event_callback_struct = (EventCallBackStruct)this.event_callback_map.get(attr_event_name);
                CallBack callback = event_callback_struct.callback;
                if (callback != null) {
                    DeviceAttribute attr_value = null;
                    AttributeInfoEx attr_config = null;
                    DevError[] dev_err_list = null;
                    java.lang.Object obj = this.extractAttributeObject(notification);
                    if (obj instanceof AttributeInfoEx) {
                        attr_config = (AttributeInfoEx)obj;
                    } else if (obj instanceof DeviceAttribute) {
                        attr_value = (DeviceAttribute)obj;
                    } else if (obj instanceof DevError[]) {
                        dev_err_list = (DevError[])obj;
                    }
                    EventData event_data = new EventData(event_callback_struct.device, domain_name, event_name, attr_value, attr_config, dev_err_list);
                    callback.push_event(event_data);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int subscribe_event(DeviceProxy device, String attribute, int event, CallBack callback, String[] filters) throws DevFailed {
        String callback_key;
        String event_name;
        if (device == null || callback == null) {
            Except.throw_wrong_syntax_exception("API_InvalidArgs", "Device or callback pointer NULL !!", "EventConsumer.subscribe_event()");
        }
        switch (event) {
            case 0: {
                event_name = "change";
                break;
            }
            case 1: {
                event_name = "quality_change";
                break;
            }
            case 2: {
                event_name = "periodic";
                break;
            }
            case 3: {
                event_name = "archive";
                break;
            }
            case 4: {
                event_name = "user_event";
                break;
            }
            case 5: {
                event_name = "attr_conf";
                break;
            }
            default: {
                event_name = "unknown";
            }
        }
        if (device == null || device.name() == null) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to connect to device", "EventConsumer.subscribe_event()");
        }
        if (this.event_callback_map.containsKey(callback_key = device.name().toLowerCase() + "/" + attribute + "." + event_name)) {
            Except.throw_event_system_failed("API_MethodArgument", "Already connected to event " + callback_key, "EventConsumer.subscribe_event()");
        }
        String device_name = device.name();
        DeviceData subscriber_in = new DeviceData();
        String[] subscriber_info = new String[]{device_name, attribute.toLowerCase(), "subscribe", event_name};
        subscriber_in.insert(subscriber_info);
        device.get_adm_dev().command_inout("EventSubscriptionChange", subscriber_in);
        if (!this.device_channel_map.containsKey(device_name)) {
            this.connect(device);
            if (!this.device_channel_map.containsKey(device_name)) {
                Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to connect to event channel for device", "EventConsumer.subscribe_event()");
            }
        }
        String channel_name = (String)this.device_channel_map.get(device_name);
        EventChannelStruct event_channel_struct = (EventChannelStruct)this.channel_map.get(channel_name);
        String constraint_expr = "$domain_name == '" + device_name.toLowerCase() + "/" + attribute.toLowerCase() + "'" + " and $event_name == '" + event_name + "'";
        if (filters != null && filters.length != 0) {
            constraint_expr = constraint_expr + " and ((";
            for (int i = 0; i < filters.length; ++i) {
                constraint_expr = constraint_expr + filters[i];
            }
            constraint_expr = constraint_expr + " ) and $forced_event > 0.5 )";
        }
        event_channel_struct.last_subscribed = System.currentTimeMillis();
        int filter_id = this.add_filter_for_channel(event_channel_struct, constraint_expr);
        EventCallBackStruct new_event_callback_struct = new EventCallBackStruct(device, attribute, event_name, channel_name, callback, ++subscribe_event_id, event, constraint_expr, filter_id, true);
        this.event_callback_map.put(callback_key, new_event_callback_struct);
        if (event == 0 || event == 2 || event == 1 || event == 3 || event == 4 || event == 5) {
            new PushAttrValueLater(new_event_callback_struct).start();
        }
        return subscribe_event_id;
    }

    public void unsubscribe_event(int event_id) throws DevFailed {
        Enumeration keys = this.event_callback_map.keys();
        boolean found = false;
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            EventCallBackStruct callback_struct = (EventCallBackStruct)this.event_callback_map.get(name);
            if (callback_struct.id != event_id) continue;
            try {
                EventChannelStruct ec_struct = (EventChannelStruct)this.channel_map.get(callback_struct.channel_name);
                Filter filter = ec_struct.structuredProxyPushSupplier.get_filter(callback_struct.filter_id);
                ec_struct.structuredProxyPushSupplier.remove_filter(callback_struct.filter_id);
                filter.destroy();
            }
            catch (FilterNotFound e) {
                Except.throw_event_system_failed("API_EventNotFound", "Failed to unsubscribe event, caught exception while calling remove_filter() (hint: check notification daemon is running)", "EventConsumer.unsubscribe_event()");
            }
            this.event_callback_map.remove(name);
            found = true;
            break;
        }
        if (!found) {
            Except.throw_event_system_failed("API_EventNotFound", "Failed to unsubscribe event, the event id (" + event_id + ") specified does not correspond with any known one", "EventConsumer.unsubscribe_event()");
        }
    }

    public void unsubscribe_device(DeviceProxy device) {
    }

    public void connect(DeviceProxy device_proxy) throws DevFailed {
        String device_name = device_proxy.name();
        String adm_name = null;
        try {
            adm_name = device_proxy.adm_name();
        }
        catch (DevFailed e) {
            Except.throw_event_system_failed("API_BadConfigurationProperty", "Can't subscribe to event for device " + device_name + "\n Check that device server is running...", "EventConsumer.connect");
        }
        String channel_name = adm_name;
        Database dbase = null;
        if (!this.channel_map.containsKey(channel_name)) {
            if (device_proxy.use_db()) {
                dbase = device_proxy.get_db_obj();
            }
            this.connect_event_channel(channel_name, dbase, false);
        }
        EventChannelStruct eventChannelStruct = (EventChannelStruct)this.channel_map.get(channel_name);
        eventChannelStruct.adm_device_proxy = device_proxy.get_adm_dev();
        eventChannelStruct.use_db = device_proxy.use_db();
        eventChannelStruct.dbase = dbase;
        this.device_channel_map.put(device_name, channel_name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block6: {
            try {
                if (!ApiUtil.in_server()) {
                    this.keepAliveTimer.schedule((TimerTask)new KeepAliveThread(), 2000L, 10000L);
                    EventConsumer eventConsumer = this;
                    synchronized (eventConsumer) {
                        Object obj = this.orb.resolve_initial_references("RootPOA");
                        POA poa = POAHelper.narrow(obj);
                        POAManager pman = poa.the_POAManager();
                        pman.activate();
                    }
                    this.orbRunning = true;
                    this.orb.run();
                    this.orb.destroy();
                    break block6;
                }
                this.keepAliveTimer.schedule((TimerTask)new KeepAliveThread(), 2000L, 10000L);
            }
            catch (UserException ex) {
                System.out.println("EventConsumer.run() : Unable to start orb");
                ex.printStackTrace();
                System.exit(1);
            }
        }
    }

    private EventConsumer() throws DevFailed {
        instance = this;
        this.channel_map = new Hashtable();
        this.device_channel_map = new Hashtable();
        this.device_channel_map.clear();
        this.event_callback_map = new Hashtable();
        this.keepAliveTimer = new Timer();
        this.runner = new Thread(this);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                EventConsumer.this.keepAliveTimer.cancel();
                EventConsumer.this.cleanup_heartbeat_filters();
                EventConsumer.this.cleanup_event_filters();
                if (EventConsumer.this.orbRunning) {
                    EventConsumer.this.orb.shutdown(true);
                    try {
                        EventConsumer.this.runner.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.runner.start();
    }

    private void cleanup_heartbeat_filters() {
        Enumeration channel_names = this.channel_map.keys();
        while (channel_names.hasMoreElements()) {
            String name = (String)channel_names.nextElement();
            EventChannelStruct event_channel_struct = (EventChannelStruct)this.channel_map.get(name);
            try {
                int filter_id = event_channel_struct.heartbeat_filter_id;
                Filter filter = event_channel_struct.structuredProxyPushSupplier.get_filter(filter_id);
                event_channel_struct.structuredProxyPushSupplier.remove_filter(filter_id);
                filter.destroy();
            }
            catch (FilterNotFound e) {}
        }
    }

    private void cleanup_event_filters() {
        Enumeration keys = this.event_callback_map.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            EventCallBackStruct callback_struct = (EventCallBackStruct)this.event_callback_map.get(name);
            try {
                EventChannelStruct ec_struct = (EventChannelStruct)this.channel_map.get(callback_struct.channel_name);
                Filter filter = ec_struct.structuredProxyPushSupplier.get_filter(callback_struct.filter_id);
                ec_struct.structuredProxyPushSupplier.remove_filter(callback_struct.filter_id);
                filter.destroy();
            }
            catch (FilterNotFound e) {
                // empty catch block
            }
            this.event_callback_map.remove(name);
        }
    }

    private synchronized void connect_event_channel(String channel_name, Database dbase, boolean reconnect) throws DevFailed {
        DbEventImportInfo received = null;
        DeviceProxy adm_dev = null;
        try {
            if (dbase != null) {
                received = dbase.import_event(channel_name);
            } else {
                received = new DbEventImportInfo();
                adm_dev = new DeviceProxy(channel_name);
                DeviceData data = adm_dev.command_inout("QueryEventChannelIOR");
                received.channel_ior = data.extractString();
                received.channel_exported = true;
                IORdump id = new IORdump(null, received.channel_ior);
                received.host = id.get_hostname();
            }
        }
        catch (DevFailed df) {
            if (dbase != null) {
                Except.throw_event_system_failed("API_NotificationServiceFailed", channel_name + " has no event channel defined in the database\n" + " May be the server is not running or is not linked with Tango release 4.x (or above)", "EventConsumer.connect_event_channel");
            }
            Except.throw_event_system_failed("API_NotificationServiceFailed", channel_name + " did not returned event channel IOR\n" + " May be the server is not running or is not linked with Tango release 4.x (or above)", "EventConsumer.connect_event_channel");
        }
        String channel_ior = received.channel_ior;
        boolean channel_exported = received.channel_exported;
        int idx = received.host.indexOf(46);
        if (idx > 0) {
            received.host = received.host.substring(0, idx);
        }
        if (channel_exported) {
            Object event_channel_obj = this.orb.string_to_object(channel_ior);
            try {
                this.eventChannel = EventChannelHelper.narrow(event_channel_obj);
            }
            catch (RuntimeException e) {
                Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to connect notification daemon (hint : make sur the notifd daemon is running on this host", "EventConsumer.connect_event_channel");
            }
            if (this.eventChannel == null) {
                channel_exported = false;
            }
        }
        if (!channel_exported) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to narrow EventChannel from notification daemon (hint : make sur the notifd daemon is running on this host", "EventConsumer.connect_event_channel");
        }
        try {
            this.consumerAdmin = this.eventChannel.default_consumer_admin();
        }
        catch (Exception e) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Received " + e.toString() + "\nduring eventChannel.default_consumer_admin() call", "EventConsumer.connect_event_channel");
        }
        if (this.consumerAdmin == null) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to get default consumer admin from notification daemon (hint : make sur the notifd daemon is running on this host", "EventConsumer.connect_event_channel");
        }
        IntHolder pId = new IntHolder();
        try {
            this.proxySupplier = this.consumerAdmin.obtain_notification_push_supplier(ClientType.STRUCTURED_EVENT, pId);
            if (this.proxySupplier == null) {
                Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to get a push supplier from notification daemon (hint : make sur the notifd daemon is running on this host", "EventConsumer.connect_event_channel");
            }
        }
        catch (TIMEOUT ex) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to get a push supplier due to a Timeout", "EventConsumer.connect_event_channel");
        }
        catch (AdminLimitExceeded ex) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to get a push supplier due to AdminLimitExceeded (hint : make sur the notifd daemon is running on this host", "EventConsumer.connect_event_channel");
        }
        this.structuredProxyPushSupplier = StructuredProxyPushSupplierHelper.narrow(this.proxySupplier);
        if (this.structuredProxyPushSupplier == null) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to narrow the push supplier due to AdminLimitExceeded (hint : make sur the notifd daemon is running on this host", "EventConsumer.connect_event_channel");
        }
        try {
            this.structuredProxyPushSupplier.connect_structured_push_consumer(this._this(this.orb));
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            Except.throw_event_system_failed("API_NotificationServiceFailed", e + " detected when subscribing to " + channel_name, "EventConsumer.connect_event_channel");
        }
        catch (AlreadyConnected ex) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to connect the push supplier due to CosEventChannelAdmin.AlreadyConnected.AlreadyConnected  exception", "EventConsumer.connect_event_channel");
        }
        catch (TypeError ex) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to connect the push supplier due to CosEventChannelAdmin.AlreadyConnected.TypeError  exception", "EventConsumer.connect_event_channel");
        }
        if (reconnect) {
            EventChannelStruct eventChannelStruct = (EventChannelStruct)this.channel_map.get(channel_name);
            eventChannelStruct.eventChannel = this.eventChannel;
            eventChannelStruct.structuredProxyPushSupplier = this.structuredProxyPushSupplier;
            eventChannelStruct.last_heartbeat = System.currentTimeMillis();
            eventChannelStruct.heartbeat_skipped = false;
            eventChannelStruct.host = received.host;
            try {
                int filter_id = eventChannelStruct.heartbeat_filter_id;
                Filter filter = eventChannelStruct.structuredProxyPushSupplier.get_filter(filter_id);
                eventChannelStruct.structuredProxyPushSupplier.remove_filter(filter_id);
                filter.destroy();
            }
            catch (FilterNotFound e) {
                // empty catch block
            }
            String constraint_expr = "$event_name == 'heartbeat'";
            eventChannelStruct.heartbeat_filter_id = this.add_filter_for_channel(eventChannelStruct, constraint_expr);
        } else {
            EventChannelStruct new_event_channel_struct = new EventChannelStruct();
            new_event_channel_struct.eventChannel = this.eventChannel;
            new_event_channel_struct.structuredProxyPushSupplier = this.structuredProxyPushSupplier;
            new_event_channel_struct.last_heartbeat = System.currentTimeMillis();
            new_event_channel_struct.heartbeat_skipped = false;
            new_event_channel_struct.adm_device_proxy = adm_dev;
            new_event_channel_struct.host = received.host;
            String constraint_expr = "$event_name == 'heartbeat'";
            new_event_channel_struct.heartbeat_filter_id = this.add_filter_for_channel(new_event_channel_struct, constraint_expr);
            this.channel_map.put(channel_name, new_event_channel_struct);
        }
    }

    private int add_filter_for_channel(EventChannelStruct event_channel_struct, String constraint_expr) throws DevFailed {
        Filter filter = null;
        int filter_id = -1;
        try {
            FilterFactory ffp = event_channel_struct.eventChannel.default_filter_factory();
            filter = ffp.create_filter("EXTENDED_TCL");
        }
        catch (InvalidGrammar ex) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Caught Invalid Grammar exception while creating heartbeat filter : check filter", "EventConsumer.add_filter_for_channel");
        }
        ConstraintExp[] exp = new ConstraintExp[]{new ConstraintExp()};
        exp[0].event_types = new EventType[0];
        exp[0].constraint_expr = constraint_expr;
        try {
            filter.add_constraints(exp);
            filter_id = event_channel_struct.structuredProxyPushSupplier.add_filter(filter);
        }
        catch (InvalidConstraint ex) {
            filter.destroy();
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Caught InvalidConstraint exception while adding constraint for heartbeat : check filter", "EventConsumer.add_filter_for_channel");
        }
        return filter_id;
    }

    class PushAttrValueLater
    extends Thread {
        private DeviceProxy device;
        private String attribute;
        private String event_name;
        private int event_type;
        private CallBack callback;

        PushAttrValueLater(EventCallBackStruct cb_struct) {
            this.device = cb_struct.device;
            this.attribute = cb_struct.attr_name;
            this.event_name = cb_struct.event_name;
            this.event_type = cb_struct.event_type;
            this.callback = cb_struct.callback;
        }

        public void run() {
            try {
                PushAttrValueLater.sleep(10L);
            }
            catch (Exception e) {
                // empty catch block
            }
            DeviceAttribute da = null;
            AttributeInfoEx info = null;
            DevError[] err = null;
            String domain_name = this.device.name() + "/" + this.attribute.toLowerCase();
            try {
                if (this.event_type == 5) {
                    info = this.device.get_attribute_info_ex(this.attribute);
                } else {
                    da = this.device.read_attribute(this.attribute);
                }
            }
            catch (DevFailed e) {
                err = e.errors;
            }
            EventData event_data = new EventData(this.device, domain_name, this.event_name, da, info, err);
            this.callback.push_event(event_data);
        }
    }

    private class KeepAliveThread
    extends TimerTask {
        public void run() {
            long MAX_TARDINESS = 15000L;
            if (System.currentTimeMillis() - this.scheduledExecutionTime() >= MAX_TARDINESS) {
                return;
            }
            this.resubscribe_if_needed();
        }

        private void resubscribe_if_needed() {
            Enumeration channel_names = EventConsumer.this.channel_map.keys();
            long now = System.currentTimeMillis();
            while (channel_names.hasMoreElements()) {
                boolean heartbeat_skipped;
                String name = (String)channel_names.nextElement();
                EventChannelStruct event_channel_struct = (EventChannelStruct)EventConsumer.this.channel_map.get(name);
                if (now - event_channel_struct.last_subscribed > 200000L) {
                    this.reSubscribeByName(event_channel_struct, name);
                }
                boolean bl = heartbeat_skipped = now - event_channel_struct.last_heartbeat > 10000L;
                if (!heartbeat_skipped && !event_channel_struct.heartbeat_skipped && !event_channel_struct.notifd_failed) continue;
                event_channel_struct.heartbeat_skipped = true;
                try {
                    event_channel_struct.eventChannel.MyFactory();
                    if (this.checkIfHostHasChanged(event_channel_struct)) {
                        event_channel_struct.notifd_failed = true;
                    }
                }
                catch (RuntimeException e1) {
                    event_channel_struct.notifd_failed = true;
                }
                if (!event_channel_struct.use_db) {
                    event_channel_struct.notifd_failed = true;
                }
                if (event_channel_struct.notifd_failed) {
                    boolean bl2 = event_channel_struct.notifd_failed = !this.reconnect_to_channel(name);
                    if (!event_channel_struct.notifd_failed) {
                        this.reconnect_to_event(name);
                    }
                }
                Enumeration callback_structs = EventConsumer.this.event_callback_map.elements();
                while (callback_structs.hasMoreElements()) {
                    EventCallBackStruct callback_struct = (EventCallBackStruct)callback_structs.nextElement();
                    if (!callback_struct.channel_name.equals(name) || callback_struct.callback == null) continue;
                    this.pushServerNotRespondingException(event_channel_struct, callback_struct);
                    if (event_channel_struct.notifd_failed || !this.reSubscribe(event_channel_struct, callback_struct)) continue;
                    this.readAttributeAndPush(event_channel_struct, callback_struct);
                }
            }
        }

        private boolean reSubscribe(EventChannelStruct event_channel_struct, EventCallBackStruct callback_struct) {
            boolean retVal = true;
            try {
                DeviceData subscriber_in = new DeviceData();
                String[] subscriber_info = new String[]{callback_struct.device.name(), callback_struct.attr_name, "subscribe", callback_struct.event_name};
                subscriber_in.insert(subscriber_info);
                event_channel_struct.adm_device_proxy.command_inout("EventSubscriptionChange", subscriber_in);
                event_channel_struct.heartbeat_skipped = false;
                callback_struct.last_subscribed = event_channel_struct.last_subscribed = System.currentTimeMillis();
            }
            catch (Exception e) {
                retVal = false;
            }
            return retVal;
        }

        private void reSubscribeByName(EventChannelStruct event_channel_struct, String name) {
            Enumeration callback_structs = EventConsumer.this.event_callback_map.elements();
            while (callback_structs.hasMoreElements()) {
                EventCallBackStruct callback_struct = (EventCallBackStruct)callback_structs.nextElement();
                if (!callback_struct.channel_name.equals(name)) continue;
                this.reSubscribe(event_channel_struct, callback_struct);
            }
        }

        private void readAttributeAndPush(EventChannelStruct event_channel_struct, EventCallBackStruct callback_struct) {
            if (callback_struct.event_name.equals("change") || callback_struct.event_name.equals("quality") || callback_struct.event_name.equals("archive") || callback_struct.event_name.equals("user_event") || callback_struct.event_name.equals("attr_conf")) {
                DeviceAttribute da = null;
                AttributeInfoEx info = null;
                DevError[] err = null;
                String domain_name = callback_struct.device.name() + "/" + callback_struct.attr_name;
                boolean old_transp = callback_struct.device.get_transparency_reconnection();
                callback_struct.device.set_transparency_reconnection(true);
                try {
                    if (callback_struct.event_name.equals("attr_conf")) {
                        info = callback_struct.device.get_attribute_info_ex(callback_struct.attr_name);
                    } else {
                        da = callback_struct.device.read_attribute(callback_struct.attr_name);
                    }
                }
                catch (DevFailed e) {
                    err = e.errors;
                }
                callback_struct.device.set_transparency_reconnection(old_transp);
                EventData event_data = new EventData(callback_struct.device, domain_name, callback_struct.event_name, da, info, err);
                callback_struct.callback.push_event(event_data);
            }
        }

        private void pushServerNotRespondingException(EventChannelStruct event_channel_struct, EventCallBackStruct callback_struct) {
            try {
                if (!callback_struct.filter_ok) {
                    callback_struct.filter_id = EventConsumer.this.add_filter_for_channel(event_channel_struct, callback_struct.filter_constraint);
                    callback_struct.filter_ok = true;
                }
                DevError[] errors = new DevError[]{new DevError()};
                errors[0].severity = ErrSeverity.ERR;
                errors[0].origin = "EventConsumer.KeepAliveThread";
                errors[0].reason = "API_EventTimeout";
                errors[0].desc = "Event channel is not responding any more, maybe the server or event system is down";
                EventData event_data = new EventData(event_channel_struct.adm_device_proxy, "domain_name", "event_name", null, null, errors);
                CallBack callback = callback_struct.callback;
                event_data.device = callback_struct.device;
                event_data.name = callback_struct.device.name();
                event_data.event = callback_struct.event_name;
                callback.push_event(event_data);
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }

        private boolean checkIfHostHasChanged(EventChannelStruct event_channel_struct) {
            boolean retVal = false;
            try {
                IORdump dump = new IORdump(event_channel_struct.adm_device_proxy);
                String server_host = dump.get_hostname();
                int idx = server_host.indexOf(46);
                if (idx > 0) {
                    server_host = server_host.substring(0, idx);
                }
                if (!event_channel_struct.host.equals(server_host)) {
                    retVal = true;
                }
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
            return retVal;
        }

        private void reconnect_to_event(String name) {
            Enumeration callback_structs = EventConsumer.this.event_callback_map.elements();
            while (callback_structs.hasMoreElements()) {
                EventCallBackStruct callback_struct = (EventCallBackStruct)callback_structs.nextElement();
                if (!callback_struct.channel_name.equals(name) || callback_struct.callback == null) continue;
                try {
                    EventChannelStruct event_channel_struct = (EventChannelStruct)EventConsumer.this.channel_map.get(name);
                    callback_struct.filter_id = EventConsumer.this.add_filter_for_channel(event_channel_struct, callback_struct.filter_constraint);
                    callback_struct.filter_ok = true;
                }
                catch (DevFailed e1) {
                    callback_struct.filter_ok = false;
                }
            }
        }

        private boolean reconnect_to_channel(String name) {
            boolean ret = true;
            Enumeration callback_structs = EventConsumer.this.event_callback_map.elements();
            while (callback_structs.hasMoreElements()) {
                EventCallBackStruct callback_struct = (EventCallBackStruct)callback_structs.nextElement();
                if (!callback_struct.channel_name.equals(name) || callback_struct.callback == null) continue;
                try {
                    EventChannelStruct event_channel_struct = (EventChannelStruct)EventConsumer.this.channel_map.get(name);
                    EventConsumer.this.connect_event_channel(name, event_channel_struct.dbase, true);
                    event_channel_struct.adm_device_proxy.ping();
                    ret = true;
                }
                catch (DevFailed e1) {
                    Except.print_exception(e1);
                    ret = false;
                }
                break;
            }
            return ret;
        }
    }
}

