/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import java.io.Serializable;

public class DbHistory
implements Serializable {
    private String propName;
    private String attName;
    private String value;
    private String date;
    private boolean deleted;

    DbHistory(String propName, String date, String[] value) {
        this.propName = propName;
        this.date = this.formatMySQLDate(date);
        this.value = this.formatValue(value);
        this.deleted = value.length == 0;
    }

    DbHistory(String attName, String propName, String date, String[] value) {
        this(propName, date, value);
        this.attName = attName;
    }

    public String getName() {
        return this.propName;
    }

    public String getAttributeName() {
        return this.attName;
    }

    public String getValue() {
        return this.value;
    }

    public String getDate() {
        return this.date;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    private String formatValue(String[] value) {
        String ret = "";
        for (int i = 0; i < value.length; ++i) {
            ret = ret + value[i];
            if (i >= value.length - 1) continue;
            ret = ret + "\n";
        }
        return ret;
    }

    private String formatMySQLDate(String date) {
        if (date.indexOf("-") != -1) {
            return date.substring(8, 10) + "/" + date.substring(5, 7) + "/" + date.substring(0, 4) + " " + date.substring(11, 13) + ":" + date.substring(14, 16) + ":" + date.substring(17, 19);
        }
        return date.substring(6, 8) + "/" + date.substring(4, 6) + "/" + date.substring(0, 4) + " " + date.substring(8, 10) + ":" + date.substring(10, 12) + ":" + date.substring(12, 14);
    }
}

