/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Locale;
import java.util.Vector;

public class ImageProperties
implements PlugInFilter,
TextListener {
    ImagePlus imp;
    static final int NANOMETER = 0;
    static final int MICROMETER = 1;
    static final int MILLIMETER = 2;
    static final int CENTIMETER = 3;
    static final int METER = 4;
    static final int KILOMETER = 5;
    static final int INCH = 6;
    static final int FOOT = 7;
    static final int MILE = 8;
    static final int PIXEL = 9;
    static final int OTHER_UNIT = 10;
    int oldUnitIndex;
    double oldUnitsPerCm;
    Vector nfields;
    Vector sfields;
    boolean duplicatePixelWidth = true;
    String calUnit;
    double calPixelWidth;
    double calPixelHeight;
    double calPixelDepth;
    TextField pixelWidthField;
    TextField pixelHeightField;
    TextField pixelDepthField;
    int textChangedCount;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 159;
    }

    public void run(ImageProcessor ip) {
        this.showDialog(this.imp);
    }

    void showDialog(ImagePlus imp) {
        String timeUnit;
        int i;
        String options = Macro.getOptions();
        if (options != null && IJ.isJava14()) {
            String options2 = options.replaceAll(" depth=", " slices=");
            options2 = options2.replaceAll(" interval=", " frame=");
            Macro.setOptions(options2);
        }
        Calibration cal = imp.getCalibration();
        Calibration calOrig = cal.copy();
        this.oldUnitIndex = this.getUnitIndex(cal.getUnit());
        this.oldUnitsPerCm = this.getUnitsPerCm(this.oldUnitIndex);
        int stackSize = imp.getImageStackSize();
        int channels = imp.getNChannels();
        int slices = imp.getNSlices();
        int frames = imp.getNFrames();
        boolean global1 = imp.getGlobalCalibration() != null;
        int digits = cal.pixelWidth < 1.0 || cal.pixelHeight < 1.0 || cal.pixelDepth < 1.0 ? 7 : 4;
        GenericDialog gd = new GenericDialog(imp.getTitle());
        gd.addNumericField("Width:", imp.getWidth(), 0);
        gd.addNumericField("Height:", imp.getHeight(), 0);
        gd.addNumericField("Channels:", channels, 0);
        gd.addNumericField("Slices (z):", slices, 0);
        gd.addNumericField("Frames (t):", frames, 0);
        gd.setInsets(10, 0, 5);
        gd.addStringField("Unit of Length:", cal.getUnit());
        gd.addNumericField("Pixel_Width:", cal.pixelWidth, digits, 8, null);
        gd.addNumericField("Pixel_Height:", cal.pixelHeight, digits, 8, null);
        gd.addNumericField("Voxel_Depth:", cal.pixelDepth, digits, 8, null);
        gd.setInsets(10, 0, 5);
        double interval = cal.frameInterval;
        String intervalStr = IJ.d2s(interval, (double)((int)interval) == interval ? 0 : 2) + " " + cal.getTimeUnit();
        gd.addStringField("Frame Interval:", intervalStr);
        String xo = cal.xOrigin == (double)((int)cal.xOrigin) ? IJ.d2s(cal.xOrigin, 0) : IJ.d2s(cal.xOrigin, 2);
        String yo = cal.yOrigin == (double)((int)cal.yOrigin) ? IJ.d2s(cal.yOrigin, 0) : IJ.d2s(cal.yOrigin, 2);
        String zo = "";
        if (cal.zOrigin != 0.0) {
            zo = cal.zOrigin == (double)((int)cal.zOrigin) ? IJ.d2s(cal.zOrigin, 0) : IJ.d2s(cal.zOrigin, 2);
            zo = "," + zo;
        }
        gd.addStringField("Origin (pixels):", xo + "," + yo + zo);
        gd.setInsets(5, 20, 0);
        gd.addCheckbox("Global", global1);
        this.nfields = gd.getNumericFields();
        this.pixelWidthField = (TextField)this.nfields.elementAt(5);
        this.pixelHeightField = (TextField)this.nfields.elementAt(6);
        this.pixelDepthField = (TextField)this.nfields.elementAt(7);
        for (i = 0; i < this.nfields.size(); ++i) {
            ((TextField)this.nfields.elementAt(i)).addTextListener(this);
        }
        this.sfields = gd.getStringFields();
        for (i = 0; i < this.sfields.size(); ++i) {
            ((TextField)this.sfields.elementAt(i)).addTextListener(this);
        }
        this.calUnit = cal.getUnit();
        this.calPixelWidth = cal.pixelWidth;
        this.calPixelHeight = cal.pixelHeight;
        this.calPixelDepth = cal.pixelDepth;
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        double width = gd.getNextNumber();
        double height = gd.getNextNumber();
        channels = (int)gd.getNextNumber();
        if (channels < 1) {
            channels = 1;
        }
        if ((slices = (int)gd.getNextNumber()) < 1) {
            slices = 1;
        }
        if ((frames = (int)gd.getNextNumber()) < 1) {
            frames = 1;
        }
        if (width != (double)imp.getWidth() || height != (double)imp.getHeight()) {
            IJ.error("Properties", "Use Image>Adjust>Size to change the image size.");
            return;
        }
        if (channels * slices * frames == stackSize) {
            imp.setDimensions(channels, slices, frames);
        } else {
            IJ.error("Properties", "The product of channels (" + channels + "), slices (" + slices + ")\n and frames (" + frames + ") must equal the stack size (" + stackSize + ").");
        }
        String unit = gd.getNextString();
        if (unit.equals("um")) {
            unit = "\u00b5m";
        } else if (unit.equals("u")) {
            unit = "\u00b5";
        } else if (unit.equals("A")) {
            unit = "\u00c5";
        }
        double pixelWidth = gd.getNextNumber();
        double pixelHeight = gd.getNextNumber();
        double pixelDepth = gd.getNextNumber();
        if (unit.equals("") || unit.equalsIgnoreCase("none") || pixelWidth == 0.0) {
            cal.setUnit(null);
            cal.pixelWidth = 1.0;
            cal.pixelHeight = 1.0;
            cal.pixelDepth = 1.0;
        } else {
            cal.setUnit(unit);
            cal.pixelWidth = pixelWidth;
            cal.pixelHeight = pixelHeight;
            cal.pixelDepth = pixelDepth;
        }
        String frameInterval = this.validateInterval(gd.getNextString());
        String[] intAndUnit = Tools.split(frameInterval, " -");
        interval = Tools.parseDouble(intAndUnit[0]);
        cal.frameInterval = Double.isNaN(interval) ? 0.0 : interval;
        String string = timeUnit = intAndUnit.length >= 2 ? intAndUnit[1] : "sec";
        if (timeUnit.equals("usec")) {
            timeUnit = "\u00b5sec";
        }
        cal.setTimeUnit(timeUnit);
        String[] origin = Tools.split(gd.getNextString(), " ,");
        double x = Tools.parseDouble(origin[0]);
        double y = origin.length >= 2 ? Tools.parseDouble(origin[1]) : Double.NaN;
        double z = origin.length >= 3 ? Tools.parseDouble(origin[2]) : Double.NaN;
        cal.xOrigin = Double.isNaN(x) ? 0.0 : x;
        cal.yOrigin = Double.isNaN(y) ? cal.xOrigin : y;
        cal.zOrigin = Double.isNaN(z) ? 0.0 : z;
        boolean global2 = gd.getNextBoolean();
        if (!cal.equals(calOrig)) {
            imp.setCalibration(cal);
        }
        imp.setGlobalCalibration(global2 ? cal : null);
        if (global2 || global2 != global1) {
            WindowManager.repaintImageWindows();
        } else {
            imp.repaintWindow();
        }
    }

    String validateInterval(String interval) {
        if (interval.indexOf(" ") != -1) {
            return interval;
        }
        int firstLetter = -1;
        for (int i = 0; i < interval.length(); ++i) {
            char c2 = interval.charAt(i);
            if (!Character.isLetter(c2)) continue;
            firstLetter = i;
            break;
        }
        if (firstLetter > 0 && firstLetter < interval.length() - 1) {
            interval = interval.substring(0, firstLetter) + " " + interval.substring(firstLetter, interval.length());
        }
        return interval;
    }

    double getNewScale(String newUnit, double oldScale) {
        if (this.oldUnitsPerCm == 0.0) {
            return 0.0;
        }
        double newScale = 0.0;
        int newUnitIndex = this.getUnitIndex(newUnit);
        if (newUnitIndex != this.oldUnitIndex) {
            double newUnitsPerCm = this.getUnitsPerCm(newUnitIndex);
            if (this.oldUnitsPerCm != 0.0 && newUnitsPerCm != 0.0) {
                newScale = oldScale * (this.oldUnitsPerCm / newUnitsPerCm);
            }
        }
        return newScale;
    }

    int getUnitIndex(String unit) {
        if ((unit = unit.toLowerCase(Locale.US)).equals("cm") || unit.startsWith("cent")) {
            return 3;
        }
        if (unit.equals("mm") || unit.startsWith("milli")) {
            return 2;
        }
        if (unit.startsWith("inch")) {
            return 6;
        }
        if (unit.startsWith("\u00b5") || unit.startsWith("u") || unit.startsWith("micro")) {
            return 1;
        }
        if (unit.equals("nm") || unit.startsWith("nano")) {
            return 0;
        }
        if (unit.startsWith("meter")) {
            return 4;
        }
        if (unit.equals("km") || unit.startsWith("kilo")) {
            return 5;
        }
        if (unit.equals("ft") || unit.equals("foot") || unit.equals("feet")) {
            return 7;
        }
        if (unit.equals("mi") || unit.startsWith("mile")) {
            return 2;
        }
        return 10;
    }

    double getUnitsPerCm(int unitIndex) {
        switch (unitIndex) {
            case 0: {
                return 1.0E7;
            }
            case 1: {
                return 10000.0;
            }
            case 2: {
                return 10.0;
            }
            case 3: {
                return 1.0;
            }
            case 4: {
                return 0.01;
            }
            case 5: {
                return 1.0E-5;
            }
            case 6: {
                return 0.3937;
            }
            case 7: {
                return 0.0328083;
            }
            case 8: {
                return 6.213E-6;
            }
        }
        return 0.0;
    }

    public void textValueChanged(TextEvent e) {
        ++this.textChangedCount;
        Object source = e.getSource();
        TextField widthField = (TextField)this.nfields.elementAt(0);
        int width = (int)Tools.parseDouble(widthField.getText(), -99.0);
        TextField heightField = (TextField)this.nfields.elementAt(1);
        int height = (int)Tools.parseDouble(heightField.getText(), -99.0);
        int channels = (int)Tools.parseDouble(((TextField)this.nfields.elementAt(2)).getText(), -99.0);
        int depth = (int)Tools.parseDouble(((TextField)this.nfields.elementAt(3)).getText(), -99.0);
        int frames = (int)Tools.parseDouble(((TextField)this.nfields.elementAt(4)).getText(), -99.0);
        double newPixelWidth = this.calPixelWidth;
        String newWidthText = this.pixelWidthField.getText();
        if (source == this.pixelWidthField) {
            newPixelWidth = Tools.parseDouble(newWidthText, -99.0);
        }
        double newPixelHeight = this.calPixelHeight;
        if (source == this.pixelHeightField) {
            String newHeightText = this.pixelHeightField.getText();
            newPixelHeight = Tools.parseDouble(newHeightText, -99.0);
            if (!newHeightText.equals(newWidthText)) {
                this.duplicatePixelWidth = false;
            }
        }
        double newPixelDepth = this.calPixelDepth;
        if (source == this.pixelDepthField) {
            String newDepthText = this.pixelDepthField.getText();
            newPixelDepth = Tools.parseDouble(newDepthText, -99.0);
            if (!newDepthText.equals(newWidthText)) {
                this.duplicatePixelWidth = false;
            }
        }
        if (this.textChangedCount == 1 && (this.calPixelHeight != 1.0 || this.calPixelDepth != 1.0)) {
            this.duplicatePixelWidth = false;
        }
        if (source == this.pixelWidthField && newPixelWidth != -99.0 && this.duplicatePixelWidth) {
            this.pixelHeightField.setText(newWidthText);
            this.pixelDepthField.setText(newWidthText);
            this.calPixelHeight = this.calPixelWidth;
            this.calPixelDepth = this.calPixelWidth;
        }
        this.calPixelWidth = newPixelWidth;
        this.calPixelHeight = newPixelHeight;
        this.calPixelDepth = newPixelDepth;
        TextField unitField = (TextField)this.sfields.elementAt(0);
        String newUnit = unitField.getText();
        if (!newUnit.equals(this.calUnit)) {
            double oldXScale = newPixelWidth != 0.0 ? 1.0 / newPixelWidth : 0.0;
            double oldYScale = newPixelHeight != 0.0 ? 1.0 / newPixelHeight : 0.0;
            double oldZScale = newPixelDepth != 0.0 ? 1.0 / newPixelDepth : 0.0;
            double newXScale = this.getNewScale(newUnit, oldXScale);
            double newYScale = this.getNewScale(newUnit, oldYScale);
            double newZScale = this.getNewScale(newUnit, oldZScale);
            if (newXScale != 0.0) {
                double w = 1.0 / newXScale;
                double h = 1.0 / newYScale;
                double d = 1.0 / newZScale;
                int digits = w < 1.0 || h < 1.0 || d < 1.0 ? 7 : 4;
                this.pixelWidthField.setText(IJ.d2s(1.0 / newXScale, digits));
                this.pixelHeightField.setText(IJ.d2s(1.0 / newYScale, digits));
                this.pixelDepthField.setText(IJ.d2s(1.0 / newZScale, digits));
                this.calPixelWidth = 1.0 / newXScale;
                this.calPixelHeight = 1.0 / newYScale;
                this.calPixelDepth = 1.0 / newZScale;
                this.oldUnitIndex = this.getUnitIndex(newUnit);
                this.oldUnitsPerCm = this.getUnitsPerCm(this.oldUnitIndex);
            }
            this.calUnit = newUnit;
        }
    }
}

