/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.PlugIn;
import ij.plugin.filter.Analyzer;
import java.awt.Choice;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

public class Colors
implements PlugIn,
ItemListener {
    private String[] colors = new String[]{"red", "green", "blue", "magenta", "cyan", "yellow", "orange", "black", "white"};
    private Choice fchoice;
    private Choice bchoice;
    private Choice schoice;
    private Color fc2;
    private Color bc2;
    private Color sc2;

    public void run(String arg) {
        if (arg.equals("point")) {
            this.pointToolOptions();
        } else {
            this.showDialog();
        }
    }

    void showDialog() {
        Color fc = Toolbar.getForegroundColor();
        String fname = this.getColorName(fc, "black");
        Color bc = Toolbar.getBackgroundColor();
        String bname = this.getColorName(bc, "white");
        Color sc = Roi.getColor();
        String sname = this.getColorName(sc, "yellow");
        GenericDialog gd = new GenericDialog("Colors");
        gd.addChoice("Foreground:", this.colors, fname);
        gd.addChoice("Background:", this.colors, bname);
        gd.addChoice("Selection:", this.colors, sname);
        Vector choices = gd.getChoices();
        this.fchoice = (Choice)choices.elementAt(0);
        this.bchoice = (Choice)choices.elementAt(1);
        this.schoice = (Choice)choices.elementAt(2);
        this.fchoice.addItemListener(this);
        this.bchoice.addItemListener(this);
        this.schoice.addItemListener(this);
        gd.showDialog();
        if (gd.wasCanceled()) {
            if (this.fc2 != fc) {
                Toolbar.setForegroundColor(fc);
            }
            if (this.bc2 != bc) {
                Toolbar.setBackgroundColor(bc);
            }
            if (this.sc2 != sc) {
                Roi.setColor(sc);
                ImagePlus imp = WindowManager.getCurrentImage();
                if (imp != null && imp.getRoi() != null) {
                    imp.draw();
                }
            }
            return;
        }
        fname = gd.getNextChoice();
        bname = gd.getNextChoice();
        sname = gd.getNextChoice();
        this.fc2 = this.getColor(fname, Color.black);
        this.bc2 = this.getColor(bname, Color.white);
        this.sc2 = this.getColor(sname, Color.yellow);
        if (this.fc2 != fc) {
            Toolbar.setForegroundColor(this.fc2);
        }
        if (this.bc2 != bc) {
            Toolbar.setBackgroundColor(this.bc2);
        }
        if (this.sc2 != sc) {
            Roi.setColor(this.sc2);
            ImagePlus imp = WindowManager.getCurrentImage();
            if (imp != null) {
                imp.draw();
            }
            Toolbar.getInstance().repaint();
        }
    }

    String getColorName(Color c2, String defaultName) {
        String name = defaultName;
        if (c2.equals(Color.red)) {
            name = this.colors[0];
        } else if (c2.equals(Color.green)) {
            name = this.colors[1];
        } else if (c2.equals(Color.blue)) {
            name = this.colors[2];
        } else if (c2.equals(Color.magenta)) {
            name = this.colors[3];
        } else if (c2.equals(Color.cyan)) {
            name = this.colors[4];
        } else if (c2.equals(Color.yellow)) {
            name = this.colors[5];
        } else if (c2.equals(Color.orange)) {
            name = this.colors[6];
        } else if (c2.equals(Color.black)) {
            name = this.colors[7];
        } else if (c2.equals(Color.white)) {
            name = this.colors[8];
        }
        return name;
    }

    Color getColor(String name, Color defaultColor) {
        Color c2 = defaultColor;
        if (name.equals(this.colors[0])) {
            c2 = Color.red;
        } else if (name.equals(this.colors[1])) {
            c2 = Color.green;
        } else if (name.equals(this.colors[2])) {
            c2 = Color.blue;
        } else if (name.equals(this.colors[3])) {
            c2 = Color.magenta;
        } else if (name.equals(this.colors[4])) {
            c2 = Color.cyan;
        } else if (name.equals(this.colors[5])) {
            c2 = Color.yellow;
        } else if (name.equals(this.colors[6])) {
            c2 = Color.orange;
        } else if (name.equals(this.colors[7])) {
            c2 = Color.black;
        } else if (name.equals(this.colors[8])) {
            c2 = Color.white;
        }
        return c2;
    }

    public void itemStateChanged(ItemEvent e) {
        Choice choice = (Choice)e.getSource();
        String item = choice.getSelectedItem();
        Color color = this.getColor(item, Color.black);
        if (choice == this.fchoice) {
            Toolbar.setForegroundColor(color);
        } else if (choice == this.bchoice) {
            Toolbar.setBackgroundColor(color);
        } else if (choice == this.schoice) {
            Roi.setColor(color);
            ImagePlus imp = WindowManager.getCurrentImage();
            if (imp != null && imp.getRoi() != null) {
                imp.draw();
            }
            Toolbar.getInstance().repaint();
        }
    }

    void pointToolOptions() {
        ImagePlus imp;
        boolean saveNoPointLabels = Prefs.noPointLabels;
        Color sc = Roi.getColor();
        String sname = this.getColorName(sc, "yellow");
        GenericDialog gd = new GenericDialog("Point Tool");
        gd.addNumericField("Mark Width:", Analyzer.markWidth, 0, 2, "pixels");
        gd.addCheckbox("Auto-Measure", Prefs.pointAutoMeasure);
        gd.addCheckbox("Auto-Next Slice", Prefs.pointAutoNextSlice);
        gd.addCheckbox("Label Points", !Prefs.noPointLabels);
        gd.addChoice("Selection Color:", this.colors, sname);
        Vector choices = gd.getChoices();
        this.schoice = (Choice)choices.elementAt(0);
        this.schoice.addItemListener(this);
        gd.showDialog();
        if (gd.wasCanceled()) {
            if (this.sc2 != sc) {
                Roi.setColor(sc);
                ImagePlus imp2 = WindowManager.getCurrentImage();
                if (imp2 != null && imp2.getRoi() != null) {
                    imp2.draw();
                }
                Toolbar.getInstance().repaint();
            }
            return;
        }
        int width = (int)gd.getNextNumber();
        if (width < 0) {
            width = 0;
        }
        Analyzer.markWidth = width;
        Prefs.pointAutoMeasure = gd.getNextBoolean();
        Prefs.pointAutoNextSlice = gd.getNextBoolean();
        Prefs.noPointLabels = !gd.getNextBoolean();
        sname = gd.getNextChoice();
        this.sc2 = this.getColor(sname, Color.yellow);
        if (Prefs.pointAutoNextSlice) {
            Prefs.pointAutoMeasure = true;
        }
        if (Prefs.noPointLabels != saveNoPointLabels && (imp = WindowManager.getCurrentImage()) != null) {
            imp.draw();
        }
        if (this.sc2 != sc) {
            Roi.setColor(this.sc2);
            imp = WindowManager.getCurrentImage();
            if (imp != null) {
                imp.draw();
            }
            Toolbar.getInstance().repaint();
        }
    }
}

