/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IEnumScalar;
import fr.esrf.tangoatk.core.IEnumScalarListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.EnumScalarHelper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class EnumScalar
extends AAttribute
implements IEnumScalar {
    EnumScalarHelper enumHelper = null;
    String scalarValue = null;
    String setPointValue = null;
    private String[] enumLabels = null;
    private String[] enmuSetExcludeLabels = null;
    private String[] enumSetLabels = null;

    public EnumScalar(String[] stringArray, String[] stringArray2) {
        this.enumLabels = stringArray;
        this.enmuSetExcludeLabels = stringArray2;
        if (this.enmuSetExcludeLabels != null) {
            this.setEnumSetLabels();
        }
        if (this.enumSetLabels == null) {
            this.enumSetLabels = this.enumLabels;
        }
    }

    private void setEnumSetLabels() {
        int n;
        int n2 = this.enumLabels.length;
        for (n = 0; n < this.enmuSetExcludeLabels.length; ++n) {
            if (!EnumScalar.containsEnumLabel(this.enumLabels, this.enmuSetExcludeLabels[n])) continue;
            --n2;
        }
        if (n2 <= 0) {
            return;
        }
        if (n2 == this.enumLabels.length) {
            return;
        }
        this.enumSetLabels = new String[n2];
        int n3 = 0;
        for (n = 0; n < this.enumLabels.length; ++n) {
            if (EnumScalar.containsEnumLabel(this.enmuSetExcludeLabels, this.enumLabels[n])) continue;
            this.enumSetLabels[n3] = new String(this.enumLabels[n]);
            ++n3;
        }
    }

    public static boolean containsEnumLabel(String[] stringArray, String string) {
        if (string == null) {
            return false;
        }
        if (string.length() < 1) {
            return false;
        }
        if (stringArray == null) {
            return false;
        }
        if (stringArray.length < 1) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static String[] getNonEmptyLabels(String[] stringArray) {
        int n;
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length < 1) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        int n2 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] == null || stringArray[n].length() <= 0) continue;
            stringArray2[n2] = stringArray[n];
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        if (n2 == stringArray.length) {
            return stringArray2;
        }
        String[] stringArray3 = new String[n2];
        for (n = 0; n < stringArray3.length; ++n) {
            stringArray3[n] = stringArray2[n];
        }
        return stringArray3;
    }

    public String getType() {
        return "EnumScalar";
    }

    public void setEnumHelper(EnumScalarHelper enumScalarHelper) {
        this.enumHelper = enumScalarHelper;
    }

    public String getEnumScalarValue() {
        return this.scalarValue;
    }

    public void setEnumScalarValue(String string) {
        try {
            this.enumHelper.insert(string);
            this.writeAtt();
        }
        catch (AttributeSetException attributeSetException) {
            this.setAttError("Couldn't set value", attributeSetException);
        }
        catch (DevFailed devFailed) {
            this.setAttError("Couldn't set value", new AttributeSetException(devFailed));
        }
    }

    public String getEnumScalarSetPoint() {
        return this.setPointValue;
    }

    public String getEnumScalarSetPointFromDevice() {
        String string;
        try {
            string = this.enumHelper.getEnumScalarSetPoint(this.readDeviceValueFromNetwork());
            this.setPointValue = EnumScalar.containsEnumLabel(this.enumSetLabels, string) ? string : null;
        }
        catch (DevFailed devFailed) {
            this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            string = null;
            this.setPointValue = null;
        }
        catch (Exception exception) {
            this.readAttError(exception.getMessage(), exception);
            string = null;
            this.setPointValue = null;
        }
        return string;
    }

    public int getXDimension() {
        return 1;
    }

    public int getMaxXDimension() {
        return 1;
    }

    public void addEnumScalarListener(IEnumScalarListener iEnumScalarListener) {
        this.enumHelper.addEnumScalarListener(iEnumScalarListener);
        this.addStateListener(iEnumScalarListener);
    }

    public void removeEnumScalarListener(IEnumScalarListener iEnumScalarListener) {
        this.enumHelper.removeEnumScalarListener(iEnumScalarListener);
        this.removeStateListener(iEnumScalarListener);
    }

    public void refresh() {
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        if (this.skippingRefresh) {
            return;
        }
        ++this.refreshCount;
        this.trace(4, "EnumScalar.refresh() method called for " + this.getName(), l);
        try {
            try {
                this.attribute = deviceAttribute = this.readValueFromNetwork();
                if (deviceAttribute == null) {
                    return;
                }
                this.scalarValue = this.enumHelper.getEnumScalarValue(deviceAttribute);
                this.setPointValue = this.enumHelper.getEnumScalarSetPoint(deviceAttribute);
                if (!EnumScalar.containsEnumLabel(this.enumSetLabels, this.setPointValue)) {
                    this.setPointValue = null;
                }
                this.enumHelper.fireEnumScalarValueChanged(this.scalarValue, this.timeStamp);
            }
            catch (AttributeReadException attributeReadException) {
                this.scalarValue = null;
                this.setPointValue = null;
                this.readAttError("Invalid enum value read.", attributeReadException);
            }
            catch (DevFailed devFailed) {
                this.scalarValue = null;
                this.setPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
        }
        catch (Exception exception) {
            this.scalarValue = null;
            this.setPointValue = null;
            System.out.println("EnumScalar.refresh() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("EnumScalar.refresh()------------------------------------------------");
        }
    }

    public void dispatch(DeviceAttribute deviceAttribute) {
        if (this.skippingRefresh) {
            return;
        }
        ++this.refreshCount;
        try {
            try {
                if (deviceAttribute == null) {
                    return;
                }
                this.attribute = deviceAttribute;
                this.setState(deviceAttribute);
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.scalarValue = this.enumHelper.getEnumScalarValue(deviceAttribute);
                this.setPointValue = this.enumHelper.getEnumScalarSetPoint(deviceAttribute);
                if (!EnumScalar.containsEnumLabel(this.enumSetLabels, this.setPointValue)) {
                    this.setPointValue = null;
                }
                this.enumHelper.fireEnumScalarValueChanged(this.scalarValue, this.timeStamp);
            }
            catch (AttributeReadException attributeReadException) {
                this.scalarValue = null;
                this.setPointValue = null;
                this.readAttError("Invalid enum value read.", attributeReadException);
            }
            catch (DevFailed devFailed) {
                this.dispatchError(devFailed);
            }
        }
        catch (Exception exception) {
            this.scalarValue = null;
            this.setPointValue = null;
            System.out.println("EnumScalar.dispatch() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("EnumScalar.dispatch()------------------------------------------------");
        }
    }

    public void dispatchError(DevFailed devFailed) {
        this.scalarValue = null;
        this.setPointValue = null;
        this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
    }

    public boolean isWritable() {
        return super.isWritable();
    }

    public String[] getEnumValues() {
        return this.enumLabels;
    }

    public String[] getSetEnumValues() {
        return this.enumSetLabels;
    }

    public void periodic(TangoPeriodicEvent tangoPeriodicEvent) {
        ++this.periodicCount;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(128, "EnumScalar.periodic method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoPeriodicEvent.getValue();
            this.trace(128, "EnumScalar.periodicEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(128, "EnumScalar.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(128, "EnumScalar.periodicEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.scalarValue = null;
                this.setPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(128, "EnumScalar.periodicEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.scalarValue = null;
                this.setPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(128, "EnumScalar.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            this.scalarValue = null;
            this.setPointValue = null;
            System.out.println("EnumScalar.periodic.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("EnumScalar.periodic.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.scalarValue = this.enumHelper.getEnumScalarValue(deviceAttribute);
                this.setPointValue = this.enumHelper.getEnumScalarSetPoint(deviceAttribute);
                if (!EnumScalar.containsEnumLabel(this.enumSetLabels, this.setPointValue)) {
                    this.setPointValue = null;
                }
                this.enumHelper.fireEnumScalarValueChanged(this.scalarValue, this.timeStamp);
            }
            catch (AttributeReadException attributeReadException) {
                this.scalarValue = null;
                this.setPointValue = null;
                this.readAttError("Invalid enum value read.", attributeReadException);
            }
            catch (DevFailed devFailed) {
                this.scalarValue = null;
                this.setPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.scalarValue = null;
                this.setPointValue = null;
                System.out.println("EnumScalar.periodic.extractString() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("EnumScalar.periodic.extractString()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent tangoChangeEvent) {
        ++this.changeCount;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(32, "EnumScalar.change method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoChangeEvent.getValue();
            this.trace(32, "EnumScalar.changeEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(32, "EnumScalar.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "EnumScalar.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.scalarValue = null;
                this.setPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(32, "EnumScalar.changeEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.scalarValue = null;
                this.setPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(32, "EnumScalar.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            this.scalarValue = null;
            this.setPointValue = null;
            System.out.println("EnumScalar.change.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("EnumScalar.change.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.scalarValue = this.enumHelper.getEnumScalarValue(deviceAttribute);
                this.setPointValue = this.enumHelper.getEnumScalarSetPoint(deviceAttribute);
                if (!EnumScalar.containsEnumLabel(this.enumSetLabels, this.setPointValue)) {
                    this.setPointValue = null;
                }
                this.enumHelper.fireEnumScalarValueChanged(this.scalarValue, this.timeStamp);
            }
            catch (AttributeReadException attributeReadException) {
                this.scalarValue = null;
                this.setPointValue = null;
                this.readAttError("Invalid enum value read.", attributeReadException);
            }
            catch (DevFailed devFailed) {
                this.scalarValue = null;
                this.setPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.scalarValue = null;
                this.setPointValue = null;
                System.out.println("EnumScalar.change.extractString() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("EnumScalar.change.extractString()------------------------------------------------");
            }
        }
    }

    private void trace(int n, String string, long l) {
        DeviceFactory.getInstance().trace(n, string, l);
    }

    public String getVersion() {
        return "$Id: EnumScalar.java,v 1.3 2007/02/16 16:09:17 poncet Exp $";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        objectInputStream.defaultReadObject();
        this.serializeInit();
    }
}

