/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoApi.events.EventDispatcher;
import fr.esrf.TangoApi.events.ITangoQualityChangeListener;
import fr.esrf.TangoApi.events.TangoQualityChangeEvent;
import java.io.Serializable;
import javax.swing.SwingUtilities;

public class TangoQualityChange
extends EventDispatcher
implements Serializable {
    String attr_name;
    int event_identifier;
    String[] filters;

    public TangoQualityChange(DeviceProxy device_proxy, String attr_name, String[] filters) {
        super(device_proxy);
        this.attr_name = attr_name;
        this.filters = filters;
        this.event_identifier = -1;
    }

    public void addTangoQualityChangeListener(ITangoQualityChangeListener listener) throws DevFailed {
        this.event_listeners.add(ITangoQualityChangeListener.class, listener);
        this.event_identifier = this.subscribe_quality_change_event(this.attr_name, this.filters);
    }

    public void removeTangoQualityChangeListener(ITangoQualityChangeListener listener) throws DevFailed {
        this.event_listeners.remove(ITangoQualityChangeListener.class, listener);
        if (this.event_listeners.getListenerCount() == 0) {
            this.unsubscribe_event(this.event_identifier);
        }
    }

    public void dispatch_event(final EventData event_data) {
        final TangoQualityChange tg = this;
        Runnable do_work_later = new Runnable(){

            public void run() {
                TangoQualityChangeEvent change_event = new TangoQualityChangeEvent(tg, event_data);
                TangoQualityChange.this.fireTangoQualityChangeEvent(change_event);
            }
        };
        SwingUtilities.invokeLater(do_work_later);
    }

    private void fireTangoQualityChangeEvent(TangoQualityChangeEvent quality_change_event) {
        Object[] listeners = this.event_listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ITangoQualityChangeListener.class) continue;
            ((ITangoQualityChangeListener)listeners[i + 1]).qualityChange(quality_change_event);
        }
    }
}

