/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoApi.events.EventDispatcher;
import fr.esrf.TangoApi.events.ITangoArchiveListener;
import fr.esrf.TangoApi.events.TangoArchiveEvent;
import java.io.Serializable;
import javax.swing.SwingUtilities;

public class TangoArchive
extends EventDispatcher
implements Serializable {
    String attr_name;
    int event_identifier;
    String[] filters;

    public TangoArchive(DeviceProxy device_proxy, String attr_name, String[] filters) {
        super(device_proxy);
        this.attr_name = attr_name;
        this.filters = filters;
        this.event_identifier = -1;
    }

    public void addTangoArchiveListener(ITangoArchiveListener listener) throws DevFailed {
        this.event_identifier = this.subscribe_archive_event(this.attr_name, this.filters);
        this.event_listeners.add(ITangoArchiveListener.class, listener);
    }

    public void removeTangoArchiveListener(ITangoArchiveListener listener) throws DevFailed {
        this.event_listeners.remove(ITangoArchiveListener.class, listener);
        if (this.event_listeners.getListenerCount() == 0) {
            this.unsubscribe_event(this.event_identifier);
        }
    }

    public void dispatch_event(final EventData event_data) {
        final TangoArchive tg = this;
        Runnable do_work_later = new Runnable(){

            public void run() {
                TangoArchiveEvent archive_event = new TangoArchiveEvent(tg, event_data);
                TangoArchive.this.fireTangoArchiveEvent(archive_event);
            }
        };
        SwingUtilities.invokeLater(do_work_later);
    }

    private void fireTangoArchiveEvent(TangoArchiveEvent archive_event) {
        Object[] listeners = this.event_listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ITangoArchiveListener.class) continue;
            ((ITangoArchiveListener)listeners[i + 1]).archive(archive_event);
        }
    }
}

