/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;

class AccessProxy
extends DeviceProxy {
    protected static String user = null;
    protected static String host = null;
    protected boolean forced = false;
    protected Hashtable allowed_cmd_table = null;

    AccessProxy(String devname) throws DevFailed {
        super(devname, false);
        this.ping();
        String forced_str = System.getProperty("SUPER_USER");
        if (forced_str != null) {
            this.forced = forced_str.equals("true");
        }
        this.allowed_cmd_table = new Hashtable();
    }

    int checkAccessControl(String devname) throws DevFailed {
        if (this.forced) {
            return 1;
        }
        try {
            if (user == null) {
                user = System.getProperty("user.name").toLowerCase();
            }
            if (host == null) {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            DeviceData argin = new DeviceData();
            argin.insert(new String[]{user, host, devname});
            String rights = this.command_inout("GetAccess", argin).extractString();
            if (rights.equals("write")) {
                return 1;
            }
            return 0;
        }
        catch (DevFailed e) {
            if (e.errors[0].reason.equals("TangoApi_DEVICE_NOT_EXPORTED")) {
                Except.re_throw_exception(e, "TangoApi_CANNOT_CHECK_ACCESS_CONTROL", "Cannot import Access Control device !", "AccessProxy.checkAccessControl()");
            }
            throw e;
        }
        catch (UnknownHostException e) {
            System.out.println(e);
            return 0;
        }
        return 0;
    }

    boolean isCommandAllowed(String devname, String cmd) {
        String[] allowed = (String[])this.allowed_cmd_table.get(devname);
        if (allowed == null) {
            allowed = this.getAllowedCommands(devname);
        }
        if (allowed.length == 0) {
            return false;
        }
        for (int i = 0; i < allowed.length; ++i) {
            if (!allowed[i].toLowerCase().equals(cmd.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    protected String[] getAllowedCommands(String devname) {
        try {
            DeviceData argin = new DeviceData();
            argin = new DeviceData();
            argin.insert(devname);
            DeviceData argout = this.command_inout("GetAllowedCommands", argin);
            String[] allowed = argout.extractStringArray();
            this.allowed_cmd_table.put(devname, allowed);
            return allowed;
        }
        catch (DevFailed e) {
            String[] dummy = new String[]{};
            this.allowed_cmd_table.put(devname, dummy);
            return dummy;
        }
    }
}

