/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart.math;

import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import org.nfunk.jep.JEP;

public class ExpressionParser {
    protected JLDataView[] dv;
    protected DataList[] dl;
    protected int anno;
    protected int precision = 0;
    protected JEP parser;
    protected String expression;
    protected boolean x = false;

    public ExpressionParser(int n, String string) {
        this.dv = new JLDataView[n];
        this.dl = new DataList[n];
        this.parser = new JEP();
        this.parser.addStandardConstants();
        this.parser.addStandardFunctions();
        this.expression = string;
    }

    public void setPrecision(int n) {
        this.precision = n;
    }

    public void add(int n, JLDataView jLDataView) {
        this.dv[n] = jLDataView;
        this.dl[n] = jLDataView.getData();
    }

    protected double getMinTime() {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.dl.length; ++i) {
            if (this.dl[i] == null || !(this.dl[i].x < d)) continue;
            d = this.dl[i].x;
        }
        return d;
    }

    protected void initialize() {
        if (this.x) {
            this.parser.addVariable("x", Double.NaN);
        } else {
            for (int i = 0; i < this.dv.length; ++i) {
                this.parser.addVariable("x" + (i + 1), Double.NaN);
            }
        }
    }

    protected double[] getNextValues() {
        double d = this.getMinTime();
        if (d == Double.MAX_VALUE) {
            return null;
        }
        double[] dArray = new double[2];
        dArray[0] = d;
        if (this.x) {
            if (this.dl[0] != null && this.dl[0].x >= d - (double)this.precision && this.dl[0].x <= d + (double)this.precision) {
                this.parser.removeVariable("x");
                this.parser.addVariable("x", this.dl[0].y);
                this.dl[0] = this.dl[0].next;
            }
        } else {
            for (int i = 0; i < this.dl.length; ++i) {
                if (this.dl[i] == null || !(this.dl[i].x >= d - (double)this.precision) || !(this.dl[i].x <= d + (double)this.precision)) continue;
                this.parser.removeVariable("x" + (i + 1));
                this.parser.addVariable("x" + (i + 1), this.dl[i].y);
                this.dl[i] = this.dl[i].next;
            }
        }
        this.parser.parseExpression(this.expression);
        dArray[1] = this.parser.getValue();
        return dArray;
    }

    public JLDataView buildDataView(JLDataView jLDataView) {
        this.initialize();
        JLDataView jLDataView2 = jLDataView;
        if (jLDataView == null) {
            jLDataView2 = new JLDataView();
            jLDataView2.setName(this.expression);
        }
        double[] dArray = this.getNextValues();
        while (dArray != null) {
            jLDataView2.add(dArray[0], dArray[1]);
            dArray = this.getNextValues();
        }
        return jLDataView2;
    }

    public void clean() {
        if (this.dv != null) {
            for (int i = 0; i < this.dv.length; ++i) {
                this.dv[i] = null;
                this.dl[i] = null;
            }
            this.dv = null;
            this.dl = null;
        }
        this.parser = null;
        this.expression = null;
    }

    public boolean isX() {
        return this.x;
    }

    public void setX(boolean bl) {
        this.x = bl;
    }
}

