/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart;

import com.braju.format.Format;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.OFormat;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Vector;

public class JLDataView
implements Serializable {
    public static final int MARKER_NONE = 0;
    public static final int MARKER_DOT = 1;
    public static final int MARKER_BOX = 2;
    public static final int MARKER_TRIANGLE = 3;
    public static final int MARKER_DIAMOND = 4;
    public static final int MARKER_STAR = 5;
    public static final int MARKER_VERT_LINE = 6;
    public static final int MARKER_HORIZ_LINE = 7;
    public static final int MARKER_CROSS = 8;
    public static final int MARKER_CIRCLE = 9;
    public static final int MARKER_SQUARE = 10;
    public static final int STYLE_SOLID = 0;
    public static final int STYLE_DOT = 1;
    public static final int STYLE_DASH = 2;
    public static final int STYLE_LONG_DASH = 3;
    public static final int STYLE_DASH_DOT = 4;
    public static final int TYPE_LINE = 0;
    public static final int TYPE_BAR = 1;
    public static final int METHOD_FILL_FROM_TOP = 0;
    public static final int METHOD_FILL_FROM_ZERO = 1;
    public static final int METHOD_FILL_FROM_BOTTOM = 2;
    public static final int FILL_STYLE_NONE = 0;
    public static final int FILL_STYLE_SOLID = 1;
    public static final int FILL_STYLE_LARGE_RIGHT_HATCH = 2;
    public static final int FILL_STYLE_LARGE_LEFT_HATCH = 3;
    public static final int FILL_STYLE_LARGE_CROSS_HATCH = 4;
    public static final int FILL_STYLE_SMALL_RIGHT_HATCH = 5;
    public static final int FILL_STYLE_SMALL_LEFT_HATCH = 6;
    public static final int FILL_STYLE_SMALL_CROSS_HATCH = 7;
    public static final int FILL_STYLE_DOT_PATTERN_1 = 8;
    public static final int FILL_STYLE_DOT_PATTERN_2 = 9;
    public static final int FILL_STYLE_DOT_PATTERN_3 = 10;
    public static final double NAN_FOR_NULL = Double.longBitsToDouble(9218868487374504191L);
    public static final double NAN_FOR_POSITIVE_INFINITY = Double.longBitsToDouble(-1217159371947777L);
    public static final double NAN_FOR_NEGATIVE_INFINITY = Double.longBitsToDouble(-4503599626605057L);
    public static final int INTERPOLATE_NONE = 0;
    public static final int INTERPOLATE_LINEAR = 1;
    public static final int INTERPOLATE_COSINE = 2;
    public static final int INTERPOLATE_CUBIC = 3;
    public static final int INTERPOLATE_HERMITE = 4;
    public static final int SMOOTH_NONE = 0;
    public static final int SMOOTH_FLAT = 1;
    public static final int SMOOTH_TRIANGULAR = 2;
    public static final int SMOOTH_GAUSSIAN = 3;
    public static final int SMOOTH_EXT_NONE = 0;
    public static final int SMOOTH_EXT_FLAT = 1;
    public static final int SMOOTH_EXT_LINEAR = 2;
    public static final int MATH_NONE = 0;
    public static final int MATH_DERIVATIVE = 1;
    public static final int MATH_INTEGRAL = 2;
    public static final int MATH_FFT_MODULUS = 3;
    public static final int MATH_FFT_PHASE = 4;
    private JLAxis parentAxis = null;
    private Color lineColor;
    private Color fillColor;
    private Color markerColor;
    private int lineStyle = 0;
    private int lineWidth = 1;
    private int markerType = 0;
    private int markerSize = 6;
    private int barWidth = 10;
    private int fillStyle = 0;
    private int fillMethod = 2;
    private int type = 0;
    private double A0 = 0.0;
    private double A1 = 1.0;
    private double A2 = 0.0;
    private DataList theData = null;
    private DataList theFilteredData = null;
    private int dataLength = 0;
    private int filteredDataLength;
    private DataList theDataEnd = null;
    private DataList theFilteredDataEnd;
    private double max = -1.7976931348623157E308;
    private double min;
    private double maxXValue = -1.7976931348623157E308;
    private double minXValue;
    private String name = "";
    private String unit = "";
    private boolean clickable = true;
    private boolean labelVisible = true;
    private String userFormat = null;
    private Color labelColor = Color.BLACK;
    private int interpMethod = 0;
    private int interpStep = 10;
    private double interpTension = 0.0;
    private double interpBias = 0.0;
    private int smoothMethod = 0;
    private double[] smoothCoefs = null;
    private int smoothNeighbor = 3;
    private double smoothSigma = 0.5;
    private int smoothExtrapolation = 2;
    private int mathFunction = 0;
    protected boolean xDataSorted = true;

    public static String getHelpString() {
        return "-- Dataview settings --\n  Parameter name is preceded by the dataview name.\n\nlinecolor:r,g,b  Curve color\nlinewidth:width  Curve width\nlinestyle:style  Line style (0 Solid,1 Dot, 2 Dash, 3 Long Dash,...)\nfillcolor:r,g,b  Curve fill color\nfillmethod:m   Bar filling method (0 Top,1 Zero,2 Bottom)\nfillstyle:style  Curve filling style (0 No fill,1 Solid,...)\nviewtype:type   Type of plot (0 Line, 1 Bar)\nbarwidth:width   Bar width in pixel (0 autoscale)\nmarkercolor:r,g,b   Marker color\nmarkersize:size   Marker size\nmarkerstyle:style  Marker style (0 No marker,1 Dot,2 Box,...)\nA0,A1,A2:value   Vertical transfrom Y = A0 + A1*y + A2*y*y\nA0,A1,A2:value   Vertical transfrom Y = A0 + A1*y + A2*y*y\nlabelvisible:true or false   Displays legend of this view\nclickable:true or false  Shows tooltip on mouse click\n";
    }

    public JLDataView() {
        this.lineColor = Color.red;
        this.fillColor = Color.lightGray;
        this.markerColor = Color.red;
        this.min = Double.MAX_VALUE;
        this.minXValue = Double.MAX_VALUE;
    }

    public void setViewType(int n) {
        this.type = n;
    }

    public int getViewType() {
        return this.type;
    }

    public void setFillStyle(int n) {
        this.fillStyle = n;
    }

    public int getFillStyle() {
        return this.fillStyle;
    }

    public void setFillMethod(int n) {
        this.fillMethod = n;
    }

    public int getFillMethod() {
        return this.fillMethod;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setColor(Color color) {
        this.lineColor = color;
    }

    public Color getColor() {
        return this.lineColor;
    }

    public boolean isFill() {
        return this.fillStyle != 0;
    }

    public void setFill(boolean bl) {
        if (!bl) {
            this.setFillStyle(0);
        } else {
            this.setFillStyle(1);
        }
    }

    public void setClickable(boolean bl) {
        this.clickable = bl;
    }

    public boolean isClickable() {
        return this.clickable;
    }

    public void setLabelVisible(boolean bl) {
        this.labelVisible = bl;
    }

    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    public void setInterpolationMethod(int n) {
        this.interpMethod = n;
        this.commitChange();
    }

    public int getInterpolationMethod() {
        return this.interpMethod;
    }

    public void setInterpolationStep(int n) {
        if (n < 2) {
            n = 2;
        }
        this.interpStep = n;
        this.updateFilters();
    }

    public int getInterpolationStep() {
        return this.interpStep;
    }

    public void setHermiteTension(double d) {
        if (d < -1.0) {
            d = -1.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        this.interpTension = d;
        this.updateFilters();
    }

    public double getHermiteTension() {
        return this.interpTension;
    }

    public void setHermiteBias(double d) {
        this.interpBias = d;
        this.updateFilters();
    }

    public double getHermiteBias() {
        return this.interpBias;
    }

    public void setSmoothingMethod(int n) {
        this.smoothMethod = n;
        this.updateSmoothCoefs();
        this.commitChange();
    }

    public int getSmoothingMethod() {
        return this.smoothMethod;
    }

    public void setSmoothingNeighbors(int n) {
        this.smoothNeighbor = n / 2 * 2 + 1;
        if (this.smoothNeighbor < 3) {
            this.smoothNeighbor = 3;
        }
        this.updateSmoothCoefs();
        this.updateFilters();
    }

    public int getSmoothingNeighbors() {
        return this.smoothNeighbor - 1;
    }

    public void setSmoothingGaussSigma(double d) {
        this.smoothSigma = d;
        this.updateSmoothCoefs();
        this.commitChange();
    }

    public double getSmoothingGaussSigma() {
        return this.smoothSigma;
    }

    public void setSmoothingExtrapolation(int n) {
        this.smoothExtrapolation = n;
        this.updateFilters();
    }

    public int getSmoothingExtrapolation() {
        return this.smoothExtrapolation;
    }

    public void setMathFunction(int n) {
        this.mathFunction = n;
        this.updateFilters();
    }

    public int getMathFunction() {
        return this.mathFunction;
    }

    public void setBarWidth(int n) {
        this.barWidth = n;
    }

    public int getBarWidth() {
        return this.barWidth;
    }

    public void setMarkerColor(Color color) {
        this.markerColor = color;
    }

    public Color getMarkerColor() {
        return this.markerColor;
    }

    public void setStyle(int n) {
        this.lineStyle = n;
    }

    public int getMarkerSize() {
        return this.markerSize;
    }

    public void setMarkerSize(int n) {
        this.markerSize = n;
    }

    public int getStyle() {
        return this.lineStyle;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int n) {
        this.lineWidth = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setUnit(String string) {
        this.unit = string;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getExtendedName() {
        String string = "";
        if (this.hasTransform()) {
            String string2 = this.name + " [";
            if (this.A0 != 0.0) {
                string2 = string2 + Double.toString(this.A0);
                string = " + ";
            }
            if (this.A1 != 0.0) {
                string2 = string2 + string + Double.toString(this.A1) + "*y";
                string = " + ";
            }
            if (this.A2 != 0.0) {
                string2 = string2 + string + Double.toString(this.A2) + "*y^2";
            }
            string2 = string2 + "]";
            return string2;
        }
        return this.name;
    }

    public int getMarker() {
        return this.markerType;
    }

    public void setMarker(int n) {
        this.markerType = n;
    }

    public double getA0() {
        return this.A0;
    }

    public double getA1() {
        return this.A1;
    }

    public double getA2() {
        return this.A2;
    }

    public void setA0(double d) {
        this.A0 = d;
    }

    public void setA1(double d) {
        this.A1 = d;
    }

    public void setA2(double d) {
        this.A2 = d;
    }

    public boolean hasTransform() {
        return this.A0 != 0.0 || this.A1 != 1.0 || this.A2 != 0.0;
    }

    public boolean hasFilter() {
        return this.interpMethod != 0 || this.smoothMethod != 0 || this.mathFunction != 0;
    }

    public void setAxis(JLAxis jLAxis) {
        this.parentAxis = jLAxis;
    }

    public JLAxis getAxis() {
        return this.parentAxis;
    }

    public double getMinimum() {
        return this.min;
    }

    public double getMaximum() {
        return this.max;
    }

    public double getMinTime() {
        if (this.hasFilter()) {
            return this.minXValue;
        }
        if (this.theData != null) {
            return this.theData.x;
        }
        return Double.MAX_VALUE;
    }

    public double getMinXValue() {
        if (this.isXDataSorted()) {
            return this.getMinTime();
        }
        return this.minXValue;
    }

    public double getPositiveMinXValue() {
        double d = Double.MAX_VALUE;
        DataList dataList = this.theData;
        if (this.hasFilter()) {
            dataList = this.theFilteredData;
        }
        while (dataList != null) {
            if (dataList.x > 0.0 && dataList.x < d) {
                d = dataList.x;
            }
            dataList = dataList.next;
        }
        return d;
    }

    public double getPositiveMinTime() {
        DataList dataList = this.theData;
        if (this.hasFilter()) {
            dataList = this.theFilteredData;
        }
        boolean bl = false;
        while (dataList != null && !bl) {
            bl = dataList.x > 0.0;
            if (bl) continue;
            dataList = dataList.next;
        }
        if (dataList != null) {
            return dataList.x;
        }
        return Double.MAX_VALUE;
    }

    public double getMaxXValue() {
        if (this.isXDataSorted()) {
            return this.getMaxTime();
        }
        return this.maxXValue;
    }

    public double getMaxTime() {
        if (this.hasFilter()) {
            return this.maxXValue;
        }
        if (this.theDataEnd != null) {
            return this.theDataEnd.x;
        }
        return -1.7976931348623157E308;
    }

    public int getDataLength() {
        if (this.hasFilter()) {
            return this.filteredDataLength;
        }
        return this.dataLength;
    }

    public DataList getData() {
        if (this.hasFilter()) {
            return this.theFilteredData;
        }
        return this.theData;
    }

    public void commitChange() {
        if (this.hasFilter()) {
            this.updateFilters();
        } else {
            this.computeDataBounds();
        }
    }

    public void add(double d, double d2) {
        this.add(d, d2, true);
    }

    public synchronized void add(double d, double d2, boolean bl) {
        if (Double.isInfinite(d2)) {
            d2 = d2 > 0.0 ? NAN_FOR_POSITIVE_INFINITY : NAN_FOR_NEGATIVE_INFINITY;
        }
        DataList dataList = new DataList(d, d2);
        this.theDataEnd = this.theData == null ? (this.theData = dataList) : (this.theDataEnd.next = dataList);
        if (d2 < this.min) {
            this.min = d2;
        }
        if (d2 > this.max) {
            this.max = d2;
        }
        if (d < this.minXValue) {
            this.minXValue = d;
        }
        if (d > this.maxXValue) {
            this.maxXValue = d;
        }
        ++this.dataLength;
        if (bl) {
            this.updateFilters();
        }
    }

    public void setData(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            System.out.println("Warning: Cannot set data, x vector and y vector have not the same length");
            return;
        }
        this.reset();
        for (int i = 0; i < dArray.length; ++i) {
            this.add(dArray[i], dArray2[i], false);
        }
        this.updateFilters();
    }

    public void add(Point2D.Double double_) {
        this.add(double_.x, double_.y);
    }

    public synchronized int garbagePointTime(double d) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = 0;
        if (this.theData != null) {
            while (this.theData != null && !bl5) {
                bl5 = this.theData.x > this.maxXValue - d - 3000.0;
                if (bl5) continue;
                bl = bl || this.theData.y == this.max;
                bl2 = bl2 || this.theData.y == this.min;
                bl3 = bl3 || this.theData.x == this.maxXValue;
                bl4 = bl4 || this.theData.x == this.minXValue;
                DataList dataList = this.theData;
                this.theData = this.theData.next;
                dataList.next = null;
                dataList = null;
                --this.dataLength;
                ++n;
            }
        }
        if (this.theData == null) {
            this.reset();
        } else if (this.hasFilter()) {
            this.updateFilters();
        } else {
            bl4 = bl4 && !this.isXDataSorted();
            boolean bl6 = bl3 = bl3 && !this.isXDataSorted();
            if (bl) {
                if (bl2 || bl4 || bl3) {
                    this.computeDataBounds();
                } else {
                    this.computeMax();
                }
            } else if (bl2) {
                if (bl4 || bl3) {
                    this.computeDataBounds();
                } else {
                    this.computeMin();
                }
            } else if (bl3) {
                if (bl4) {
                    this.computeDataBounds();
                } else {
                    this.computeMaxXValue();
                }
            } else if (bl4) {
                this.computeMinXValue();
            }
        }
        return n;
    }

    public synchronized void garbagePointLimit(int n) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = this.dataLength - n;
        for (int i = 0; i < n2; ++i) {
            bl = bl || this.theData.y == this.max;
            bl2 = bl2 || this.theData.y == this.min;
            bl3 = bl3 || this.theData.x == this.maxXValue;
            bl4 = bl4 || this.theData.x == this.minXValue;
            DataList dataList = this.theData;
            this.theData = this.theData.next;
            dataList.next = null;
            --this.dataLength;
        }
        if (this.hasFilter()) {
            this.updateFilters();
        } else {
            bl4 = bl4 && !this.isXDataSorted();
            boolean bl5 = bl3 = bl3 && !this.isXDataSorted();
            if (bl) {
                if (bl2 || bl4 || bl3) {
                    this.computeDataBounds();
                } else {
                    this.computeMax();
                }
            } else if (bl2) {
                if (bl4 || bl3) {
                    this.computeDataBounds();
                } else {
                    this.computeMin();
                }
            } else if (bl3) {
                if (bl4) {
                    this.computeDataBounds();
                } else {
                    this.computeMaxXValue();
                }
            } else if (bl4) {
                this.computeMinXValue();
            }
        }
    }

    private void computeMin() {
        this.min = Double.MAX_VALUE;
        DataList dataList = this.theData;
        if (this.hasFilter()) {
            dataList = this.theFilteredData;
        }
        while (dataList != null) {
            if (dataList.y < this.min) {
                this.min = dataList.y;
            }
            dataList = dataList.next;
        }
    }

    private void computeMax() {
        this.max = -1.7976931348623157E308;
        DataList dataList = this.theData;
        if (this.hasFilter()) {
            dataList = this.theFilteredData;
        }
        while (dataList != null) {
            if (dataList.y > this.max) {
                this.max = dataList.y;
            }
            dataList = dataList.next;
        }
    }

    private void computeMinXValue() {
        this.minXValue = Double.MAX_VALUE;
        DataList dataList = this.theData;
        if (this.hasFilter()) {
            dataList = this.theFilteredData;
        }
        while (dataList != null) {
            if (dataList.x < this.minXValue) {
                this.minXValue = dataList.x;
            }
            dataList = dataList.next;
        }
    }

    private void computeMaxXValue() {
        this.maxXValue = -1.7976931348623157E308;
        DataList dataList = this.theData;
        if (this.hasFilter()) {
            dataList = this.theFilteredData;
        }
        while (dataList != null) {
            if (dataList.x > this.maxXValue) {
                this.maxXValue = dataList.x;
            }
            dataList = dataList.next;
        }
    }

    public void computeDataBounds() {
        this.minXValue = Double.MAX_VALUE;
        this.maxXValue = -1.7976931348623157E308;
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        DataList dataList = this.theData;
        if (this.hasFilter()) {
            dataList = this.theFilteredData;
        }
        while (dataList != null) {
            if (dataList.x < this.minXValue) {
                this.minXValue = dataList.x;
            }
            if (dataList.x > this.maxXValue) {
                this.maxXValue = dataList.x;
            }
            if (dataList.y < this.min) {
                this.min = dataList.y;
            }
            if (dataList.y > this.max) {
                this.max = dataList.y;
            }
            dataList = dataList.next;
        }
    }

    public double[] computeTransformedMinMax() {
        double[] dArray = new double[2];
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        DataList dataList = this.theData;
        if (this.hasFilter()) {
            dataList = this.theFilteredData;
        }
        while (dataList != null) {
            double d3 = this.A0 + this.A1 * dataList.y + this.A2 * dataList.y * dataList.y;
            if (d3 < d) {
                d = d3;
            }
            if (d3 > d2) {
                d2 = d3;
            }
            dataList = dataList.next;
        }
        if (d == Double.MAX_VALUE) {
            d = 0.0;
        }
        if (d2 == -1.7976931348623157E308) {
            d2 = 99.0;
        }
        dArray[0] = d;
        dArray[1] = d2;
        return dArray;
    }

    public double computePositiveMin() {
        double d = Double.MAX_VALUE;
        DataList dataList = this.theData;
        if (this.hasFilter()) {
            dataList = this.theFilteredData;
        }
        while (dataList != null) {
            if (dataList.y > 0.0 && dataList.y < d) {
                d = dataList.y;
            }
            dataList = dataList.next;
        }
        return d;
    }

    public double getTransformedValue(double d) {
        return this.A0 + this.A1 * d + this.A2 * d * d;
    }

    public DataList getLastValue() {
        if (this.hasFilter()) {
            return this.theDataEnd;
        }
        return this.theFilteredDataEnd;
    }

    public synchronized void reset() {
        this.theData = null;
        this.theDataEnd = null;
        this.dataLength = 0;
        this.updateFilters();
        this.computeDataBounds();
    }

    public void applyConfiguration(String string, CfFileReader cfFileReader) {
        Vector vector = cfFileReader.getParam(string + "_linecolor");
        if (vector != null) {
            this.setColor(OFormat.getColor(vector));
        }
        if ((vector = cfFileReader.getParam(string + "_linewidth")) != null) {
            this.setLineWidth(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_linestyle")) != null) {
            this.setStyle(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_fillcolor")) != null) {
            this.setFillColor(OFormat.getColor(vector));
        }
        if ((vector = cfFileReader.getParam(string + "_fillmethod")) != null) {
            this.setFillMethod(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_fillstyle")) != null) {
            this.setFillStyle(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_viewtype")) != null) {
            this.setViewType(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_barwidth")) != null) {
            this.setBarWidth(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_markercolor")) != null) {
            this.setMarkerColor(OFormat.getColor(vector));
        }
        if ((vector = cfFileReader.getParam(string + "_markersize")) != null) {
            this.setMarkerSize(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_markerstyle")) != null) {
            this.setMarker(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_A0")) != null) {
            this.setA0(OFormat.getDouble(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_A1")) != null) {
            this.setA1(OFormat.getDouble(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_A2")) != null) {
            this.setA2(OFormat.getDouble(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_labelvisible")) != null) {
            this.setLabelVisible(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_clickable")) != null) {
            this.setClickable(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_labelColor")) != null) {
            this.setLabelColor(OFormat.getColor(vector));
        }
    }

    public String getConfiguration(String string) {
        String string2 = "";
        string2 = string2 + string + "_linecolor:" + OFormat.color(this.getColor()) + "\n";
        string2 = string2 + string + "_linewidth:" + this.getLineWidth() + "\n";
        string2 = string2 + string + "_linestyle:" + this.getStyle() + "\n";
        string2 = string2 + string + "_fillcolor:" + OFormat.color(this.getFillColor()) + "\n";
        string2 = string2 + string + "_fillmethod:" + this.getFillMethod() + "\n";
        string2 = string2 + string + "_fillstyle:" + this.getFillStyle() + "\n";
        string2 = string2 + string + "_viewtype:" + this.getViewType() + "\n";
        string2 = string2 + string + "_barwidth:" + this.getBarWidth() + "\n";
        string2 = string2 + string + "_markercolor:" + OFormat.color(this.getMarkerColor()) + "\n";
        string2 = string2 + string + "_markersize:" + this.getMarkerSize() + "\n";
        string2 = string2 + string + "_markerstyle:" + this.getMarker() + "\n";
        string2 = string2 + string + "_A0:" + this.getA0() + "\n";
        string2 = string2 + string + "_A1:" + this.getA1() + "\n";
        string2 = string2 + string + "_A2:" + this.getA2() + "\n";
        string2 = string2 + string + "_labelvisible:" + this.isLabelVisible() + "\n";
        string2 = string2 + string + "_clickable:" + this.isClickable() + "\n";
        string2 = string2 + string + "_labelColor:" + OFormat.color(this.getLabelColor()) + "\n";
        return string2;
    }

    public double getYValueByIndex(int n) {
        if (n < 0 || n >= this.getDataLength()) {
            return Double.NaN;
        }
        DataList dataList = this.theData;
        for (int i = 0; dataList != null && i < n; ++i) {
            dataList = dataList.next;
        }
        if (dataList != null) {
            return dataList.y;
        }
        return Double.NaN;
    }

    public double getXValueByIndex(int n) {
        if (n < 0 || n >= this.getDataLength()) {
            return Double.NaN;
        }
        DataList dataList = this.theData;
        for (int i = 0; dataList != null && i < n; ++i) {
            dataList = dataList.next;
        }
        if (dataList != null) {
            return dataList.x;
        }
        return Double.NaN;
    }

    public void setUserFormat(String string) {
        if (string != null && string.length() > 0 && this.isValidFormat(string)) {
            this.userFormat = string;
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("JLDataView.setUserFormat(String format): ");
            stringBuffer.append(string);
            stringBuffer.append(" is not a valid format !");
            System.err.println(stringBuffer.toString());
            stringBuffer = null;
            this.userFormat = null;
        }
    }

    public boolean isValidFormat(String string) {
        if (string.indexOf("%") == 0 && string.lastIndexOf("%") == string.indexOf("%")) {
            if (string.indexOf(".") == -1) {
                try {
                    int n = Integer.parseInt(string.substring(1, string.length() - 1));
                    return n > 0;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            if (string.indexOf(".") == string.lastIndexOf(".")) {
                if (string.toLowerCase().indexOf("f") == string.length() - 1 && string.toLowerCase().indexOf("f") > 0 || string.toLowerCase().indexOf("e") == string.length() - 1 && string.toLowerCase().indexOf("e") > 0) {
                    try {
                        int n = Integer.parseInt(string.substring(1, string.indexOf(".")));
                        int n2 = Integer.parseInt(string.substring(string.indexOf(".") + 1, string.length() - 1));
                        return n > n2 && n > 0 && n2 >= 0;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public String getUserFormat() {
        return this.userFormat;
    }

    public String formatValue(double d) {
        if (Double.isNaN(d)) {
            long l = Double.doubleToRawLongBits(d);
            if (l == Double.doubleToRawLongBits(NAN_FOR_NULL)) {
                return "null";
            }
            if (l == Double.doubleToRawLongBits(NAN_FOR_NEGATIVE_INFINITY)) {
                return "-Infinity";
            }
            if (l == Double.doubleToRawLongBits(NAN_FOR_POSITIVE_INFINITY)) {
                return "+Infinity";
            }
            return "NaN";
        }
        if (this.userFormat != null) {
            Object[] objectArray = new Object[]{new Double(d)};
            String string = Double.toString(d);
            try {
                string = Format.sprintf((String)this.userFormat, (Object[])objectArray);
            }
            catch (Exception exception) {
                string = Double.toString(d);
            }
            return string;
        }
        if (this.parentAxis == null) {
            return Double.toString(d);
        }
        return this.parentAxis.formatValue(d, 0.0);
    }

    public boolean isXDataSorted() {
        return this.xDataSorted;
    }

    public void setXDataSorted(boolean bl) {
        if (this.xDataSorted && !bl) {
            this.computeDataBounds();
        }
        this.xDataSorted = bl;
    }

    public synchronized double[] getSortedTimes() {
        double[] dArray = new double[this.dataLength];
        DataList dataList = this.theData;
        int n = 0;
        while (n < this.dataLength) {
            dArray[n] = dataList.x;
            dataList = dataList.next;
        }
        JLDataView.mergeSort(dArray, null);
        return dArray;
    }

    public synchronized double[] getSortedValues() {
        double[] dArray = new double[this.dataLength];
        DataList dataList = this.theData;
        int n = 0;
        while (n < this.dataLength) {
            dArray[n] = dataList.y;
            dataList = dataList.next;
        }
        JLDataView.mergeSort(dArray, null);
        return dArray;
    }

    public synchronized double[][] getDataSortedByTimes() {
        double[][] dArray = new double[2][this.dataLength];
        double[] dArray2 = new double[this.dataLength];
        double[] dArray3 = new double[this.dataLength];
        DataList dataList = this.theData;
        int n = 0;
        while (n < this.dataLength) {
            dArray2[n] = dataList.x;
            dArray3[n] = dataList.y;
            dataList = dataList.next;
        }
        JLDataView.mergeSort(dArray2, dArray3);
        dArray[0] = dArray2;
        dArray[1] = dArray3;
        return dArray;
    }

    public synchronized double[][] getDataSortedByValues() {
        double[][] dArray = new double[2][this.dataLength];
        double[] dArray2 = new double[this.dataLength];
        double[] dArray3 = new double[this.dataLength];
        DataList dataList = this.theData;
        int n = 0;
        while (n < this.dataLength) {
            dArray2[n] = dataList.x;
            dArray3[n] = dataList.y;
            dataList = dataList.next;
        }
        JLDataView.mergeSort(dArray3, dArray2);
        dArray[0] = dArray2;
        dArray[1] = dArray3;
        return dArray;
    }

    public static void mergeSort(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        if (n > 0) {
            JLDataView.mergeSort(dArray, dArray2, 0, n - 1);
        }
    }

    private static void mergeSort(double[] dArray, double[] dArray2, int n, int n2) {
        if (n != n2) {
            int n3 = (n2 + n) / 2;
            JLDataView.mergeSort(dArray, dArray2, n, n3);
            JLDataView.mergeSort(dArray, dArray2, n3 + 1, n2);
            JLDataView.merge(dArray, dArray2, n, n3, n2);
        }
    }

    private static void merge(double[] dArray, double[] dArray2, int n, int n2, int n3) {
        int n4;
        int n5 = n2 + 1;
        double[] dArray3 = new double[n2 - n + 1];
        double[] dArray4 = dArray2 == null ? null : new double[n2 - n + 1];
        for (n4 = n; n4 <= n2; ++n4) {
            dArray3[n4 - n] = dArray[n4];
            if (dArray2 == null) continue;
            dArray4[n4 - n] = dArray2[n4];
        }
        n4 = n;
        int n6 = n5;
        for (int i = n; i <= n3 && n4 != n5; ++i) {
            if (n6 == n3 + 1) {
                dArray[i] = dArray3[n4 - n];
                if (dArray2 != null) {
                    dArray2[i] = dArray4[n4 - n];
                }
                ++n4;
                continue;
            }
            if (dArray3[n4 - n] < dArray[n6]) {
                dArray[i] = dArray3[n4 - n];
                if (dArray2 != null) {
                    dArray2[i] = dArray4[n4 - n];
                }
                ++n4;
                continue;
            }
            dArray[i] = dArray[n6];
            if (dArray2 != null) {
                dArray2[i] = dArray2[n6];
            }
            ++n6;
        }
    }

    private Point2D.Double[] getSource(DataList dataList, int n, boolean bl) {
        DataList dataList2 = dataList;
        Vector<Point2D.Double> vector = new Vector<Point2D.Double>();
        Point2D.Double double_ = new Point2D.Double(Double.NaN, Double.NaN);
        Point2D.Double double_2 = new Point2D.Double(Double.NaN, Double.NaN);
        while (dataList2 != null) {
            if (!Double.isNaN(dataList2.y)) {
                vector.add(new Point2D.Double(dataList2.x, dataList2.y));
            } else if (bl && !Double.isNaN(double_.y)) {
                if (dataList2.next != null && !Double.isNaN(dataList2.next.y)) {
                    double_2.x = dataList2.next.x;
                    double_2.y = dataList2.next.y;
                    vector.add(this.LinearInterpolate(double_, double_2, 0.5));
                } else {
                    vector.add(new Point2D.Double(dataList2.x, double_.y));
                }
            }
            double_.x = dataList2.x;
            double_.y = dataList2.y;
            dataList2 = dataList2.next;
        }
        Point2D.Double[] doubleArray = new Point2D.Double[vector.size() + 2 * n];
        for (int i = 0; i < vector.size(); ++i) {
            doubleArray[i + n] = (Point2D.Double)vector.get(i);
        }
        return doubleArray;
    }

    private void mathop() {
        if (this.mathFunction == 0) {
            return;
        }
        Point2D.Double[] doubleArray = this.interpMethod == 0 && this.smoothMethod == 0 ? this.getSource(this.theData, 0, false) : this.getSource(this.theFilteredData, 0, false);
        this.theFilteredData = null;
        this.theFilteredDataEnd = null;
        this.filteredDataLength = 0;
        switch (this.mathFunction) {
            case 1: {
                for (int i = 0; i < doubleArray.length - 1; ++i) {
                    double d = (doubleArray[i + 1].y - doubleArray[i].y) / (doubleArray[i + 1].x - doubleArray[i].x);
                    this.addInt(doubleArray[i].x, d);
                }
                break;
            }
            case 2: {
                double d = 0.0;
                this.addInt(doubleArray[0].x, d);
                for (int i = 0; i < doubleArray.length - 1; ++i) {
                    this.addInt(doubleArray[i + 1].x, d += (doubleArray[i + 1].y + doubleArray[i].y) / 2.0 * (doubleArray[i + 1].x - doubleArray[i].x));
                }
                break;
            }
            case 3: {
                break;
            }
        }
    }

    private int reverse(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 = n3 << 1 | n & 1;
            n >>= 1;
        }
        return n3;
    }

    private void doFFT(Point2D.Double[] doubleArray, int n) {
        int n2;
        int n3;
        int n4 = doubleArray.length;
        if (n4 < 2) {
            return;
        }
        int n5 = 0;
        n5 = (n4 & n4 - 1) == 0 ? -1 : 0;
        while (n4 != 0) {
            n4 >>= 1;
            ++n5;
        }
        n4 = 1 << n5;
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n4];
        for (n3 = 0; n3 < doubleArray.length; ++n3) {
            n2 = this.reverse(n3, n5);
            dArray[n2] = doubleArray[n3].y;
            dArray2[n2] = 0.0;
        }
        while (n3 < n4) {
            n2 = this.reverse(n3, n5);
            dArray[n2] = 0.0;
            dArray2[n2] = 0.0;
            ++n3;
        }
        int n6 = 1;
        for (int i = 2; i <= n4; i <<= 1) {
            double d = Math.PI * 2 / (double)i;
            double d2 = Math.sin(-2.0 * d);
            double d3 = Math.sin(-d);
            double d4 = Math.cos(-2.0 * d);
            double d5 = Math.cos(-d);
            double d6 = 2.0 * d5;
            for (n3 = 0; n3 < n4; n3 += i) {
                double d7 = d4;
                double d8 = d5;
                double d9 = d2;
                double d10 = d3;
                int n7 = n3;
                for (int j = 0; j < n6; ++j) {
                    double d11 = d6 * d8 - d7;
                    d7 = d8;
                    d8 = d11;
                    double d12 = d6 * d10 - d9;
                    d9 = d10;
                    d10 = d12;
                    int n8 = n7 + n6;
                    double d13 = d11 * dArray[n8] - d12 * dArray2[n8];
                    double d14 = d11 * dArray2[n8] + d12 * dArray[n8];
                    dArray[n8] = dArray[n7] - d13;
                    dArray2[n8] = dArray2[n7] - d14;
                    int n9 = n7;
                    dArray[n9] = dArray[n9] + d13;
                    int n10 = n7++;
                    dArray2[n10] = dArray2[n10] + d14;
                }
            }
            n6 = i;
        }
        switch (n) {
            case 0: {
                for (n3 = 0; n3 < n4; ++n3) {
                    double d = Math.sqrt(dArray[n3] * dArray[n3] + dArray2[n3] * dArray2[n3]);
                    this.addInt(n3, d);
                }
                break;
            }
            case 1: {
                for (n3 = 0; n3 < n4; ++n3) {
                }
                break;
            }
        }
    }

    public void updateFilters() {
        this.theFilteredData = null;
        this.theFilteredDataEnd = null;
        this.filteredDataLength = 0;
        if (this.hasFilter()) {
            this.interpolate();
            this.convolution();
            this.mathop();
            this.computeDataBounds();
        }
    }

    private void updateSmoothCoefs() {
        int n;
        if (this.smoothMethod == 0) {
            this.smoothCoefs = null;
            return;
        }
        this.smoothCoefs = new double[this.smoothNeighbor];
        int n2 = this.smoothNeighbor / 2;
        switch (this.smoothMethod) {
            case 1: {
                for (int i = 0; i < this.smoothNeighbor; ++i) {
                    this.smoothCoefs[i] = 1.0;
                }
                break;
            }
            case 2: {
                int n3;
                double d = 1.0 / ((double)n2 + 1.0);
                for (n3 = 0; n3 < n2; ++n3) {
                    this.smoothCoefs[n3] = (double)(n3 - n2) * d + 1.0;
                }
                for (n3 = 1; n3 <= n2; ++n3) {
                    this.smoothCoefs[n3 + n2] = (double)(-n3) * d + 1.0;
                }
                this.smoothCoefs[n2] = 1.0;
                break;
            }
            case 3: {
                double d = 1.0 / (2.0 * Math.sqrt(Math.PI) * this.smoothSigma);
                double d2 = 1.0 / (2.0 * this.smoothSigma * this.smoothSigma);
                for (int i = 0; i < this.smoothNeighbor; ++i) {
                    double d3 = i - n2;
                    this.smoothCoefs[i] = d * Math.exp(-d3 * d3 * d2);
                }
                break;
            }
        }
        double d = 0.0;
        for (n = 0; n < this.smoothNeighbor; ++n) {
            d += this.smoothCoefs[n];
        }
        for (n = 0; n < this.smoothNeighbor; ++n) {
            this.smoothCoefs[n] = this.smoothCoefs[n] / d;
        }
    }

    private void convolution() {
        int n;
        int n2;
        int n3;
        if (this.smoothMethod == 0) {
            return;
        }
        int n4 = this.smoothCoefs.length / 2;
        switch (this.smoothExtrapolation) {
            case 0: {
                n3 = 0;
                break;
            }
            default: {
                n3 = n4;
            }
        }
        Point2D.Double[] doubleArray = this.interpMethod == 0 ? this.getSource(this.theData, n3, true) : this.getSource(this.theFilteredData, n3, true);
        int n5 = doubleArray.length - 2 * n4;
        int n6 = n4;
        int n7 = n5 + n4 - 1;
        if (n5 == n3 || n6 > n7) {
            return;
        }
        switch (this.smoothExtrapolation) {
            case 2: {
                n2 = 3;
                Point2D.Double double_ = new Point2D.Double();
                int n8 = 0;
                double_.x = 0.0;
                double_.y = 0.0;
                for (n = n6; n < n2 + n6 && n < n5 + n6 - 1; ++n) {
                    double_.x += doubleArray[n].x - doubleArray[n + 1].x;
                    double_.y += doubleArray[n].y - doubleArray[n + 1].y;
                    ++n8;
                }
                if (n8 == 0) {
                    double_.x = doubleArray[n6].x - (double)n3;
                    double_.y = doubleArray[n6].y;
                } else {
                    double_.x = double_.x / (double)n8 * (double)n3 + doubleArray[n6].x;
                    double_.y = double_.y / (double)n8 * (double)n3 + doubleArray[n6].y;
                }
                for (n = 0; n < n3; ++n) {
                    doubleArray[n] = this.LinearInterpolate(double_, doubleArray[n6], (double)n / (double)n3);
                }
                n8 = 0;
                double_.x = 0.0;
                double_.y = 0.0;
                for (n = n7 - n2; n < n7; ++n) {
                    if (n < n6) continue;
                    double_.x += doubleArray[n + 1].x - doubleArray[n].x;
                    double_.y += doubleArray[n + 1].y - doubleArray[n].y;
                    ++n8;
                }
                if (n8 == 0) {
                    double_.x = doubleArray[n7].x + (double)n3;
                    double_.y = doubleArray[n7].y;
                } else {
                    double_.x = double_.x / (double)n8 * (double)n3 + doubleArray[n7].x;
                    double_.y = double_.y / (double)n8 * (double)n3 + doubleArray[n7].y;
                }
                for (n = 1; n <= n3; ++n) {
                    doubleArray[n7 + n] = this.LinearInterpolate(doubleArray[n7], double_, (double)n / (double)n3);
                }
                break;
            }
            case 1: {
                for (n = 0; n < n3; ++n) {
                    doubleArray[n] = new Point2D.Double(doubleArray[n6].x - (double)n3 + (double)n, doubleArray[n6].y);
                    doubleArray[n + n7 + 1] = new Point2D.Double(doubleArray[n7].x + (double)n + 1.0, doubleArray[n7].y);
                }
                break;
            }
        }
        this.theFilteredData = null;
        this.theFilteredDataEnd = null;
        this.filteredDataLength = 0;
        for (n = n6; n <= n7; ++n) {
            double d = 0.0;
            for (n2 = 0; n2 < this.smoothCoefs.length; ++n2) {
                d += this.smoothCoefs[n2] * doubleArray[n + n2 - n4].y;
            }
            this.addInt(doubleArray[n].x, d);
        }
    }

    private void addInt(Point2D.Double double_) {
        this.addInt(double_.x, double_.y);
    }

    private void addInt(double d, double d2) {
        DataList dataList = new DataList(d, d2);
        if (this.theFilteredData == null) {
            this.theFilteredData = dataList;
        } else {
            this.theFilteredDataEnd.next = dataList;
        }
        this.theFilteredDataEnd = dataList;
        ++this.filteredDataLength;
    }

    private Point2D.Double[] getSegments(DataList dataList) {
        int n = 0;
        DataList dataList2 = dataList;
        while (dataList != null && !Double.isNaN(dataList.y)) {
            ++n;
            dataList = dataList.next;
        }
        dataList = dataList2;
        Point2D.Double[] doubleArray = new Point2D.Double[n];
        for (int i = 0; i < n; ++i) {
            doubleArray[i] = new Point2D.Double(dataList.x, dataList.y);
            dataList = dataList.next;
        }
        return doubleArray;
    }

    private Point2D.Double LinearInterpolate(Point2D.Double double_, Point2D.Double double_2, double d) {
        return new Point2D.Double(double_.x + (double_2.x - double_.x) * d, double_.y + (double_2.y - double_.y) * d);
    }

    private Point2D.Double CosineInterpolate(Point2D.Double double_, Point2D.Double double_2, double d) {
        double d2 = (1.0 - Math.cos(d * Math.PI)) / 2.0;
        return new Point2D.Double(double_.x + (double_2.x - double_.x) * d, double_.y * (1.0 - d2) + double_2.y * d2);
    }

    private Point2D.Double CubicInterpolate(Point2D.Double double_, Point2D.Double double_2, Point2D.Double double_3, Point2D.Double double_4, double d) {
        double d2 = d * d;
        double d3 = d2 * d;
        double d4 = double_4.y - double_3.y - double_.y + double_2.y;
        double d5 = double_.y - double_2.y - d4;
        double d6 = double_3.y - double_.y;
        double d7 = double_2.y;
        return new Point2D.Double(double_2.x + (double_3.x - double_2.x) * d, d4 * d3 + d5 * d2 + d6 * d + d7);
    }

    private Point2D.Double HermiteInterpolate(Point2D.Double double_, Point2D.Double double_2, Point2D.Double double_3, Point2D.Double double_4, double d, double d2, double d3) {
        double d4 = (1.0 - d2) / 2.0;
        double d5 = d * d;
        double d6 = d5 * d;
        double d7 = 2.0 * d6 - 3.0 * d5 + 1.0;
        double d8 = d6 - 2.0 * d5 + d;
        double d9 = d6 - d5;
        double d10 = -2.0 * d6 + 3.0 * d5;
        double d11 = (double_2.x - double_.x) * (1.0 + d3) * d4;
        double d12 = (double_3.x - double_2.x) * (1.0 + d3) * d4;
        double d13 = (double_2.y - double_.y) * (1.0 + d3) * d4;
        double d14 = (double_3.y - double_2.y) * (1.0 + d3) * d4;
        return new Point2D.Double(d7 * double_2.x + d8 * (d11 += (double_3.x - double_2.x) * (1.0 - d3) * d4) + d9 * (d12 += (double_4.x - double_3.x) * (1.0 - d3) * d4) + d10 * double_3.x, d7 * double_2.y + d8 * (d13 += (double_3.y - double_2.y) * (1.0 - d3) * d4) + d9 * (d14 += (double_4.y - double_3.y) * (1.0 - d3) * d4) + d10 * double_3.y);
    }

    private void interpolate() {
        if (this.interpMethod == 0) {
            return;
        }
        double d = 1.0 / (double)this.interpStep;
        DataList dataList = this.theData;
        while (dataList != null) {
            int n;
            Point2D.Double[] doubleArray = this.getSegments(dataList);
            int n2 = doubleArray.length;
            int n3 = this.interpMethod;
            if (n2 == 0) {
                n3 = 0;
                this.addInt(new Point2D.Double(dataList.x, dataList.y));
                dataList = dataList.next;
            } else if (n2 == 1) {
                n3 = 0;
                this.addInt(doubleArray[0]);
            } else if (n2 == 2) {
                n3 = 1;
            }
            switch (n3) {
                case 1: {
                    double d2;
                    int n4;
                    for (n = 0; n < n2 - 2; ++n) {
                        for (n4 = 0; n4 < this.interpStep; ++n4) {
                            d2 = (double)n4 * d;
                            this.addInt(this.LinearInterpolate(doubleArray[n], doubleArray[n + 1], d2));
                        }
                    }
                    for (n4 = 0; n4 <= this.interpStep; ++n4) {
                        d2 = (double)n4 * d;
                        this.addInt(this.LinearInterpolate(doubleArray[n], doubleArray[n + 1], d2));
                    }
                    break;
                }
                case 2: {
                    double d2;
                    int n4;
                    for (n = 0; n < n2 - 2; ++n) {
                        for (n4 = 0; n4 < this.interpStep; ++n4) {
                            d2 = (double)n4 * d;
                            this.addInt(this.CosineInterpolate(doubleArray[n], doubleArray[n + 1], d2));
                        }
                    }
                    for (n4 = 0; n4 <= this.interpStep; ++n4) {
                        d2 = (double)n4 * d;
                        this.addInt(this.LinearInterpolate(doubleArray[n], doubleArray[n + 1], d2));
                    }
                    break;
                }
                case 3: {
                    double d2;
                    int n4;
                    Point2D.Double double_ = new Point2D.Double(2.0 * doubleArray[0].x - doubleArray[1].x, 2.0 * doubleArray[0].y - doubleArray[1].y);
                    for (n4 = 0; n4 < this.interpStep; ++n4) {
                        d2 = (double)n4 * d;
                        this.addInt(this.CubicInterpolate(double_, doubleArray[0], doubleArray[1], doubleArray[2], d2));
                    }
                    for (n = 1; n < n2 - 2; ++n) {
                        for (n4 = 0; n4 < this.interpStep; ++n4) {
                            d2 = (double)n4 * d;
                            this.addInt(this.CubicInterpolate(doubleArray[n - 1], doubleArray[n], doubleArray[n + 1], doubleArray[n + 2], d2));
                        }
                    }
                    Point2D.Double double_2 = new Point2D.Double(2.0 * doubleArray[n + 1].x - doubleArray[n].x, 2.0 * doubleArray[n + 1].y - doubleArray[n].y);
                    for (n4 = 0; n4 <= this.interpStep; ++n4) {
                        d2 = (double)n4 * d;
                        this.addInt(this.CubicInterpolate(doubleArray[n - 1], doubleArray[n], doubleArray[n + 1], double_2, d2));
                    }
                    break;
                }
                case 4: {
                    double d2;
                    int n4;
                    Point2D.Double double_ = new Point2D.Double(2.0 * doubleArray[0].x - doubleArray[1].x, 2.0 * doubleArray[0].y - doubleArray[1].y);
                    for (n4 = 0; n4 < this.interpStep; ++n4) {
                        d2 = (double)n4 * d;
                        this.addInt(this.HermiteInterpolate(double_, doubleArray[0], doubleArray[1], doubleArray[2], d2, this.interpTension, this.interpBias));
                    }
                    for (n = 1; n < n2 - 2; ++n) {
                        for (n4 = 0; n4 < this.interpStep; ++n4) {
                            d2 = (double)n4 * d;
                            this.addInt(this.HermiteInterpolate(doubleArray[n - 1], doubleArray[n], doubleArray[n + 1], doubleArray[n + 2], d2, this.interpTension, this.interpBias));
                        }
                    }
                    Point2D.Double double_2 = new Point2D.Double(2.0 * doubleArray[n + 1].x - doubleArray[n].x, 2.0 * doubleArray[n + 1].y - doubleArray[n].y);
                    for (n4 = 0; n4 <= this.interpStep; ++n4) {
                        d2 = (double)n4 * d;
                        this.addInt(this.HermiteInterpolate(doubleArray[n - 1], doubleArray[n], doubleArray[n + 1], double_2, d2, this.interpTension, this.interpBias));
                    }
                    break;
                }
            }
            for (n = 0; n < n2; ++n) {
                dataList = dataList.next;
            }
        }
    }
}

