/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.AdvancedImagePlus;
import fr.esrf.tangoatk.widget.util.JImage;
import fr.esrf.tangoatk.widget.util.MaskUndoableEdit;
import fr.esrf.tangoatk.widget.util.RoiDefaultUndoableEdit;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import ij.ImageJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.Toolbar;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.LineBorder;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class JImageJ
extends JPanel
implements ActionListener {
    protected BufferedImage theImage = null;
    protected Insets margin;
    protected int xOrg;
    protected int yOrg;
    protected boolean snapToGrid;
    protected int grid = 16;
    protected JLAxis xAxis;
    protected int xAxisHeight;
    protected int xAxisUpMargin;
    protected JLAxis yAxis;
    protected int yAxisWidth;
    protected int yAxisRightMargin;
    protected boolean crossCursor = false;
    protected Color cursorColor = Color.WHITE;
    protected int xCursor = -1;
    protected int yCursor = -1;
    protected Color roiColor = Color.RED;
    protected Color roiSelectionColor = Color.BLACK;
    protected Color roiInsideColor = Color.MAGENTA;
    protected Color roiInsideSelectionColor = new Color(255, 100, 255);
    protected Color roiOutsideColor = new Color(0, 200, 0);
    protected Color roiOutsideSelectionColor = Color.GREEN;
    protected AdvancedImagePlus imp;
    protected RenderedImageCanvas canvas;
    protected ImageJ hiddenIJ;
    protected CanvasRenderer canvasRenderer;
    protected JScrollPane imagePane;
    protected JPanel toolbarPanel;
    protected JToggleButton rectangleButton;
    protected JToggleButton ellipseButton;
    protected JToggleButton freeHandButton;
    protected JToggleButton polygonButton;
    protected JToggleButton lineButton;
    protected JToggleButton angleButton;
    protected JToggleButton wandButton;
    protected JToggleButton zoomButton;
    protected JToggleButton arrowButton;
    protected JButton clearButton;
    protected JButton deleteButton;
    protected JToggleButton allButton;
    protected JToggleButton selectedButton;
    protected JButton innerButton;
    protected JButton outerButton;
    protected JButton maskButton;
    protected JButton invalidateButton;
    protected JButton resetButton;
    protected JButton intersectionButton;
    protected JButton unionButton;
    protected JButton substractButton;
    protected JButton xorButton;
    protected JButton undoButton;
    protected JButton redoButton;
    protected String rectangleTitle = "Rectangle ROI";
    protected String ellipseTitle = "Ellipse ROI";
    protected String freeHandTitle = "Free Draw ROI";
    protected String polygonTitle = "Polygon ROI";
    protected String lineTitle = "Line";
    protected String angleTitle = "Angle";
    protected String wandTitle = "Magic Wand";
    protected String zoomTitle = "Zoom";
    protected String selectionTitle = "Selection Mode";
    protected String deleteTitle = "Delete Selected ROI";
    protected String deleteUndoRedoTitle = "ROI deletion";
    protected String clearTitle = "Delete All ROIs";
    protected String clearUndoRedoTitle = "ROI deletion";
    protected String innerTitle = "Interior ROI";
    protected String outerTitle = "Exterior ROI";
    protected String maskTitle = "Apply Mask";
    protected String maskUndoRedoTitle = "mask";
    protected String invalidateTitle = "Invalidate ROI";
    protected String resetTitle = "Reset Image";
    protected String resetUndoRedoTitle = "Reset Image";
    protected String intersectionTitle = "ROI intersection";
    protected String intersectionUndoRedoTitle = "intersection";
    protected String unionTitle = "ROI union";
    protected String unionUndoRedoTitle = "union";
    protected String substractTitle = "ROI substraction";
    protected String substractUndoRedoTitle = "substraction";
    protected String xorTitle = "ROI xor";
    protected String xorUndoRedoTitle = "xor";
    protected String undoTitle = "Undo";
    protected String redoTitle = "Redo";
    protected UndoManager undoManager = new UndoManager();
    protected static final int undoLimit = 1;
    protected String ignoreROITitle;
    protected String ignoreROIMessage;
    protected String ignoreROIContinueMessage;
    protected String deleteAllROIsTitle;
    protected String deleteAllROIsMessage;
    protected static final Insets NO_MARGIN = new Insets(0, 0, 0, 0);

    public JImageJ() {
        this.undoManager.setLimit(1);
        this.initMessages();
        this.hiddenIJ = new ImageJ(){

            public void show() {
            }

            public void setVisible(boolean bl) {
                if (!bl) {
                    super.setVisible(bl);
                }
            }
        };
        this.imp = new AdvancedImagePlus();
        this.canvasRenderer = new CanvasRenderer();
        this.canvas = new RenderedImageCanvas(this.imp);
        this.canvas.removeMouseListener((MouseListener)((Object)this.canvas));
        this.canvas.removeMouseMotionListener((MouseMotionListener)((Object)this.canvas));
        this.imagePane = new JScrollPane(this.canvasRenderer);
        new HiddenWindow(this.imp, this.canvas);
        this.setLayout(new GridBagLayout());
        this.initToolbar();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.toolbarPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.add((Component)this.imagePane, gridBagConstraints2);
        Toolbar.getInstance().setEnabled(true);
        this.setBorder(null);
        this.setBackground(new Color(180, 180, 200));
        this.setOpaque(true);
        this.setMargin(new Insets(5, 5, 5, 5));
        this.xOrg = 5;
        this.yOrg = 5;
        this.snapToGrid = false;
        this.yAxis = new JLAxis(this.canvasRenderer, 6);
        this.yAxis.setAxisColor(Color.BLACK);
        this.yAxis.setFont(ATKConstant.labelFont);
        this.yAxis.setAutoScale(false);
        this.yAxis.setMinimum(0.0);
        this.yAxis.setMaximum(100.0);
        this.yAxis.setVisible(false);
        this.yAxis.setInverted(false);
        this.xAxis = new JLAxis(this, 2);
        this.xAxis.setAxisColor(Color.BLACK);
        this.xAxis.setFont(ATKConstant.labelFont);
        this.xAxis.setAutoScale(false);
        this.xAxis.setMinimum(0.0);
        this.xAxis.setMaximum(100.0);
        this.xAxis.setVisible(false);
        Roi.setColor((Color)this.roiColor);
    }

    protected void initToolbar() {
        this.toolbarPanel = new JPanel();
        this.toolbarPanel.setBackground(this.canvas.getBackground());
        Dimension dimension = new Dimension(396, 18);
        this.toolbarPanel.setPreferredSize(dimension);
        this.toolbarPanel.setMinimumSize(dimension);
        dimension = null;
        this.toolbarPanel.setLayout(null);
        this.rectangleButton = new JToggleButton();
        this.rectangleButton.setMargin(NO_MARGIN);
        this.rectangleButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.rectangleButton.setToolTipText(this.rectangleTitle);
        this.rectangleButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/rectangle.gif")));
        this.rectangleButton.addActionListener(this);
        this.rectangleButton.setBounds(0, 0, 18, 18);
        this.rectangleButton.setBackground(Color.WHITE);
        this.rectangleButton.setSelected(true);
        this.selectedButton = this.rectangleButton;
        this.toolbarPanel.add(this.rectangleButton);
        this.ellipseButton = new JToggleButton();
        this.ellipseButton.setMargin(NO_MARGIN);
        this.ellipseButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.ellipseButton.setToolTipText(this.ellipseTitle);
        this.ellipseButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/ellipse.gif")));
        this.ellipseButton.addActionListener(this);
        this.ellipseButton.setBounds(18, 0, 18, 18);
        this.ellipseButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.ellipseButton);
        this.polygonButton = new JToggleButton();
        this.polygonButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.polygonButton.setMargin(NO_MARGIN);
        this.polygonButton.setToolTipText(this.polygonTitle);
        this.polygonButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/polygon.gif")));
        this.polygonButton.addActionListener(this);
        this.polygonButton.setBounds(36, 0, 18, 18);
        this.polygonButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.polygonButton);
        this.freeHandButton = new JToggleButton();
        this.freeHandButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.freeHandButton.setMargin(NO_MARGIN);
        this.freeHandButton.setToolTipText(this.freeHandTitle);
        this.freeHandButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/freeHand.gif")));
        this.freeHandButton.addActionListener(this);
        this.freeHandButton.setBounds(54, 0, 18, 18);
        this.freeHandButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.freeHandButton);
        this.lineButton = new JToggleButton();
        this.lineButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.lineButton.setMargin(NO_MARGIN);
        this.lineButton.setToolTipText(this.lineTitle);
        this.lineButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/line.gif")));
        this.lineButton.addActionListener(this);
        this.lineButton.setBounds(72, 0, 18, 18);
        this.lineButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.lineButton);
        this.angleButton = new JToggleButton();
        this.angleButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.angleButton.setMargin(NO_MARGIN);
        this.angleButton.setToolTipText(this.angleTitle);
        this.angleButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/angle.gif")));
        this.angleButton.addActionListener(this);
        this.angleButton.setBounds(90, 0, 18, 18);
        this.angleButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.angleButton);
        this.wandButton = new JToggleButton();
        this.wandButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.wandButton.setMargin(NO_MARGIN);
        this.wandButton.setToolTipText(this.wandTitle);
        this.wandButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/wand.gif")));
        this.wandButton.addActionListener(this);
        this.wandButton.setBounds(108, 0, 18, 18);
        this.wandButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.wandButton);
        this.zoomButton = new JToggleButton();
        this.zoomButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.zoomButton.setMargin(NO_MARGIN);
        this.zoomButton.setToolTipText(this.zoomTitle);
        this.zoomButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/zoom.gif")));
        this.zoomButton.addActionListener(this);
        this.zoomButton.setBounds(126, 0, 18, 18);
        this.zoomButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.zoomButton);
        this.arrowButton = new JToggleButton();
        this.arrowButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.arrowButton.setMargin(NO_MARGIN);
        this.arrowButton.setToolTipText(this.selectionTitle);
        this.arrowButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/arrow.gif")));
        this.arrowButton.addActionListener(this);
        this.arrowButton.setBounds(144, 0, 18, 18);
        this.arrowButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.arrowButton);
        this.deleteButton = new JButton();
        this.deleteButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.deleteButton.setMargin(NO_MARGIN);
        this.deleteButton.setToolTipText(this.deleteTitle);
        this.deleteButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/delete.gif")));
        this.deleteButton.addActionListener(this);
        this.deleteButton.setBounds(162, 0, 18, 18);
        this.deleteButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.deleteButton);
        this.clearButton = new JButton();
        this.clearButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.clearButton.setMargin(NO_MARGIN);
        this.clearButton.setToolTipText(this.clearTitle);
        this.clearButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/clear.gif")));
        this.clearButton.addActionListener(this);
        this.clearButton.setBounds(180, 0, 18, 18);
        this.clearButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.clearButton);
        this.innerButton = new JButton();
        this.innerButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.innerButton.setMargin(NO_MARGIN);
        this.innerButton.setToolTipText(this.innerTitle);
        this.innerButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/interiorRoi.png")));
        this.innerButton.addActionListener(this);
        this.innerButton.setBounds(198, 0, 18, 18);
        this.innerButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.innerButton);
        this.outerButton = new JButton();
        this.outerButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.outerButton.setMargin(NO_MARGIN);
        this.outerButton.setToolTipText(this.outerTitle);
        this.outerButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/exteriorRoi.png")));
        this.outerButton.addActionListener(this);
        this.outerButton.setBounds(216, 0, 18, 18);
        this.outerButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.outerButton);
        this.maskButton = new JButton();
        this.maskButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.maskButton.setMargin(NO_MARGIN);
        this.maskButton.setToolTipText(this.maskTitle);
        this.maskButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/mask.gif")));
        this.maskButton.addActionListener(this);
        this.maskButton.setBounds(234, 0, 18, 18);
        this.maskButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.maskButton);
        this.invalidateButton = new JButton();
        this.invalidateButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.invalidateButton.setMargin(NO_MARGIN);
        this.invalidateButton.setToolTipText(this.invalidateTitle);
        this.invalidateButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/invalidate.gif")));
        this.invalidateButton.addActionListener(this);
        this.invalidateButton.setBounds(252, 0, 18, 18);
        this.invalidateButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.invalidateButton);
        this.resetButton = new JButton();
        this.resetButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.resetButton.setMargin(NO_MARGIN);
        this.resetButton.setToolTipText(this.resetTitle);
        this.resetButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/reset.gif")));
        this.resetButton.addActionListener(this);
        this.resetButton.setBounds(270, 0, 18, 18);
        this.resetButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.resetButton);
        this.intersectionButton = new JButton();
        this.intersectionButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.intersectionButton.setMargin(NO_MARGIN);
        this.intersectionButton.setToolTipText(this.intersectionTitle);
        this.intersectionButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/intersection.gif")));
        this.intersectionButton.addActionListener(this);
        this.intersectionButton.setBounds(288, 0, 18, 18);
        this.intersectionButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.intersectionButton);
        this.unionButton = new JButton();
        this.unionButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.unionButton.setMargin(NO_MARGIN);
        this.unionButton.setToolTipText(this.unionTitle);
        this.unionButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/union.gif")));
        this.unionButton.addActionListener(this);
        this.unionButton.setBounds(306, 0, 18, 18);
        this.unionButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.unionButton);
        this.substractButton = new JButton();
        this.substractButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.substractButton.setMargin(NO_MARGIN);
        this.substractButton.setToolTipText(this.substractTitle);
        this.substractButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/substract.gif")));
        this.substractButton.addActionListener(this);
        this.substractButton.setBounds(324, 0, 18, 18);
        this.substractButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.substractButton);
        this.xorButton = new JButton();
        this.xorButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.xorButton.setMargin(NO_MARGIN);
        this.xorButton.setToolTipText(this.xorTitle);
        this.xorButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/xor.gif")));
        this.xorButton.addActionListener(this);
        this.xorButton.setBounds(342, 0, 18, 18);
        this.xorButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.xorButton);
        this.undoButton = new JButton();
        this.undoButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.undoButton.setMargin(NO_MARGIN);
        this.undoButton.setToolTipText(this.undoTitle);
        this.undoButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/undo.gif")));
        this.undoButton.addActionListener(this);
        this.undoButton.setBounds(360, 0, 18, 18);
        this.undoButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.undoButton);
        this.redoButton = new JButton();
        this.redoButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.redoButton.setMargin(NO_MARGIN);
        this.redoButton.setToolTipText(this.redoTitle);
        this.redoButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/redo.gif")));
        this.redoButton.addActionListener(this);
        this.redoButton.setBounds(378, 0, 18, 18);
        this.redoButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.redoButton);
        this.updateUndoRedoButtons();
        Toolbar.getInstance().setTool(0);
    }

    protected void updateUndoRedoButtons() {
        String string = this.undoManager.getUndoPresentationName();
        if (string != null && !"".equals(string.trim())) {
            this.undoButton.setToolTipText(string);
        }
        this.undoButton.setEnabled(this.undoManager.canUndo());
        string = this.undoManager.getRedoPresentationName();
        if (string != null && !"".equals(string.trim())) {
            this.redoButton.setToolTipText(string);
        }
        this.redoButton.setEnabled(this.undoManager.canRedo());
    }

    protected void initMessages() {
        this.ignoreROITitle = "Warning! ROI ignored";
        this.ignoreROIMessage = "The following ROI will be ignored:\n";
        this.ignoreROIContinueMessage = "Do you wish to continue ?";
        this.deleteAllROIsTitle = "Please confirm action";
        this.deleteAllROIsMessage = "Delete all ROIs ?";
    }

    public void setMargin(Insets insets) {
        this.margin = insets;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public AdvancedImagePlus getImagePlus() {
        return this.imp;
    }

    protected void measureAxis() {
        this.xAxisHeight = 0;
        this.yAxisWidth = 0;
        this.xAxisUpMargin = Toolbar.getInstance().getHeight() + 7;
        this.yAxisRightMargin = 15;
        Dimension dimension = this.canvas.getPreferredSize();
        int n = dimension.width;
        int n2 = dimension.height;
        dimension = null;
        if (this.xAxis.isVisible()) {
            this.xAxis.measureAxis(ATKGraphicsUtils.getDefaultRenderContext(), n, 0);
            this.xAxisHeight = this.xAxis.getThickness();
        }
        if (this.yAxis.isVisible()) {
            this.yAxis.measureAxis(ATKGraphicsUtils.getDefaultRenderContext(), 0, n2);
            this.yAxisWidth = this.yAxis.getThickness();
        }
    }

    protected void paintAxis(Graphics graphics) {
        Dimension dimension = this.canvas.getPreferredSize();
        int n = dimension.width;
        int n2 = dimension.height;
        dimension = null;
        if (this.yAxis.isVisible()) {
            if (this.yAxis.getOrientation() == 5) {
                this.yAxis.paintAxisDirect(graphics, ATKGraphicsUtils.getDefaultRenderContext(), n - this.yAxis.getThickness(), 0, Color.BLACK, 0, 0);
                if (this.yAxis.isDrawOpposite()) {
                    this.yAxis.paintAxisOpposite(graphics, ATKGraphicsUtils.getDefaultRenderContext(), -this.yAxis.getThickness(), 0, Color.BLACK, 0, 0);
                }
            } else {
                this.yAxis.paintAxisDirect(graphics, ATKGraphicsUtils.getDefaultRenderContext(), -this.yAxis.getThickness(), 0, Color.BLACK, 0, 0);
                if (this.yAxis.isDrawOpposite()) {
                    this.yAxis.paintAxisOpposite(graphics, ATKGraphicsUtils.getDefaultRenderContext(), n - this.yAxis.getThickness(), 0, Color.BLACK, 0, 0);
                }
            }
        }
        if (this.xAxis.isVisible()) {
            if (this.xAxis.getOrientation() == 2) {
                this.xAxis.paintAxisDirect(graphics, ATKGraphicsUtils.getDefaultRenderContext(), 0, 0, Color.BLACK, 0, 0);
                if (this.xAxis.isDrawOpposite()) {
                    this.xAxis.paintAxisOpposite(graphics, ATKGraphicsUtils.getDefaultRenderContext(), 0, n2, Color.BLACK, 0, 0);
                }
            } else {
                this.xAxis.paintAxisDirect(graphics, ATKGraphicsUtils.getDefaultRenderContext(), 0, n2, Color.BLACK, 0, 0);
                if (this.xAxis.isDrawOpposite()) {
                    this.xAxis.paintAxisOpposite(graphics, ATKGraphicsUtils.getDefaultRenderContext(), 0, 0, Color.BLACK, 0, 0);
                }
            }
        }
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.toolbarPanel.getPreferredSize();
        int n = dimension.width;
        return new Dimension(n, 100);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JToggleButton) {
            if (this.selectedButton != null) {
                this.selectedButton.setSelected(false);
            }
            this.selectedButton = (JToggleButton)actionEvent.getSource();
            this.selectedButton.setSelected(true);
        }
        if (actionEvent.getSource() == this.rectangleButton) {
            Toolbar.getInstance().setTool(0);
            this.canvas.setSelectionMode(false);
        } else if (actionEvent.getSource() == this.ellipseButton) {
            Toolbar.getInstance().setTool(1);
            this.canvas.setSelectionMode(false);
        } else if (actionEvent.getSource() == this.polygonButton) {
            Toolbar.getInstance().setTool(2);
            this.canvas.setSelectionMode(false);
        } else if (actionEvent.getSource() == this.freeHandButton) {
            Toolbar.getInstance().setTool(3);
            this.canvas.setSelectionMode(false);
        } else if (actionEvent.getSource() == this.lineButton) {
            Toolbar.getInstance().setTool(4);
            this.canvas.setSelectionMode(false);
        } else if (actionEvent.getSource() == this.angleButton) {
            Toolbar.getInstance().setTool(14);
            this.canvas.setSelectionMode(false);
        } else if (actionEvent.getSource() == this.wandButton) {
            Toolbar.getInstance().setTool(8);
            this.canvas.setSelectionMode(false);
        } else if (actionEvent.getSource() == this.zoomButton) {
            Toolbar.getInstance().setTool(11);
            this.canvas.setSelectionMode(false);
        } else if (actionEvent.getSource() == this.arrowButton) {
            Toolbar.getInstance().setTool(0);
            this.canvas.setSelectionMode(true);
        } else if (actionEvent.getSource() == this.deleteButton) {
            this.deleteSelectedRois();
        } else if (actionEvent.getSource() == this.clearButton) {
            this.deleteAllROIs();
        } else if (actionEvent.getSource() == this.innerButton) {
            this.setSelectedRoisAsInner();
        } else if (actionEvent.getSource() == this.outerButton) {
            this.setSelectedRoisAsOuter();
        } else if (actionEvent.getSource() == this.maskButton) {
            this.applyMask();
        } else if (actionEvent.getSource() == this.invalidateButton) {
            this.invalidateROI();
        } else if (actionEvent.getSource() == this.resetButton) {
            this.resetMask();
        } else if (actionEvent.getSource() == this.intersectionButton) {
            this.intersectROIs();
        } else if (actionEvent.getSource() == this.unionButton) {
            this.unifyROIs();
        } else if (actionEvent.getSource() == this.substractButton) {
            this.substractROIs();
        } else if (actionEvent.getSource() == this.xorButton) {
            this.xorROIs();
        } else if (actionEvent.getSource() == this.undoButton) {
            this.undo();
        } else if (actionEvent.getSource() == this.redoButton) {
            this.redo();
        }
        this.canvasRenderer.grabFocus();
        this.repaint();
    }

    public Toolbar getToolbar() {
        return Toolbar.getInstance();
    }

    public void setImage(BufferedImage bufferedImage) {
        if (this.theImage != bufferedImage) {
            BufferedImage bufferedImage2 = this.theImage;
            this.theImage = bufferedImage;
            this.imp.killRoi();
            this.imp.setWindow(null);
            if (this.theImage != null) {
                this.imp.setImage(this.theImage);
            }
            if (bufferedImage2 != null) {
                bufferedImage2.flush();
                bufferedImage2 = null;
            }
            this.canvas = new RenderedImageCanvas(this.imp);
            this.canvas.removeMouseListener((MouseListener)((Object)this.canvas));
            this.canvas.removeMouseMotionListener((MouseMotionListener)((Object)this.canvas));
            new HiddenWindow(this.imp, this.canvas);
            this.revalidate();
            this.repaint();
        }
    }

    public void refreshImage() {
        if (this.imp != null && this.theImage != null) {
            Image image = this.imp.getImage();
            Roi roi = this.imp.getRoi();
            this.imp.setImage(this.theImage);
            this.imp.setRoi(roi);
            if (image != null) {
                image.flush();
                image = null;
            }
        }
        this.repaint();
    }

    public void setZoom(double d) {
        if (this.canvas != null) {
            this.canvas.computeZoom(d);
            this.canvasRenderer.revalidate();
            this.imagePane.setViewportView(this.canvasRenderer);
            this.revalidate();
            this.repaint();
        }
    }

    public void setZoomRoi(Roi roi) {
        if (this.canvas != null) {
            this.canvas.computeZoom(roi);
            this.imp.removeRoi(roi);
        }
    }

    public double getZoom() {
        if (this.canvas == null) {
            return 1.0;
        }
        return this.canvas.getMagnification();
    }

    public JLAxis getXAxis() {
        return this.xAxis;
    }

    public JLAxis getYAxis() {
        return this.yAxis;
    }

    public BufferedImage getImage() {
        return this.theImage;
    }

    public Dimension getImageSize() {
        if (this.theImage != null) {
            return new Dimension(this.theImage.getWidth(), this.theImage.getHeight());
        }
        return new Dimension(0, 0);
    }

    public int getXOrigin() {
        return this.xOrg + this.yAxis.getThickness();
    }

    public int getYOrigin() {
        return this.yOrg + this.xAxisUpMargin;
    }

    public Point[] getSelectionPoint() {
        if (this.imp != null && this.imp.getSelectedRois() != null) {
            for (int i = 0; i < this.imp.getSelectedRois().size(); ++i) {
                if (!(this.imp.getSelectedRois().get(i) instanceof Line)) continue;
                Line line = (Line)this.imp.getSelectedRois().get(i);
                Point[] pointArray = new Point[]{new Point(line.x1, line.y1), new Point(line.x2, line.y2)};
                line = null;
                return pointArray;
            }
        }
        return null;
    }

    public Rectangle getCurrentRoiBounds() {
        Roi roi;
        if (this.imp != null && this.imp.getRoi() != null && (roi = this.imp.getRoi()) != null) {
            return roi.getBounds();
        }
        return null;
    }

    public void deleteAllROIs() {
        int n;
        if (this.imp != null && (n = JOptionPane.showConfirmDialog(this, this.deleteAllROIsMessage, this.deleteAllROIsTitle, 0)) == 0) {
            Vector<Roi> vector = new Vector<Roi>();
            vector.addAll(this.imp.getAllRois());
            Vector<Roi> vector2 = new Vector<Roi>();
            vector2.addAll(this.imp.getSelectedRois());
            Vector<Roi> vector3 = new Vector<Roi>();
            vector3.addAll(this.imp.getInnerRois());
            Vector<Roi> vector4 = new Vector<Roi>();
            vector4.addAll(this.imp.getOuterRois());
            Roi roi = this.imp.getValidatedRoi();
            Roi roi2 = this.imp.getRoi();
            this.imp.killRoi();
            this.imp.getAllRois().clear();
            this.imp.getInnerRois().clear();
            this.imp.getOuterRois().clear();
            this.imp.setValidatedRoi(null);
            this.undoManager.addEdit(new RoiDefaultUndoableEdit(this.imp, vector, vector2, vector3, vector4, roi, roi2, this.clearTitle));
            vector = null;
            vector2 = null;
            vector3 = null;
            vector4 = null;
            roi = null;
            roi2 = null;
            this.updateUndoRedoButtons();
            this.revalidate();
            this.repaint();
        }
    }

    public void deleteSelectedRois() {
        if (this.imp != null) {
            Vector<Roi> vector = new Vector<Roi>();
            vector.addAll(this.imp.getAllRois());
            Vector<Roi> vector2 = new Vector<Roi>();
            vector2.addAll(this.imp.getSelectedRois());
            Vector<Roi> vector3 = new Vector<Roi>();
            vector3.addAll(this.imp.getInnerRois());
            Vector<Roi> vector4 = new Vector<Roi>();
            vector4.addAll(this.imp.getOuterRois());
            Roi roi = this.imp.getValidatedRoi();
            Roi roi2 = this.imp.getRoi();
            this.imp.deleteSelectedRois();
            this.undoManager.addEdit(new RoiDefaultUndoableEdit(this.imp, vector, vector2, vector3, vector4, roi, roi2, this.deleteUndoRedoTitle));
            vector = null;
            vector2 = null;
            vector3 = null;
            vector4 = null;
            roi = null;
            roi2 = null;
            this.updateUndoRedoButtons();
            this.revalidate();
            this.repaint();
        }
    }

    public void setSelectedRoisAsInner() {
        Vector<Roi> vector = this.imp.getSelectedRois();
        Vector<Roi> vector2 = this.imp.getInnerRois();
        if (vector != null && vector2 != null) {
            for (int i = 0; i < vector.size(); ++i) {
                if (vector2.contains(vector.get(i))) continue;
                vector2.add(vector.get(i));
                if (vector.get(i) == this.imp.getRoi()) {
                    this.imp.setHandledRoi(null);
                }
                if (this.imp.getOuterRois() != null) {
                    this.imp.getOuterRois().remove(vector.get(i));
                }
                if (i != vector.size() - 1) continue;
                this.imp.setValidatedRoi(vector.get(i));
            }
            vector.clear();
            this.imp.getSelectedRois().add(this.imp.getValidatedRoi());
        }
        this.repaint();
    }

    public void setSelectedRoisAsOuter() {
        Vector<Roi> vector = this.imp.getSelectedRois();
        Vector<Roi> vector2 = this.imp.getOuterRois();
        if (vector != null && vector2 != null) {
            for (int i = 0; i < vector.size(); ++i) {
                if (vector2.contains(vector.get(i))) continue;
                vector2.add(vector.get(i));
                if (vector.get(i) == this.imp.getRoi()) {
                    this.imp.setHandledRoi(null);
                }
                if (this.imp.getInnerRois() != null) {
                    this.imp.getInnerRois().remove(vector.get(i));
                }
                if (i != vector.size() - 1) continue;
                this.imp.setValidatedRoi(vector.get(i));
            }
            vector.clear();
            this.imp.getSelectedRois().add(this.imp.getValidatedRoi());
        }
        this.repaint();
    }

    public void applyMask() {
        if (this.imp.getValidatedRoi() != null && this.getImage() != null) {
            ImageProcessor imageProcessor = this.imp.getProcessor();
            Roi roi = this.imp.getValidatedRoi();
            ColorProcessor colorProcessor = new ColorProcessor((Image)this.getImage());
            this.imp.setHandledRoi(roi);
            colorProcessor.setRoi(roi);
            colorProcessor.setColor(Toolbar.getBackgroundColor());
            Rectangle rectangle = roi.getBounds();
            Dimension dimension = this.getImageSize();
            int n = Math.max(rectangle.x, 0);
            if (dimension.width > 0 && n > dimension.width - 1) {
                n = dimension.width - 1;
            }
            int n2 = Math.max(rectangle.y, 0);
            if (dimension.height > 0 && n2 > dimension.height - 1) {
                n2 = dimension.height - 1;
            }
            int n3 = Math.min(dimension.width - n, rectangle.x + rectangle.width - n);
            int n4 = Math.min(dimension.height - n2, rectangle.y + rectangle.height - n2);
            rectangle.x = n;
            rectangle.y = n2;
            rectangle.width = n3;
            rectangle.height = n4;
            if (this.imp.getOuterRois().contains(roi)) {
                if (roi.getPolygon() == null || roi instanceof ShapeRoi) {
                    for (int i = 0; i < rectangle.width; ++i) {
                        for (int j = 0; j < rectangle.height; ++j) {
                            if (!roi.contains(i + rectangle.x, j + rectangle.y)) continue;
                            colorProcessor.drawPixel(i + rectangle.x, j + rectangle.y);
                        }
                    }
                } else {
                    colorProcessor.fillPolygon(roi.getPolygon());
                }
            } else {
                colorProcessor.setRoi(0, 0, rectangle.x, this.imp.getHeight());
                colorProcessor.fill();
                colorProcessor.setRoi(rectangle.x, 0, rectangle.width, rectangle.y);
                colorProcessor.fill();
                colorProcessor.setRoi(rectangle.x + rectangle.width, 0, this.imp.getWidth() - rectangle.x - rectangle.width, this.imp.getHeight());
                colorProcessor.fill();
                colorProcessor.setRoi(rectangle.x, rectangle.y + rectangle.height, rectangle.width, this.imp.getHeight() - rectangle.y - rectangle.height);
                colorProcessor.fill();
                for (int i = 0; i < rectangle.width; ++i) {
                    for (int j = 0; j < rectangle.height; ++j) {
                        if (roi.contains(i + rectangle.x, j + rectangle.y)) continue;
                        colorProcessor.drawPixel(i + rectangle.x, j + rectangle.y);
                    }
                }
            }
            dimension = null;
            colorProcessor.setColor(Toolbar.getForegroundColor());
            this.imp.setProcessor(null, (ImageProcessor)colorProcessor);
            this.undoManager.addEdit(new MaskUndoableEdit(this.imp, imageProcessor, this.maskUndoRedoTitle));
            imageProcessor = null;
            this.updateUndoRedoButtons();
            this.repaint();
            if (this.imp.getRoi() == roi) {
                this.imp.setHandledRoi(null);
            }
        }
    }

    public void resetMask() {
        if (this.imp != null && this.theImage != null) {
            ImageProcessor imageProcessor = this.imp.getProcessor();
            this.refreshImage();
            this.undoManager.addEdit(new MaskUndoableEdit(this.imp, imageProcessor, this.resetUndoRedoTitle));
            imageProcessor = null;
            this.updateUndoRedoButtons();
        }
    }

    public void invalidateROI() {
        Roi roi = this.imp.getValidatedRoi();
        if (roi != null) {
            this.imp.getInnerRois().remove(roi);
            this.imp.getOuterRois().remove(roi);
            this.imp.setValidatedRoi(null);
        }
        this.repaint();
    }

    public void setSelection(int n, int n2, int n3, int n4) {
        if (this.imp != null) {
            this.imp.getAllRois().clear();
            Roi roi = new Roi(n, n2, n3 - n, n4 - n2);
            this.imp.setRoi(roi);
        }
    }

    public int transformX(int n) {
        if (this.canvas == null) {
            return n;
        }
        return this.canvas.offScreenX(n);
    }

    public int transformY(int n) {
        if (this.canvas == null) {
            return n;
        }
        return this.canvas.offScreenY(n);
    }

    protected boolean canCombineROIs() {
        int n = 1;
        int n2 = this.imp.getSelectedRois().size();
        Roi roi = this.imp.getValidatedRoi();
        Vector<Integer> vector = new Vector<Integer>();
        if (n2 > 1) {
            for (int i = 0; i < this.imp.getSelectedRois().size(); ++i) {
                if (this.imp.getSelectedRois().get(i) != roi && !(this.imp.getSelectedRois().get(i) instanceof Line)) continue;
                vector.add(new Integer(i + 1));
                --n2;
            }
            if (vector.size() == 0) {
                n = 0;
            } else if (n2 > 1) {
                StringBuffer stringBuffer = new StringBuffer(this.ignoreROIMessage);
                stringBuffer.append(vector.get(0));
                for (int i = 1; i < vector.size(); ++i) {
                    stringBuffer.append(", ");
                    stringBuffer.append(vector.get(i));
                }
                stringBuffer.append("\n");
                stringBuffer.append(this.ignoreROIContinueMessage);
                n = JOptionPane.showConfirmDialog(this, stringBuffer.toString(), this.ignoreROITitle, 0);
                stringBuffer = null;
            }
        }
        roi = null;
        return n == 0;
    }

    public void intersectROIs() {
        if (this.canCombineROIs()) {
            Roi roi;
            Vector<Roi> vector = new Vector<Roi>();
            vector.addAll(this.imp.getAllRois());
            Vector<Roi> vector2 = new Vector<Roi>();
            vector2.addAll(this.imp.getSelectedRois());
            Vector<Roi> vector3 = new Vector<Roi>();
            vector3.addAll(this.imp.getInnerRois());
            Vector<Roi> vector4 = new Vector<Roi>();
            vector4.addAll(this.imp.getOuterRois());
            Roi roi2 = this.imp.getValidatedRoi();
            Roi roi3 = this.imp.getRoi();
            Vector<Roi> vector5 = new Vector<Roi>();
            for (int i = 0; i < this.imp.getSelectedRois().size(); ++i) {
                if (this.imp.getSelectedRois().get(i) != this.imp.getValidatedRoi() && !(this.imp.getSelectedRois().get(i) instanceof Line)) continue;
                vector5.add(this.imp.getSelectedRois().get(i));
            }
            if (vector5.size() > 0) {
                this.imp.getSelectedRois().removeAll(vector5);
            }
            ShapeRoi shapeRoi = (roi = this.imp.getSelectedRois().get(0)) instanceof ShapeRoi ? (ShapeRoi)roi : new ShapeRoi(roi);
            roi = null;
            for (int i = 1; i < this.imp.getSelectedRois().size(); ++i) {
                Roi roi4 = this.imp.getSelectedRois().get(i);
                ShapeRoi shapeRoi2 = roi4 instanceof ShapeRoi ? (ShapeRoi)roi4 : new ShapeRoi(roi4);
                roi4 = null;
                shapeRoi = shapeRoi.and(shapeRoi2);
                shapeRoi2 = null;
                if (shapeRoi == null) break;
                Rectangle rectangle = shapeRoi.getBounds();
                if (rectangle.width == 0 || rectangle.height == 0) {
                    shapeRoi = null;
                    rectangle = null;
                    break;
                }
                rectangle = null;
            }
            this.imp.getAllRois().removeAll(this.imp.getSelectedRois());
            this.imp.getSelectedRois().clear();
            this.imp.setRoi(null);
            this.imp.getSelectedRois().addAll(vector5);
            if (shapeRoi != null) {
                this.imp.getSelectedRois().add((Roi)shapeRoi);
                this.imp.getAllRois().add((Roi)shapeRoi);
                this.imp.setRoi((Roi)shapeRoi);
            }
            this.undoManager.addEdit(new RoiDefaultUndoableEdit(this.imp, vector, vector2, vector3, vector4, roi2, roi3, this.intersectionUndoRedoTitle));
            vector5.clear();
            vector5 = null;
            vector = null;
            vector2 = null;
            vector3 = null;
            vector4 = null;
            roi2 = null;
            roi3 = null;
            this.updateUndoRedoButtons();
            this.canvasRenderer.repaint();
        }
    }

    public void unifyROIs() {
        if (this.canCombineROIs()) {
            Roi roi;
            Vector<Roi> vector = new Vector<Roi>();
            vector.addAll(this.imp.getAllRois());
            Vector<Roi> vector2 = new Vector<Roi>();
            vector2.addAll(this.imp.getSelectedRois());
            Vector<Roi> vector3 = new Vector<Roi>();
            vector3.addAll(this.imp.getInnerRois());
            Vector<Roi> vector4 = new Vector<Roi>();
            vector4.addAll(this.imp.getOuterRois());
            Roi roi2 = this.imp.getValidatedRoi();
            Roi roi3 = this.imp.getRoi();
            Vector<Roi> vector5 = new Vector<Roi>();
            for (int i = 0; i < this.imp.getSelectedRois().size(); ++i) {
                if (this.imp.getSelectedRois().get(i) != this.imp.getValidatedRoi() && !(this.imp.getSelectedRois().get(i) instanceof Line)) continue;
                vector5.add(this.imp.getSelectedRois().get(i));
            }
            if (vector5.size() > 0) {
                this.imp.getSelectedRois().removeAll(vector5);
            }
            ShapeRoi shapeRoi = (roi = this.imp.getSelectedRois().get(0)) instanceof ShapeRoi ? (ShapeRoi)roi : new ShapeRoi(roi);
            roi = null;
            for (int i = 1; i < this.imp.getSelectedRois().size(); ++i) {
                Roi roi4 = this.imp.getSelectedRois().get(i);
                ShapeRoi shapeRoi2 = roi4 instanceof ShapeRoi ? (ShapeRoi)roi4 : new ShapeRoi(roi4);
                roi4 = null;
                shapeRoi = shapeRoi.or(shapeRoi2);
                shapeRoi2 = null;
                if (shapeRoi == null) break;
                Rectangle rectangle = shapeRoi.getBounds();
                if (rectangle.width == 0 || rectangle.height == 0) {
                    shapeRoi = null;
                    rectangle = null;
                    break;
                }
                rectangle = null;
            }
            this.imp.getAllRois().removeAll(this.imp.getSelectedRois());
            this.imp.getSelectedRois().clear();
            this.imp.setRoi(null);
            this.imp.getSelectedRois().addAll(vector5);
            if (shapeRoi != null) {
                this.imp.getSelectedRois().add((Roi)shapeRoi);
                this.imp.getAllRois().add((Roi)shapeRoi);
                this.imp.setRoi((Roi)shapeRoi);
            }
            this.undoManager.addEdit(new RoiDefaultUndoableEdit(this.imp, vector, vector2, vector3, vector4, roi2, roi3, this.unionUndoRedoTitle));
            vector5.clear();
            vector5 = null;
            vector = null;
            vector2 = null;
            vector3 = null;
            vector4 = null;
            roi2 = null;
            roi3 = null;
            this.updateUndoRedoButtons();
            this.canvasRenderer.repaint();
        }
    }

    public void substractROIs() {
        if (this.canCombineROIs()) {
            Roi roi;
            Vector<Roi> vector = new Vector<Roi>();
            vector.addAll(this.imp.getAllRois());
            Vector<Roi> vector2 = new Vector<Roi>();
            vector2.addAll(this.imp.getSelectedRois());
            Vector<Roi> vector3 = new Vector<Roi>();
            vector3.addAll(this.imp.getInnerRois());
            Vector<Roi> vector4 = new Vector<Roi>();
            vector4.addAll(this.imp.getOuterRois());
            Roi roi2 = this.imp.getValidatedRoi();
            Roi roi3 = this.imp.getRoi();
            Vector<Roi> vector5 = new Vector<Roi>();
            for (int i = 0; i < this.imp.getSelectedRois().size(); ++i) {
                if (this.imp.getSelectedRois().get(i) != this.imp.getValidatedRoi() && !(this.imp.getSelectedRois().get(i) instanceof Line)) continue;
                vector5.add(this.imp.getSelectedRois().get(i));
            }
            if (vector5.size() > 0) {
                this.imp.getSelectedRois().removeAll(vector5);
            }
            ShapeRoi shapeRoi = (roi = this.imp.getSelectedRois().get(0)) instanceof ShapeRoi ? (ShapeRoi)roi : new ShapeRoi(roi);
            roi = null;
            for (int i = 1; i < this.imp.getSelectedRois().size(); ++i) {
                Roi roi4 = this.imp.getSelectedRois().get(i);
                ShapeRoi shapeRoi2 = roi4 instanceof ShapeRoi ? (ShapeRoi)roi4 : new ShapeRoi(roi4);
                roi4 = null;
                shapeRoi = shapeRoi.not(shapeRoi2);
                shapeRoi2 = null;
                if (shapeRoi == null) break;
                Rectangle rectangle = shapeRoi.getBounds();
                if (rectangle.width == 0 || rectangle.height == 0) {
                    shapeRoi = null;
                    rectangle = null;
                    break;
                }
                rectangle = null;
            }
            this.imp.getAllRois().removeAll(this.imp.getSelectedRois());
            this.imp.getSelectedRois().clear();
            this.imp.setRoi(null);
            this.imp.getSelectedRois().addAll(vector5);
            if (shapeRoi != null) {
                this.imp.getSelectedRois().add((Roi)shapeRoi);
                this.imp.getAllRois().add((Roi)shapeRoi);
                this.imp.setRoi((Roi)shapeRoi);
            }
            this.undoManager.addEdit(new RoiDefaultUndoableEdit(this.imp, vector, vector2, vector3, vector4, roi2, roi3, this.substractUndoRedoTitle));
            vector5.clear();
            vector5 = null;
            vector = null;
            vector2 = null;
            vector3 = null;
            vector4 = null;
            roi2 = null;
            roi3 = null;
            this.updateUndoRedoButtons();
            this.canvasRenderer.repaint();
        }
    }

    public void xorROIs() {
        if (this.canCombineROIs()) {
            Roi roi;
            Vector<Roi> vector = new Vector<Roi>();
            vector.addAll(this.imp.getAllRois());
            Vector<Roi> vector2 = new Vector<Roi>();
            vector2.addAll(this.imp.getSelectedRois());
            Vector<Roi> vector3 = new Vector<Roi>();
            vector3.addAll(this.imp.getInnerRois());
            Vector<Roi> vector4 = new Vector<Roi>();
            vector4.addAll(this.imp.getOuterRois());
            Roi roi2 = this.imp.getValidatedRoi();
            Roi roi3 = this.imp.getRoi();
            Vector<Roi> vector5 = new Vector<Roi>();
            for (int i = 0; i < this.imp.getSelectedRois().size(); ++i) {
                if (this.imp.getSelectedRois().get(i) != this.imp.getValidatedRoi() && !(this.imp.getSelectedRois().get(i) instanceof Line)) continue;
                vector5.add(this.imp.getSelectedRois().get(i));
            }
            if (vector5.size() > 0) {
                this.imp.getSelectedRois().removeAll(vector5);
            }
            ShapeRoi shapeRoi = (roi = this.imp.getSelectedRois().get(0)) instanceof ShapeRoi ? (ShapeRoi)roi : new ShapeRoi(roi);
            roi = null;
            for (int i = 1; i < this.imp.getSelectedRois().size(); ++i) {
                Roi roi4 = this.imp.getSelectedRois().get(i);
                ShapeRoi shapeRoi2 = roi4 instanceof ShapeRoi ? (ShapeRoi)roi4 : new ShapeRoi(roi4);
                roi4 = null;
                shapeRoi = shapeRoi.xor(shapeRoi2);
                shapeRoi2 = null;
                if (shapeRoi == null) break;
                Rectangle rectangle = shapeRoi.getBounds();
                if (rectangle.width == 0 || rectangle.height == 0) {
                    shapeRoi = null;
                    rectangle = null;
                    break;
                }
                rectangle = null;
            }
            this.imp.getAllRois().removeAll(this.imp.getSelectedRois());
            this.imp.getSelectedRois().clear();
            this.imp.setRoi(null);
            this.imp.getSelectedRois().addAll(vector5);
            if (shapeRoi != null) {
                this.imp.getSelectedRois().add((Roi)shapeRoi);
                this.imp.getAllRois().add((Roi)shapeRoi);
                this.imp.setRoi((Roi)shapeRoi);
            }
            this.undoManager.addEdit(new RoiDefaultUndoableEdit(this.imp, vector, vector2, vector3, vector4, roi2, roi3, this.xorUndoRedoTitle));
            vector5.clear();
            vector5 = null;
            vector = null;
            vector2 = null;
            vector3 = null;
            vector4 = null;
            roi2 = null;
            roi3 = null;
            this.updateUndoRedoButtons();
            this.canvasRenderer.repaint();
        }
    }

    public void undo() {
        if (this.undoManager.canUndo()) {
            try {
                this.undoManager.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
        }
        this.updateUndoRedoButtons();
    }

    public void redo() {
        if (this.undoManager.canRedo()) {
            try {
                this.undoManager.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
        }
        this.updateUndoRedoButtons();
    }

    public Color getRoiColor() {
        return this.roiColor;
    }

    public void setRoiColor(Color color) {
        this.roiColor = color;
        Roi.setColor((Color)color);
    }

    public Color getRoiSelectionColor() {
        return this.roiSelectionColor;
    }

    public void setRoiSelectionColor(Color color) {
        this.roiSelectionColor = color;
    }

    public Color getRoiInsideColor() {
        return this.roiInsideColor;
    }

    public void setRoiInsideColor(Color color) {
        this.roiInsideColor = color;
    }

    public Color getRoiInsideSelectionColor() {
        return this.roiInsideSelectionColor;
    }

    public void setRoiInsideSelectionColor(Color color) {
        this.roiInsideSelectionColor = color;
    }

    public Color getRoiOutsideColor() {
        return this.roiOutsideColor;
    }

    public void setRoiOutsideColor(Color color) {
        this.roiOutsideColor = color;
    }

    public Color getRoiOutsideSelectionColor() {
        return this.roiOutsideSelectionColor;
    }

    public void setRoiOutsideSelectionColor(Color color) {
        this.roiOutsideSelectionColor = color;
    }

    public JComponent getImageRenderer() {
        return this.canvasRenderer;
    }

    public JScrollPane getImagePane() {
        return this.imagePane;
    }

    public String getIgnoreROITitle() {
        return this.ignoreROITitle;
    }

    public void setIgnoreROITitle(String string) {
        this.ignoreROITitle = string;
    }

    public void setIgnoreValidatedROITitle(String string) {
        this.ignoreROITitle = string;
    }

    public String getIgnoreROIMessage() {
        return this.ignoreROIMessage;
    }

    public void setIgnoreValidatedROIMessage(String string) {
        this.ignoreROIMessage = string;
    }

    public String getIgnoreROIContinueMessage() {
        return this.ignoreROIContinueMessage;
    }

    public void setIgnoreValidatedROIContinueMessage(String string) {
        this.ignoreROIContinueMessage = string;
    }

    public String getDeleteAllROIsTitle() {
        return this.deleteAllROIsTitle;
    }

    public void setDeleteAllROIsTitle(String string) {
        this.deleteAllROIsTitle = string;
    }

    public String getDeleteAllROIsMessage() {
        return this.deleteAllROIsMessage;
    }

    public void setDeleteAllROIsMessage(String string) {
        this.deleteAllROIsMessage = string;
    }

    public JPanel getToolbarPanel() {
        return this.toolbarPanel;
    }

    public JToggleButton getRectangleButton() {
        return this.rectangleButton;
    }

    public JToggleButton getEllipseButton() {
        return this.ellipseButton;
    }

    public JToggleButton getFreeHandButton() {
        return this.freeHandButton;
    }

    public JToggleButton getPolygonButton() {
        return this.polygonButton;
    }

    public JToggleButton getLineButton() {
        return this.lineButton;
    }

    public JToggleButton getAngleButton() {
        return this.angleButton;
    }

    public JToggleButton getWandButton() {
        return this.wandButton;
    }

    public JToggleButton getZoomButton() {
        return this.zoomButton;
    }

    public JToggleButton getArrowButton() {
        return this.arrowButton;
    }

    public JButton getClearButton() {
        return this.clearButton;
    }

    public JButton getDeleteButton() {
        return this.deleteButton;
    }

    public JToggleButton getAllButton() {
        return this.allButton;
    }

    public JToggleButton getSelectedButton() {
        return this.selectedButton;
    }

    public JButton getInnerButton() {
        return this.innerButton;
    }

    public JButton getOuterButton() {
        return this.outerButton;
    }

    public JButton getMaskButton() {
        return this.maskButton;
    }

    public JButton getInvalidateButton() {
        return this.invalidateButton;
    }

    public JButton getResetButton() {
        return this.resetButton;
    }

    public JButton getIntersectionButton() {
        return this.intersectionButton;
    }

    public JButton getUnionButton() {
        return this.unionButton;
    }

    public JButton getSubstractButton() {
        return this.substractButton;
    }

    public JButton getXorButton() {
        return this.xorButton;
    }

    public String getRectangleTitle() {
        return this.rectangleTitle;
    }

    public void setRectangleTitle(String string) {
        this.rectangleTitle = string;
        this.rectangleButton.setToolTipText(string);
    }

    public String getEllipseTitle() {
        return this.ellipseTitle;
    }

    public void setEllipseTitle(String string) {
        this.ellipseTitle = string;
        this.ellipseButton.setToolTipText(string);
    }

    public String getFreeHandTitle() {
        return this.freeHandTitle;
    }

    public void setFreeHandTitle(String string) {
        this.freeHandTitle = string;
        this.freeHandButton.setToolTipText(string);
    }

    public String getPolygonTitle() {
        return this.polygonTitle;
    }

    public void setPolygonTitle(String string) {
        this.polygonTitle = string;
        this.polygonButton.setToolTipText(string);
    }

    public String getLineTitle() {
        return this.lineTitle;
    }

    public void setLineTitle(String string) {
        this.lineTitle = string;
        this.lineButton.setToolTipText(string);
    }

    public String getAngleTitle() {
        return this.angleTitle;
    }

    public void setAngleTitle(String string) {
        this.angleTitle = string;
        this.angleButton.setToolTipText(string);
    }

    public String getWandTitle() {
        return this.wandTitle;
    }

    public void setWandTitle(String string) {
        this.wandTitle = string;
        this.wandButton.setToolTipText(string);
    }

    public String getZoomTitle() {
        return this.zoomTitle;
    }

    public void setZoomTitle(String string) {
        this.zoomTitle = string;
        this.zoomButton.setToolTipText(string);
    }

    public String getSelectionTitle() {
        return this.selectionTitle;
    }

    public void setSelectionTitle(String string) {
        this.selectionTitle = string;
        this.selectedButton.setToolTipText(string);
    }

    public String getDeleteTitle() {
        return this.deleteTitle;
    }

    public void setDeleteTitle(String string) {
        this.deleteTitle = string;
        this.deleteButton.setToolTipText(string);
    }

    public String getDeleteUndoRedoTitle() {
        return this.deleteUndoRedoTitle;
    }

    public void setDeleteUndoRedoTitle(String string) {
        this.deleteUndoRedoTitle = string;
    }

    public String getClearTitle() {
        return this.clearTitle;
    }

    public void setClearTitle(String string) {
        this.clearTitle = string;
        this.clearButton.setToolTipText(string);
    }

    public String getClearUndoRedoTitle() {
        return this.clearUndoRedoTitle;
    }

    public void setClearUndoRedoTitle(String string) {
        this.clearUndoRedoTitle = string;
    }

    public String getInnerTitle() {
        return this.innerTitle;
    }

    public void setInnerTitle(String string) {
        this.innerTitle = string;
        this.innerButton.setToolTipText(string);
    }

    public String getOuterTitle() {
        return this.outerTitle;
    }

    public void setOuterTitle(String string) {
        this.outerTitle = string;
        this.outerButton.setToolTipText(string);
    }

    public String getMaskTitle() {
        return this.maskTitle;
    }

    public void setMaskTitle(String string) {
        this.maskTitle = string;
        this.maskButton.setToolTipText(string);
    }

    public String getMaskUndoRedoTitle() {
        return this.maskUndoRedoTitle;
    }

    public void setMaskUndoRedoTitle(String string) {
        this.maskUndoRedoTitle = string;
    }

    public String getInvalidateTitle() {
        return this.invalidateTitle;
    }

    public void setInvalidateTitle(String string) {
        this.invalidateTitle = string;
        this.invalidateButton.setToolTipText(string);
    }

    public String getResetTitle() {
        return this.resetTitle;
    }

    public void setResetTitle(String string) {
        this.resetTitle = string;
        this.resetButton.setToolTipText(string);
    }

    public String getResetUndoRedoTitle() {
        return this.resetUndoRedoTitle;
    }

    public void setResetUndoRedoTitle(String string) {
        this.resetUndoRedoTitle = string;
    }

    public String getIntersectionTitle() {
        return this.intersectionTitle;
    }

    public void setIntersectionTitle(String string) {
        this.intersectionTitle = string;
        this.intersectionButton.setToolTipText(string);
    }

    public String getIntersectionUndoRedoTitle() {
        return this.intersectionUndoRedoTitle;
    }

    public void setIntersectionUndoRedoTitle(String string) {
        this.intersectionUndoRedoTitle = string;
    }

    public String getUnionTitle() {
        return this.unionTitle;
    }

    public void setUnionTitle(String string) {
        this.unionTitle = string;
        this.unionButton.setToolTipText(string);
    }

    public String getUnionUndoRedoTitle() {
        return this.unionUndoRedoTitle;
    }

    public void setUnionUndoRedoTitle(String string) {
        this.unionUndoRedoTitle = string;
    }

    public String getSubstractTitle() {
        return this.substractTitle;
    }

    public void setSubstractTitle(String string) {
        this.substractTitle = string;
        this.substractButton.setToolTipText(string);
    }

    public String getSubstractUndoRedoTitle() {
        return this.substractUndoRedoTitle;
    }

    public void setSubstractUndoRedoTitle(String string) {
        this.substractUndoRedoTitle = string;
    }

    public String getXorTitle() {
        return this.xorTitle;
    }

    public void setXorTitle(String string) {
        this.xorTitle = string;
        this.xorButton.setToolTipText(string);
    }

    public String getXorUndoRedoTitle() {
        return this.xorUndoRedoTitle;
    }

    public void setXorUndoRedoTitle(String string) {
        this.xorUndoRedoTitle = string;
    }

    public String getUndoTitle() {
        return this.undoTitle;
    }

    public void setUndoTitle(String string) {
        this.undoTitle = string;
        this.undoButton.setToolTipText(string);
    }

    public String getRedoTitle() {
        return this.redoTitle;
    }

    public void setRedoTitle(String string) {
        this.redoTitle = string;
        this.redoButton.setToolTipText(string);
    }

    protected class CanvasRenderer
    extends JComponent
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener,
    KeyListener {
        protected int xMouse;
        protected int yMouse;
        protected Stroke selectionStroke = new BasicStroke(2.0f);

        public CanvasRenderer() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
            this.addKeyListener(this);
        }

        public double antiTranslateX(double d) {
            JImageJ.this.measureAxis();
            Dimension dimension = this.getSize();
            int n = JImageJ.this.canvas.getPreferredSize().width;
            JImageJ.this.xOrg = (dimension.width - (n + JImageJ.this.yAxisWidth + JImageJ.this.yAxisRightMargin)) / 2;
            return d - (double)JImageJ.this.xOrg - (double)JImageJ.this.yAxisWidth;
        }

        public int antiTranslateX(int n) {
            JImageJ.this.measureAxis();
            Dimension dimension = this.getSize();
            int n2 = JImageJ.this.canvas.getPreferredSize().width;
            JImageJ.this.xOrg = (dimension.width - (n2 + JImageJ.this.yAxisWidth + JImageJ.this.yAxisRightMargin)) / 2;
            return n - JImageJ.this.xOrg - JImageJ.this.yAxisWidth;
        }

        public double antiTranslateY(double d) {
            JImageJ.this.measureAxis();
            Dimension dimension = this.getSize();
            int n = JImageJ.this.canvas.getPreferredSize().height;
            JImageJ.this.yOrg = (dimension.height - (n + JImageJ.this.xAxisHeight + JImageJ.this.xAxisUpMargin)) / 2;
            return d - (double)JImageJ.this.yOrg - (double)JImageJ.this.xAxisUpMargin;
        }

        public int antiTranslateY(int n) {
            JImageJ.this.measureAxis();
            Dimension dimension = this.getSize();
            int n2 = JImageJ.this.canvas.getPreferredSize().height;
            JImageJ.this.yOrg = (dimension.height - (n2 + JImageJ.this.xAxisHeight + JImageJ.this.xAxisUpMargin)) / 2;
            return n - JImageJ.this.yOrg - JImageJ.this.xAxisUpMargin;
        }

        public void translateGraphics(Graphics graphics) {
            JImageJ.this.measureAxis();
            Dimension dimension = this.getSize();
            Dimension dimension2 = JImageJ.this.canvas.getPreferredSize();
            int n = dimension2.width;
            int n2 = dimension2.height;
            JImageJ.this.xOrg = (dimension.width - (n + JImageJ.this.yAxisWidth + JImageJ.this.yAxisRightMargin)) / 2;
            JImageJ.this.yOrg = (dimension.height - (n2 + JImageJ.this.xAxisHeight + JImageJ.this.xAxisUpMargin)) / 2;
            graphics.translate(JImageJ.this.xOrg + JImageJ.this.yAxisWidth, JImageJ.this.yOrg + JImageJ.this.xAxisUpMargin);
        }

        public MouseEvent antiTranslateMouseEvent(MouseEvent mouseEvent) {
            JImageJ.this.measureAxis();
            Dimension dimension = this.getSize();
            Dimension dimension2 = JImageJ.this.canvas.getPreferredSize();
            int n = dimension2.width;
            int n2 = dimension2.height;
            JImageJ.this.xOrg = (dimension.width - (n + JImageJ.this.yAxisWidth + JImageJ.this.yAxisRightMargin)) / 2;
            JImageJ.this.yOrg = (dimension.height - (n2 + JImageJ.this.xAxisHeight + JImageJ.this.xAxisUpMargin)) / 2;
            return new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - JImageJ.this.xOrg - JImageJ.this.yAxisWidth, mouseEvent.getY() - JImageJ.this.yOrg - JImageJ.this.xAxisUpMargin, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
        }

        public MouseEvent translateMouseEvent(MouseEvent mouseEvent) {
            JImageJ.this.measureAxis();
            Dimension dimension = this.getSize();
            Dimension dimension2 = JImageJ.this.canvas.getPreferredSize();
            int n = dimension2.width;
            int n2 = dimension2.height;
            JImageJ.this.xOrg = (dimension.width - (n + JImageJ.this.yAxisWidth + JImageJ.this.yAxisRightMargin)) / 2;
            JImageJ.this.yOrg = (dimension.height - (n2 + JImageJ.this.xAxisHeight + JImageJ.this.xAxisUpMargin)) / 2;
            return new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() + JImageJ.this.xOrg + JImageJ.this.yAxisWidth, mouseEvent.getY() + JImageJ.this.yOrg + JImageJ.this.xAxisUpMargin, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (JImageJ.this.canvas != null) {
                JImageJ.this.canvas.mouseClicked(mouseEvent);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (JImageJ.this.canvas != null) {
                JImageJ.this.canvas.mouseEntered(mouseEvent);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (JImageJ.this.canvas != null) {
                JImageJ.this.canvas.mouseExited(mouseEvent);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (JImageJ.this.canvas != null) {
                this.grabFocus();
                JImageJ.this.canvas.mousePressed(mouseEvent);
                this.repaint();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (JImageJ.this.canvas != null) {
                JImageJ.this.canvas.mouseReleased(mouseEvent);
                this.repaint();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (Toolbar.getToolId() == 12) {
                this.scroll(mouseEvent.getX(), mouseEvent.getY());
            }
            if (JImageJ.this.canvas != null) {
                JImageJ.this.canvas.mouseDragged(mouseEvent);
                this.repaint();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (JImageJ.this.canvas != null) {
                JImageJ.this.canvas.mouseMoved(mouseEvent);
                this.repaint();
            }
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (Toolbar.getToolId() == 11) {
                if (mouseWheelEvent.getWheelRotation() < 0) {
                    this.zoomIn();
                } else {
                    this.zoomOut();
                }
                this.revalidate();
                this.repaint();
            }
        }

        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Stroke stroke = graphics2D.getStroke();
            if (JImageJ.this.canvas != null && JImageJ.this.theImage != null) {
                if (JImageJ.this.xAxis.isAutoScale()) {
                    JImageJ.this.xAxis.setAutoScale(false);
                    JImageJ.this.xAxis.setMinimum(0.0);
                    JImageJ.this.xAxis.setMaximum(JImageJ.this.theImage.getWidth());
                    JImageJ.this.xAxis.setAutoScale(true);
                }
                if (JImageJ.this.yAxis.isAutoScale()) {
                    JImageJ.this.yAxis.setAutoScale(false);
                    JImageJ.this.yAxis.setMinimum(0.0);
                    JImageJ.this.yAxis.setMaximum(JImageJ.this.theImage.getHeight());
                    JImageJ.this.yAxis.setAutoScale(true);
                }
                Dimension dimension = this.getSize();
                if (this.isOpaque()) {
                    graphics2D.setColor(this.getBackground());
                    graphics2D.fillRect(0, 0, dimension.width, dimension.height);
                }
                this.translateGraphics(graphics2D);
                JImageJ.this.canvas.paint(graphics2D);
                JImageJ.this.paintAxis(graphics2D);
                Vector<Roi> vector = JImageJ.this.imp.getAllRois();
                boolean bl = JImageJ.this.imp.getSelectedRois().size() > 1;
                for (int i = 0; i < vector.size(); ++i) {
                    if (vector.get(i) == null) continue;
                    Color color = Roi.getColor();
                    if (JImageJ.this.imp.getSelectedRois().contains(vector.get(i))) {
                        graphics2D.setStroke(this.selectionStroke);
                        if (JImageJ.this.imp.getInnerRois().contains(vector.get(i))) {
                            Roi.setColor((Color)JImageJ.this.roiInsideSelectionColor);
                        } else if (JImageJ.this.imp.getOuterRois().contains(vector.get(i))) {
                            Roi.setColor((Color)JImageJ.this.roiOutsideSelectionColor);
                        } else {
                            Roi.setColor((Color)JImageJ.this.roiSelectionColor);
                        }
                        if (bl) {
                            int n = JImageJ.this.imp.getSelectedRois().indexOf(vector.get(i));
                            Color color2 = graphics2D.getColor();
                            graphics2D.setColor(Color.WHITE);
                            Rectangle rectangle = vector.get(i).getBounds();
                            int n2 = rectangle.x;
                            int n3 = rectangle.y;
                            int n4 = rectangle.width / 2;
                            int n5 = rectangle.height / 2;
                            graphics2D.drawString(Integer.toString(n + 1), (int)((double)(n2 += n4) * JImageJ.this.canvas.getMagnification()), (int)((double)(n3 += n5) * JImageJ.this.canvas.getMagnification()));
                            graphics2D.setColor(color2);
                            color2 = null;
                        }
                    } else if (JImageJ.this.imp.getInnerRois().contains(vector.get(i))) {
                        Roi.setColor((Color)JImageJ.this.roiInsideColor);
                    } else if (JImageJ.this.imp.getOuterRois().contains(vector.get(i))) {
                        Roi.setColor((Color)JImageJ.this.roiOutsideColor);
                    }
                    vector.get(i).draw((Graphics)graphics2D);
                    graphics2D.setStroke(stroke);
                    Roi.setColor((Color)color);
                }
            }
        }

        public Dimension getPreferredSize() {
            if (JImageJ.this.canvas != null) {
                Dimension dimension = JImageJ.this.canvas.getPreferredSize();
                JImageJ.this.measureAxis();
                dimension.width += JImageJ.this.yAxisWidth + JImageJ.this.yAxisRightMargin;
                dimension.height += JImageJ.this.xAxisHeight + JImageJ.this.xAxisUpMargin;
                return dimension;
            }
            return super.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void keyPressed(KeyEvent keyEvent) {
            Rectangle rectangle = null;
            Roi roi = JImageJ.this.imp.getRoi();
            if (roi != null && roi.getState() != 0) {
                rectangle = roi.getBounds();
            }
            switch (keyEvent.getKeyCode()) {
                case 8: 
                case 127: {
                    JImageJ.this.deleteSelectedRois();
                    break;
                }
                case 27: {
                    JImageJ.this.canvas.setSelectionMode(true);
                    JImageJ.this.canvas.setCursor(JImageJ.this.canvas.getDefaultCursor());
                    break;
                }
                case 17: {
                    break;
                }
                case 107: 
                case 521: {
                    if (Toolbar.getToolId() != 11) break;
                    this.zoomIn();
                    break;
                }
                case 45: 
                case 109: {
                    if (Toolbar.getToolId() != 11) break;
                    this.zoomOut();
                    break;
                }
                case 38: {
                    if (rectangle == null || rectangle.y <= 0 || rectangle.x < 0) break;
                    roi.setLocation(rectangle.x, rectangle.y - 1);
                    break;
                }
                case 40: {
                    if (rectangle == null || JImageJ.this.theImage == null || rectangle.y + rectangle.height >= JImageJ.this.theImage.getHeight() - 1 || rectangle.x < 0) break;
                    roi.setLocation(rectangle.x, rectangle.y + 1);
                    break;
                }
                case 37: {
                    if (rectangle == null || rectangle.y < 0 || rectangle.x <= 0) break;
                    roi.setLocation(rectangle.x - 1, rectangle.y);
                    break;
                }
                case 39: {
                    if (rectangle == null || JImageJ.this.theImage == null || rectangle.x + rectangle.width >= JImageJ.this.theImage.getWidth() - 1 || rectangle.y < 0) break;
                    roi.setLocation(rectangle.x + 1, rectangle.y);
                    break;
                }
                default: {
                    JImageJ.this.hiddenIJ.keyPressed(keyEvent);
                }
            }
            roi = null;
            rectangle = null;
            this.repaint();
        }

        public void keyReleased(KeyEvent keyEvent) {
            JImageJ.this.hiddenIJ.keyReleased(keyEvent);
            this.repaint();
        }

        public void keyTyped(KeyEvent keyEvent) {
            JImageJ.this.hiddenIJ.keyTyped(keyEvent);
            this.repaint();
        }

        protected void scroll(int n, int n2) {
            JScrollBar jScrollBar = JImageJ.this.imagePane.getHorizontalScrollBar();
            JScrollBar jScrollBar2 = JImageJ.this.imagePane.getVerticalScrollBar();
            if (jScrollBar != null) {
                if (n < jScrollBar.getMaximum()) {
                    jScrollBar.setValue(n);
                } else {
                    jScrollBar.setValue(jScrollBar.getMaximum());
                }
            }
            if (jScrollBar2 != null) {
                if (n2 < jScrollBar2.getMaximum()) {
                    jScrollBar2.setValue(n2);
                } else {
                    jScrollBar2.setValue(jScrollBar2.getMaximum());
                }
            }
        }

        public void zoomIn() {
            JImageJ.this.canvas.zoomInNoTranslation(0, 0);
            this.revalidate();
            this.repaint();
        }

        public void zoomOut() {
            JImageJ.this.canvas.zoomOutNoTranslation(0, 0);
            this.revalidate();
            this.repaint();
        }
    }

    protected class RenderedImageCanvas
    extends ImageCanvas {
        protected boolean roiselected;
        protected boolean selectionMode;

        public RenderedImageCanvas(ImagePlus imagePlus) {
            super(imagePlus);
            this.roiselected = false;
            this.selectionMode = false;
        }

        public void setCursor(Cursor cursor) {
            if (this.imp instanceof AdvancedImagePlus && !((AdvancedImagePlus)this.imp).isAllowRoiCreation()) {
                cursor = defaultCursor;
            }
            super.setCursor(cursor);
            if (JImageJ.this.canvasRenderer != null) {
                JImageJ.this.canvasRenderer.setCursor(cursor);
            }
        }

        public void setCursor(int n, int n2, int n3, int n4) {
            super.setCursor(n3, n4, n3, n4);
        }

        public Cursor getDefaultCursor() {
            return defaultCursor;
        }

        public Graphics getGraphics() {
            if (JImageJ.this.canvasRenderer == null) {
                return super.getGraphics();
            }
            Graphics graphics = JImageJ.this.canvasRenderer.getGraphics();
            return graphics;
        }

        public boolean isShowing() {
            if (JImageJ.this.canvasRenderer != null) {
                return JImageJ.this.canvasRenderer.isShowing();
            }
            return super.isShowing();
        }

        public synchronized void add(PopupMenu popupMenu) {
        }

        protected void handlePopupMenu(MouseEvent mouseEvent) {
        }

        public int offScreenX(int n) {
            int n2 = super.offScreenX(n);
            if (JImageJ.this.canvasRenderer != null) {
                n2 = (int)((double)JImageJ.this.canvasRenderer.antiTranslateX(n) / this.magnification);
            }
            return n2 += this.srcRect.x;
        }

        public double offScreenXD(int n) {
            double d = super.offScreenXD(n);
            if (JImageJ.this.canvasRenderer != null) {
                d = (double)JImageJ.this.canvasRenderer.antiTranslateX(n) / this.magnification;
            }
            return d += (double)this.srcRect.x;
        }

        public int offScreenY(int n) {
            int n2 = super.offScreenY(n);
            if (JImageJ.this.canvasRenderer != null) {
                n2 = (int)((double)JImageJ.this.canvasRenderer.antiTranslateY(n) / this.magnification);
            }
            return n2 += this.srcRect.y;
        }

        public double offScreenYD(int n) {
            double d = super.offScreenYD(n);
            if (JImageJ.this.canvasRenderer != null) {
                d = (double)JImageJ.this.canvasRenderer.antiTranslateY(n) / this.magnification;
            }
            return d += (double)this.srcRect.y;
        }

        public void findRoiSelected(int n, int n2, boolean bl) {
            if (this.imp instanceof AdvancedImagePlus) {
                Roi roi = ((AdvancedImagePlus)this.imp).getValidatedRoi();
                Roi roi2 = null;
                this.roiselected = false;
                Vector<Roi> vector = ((AdvancedImagePlus)this.imp).getAllRois();
                Vector<Roi> vector2 = ((AdvancedImagePlus)this.imp).getInnerRois();
                Vector<Roi> vector3 = ((AdvancedImagePlus)this.imp).getOuterRois();
                Iterator<Roi> iterator = vector.iterator();
                boolean bl2 = false;
                while (iterator.hasNext()) {
                    roi2 = iterator.next();
                    if (roi2 != null && roi2.getState() != 0 && roi2.isHandle((int)((double)n * this.magnification), (int)((double)n2 * this.magnification)) >= 0) {
                        if (((AdvancedImagePlus)this.imp).getSelectedRois().contains(roi2)) {
                            bl2 = true;
                            break;
                        }
                        this.roiselected = true;
                        break;
                    }
                    if (roi2 == null || roi2.getState() == 0 || !roi2.contains(n, n2)) continue;
                    if (((AdvancedImagePlus)this.imp).getSelectedRois().contains(roi2)) {
                        bl2 = true;
                        break;
                    }
                    this.roiselected = true;
                    break;
                }
                if (!bl) {
                    ((AdvancedImagePlus)this.imp).getSelectedRois().clear();
                    ((AdvancedImagePlus)this.imp).setValidatedRoi(null);
                }
                if (this.roiselected) {
                    ((AdvancedImagePlus)this.imp).getSelectedRois().removeAll(((AdvancedImagePlus)this.imp).getInnerRois());
                    ((AdvancedImagePlus)this.imp).getSelectedRois().removeAll(((AdvancedImagePlus)this.imp).getOuterRois());
                    ((AdvancedImagePlus)this.imp).getSelectedRois().add(roi2);
                    if (!vector2.contains(roi2) && !vector3.contains(roi2)) {
                        ((AdvancedImagePlus)this.imp).setHandledRoi(roi2);
                    }
                    if (((AdvancedImagePlus)this.imp).getInnerRois().contains(roi2) || ((AdvancedImagePlus)this.imp).getOuterRois().contains(roi2)) {
                        ((AdvancedImagePlus)this.imp).setValidatedRoi(roi2);
                        if (bl && roi != null && roi != roi2) {
                            ((AdvancedImagePlus)this.imp).getSelectedRois().remove(roi);
                        }
                    }
                } else if (bl2) {
                    ((AdvancedImagePlus)this.imp).getSelectedRois().remove(roi2);
                    if (!vector2.contains(roi2) && !vector3.contains(roi2)) {
                        ((AdvancedImagePlus)this.imp).setHandledRoi(roi2);
                    }
                    if (roi2 == roi) {
                        ((AdvancedImagePlus)this.imp).setValidatedRoi(null);
                    }
                } else {
                    ((AdvancedImagePlus)this.imp).getSelectedRois().clear();
                    ((AdvancedImagePlus)this.imp).setValidatedRoi(null);
                }
            }
        }

        public void findHandledRoi(int n, int n2) {
            if (this.imp instanceof AdvancedImagePlus) {
                Roi roi2 = null;
                Vector<Roi> vector = ((AdvancedImagePlus)this.imp).getAllRois();
                Vector<Roi> vector2 = ((AdvancedImagePlus)this.imp).getInnerRois();
                Vector<Roi> vector3 = ((AdvancedImagePlus)this.imp).getOuterRois();
                for (Roi roi2 : vector) {
                    if (!vector2.contains(roi2) && !vector3.contains(roi2) && (roi2 != null && roi2.getState() != 0 && roi2.isHandle((int)((double)n * this.magnification), (int)((double)n2 * this.magnification)) >= 0 || roi2 != null && roi2.getState() != 0 && roi2.contains(n, n2))) break;
                    roi2 = null;
                }
                vector = null;
                vector2 = null;
                vector3 = null;
                if (roi2 != null) {
                    ((AdvancedImagePlus)this.imp).setHandledRoi(roi2);
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && (handCursor.equals(this.getCursor()) || defaultCursor.equals(this.getCursor()))) {
                this.imp.killRoi();
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                int n3 = this.offScreenX(n);
                int n4 = this.offScreenY(n2);
                boolean bl = mouseEvent.isShiftDown() || mouseEvent.isControlDown();
                this.findRoiSelected(n3, n4, bl);
            } else {
                super.mouseClicked(mouseEvent);
            }
            this.repaint();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = Toolbar.getToolId();
            if ((n == 2 || n == 5 || n == 14) && this.imp.getRoi() != null && this.imp.getRoi().getState() != 0) {
                this.imp.killRoi();
            }
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            int n4 = this.offScreenX(n2);
            int n5 = this.offScreenY(n3);
            if (this.isSelectionMode() || this.imp instanceof AdvancedImagePlus && !((AdvancedImagePlus)this.imp).isAllowRoiCreation()) {
                this.findHandledRoi(n4, n5);
            }
            if (Toolbar.getToolId() == 11) {
                Toolbar.getInstance().setTool(0);
            }
            n4 = (int)((double)n4 * this.magnification);
            n5 = (int)((double)n5 * this.magnification);
            if (this.imp.getRoi() != null && this.imp.getRoi().isHandle(n4, n5) >= 0) {
                super.mousePressed(new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiersEx(), n4, n5, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
            } else {
                super.mousePressed(mouseEvent);
            }
            this.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = (int)((double)this.offScreenX(n) * JImageJ.this.canvas.getMagnification());
            int n4 = (int)((double)this.offScreenY(n2) * JImageJ.this.canvas.getMagnification());
            if (JImageJ.this.selectedButton == JImageJ.this.zoomButton) {
                if (this.imp.getRoi() != null) {
                    JImageJ.this.setZoomRoi(this.imp.getRoi());
                }
                Toolbar.getInstance().setTool(11);
            } else if (this.imp.getRoi() != null && this.imp.getRoi().isHandle(n3, n4) >= 0) {
                super.mouseReleased(new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiersEx(), n3, n4, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
            } else {
                super.mouseReleased(mouseEvent);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (!this.isSelectionMode()) {
                int n;
                int n2 = mouseEvent.getX();
                int n3 = mouseEvent.getY();
                int n4 = this.offScreenX(n2);
                int n5 = this.offScreenY(n3);
                Dimension dimension = JImageJ.this.getImageSize();
                if (n4 >= dimension.width) {
                    n = 1 + n4 - dimension.width;
                    n4 -= n;
                    n2 = (int)((double)n2 - (double)n * this.magnification);
                }
                if (n5 >= dimension.height) {
                    n = 1 + n5 - dimension.height;
                    n5 -= n;
                    n3 = (int)((double)n3 - (double)n * this.magnification);
                }
                if (n2 < JImageJ.this.getXOrigin()) {
                    n2 = JImageJ.this.getXOrigin();
                    n4 = this.offScreenX(n2);
                }
                if (n3 < JImageJ.this.getYOrigin()) {
                    n3 = JImageJ.this.getYOrigin();
                    n5 = this.offScreenY(n3);
                }
                if (this.imp.getRoi() != null && this.imp.getRoi().getState() != 0 && this.imp.getRoi().isHandle(n4, n5) >= 0) {
                    super.mouseMoved(new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiersEx(), n4, n5, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
                } else {
                    super.mouseMoved(new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiersEx(), n2, n3, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
                }
            }
        }

        public boolean isSelectionMode() {
            return this.selectionMode;
        }

        public void setSelectionMode(boolean bl) {
            this.selectionMode = bl;
            if (this.imp instanceof AdvancedImagePlus) {
                ((AdvancedImagePlus)this.imp).setAllowRoiCreation(!bl);
            }
        }

        public void zoomInNoTranslation(int n, int n2) {
            super.zoomIn(n, n2);
            JImageJ.this.revalidate();
        }

        public void zoomOutNoTranslation(int n, int n2) {
            super.zoomOut(n, n2);
            JImageJ.this.revalidate();
        }

        public void zoomIn(int n, int n2) {
            int n3 = this.offScreenX(n);
            int n4 = this.offScreenY(n2);
            super.zoomIn(n3, n4);
            JImageJ.this.revalidate();
        }

        public void zoomOut(int n, int n2) {
            int n3 = this.offScreenX(n);
            int n4 = this.offScreenY(n2);
            super.zoomOut(n3, n4);
            JImageJ.this.revalidate();
        }

        public void unzoom() {
            super.unzoom();
            JImageJ.this.revalidate();
        }

        public void computeZoom(double d) {
            this.setMagnification(d);
            int n = (int)((double)this.imageWidth * d);
            int n2 = (int)((double)this.imageHeight * d);
            Dimension dimension = this.canEnlarge(n, n2);
            if (dimension != null) {
                this.setDrawingSize(dimension.width, dimension.height);
                if (dimension.width != n || dimension.height != n2) {
                    this.reAdjustSourceRect(d);
                } else {
                    this.setMagnification(d);
                }
                this.imp.getWindow().pack();
            } else {
                this.reAdjustSourceRect(d);
            }
            JImageJ.this.imagePane.setViewportView(JImageJ.this.canvasRenderer);
            this.repaint();
        }

        public void computeZoom(Roi roi) {
            if (roi != null) {
                int n;
                Rectangle rectangle = roi.getBounds();
                double d = rectangle.width;
                double d2 = rectangle.height;
                Rectangle rectangle2 = JImageJ.this.imagePane.getVisibleRect();
                double d3 = rectangle2.width;
                double d4 = rectangle2.height;
                rectangle2 = null;
                double d5 = Math.min(d3 / d, d4 / d2);
                int n2 = (int)(d3 * (d5 = RenderedImageCanvas.getLowerZoomLevel((double)(d5 + 1.0E-16))));
                Dimension dimension = this.canEnlarge(n2, n = (int)(d4 * d5));
                if (dimension != null) {
                    this.setDrawingSize(dimension.width, dimension.height);
                    if (dimension.width != n2 || dimension.height != n) {
                        this.reAdjustSourceRect(d5);
                    } else {
                        this.setMagnification(d5);
                    }
                    this.imp.getWindow().pack();
                } else {
                    this.reAdjustSourceRect(d5);
                }
                JImageJ.this.revalidate();
                this.repaint();
                JImageJ.this.canvasRenderer.revalidate();
                Rectangle rectangle3 = roi.getBounds();
                Rectangle rectangle4 = new Rectangle((int)((double)rectangle3.x * d5), (int)((double)rectangle3.y * d5), (int)((double)rectangle3.width * d5), (int)((double)rectangle3.height * d5));
                JImageJ.this.imagePane.setViewportView(JImageJ.this.canvasRenderer);
                JImageJ.this.canvasRenderer.scroll(rectangle4.x, rectangle4.y);
                rectangle3 = null;
                rectangle4 = null;
            }
        }

        protected void reAdjustSourceRect(double d) {
            int n;
            int n2 = (int)Math.round((double)this.dstWidth / d);
            if ((double)n2 * d < (double)this.dstWidth) {
                ++n2;
            }
            if ((double)(n = (int)Math.round((double)this.dstHeight / d)) * d < (double)this.dstHeight) {
                ++n;
            }
            this.srcRect = new Rectangle(0, 0, n2, n);
            this.setMagnification(d);
        }

        protected Dimension canEnlarge(int n, int n2) {
            return new Dimension(n, n2);
        }
    }

    protected class HiddenWindow
    extends ImageWindow {
        public HiddenWindow(ImagePlus imagePlus, ImageCanvas imageCanvas) {
            super(imagePlus, imageCanvas);
            this.remove((Component)imageCanvas);
        }

        public HiddenWindow(String string) {
            super(string);
        }

        public HiddenWindow(ImagePlus imagePlus) {
            super(imagePlus);
        }

        public void show() {
        }

        public void setVisible(boolean bl) {
            if (!bl) {
                super.setVisible(bl);
            }
        }
    }
}

