/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import jive.JiveUtils;
import jive.MultiLineCellEditor;
import jive3.MainPanel;
import jive3.ProgressFrame;
import jive3.PropertyNode;
import jive3.TaskClassAttributePropertyNode;
import jive3.TaskClassPropertyNode;
import jive3.TaskDeviceAttributePropertyNode;
import jive3.TaskDevicePropertyNode;
import jive3.TaskFreePropertyNode;
import jive3.TaskSubDevicePropertyNode;

public class PropertyPanel
extends JPanel
implements ActionListener,
MouseListener {
    private JScrollPane textView;
    private JTable theTable;
    private JButton refreshButton;
    private JButton applyButton;
    private JButton deleteButton;
    private JButton copyButton;
    private JButton newButton;
    private MainPanel parent;
    private PropertyNode[] source = null;
    private DefaultTableModel dm;
    private MultiLineCellEditor editor;
    private boolean[] updatedProp;
    private JPopupMenu tableMenu;
    private JMenuItem historyMenuItem;
    private JMenuItem renameMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenuItem copyMenuItem;

    PropertyPanel() {
        this.setLayout(new BorderLayout());
        this.dm = new DefaultTableModel(){

            public Class getColumnClass(int n) {
                return String.class;
            }

            public boolean isCellEditable(int n, int n2) {
                return n2 == 1 && !JiveUtils.readOnly;
            }

            public void setValueAt(Object object, int n, int n2) {
                if (!object.equals(this.getValueAt(n, n2))) {
                    super.setValueAt(object, n, n2);
                    PropertyPanel.this.applyButton.setEnabled(true);
                    ((PropertyPanel)PropertyPanel.this).updatedProp[n] = true;
                }
            }
        };
        this.theTable = new JTable(this.dm);
        this.theTable.addMouseListener(this);
        this.editor = new MultiLineCellEditor(this.theTable);
        this.theTable.setDefaultEditor(String.class, this.editor);
        MultiLineCellRenderer multiLineCellRenderer = new MultiLineCellRenderer();
        this.theTable.setDefaultRenderer(String.class, multiLineCellRenderer);
        this.textView = new JScrollPane(this.theTable);
        this.add((Component)this.textView, "Center");
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "...");
        this.textView.setBorder(titledBorder);
        this.add((Component)this.textView, "Center");
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.addActionListener(this);
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(this);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.setEnabled(!JiveUtils.readOnly);
        this.deleteButton.addActionListener(this);
        this.copyButton = new JButton("Copy");
        this.copyButton.setEnabled(!JiveUtils.readOnly);
        this.copyButton.addActionListener(this);
        this.newButton = new JButton("New property");
        this.newButton.setEnabled(!JiveUtils.readOnly);
        this.newButton.addActionListener(this);
        jPanel.add(this.refreshButton);
        jPanel.add(this.applyButton);
        jPanel.add(this.newButton);
        jPanel.add(this.copyButton);
        jPanel.add(this.deleteButton);
        this.add((Component)jPanel, "South");
        this.tableMenu = new JPopupMenu();
        this.copyMenuItem = new JMenuItem("Copy");
        this.copyMenuItem.addActionListener(this);
        this.renameMenuItem = new JMenuItem("Rename");
        this.renameMenuItem.addActionListener(this);
        this.historyMenuItem = new JMenuItem("View history");
        this.historyMenuItem.addActionListener(this);
        this.deleteMenuItem = new JMenuItem("Delete");
        this.deleteMenuItem.addActionListener(this);
        this.tableMenu.add(this.copyMenuItem);
        this.tableMenu.add(this.deleteMenuItem);
        this.tableMenu.add(this.renameMenuItem);
        this.tableMenu.add(this.historyMenuItem);
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1 && !JiveUtils.readOnly && (n = this.getRowForLocation(mouseEvent.getY())) != -1) {
            this.theTable.addRowSelectionInterval(n, n);
            this.theTable.setColumnSelectionInterval(0, 1);
            int[] nArray = this.theTable.getSelectedRows();
            this.renameMenuItem.setEnabled(nArray.length == 1);
            this.historyMenuItem.setEnabled(nArray.length == 1);
            this.tableMenu.show(this.theTable, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void setParent(MainPanel mainPanel) {
        this.parent = mainPanel;
    }

    public boolean hasChanged() {
        return this.applyButton.isEnabled();
    }

    public void saveChange() {
        int n = this.getNbUpdated() * this.source.length;
        int n2 = 0;
        if (n > 1) {
            ProgressFrame.displayProgress("Updating properties");
        }
        for (int i = 0; i < this.updatedProp.length; ++i) {
            if (!this.updatedProp[i]) continue;
            for (int j = 0; j < this.source.length; ++j) {
                ProgressFrame.setProgress("Applying " + this.source[j].getName() + "/" + this.dm.getValueAt(i, 0), ++n2 * 100 / n);
                this.source[j].setProperty((String)this.dm.getValueAt(i, 0), (String)this.dm.getValueAt(i, 1));
            }
            this.updatedProp[i] = false;
        }
        this.applyButton.setEnabled(false);
        ProgressFrame.hideProgress();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block19: {
            Object object;
            block23: {
                String string;
                block28: {
                    String string2;
                    block27: {
                        block26: {
                            block25: {
                                block24: {
                                    block22: {
                                        block21: {
                                            block20: {
                                                block18: {
                                                    object = actionEvent.getSource();
                                                    if (object != this.refreshButton) break block18;
                                                    this.refreshValue();
                                                    break block19;
                                                }
                                                if (object != this.applyButton) break block20;
                                                this.saveChange();
                                                break block19;
                                            }
                                            if (object != this.deleteMenuItem && object != this.deleteButton) break block21;
                                            int[] nArray = this.theTable.getSelectedRows();
                                            if (nArray.length == 0) {
                                                JiveUtils.showJiveError("Selection is empty.");
                                                return;
                                            }
                                            int n = JOptionPane.showConfirmDialog(this, "Delete selection ?", "Confirm delete", 0);
                                            if (n == 0) {
                                                int n2 = nArray.length * this.source.length;
                                                int n3 = 0;
                                                if (n2 > 1) {
                                                    ProgressFrame.displayProgress("Deleting properties");
                                                }
                                                for (int i = 0; i < nArray.length; ++i) {
                                                    for (int j = 0; j < this.source.length; ++j) {
                                                        ProgressFrame.setProgress("Deleting " + this.source[j].getName() + "/" + this.dm.getValueAt(nArray[i], 0), ++n3 * 100 / n2);
                                                        this.source[j].deleteProperty((String)this.dm.getValueAt(nArray[i], 0));
                                                    }
                                                }
                                                ProgressFrame.hideProgress();
                                                this.refreshValue();
                                            }
                                            break block19;
                                        }
                                        if (object != this.renameMenuItem) break block22;
                                        int n = this.theTable.getSelectedRow();
                                        String string3 = (String)this.dm.getValueAt(n, 0);
                                        String string4 = (String)this.dm.getValueAt(n, 1);
                                        String string5 = JOptionPane.showInputDialog(null, "Rename property", string3);
                                        if (string5 == null) {
                                            return;
                                        }
                                        if (this.propertyExists(string5)) {
                                            JiveUtils.showJiveError("Name already exists.");
                                            return;
                                        }
                                        int n4 = 0;
                                        int n5 = this.source.length;
                                        if (n5 > 1) {
                                            ProgressFrame.displayProgress("Renaming properties");
                                        }
                                        for (int i = 0; i < this.source.length; ++i) {
                                            ProgressFrame.setProgress("Renaming " + this.source[i].getName() + "/" + string3, ++n4 * 100 / n5);
                                            this.source[i].rename(string3, string4, string5);
                                        }
                                        this.refreshValue();
                                        ProgressFrame.hideProgress();
                                        break block19;
                                    }
                                    if (object != this.historyMenuItem) break block23;
                                    int n = this.theTable.getSelectedRow();
                                    string = (String)this.dm.getValueAt(n, 0);
                                    string2 = this.source[0].getName();
                                    if (!(this.source[0] instanceof TaskDevicePropertyNode)) break block24;
                                    this.parent.historyDlg.viewDevicePropertyHistory(string2, string);
                                    this.parent.showHistory();
                                    break block19;
                                }
                                if (!(this.source[0] instanceof TaskDeviceAttributePropertyNode)) break block25;
                                String string6 = ((TaskDeviceAttributePropertyNode)this.source[0]).getAttributeName();
                                this.parent.historyDlg.viewDeviceAttPropertyHistory(string2, string6, string);
                                this.parent.showHistory();
                                break block19;
                            }
                            if (!(this.source[0] instanceof TaskClassAttributePropertyNode)) break block26;
                            String string7 = ((TaskClassAttributePropertyNode)this.source[0]).getAttributeName();
                            this.parent.historyDlg.viewClassAttPropertyHistory(string2, string7, string);
                            this.parent.showHistory();
                            break block19;
                        }
                        if (!(this.source[0] instanceof TaskFreePropertyNode)) break block27;
                        this.parent.historyDlg.viewFreePropertyHistory(string2, string);
                        this.parent.showHistory();
                        break block19;
                    }
                    if (!(this.source[0] instanceof TaskClassPropertyNode)) break block28;
                    this.parent.historyDlg.viewClassPropertyHistory(string2, string);
                    this.parent.showHistory();
                    break block19;
                }
                if (!(this.source[0] instanceof TaskSubDevicePropertyNode)) break block19;
                String string8 = ((TaskSubDevicePropertyNode)this.source[0]).getDevName();
                String string9 = ((TaskSubDevicePropertyNode)this.source[0]).getSubName() + "/" + string;
                this.parent.historyDlg.viewDevicePropertyHistory(string8, string9);
                this.parent.showHistory();
                break block19;
            }
            if (object == this.newButton) {
                String string = JOptionPane.showInputDialog(null, "Add property", "");
                if (string == null) {
                    return;
                }
                if (this.propertyExists(string)) {
                    JiveUtils.showJiveError("Name already exists.");
                    return;
                }
                int n = 0;
                int n6 = this.source.length;
                if (n6 > 1) {
                    ProgressFrame.displayProgress("Creating properties");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    ProgressFrame.setProgress("Creating " + this.source[i].getName() + "/" + string, ++n * 100 / n6);
                    this.source[i].setProperty(string, "");
                }
                this.refreshValue();
                ProgressFrame.hideProgress();
            } else if (object == this.copyMenuItem || object == this.copyButton) {
                int[] nArray = this.theTable.getSelectedRows();
                if (nArray.length == 0) {
                    JiveUtils.showJiveError("Nothing to copy.");
                    return;
                }
                JiveUtils.the_clipboard.clear();
                for (int i = 0; i < nArray.length; ++i) {
                    JiveUtils.the_clipboard.add((String)this.dm.getValueAt(nArray[i], 0), (String)this.dm.getValueAt(nArray[i], 1));
                }
            }
        }
    }

    void setSource(PropertyNode[] propertyNodeArray) {
        this.source = propertyNodeArray;
        this.refreshValue();
    }

    private void refreshValue() {
        this.applyButton.setEnabled(false);
        if (this.source != null) {
            Object[] objectArray = new String[]{"Property name", "Value"};
            Object[][] objectArray2 = this.source[0].getProperties();
            this.dm.setDataVector(objectArray2, objectArray);
            this.updatedProp = new boolean[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                this.updatedProp[i] = false;
            }
            this.editor.updateRows();
            this.theTable.getColumnModel().getColumn(1).setPreferredWidth(250);
            this.theTable.validate();
            String string = this.source[0].getTitle();
            string = this.source.length == 1 ? string + " [" + this.source[0].getName() + "]" : string + " [" + this.source.length + " items selected]";
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string);
            this.textView.setBorder(titledBorder);
        }
    }

    private boolean propertyExists(String string) {
        boolean bl = false;
        int n = 0;
        while (n < this.dm.getRowCount() && !bl) {
            bl = ((String)this.dm.getValueAt(n, 0)).equalsIgnoreCase(string);
            if (bl) continue;
            ++n;
        }
        return bl;
    }

    private int getNbUpdated() {
        int n = 0;
        for (int i = 0; i < this.updatedProp.length; ++i) {
            if (!this.updatedProp[i]) continue;
            ++n;
        }
        return n;
    }

    private int getRowForLocation(int n) {
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.dm.getRowCount() && !bl) {
            bl = n >= n3 && n <= n3 + this.theTable.getRowHeight(n2);
            if (bl) continue;
            n3 += this.theTable.getRowHeight(n2);
            ++n2;
        }
        if (bl) {
            return n2;
        }
        return -1;
    }

    class MultiLineCellRenderer
    extends JTextArea
    implements TableCellRenderer {
        Color selColor = new Color(200, 200, 255);
        Border selBorder = BorderFactory.createLineBorder(this.selColor);

        public MultiLineCellRenderer() {
            this.setEditable(false);
            this.setLineWrap(false);
            this.setWrapStyleWord(false);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof String) {
                this.setText((String)object);
            } else {
                this.setText("");
            }
            int[] nArray = jTable.getSelectedRows();
            if (JiveUtils.contains(nArray, n) && n2 == 0) {
                this.setBackground(this.selColor);
            } else {
                this.setBackground(Color.WHITE);
            }
            if (bl && n2 == 1) {
                this.setBorder(this.selBorder);
            } else {
                this.setBorder(null);
            }
            return this;
        }
    }
}

