/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.interlock;

import fr.esrf.tangoatk.widget.util.interlock.NetEditorDlg;
import fr.esrf.tangoatk.widget.util.interlock.NetEditorListener;
import fr.esrf.tangoatk.widget.util.interlock.NetFileFilter;
import fr.esrf.tangoatk.widget.util.interlock.NetFileLoader;
import fr.esrf.tangoatk.widget.util.interlock.NetObject;
import fr.esrf.tangoatk.widget.util.interlock.NetObjectDlg;
import fr.esrf.tangoatk.widget.util.interlock.NetUtils;
import fr.esrf.tangoatk.widget.util.interlock.UndoBuffer;
import fr.esrf.tangoatk.widget.util.interlock.XpssFileLoader;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class NetEditor
extends JComponent
implements MouseListener,
MouseMotionListener {
    static final int DRAG_NONE = 0;
    static final int DRAG_OBJECT = 1;
    static final int DRAG_SELECTION = 2;
    static final int DRAG_LABEL = 3;
    static final int DRAG_LINK = 4;
    static final int DRAG_LINKMOVE = 5;
    public static final int CREATE_NONE = 0;
    public static final int CREATE_BUBBLE = 1;
    public static final int CREATE_TEXT = 3;
    public static final int CREATE_LINK = 4;
    Font smallFont = defaultSmallFont;
    Font labelFont = defaultLabelFont;
    boolean useAAFont = false;
    boolean showArrow = true;
    boolean isEditable = true;
    String defaultExtension = "net";
    int XGRID_SIZE = 20;
    int YGRID_SIZE = 16;
    private Vector objects;
    private Vector clipboard;
    private Vector undo;
    private JFrame pFrame;
    private boolean needToSave;
    private boolean moveBubble;
    private int dragMode;
    private int createMode;
    private Point dragStart;
    private Rectangle selDrag;
    private boolean onlyTextSelected;
    private NetObject selObject;
    private NetObject lnkObject;
    private NetObjectDlg dlgProp;
    private NetEditorDlg dlgOpt;
    private static final int undoLength = 15;
    private int undoPos;
    private Vector listeners;
    private String currentFileName;
    private static final float[] dashPattern = new float[]{2.0f};
    private static final BasicStroke dashStroke = new BasicStroke(1.0f, 0, 0, 10.0f, dashPattern, 0.0f);
    static final Font defaultSmallFont = new Font("Dialog", 0, 9);
    static final Font defaultLabelFont = new Font("Dialog", 0, 11);

    public NetEditor() {
        this.pFrame = null;
        this.initComponents();
    }

    public NetEditor(JFrame jFrame) {
        this.pFrame = jFrame;
        this.initComponents();
    }

    private void initComponents() {
        this.setBackground(new Color(220, 220, 220));
        this.setLayout(null);
        this.objects = new Vector();
        this.clipboard = new Vector();
        this.dragMode = 0;
        this.dragStart = new Point();
        this.selDrag = new Rectangle();
        this.selObject = null;
        this.createMode = 0;
        this.dlgProp = new NetObjectDlg(this.pFrame, this);
        this.dlgOpt = new NetEditorDlg(this.pFrame, this);
        this.useAAFont = false;
        this.undo = new Vector();
        this.resetUndo();
        this.needToSave = false;
        this.listeners = new Vector();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.currentFileName = "";
        this.moveBubble = false;
        this.setPreferredSize(new Dimension(640, 480));
    }

    public void setEditable(boolean bl) {
        this.unselectAll();
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.dragMode = 0;
        if (this.createMode != 0) {
            this.createMode = 0;
            this.fireCancelCreate();
        }
        this.isEditable = bl;
        this.repaint();
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setFileExtension(String string) {
        this.defaultExtension = string;
    }

    public String getFileExtension() {
        return this.defaultExtension;
    }

    public void loadFile(String string) throws IOException {
        Object object;
        char[] cArray = new char[5];
        FileReader fileReader = new FileReader(string);
        fileReader.read(cArray, 0, 5);
        fileReader.close();
        fileReader = new FileReader(string);
        String string2 = new String(cArray);
        Vector vector = null;
        if (string2.equalsIgnoreCase("Begin")) {
            object = new XpssFileLoader(fileReader);
            vector = ((XpssFileLoader)object).parseXpssFile(new Dimension(this.XGRID_SIZE, this.YGRID_SIZE));
        } else {
            object = new NetFileLoader(fileReader, string);
            vector = ((NetFileLoader)object).parseNetFile();
            this.smallFont = ((NetFileLoader)object).getSmallFont();
            this.labelFont = ((NetFileLoader)object).getLabelFont();
            this.useAAFont = ((NetFileLoader)object).getUseAAFont();
            this.showArrow = ((NetFileLoader)object).getDrawArrow();
        }
        fileReader.close();
        this.clearObjects();
        this.currentFileName = string;
        for (int i = 0; i < vector.size(); ++i) {
            this.addObject((NetObject)vector.get(i));
        }
        this.resetUndo();
        this.computePreferredSize();
        this.setNeedToSave(false, "Load");
        this.repaint();
    }

    public void showOpenFileDialog(String string, NetFileFilter netFileFilter) {
        String[] stringArray;
        boolean bl = false;
        JFileChooser jFileChooser = new JFileChooser(string);
        if (this.currentFileName.length() > 0) {
            jFileChooser.setSelectedFile(new File(this.currentFileName));
        }
        if (netFileFilter != null) {
            jFileChooser.addChoosableFileFilter(netFileFilter);
        } else {
            String[] stringArray2 = new String[]{this.defaultExtension};
            stringArray = new String[]{"xpss", "pss"};
            jFileChooser.addChoosableFileFilter(new NetFileFilter("PSS Network description file", stringArray));
            jFileChooser.addChoosableFileFilter(new NetFileFilter("Network description file", stringArray2));
        }
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0 && (stringArray = jFileChooser.getSelectedFile()) != null && !bl) {
            String string2 = stringArray.getAbsolutePath();
            try {
                this.loadFile(string2);
            }
            catch (IOException iOException) {
                this.error("Error during reading file:" + string2 + "\n" + iOException.getMessage());
                this.fireValueChanged();
            }
        }
    }

    public void saveNetFile(String string) throws IOException {
        int n;
        int n2 = this.objects.size();
        if (n2 == 0) {
            return;
        }
        if (!string.endsWith(this.defaultExtension) && JOptionPane.showConfirmDialog(this, "Do you really want to save " + string + "\nwith an extension different from the standard (." + this.defaultExtension + ") ?", "Confirm", 0) == 1) {
            return;
        }
        FileWriter fileWriter = new FileWriter(string);
        fileWriter.write("NetFile v10 {\n");
        fileWriter.write("  GlobalParam {\n");
        if (!NetUtils.fontEquals(this.labelFont, defaultLabelFont)) {
            fileWriter.write("    label_font:\"" + this.labelFont.getName() + "\"," + this.labelFont.getStyle() + "," + this.labelFont.getSize() + "\n");
        }
        if (!NetUtils.fontEquals(this.smallFont, defaultSmallFont)) {
            fileWriter.write("    small_font:\"" + this.smallFont.getName() + "\"," + this.smallFont.getStyle() + "," + this.smallFont.getSize() + "\n");
        }
        if (this.useAAFont) {
            fileWriter.write("    use_aa_font:1\n");
        }
        if (!this.showArrow) {
            fileWriter.write("    draw_arrow:0\n");
        }
        fileWriter.write("  }\n");
        for (n = 0; n < n2; ++n) {
            ((NetObject)this.objects.get(n)).setIndex(n);
        }
        for (n = 0; n < this.objects.size(); ++n) {
            ((NetObject)this.objects.get(n)).saveObject(fileWriter);
        }
        fileWriter.write("}\n");
        fileWriter.close();
        this.currentFileName = string;
        this.setNeedToSave(false, "Save");
    }

    public void showSaveFileDialog(String string, NetFileFilter netFileFilter) {
        File file;
        int n = 0;
        JFileChooser jFileChooser = new JFileChooser(string);
        if (this.currentFileName.length() > 0) {
            jFileChooser.setSelectedFile(new File(this.currentFileName));
        }
        if (netFileFilter != null) {
            jFileChooser.addChoosableFileFilter(netFileFilter);
        } else {
            String[] stringArray = new String[]{this.defaultExtension};
            jFileChooser.addChoosableFileFilter(new NetFileFilter("Network description file", stringArray));
        }
        int n2 = jFileChooser.showSaveDialog(this);
        if (n2 == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            if (file.exists()) {
                n = JOptionPane.showConfirmDialog(this, "Do you want to overwrite " + file.getName() + " ?", "Confirm overwrite", 0);
            }
            if (n == 0) {
                String string2 = file.getAbsolutePath();
                try {
                    this.saveNetFile(string2);
                }
                catch (IOException iOException) {
                    this.error("Error during saving file:" + string2 + "\n" + iOException.getMessage());
                }
            }
        }
    }

    public void saveCurrent(String string) {
        if (this.currentFileName.length() == 0) {
            this.showSaveFileDialog(string, null);
        } else {
            try {
                this.saveNetFile(this.currentFileName);
            }
            catch (IOException iOException) {
                this.error("Error during saving file:" + this.currentFileName + "\n" + iOException.getMessage());
            }
        }
    }

    public void setAntialiasFont(boolean bl) {
        this.useAAFont = bl;
        this.repaint();
    }

    public boolean getAntialiasFont() {
        return this.useAAFont;
    }

    public void unselectAll() {
        int n = this.objects.size();
        for (int i = 0; i < n; ++i) {
            ((NetObject)this.objects.get(i)).setSelected(false);
        }
        this.selObject = null;
        this.onlyTextSelected = false;
    }

    public void selectAll() {
        int n = this.objects.size();
        this.onlyTextSelected = true;
        for (int i = 0; i < n; ++i) {
            NetObject netObject = (NetObject)this.objects.get(i);
            netObject.setSelected(true);
            this.onlyTextSelected |= netObject.type == 2;
        }
        this.selObject = null;
    }

    public void newAll() {
        int n = 0;
        if (this.objects.size() > 0 && (n = JOptionPane.showConfirmDialog(this.pFrame, "Do you want to clear all objects. ?", "Confirm new", 0)) == 0) {
            this.clearObjects();
            this.setNeedToSave(true, "New all");
            this.repaint();
        }
    }

    public void setShowArrow(boolean bl) {
        this.showArrow = bl;
        this.repaint();
    }

    public boolean isShowingArrow() {
        return this.showArrow;
    }

    public void setCreateMode(int n) {
        if (!this.isEditable) {
            return;
        }
        this.createMode = n;
        switch (n) {
            case 1: {
                this.setCursor(Cursor.getPredefinedCursor(12));
                break;
            }
            case 3: {
                this.setCursor(Cursor.getPredefinedCursor(12));
                break;
            }
            case 4: {
                this.setCursor(Cursor.getPredefinedCursor(1));
                this.unselectAll();
                this.repaint();
            }
        }
    }

    public NetObject createBubbleObject(int n, int n2) {
        return new NetObject(1, 0, 10, 10, n, n2);
    }

    public void cutSelection() {
        this.copySelection();
        this.deleteSelection();
    }

    public void copySelection() {
        NetObject netObject;
        NetObject netObject2;
        int n;
        int[] nArray = new int[this.objects.size()];
        int[] nArray2 = new int[this.objects.size()];
        if (!this.isEditable) {
            return;
        }
        this.clipboard.clear();
        for (n = 0; n < this.objects.size(); ++n) {
            nArray[n] = -1;
            nArray2[n] = -1;
        }
        int n2 = 0;
        for (n = 0; n < this.objects.size(); ++n) {
            netObject2 = (NetObject)this.objects.get(n);
            if (!netObject2.getSelected()) continue;
            netObject = netObject2.type == 2 ? netObject2.getCopyAt(netObject2.org.x + 2 * this.XGRID_SIZE, netObject2.org.y + 2 * this.YGRID_SIZE) : netObject2.getCopyAt(netObject2.org.x + 2, netObject2.org.y + 2);
            this.clipboard.add(netObject);
            nArray[n] = n2;
            nArray2[n2] = n;
            ++n2;
        }
        if (this.clipboard.size() == 0) {
            this.error("Nothing to copy, empty selection.");
            return;
        }
        for (n = 0; n < this.clipboard.size(); ++n) {
            netObject = (NetObject)this.clipboard.get(n);
            netObject2 = (NetObject)this.objects.get(nArray2[n]);
            for (n2 = 0; n2 < netObject2.getChildrenNumber(); ++n2) {
                int n3 = nArray[this.objects.indexOf(netObject2.getChildAt(n2))];
                if (n3 == -1) continue;
                netObject.addChild((NetObject)this.clipboard.get(n3));
            }
        }
    }

    public void pasteSelection() {
        if (!this.isEditable) {
            return;
        }
        if (this.clipboard.size() == 0) {
            this.error("Nothing to paste, clipboard empty.");
            return;
        }
        this.unselectAll();
        for (int i = 0; i < this.clipboard.size(); ++i) {
            NetObject netObject = (NetObject)this.clipboard.get(i);
            if (!this.addObject(netObject)) continue;
            netObject.setSelected(true);
        }
        this.copySelection();
        this.setNeedToSave(true, "Paste");
        this.repaint();
    }

    public void deleteSelection() {
        int n;
        Vector<NetObject> vector = new Vector<NetObject>();
        if (!this.isEditable) {
            return;
        }
        if (this.selObject != null && this.selObject.selSet >= 10) {
            int n2 = this.selObject.selSet - 10;
            this.selObject.removeChild(n2);
            this.unselectAll();
            this.setNeedToSave(true, "Delete link");
            this.repaint();
            return;
        }
        for (n = 0; n < this.objects.size(); ++n) {
            NetObject netObject = (NetObject)this.objects.get(n);
            if (!netObject.getSelected()) continue;
            vector.add(netObject);
        }
        if (vector.size() == 0) {
            this.error("Nothing to delete, empty selection.");
            return;
        }
        for (n = 0; n < vector.size(); ++n) {
            this.removeObject((NetObject)vector.get(n));
        }
        vector.clear();
        this.unselectAll();
        this.setNeedToSave(true, "Cut/Delete");
        this.repaint();
    }

    public boolean canUndo() {
        return this.isEditable && this.undoPos >= 2;
    }

    public String getUndoActionName() {
        if (this.canUndo()) {
            return ((UndoBuffer)this.undo.get(this.undoPos - 1)).getName();
        }
        return "";
    }

    public String getRedoActionName() {
        if (this.canRedo()) {
            return ((UndoBuffer)this.undo.get(this.undoPos)).getName();
        }
        return "";
    }

    public boolean canRedo() {
        return this.isEditable && this.undoPos < this.undo.size();
    }

    public void undo() {
        if (this.canUndo()) {
            --this.undoPos;
            this.rebuildBackup(this.undoPos - 1);
        }
    }

    public void redo() {
        if (this.canRedo()) {
            ++this.undoPos;
            this.rebuildBackup(this.undoPos - 1);
        }
    }

    public void addEditorListener(NetEditorListener netEditorListener) {
        this.listeners.add(netEditorListener);
    }

    public void removeEditorListener(NetEditorListener netEditorListener) {
        this.listeners.remove(netEditorListener);
    }

    public void clearEditorListener() {
        this.listeners.clear();
    }

    public boolean getNeedToSaveState() {
        return this.needToSave;
    }

    public void computePreferredSize() {
        int n = 320;
        int n2 = 200;
        for (int i = 0; i < this.objects.size(); ++i) {
            ((NetObject)this.objects.get(i)).updateRepaintRect();
            Rectangle rectangle = ((NetObject)this.objects.get(i)).getRepaintRect();
            if (rectangle.x + rectangle.width > n) {
                n = rectangle.x + rectangle.width;
            }
            if (rectangle.y + rectangle.height <= n2) continue;
            n2 = rectangle.y + rectangle.height;
        }
        Dimension dimension = new Dimension(n += 10, n2 += 10);
        this.setPreferredSize(dimension);
        this.setMaximumSize(dimension);
        this.invalidate();
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((NetEditorListener)this.listeners.get(i)).sizeChanged(this, dimension);
        }
    }

    public String getFileName() {
        return this.currentFileName;
    }

    public NetObject getNetObjectAt(int n) {
        return (NetObject)this.objects.get(n);
    }

    public void removeObject(NetObject netObject) {
        int n = this.objects.size();
        netObject.clearChildren();
        for (int i = 0; i < n; ++i) {
            NetObject netObject2 = (NetObject)this.objects.get(i);
            if (!netObject2.isParentOf(netObject)) continue;
            netObject2.removeChild(netObject);
        }
        this.objects.remove(netObject);
        netObject.setParent(null);
    }

    public boolean addObject(NetObject netObject) {
        if (netObject == null) {
            return false;
        }
        netObject.setParent(this);
        this.objects.add(netObject);
        return true;
    }

    public void clearObjects() {
        this.unselectAll();
        this.objects.clear();
    }

    public int getNetObjectNumber() {
        return this.objects.size();
    }

    public void showOptionDialog() {
        this.dlgOpt.showOption();
    }

    public void setNetEditorDialog(NetEditorDlg netEditorDlg) {
        this.dlgOpt = netEditorDlg;
    }

    public void setNetObjectDialog(NetObjectDlg netObjectDlg) {
        this.dlgProp = netObjectDlg;
    }

    public void setMoveableBubble(boolean bl) {
        this.moveBubble = bl;
    }

    public JFrame getParentFrame() {
        return this.pFrame;
    }

    public void setGridSize(Dimension dimension) {
        this.XGRID_SIZE = dimension.width;
        this.YGRID_SIZE = dimension.height;
        this.repaint();
    }

    public Dimension getGridSize() {
        return new Dimension(this.XGRID_SIZE, this.YGRID_SIZE);
    }

    private NetObject findObject(MouseEvent mouseEvent) {
        boolean bl = false;
        int n = -1;
        NetObject netObject = null;
        int n2 = this.objects.size();
        int n3 = mouseEvent.getX();
        int n4 = mouseEvent.getY();
        int n5 = 0;
        while (n5 < n2 && !bl) {
            netObject = (NetObject)this.objects.get(n5);
            bl = netObject.labelContains(n3, n4);
            if (bl) continue;
            ++n5;
        }
        if (bl) {
            netObject.selSet = 2;
            return netObject;
        }
        n5 = 0;
        while (n5 < n2 && !bl) {
            netObject = (NetObject)this.objects.get(n5);
            bl = netObject.contains(n3, n4);
            if (bl) continue;
            ++n5;
        }
        if (bl) {
            netObject.selSet = 1;
            return netObject;
        }
        n5 = 0;
        while (n5 < n2 && n == -1) {
            netObject = (NetObject)this.objects.get(n5);
            n = netObject.childContains(n3, n4);
            if (n != -1) continue;
            ++n5;
        }
        if (n != -1) {
            netObject.selSet = 10 + n;
            return netObject;
        }
        return null;
    }

    private void initDragObject(MouseEvent mouseEvent) {
        int n = this.objects.size();
        this.dragMode = 1;
        this.onlyTextSelected = true;
        for (int i = 0; i < n; ++i) {
            NetObject netObject = (NetObject)this.objects.get(i);
            if (!netObject.getSelected()) continue;
            netObject.resetDrag();
            this.onlyTextSelected = this.onlyTextSelected && netObject.type == 2;
        }
        this.dragStart.x = mouseEvent.getX();
        this.dragStart.y = mouseEvent.getY();
        this.setCursor(Cursor.getPredefinedCursor(13));
    }

    private void initDragSelection(MouseEvent mouseEvent) {
        this.dragMode = 2;
        this.dragStart.x = mouseEvent.getX();
        this.dragStart.y = mouseEvent.getY();
        this.selDrag.setRect(mouseEvent.getX(), mouseEvent.getY(), 0.0, 0.0);
    }

    private void initDragLabel(MouseEvent mouseEvent, NetObject netObject) {
        this.dragMode = 3;
        this.dragStart.x = mouseEvent.getX();
        this.dragStart.y = mouseEvent.getY();
        this.selObject = netObject;
        this.selObject.dragStart.x = netObject.labelOffset.x;
        this.selObject.dragStart.y = netObject.labelOffset.y;
        this.setCursor(Cursor.getPredefinedCursor(13));
    }

    private void initDragLink(MouseEvent mouseEvent, NetObject netObject) {
        this.dragStart.x = netObject.org.x * this.XGRID_SIZE;
        this.dragStart.y = netObject.org.y * this.YGRID_SIZE;
        this.selDrag.setRect(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getX(), mouseEvent.getY());
        this.lnkObject = netObject;
        this.dragMode = 4;
    }

    private void initDragMoveLink(MouseEvent mouseEvent, NetObject netObject) {
        this.unselectAll();
        this.dragStart.x = mouseEvent.getX();
        this.dragStart.y = mouseEvent.getY();
        this.selObject = netObject;
        this.lnkObject = netObject.getChildAt(netObject.selSet - 10);
        this.selObject.resetDrag();
        this.lnkObject.resetDrag();
        this.dragMode = 5;
        this.setCursor(Cursor.getPredefinedCursor(13));
    }

    private void createObject(MouseEvent mouseEvent) {
        int n = 0;
        int n2 = 0;
        NetObject netObject = null;
        switch (this.createMode) {
            case 1: {
                n = (mouseEvent.getX() + this.XGRID_SIZE / 2) / this.XGRID_SIZE;
                n2 = (mouseEvent.getY() + this.YGRID_SIZE / 2) / this.YGRID_SIZE;
                netObject = this.createBubbleObject(n, n2);
                break;
            }
            case 3: {
                netObject = new NetObject(2, 0, 0, 0, mouseEvent.getX(), mouseEvent.getY());
                netObject.setLabel("label");
            }
        }
        if (this.addObject(netObject)) {
            this.setNeedToSave(true, "Create " + netObject.getName());
        }
        netObject = null;
        this.repaint();
    }

    private void buildSelRect(int n, int n2, int n3, int n4) {
        if (n < n3) {
            if (n2 < n4) {
                this.selDrag.setRect(n, n2, n3 - n, n4 - n2);
            } else {
                this.selDrag.setRect(n, n4, n3 - n, n2 - n4);
            }
        } else if (n2 < n4) {
            this.selDrag.setRect(n3, n2, n - n3, n4 - n2);
        } else {
            this.selDrag.setRect(n3, n4, n - n3, n2 - n4);
        }
    }

    private void dragObjects(MouseEvent mouseEvent) {
        int n = 0;
        int n2 = 0;
        int n3 = this.objects.size();
        for (int i = 0; i < n3; ++i) {
            NetObject netObject = (NetObject)this.objects.get(i);
            if (!netObject.getSelected()) continue;
            if (this.onlyTextSelected) {
                n = mouseEvent.getX() - this.dragStart.x;
                n2 = mouseEvent.getY() - this.dragStart.y;
            } else {
                n = mouseEvent.getX() - this.dragStart.x;
                n = n < 0 ? (netObject.type == 2 ? (mouseEvent.getX() - this.dragStart.x - this.XGRID_SIZE / 2) / this.XGRID_SIZE * this.XGRID_SIZE : (mouseEvent.getX() - this.dragStart.x - this.XGRID_SIZE / 2) / this.XGRID_SIZE) : (netObject.type == 2 ? (mouseEvent.getX() - this.dragStart.x + this.XGRID_SIZE / 2) / this.XGRID_SIZE * this.XGRID_SIZE : (mouseEvent.getX() - this.dragStart.x + this.XGRID_SIZE / 2) / this.XGRID_SIZE);
                n2 = mouseEvent.getY() - this.dragStart.y;
                n2 = n2 < 0 ? (netObject.type == 2 ? (mouseEvent.getY() - this.dragStart.y - this.YGRID_SIZE / 2) / this.YGRID_SIZE * this.YGRID_SIZE : (mouseEvent.getY() - this.dragStart.y - this.YGRID_SIZE / 2) / this.YGRID_SIZE) : (netObject.type == 2 ? (mouseEvent.getY() - this.dragStart.y + this.YGRID_SIZE / 2) / this.YGRID_SIZE * this.YGRID_SIZE : (mouseEvent.getY() - this.dragStart.y + this.YGRID_SIZE / 2) / this.YGRID_SIZE);
            }
            if (netObject.type == 2) {
                switch (netObject.justify) {
                    case 2: {
                        netObject.org.x = this.saturateLow(netObject.dragStart.x + n, netObject.getBoundRect().width / 2);
                        netObject.org.y = this.saturateLow(netObject.dragStart.y + n2, netObject.labelAscent);
                        break;
                    }
                    case 1: {
                        netObject.org.x = this.saturateLow(netObject.dragStart.x + n, netObject.getBoundRect().width);
                        netObject.org.y = this.saturateLow(netObject.dragStart.y + n2, netObject.labelAscent);
                        break;
                    }
                    case 0: {
                        netObject.org.x = this.saturateLow(netObject.dragStart.x + n, 0);
                        netObject.org.y = this.saturateLow(netObject.dragStart.y + n2, netObject.labelAscent);
                    }
                }
                continue;
            }
            netObject.org.x = this.saturateLow(netObject.dragStart.x + n, 1);
            netObject.org.y = this.saturateLow(netObject.dragStart.y + n2, 1);
        }
    }

    private void dragLink(MouseEvent mouseEvent) {
        int n = 0;
        int n2 = 0;
        n = mouseEvent.getX() - this.dragStart.x;
        n = n < 0 ? (mouseEvent.getX() - this.dragStart.x - this.XGRID_SIZE / 2) / this.XGRID_SIZE : (mouseEvent.getX() - this.dragStart.x + this.XGRID_SIZE / 2) / this.XGRID_SIZE;
        n2 = mouseEvent.getY() - this.dragStart.y;
        n2 = n2 < 0 ? (mouseEvent.getY() - this.dragStart.y - this.YGRID_SIZE / 2) / this.YGRID_SIZE : (mouseEvent.getY() - this.dragStart.y + this.YGRID_SIZE / 2) / this.YGRID_SIZE;
        this.selObject.org.x = this.saturateLow(this.selObject.dragStart.x + n, 1);
        this.selObject.org.y = this.saturateLow(this.selObject.dragStart.y + n2, 1);
        this.lnkObject.org.x = this.saturateLow(this.lnkObject.dragStart.x + n, 1);
        this.lnkObject.org.y = this.saturateLow(this.lnkObject.dragStart.y + n2, 1);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        switch (this.dragMode) {
            case 1: {
                this.dragObjects(mouseEvent);
                this.repaint();
                break;
            }
            case 5: {
                this.dragLink(mouseEvent);
                this.repaint();
                break;
            }
            case 2: {
                this.buildSelRect(this.dragStart.x, this.dragStart.y, mouseEvent.getX(), mouseEvent.getY());
                this.repaint();
                break;
            }
            case 4: {
                this.selDrag.setRect(this.dragStart.x, this.dragStart.y, mouseEvent.getX(), mouseEvent.getY());
                this.repaint();
                break;
            }
            case 3: {
                this.selObject.labelOffset.x = this.selObject.dragStart.x + (mouseEvent.getX() - this.dragStart.x);
                this.selObject.labelOffset.y = this.selObject.dragStart.y + (mouseEvent.getY() - this.dragStart.y);
                this.repaint();
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClickedB3(MouseEvent mouseEvent) {
    }

    public void mouseClickedB1(MouseEvent mouseEvent) {
        NetObject netObject;
        if (mouseEvent.getClickCount() == 2 && (netObject = this.findObject(mouseEvent)) != null && (netObject.selSet == 1 || netObject.selSet == 2) && netObject.hasProperties()) {
            this.dlgProp.editObject(netObject);
            if (this.dlgProp.getModified()) {
                this.setNeedToSave(true, "Change properties");
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.isEditable) {
            if (mouseEvent.getButton() == 1) {
                this.mouseClickedB1(mouseEvent);
            }
            if (mouseEvent.getButton() == 3) {
                this.mouseClickedB3(mouseEvent);
            }
        } else {
            NetObject netObject = this.findObject(mouseEvent);
            if (netObject != null) {
                if (netObject.selSet == 1) {
                    this.fireObjectClicked(netObject, mouseEvent);
                } else if (netObject.selSet >= 10) {
                    this.fireLinkClicked(netObject, netObject.selSet - 10, mouseEvent);
                }
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = 0;
        int n2 = this.objects.size();
        switch (this.dragMode) {
            case 1: 
            case 3: {
                this.setCursor(Cursor.getPredefinedCursor(0));
                if (this.dragStart.x != mouseEvent.getX() || this.dragStart.y != mouseEvent.getY()) {
                    this.setNeedToSave(true, "Move object");
                }
                this.dragMode = 0;
                break;
            }
            case 5: {
                this.setCursor(Cursor.getPredefinedCursor(0));
                if (this.dragStart.x != mouseEvent.getX() || this.dragStart.y != mouseEvent.getY()) {
                    this.setNeedToSave(true, "Move link");
                }
                this.dragMode = 0;
                break;
            }
            case 2: {
                this.dragMode = 0;
                for (n = 0; n < n2; ++n) {
                    NetObject netObject = (NetObject)this.objects.get(n);
                    this.onlyTextSelected = true;
                    if (!netObject.inside(this.selDrag)) continue;
                    netObject.setSelected(true);
                    this.onlyTextSelected |= netObject.type == 2;
                }
                this.repaint();
                break;
            }
            case 4: {
                NetObject netObject = this.findObject(mouseEvent);
                if (netObject != null) {
                    if (netObject != this.lnkObject) {
                        if (netObject.acceptInput()) {
                            if (!this.lnkObject.isParentOf(netObject)) {
                                this.lnkObject.addChild(netObject);
                                this.setNeedToSave(true, "Create link");
                            } else {
                                this.error("Link already exists.");
                            }
                        } else {
                            this.error("This object does not accept more incoming link.");
                        }
                    } else {
                        this.error("Cannot link to itself.\nHint: to return to selection mode, right click");
                    }
                }
                this.dragMode = 0;
                this.repaint();
                break;
            }
            default: {
                this.dragMode = 0;
            }
        }
    }

    public void mousePressedB1(MouseEvent mouseEvent) {
        if (this.createMode != 0 && this.createMode != 4) {
            this.createObject(mouseEvent);
            return;
        }
        NetObject netObject = this.findObject(mouseEvent);
        if (netObject != null) {
            if (this.isEditable) {
                if (this.createMode == 4) {
                    if (netObject.acceptOutput()) {
                        this.unselectAll();
                        netObject.setSelected(true);
                        this.initDragLink(mouseEvent, netObject);
                        this.repaint();
                    } else {
                        this.error("This object does not accept more outgoing link.");
                    }
                    return;
                }
                if (netObject.selSet >= 10) {
                    this.initDragMoveLink(mouseEvent, netObject);
                } else {
                    if (mouseEvent.isControlDown()) {
                        netObject.setSelected(!netObject.getSelected());
                    } else if (!netObject.getSelected()) {
                        this.unselectAll();
                        netObject.setSelected(true);
                    }
                    if (!mouseEvent.isControlDown()) {
                        switch (netObject.selSet) {
                            case 1: {
                                this.initDragObject(mouseEvent);
                                break;
                            }
                            case 2: {
                                this.initDragLabel(mouseEvent, netObject);
                            }
                        }
                    }
                }
                this.repaint();
            } else if (netObject.selSet == 1 && this.moveBubble && netObject.type == 1) {
                this.unselectAll();
                netObject.setSelected(true);
                this.initDragObject(mouseEvent);
            }
        } else if (!mouseEvent.isControlDown() && this.isEditable && this.createMode == 0) {
            this.unselectAll();
            this.initDragSelection(mouseEvent);
            this.repaint();
        }
    }

    public void mousePressedB3(MouseEvent mouseEvent) {
        if (this.createMode != 0) {
            this.createMode = 0;
            this.fireCancelCreate();
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.grabFocus();
        if (mouseEvent.getButton() == 1) {
            this.mousePressedB1(mouseEvent);
        }
        if (mouseEvent.getButton() == 3) {
            this.mousePressedB3(mouseEvent);
        }
    }

    public void paintLinks(Graphics2D graphics2D) {
        for (int i = 0; i < this.objects.size(); ++i) {
            NetObject netObject = (NetObject)this.objects.get(i);
            netObject.paintLinks(graphics2D, this.showArrow, this.isEditable ? this.selObject == netObject : false);
        }
    }

    public void paintObjects(Graphics2D graphics2D) {
        int n = this.objects.size();
        for (int i = 0; i < n; ++i) {
            ((NetObject)this.objects.get(i)).paint(graphics2D);
        }
    }

    public void paint(Graphics graphics) {
        Stroke stroke;
        Dimension dimension = this.getSize();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        this.paintGrid(graphics2D);
        this.paintLinks(graphics2D);
        if (this.useAAFont) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.paintObjects(graphics2D);
        if (this.dragMode == 2) {
            stroke = graphics2D.getStroke();
            graphics2D.setStroke(dashStroke);
            graphics2D.setColor(Color.DARK_GRAY);
            graphics2D.drawRect(this.selDrag.x, this.selDrag.y, this.selDrag.width, this.selDrag.height);
            graphics2D.setStroke(stroke);
        }
        if (this.dragMode == 4) {
            stroke = graphics2D.getStroke();
            graphics2D.setStroke(dashStroke);
            graphics2D.setColor(Color.DARK_GRAY);
            graphics2D.drawLine(this.selDrag.x, this.selDrag.y, this.selDrag.width, this.selDrag.height);
            graphics2D.setStroke(stroke);
        }
    }

    private void paintGrid(Graphics2D graphics2D) {
        Dimension dimension = this.getSize();
        if (this.isEditable) {
            graphics2D.setColor(Color.BLACK);
            for (int i = 0; i < dimension.width; i += this.XGRID_SIZE) {
                for (int j = 0; j < dimension.height; j += this.YGRID_SIZE) {
                    graphics2D.drawLine(i, j, i, j);
                }
            }
        }
    }

    private void error(String string) {
        JOptionPane.showMessageDialog(this.pFrame, string, "Error", 0);
    }

    private void fireValueChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((NetEditorListener)this.listeners.get(i)).valueChanged(this);
        }
    }

    private void fireCancelCreate() {
        if (this.isEditable) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((NetEditorListener)this.listeners.get(i)).cancelCreate(this);
            }
        }
    }

    private void fireObjectClicked(NetObject netObject, MouseEvent mouseEvent) {
        if (!this.isEditable) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((NetEditorListener)this.listeners.get(i)).objectClicked(this, netObject, mouseEvent);
            }
        }
    }

    private void fireLinkClicked(NetObject netObject, int n, MouseEvent mouseEvent) {
        if (!this.isEditable) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((NetEditorListener)this.listeners.get(i)).linkClicked(this, netObject, n, mouseEvent);
            }
        }
    }

    private int saturateLow(int n, int n2) {
        if (n <= n2) {
            return n2;
        }
        return n;
    }

    private void setNeedToSave(boolean bl, String string) {
        this.needToSave = bl;
        if (this.needToSave && this.isEditable) {
            for (int i = this.undo.size() - 1; i >= this.undoPos; --i) {
                this.undo.removeElementAt(i);
            }
            this.undo.add(new UndoBuffer(this.objects, string));
            if (this.undo.size() >= 15) {
                this.undo.removeElementAt(0);
            }
            this.undoPos = this.undo.size();
        }
        this.fireValueChanged();
    }

    private void resetUndo() {
        this.undo.clear();
        this.undo.add(new UndoBuffer(this.objects, "Init"));
        this.undoPos = 1;
    }

    private void rebuildBackup(int n) {
        this.clearObjects();
        NetObject[] netObjectArray = ((UndoBuffer)this.undo.get(n)).rebuild();
        for (int i = 0; i < netObjectArray.length; ++i) {
            this.addObject(netObjectArray[i]);
        }
        this.fireValueChanged();
        this.repaint();
    }
}

