/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.image;

import fr.esrf.tangoatk.widget.image.IImageManipulator;
import fr.esrf.tangoatk.widget.image.IImagePanel;
import fr.esrf.tangoatk.widget.image.IImageViewer;
import fr.esrf.tangoatk.widget.util.IApplicable;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class ConvolveFilter
extends JPanel
implements IImageManipulator,
IImagePanel,
IApplicable {
    IImageViewer viewer;
    boolean customFilter = false;
    int i = 0;
    final float ninth = 0.11111111f;
    float[] edge = new float[]{0.0f, -1.0f, 0.0f, -1.0f, 4.0f, -1.0f, 0.0f, -1.0f, 0.0f};
    float[] sharpen = new float[]{0.0f, -1.0f, 0.0f, -1.0f, 5.0f, -1.0f, 0.0f, -1.0f, 0.0f};
    float[] blur = new float[]{0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f};
    Kernel kernel;
    ConvolveOp cop;
    ButtonGroup group = new ButtonGroup();
    JRadioButton edgeButton = new JRadioButton("Edge");
    JRadioButton blurButton = new JRadioButton("Blur");
    JRadioButton sharpButton = new JRadioButton("Sharpen");
    JRadioButton resetButton = new JRadioButton("No filter");
    float[] myFilter = new float[]{0.0f, -1.0f, 0.0f, -1.0f, 4.0f, -1.0f, 0.0f, -1.0f, 0.0f};
    float[] currentFilter = this.myFilter;
    JRadioButton setButton = new JRadioButton("Custom");
    boolean newFilter = false;
    boolean filter = false;
    MyTableModel tableModel = new MyTableModel();
    JTable table = new JTable(this.tableModel);

    public ConvolveFilter() {
        this.group.add(this.edgeButton);
        this.group.add(this.blurButton);
        this.group.add(this.sharpButton);
        this.group.add(this.setButton);
        this.group.add(this.resetButton);
        this.resetButton.setSelected(true);
        this.resetAction();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.kernel = new Kernel(3, 3, this.sharpen);
        this.cop = new ConvolveOp(this.kernel);
        this.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        this.add((Component)this.edgeButton, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.add((Component)this.blurButton, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.add((Component)this.sharpButton, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.add((Component)this.setButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        this.add((Component)this.resetButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        this.add((Component)this.table, gridBagConstraints);
        this.edgeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConvolveFilter.this.edgeAction();
            }
        });
        this.setButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConvolveFilter.this.setAction();
            }
        });
        this.blurButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConvolveFilter.this.blurAction();
            }
        });
        this.resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConvolveFilter.this.resetAction();
            }
        });
        this.sharpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConvolveFilter.this.sharpAction();
            }
        });
    }

    protected void edgeAction() {
        this.currentFilter = this.edge;
        this.tableModel.filterChanged();
        this.filter = true;
        this.newFilter = true;
    }

    protected void setAction() {
        this.currentFilter = this.myFilter;
        this.tableModel.filterChanged();
        this.filter = true;
        this.newFilter = true;
    }

    protected void blurAction() {
        this.currentFilter = this.blur;
        this.tableModel.filterChanged();
        this.filter = true;
        this.newFilter = true;
    }

    protected void resetAction() {
        this.table.setBackground(this.getBackground());
        this.filter = false;
    }

    protected void sharpAction() {
        this.currentFilter = this.sharpen;
        this.tableModel.filterChanged();
        this.filter = true;
        this.newFilter = true;
    }

    public String getName() {
        return "ConvolveOps";
    }

    public JComponent getComponent() {
        return this;
    }

    public BufferedImage filter(BufferedImage bufferedImage) {
        if (this.filter) {
            System.out.println("filtering...");
            this.newFilter = false;
            return this.cop.filter(bufferedImage, null);
        }
        return bufferedImage;
    }

    public void setModel(IImageViewer iImageViewer) {
        this.setImageViewer(iImageViewer);
    }

    public void setImageViewer(IImageViewer iImageViewer) {
        this.viewer = iImageViewer;
    }

    public void roiChanged(int n, int n2, int n3, int n4) {
    }

    public void ok() {
        this.apply();
        this.cancel();
    }

    public void cancel() {
        this.getRootPane().getParent().setVisible(false);
    }

    public void apply() {
        this.kernel = new Kernel(3, 3, this.currentFilter);
        this.cop = new ConvolveOp(this.kernel);
        this.viewer.repaint();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(new ConvolveFilter());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    class MyTableModel
    extends AbstractTableModel {
        MyTableModel() {
        }

        public int getRowCount() {
            return 3;
        }

        public void filterChanged() {
            ConvolveFilter.this.table.setBackground(Color.white);
            this.fireTableStructureChanged();
        }

        public int getColumnCount() {
            return 3;
        }

        public Object getValueAt(int n, int n2) {
            return new Float(ConvolveFilter.this.currentFilter[n * this.getColumnCount() + n2]);
        }

        public void setValueAt(Object object, int n, int n2) {
            ConvolveFilter.this.currentFilter[n * this.getColumnCount() + n2] = ((Float)object).floatValue();
        }

        public Class getColumnClass(int n) {
            return Float.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return ConvolveFilter.this.setButton.isSelected();
        }
    }
}

