/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.command;

import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IResultListener;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.core.ResultEvent;
import fr.esrf.tangoatk.widget.command.PropertyFrame;
import fr.esrf.tangoatk.widget.command.ScalarCommandInput;
import fr.esrf.tangoatk.widget.command.SimpleCommandOutput;
import fr.esrf.tangoatk.widget.device.DeviceViewer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class SimpleCommandViewer
extends JPanel
implements IResultListener {
    ICommand model;
    DeviceViewer dv = new DeviceViewer();
    JFrame deviceFrame = new JFrame();
    List<List> input = new Vector<List>();
    public PropertyFrame propertyFrame = new PropertyFrame();
    private JButton infoButton;
    private JButton deviceButton;
    private JLabel descriptionLabel;
    private ScalarCommandInput scalarCommandInput;
    private SimpleCommandOutput simpleCommandOutput;

    public ICommand getModel() {
        return this.model;
    }

    public void setModel(ICommand iCommand) {
        if (this.model != null) {
            this.model.removeResultListener((IResultListener)this);
        }
        this.model = iCommand;
        if (this.getBorder() != null) {
            ((TitledBorder)this.getBorder()).setTitle(this.model.getName());
        }
        this.clearInput();
        this.clearOutput();
        this.model.addResultListener((IResultListener)this);
        this.propertyFrame.setModel(this.model);
        this.propertyFrame.pack();
        this.dv.setModel(this.model.getDevice());
        this.deviceFrame.getContentPane().add(this.dv);
        this.deviceFrame.pack();
        this.scalarCommandInput.setInputEnabled(this.model.takesInput());
        Property property = this.model.getProperty("in_type_desc");
        if (property != null) {
            this.descriptionLabel.setText(property.getPresentation());
        }
    }

    private void initComponents() {
        this.infoButton = new JButton();
        this.deviceButton = new JButton();
        this.descriptionLabel = new JLabel();
        this.scalarCommandInput = new ScalarCommandInput();
        this.simpleCommandOutput = new SimpleCommandOutput();
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder("Not Connected"));
        this.infoButton.setText("Info");
        this.infoButton.setToolTipText("Click to get Command info");
        this.infoButton.addActionListener(new _cls1());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.infoButton, gridBagConstraints);
        this.deviceButton.setText("Device");
        this.deviceButton.addActionListener(new _cls2());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.deviceButton, gridBagConstraints);
        this.descriptionLabel.setFont(new Font("Dialog", 0, 12));
        this.descriptionLabel.setHorizontalAlignment(2);
        this.descriptionLabel.setText("Not Connected");
        this.descriptionLabel.setBorder(new TitledBorder("Description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.descriptionLabel, gridBagConstraints);
        this.scalarCommandInput.setMinimumSize(new Dimension(200, 17));
        this.scalarCommandInput.setPreferredSize(new Dimension(200, 60));
        this.scalarCommandInput.addPropertyChangeListener(new _cls3());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.01;
        this.add((Component)this.scalarCommandInput, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.3;
        this.add((Component)this.simpleCommandOutput, gridBagConstraints);
    }

    private void scalarCommandInputPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("execute".equals(propertyChangeEvent.getPropertyName())) {
            this.input.set(0, this.scalarCommandInput.getInput());
            if (this.model == null) {
                return;
            }
            this.model.execute(this.input);
        }
    }

    private void deviceButtonActionPerformed(ActionEvent actionEvent) {
        this.deviceFrame.setVisible(true);
    }

    private void infoButtonActionPerformed(ActionEvent actionEvent) {
        this.propertyFrame.setVisible(true);
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.simpleCommandOutput.setResult(errorEvent.getError().toString());
    }

    public void resultChange(ResultEvent resultEvent) {
        this.simpleCommandOutput.setResult(resultEvent.getResult());
    }

    public void setDeviceButtonVisible(boolean bl) {
        this.deviceButton.setVisible(bl);
    }

    public boolean isDeviceButtonVisible() {
        return this.deviceButton.isVisible();
    }

    public void setDescriptionVisible(boolean bl) {
        this.descriptionLabel.setVisible(bl);
    }

    public boolean isDescriptionVisible() {
        return this.descriptionLabel.isVisible();
    }

    public void setInfoButtonVisible(boolean bl) {
        this.infoButton.setVisible(bl);
    }

    public boolean isInfoButtonVisible() {
        return this.infoButton.isVisible();
    }

    public void setInputVisible(boolean bl) {
        this.scalarCommandInput.setVisible(bl);
    }

    public boolean isInputVisible() {
        return this.scalarCommandInput.isVisible();
    }

    public void setOutputVisible(boolean bl) {
        this.simpleCommandOutput.setVisible(bl);
    }

    public boolean isOutputVisible() {
        return this.simpleCommandOutput.isVisible();
    }

    public void clearInput() {
        this.scalarCommandInput.setInput(null);
    }

    public void clearOutput() {
        this.simpleCommandOutput.setResult("");
    }

    public void setOutputFont(Font font) {
        if (this.simpleCommandOutput == null) {
            return;
        }
        this.simpleCommandOutput.setFont(font);
    }

    public Font getOutputFont() {
        if (this.simpleCommandOutput == null) {
            return this.getFont();
        }
        return this.simpleCommandOutput.getFont();
    }

    public void setInputFont(Font font) {
        if (this.scalarCommandInput == null) {
            return;
        }
        this.scalarCommandInput.setFont(font);
    }

    public Font getInputFont() {
        if (this.scalarCommandInput == null) {
            return this.getFont();
        }
        return this.scalarCommandInput.getFont();
    }

    public void setDescriptionFont(Font font) {
        if (this.descriptionLabel == null) {
            return;
        }
        this.descriptionLabel.setFont(font);
    }

    public Font getDescriptionFont() {
        if (this.descriptionLabel == null) {
            return this.getFont();
        }
        return this.descriptionLabel.getFont();
    }

    public void setDeviceButtonFont(Font font) {
        if (this.deviceButton == null) {
            return;
        }
        this.deviceButton.setFont(font);
    }

    public Font getDeviceButtonFont() {
        if (this.deviceButton == null) {
            return this.getFont();
        }
        return this.deviceButton.getFont();
    }

    public void setInfoButtonFont(Font font) {
        if (this.infoButton == null) {
            return;
        }
        this.infoButton.setFont(font);
    }

    public Font getInfoButtonFont() {
        if (this.infoButton == null) {
            return this.getFont();
        }
        return this.infoButton.getFont();
    }

    private void serializeInit() {
        System.out.println(this.scalarCommandInput + " " + this.deviceButton + " " + this.infoButton);
        this.scalarCommandInput.addPropertyChangeListener(new _cls3());
        this.deviceButton.addActionListener(new _cls2());
        this.infoButton.addActionListener(new _cls1());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.serializeInit();
    }

    public static void main(String[] stringArray) throws Exception {
        CommandList commandList = new CommandList();
        commandList.add("eas/test-api/1/IOString");
        SimpleCommandViewer simpleCommandViewer = new SimpleCommandViewer();
        simpleCommandViewer.setModel((ICommand)commandList.get(0));
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(simpleCommandViewer);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public SimpleCommandViewer() {
        this.initComponents();
        this.input.add(new Vector());
    }

    private class _cls3
    implements PropertyChangeListener {
        private _cls3() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SimpleCommandViewer.this.scalarCommandInputPropertyChange(propertyChangeEvent);
        }
    }

    private class _cls2
    implements ActionListener {
        private _cls2() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleCommandViewer.this.deviceButtonActionPerformed(actionEvent);
        }
    }

    private class _cls1
    implements ActionListener {
        private _cls1() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleCommandViewer.this.infoButtonActionPerformed(actionEvent);
        }
    }
}

