/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.command;

import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IResultListener;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.core.ResultEvent;
import fr.esrf.tangoatk.widget.command.CommandInputOutputFactory;
import fr.esrf.tangoatk.widget.command.CommandOutput;
import fr.esrf.tangoatk.widget.command.IInput;
import fr.esrf.tangoatk.widget.command.NoInput;
import fr.esrf.tangoatk.widget.command.PropertyFrame;
import fr.esrf.tangoatk.widget.device.DeviceViewer;
import fr.esrf.tangoatk.widget.util.ButtonBar;
import fr.esrf.tangoatk.widget.util.IControlee;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class AnyCommandViewer
extends JPanel
implements IResultListener {
    ICommand model = null;
    DeviceViewer dv;
    JFrame deviceFrame;
    public PropertyFrame propertyFrame;
    private JButton infoButton = null;
    private JButton deviceButton = null;
    private JLabel descriptionLabel;
    private IInput commandInput = null;
    private CommandOutput commandOutput = null;
    private IControlee controlee = new CommandArgControlee();
    private ButtonBar buttonBar1;

    public AnyCommandViewer() {
        this.dv = new DeviceViewer();
        this.deviceFrame = new JFrame();
        this.propertyFrame = new PropertyFrame();
    }

    public AnyCommandViewer(ICommand iCommand) {
        this.dv = new DeviceViewer();
        this.deviceFrame = new JFrame();
        this.propertyFrame = new PropertyFrame();
        this.setModel(iCommand);
        try {
            this.initComponents();
        }
        catch (Exception exception) {
            throw new IllegalStateException("Please do a initialize(ICommand) with a not null icommand. ");
        }
    }

    public void initialize(ICommand iCommand) {
        if (this.model != null) {
            this.model.removeResultListener((IResultListener)this);
        }
        this.model = iCommand;
        this.model.addResultListener((IResultListener)this);
        this.propertyFrame.setModel(this.model);
        this.propertyFrame.pack();
        this.dv.setModel(this.model.getDevice());
        this.deviceFrame.getContentPane().add(this.dv);
        this.deviceFrame.pack();
        try {
            Property property;
            if (this.infoButton == null) {
                this.initComponents();
            } else {
                if (this.commandInput != null) {
                    this.remove((JPanel)((Object)this.commandInput));
                }
                if (this.commandOutput != null) {
                    this.remove(this.commandOutput);
                }
                this.commandInput = null;
                this.commandOutput = null;
                this.createInputOutput();
            }
            if (this.getBorder() != null) {
                ((TitledBorder)this.getBorder()).setTitle(this.model.getName());
            }
            if ((property = this.model.getProperty("out_type_desc")) != null) {
                this.descriptionLabel.setText(property.getPresentation());
            }
            this.clearInput();
            this.clearOutput();
        }
        catch (Exception exception) {
            throw new IllegalStateException("Please do a initialize(ICommand) with a not null icommand. ");
        }
    }

    public ICommand getModel() {
        return this.model;
    }

    public void setModel(ICommand iCommand) {
        Property property;
        if (this.infoButton == null) {
            throw new IllegalStateException("This AnyCommandViewer object has never been initialized.\nPlease use initialize(ICommand) instead of setModel(ICommand). ");
        }
        if (this.model != null) {
            this.model.removeResultListener((IResultListener)this);
        }
        this.model = iCommand;
        this.model.addResultListener((IResultListener)this);
        this.propertyFrame.setModel(this.model);
        this.propertyFrame.pack();
        this.dv.setModel(this.model.getDevice());
        this.deviceFrame.getContentPane().add(this.dv);
        this.deviceFrame.pack();
        if (this.commandInput != null) {
            this.remove((JPanel)((Object)this.commandInput));
        }
        if (this.commandOutput != null) {
            this.remove(this.commandOutput);
        }
        this.commandInput = null;
        this.commandOutput = null;
        this.createInputOutput();
        if (this.getBorder() != null) {
            ((TitledBorder)this.getBorder()).setTitle(this.model.getName());
        }
        if ((property = this.model.getProperty("out_type_desc")) != null) {
            this.descriptionLabel.setText(property.getPresentation());
        }
        this.clearInput();
        this.clearOutput();
    }

    private void initComponents() {
        this.infoButton = new JButton();
        this.deviceButton = new JButton();
        this.descriptionLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder("Not Connected"));
        if (this.getBorder() != null) {
            ((TitledBorder)this.getBorder()).setTitle(this.model.getName());
        }
        this.descriptionLabel.setFont(new Font("Dialog", 0, 12));
        this.descriptionLabel.setHorizontalAlignment(2);
        this.descriptionLabel.setText("Not Connected");
        this.descriptionLabel.setBorder(new TitledBorder("Description"));
        Property property = this.model.getProperty("out_type_desc");
        if (property != null) {
            this.descriptionLabel.setText(property.getPresentation());
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.descriptionLabel, gridBagConstraints);
        this.infoButton.setText("Info");
        this.infoButton.setToolTipText("Click to get Command info");
        this.infoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnyCommandViewer.this.infoButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.infoButton, gridBagConstraints);
        this.deviceButton.setText("Device");
        this.deviceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnyCommandViewer.this.deviceButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.deviceButton, gridBagConstraints);
        this.createInputOutput();
        this.buttonBar1 = new ButtonBar();
        this.buttonBar1.setControlee(this.controlee);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.buttonBar1, gridBagConstraints);
    }

    private void createInputOutput() {
        GridBagConstraints gridBagConstraints;
        this.commandInput = CommandInputOutputFactory.getInstance().getInputter4Command(this.model);
        if (this.commandInput != null && this.commandInput instanceof NoInput) {
            this.commandInput = null;
        }
        if (this.commandInput != null) {
            this.commandInput.setInputEnabled(this.model.takesInput());
            JPanel jPanel = (JPanel)((Object)this.commandInput);
            jPanel.addPropertyChangeListener(new _cls1());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.3;
            this.add((Component)jPanel, gridBagConstraints);
        }
        this.commandOutput = new CommandOutput();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.7;
        this.add((Component)this.commandOutput, gridBagConstraints);
    }

    private void commandInputPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("execute".equals(propertyChangeEvent.getPropertyName())) {
            if (this.model == null) {
                return;
            }
            if (this.model.takesInput()) {
                if (this.commandInput == null) {
                    return;
                }
                if (this.commandInput instanceof NoInput) {
                    return;
                }
                List list = this.commandInput.getInput();
                this.model.execute(list);
            } else {
                this.model.execute();
            }
        }
    }

    private void deviceButtonActionPerformed(ActionEvent actionEvent) {
        this.deviceFrame.setVisible(true);
    }

    private void infoButtonActionPerformed(ActionEvent actionEvent) {
        this.propertyFrame.setVisible(true);
    }

    public void errorChange(ErrorEvent errorEvent) {
        if (this.commandOutput == null) {
            return;
        }
        this.commandOutput.setResult(errorEvent.getError().toString());
    }

    public void resultChange(ResultEvent resultEvent) {
        if (this.commandOutput == null) {
            return;
        }
        this.commandOutput.setResult(resultEvent.getResult());
    }

    public void setDeviceButtonVisible(boolean bl) {
        this.deviceButton.setVisible(bl);
    }

    public boolean isDeviceButtonVisible() {
        return this.deviceButton.isVisible();
    }

    public void setDescriptionVisible(boolean bl) {
        this.descriptionLabel.setVisible(bl);
    }

    public boolean isDescriptionVisible() {
        return this.descriptionLabel.isVisible();
    }

    public void setInfoButtonVisible(boolean bl) {
        this.infoButton.setVisible(bl);
    }

    public boolean isInfoButtonVisible() {
        return this.infoButton.isVisible();
    }

    public void setInputVisible(boolean bl) {
        if (this.commandInput == null) {
            return;
        }
        this.commandInput.setVisible(bl);
    }

    public boolean isInputVisible() {
        if (this.commandInput == null) {
            return false;
        }
        return this.commandInput.isVisible();
    }

    public void setOutputVisible(boolean bl) {
        if (this.commandOutput == null) {
            return;
        }
        this.commandOutput.setVisible(bl);
    }

    public boolean isOutputVisible() {
        if (this.commandOutput == null) {
            return false;
        }
        return this.commandOutput.isVisible();
    }

    public void clearInput() {
        if (this.commandInput == null) {
            return;
        }
        this.commandInput.setInput(null);
    }

    public void clearOutput() {
        if (this.commandOutput == null) {
            return;
        }
        this.commandOutput.setResult("");
    }

    public void setOutputFont(Font font) {
        if (this.commandOutput == null) {
            return;
        }
        this.commandOutput.setFont(font);
    }

    public Font getOutputFont() {
        if (this.commandOutput == null) {
            return this.getFont();
        }
        return this.commandOutput.getFont();
    }

    public void setInputFont(Font font) {
        if (this.commandInput == null) {
            return;
        }
        this.commandInput.setFont(font);
    }

    public Font getInputFont() {
        if (this.commandInput == null) {
            return this.getFont();
        }
        return this.commandInput.getFont();
    }

    public void setDescriptionFont(Font font) {
        if (this.descriptionLabel == null) {
            return;
        }
        this.descriptionLabel.setFont(font);
    }

    public Font getDescriptionFont() {
        if (this.descriptionLabel == null) {
            return this.getFont();
        }
        return this.descriptionLabel.getFont();
    }

    public void setDeviceButtonFont(Font font) {
        if (this.deviceButton == null) {
            return;
        }
        this.deviceButton.setFont(font);
    }

    public Font getDeviceButtonFont() {
        if (this.deviceButton == null) {
            return this.getFont();
        }
        return this.deviceButton.getFont();
    }

    public void setInfoButtonFont(Font font) {
        if (this.infoButton == null) {
            return;
        }
        this.infoButton.setFont(font);
    }

    public Font getInfoButtonFont() {
        if (this.infoButton == null) {
            return this.getFont();
        }
        return this.infoButton.getFont();
    }

    public static void main(String[] stringArray) throws Exception {
        CommandList commandList = new CommandList();
        commandList.add("eas/test-api/1/IOString");
        AnyCommandViewer anyCommandViewer = new AnyCommandViewer();
        anyCommandViewer.setModel((ICommand)commandList.get(0));
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(anyCommandViewer);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private class _cls1
    implements PropertyChangeListener {
        private _cls1() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AnyCommandViewer.this.commandInputPropertyChange(propertyChangeEvent);
        }
    }

    class CommandArgControlee
    implements IControlee {
        CommandArgControlee() {
        }

        public void ok() {
            AnyCommandViewer.this.getRootPane().getParent().setVisible(false);
        }

        public void cancel() {
            AnyCommandViewer.this.getRootPane().getParent().setVisible(false);
        }
    }
}

