/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IStringImage;
import fr.esrf.tangoatk.core.IStringImageListener;
import fr.esrf.tangoatk.core.StringImageEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.Color;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class StringImageTableViewer
extends JTable
implements IStringImageListener {
    private IStringImage attModel = null;
    private DefaultTableModel tabModel = null;
    private String[] columnIdents = null;
    private boolean qualityEnabled = false;
    private Color background = this.getBackground();

    public StringImageTableViewer() {
        this.tabModel = new DefaultTableModel();
        super.setModel(this.tabModel);
    }

    public IStringImage getAttModel() {
        return this.attModel;
    }

    public void setAttModel(IStringImage iStringImage) {
        if (this.attModel != null) {
            this.attModel.removeStringImageListener((IStringImageListener)this);
            this.attModel = null;
        }
        if (iStringImage != null) {
            this.attModel = iStringImage;
            this.attModel.addStringImageListener((IStringImageListener)this);
            this.attModel.refresh();
            this.setStringImageValue(this.attModel.getValue());
        } else {
            this.setStringImageValue(null);
        }
    }

    public boolean getQualityEnabled() {
        return this.qualityEnabled;
    }

    public void setQualityEnabled(boolean bl) {
        this.qualityEnabled = bl;
        if (!this.qualityEnabled) {
            super.setBackground(this.background);
            this.repaint();
        }
    }

    public String[] getColumnIdents() {
        return this.columnIdents;
    }

    public void setColumnIdents(String[] stringArray) {
        this.columnIdents = stringArray;
        this.tabModel.setColumnIdentifiers(stringArray);
    }

    public void clearModel() {
        this.setAttModel(null);
    }

    public void setBackground(Color color) {
        this.background = color;
        super.setBackground(color);
    }

    public void stringImageChange(StringImageEvent stringImageEvent) {
        this.setStringImageValue(stringImageEvent.getValue());
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
        String string = attributeStateEvent.getState();
        if (!this.qualityEnabled) {
            return;
        }
        super.setBackground(ATKConstant.getColor4Quality(string));
        this.repaint();
    }

    public void errorChange(ErrorEvent errorEvent) {
    }

    protected void setStringImageValue(String[][] stringArray) {
        if (stringArray == null) {
            this.tabModel = new DefaultTableModel();
            super.setModel(this.tabModel);
            return;
        }
        this.tabModel.setDataVector(stringArray, this.columnIdents);
    }

    public static void main(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        JFrame jFrame = new JFrame();
        StringImageTableViewer stringImageTableViewer = new StringImageTableViewer();
        try {
            IEntity iEntity = attributeList.add("tests/machine/status/operatorMessageHistory");
            if (!(iEntity instanceof IStringImage)) {
                System.out.println("tests/machine/status/operatorMessageHistory is not a IStringImage");
                System.exit(0);
            }
            IStringImage iStringImage = (IStringImage)iEntity;
            stringImageTableViewer.setAttModel(iStringImage);
        }
        catch (Exception exception) {
            System.out.println("Cannot connect to tests/machine/status");
        }
        jFrame.setContentPane(stringImageTableViewer);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

