/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.BooleanScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;

public class SignalScalarComboEditor
extends JComboBox
implements ActionListener,
IBooleanScalarListener,
INumberScalarListener,
ISetErrorListener {
    protected IAttribute attModel = null;
    protected String trueLabel = "True";
    protected String falseLabel = "False";
    protected DefaultComboBoxModel comboModel = null;
    protected String defActionCmd = "setAttActionCmd";
    protected String[] optionList = new String[]{this.trueLabel, this.falseLabel};
    protected static final int trueIndex = 0;
    protected static final int falseIndex = 1;

    public SignalScalarComboEditor() {
        this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
        this.setModel(this.comboModel);
        this.setActionCommand(this.defActionCmd);
        this.addActionListener(this);
    }

    public IAttribute getAttModel() {
        return this.attModel;
    }

    public void setBooleanScalarModel(IBooleanScalar iBooleanScalar) {
        if (this.attModel != null) {
            this.clearModel();
        }
        if (iBooleanScalar == null) {
            return;
        }
        if (!iBooleanScalar.isWritable()) {
            throw new IllegalArgumentException("SignalScalarComboEditor: Only accept writeable attribute.");
        }
        this.optionList = new String[]{this.trueLabel, this.falseLabel};
        this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
        this.setModel(this.comboModel);
        this.attModel = iBooleanScalar;
        ((IBooleanScalar)this.attModel).addBooleanScalarListener((IBooleanScalarListener)this);
        this.attModel.addSetErrorListener((ISetErrorListener)this);
        this.attModel.refresh();
        this.repaint();
    }

    public void setNumberScalarModel(INumberScalar iNumberScalar) {
        if (this.attModel != null) {
            this.clearModel();
        }
        if (iNumberScalar == null) {
            return;
        }
        if (!iNumberScalar.isWritable()) {
            throw new IllegalArgumentException("SignalScalarComboEditor: Only accept writeable attribute.");
        }
        this.optionList = new String[]{this.trueLabel, this.falseLabel};
        this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
        this.setModel(this.comboModel);
        this.attModel = iNumberScalar;
        ((INumberScalar)this.attModel).addNumberScalarListener((INumberScalarListener)this);
        this.attModel.addSetErrorListener((ISetErrorListener)this);
        this.attModel.refresh();
        this.repaint();
    }

    public void clearModel() {
        if (this.attModel != null) {
            if (this.attModel instanceof IBooleanScalar) {
                ((IBooleanScalar)this.attModel).removeBooleanScalarListener((IBooleanScalarListener)this);
            } else if (this.attModel instanceof INumberScalar) {
                ((INumberScalar)this.attModel).removeNumberScalarListener((INumberScalarListener)this);
            }
            this.attModel.removeSetErrorListener((ISetErrorListener)this);
            this.attModel = null;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        JComboBox jComboBox = null;
        if (!actionEvent.getActionCommand().equals(this.defActionCmd)) {
            return;
        }
        if (this.attModel == null) {
            return;
        }
        jComboBox = (JComboBox)actionEvent.getSource();
        if (jComboBox.getSelectedIndex() < 0) {
            return;
        }
        boolean bl2 = bl = jComboBox.getSelectedIndex() == 0;
        if (this.attModel instanceof IBooleanScalar) {
            if (bl) {
                ((IBooleanScalar)this.attModel).setValue(true);
            } else {
                ((IBooleanScalar)this.attModel).setValue(false);
            }
        } else if (this.attModel instanceof INumberScalar) {
            if (bl) {
                ((INumberScalar)this.attModel).setValue(1.0);
            } else {
                ((INumberScalar)this.attModel).setValue(0.0);
            }
        }
    }

    public void booleanScalarChange(BooleanScalarEvent booleanScalarEvent) {
        boolean bl = this.hasFocus() ? ((IBooleanScalar)this.attModel).getDeviceSetPoint() : ((IBooleanScalar)this.attModel).getSetPoint();
        this.changeCurrentSelection(bl);
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.disableExecution();
        this.setSelectedIndex(-1);
        this.repaint();
        this.enableExecution();
    }

    public void setErrorOccured(ErrorEvent errorEvent) {
        if (this.attModel == null) {
            return;
        }
        if (errorEvent.getSource() != this.attModel) {
            return;
        }
        if (this.attModel instanceof IBooleanScalar) {
            this.changeCurrentSelection(((IBooleanScalar)this.attModel).getDeviceSetPoint());
        } else if (this.attModel instanceof INumberScalar) {
            this.changeCurrentSelection(((INumberScalar)this.attModel).getNumberScalarDeviceSetPoint() != 0.0);
        }
    }

    protected void changeCurrentSelection(boolean bl) {
        this.disableExecution();
        if (bl) {
            this.setSelectedIndex(0);
        } else {
            this.setSelectedIndex(1);
        }
        this.repaint();
        this.enableExecution();
    }

    public void enableExecution() {
        this.setActionCommand(this.defActionCmd);
    }

    public void disableExecution() {
        this.setActionCommand("dummy");
    }

    public static void main(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        JFrame jFrame = new JFrame();
        SignalScalarComboEditor signalScalarComboEditor = new SignalScalarComboEditor();
        String string = "tango/tangotest/1/boolean_scalar";
        try {
            IEntity iEntity;
            if (stringArray.length > 0) {
                string = stringArray[0];
            }
            if (!((iEntity = attributeList.add(string)) instanceof IBooleanScalar) && !(iEntity instanceof INumberScalar)) {
                System.out.println(string + " is not a valid attribute");
                System.exit(0);
            }
            if (iEntity instanceof IBooleanScalar) {
                signalScalarComboEditor.setBooleanScalarModel((IBooleanScalar)iEntity);
            } else {
                signalScalarComboEditor.setNumberScalarModel((INumberScalar)iEntity);
            }
        }
        catch (Exception exception) {
            System.out.println("Cannot connect to " + string);
        }
        attributeList.startRefresher();
        jFrame.setContentPane(signalScalarComboEditor);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public String getFalseLabel() {
        return this.falseLabel;
    }

    public void setFalseLabel(String string) {
        this.falseLabel = string;
    }

    public String getTrueLabel() {
        return this.trueLabel;
    }

    public void setTrueLabel(String string) {
        this.trueLabel = string;
    }

    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        boolean bl = this.hasFocus() ? ((INumberScalar)this.attModel).getNumberScalarDeviceSetPoint() != 0.0 : ((INumberScalar)this.attModel).getNumberScalarSetPoint() != 0.0;
        this.changeCurrentSelection(bl);
    }
}

