/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributePolledList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class DualNumberScalarChart
extends JLChart
implements INumberScalarListener {
    private JLDataView pointView = new JLDataView();
    private JLDataView midleLineView = new JLDataView();
    private int markerStyle = 1;
    private boolean middleLineVisible = true;
    private INumberScalar xattribute = null;
    private INumberScalar yattribute = null;
    private double defaultXMinValue = -100.0;
    private double defaultXMaxValue = 100.0;
    private double defaultXMinAlarm = -100.0;
    private double defaultXMaxAlarm = 100.0;
    private double defaultYMinValue = -100.0;
    private double defaultYMaxValue = 100.0;
    private double defaultYMinAlarm = -100.0;
    private double defaultYMaxAlarm = 100.0;

    public DualNumberScalarChart() {
        this.initComponents();
    }

    public int getMarkerStyle() {
        return this.markerStyle;
    }

    public void setMarkerStyle(int n) {
        this.markerStyle = n;
        if (this.pointView != null) {
            this.pointView.setMarker(this.markerStyle);
            this.repaint();
        }
    }

    protected void initComponents() {
        this.setSize(640, 480);
        this.setHeaderVisible(true);
        this.setLabelVisible(true);
        this.getXAxis().setDrawOpposite(true);
        this.setXAxisOnBottom(false);
        this.setMarkerStyle(this.markerStyle);
        this.getY1Axis().setDrawOpposite(true);
        this.getY1Axis().setAutoScale(false);
        this.getY1Axis().setGridVisible(true);
        this.getY1Axis().setSubGridVisible(true);
        this.getY1Axis().setMinimum(this.defaultYMinValue);
        this.getY1Axis().setMaximum(this.defaultYMaxValue);
        this.getXAxis().setAutoScale(false);
        this.getXAxis().setMinimum(this.defaultXMinValue);
        this.getXAxis().setMaximum(this.defaultXMaxValue);
        this.getXAxis().setAnnotation(2);
        this.getXAxis().setGridVisible(false);
        this.getXAxis().setSubGridVisible(true);
        this.setPaintAxisFirst(false);
    }

    public void setXYModel(INumberScalar iNumberScalar, INumberScalar iNumberScalar2) {
        if (this.xattribute != null || this.yattribute != null) {
            this.clearXYModel();
        }
        if (iNumberScalar == null || iNumberScalar2 == null) {
            return;
        }
        this.xattribute = iNumberScalar;
        this.yattribute = iNumberScalar2;
        if (this.xattribute.getMaxValue() > this.defaultXMaxValue) {
            this.setDefaultXMaxValue(this.xattribute.getMaxValue());
        }
        if (this.xattribute.getMaxAlarm() < this.defaultXMaxAlarm) {
            this.setDefaultXMaxAlarm(this.xattribute.getMaxAlarm());
        }
        if (this.xattribute.getMinValue() < this.defaultXMinValue) {
            this.setDefaultXMinValue(this.xattribute.getMinValue());
        }
        if (this.xattribute.getMinAlarm() > this.defaultXMinAlarm) {
            this.setDefaultXMinAlarm(this.xattribute.getMinAlarm());
        }
        if (this.yattribute.getMaxValue() > this.defaultYMaxValue) {
            this.setDefaultYMaxValue(this.yattribute.getMaxValue());
        }
        if (this.yattribute.getMaxAlarm() < this.defaultYMaxAlarm) {
            this.setDefaultYMaxAlarm(this.yattribute.getMaxAlarm());
        }
        if (this.yattribute.getMinValue() < this.defaultYMinValue) {
            this.setDefaultYMinValue(this.yattribute.getMinValue());
        }
        if (this.yattribute.getMinAlarm() > this.defaultYMinAlarm) {
            this.setDefaultYMinAlarm(this.yattribute.getMinAlarm());
        }
        this.setHeader(this.xattribute.getName());
        this.pointView.setName(this.yattribute.getName());
        this.pointView.setLineWidth(2);
        this.pointView.setColor(ATKConstant.getColor4State("VALID"));
        this.pointView.setLabelVisible(true);
        this.pointView.setStyle(1);
        this.pointView.setLineWidth(1);
        this.pointView.setFillStyle(1);
        this.pointView.setMarker(this.markerStyle);
        this.getY1Axis().addDataView(this.pointView);
        this.yattribute.addNumberScalarListener((INumberScalarListener)this);
        this.setMiddleLineVisible(this.middleLineVisible);
        this.midleLineView.setColor(Color.BLACK);
        this.midleLineView.setStyle(0);
        this.midleLineView.setMarker(7);
        this.midleLineView.setName("X middle axis");
        double d = (this.defaultXMaxValue + this.defaultXMinValue) / 2.0;
        this.midleLineView.add(d, this.defaultYMinValue);
        this.midleLineView.add(d, this.defaultYMaxValue);
        this.getY1Axis().addDataView(this.midleLineView);
    }

    public void clearXYModel() {
        if (this.xattribute != null) {
            this.xattribute = null;
        }
        if (this.yattribute != null) {
            this.yattribute.removeNumberScalarListener((INumberScalarListener)this);
            this.yattribute = null;
        }
        this.getY1Axis().clearDataView();
        this.pointView.reset();
        this.midleLineView.reset();
    }

    public boolean isMiddleLineVisible() {
        return this.middleLineVisible;
    }

    public void setMiddleLineVisible(boolean bl) {
        this.middleLineVisible = bl;
        if (bl) {
            this.midleLineView.setLineWidth(1);
        } else {
            this.midleLineView.setLineWidth(0);
        }
    }

    public double getDefaultXMaxAlarm() {
        return this.defaultXMaxAlarm;
    }

    public void setDefaultXMaxAlarm(double d) {
        this.defaultXMaxAlarm = d;
    }

    public double getDefaultXMaxValue() {
        return this.defaultXMaxValue;
    }

    public void setDefaultXMaxValue(double d) {
        this.defaultXMaxValue = d;
        this.getXAxis().setMaximum(d);
    }

    public double getDefaultXMinAlarm() {
        return this.defaultXMinAlarm;
    }

    public void setDefaultXMinAlarm(double d) {
        this.defaultXMinAlarm = d;
    }

    public double getDefaultXMinValue() {
        return this.defaultXMinValue;
    }

    public void setDefaultXMinValue(double d) {
        this.defaultXMinValue = d;
        this.getXAxis().setMinimum(d);
    }

    public double getDefaultYMaxAlarm() {
        return this.defaultYMaxAlarm;
    }

    public void setDefaultYMaxAlarm(double d) {
        this.defaultYMaxAlarm = d;
    }

    public double getDefaultYMaxValue() {
        return this.defaultYMaxValue;
    }

    public void setDefaultYMaxValue(double d) {
        this.defaultYMaxValue = d;
        this.getY1Axis().setMaximum(d);
    }

    public double getDefaultYMinAlarm() {
        return this.defaultYMinAlarm;
    }

    public void setDefaultYMinAlarm(double d) {
        this.defaultYMinAlarm = d;
    }

    public double getDefaultYMinValue() {
        return this.defaultYMinValue;
    }

    public void setDefaultYMinValue(double d) {
        this.defaultYMinValue = d;
        this.getY1Axis().setMinimum(d);
    }

    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        double d = numberScalarEvent.getValue();
        double d2 = this.xattribute.getNumberScalarValue();
        this.pointView.reset();
        this.pointView.add(d2, d);
        if (d <= this.defaultYMinValue || d >= this.defaultYMaxValue) {
            this.pointView.setMarkerColor(ATKConstant.getColor4Quality("INVALID"));
        } else if (d <= this.defaultYMinAlarm || d >= this.defaultYMaxAlarm) {
            this.pointView.setMarkerColor(ATKConstant.getColor4Quality("ALARM"));
        } else if (d2 >= this.defaultXMaxValue || d2 <= this.defaultXMinValue) {
            this.pointView.setMarkerColor(ATKConstant.getColor4Quality("INVALID"));
        } else if (d2 >= this.defaultXMaxAlarm || d2 <= this.defaultXMinAlarm) {
            this.pointView.setMarkerColor(ATKConstant.getColor4Quality("ALARM"));
        } else {
            this.pointView.setMarkerColor(ATKConstant.getColor4Quality("VALID"));
        }
        this.getY1Axis().addDataView(this.pointView);
        this.repaint();
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        DualNumberScalarChart dualNumberScalarChart = new DualNumberScalarChart();
        INumberScalar iNumberScalar = null;
        INumberScalar iNumberScalar2 = null;
        AttributePolledList attributePolledList = new AttributePolledList();
        try {
            if (stringArray != null && stringArray.length > 1) {
                iNumberScalar = (INumberScalar)attributePolledList.add(stringArray[0].trim());
                iNumberScalar2 = (INumberScalar)attributePolledList.add(stringArray[1].trim());
            } else {
                iNumberScalar = (INumberScalar)attributePolledList.add("LT1/AE/CH.1/voltage");
                iNumberScalar2 = (INumberScalar)attributePolledList.add("LT1/AE/CH.2/voltage");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        dualNumberScalarChart.setDefaultYMaxValue(1.0);
        dualNumberScalarChart.setDefaultYMinValue(-1.0);
        dualNumberScalarChart.setDefaultXMaxValue(1.0);
        dualNumberScalarChart.setDefaultXMinValue(-1.0);
        dualNumberScalarChart.setMiddleLineVisible(true);
        dualNumberScalarChart.setXYModel(iNumberScalar, iNumberScalar2);
        attributePolledList.startRefresher();
        jFrame.getContentPane().add((Component)dualNumberScalarChart, "Center");
        jFrame.setSize(640, 480);
        jFrame.setTitle(dualNumberScalarChart.getHeader() + " Example 1");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setVisible(true);
    }
}

