/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.vectorJep.function;

import java.util.Stack;
import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.function.UnaryOperatorI;
import org.lsmp.djep.vectorJep.values.Matrix;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.lsmp.djep.vectorJep.values.Scaler;
import org.lsmp.djep.vectorJep.values.Tensor;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.Add;
import org.nfunk.jep.function.Multiply;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.function.Subtract;

public class Determinant
extends PostfixMathCommand
implements UnaryOperatorI {
    Add add = new Add();
    Subtract sub = new Subtract();
    Multiply mul = new Multiply();

    public Determinant() {
        this.numberOfParameters = 1;
    }

    public Dimensions calcDim(Dimensions dimensions) {
        return Dimensions.ONE;
    }

    public MatrixValueI calcValue(MatrixValueI matrixValueI, MatrixValueI matrixValueI2) throws ParseException {
        if (!(matrixValueI instanceof Scaler)) {
            throw new ParseException("det: result must be a scaler");
        }
        if (!(matrixValueI2 instanceof Matrix)) {
            throw new ParseException("det: argument must be a matrix");
        }
        Matrix matrix = (Matrix)matrixValueI2;
        if (matrix.getNumRows() != matrix.getNumCols()) {
            throw new ParseException("det: argument must be a square matrix " + matrix);
        }
        if (matrix.getNumRows() == 2) {
            matrixValueI.setEle(0, this.sub.sub(this.mul.mul(matrix.getEle(0, 0), matrix.getEle(1, 1)), this.mul.mul(matrix.getEle(1, 0), matrix.getEle(0, 1))));
        } else if (matrix.getNumRows() == 3) {
            Object object = this.mul.mul(matrix.getEle(0, 0), this.mul.mul(matrix.getEle(1, 1), matrix.getEle(2, 2)));
            Object object2 = this.mul.mul(matrix.getEle(0, 1), this.mul.mul(matrix.getEle(1, 2), matrix.getEle(2, 0)));
            Object object3 = this.mul.mul(matrix.getEle(0, 2), this.mul.mul(matrix.getEle(1, 0), matrix.getEle(2, 1)));
            Object object4 = this.mul.mul(matrix.getEle(0, 0), this.mul.mul(matrix.getEle(1, 2), matrix.getEle(2, 1)));
            Object object5 = this.mul.mul(matrix.getEle(0, 1), this.mul.mul(matrix.getEle(1, 0), matrix.getEle(2, 2)));
            Object object6 = this.mul.mul(matrix.getEle(0, 2), this.mul.mul(matrix.getEle(1, 1), matrix.getEle(2, 0)));
            Object object7 = this.add.add(object, this.add.add(object2, object3));
            Object object8 = this.add.add(object4, this.add.add(object5, object6));
            matrixValueI.setEle(0, this.sub.sub(object7, object8));
        } else {
            Object[][] objectArray = matrix.getEles();
            matrixValueI.setEle(0, this.det(objectArray));
        }
        return matrixValueI;
    }

    public static Object[][] dropRowCol(Object[][] objectArray, int n, int n2) {
        int n3 = objectArray.length;
        int n4 = objectArray[0].length;
        Object[][] objectArray2 = new Object[n3 - 1][n4 - 1];
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            if (i == n) continue;
            int n6 = 0;
            for (int j = 0; j < n4; ++j) {
                if (j == n2) continue;
                objectArray2[n5][n6] = objectArray[i][j];
                ++n6;
            }
            ++n5;
        }
        return objectArray2;
    }

    public Object det(Object[][] objectArray) throws ParseException {
        if (objectArray.length == 1) {
            return objectArray[0][0];
        }
        if (objectArray.length == 2) {
            return this.sub.sub(this.mul.mul(objectArray[0][0], objectArray[1][1]), this.mul.mul(objectArray[1][0], objectArray[0][1]));
        }
        Object object = new Double(0.0);
        for (int i = 0; i < objectArray.length; ++i) {
            Object[][] objectArray2 = Determinant.dropRowCol(objectArray, 0, i);
            Object object2 = this.det(objectArray2);
            object = i % 2 == 0 ? this.add.add(object, this.mul.mul(objectArray[0][i], object2)) : this.sub.sub(object, this.mul.mul(objectArray[0][i], object2));
        }
        return object;
    }

    public void run(Stack stack) throws ParseException {
        MatrixValueI matrixValueI = (MatrixValueI)stack.pop();
        MatrixValueI matrixValueI2 = Tensor.getInstance(this.calcDim(matrixValueI.getDim()));
        this.calcValue(matrixValueI2, matrixValueI);
        stack.push(matrixValueI2);
    }
}

