/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.sjep;

import org.lsmp.djep.sjep.Monomial;
import org.lsmp.djep.sjep.PConstant;
import org.lsmp.djep.sjep.PFunction;
import org.lsmp.djep.sjep.PNodeI;
import org.lsmp.djep.sjep.POperator;
import org.lsmp.djep.sjep.PVariable;
import org.lsmp.djep.sjep.Polynomial;
import org.lsmp.djep.xjep.DoNothingVisitor;
import org.lsmp.djep.xjep.NodeFactory;
import org.lsmp.djep.xjep.XJep;
import org.lsmp.djep.xjep.XOperator;
import org.lsmp.djep.xjep.XVariable;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.Operator;
import org.nfunk.jep.OperatorSet;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.Add;
import org.nfunk.jep.function.Divide;
import org.nfunk.jep.function.Multiply;
import org.nfunk.jep.function.Power;
import org.nfunk.jep.function.Subtract;
import org.nfunk.jep.function.UMinus;
import org.nfunk.jep.type.Complex;
import org.nfunk.jep.type.NumberFactory;

public class PolynomialCreator
extends DoNothingVisitor {
    private XJep jep;
    Object zero;
    Object one;
    Object minusOne;
    Object infinity;
    Object nan;
    Object two;
    PConstant zeroConstant;
    PConstant oneConstant;
    PConstant minusOneConstant;
    PConstant infConstant;
    PConstant nanConstant;
    PConstant twoConstant;
    Monomial zeroMonomial;
    Monomial unitMonomial;
    Monomial infMonomial;
    Monomial nanMonomial;
    Polynomial zeroPolynomial;
    Polynomial unitPolynomial;
    Polynomial infPolynomial;
    Polynomial nanPolynomial;
    NumberFactory numf;
    OperatorSet os;
    NodeFactory nf;

    private PolynomialCreator() {
    }

    public PolynomialCreator(XJep xJep) {
        this.jep = xJep;
        this.numf = xJep.getNumberFactory();
        this.os = xJep.getOperatorSet();
        this.nf = xJep.getNodeFactory();
        this.zero = xJep.getNumberFactory().getZero();
        this.one = xJep.getNumberFactory().getOne();
        this.minusOne = xJep.getNumberFactory().getMinusOne();
        this.two = xJep.getNumberFactory().getTwo();
        try {
            this.infinity = this.div(this.one, this.zero);
            this.nan = this.div(this.zero, this.zero);
        }
        catch (ParseException parseException) {
            this.infinity = new Double(Double.POSITIVE_INFINITY);
            this.nan = new Double(Double.NaN);
        }
        this.zeroConstant = new PConstant(this, this.zero);
        this.oneConstant = new PConstant(this, this.one);
        this.twoConstant = new PConstant(this, this.two);
        this.minusOneConstant = new PConstant(this, this.minusOne);
        this.infConstant = new PConstant(this, this.infinity);
        this.nanConstant = new PConstant(this, this.nan);
    }

    public PNodeI createPoly(Node node) throws ParseException {
        return (PNodeI)node.jjtAccept(this, null);
    }

    public Node simplify(Node node) throws ParseException {
        PNodeI pNodeI = this.createPoly(node);
        return pNodeI.toNode();
    }

    public Node expand(Node node) throws ParseException {
        PNodeI pNodeI = this.createPoly(node);
        PNodeI pNodeI2 = pNodeI.expand();
        return pNodeI2.toNode();
    }

    public int compare(Node node, Node node2) throws ParseException {
        PNodeI pNodeI = this.createPoly(node);
        PNodeI pNodeI2 = pNodeI.expand();
        PNodeI pNodeI3 = this.createPoly(node2);
        PNodeI pNodeI4 = pNodeI3.expand();
        return pNodeI2.compareTo(pNodeI4);
    }

    public boolean equals(Node node, Node node2) throws ParseException {
        PNodeI pNodeI = this.createPoly(node);
        PNodeI pNodeI2 = pNodeI.expand();
        PNodeI pNodeI3 = this.createPoly(node2);
        PNodeI pNodeI4 = pNodeI3.expand();
        return pNodeI2.equals(pNodeI4);
    }

    public Object visit(ASTConstant aSTConstant, Object object) throws ParseException {
        return new PConstant(this, aSTConstant.getValue());
    }

    public Object visit(ASTVarNode aSTVarNode, Object object) throws ParseException {
        return new PVariable(this, (XVariable)aSTVarNode.getVar());
    }

    public Object visit(ASTFunNode aSTFunNode, Object object) throws ParseException {
        int n = aSTFunNode.jjtGetNumChildren();
        PNodeI[] pNodeIArray = new PNodeI[n];
        for (int i = 0; i < n; ++i) {
            pNodeIArray[i] = (PNodeI)aSTFunNode.jjtGetChild(i).jjtAccept(this, object);
        }
        XOperator xOperator = (XOperator)aSTFunNode.getOperator();
        if (xOperator == this.os.getAdd()) {
            PNodeI pNodeI = pNodeIArray[0];
            for (int i = 1; i < n; ++i) {
                pNodeI = pNodeI.add(pNodeIArray[i]);
            }
            return pNodeI;
        }
        if (xOperator == this.os.getSubtract()) {
            if (pNodeIArray.length != 2) {
                throw new ParseException("Subtract must have two args it has " + pNodeIArray.length);
            }
            return pNodeIArray[0].sub(pNodeIArray[1]);
        }
        if (xOperator == this.os.getUMinus()) {
            PNodeI pNodeI = pNodeIArray[0];
            return pNodeI.negate();
        }
        if (xOperator == this.os.getMultiply()) {
            PNodeI pNodeI = pNodeIArray[0];
            for (int i = 1; i < n; ++i) {
                pNodeI = pNodeI.mul(pNodeIArray[i]);
            }
            return pNodeI;
        }
        if (xOperator == this.os.getDivide()) {
            if (pNodeIArray.length != 2) {
                throw new ParseException("Divide must have two args it has " + pNodeIArray.length);
            }
            return pNodeIArray[0].div(pNodeIArray[1]);
        }
        if (xOperator == this.os.getPower()) {
            if (pNodeIArray.length != 2) {
                throw new ParseException("Power must have two args it has " + pNodeIArray.length);
            }
            return pNodeIArray[0].pow(pNodeIArray[1]);
        }
        boolean bl = true;
        for (int i = 0; i < pNodeIArray.length; ++i) {
            if (pNodeIArray[i] instanceof PConstant) continue;
            bl = false;
            break;
        }
        if (bl) {
            Object object2;
            Node[] nodeArray = new Node[pNodeIArray.length];
            for (int i = 0; i < pNodeIArray.length; ++i) {
                nodeArray[i] = pNodeIArray[i].toNode();
            }
            ASTFunNode aSTFunNode2 = xOperator != null ? this.nf.buildOperatorNode((Operator)xOperator, nodeArray) : this.nf.buildFunctionNode(aSTFunNode.getName(), aSTFunNode.getPFMC(), nodeArray);
            try {
                object2 = this.jep.evaluate(aSTFunNode2);
            }
            catch (Exception exception) {
                throw new ParseException(exception.getMessage());
            }
            return new PConstant(this, object2);
        }
        if (xOperator != null) {
            return new POperator(this, xOperator, pNodeIArray);
        }
        return new PFunction(this, aSTFunNode.getName(), aSTFunNode.getPFMC(), pNodeIArray);
    }

    Object add(Object object, Object object2) throws ParseException {
        return ((Add)this.os.getAdd().getPFMC()).add(object, object2);
    }

    Object sub(Object object, Object object2) throws ParseException {
        return ((Subtract)this.os.getSubtract().getPFMC()).sub(object, object2);
    }

    Object mul(Object object, Object object2) throws ParseException {
        return ((Multiply)this.os.getMultiply().getPFMC()).mul(object, object2);
    }

    Object div(Object object, Object object2) throws ParseException {
        return ((Divide)this.os.getDivide().getPFMC()).div(object, object2);
    }

    Object intToValue(int n) {
        return new Double(n);
    }

    Object raise(Object object, Object object2) throws ParseException {
        return ((Power)this.os.getPower().getPFMC()).power(object, object2);
    }

    Object neg(Object object) throws ParseException {
        return ((UMinus)this.os.getUMinus().getPFMC()).umin(object);
    }

    int cmp(Object object, Object object2) throws ParseException {
        if (object.equals(object2)) {
            return 0;
        }
        if (object instanceof Complex) {
            Complex complex = (Complex)object;
            double d = complex.re();
            double d2 = complex.im();
            if (object2 instanceof Complex) {
                Complex complex2 = (Complex)object2;
                double d3 = complex2.re();
                double d4 = complex2.im();
                if (d == d3) {
                    if (d2 == d4) {
                        return 0;
                    }
                    if (d2 < d4) {
                        return -1;
                    }
                    return 0;
                }
                if (d < d3) {
                    return -1;
                }
                return 1;
            }
            if (object2 instanceof Number) {
                double d5 = ((Number)object2).doubleValue();
                double d6 = 0.0;
                if (d == d5) {
                    if (d2 == d6) {
                        return 0;
                    }
                    if (d2 < d6) {
                        return -1;
                    }
                    return 0;
                }
                if (d < d5) {
                    return -1;
                }
                return 1;
            }
            throw new ParseException("Don't know how to compare a Complex with " + object2 + " (" + object2.getClass().getName() + ")");
        }
        if (object instanceof Number && object2 instanceof Complex) {
            double d = ((Number)object).doubleValue();
            double d7 = 0.0;
            Complex complex = (Complex)object2;
            double d8 = complex.re();
            double d9 = complex.im();
            if (d == d8) {
                if (d7 == d9) {
                    return 0;
                }
                if (d7 < d9) {
                    return -1;
                }
                return 0;
            }
            if (d < d8) {
                return -1;
            }
            return 1;
        }
        if (object instanceof Comparable && object.getClass().equals(object2.getClass())) {
            return ((Comparable)object).compareTo(object2);
        }
        if (object instanceof Number && object2 instanceof Number) {
            double d;
            double d10 = ((Number)object).doubleValue();
            if (d10 == (d = ((Number)object2).doubleValue())) {
                return 0;
            }
            if (d10 < d) {
                return -1;
            }
            return 1;
        }
        if (object instanceof Comparable) {
            return ((Comparable)object).compareTo(object2);
        }
        throw new IllegalArgumentException("Sorry don't know how to compare " + object + " (" + object.getClass().getName() + ") and " + object2 + " (" + object2.getClass().getName() + ")");
    }
}

