/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.OvalRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.Toolbar;
import java.awt.Point;
import java.awt.Polygon;

class RoiBrush
implements Runnable {
    private Polygon poly;
    private Point previousP;

    RoiBrush() {
        Thread thread = new Thread((Runnable)this, "RoiBrush");
        thread.start();
    }

    public void run() {
        int size = Toolbar.getBrushSize();
        ImagePlus img = WindowManager.getCurrentImage();
        if (img == null) {
            return;
        }
        ImageCanvas ic = img.getCanvas();
        if (ic == null) {
            return;
        }
        Roi roi = img.getRoi();
        if (roi != null && !roi.isArea()) {
            img.killRoi();
        }
        int leftClick = 16;
        int alt = 9;
        while (true) {
            Point p;
            if ((p = ic.getCursorLoc()).equals(this.previousP)) {
                IJ.wait(1);
                continue;
            }
            this.previousP = p;
            int flags = ic.getModifiers();
            if ((flags & leftClick) == 0) {
                return;
            }
            if ((flags & alt) == 0) {
                this.addCircle(img, p.x, p.y, size);
                continue;
            }
            this.subtractCircle(img, p.x, p.y, size);
        }
    }

    void addCircle(ImagePlus img, int x, int y, int width) {
        Roi roi = img.getRoi();
        if (roi != null) {
            if (!(roi instanceof ShapeRoi)) {
                roi = new ShapeRoi(roi);
            }
            ((ShapeRoi)roi).or(this.getCircularRoi(x, y, width));
        } else {
            roi = new OvalRoi(x - width / 2, y - width / 2, width, width);
        }
        img.setRoi(roi);
    }

    void subtractCircle(ImagePlus img, int x, int y, int width) {
        Roi roi = img.getRoi();
        if (roi != null) {
            if (!(roi instanceof ShapeRoi)) {
                roi = new ShapeRoi(roi);
            }
            ((ShapeRoi)roi).not(this.getCircularRoi(x, y, width));
            img.setRoi(roi);
        }
    }

    ShapeRoi getCircularRoi(int x, int y, int width) {
        if (this.poly == null) {
            OvalRoi roi = new OvalRoi(x - width / 2, y - width / 2, width, width);
            this.poly = ((Roi)roi).getPolygon();
            int i = 0;
            while (i < this.poly.npoints) {
                int n = i;
                this.poly.xpoints[n] = this.poly.xpoints[n] - x;
                int n2 = i++;
                this.poly.ypoints[n2] = this.poly.ypoints[n2] - y;
            }
        }
        return new ShapeRoi(x, y, this.poly);
    }
}

