/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.gui.ImageWindow;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.RoiBrush;
import ij.gui.ShapeRoi;
import ij.gui.StackWindow;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.macro.MacroRunner;
import ij.plugin.frame.Recorder;
import ij.plugin.frame.RoiManager;
import ij.util.Java2;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.List;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.IndexColorModel;
import java.util.Hashtable;
import java.util.Vector;

public class ImageCanvas
extends Canvas
implements MouseListener,
MouseMotionListener,
Cloneable {
    protected static Cursor defaultCursor = new Cursor(0);
    protected static Cursor handCursor = new Cursor(12);
    protected static Cursor moveCursor = new Cursor(13);
    protected static Cursor crosshairCursor = new Cursor(1);
    public static boolean usePointer = Prefs.usePointerCursor;
    protected ImagePlus imp;
    protected boolean imageUpdated;
    protected Rectangle srcRect;
    protected int imageWidth;
    protected int imageHeight;
    protected int xMouse;
    protected int yMouse;
    private boolean showCursorStatus = true;
    private int sx2;
    private int sy2;
    private boolean disablePopupMenu;
    private boolean showAllROIs;
    private static Color showAllColor;
    private static Color zoomIndicatorColor;
    private static Font smallFont;
    private static Font largeFont;
    private Rectangle[] labelRects;
    private boolean maxBoundsReset;
    private Vector displayList;
    private boolean labelListItems;
    private Color listColor;
    private BasicStroke listStroke;
    private static final int LIST_OFFSET = 100000;
    protected ImageJ ij;
    protected double magnification;
    protected int dstWidth;
    protected int dstHeight;
    protected int xMouseStart;
    protected int yMouseStart;
    protected int xSrcStart;
    protected int ySrcStart;
    protected int flags;
    private Image offScreenImage;
    private int offScreenWidth = 0;
    private int offScreenHeight = 0;
    long firstFrame;
    int frames;
    int fps;
    int count;
    private static final double[] zoomLevels;

    public ImageCanvas(ImagePlus imp) {
        this.imp = imp;
        this.ij = IJ.getInstance();
        int width = imp.getWidth();
        int height = imp.getHeight();
        this.imageWidth = width;
        this.imageHeight = height;
        this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
        this.setDrawingSize(this.imageWidth, this.imageHeight);
        this.magnification = 1.0;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this.ij);
        this.setFocusTraversalKeysEnabled(false);
    }

    void updateImage(ImagePlus imp) {
        this.imp = imp;
        int width = imp.getWidth();
        int height = imp.getHeight();
        this.imageWidth = width;
        this.imageHeight = height;
        this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
        this.setDrawingSize(this.imageWidth, this.imageHeight);
        this.magnification = 1.0;
    }

    void update(ImageCanvas ic) {
        if (ic == null || ic == this || ic.imp == null) {
            return;
        }
        if (ic.imp.getWidth() != this.imageWidth || ic.imp.getHeight() != this.imageHeight) {
            return;
        }
        this.srcRect = new Rectangle(ic.srcRect.x, ic.srcRect.y, ic.srcRect.width, ic.srcRect.height);
        this.setMagnification(ic.magnification);
        this.setDrawingSize(ic.dstWidth, ic.dstHeight);
    }

    public void setDrawingSize(int width, int height) {
        this.dstWidth = width;
        this.dstHeight = height;
        this.setSize(this.dstWidth, this.dstHeight);
    }

    public void setImageUpdated() {
        this.imageUpdated = true;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Roi roi = this.imp.getRoi();
        if (roi != null) {
            roi.updatePaste();
            if (Prefs.doubleBuffer && !IJ.isMacOSX()) {
                this.paintDoubleBuffered(g);
                return;
            }
        }
        try {
            Image img;
            if (this.imageUpdated) {
                this.imageUpdated = false;
                this.imp.updateImage();
            }
            if (IJ.isJava2()) {
                Java2.setBilinearInterpolation(g, Prefs.interpolateScaledImages);
            }
            if ((img = this.imp.getImage()) != null) {
                g.drawImage(img, 0, 0, (int)((double)this.srcRect.width * this.magnification), (int)((double)this.srcRect.height * this.magnification), this.srcRect.x, this.srcRect.y, this.srcRect.x + this.srcRect.width, this.srcRect.y + this.srcRect.height, null);
            }
            if (this.showAllROIs) {
                this.showAllROIs(g);
            }
            if (this.displayList != null) {
                this.drawDisplayList(g);
            }
            if (roi != null) {
                roi.draw(g);
            }
            if (this.srcRect.width < this.imageWidth || this.srcRect.height < this.imageHeight) {
                this.drawZoomIndicator(g);
            }
            if (IJ.debugMode) {
                this.showFrameRate(g);
            }
        }
        catch (OutOfMemoryError e) {
            IJ.outOfMemory("Paint");
        }
    }

    void showAllROIs(Graphics g) {
        RoiManager rm = RoiManager.getInstance();
        if (rm == null) {
            return;
        }
        this.initGraphics(g, null);
        Hashtable rois = rm.getROIs();
        List list = rm.getList();
        int n = list.getItemCount();
        if (this.labelRects == null || this.labelRects.length != n) {
            this.labelRects = new Rectangle[n];
        }
        for (int i = 0; i < n; ++i) {
            String label = list.getItem(i);
            Roi roi = (Roi)rois.get(label);
            if (roi == null) continue;
            this.drawRoi(g, roi, i);
        }
    }

    void drawDisplayList(Graphics g) {
        this.initGraphics(g, this.listColor);
        int n = this.displayList.size();
        for (int i = 0; i < n; ++i) {
            this.drawRoi(g, (Roi)this.displayList.elementAt(i), this.labelListItems ? i + 100000 : -1);
        }
        if (this.listStroke != null) {
            ((Graphics2D)g).setStroke(new BasicStroke());
        }
    }

    void initGraphics(Graphics g, Color c2) {
        if (showAllColor == null) {
            showAllColor = new Color(128, 255, 255);
            smallFont = new Font("SansSerif", 0, 9);
            largeFont = new Font("SansSerif", 0, 12);
        }
        if (c2 != null) {
            g.setColor(c2);
            if (this.listStroke != null) {
                ((Graphics2D)g).setStroke(this.listStroke);
            }
        } else {
            g.setColor(showAllColor);
        }
    }

    void drawRoi(Graphics g, Roi roi, int index) {
        if (roi.getType() == 9) {
            roi.setImage(this.imp);
            Color c2 = roi.getColor();
            if (index == -1 && this.listColor != null) {
                Roi.setColor(this.listColor);
            } else {
                Roi.setColor(showAllColor);
            }
            roi.draw(g);
            Roi.setColor(c2);
            if (index >= 0) {
                this.drawRoiLabel(g, index, roi.getBounds());
            }
        } else {
            Polygon p = roi.getPolygon();
            int x1 = 0;
            int y1 = 0;
            int x2 = 0;
            int y2 = 0;
            for (int j = 0; j < p.npoints; ++j) {
                x2 = this.screenX(p.xpoints[j]);
                y2 = this.screenY(p.ypoints[j]);
                if (j > 0) {
                    g.drawLine(x1, y1, x2, y2);
                }
                x1 = x2;
                y1 = y2;
            }
            if (roi.isArea() && p.npoints > 0) {
                int x0 = this.screenX(p.xpoints[0]);
                int y0 = this.screenY(p.ypoints[0]);
                g.drawLine(x1, y1, x0, y0);
            }
            if (index >= 0) {
                this.drawRoiLabel(g, index, roi.getBounds());
            }
        }
    }

    void drawRoiLabel(Graphics g, int index, Rectangle r) {
        boolean drawingList;
        int size;
        int x = this.screenX(r.x);
        int y = this.screenY(r.y);
        double mag = this.getMagnification();
        int width = (int)((double)r.width * mag);
        int height = (int)((double)r.height * mag);
        int n = size = width > 40 && height > 40 ? 12 : 9;
        if (size == 12) {
            g.setFont(largeFont);
        } else {
            g.setFont(smallFont);
        }
        boolean bl = drawingList = index >= 100000;
        if (drawingList) {
            index -= 100000;
        }
        String label = "" + (index + 1);
        FontMetrics metrics = g.getFontMetrics();
        int w = metrics.stringWidth(label);
        x = x + width / 2 - w / 2;
        y = y + height / 2 + Math.max(size / 2, 6);
        int h = metrics.getHeight();
        g.fillRoundRect(x - 1, y - h + 2, w + 1, h - 3, 5, 5);
        if (!drawingList) {
            this.labelRects[index] = new Rectangle(x - 1, y - h + 2, w + 1, h - 3);
        }
        g.setColor(Color.black);
        g.drawString(label, x, y - 2);
        g.setColor(showAllColor);
    }

    void drawZoomIndicator(Graphics g) {
        int x1 = 10;
        int y1 = 10;
        double aspectRatio = (double)this.imageHeight / (double)this.imageWidth;
        int w1 = 64;
        if (aspectRatio > 1.0) {
            w1 = (int)((double)w1 / aspectRatio);
        }
        int h1 = (int)((double)w1 * aspectRatio);
        if (w1 < 4) {
            w1 = 4;
        }
        if (h1 < 4) {
            h1 = 4;
        }
        int w2 = (int)((double)w1 * ((double)this.srcRect.width / (double)this.imageWidth));
        int h2 = (int)((double)h1 * ((double)this.srcRect.height / (double)this.imageHeight));
        if (w2 < 1) {
            w2 = 1;
        }
        if (h2 < 1) {
            h2 = 1;
        }
        int x2 = (int)((double)w1 * ((double)this.srcRect.x / (double)this.imageWidth));
        int y2 = (int)((double)h1 * ((double)this.srcRect.y / (double)this.imageHeight));
        if (zoomIndicatorColor == null) {
            zoomIndicatorColor = new Color(128, 128, 255);
        }
        g.setColor(zoomIndicatorColor);
        g.drawRect(x1, y1, w1, h1);
        if (w2 * h2 <= 200 || w2 < 10 || h2 < 10) {
            g.fillRect(x1 + x2, y1 + y2, w2, h2);
        } else {
            g.drawRect(x1 + x2, y1 + y2, w2, h2);
        }
    }

    void paintDoubleBuffered(Graphics g) {
        int srcRectWidthMag = (int)((double)this.srcRect.width * this.magnification);
        int srcRectHeightMag = (int)((double)this.srcRect.height * this.magnification);
        if (this.offScreenImage == null || this.offScreenWidth != srcRectWidthMag || this.offScreenHeight != srcRectHeightMag) {
            this.offScreenImage = this.createImage(srcRectWidthMag, srcRectHeightMag);
            this.offScreenWidth = srcRectWidthMag;
            this.offScreenHeight = srcRectHeightMag;
        }
        Roi roi = this.imp.getRoi();
        try {
            Image img;
            if (this.imageUpdated) {
                this.imageUpdated = false;
                this.imp.updateImage();
            }
            Graphics offScreenGraphics = this.offScreenImage.getGraphics();
            if (IJ.isJava2()) {
                Java2.setBilinearInterpolation(offScreenGraphics, Prefs.interpolateScaledImages);
            }
            if ((img = this.imp.getImage()) != null) {
                offScreenGraphics.drawImage(img, 0, 0, srcRectWidthMag, srcRectHeightMag, this.srcRect.x, this.srcRect.y, this.srcRect.x + this.srcRect.width, this.srcRect.y + this.srcRect.height, null);
            }
            if (this.showAllROIs) {
                this.showAllROIs(offScreenGraphics);
            }
            if (this.displayList != null) {
                this.drawDisplayList(offScreenGraphics);
            }
            if (roi != null) {
                roi.draw(offScreenGraphics);
            }
            if (this.srcRect.width < this.imageWidth || this.srcRect.height < this.imageHeight) {
                this.drawZoomIndicator(offScreenGraphics);
            }
            if (IJ.debugMode) {
                this.showFrameRate(offScreenGraphics);
            }
            g.drawImage(this.offScreenImage, 0, 0, null);
        }
        catch (OutOfMemoryError e) {
            IJ.outOfMemory("Paint");
        }
    }

    void showFrameRate(Graphics g) {
        ++this.frames;
        if (System.currentTimeMillis() > this.firstFrame + 1000L) {
            this.firstFrame = System.currentTimeMillis();
            this.fps = this.frames;
            this.frames = 0;
        }
        g.setColor(Color.white);
        g.fillRect(10, 12, 50, 15);
        g.setColor(Color.black);
        g.drawString((int)((double)this.fps + 0.5) + " fps", 10, 25);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.dstWidth, this.dstHeight);
    }

    public Point getCursorLoc() {
        return new Point(this.xMouse, this.yMouse);
    }

    public int getModifiers() {
        return this.flags;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setCursor(int sx, int sy, int ox, int oy) {
        block14: {
            block13: {
                this.xMouse = ox;
                this.yMouse = oy;
                Roi roi = this.imp.getRoi();
                ImageWindow win = this.imp.getWindow();
                if (win == null) {
                    return;
                }
                if (IJ.spaceBarDown()) {
                    this.setCursor(handCursor);
                    return;
                }
                int id = Toolbar.getToolId();
                switch (Toolbar.getToolId()) {
                    case 11: {
                        this.setCursor(moveCursor);
                        return;
                    }
                    case 12: {
                        this.setCursor(handCursor);
                        return;
                    }
                }
                if (id == 10 || id >= 15) {
                    if (Prefs.usePointerCursor) {
                        this.setCursor(defaultCursor);
                        return;
                    }
                    this.setCursor(crosshairCursor);
                    return;
                }
                if (roi != null) {
                    if (roi.getState() != 0 && roi.isHandle(sx, sy) >= 0) {
                        this.setCursor(handCursor);
                        return;
                    }
                }
                if (Prefs.usePointerCursor) break block13;
                if (roi == null) break block14;
                if (roi.getState() == 0 || !roi.contains(ox, oy)) break block14;
            }
            this.setCursor(defaultCursor);
            return;
        }
        this.setCursor(crosshairCursor);
    }

    public int offScreenX(int sx) {
        return this.srcRect.x + (int)((double)sx / this.magnification);
    }

    public int offScreenY(int sy) {
        return this.srcRect.y + (int)((double)sy / this.magnification);
    }

    public double offScreenXD(int sx) {
        return (double)this.srcRect.x + (double)sx / this.magnification;
    }

    public double offScreenYD(int sy) {
        return (double)this.srcRect.y + (double)sy / this.magnification;
    }

    public int screenX(int ox) {
        return (int)((double)(ox - this.srcRect.x) * this.magnification);
    }

    public int screenY(int oy) {
        return (int)((double)(oy - this.srcRect.y) * this.magnification);
    }

    public int screenXD(double ox) {
        return (int)((ox - (double)this.srcRect.x) * this.magnification);
    }

    public int screenYD(double oy) {
        return (int)((oy - (double)this.srcRect.y) * this.magnification);
    }

    public double getMagnification() {
        return this.magnification;
    }

    public void setMagnification(double magnification) {
        this.setMagnification2(magnification);
    }

    void setMagnification2(double magnification) {
        if (magnification > 32.0) {
            magnification = 32.0;
        }
        this.magnification = magnification;
        this.imp.setTitle(this.imp.getTitle());
    }

    public Rectangle getSrcRect() {
        return this.srcRect;
    }

    void setSrcRect(Rectangle srcRect) {
        this.srcRect = srcRect;
    }

    void resizeCanvas(int width, int height) {
        ImageWindow win = this.imp.getWindow();
        if (!(this.maxBoundsReset || width <= this.dstWidth && height <= this.dstHeight || win == null || win.maxBounds == null || width == win.maxBounds.width - 10)) {
            Dimension screen = IJ.getScreenSize();
            win.setMaximizedBounds(new Rectangle(0, 0, screen.width, screen.height));
            this.maxBoundsReset = true;
        }
        if (this.srcRect.width < this.imageWidth || this.srcRect.height < this.imageHeight) {
            if ((double)width > (double)this.imageWidth * this.magnification) {
                width = (int)((double)this.imageWidth * this.magnification);
            }
            if ((double)height > (double)this.imageHeight * this.magnification) {
                height = (int)((double)this.imageHeight * this.magnification);
            }
            this.setDrawingSize(width, height);
            this.srcRect.width = (int)((double)this.dstWidth / this.magnification);
            this.srcRect.height = (int)((double)this.dstHeight / this.magnification);
            if (this.srcRect.x + this.srcRect.width > this.imageWidth) {
                this.srcRect.x = this.imageWidth - this.srcRect.width;
            }
            if (this.srcRect.y + this.srcRect.height > this.imageHeight) {
                this.srcRect.y = this.imageHeight - this.srcRect.height;
            }
            this.repaint();
        }
    }

    void setMaxBounds() {
        if (this.maxBoundsReset) {
            this.maxBoundsReset = false;
            ImageWindow win = this.imp.getWindow();
            if (win != null && !IJ.isLinux()) {
                win.setMaximizedBounds(win.maxBounds);
            }
        }
    }

    public static double getLowerZoomLevel(double currentMag) {
        double newMag = zoomLevels[0];
        for (int i = 0; i < zoomLevels.length && zoomLevels[i] < currentMag; ++i) {
            newMag = zoomLevels[i];
        }
        return newMag;
    }

    public static double getHigherZoomLevel(double currentMag) {
        double newMag = 32.0;
        for (int i = zoomLevels.length - 1; i >= 0 && zoomLevels[i] > currentMag; --i) {
            newMag = zoomLevels[i];
        }
        return newMag;
    }

    public void zoomIn(int x, int y) {
        int newHeight;
        if (this.magnification >= 32.0) {
            return;
        }
        double newMag = ImageCanvas.getHigherZoomLevel(this.magnification);
        int newWidth = (int)((double)this.imageWidth * newMag);
        Dimension newSize = this.canEnlarge(newWidth, newHeight = (int)((double)this.imageHeight * newMag));
        if (newSize != null) {
            this.setDrawingSize(newSize.width, newSize.height);
            if (newSize.width != newWidth || newSize.height != newHeight) {
                this.adjustSourceRect(newMag, x, y);
            } else {
                this.setMagnification(newMag);
            }
            this.imp.getWindow().pack();
        } else {
            this.adjustSourceRect(newMag, x, y);
        }
        this.repaint();
    }

    void adjustSourceRect(double newMag, int x, int y) {
        int h;
        int w = (int)Math.round((double)this.dstWidth / newMag);
        if ((double)w * newMag < (double)this.dstWidth) {
            ++w;
        }
        if ((double)(h = (int)Math.round((double)this.dstHeight / newMag)) * newMag < (double)this.dstHeight) {
            ++h;
        }
        x = this.offScreenX(x);
        y = this.offScreenY(y);
        Rectangle r = new Rectangle(x - w / 2, y - h / 2, w, h);
        if (r.x < 0) {
            r.x = 0;
        }
        if (r.y < 0) {
            r.y = 0;
        }
        if (r.x + w > this.imageWidth) {
            r.x = this.imageWidth - w;
        }
        if (r.y + h > this.imageHeight) {
            r.y = this.imageHeight - h;
        }
        this.srcRect = r;
        this.setMagnification(newMag);
    }

    protected Dimension canEnlarge(int newWidth, int newHeight) {
        boolean fitsVertically;
        if ((this.flags & 1) != 0 || IJ.shiftKeyDown()) {
            return null;
        }
        ImageWindow win = this.imp.getWindow();
        if (win == null) {
            return null;
        }
        Rectangle r1 = win.getBounds();
        Insets insets = win.getInsets();
        Point loc = this.getLocation();
        if (loc.x > insets.left + 5 || loc.y > insets.top + 5) {
            r1.width = newWidth + insets.left + insets.right + 10;
            r1.height = newHeight + insets.top + insets.bottom + 10;
            if (win instanceof StackWindow) {
                r1.height += 20;
            }
        } else {
            r1.width = r1.width - this.dstWidth + newWidth + 10;
            r1.height = r1.height - this.dstHeight + newHeight + 10;
        }
        Rectangle max = win.getMaxWindow();
        boolean fitsHorizontally = r1.x + r1.width < max.x + max.width;
        boolean bl = fitsVertically = r1.y + r1.height < max.y + max.height;
        if (fitsHorizontally && fitsVertically) {
            return new Dimension(newWidth, newHeight);
        }
        if (fitsVertically && newHeight < this.dstWidth) {
            return new Dimension(this.dstWidth, newHeight);
        }
        if (fitsHorizontally && newWidth < this.dstHeight) {
            return new Dimension(newWidth, this.dstHeight);
        }
        return null;
    }

    public void zoomOut(int x, int y) {
        if (this.magnification <= 0.03125) {
            return;
        }
        double oldMag = this.magnification;
        double newMag = ImageCanvas.getLowerZoomLevel(this.magnification);
        double srcRatio = (double)this.srcRect.width / (double)this.srcRect.height;
        double imageRatio = (double)this.imageWidth / (double)this.imageHeight;
        double initialMag = this.imp.getWindow().getInitialMagnification();
        if (Math.abs(srcRatio - imageRatio) > 0.05) {
            double scale = oldMag / newMag;
            int newSrcWidth = (int)Math.round((double)this.srcRect.width * scale);
            int newSrcHeight = (int)Math.round((double)this.srcRect.height * scale);
            if (newSrcWidth > this.imageWidth) {
                newSrcWidth = this.imageWidth;
            }
            if (newSrcHeight > this.imageHeight) {
                newSrcHeight = this.imageHeight;
            }
            int newSrcX = this.srcRect.x - (newSrcWidth - this.srcRect.width) / 2;
            int newSrcY = this.srcRect.y - (newSrcHeight - this.srcRect.height) / 2;
            if (newSrcX < 0) {
                newSrcX = 0;
            }
            if (newSrcY < 0) {
                newSrcY = 0;
            }
            this.srcRect = new Rectangle(newSrcX, newSrcY, newSrcWidth, newSrcHeight);
            int newDstWidth = (int)((double)this.srcRect.width * newMag);
            int newDstHeight = (int)((double)this.srcRect.height * newMag);
            this.setMagnification(newMag);
            this.setMaxBounds();
            if (newDstWidth < this.dstWidth || newDstHeight < this.dstHeight) {
                this.setDrawingSize(newDstWidth, newDstHeight);
                this.imp.getWindow().pack();
            } else {
                this.repaint();
            }
            return;
        }
        if ((double)this.imageWidth * newMag > (double)this.dstWidth) {
            int h;
            int w = (int)Math.round((double)this.dstWidth / newMag);
            if ((double)w * newMag < (double)this.dstWidth) {
                ++w;
            }
            if ((double)(h = (int)Math.round((double)this.dstHeight / newMag)) * newMag < (double)this.dstHeight) {
                ++h;
            }
            x = this.offScreenX(x);
            y = this.offScreenY(y);
            Rectangle r = new Rectangle(x - w / 2, y - h / 2, w, h);
            if (r.x < 0) {
                r.x = 0;
            }
            if (r.y < 0) {
                r.y = 0;
            }
            if (r.x + w > this.imageWidth) {
                r.x = this.imageWidth - w;
            }
            if (r.y + h > this.imageHeight) {
                r.y = this.imageHeight - h;
            }
            this.srcRect = r;
        } else {
            this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
            this.setDrawingSize((int)((double)this.imageWidth * newMag), (int)((double)this.imageHeight * newMag));
            this.imp.getWindow().pack();
        }
        this.setMagnification(newMag);
        this.setMaxBounds();
        this.repaint();
    }

    public void unzoom() {
        double imag = this.imp.getWindow().getInitialMagnification();
        if (this.magnification == imag) {
            return;
        }
        this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
        ImageWindow win = this.imp.getWindow();
        this.setDrawingSize((int)((double)this.imageWidth * imag), (int)((double)this.imageHeight * imag));
        this.setMagnification(imag);
        this.setMaxBounds();
        win.pack();
        this.repaint();
    }

    protected void scroll(int sx, int sy) {
        int ox = this.xSrcStart + (int)((double)sx / this.magnification);
        int oy = this.ySrcStart + (int)((double)sy / this.magnification);
        int newx = this.xSrcStart + (this.xMouseStart - ox);
        int newy = this.ySrcStart + (this.yMouseStart - oy);
        if (newx < 0) {
            newx = 0;
        }
        if (newy < 0) {
            newy = 0;
        }
        if (newx + this.srcRect.width > this.imageWidth) {
            newx = this.imageWidth - this.srcRect.width;
        }
        if (newy + this.srcRect.height > this.imageHeight) {
            newy = this.imageHeight - this.srcRect.height;
        }
        this.srcRect.x = newx;
        this.srcRect.y = newy;
        this.imp.draw();
        Thread.yield();
    }

    Color getColor(int index) {
        IndexColorModel cm = (IndexColorModel)this.imp.getProcessor().getColorModel();
        return new Color(cm.getRGB(index));
    }

    protected void setDrawingColor(int ox, int oy, boolean setBackground) {
        Color c2;
        int type = this.imp.getType();
        int[] v = this.imp.getPixel(ox, oy);
        switch (type) {
            case 0: {
                if (setBackground) {
                    this.setBackgroundColor(this.getColor(v[0]));
                    break;
                }
                this.setForegroundColor(this.getColor(v[0]));
                break;
            }
            case 1: 
            case 2: {
                double min = this.imp.getProcessor().getMin();
                double max = this.imp.getProcessor().getMax();
                double value = type == 2 ? (double)Float.intBitsToFloat(v[0]) : (double)v[0];
                int index = (int)(255.0 * ((value - min) / (max - min)));
                if (index < 0) {
                    index = 0;
                }
                if (index > 255) {
                    index = 255;
                }
                if (setBackground) {
                    this.setBackgroundColor(this.getColor(index));
                    break;
                }
                this.setForegroundColor(this.getColor(index));
                break;
            }
            case 3: 
            case 4: {
                Color c3 = new Color(v[0], v[1], v[2]);
                if (setBackground) {
                    this.setBackgroundColor(c3);
                    break;
                }
                this.setForegroundColor(c3);
                break;
            }
        }
        if (setBackground) {
            c2 = Toolbar.getBackgroundColor();
        } else {
            c2 = Toolbar.getForegroundColor();
            this.imp.setColor(c2);
        }
        IJ.showStatus("(" + c2.getRed() + ", " + c2.getGreen() + ", " + c2.getBlue() + ")");
    }

    private void setForegroundColor(Color c2) {
        Toolbar.setForegroundColor(c2);
        if (Recorder.record) {
            Recorder.record("setForegroundColor", c2.getRed(), c2.getGreen(), c2.getBlue());
        }
    }

    private void setBackgroundColor(Color c2) {
        Toolbar.setBackgroundColor(c2);
        if (Recorder.record) {
            Recorder.record("setBackgroundColor", c2.getRed(), c2.getGreen(), c2.getBlue());
        }
    }

    public void mousePressed(MouseEvent e) {
        Roi roi;
        if (this.ij == null) {
            return;
        }
        this.showCursorStatus = true;
        int toolID = Toolbar.getToolId();
        ImageWindow win = this.imp.getWindow();
        if (win != null && win.running2 && toolID != 11) {
            win.running2 = false;
            return;
        }
        int x = e.getX();
        int y = e.getY();
        this.flags = e.getModifiers();
        if (toolID != 11 && (e.isPopupTrigger() || (this.flags & 4) != 0)) {
            this.handlePopupMenu(e);
            return;
        }
        int ox = this.offScreenX(x);
        int oy = this.offScreenY(y);
        this.xMouse = ox;
        this.yMouse = oy;
        if (IJ.spaceBarDown()) {
            this.setupScroll(ox, oy);
            return;
        }
        if (this.showAllROIs && ((roi = this.imp.getRoi()) == null || !roi.contains(ox, oy) && roi.isHandle(x, y) < 0) && this.roiManagerSelect(x, y)) {
            return;
        }
        switch (toolID) {
            case 11: {
                if (IJ.shiftKeyDown()) {
                    this.zoomToSelection(ox, oy);
                    break;
                }
                if ((this.flags & 0xE) != 0) {
                    this.zoomOut(x, y);
                    break;
                }
                this.zoomIn(x, y);
                break;
            }
            case 12: {
                this.setupScroll(ox, oy);
                break;
            }
            case 13: {
                this.setDrawingColor(ox, oy, IJ.altKeyDown());
                break;
            }
            case 8: {
                int handle;
                roi = this.imp.getRoi();
                if (roi != null && roi.contains(ox, oy)) {
                    Rectangle r = roi.getBounds();
                    if (r.width == this.imageWidth && r.height == this.imageHeight) {
                        this.imp.killRoi();
                    } else if (!e.isAltDown()) {
                        this.handleRoiMouseDown(e);
                        return;
                    }
                }
                if (roi != null && (handle = roi.isHandle(x, y)) >= 0) {
                    roi.mouseDownInHandle(handle, x, y);
                    return;
                }
                this.setRoiModState(e, roi, -1);
                int npoints = IJ.doWand(ox, oy);
                if (!Recorder.record || npoints <= 0) break;
                Recorder.record("doWand", ox, oy);
                break;
            }
            case 1: {
                if (Toolbar.getBrushSize() > 0) {
                    new RoiBrush();
                    break;
                }
                this.handleRoiMouseDown(e);
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                Toolbar.getInstance().runMacroTool(toolID);
                break;
            }
            default: {
                this.handleRoiMouseDown(e);
            }
        }
    }

    void zoomToSelection(int x, int y) {
        IJ.setKeyUp(50);
        String macro = "args = split(getArgument);\nx1=parseInt(args[0]); y1=parseInt(args[1]); flags=20;\nwhile (flags&20!=0) {\ngetCursorLoc(x2, y2, z, flags);\nif (x2>=x1) x=x1; else x=x2;\nif (y2>=y1) y=y1; else y=y2;\nmakeRectangle(x, y, abs(x2-x1), abs(y2-y1));\nwait(10);\n}\nrun('To Selection');\n";
        new MacroRunner(macro, x + " " + y);
    }

    boolean roiManagerSelect(int x, int y) {
        RoiManager rm = RoiManager.getInstance();
        if (rm == null) {
            return false;
        }
        Hashtable rois = rm.getROIs();
        List list = rm.getList();
        int n = list.getItemCount();
        if (this.labelRects == null || this.labelRects.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.labelRects[i] == null || !this.labelRects[i].contains(x, y)) continue;
            new MacroRunner("roiManager('select', " + i + "); roiManager('update');");
            return true;
        }
        return false;
    }

    protected void setupScroll(int ox, int oy) {
        this.xMouseStart = ox;
        this.yMouseStart = oy;
        this.xSrcStart = this.srcRect.x;
        this.ySrcStart = this.srcRect.y;
    }

    protected void handlePopupMenu(MouseEvent e) {
        PopupMenu popup;
        if (this.disablePopupMenu) {
            return;
        }
        if (IJ.debugMode) {
            IJ.log("show popup: " + (e.isPopupTrigger() ? "true" : "false"));
        }
        int x = e.getX();
        int y = e.getY();
        Roi roi = this.imp.getRoi();
        if (roi != null && (roi.getType() == 2 || roi.getType() == 6 || roi.getType() == 8)) {
            if (roi.getState() == 0) {
                roi.handleMouseUp(x, y);
                roi.handleMouseUp(x, y);
                return;
            }
        }
        if ((popup = Menus.getPopupMenu()) != null) {
            this.add(popup);
            if (IJ.isMacOSX()) {
                IJ.wait(10);
            }
            popup.show(this, x, y);
        }
    }

    public void mouseExited(MouseEvent e) {
        ImageWindow win = this.imp.getWindow();
        if (win != null) {
            this.setCursor(defaultCursor);
        }
        IJ.showStatus("");
    }

    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.xMouse = this.offScreenX(x);
        this.yMouse = this.offScreenY(y);
        this.flags = e.getModifiers();
        if (this.flags == 0) {
            this.flags = 16;
        }
        if (Toolbar.getToolId() == 12 || IJ.spaceBarDown()) {
            this.scroll(x, y);
        } else {
            IJ.setInputEvent(e);
            Roi roi = this.imp.getRoi();
            if (roi != null) {
                roi.handleMouseDrag(x, y, this.flags);
            }
        }
    }

    void handleRoiMouseDown(MouseEvent e) {
        int sx = e.getX();
        int sy = e.getY();
        int ox = this.offScreenX(sx);
        int oy = this.offScreenY(sy);
        Roi roi = this.imp.getRoi();
        int handle = roi != null ? roi.isHandle(sx, sy) : -1;
        this.setRoiModState(e, roi, handle);
        if (roi != null) {
            int tool;
            Rectangle r = roi.getBounds();
            int type = roi.getType();
            if (type == 0 && r.width == this.imp.getWidth() && r.height == this.imp.getHeight() && roi.getPasteMode() == -1) {
                this.imp.killRoi();
                return;
            }
            if (handle >= 0) {
                roi.mouseDownInHandle(handle, sx, sy);
                return;
            }
            if (roi.contains(ox, oy)) {
                if (roi.modState == 0) {
                    roi.handleMouseDown(sx, sy);
                } else {
                    this.imp.killRoi();
                    this.imp.createNewRoi(sx, sy);
                }
                return;
            }
            if (type == 2 || type == 6 || type == 8) {
                if (roi.getState() == 0) {
                    return;
                }
            }
            if (!((tool = Toolbar.getToolId()) != 2 && tool != 5 && tool != 14 || IJ.shiftKeyDown() || IJ.altKeyDown())) {
                this.imp.killRoi();
                return;
            }
        }
        this.imp.createNewRoi(sx, sy);
    }

    void setRoiModState(MouseEvent e, Roi roi, int handle) {
        if (roi == null || handle >= 0 && roi.modState == 0) {
            return;
        }
        if (roi.state == 0) {
            return;
        }
        int tool = Toolbar.getToolId();
        if (tool > 3 && tool != 8 && tool != 7) {
            roi.modState = 0;
            return;
        }
        roi.modState = e.isShiftDown() ? 1 : (e.isAltDown() ? 2 : 0);
    }

    public void disablePopupMenu(boolean status) {
        this.disablePopupMenu = status;
    }

    public void setShowAllROIs(boolean showAllROIs) {
        this.showAllROIs = showAllROIs;
    }

    public boolean getShowAllROIs() {
        return this.showAllROIs;
    }

    public void setDisplayList(Vector list) {
        this.displayList = list;
        this.labelListItems = true;
        this.listColor = null;
        this.repaint();
    }

    public void setDisplayList(Shape shape, Color color, BasicStroke stroke) {
        if (shape == null) {
            this.setDisplayList(null);
            return;
        }
        ShapeRoi roi = new ShapeRoi(shape);
        Vector<ShapeRoi> list = new Vector<ShapeRoi>();
        list.addElement(roi);
        this.displayList = list;
        this.labelListItems = false;
        this.listColor = color;
        this.listStroke = stroke;
        this.repaint();
    }

    public void setShowCursorStatus(boolean status) {
        this.showCursorStatus = status;
        if (status) {
            this.sy2 = -1000;
            this.sx2 = -1000;
        } else {
            this.sx2 = this.screenX(this.xMouse);
            this.sy2 = this.screenY(this.yMouse);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void mouseReleased(MouseEvent e) {
        this.flags = e.getModifiers();
        this.flags &= 0xFFFFFFEF;
        this.flags &= 0xFFFFFFF7;
        this.flags &= 0xFFFFFFFB;
        Roi roi = this.imp.getRoi();
        if (roi == null) return;
        Rectangle r = roi.getBounds();
        int type = roi.getType();
        if (!(r.width != 0 && r.height != 0 || type == 2 || type == 6 || type == 8 || type == 5 || roi instanceof TextRoi)) {
            if (roi.getState() == 0) {
                if (type != 10) {
                    this.imp.killRoi();
                    return;
                }
            }
        }
        roi.handleMouseUp(e.getX(), e.getY());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void mouseMoved(MouseEvent e) {
        int oy;
        int ox;
        int sy;
        int sx;
        block7: {
            Roi roi;
            block8: {
                if (this.ij == null) {
                    return;
                }
                sx = e.getX();
                sy = e.getY();
                ox = this.offScreenX(sx);
                oy = this.offScreenY(sy);
                this.flags = e.getModifiers();
                this.setCursor(sx, sy, ox, oy);
                IJ.setInputEvent(e);
                roi = this.imp.getRoi();
                if (roi == null) break block7;
                if (roi.getType() == 2 || roi.getType() == 6) break block8;
                if (roi.getType() != 8) break block7;
            }
            if (roi.getState() == 0) {
                PolygonRoi pRoi = (PolygonRoi)roi;
                pRoi.handleMouseMove(ox, oy);
                return;
            }
        }
        if (ox < this.imageWidth && oy < this.imageHeight) {
            ImageWindow win = this.imp.getWindow();
            if ((sx - this.sx2) * (sx - this.sx2) + (sy - this.sy2) * (sy - this.sy2) > 144) {
                this.showCursorStatus = true;
            }
            if (win == null) return;
            if (!this.showCursorStatus) return;
            win.mouseMoved(ox, oy);
            return;
        }
        IJ.showStatus("");
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    static {
        zoomLevels = new double[]{0.013888888888888888, 0.020833333333333332, 0.03125, 0.041666666666666664, 0.0625, 0.08333333333333333, 0.125, 0.16666666666666666, 0.25, 0.3333333333333333, 0.5, 0.75, 1.0, 1.5, 2.0, 3.0, 4.0, 6.0, 8.0, 12.0, 16.0, 24.0, 32.0};
    }
}

