/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.plugin.MacroInstaller;
import ij.process.ImageProcessor;
import ij.util.StringSorter;
import java.applet.Applet;
import java.awt.CheckboxMenuItem;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.PopupMenu;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Menus {
    public static final char PLUGINS_MENU = 'p';
    public static final char IMPORT_MENU = 'i';
    public static final char SAVE_AS_MENU = 's';
    public static final char SHORTCUTS_MENU = 'h';
    public static final char ABOUT_MENU = 'a';
    public static final char FILTERS_MENU = 'f';
    public static final char TOOLS_MENU = 't';
    public static final char UTILITIES_MENU = 'u';
    public static final int WINDOW_MENU_ITEMS = 5;
    public static final int NORMAL_RETURN = 0;
    public static final int COMMAND_IN_USE = -1;
    public static final int INVALID_SHORTCUT = -2;
    public static final int SHORTCUT_IN_USE = -3;
    public static final int NOT_INSTALLED = -4;
    public static final int COMMAND_NOT_FOUND = -5;
    public static final int MAX_OPEN_RECENT_ITEMS = 15;
    private static MenuBar mbar;
    private static CheckboxMenuItem gray8Item;
    private static CheckboxMenuItem gray16Item;
    private static CheckboxMenuItem gray32Item;
    private static CheckboxMenuItem color256Item;
    private static CheckboxMenuItem colorRGBItem;
    private static CheckboxMenuItem RGBStackItem;
    private static CheckboxMenuItem HSBStackItem;
    private static PopupMenu popup;
    private static ImageJ ij;
    private static Applet applet;
    private static Hashtable demoImagesTable;
    private static String pluginsPath;
    private static String macrosPath;
    private static Menu pluginsMenu;
    private static Menu importMenu;
    private static Menu saveAsMenu;
    private static Menu shortcutsMenu;
    private static Menu aboutMenu;
    private static Menu filtersMenu;
    private static Menu toolsMenu;
    private static Menu utilitiesMenu;
    private static Menu macrosMenu;
    private static Menu optionsMenu;
    private static Hashtable pluginsTable;
    static Menu window;
    static Menu openRecentMenu;
    int nPlugins;
    int nMacros;
    private static Hashtable shortcuts;
    private static Hashtable macroShortcuts;
    private static Vector pluginsPrefs;
    static int windowMenuItems2;
    private static String error;
    private String jarError;
    private String pluginError;
    private boolean isJarErrorHeading;
    private boolean installingJars;
    private boolean duplicateCommand;
    private static Vector jarFiles;
    private static Vector macroFiles;
    private int importCount;
    private int saveAsCount;
    private int toolsCount;
    private int optionsCount;
    private static Hashtable menusTable;
    private int userPluginsIndex;
    private boolean addSorted;
    private static int fontSize;
    private static Font menuFont;
    static boolean jnlp;
    static String submenuName;
    static Menu submenu;
    static final int RGB_STACK = 10;
    static final int HSB_STACK = 11;

    Menus(ImageJ ijInstance, Applet appletInstance) {
        ij = ijInstance;
        applet = appletInstance;
    }

    String addMenuBar() {
        error = null;
        pluginsTable = new Hashtable();
        Menu file = new Menu("File");
        this.addSubMenu(file, "New");
        this.addPlugInItem(file, "Open...", "ij.plugin.Commands(\"open\")", 79, false);
        this.addPlugInItem(file, "Open Next", "ij.plugin.NextImageOpener", 79, true);
        this.addSubMenu(file, "Open Samples");
        this.addOpenRecentSubMenu(file);
        importMenu = this.addSubMenu(file, "Import");
        file.addSeparator();
        this.addPlugInItem(file, "Close", "ij.plugin.Commands(\"close\")", 87, false);
        this.addPlugInItem(file, "Save", "ij.plugin.Commands(\"save\")", 83, false);
        saveAsMenu = this.addSubMenu(file, "Save As");
        this.addPlugInItem(file, "Revert", "ij.plugin.Commands(\"revert\")", 82, false);
        file.addSeparator();
        this.addPlugInItem(file, "Page Setup...", "ij.plugin.filter.Printer(\"setup\")", 0, false);
        this.addPlugInItem(file, "Print...", "ij.plugin.filter.Printer(\"print\")", 80, false);
        file.addSeparator();
        this.addPlugInItem(file, "Quit", "ij.plugin.Commands(\"quit\")", 0, false);
        Menu edit = new Menu("Edit");
        this.addPlugInItem(edit, "Undo", "ij.plugin.Commands(\"undo\")", 90, false);
        edit.addSeparator();
        this.addPlugInItem(edit, "Cut", "ij.plugin.Clipboard(\"cut\")", 88, false);
        this.addPlugInItem(edit, "Copy", "ij.plugin.Clipboard(\"copy\")", 67, false);
        this.addPlugInItem(edit, "Copy to System", "ij.plugin.Clipboard(\"scopy\")", 0, false);
        this.addPlugInItem(edit, "Paste", "ij.plugin.Clipboard(\"paste\")", 86, false);
        this.addPlugInItem(edit, "Paste Control...", "ij.plugin.frame.PasteController", 0, false);
        edit.addSeparator();
        this.addPlugInItem(edit, "Clear", "ij.plugin.filter.Filler(\"clear\")", 0, false);
        this.addPlugInItem(edit, "Clear Outside", "ij.plugin.filter.Filler(\"outside\")", 0, false);
        this.addPlugInItem(edit, "Fill", "ij.plugin.filter.Filler(\"fill\")", 70, false);
        this.addPlugInItem(edit, "Draw", "ij.plugin.filter.Filler(\"draw\")", 68, false);
        this.addPlugInItem(edit, "Invert", "ij.plugin.filter.Filters(\"invert\")", 73, true);
        edit.addSeparator();
        this.addSubMenu(edit, "Selection");
        optionsMenu = this.addSubMenu(edit, "Options");
        Menu image = new Menu("Image");
        Menu imageType = new Menu("Type");
        gray8Item = this.addCheckboxItem(imageType, "8-bit", "ij.plugin.Converter(\"8-bit\")");
        gray16Item = this.addCheckboxItem(imageType, "16-bit", "ij.plugin.Converter(\"16-bit\")");
        gray32Item = this.addCheckboxItem(imageType, "32-bit", "ij.plugin.Converter(\"32-bit\")");
        color256Item = this.addCheckboxItem(imageType, "8-bit Color", "ij.plugin.Converter(\"8-bit Color\")");
        colorRGBItem = this.addCheckboxItem(imageType, "RGB Color", "ij.plugin.Converter(\"RGB Color\")");
        imageType.add(new MenuItem("-"));
        RGBStackItem = this.addCheckboxItem(imageType, "RGB Stack", "ij.plugin.Converter(\"RGB Stack\")");
        HSBStackItem = this.addCheckboxItem(imageType, "HSB Stack", "ij.plugin.Converter(\"HSB Stack\")");
        image.add(imageType);
        image.addSeparator();
        this.addSubMenu(image, "Adjust");
        this.addPlugInItem(image, "Show Info...", "ij.plugin.filter.Info", 73, false);
        this.addPlugInItem(image, "Properties...", "ij.plugin.filter.ImageProperties", 80, true);
        this.addSubMenu(image, "Color");
        this.addSubMenu(image, "Stacks");
        image.addSeparator();
        this.addPlugInItem(image, "Crop", "ij.plugin.filter.Resizer(\"crop\")", 88, true);
        this.addPlugInItem(image, "Duplicate...", "ij.plugin.filter.Duplicater", 68, true);
        this.addPlugInItem(image, "Rename...", "ij.plugin.SimpleCommands(\"rename\")", 0, false);
        this.addPlugInItem(image, "Scale...", "ij.plugin.Scaler", 69, false);
        this.addSubMenu(image, "Rotate");
        this.addSubMenu(image, "Zoom");
        image.addSeparator();
        this.addSubMenu(image, "Lookup Tables");
        Menu process = new Menu("Process");
        this.addPlugInItem(process, "Smooth", "ij.plugin.filter.Filters(\"smooth\")", 83, true);
        this.addPlugInItem(process, "Sharpen", "ij.plugin.filter.Filters(\"sharpen\")", 0, false);
        this.addPlugInItem(process, "Find Edges", "ij.plugin.filter.Filters(\"edge\")", 0, false);
        this.addPlugInItem(process, "Enhance Contrast", "ij.plugin.ContrastEnhancer", 0, false);
        this.addSubMenu(process, "Noise");
        this.addSubMenu(process, "Shadows");
        this.addSubMenu(process, "Binary");
        this.addSubMenu(process, "Math");
        this.addSubMenu(process, "FFT");
        filtersMenu = this.addSubMenu(process, "Filters");
        process.addSeparator();
        this.addPlugInItem(process, "Image Calculator...", "ij.plugin.ImageCalculator", 0, false);
        this.addPlugInItem(process, "Subtract Background...", "ij.plugin.filter.BackgroundSubtracter", 0, false);
        this.addItem(process, "Repeat Command", 82, true);
        Menu analyze = new Menu("Analyze");
        this.addPlugInItem(analyze, "Measure", "ij.plugin.filter.Analyzer", 77, false);
        this.addPlugInItem(analyze, "Analyze Particles...", "ij.plugin.filter.ParticleAnalyzer", 0, false);
        this.addPlugInItem(analyze, "Summarize", "ij.plugin.filter.Analyzer(\"sum\")", 0, false);
        this.addPlugInItem(analyze, "Distribution...", "ij.plugin.Distribution", 0, false);
        this.addPlugInItem(analyze, "Label", "ij.plugin.filter.Filler(\"label\")", 0, false);
        this.addPlugInItem(analyze, "Clear Results", "ij.plugin.filter.Analyzer(\"clear\")", 0, false);
        this.addPlugInItem(analyze, "Set Measurements...", "ij.plugin.filter.Analyzer(\"set\")", 0, false);
        analyze.addSeparator();
        this.addPlugInItem(analyze, "Set Scale...", "ij.plugin.filter.ScaleDialog", 0, false);
        this.addPlugInItem(analyze, "Calibrate...", "ij.plugin.filter.Calibrator", 0, false);
        this.addPlugInItem(analyze, "Histogram", "ij.plugin.Histogram", 72, false);
        this.addPlugInItem(analyze, "Plot Profile", "ij.plugin.filter.Profiler(\"plot\")", 75, false);
        this.addPlugInItem(analyze, "Surface Plot...", "ij.plugin.SurfacePlotter", 0, false);
        this.addSubMenu(analyze, "Gels");
        toolsMenu = this.addSubMenu(analyze, "Tools");
        window = new Menu("Window");
        this.addPlugInItem(window, "Show All", "ij.plugin.WindowOrganizer(\"show\")", 70, true);
        this.addPlugInItem(window, "Put Behind [tab]", "ij.plugin.Commands(\"tab\")", 0, false);
        this.addPlugInItem(window, "Cascade", "ij.plugin.WindowOrganizer(\"cascade\")", 0, false);
        this.addPlugInItem(window, "Tile", "ij.plugin.WindowOrganizer(\"tile\")", 0, false);
        window.addSeparator();
        Menu help = new Menu("Help");
        this.addPlugInItem(help, "ImageJ Website...", "ij.plugin.BrowserLauncher", 0, false);
        this.addPlugInItem(help, "ImageJ News...", "ij.plugin.BrowserLauncher(\"http://rsb.info.nih.gov/ij/notes.html\")", 0, false);
        this.addPlugInItem(help, "Documentation...", "ij.plugin.BrowserLauncher(\"http://rsb.info.nih.gov/ij/docs\")", 0, false);
        this.addPlugInItem(help, "Installation...", "ij.plugin.SimpleCommands(\"install\")", 0, false);
        this.addPlugInItem(help, "Search Website...", "ij.plugin.BrowserLauncher(\"http://rsb.info.nih.gov/ij/search.html\")", 0, false);
        this.addPlugInItem(help, "List Archives...", "ij.plugin.BrowserLauncher(\"https://list.nih.gov/archives/imagej.html\")", 0, false);
        help.addSeparator();
        this.addPlugInItem(help, "Plugins...", "ij.plugin.BrowserLauncher(\"http://rsb.info.nih.gov/ij/plugins\")", 0, false);
        this.addPlugInItem(help, "Macros...", "ij.plugin.BrowserLauncher(\"http://rsb.info.nih.gov/ij/macros/\")", 0, false);
        this.addPlugInItem(help, "Source Code...", "ij.plugin.BrowserLauncher(\"http://rsb.info.nih.gov/ij/developer/source/\")", 0, false);
        this.addPlugInItem(help, "Macro Language...", "ij.plugin.BrowserLauncher(\"http://rsb.info.nih.gov/ij/developer/macro/macros.html\")", 0, false);
        this.addPlugInItem(help, "Macro Functions...", "ij.plugin.BrowserLauncher(\"http://rsb.info.nih.gov/ij/developer/macro/functions.html\")", 0, false);
        help.addSeparator();
        aboutMenu = this.addSubMenu(help, "About Plugins");
        this.addPlugInItem(help, "About ImageJ...", "ij.plugin.AboutBox", 0, false);
        this.addPluginsMenu();
        if (applet == null) {
            this.installPlugins();
        }
        mbar = new MenuBar();
        if (fontSize != 0) {
            mbar.setFont(Menus.getFont());
        }
        mbar.add(file);
        mbar.add(edit);
        mbar.add(image);
        mbar.add(process);
        mbar.add(analyze);
        mbar.add(pluginsMenu);
        mbar.add(window);
        mbar.setHelpMenu(help);
        if (ij != null) {
            ij.setMenuBar(mbar);
        }
        if (this.pluginError != null) {
            String string = error = error != null ? (error = error + "\n" + this.pluginError) : this.pluginError;
        }
        if (this.jarError != null) {
            error = error != null ? (error = error + "\n" + this.jarError) : this.jarError;
        }
        return error;
    }

    void addOpenRecentSubMenu(Menu menu) {
        String path;
        openRecentMenu = new Menu("Open Recent");
        for (int i = 0; i < 15 && (path = Prefs.getString("recent" + i / 10 % 10 + i % 10)) != null; ++i) {
            MenuItem item = new MenuItem(path);
            openRecentMenu.add(item);
            item.addActionListener(ij);
        }
        menu.add(openRecentMenu);
    }

    void addItem(Menu menu, String label, int shortcut, boolean shift) {
        MenuItem item;
        if (menu == null) {
            return;
        }
        if (shortcut == 0) {
            item = new MenuItem(label);
        } else if (shift) {
            item = new MenuItem(label, new MenuShortcut(shortcut, true));
            shortcuts.put(new Integer(shortcut + 200), label);
        } else {
            item = new MenuItem(label, new MenuShortcut(shortcut));
            shortcuts.put(new Integer(shortcut), label);
        }
        if (this.addSorted) {
            if (menu == pluginsMenu) {
                this.addItemSorted(menu, item, this.userPluginsIndex);
            } else {
                this.addOrdered(menu, item);
            }
        } else {
            menu.add(item);
        }
        item.addActionListener(ij);
    }

    void addPlugInItem(Menu menu, String label, String className, int shortcut, boolean shift) {
        pluginsTable.put(label, className);
        ++this.nPlugins;
        this.addItem(menu, label, shortcut, shift);
    }

    CheckboxMenuItem addCheckboxItem(Menu menu, String label, String className) {
        pluginsTable.put(label, className);
        ++this.nPlugins;
        CheckboxMenuItem item = new CheckboxMenuItem(label);
        menu.add(item);
        item.addItemListener(ij);
        item.setState(false);
        return item;
    }

    Menu addSubMenu(Menu menu, String name) {
        String value;
        String key = name.toLowerCase(Locale.US);
        Menu submenu = new Menu(name.replace('_', ' '));
        int index = key.indexOf(32);
        if (index > 0) {
            key = key.substring(0, index);
        }
        for (int count = 1; count < 100 && (value = Prefs.getString(key + count / 10 % 10 + count % 10)) != null; ++count) {
            if (count == 1) {
                menu.add(submenu);
            }
            if (value.equals("-")) {
                submenu.addSeparator();
                continue;
            }
            this.addPluginItem(submenu, value);
        }
        if (name.equals("Lookup Tables") && applet == null) {
            this.addLuts(submenu);
        }
        return submenu;
    }

    void addLuts(Menu submenu) {
        String path = Prefs.getHomeDir() + File.separator;
        File f = new File(path + "luts");
        String[] list = null;
        if (applet == null && f.exists() && f.isDirectory()) {
            list = f.list();
        }
        if (list == null) {
            return;
        }
        if (IJ.isLinux()) {
            StringSorter.sort(list);
        }
        submenu.addSeparator();
        for (int i = 0; i < list.length; ++i) {
            String name = list[i];
            if (!name.endsWith(".lut")) continue;
            name = name.substring(0, name.length() - 4);
            MenuItem item = new MenuItem(name);
            submenu.add(item);
            item.addActionListener(ij);
            ++this.nPlugins;
        }
    }

    void addPluginItem(Menu submenu, String s) {
        int openBracket;
        if (s.startsWith("\"-\"")) {
            this.addSeparator(submenu);
            return;
        }
        int lastComma = s.lastIndexOf(44);
        if (lastComma <= 0) {
            return;
        }
        String command = s.substring(1, lastComma - 1);
        int keyCode = 0;
        boolean shift = false;
        if (command.endsWith("]") && (openBracket = command.lastIndexOf(91)) > 0) {
            boolean functionKey;
            String shortcut = command.substring(openBracket + 1, command.length() - 1);
            keyCode = Menus.convertShortcutToCode(shortcut);
            boolean bl = functionKey = keyCode >= 112 && keyCode <= 123;
            if (keyCode > 0 && !functionKey) {
                command = command.substring(0, openBracket);
            }
        }
        if (keyCode >= 112 && keyCode <= 123) {
            shortcuts.put(new Integer(keyCode), command);
            keyCode = 0;
        } else if (keyCode >= 265 && keyCode <= 290) {
            keyCode -= 200;
            shift = true;
        }
        this.addItem(submenu, command, keyCode, shift);
        while (s.charAt(lastComma + 1) == ' ' && lastComma + 2 < s.length()) {
            ++lastComma;
        }
        String className = s.substring(lastComma + 1, s.length());
        if (this.installingJars) {
            this.duplicateCommand = pluginsTable.get(command) != null;
        }
        pluginsTable.put(command, className);
        ++this.nPlugins;
    }

    void checkForDuplicate(String command) {
        if (pluginsTable.get(command) != null) {
            // empty if block
        }
    }

    void addPluginsMenu() {
        String value;
        pluginsMenu = new Menu("Plugins");
        for (int count = 1; count < 100 && (value = Prefs.getString("plug-in" + count / 10 % 10 + count % 10)) != null; ++count) {
            char firstChar = value.charAt(0);
            if (firstChar == '-') {
                pluginsMenu.addSeparator();
                continue;
            }
            if (firstChar == '>') {
                String submenu = value.substring(2, value.length() - 1);
                Menu menu = this.addSubMenu(pluginsMenu, submenu);
                if (submenu.equals("Shortcuts")) {
                    shortcutsMenu = menu;
                    continue;
                }
                if (submenu.equals("Utilities")) {
                    utilitiesMenu = menu;
                    continue;
                }
                if (!submenu.equals("Macros")) continue;
                macrosMenu = menu;
                continue;
            }
            this.addPluginItem(pluginsMenu, value);
        }
        this.userPluginsIndex = pluginsMenu.getItemCount();
        if (this.userPluginsIndex < 0) {
            this.userPluginsIndex = 0;
        }
    }

    void installPlugins() {
        String value;
        String[] plugins = Menus.getPlugins();
        String[] plugins2 = null;
        Hashtable<String, String> skipList = new Hashtable<String, String>();
        for (int index = 0; index < 100 && (value = Prefs.getString("plugin" + index / 10 % 10 + index % 10)) != null; ++index) {
            int argStart;
            Menu menu;
            char menuCode = value.charAt(0);
            switch (menuCode) {
                default: {
                    menu = pluginsMenu;
                    break;
                }
                case 'i': {
                    menu = importMenu;
                    break;
                }
                case 's': {
                    menu = saveAsMenu;
                    break;
                }
                case 'h': {
                    menu = shortcutsMenu;
                    break;
                }
                case 'a': {
                    menu = aboutMenu;
                    break;
                }
                case 'f': {
                    menu = filtersMenu;
                    break;
                }
                case 't': {
                    menu = toolsMenu;
                    break;
                }
                case 'u': {
                    menu = utilitiesMenu;
                }
            }
            String prefsValue = value;
            value = value.substring(2, value.length());
            String className = value.substring(value.lastIndexOf(44) + 1, value.length());
            boolean found = className.startsWith("ij.");
            if (!found && plugins != null) {
                if (plugins2 == null) {
                    plugins2 = this.getStrippedPlugins(plugins);
                }
                for (int i = 0; i < plugins2.length; ++i) {
                    if (!className.startsWith(plugins2[i])) continue;
                    found = true;
                    break;
                }
            }
            if (!found) continue;
            this.addPluginItem(menu, value);
            pluginsPrefs.addElement(prefsValue);
            if (className.endsWith("\")") && (argStart = className.lastIndexOf("(\"")) > 0) {
                className = className.substring(0, argStart);
            }
            skipList.put(className, "");
        }
        if (plugins != null) {
            for (int i = 0; i < plugins.length; ++i) {
                if (skipList.containsKey(plugins[i])) continue;
                this.installUserPlugin(plugins[i]);
            }
        }
        this.installJarPlugins();
        this.installMacros();
    }

    void installMacros() {
        if (macroFiles == null) {
            return;
        }
        for (int i = 0; i < macroFiles.size(); ++i) {
            String name = (String)macroFiles.elementAt(i);
            this.installMacro(name);
        }
    }

    void installMacro(String name) {
        Menu menu = pluginsMenu;
        String dir = null;
        int slashIndex = name.indexOf(47);
        if (slashIndex > 0) {
            dir = name.substring(0, slashIndex);
            name = name.substring(slashIndex + 1, name.length());
            menu = this.getPluginsSubmenu(dir);
        }
        String command = name.replace('_', ' ');
        command = command.substring(0, command.length() - 4);
        command.trim();
        if (pluginsTable.get(command) != null) {
            command = command + " Macro";
        }
        MenuItem item = new MenuItem(command);
        this.addOrdered(menu, item);
        item.addActionListener(ij);
        String path = (dir != null ? dir + File.separator : "") + name;
        pluginsTable.put(command, "ij.plugin.Macro_Runner(\"" + path + "\")");
        ++this.nMacros;
    }

    void addOrdered(Menu menu, MenuItem item) {
        if (menu == pluginsMenu) {
            menu.add(item);
            return;
        }
        String label = item.getLabel();
        for (int i = 0; i < menu.getItemCount(); ++i) {
            if (label.compareTo(menu.getItem(i).getLabel()) >= 0) continue;
            menu.insert(item, i);
            return;
        }
        menu.add(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void installJarPlugins() {
        if (jarFiles == null) {
            return;
        }
        this.installingJars = true;
        for (int i = 0; i < jarFiles.size(); ++i) {
            String s;
            this.isJarErrorHeading = false;
            String jar = (String)jarFiles.elementAt(i);
            InputStream is = this.getConfigurationFile(jar);
            if (is == null) continue;
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(is));
            while ((s = lnr.readLine()) != null) {
                this.installJarPlugin(jar, s);
            }
            Object var7_7 = null;
            try {
                if (lnr == null) continue;
                lnr.close();
            }
            catch (IOException e2) {}
            continue;
            {
                catch (IOException e) {
                    var7_7 = null;
                    try {
                        if (lnr == null) continue;
                        lnr.close();
                    }
                    catch (IOException e2) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var7_7 = null;
                try {
                    if (lnr != null) {
                        lnr.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    void installJarPlugin(String jar, String s) {
        void var4_6;
        Menu menu;
        if (s.length() < 3) {
            return;
        }
        char firstChar = s.charAt(0);
        if (firstChar == '#') {
            return;
        }
        this.addSorted = false;
        if (s.startsWith("Plugins>")) {
            int firstComma = s.indexOf(44);
            if (firstComma == -1 || firstComma <= 8) {
                menu = null;
            } else {
                String name = s.substring(8, firstComma);
                menu = this.getPluginsSubmenu(name);
            }
        } else if (firstChar == '\"' || s.startsWith("Plugins")) {
            String name = this.getSubmenuName(jar);
            menu = name != null ? this.getPluginsSubmenu(name) : pluginsMenu;
            this.addSorted = true;
        } else if (s.startsWith("File>Import")) {
            menu = importMenu;
            if (this.importCount == 0) {
                this.addSeparator(menu);
            }
            ++this.importCount;
        } else if (s.startsWith("File>Save")) {
            menu = saveAsMenu;
            if (this.saveAsCount == 0) {
                this.addSeparator(menu);
            }
            ++this.saveAsCount;
        } else if (s.startsWith("Analyze>Tools")) {
            menu = toolsMenu;
            if (this.toolsCount == 0) {
                this.addSeparator(menu);
            }
            ++this.toolsCount;
        } else if (s.startsWith("Help>About")) {
            menu = aboutMenu;
        } else if (s.startsWith("Edit>Options")) {
            menu = optionsMenu;
            if (this.optionsCount == 0) {
                this.addSeparator(menu);
            }
            ++this.optionsCount;
        } else {
            if (this.jarError == null) {
                this.jarError = "";
            }
            this.addJarErrorHeading(jar);
            this.jarError = this.jarError + "    Invalid menu: " + s + "\n";
            return;
        }
        int firstQuote = s.indexOf(34);
        if (firstQuote == -1) {
            return;
        }
        s = s.substring(firstQuote, s.length());
        if (var4_6 != null) {
            this.addPluginItem((Menu)var4_6, s);
            this.addSorted = false;
        }
        if (this.duplicateCommand) {
            if (this.jarError == null) {
                this.jarError = "";
            }
            this.addJarErrorHeading(jar);
            this.jarError = this.jarError + "    Duplicate command: " + s + "\n";
        }
        this.duplicateCommand = false;
    }

    void addJarErrorHeading(String jar) {
        if (!this.isJarErrorHeading) {
            if (!this.jarError.equals("")) {
                this.jarError = this.jarError + " \n";
            }
            this.jarError = this.jarError + "Plugin configuration error: " + jar + "\n";
            this.isJarErrorHeading = true;
        }
    }

    Menu getPluginsSubmenu(String submenuName) {
        Menu menu;
        if (menusTable != null && (menu = (Menu)menusTable.get(submenuName)) != null) {
            return menu;
        }
        menu = new Menu(submenuName);
        this.addItemSorted(pluginsMenu, menu, this.userPluginsIndex);
        if (menusTable == null) {
            menusTable = new Hashtable();
        }
        menusTable.put(submenuName, menu);
        return menu;
    }

    String getSubmenuName(String jarPath) {
        int index;
        if (jarPath.startsWith(pluginsPath)) {
            jarPath = jarPath.substring(pluginsPath.length() - 1);
        }
        if ((index = jarPath.lastIndexOf(File.separatorChar)) < 0) {
            return null;
        }
        String name = jarPath.substring(0, index);
        if ((index = name.lastIndexOf(File.separatorChar)) < 0) {
            return null;
        }
        if ((name = name.substring(index + 1)).equals("plugins")) {
            return null;
        }
        return name;
    }

    void addItemSorted(Menu menu, MenuItem item, int startingIndex) {
        String itemLabel = item.getLabel();
        int count = menu.getItemCount();
        boolean inserted = false;
        for (int i = startingIndex; i < count; ++i) {
            MenuItem mi = menu.getItem(i);
            String label = mi.getLabel();
            if (itemLabel.compareTo(label) >= 0) continue;
            menu.insert(item, i);
            inserted = true;
            break;
        }
        if (!inserted) {
            menu.add(item);
        }
    }

    void addSeparator(Menu menu) {
        menu.addSeparator();
    }

    InputStream getConfigurationFile(String jar) {
        try {
            ZipFile jarFile = new ZipFile(jar);
            Enumeration<? extends ZipEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().endsWith("plugins.config")) continue;
                return jarFile.getInputStream(entry);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.autoGenerateConfigFile(jar);
    }

    InputStream autoGenerateConfigFile(String jar) {
        StringBuffer sb = null;
        try {
            ZipFile jarFile = new ZipFile(jar);
            Enumeration<? extends ZipEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".class") || name.indexOf("_") <= 0 || name.indexOf("$") != -1 || name.indexOf("/_") != -1 || name.startsWith("_")) continue;
                if (sb == null) {
                    sb = new StringBuffer();
                }
                String className = name.substring(0, name.length() - 6);
                int slashIndex = className.lastIndexOf(47);
                String plugins = "Plugins";
                if (slashIndex >= 0) {
                    plugins = plugins + ">" + className.substring(0, slashIndex).replace('/', '>').replace('_', ' ');
                    name = className.substring(slashIndex + 1);
                } else {
                    name = className;
                }
                name = name.replace('_', ' ');
                className = className.replace('/', '.');
                sb.append(plugins + ", \"" + name + "\", " + className + "\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sb == null) {
            return null;
        }
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    String[] getStrippedPlugins(String[] plugins) {
        String[] plugins2 = new String[plugins.length];
        for (int i = 0; i < plugins2.length; ++i) {
            plugins2[i] = plugins[i];
            int slashPos = plugins2[i].lastIndexOf(47);
            if (slashPos < 0) continue;
            plugins2[i] = plugins[i].substring(slashPos + 1, plugins2[i].length());
        }
        return plugins2;
    }

    public static synchronized String[] getPlugins() {
        File f;
        String homeDir = Prefs.getHomeDir();
        if (homeDir == null) {
            return null;
        }
        if (homeDir.endsWith("plugins")) {
            pluginsPath = homeDir + Prefs.separator;
        } else {
            String pluginsDir;
            String property = System.getProperty("plugins.dir");
            if (property != null && (property.endsWith("/") || property.endsWith("\\"))) {
                property = property.substring(0, property.length() - 1);
            }
            if ((pluginsDir = property) == null) {
                pluginsDir = homeDir;
            } else if (pluginsDir.equals("user.home")) {
                pluginsDir = System.getProperty("user.home");
                if (!new File(pluginsDir + Prefs.separator + "plugins").isDirectory()) {
                    pluginsDir = pluginsDir + Prefs.separator + "ImageJ";
                }
                property = null;
                if (applet == null) {
                    System.setSecurityManager(null);
                }
                jnlp = true;
            }
            pluginsPath = pluginsDir + Prefs.separator + "plugins" + Prefs.separator;
            if (property != null && !new File(pluginsPath).isDirectory()) {
                pluginsPath = pluginsDir + Prefs.separator;
            }
            macrosPath = pluginsDir + Prefs.separator + "macros" + Prefs.separator;
        }
        File file = f = macrosPath != null ? new File(macrosPath) : null;
        if (f != null && !f.isDirectory()) {
            macrosPath = null;
        }
        File file2 = f = pluginsPath != null ? new File(pluginsPath) : null;
        if (f == null || f != null && !f.isDirectory()) {
            pluginsPath = null;
            return null;
        }
        Object[] list = f.list();
        if (list == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        jarFiles = null;
        macroFiles = null;
        for (int i = 0; i < list.length; ++i) {
            boolean hasUnderscore;
            String name = list[i];
            boolean isClassFile = name.endsWith(".class");
            boolean bl = hasUnderscore = name.indexOf(95) >= 0;
            if (hasUnderscore && isClassFile && name.indexOf(36) < 0) {
                name = name.substring(0, name.length() - 6);
                v.addElement(name);
                continue;
            }
            if (hasUnderscore && (name.endsWith(".jar") || name.endsWith(".zip"))) {
                if (jarFiles == null) {
                    jarFiles = new Vector();
                }
                jarFiles.addElement(pluginsPath + name);
                continue;
            }
            if (hasUnderscore && (name.endsWith(".txt") || name.endsWith(".ijm"))) {
                if (macroFiles == null) {
                    macroFiles = new Vector();
                }
                macroFiles.addElement(name);
                continue;
            }
            if (isClassFile) continue;
            Menus.checkSubdirectory(pluginsPath, name, v);
        }
        list = new String[v.size()];
        v.copyInto(list);
        StringSorter.sort((String[])list);
        return list;
    }

    static void checkSubdirectory(String path, String dir, Vector v) {
        if (dir.endsWith(".java")) {
            return;
        }
        File f = new File(path, dir);
        if (!f.isDirectory()) {
            return;
        }
        String[] list = f.list();
        if (list == null) {
            return;
        }
        dir = dir + "/";
        for (int i = 0; i < list.length; ++i) {
            boolean hasUnderscore;
            String name = list[i];
            boolean bl = hasUnderscore = name.indexOf(95) >= 0;
            if (hasUnderscore && name.endsWith(".class") && name.indexOf(36) < 0) {
                name = name.substring(0, name.length() - 6);
                v.addElement(dir + name);
                continue;
            }
            if (hasUnderscore && (name.endsWith(".jar") || name.endsWith(".zip"))) {
                if (jarFiles == null) {
                    jarFiles = new Vector();
                }
                jarFiles.addElement(f.getPath() + File.separator + name);
                continue;
            }
            if (!hasUnderscore || !name.endsWith(".txt") && !name.endsWith(".ijm")) continue;
            if (macroFiles == null) {
                macroFiles = new Vector();
            }
            macroFiles.addElement(dir + name);
        }
    }

    void installUserPlugin(String className) {
        Menu menu = pluginsMenu;
        int slashIndex = className.indexOf(47);
        String command = className;
        if (slashIndex > 0) {
            String dir = className.substring(0, slashIndex);
            command = className.substring(slashIndex + 1, className.length());
            if (submenu == null || !submenuName.equals(dir)) {
                submenuName = dir;
                submenu = new Menu(submenuName);
                pluginsMenu.add(submenu);
                if (menusTable == null) {
                    menusTable = new Hashtable();
                }
                menusTable.put(submenuName, submenu);
            }
            menu = submenu;
        }
        command = command.replace('_', ' ');
        command.trim();
        if (pluginsTable.get(command) != null) {
            command = command + " Plugin";
        }
        MenuItem item = new MenuItem(command);
        menu.add(item);
        item.addActionListener(ij);
        pluginsTable.put(command, className.replace('/', '.'));
        ++this.nPlugins;
    }

    void installPopupMenu(ImageJ ij) {
        String s;
        int count = 0;
        popup = new PopupMenu("");
        if (fontSize != 0) {
            popup.setFont(Menus.getFont());
        }
        while ((s = Prefs.getString("popup" + ++count / 10 % 10 + count % 10)) != null) {
            if (s.equals("-")) {
                popup.addSeparator();
                continue;
            }
            if (s.equals("")) continue;
            MenuItem mi = new MenuItem(s);
            mi.addActionListener(ij);
            popup.add(mi);
        }
    }

    public static MenuBar getMenuBar() {
        return mbar;
    }

    public static Menu getMacrosMenu() {
        return macrosMenu;
    }

    public static void updateMenus() {
        ImageProcessor ip;
        if (ij == null) {
            return;
        }
        gray8Item.setState(false);
        gray16Item.setState(false);
        gray32Item.setState(false);
        color256Item.setState(false);
        colorRGBItem.setState(false);
        RGBStackItem.setState(false);
        HSBStackItem.setState(false);
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return;
        }
        int type = imp.getType();
        if (imp.getStackSize() > 1) {
            ImageStack stack = imp.getStack();
            if (stack.isRGB()) {
                type = 10;
            } else if (stack.isHSB()) {
                type = 11;
            }
        }
        if (type == 0 && (ip = imp.getProcessor()) != null && ip.getMinThreshold() == -808080.0 && ip.isColorLut()) {
            type = 3;
            if (!ip.isPseudoColorLut()) {
                imp.setType(3);
            }
        }
        switch (type) {
            case 0: {
                gray8Item.setState(true);
                break;
            }
            case 1: {
                gray16Item.setState(true);
                break;
            }
            case 2: {
                gray32Item.setState(true);
                break;
            }
            case 3: {
                color256Item.setState(true);
                break;
            }
            case 4: {
                colorRGBItem.setState(true);
                break;
            }
            case 10: {
                RGBStackItem.setState(true);
                break;
            }
            case 11: {
                HSBStackItem.setState(true);
            }
        }
        int nItems = window.getItemCount();
        int start = 5 + windowMenuItems2;
        int index = start + WindowManager.getCurrentIndex();
        try {
            for (int i = start; i < nItems; ++i) {
                CheckboxMenuItem item = (CheckboxMenuItem)window.getItem(i);
                item.setState(i == index);
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    static boolean isColorLut(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        IndexColorModel cm = (IndexColorModel)ip.getColorModel();
        if (cm == null) {
            return false;
        }
        int mapSize = cm.getMapSize();
        byte[] reds = new byte[mapSize];
        byte[] greens = new byte[mapSize];
        byte[] blues = new byte[mapSize];
        cm.getReds(reds);
        cm.getGreens(greens);
        cm.getBlues(blues);
        boolean isColor = false;
        for (int i = 0; i < mapSize; ++i) {
            if (reds[i] == greens[i] && greens[i] == blues[i]) continue;
            isColor = true;
            break;
        }
        return isColor;
    }

    public static String getPlugInsPath() {
        return pluginsPath;
    }

    public static String getMacrosPath() {
        return macrosPath;
    }

    public static Hashtable getCommands() {
        return pluginsTable;
    }

    public static Hashtable getShortcuts() {
        return shortcuts;
    }

    public static Hashtable getMacroShortcuts() {
        if (macroShortcuts == null) {
            macroShortcuts = new Hashtable();
        }
        return macroShortcuts;
    }

    static synchronized void insertWindowMenuItem(Frame win) {
        if (ij == null || win == null) {
            return;
        }
        CheckboxMenuItem item = new CheckboxMenuItem(win.getTitle());
        item.addItemListener(ij);
        int index = 5 + windowMenuItems2;
        if (windowMenuItems2 >= 2) {
            --index;
        }
        window.insert(item, index);
        if (++windowMenuItems2 == 1) {
            window.insertSeparator(5 + windowMenuItems2);
            ++windowMenuItems2;
        }
    }

    static synchronized void addWindowMenuItem(ImagePlus imp) {
        if (ij == null) {
            return;
        }
        String name = imp.getTitle();
        int size = imp.getWidth() * imp.getHeight() * imp.getStackSize() / 1024;
        switch (imp.getType()) {
            case 2: 
            case 4: {
                size *= 4;
                break;
            }
            case 1: {
                size *= 2;
                break;
            }
        }
        CheckboxMenuItem item = new CheckboxMenuItem(name + " " + size + "K");
        window.add(item);
        item.addItemListener(ij);
    }

    static synchronized void removeWindowMenuItem(int index) {
        if (ij == null) {
            return;
        }
        if (index >= 0 && index < window.getItemCount()) {
            window.remove(5 + index);
            if (index < windowMenuItems2 && --windowMenuItems2 == 1) {
                window.remove(5);
                windowMenuItems2 = 0;
            }
        }
    }

    public static synchronized void updateWindowMenuItem(String oldLabel, String newLabel) {
        if (oldLabel.equals(newLabel)) {
            return;
        }
        int first = 5;
        int last = window.getItemCount() - 1;
        try {
            for (int i = first; i <= last; ++i) {
                int index;
                MenuItem item = window.getItem(i);
                String label = item.getLabel();
                if (item == null || !label.startsWith(oldLabel)) continue;
                if (label.endsWith("K") && (index = label.lastIndexOf(32)) > -1) {
                    newLabel = newLabel + label.substring(index, label.length());
                }
                item.setLabel(newLabel);
                return;
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    public static synchronized void addOpenRecentItem(String path) {
        if (ij == null) {
            return;
        }
        int count = openRecentMenu.getItemCount();
        if (count > 0 && openRecentMenu.getItem(0).getLabel().equals(path)) {
            return;
        }
        if (count == 15) {
            openRecentMenu.remove(14);
        }
        MenuItem item = new MenuItem(path);
        openRecentMenu.insert(item, 0);
        item.addActionListener(ij);
    }

    public static PopupMenu getPopupMenu() {
        return popup;
    }

    /*
     * WARNING - void declaration
     */
    public static int installPlugin(String plugin, char menuCode, String command, String shortcut, ImageJ ij) {
        void var5_5;
        MenuItem item;
        boolean functionKey;
        if (command.equals("")) {
            return 0;
        }
        if (Menus.commandInUse(command)) {
            return -1;
        }
        if (!Menus.validShortcut(shortcut)) {
            return -2;
        }
        if (Menus.shortcutInUse(shortcut)) {
            return -3;
        }
        switch (menuCode) {
            case 'p': {
                Menu menu = pluginsMenu;
                break;
            }
            case 'i': {
                Menu menu = importMenu;
                break;
            }
            case 's': {
                Menu menu = saveAsMenu;
                break;
            }
            case 'h': {
                Menu menu = shortcutsMenu;
                break;
            }
            case 'a': {
                Menu menu = aboutMenu;
                break;
            }
            case 'f': {
                Menu menu = filtersMenu;
                break;
            }
            case 't': {
                Menu menu = toolsMenu;
                break;
            }
            case 'u': {
                Menu menu = utilitiesMenu;
                break;
            }
            default: {
                return 0;
            }
        }
        int code = Menus.convertShortcutToCode(shortcut);
        boolean bl = functionKey = code >= 112 && code <= 123;
        if (code == 0) {
            item = new MenuItem(command);
        } else if (functionKey) {
            command = command + " [F" + (code - 112 + 1) + "]";
            shortcuts.put(new Integer(code), command);
            item = new MenuItem(command);
        } else {
            shortcuts.put(new Integer(code), command);
            int keyCode = code;
            boolean shift = false;
            if (keyCode >= 265 && keyCode <= 290) {
                keyCode -= 200;
                shift = true;
            }
            item = new MenuItem(command, new MenuShortcut(keyCode, shift));
        }
        var5_5.add(item);
        item.addActionListener(ij);
        pluginsTable.put(command, plugin);
        shortcut = code > 0 && !functionKey ? "[" + shortcut + "]" : "";
        pluginsPrefs.addElement(menuCode + ",\"" + command + shortcut + "\"," + plugin);
        return 0;
    }

    public static int uninstallPlugin(String command) {
        boolean found = false;
        Enumeration en = pluginsPrefs.elements();
        while (en.hasMoreElements()) {
            String cmd = (String)en.nextElement();
            if (cmd.indexOf(command) <= 0) continue;
            pluginsPrefs.removeElement(cmd);
            found = true;
            break;
        }
        if (found) {
            return 0;
        }
        return -5;
    }

    public static boolean commandInUse(String command) {
        return pluginsTable.get(command) != null;
    }

    public static int convertShortcutToCode(String shortcut) {
        int code = 0;
        int len = shortcut.length();
        if (len == 2 && shortcut.charAt(0) == 'F') {
            code = 112 + shortcut.charAt(1) - 49;
            if (code >= 112 && code <= 120) {
                return code;
            }
            return 0;
        }
        if (len == 3 && shortcut.charAt(0) == 'F') {
            code = 121 + shortcut.charAt(2) - 48;
            if (code >= 121 && code <= 123) {
                return code;
            }
            return 0;
        }
        if (len == 2 && shortcut.charAt(0) == 'N') {
            code = 96 + shortcut.charAt(1) - 48;
            if (code >= 96 && code <= 105) {
                return code;
            }
            switch (shortcut.charAt(1)) {
                case '/': {
                    return 111;
                }
                case '*': {
                    return 106;
                }
                case '-': {
                    return 109;
                }
                case '+': {
                    return 107;
                }
                case '.': {
                    return 110;
                }
            }
            return 0;
        }
        if (len != 1) {
            return 0;
        }
        char c2 = shortcut.charAt(0);
        if (c2 >= 'A' && c2 <= 'Z') {
            code = 65 + c2 - 65 + 200;
        } else if (c2 >= 'a' && c2 <= 'z') {
            code = 65 + c2 - 97;
        } else if (c2 >= '0' && c2 <= '9') {
            code = 48 + c2 - 48;
        } else {
            switch (c2) {
                case '+': {
                    code = 521;
                    break;
                }
                case '-': {
                    code = 45;
                    break;
                }
                default: {
                    return 0;
                }
            }
        }
        return code;
    }

    void installStartupMacroSet() {
        if (applet != null) {
            int index;
            String docBase = "" + applet.getDocumentBase();
            if (!docBase.endsWith("/") && (index = docBase.lastIndexOf("/")) != -1) {
                docBase = docBase.substring(0, index + 1);
            }
            IJ.runPlugIn("ij.plugin.URLOpener", docBase + "StartupMacros.txt");
            return;
        }
        if (macrosPath == null) {
            new MacroInstaller().installFromIJJar("/macros/StartupMacros.txt");
            return;
        }
        String path = macrosPath + "StartupMacros.txt";
        File f = new File(path);
        if (!f.exists() && !(f = new File(path = macrosPath + "StartupMacros.ijm")).exists()) {
            new MacroInstaller().installFromIJJar("/macros/StartupMacros.txt");
            return;
        }
        String libraryPath = macrosPath + "Library.txt";
        f = new File(libraryPath);
        boolean isLibrary = f.exists();
        try {
            MacroInstaller mi = new MacroInstaller();
            if (isLibrary) {
                mi.installLibrary(libraryPath);
            }
            mi.installFile(path);
            this.nMacros += mi.getMacroCount();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    static boolean validShortcut(String shortcut) {
        int len = shortcut.length();
        if (shortcut.equals("")) {
            return true;
        }
        if (len == 1) {
            return true;
        }
        return shortcut.startsWith("F") && (len == 2 || len == 3);
    }

    public static boolean shortcutInUse(String shortcut) {
        int code = Menus.convertShortcutToCode(shortcut);
        return shortcuts.get(new Integer(code)) != null;
    }

    public static void setFontSize(int size) {
        if (size < 9 && size != 0) {
            size = 9;
        }
        if (size > 24) {
            size = 24;
        }
        fontSize = size;
    }

    public static int getFontSize() {
        return IJ.isMacintosh() ? 0 : fontSize;
    }

    public static Font getFont() {
        if (menuFont == null) {
            menuFont = new Font("SanSerif", 0, fontSize == 0 ? 12 : fontSize);
        }
        return menuFont;
    }

    public static void savePreferences(Properties prefs) {
        int index = 0;
        Enumeration en = pluginsPrefs.elements();
        while (en.hasMoreElements()) {
            String key = "plugin" + index / 10 % 10 + index % 10;
            String value = (String)en.nextElement();
            prefs.put(key, value);
            ++index;
        }
        int n = openRecentMenu.getItemCount();
        for (int i = 0; i < n; ++i) {
            String key = "" + i;
            if (key.length() == 1) {
                key = "0" + key;
            }
            key = "recent" + key;
            prefs.put(key, openRecentMenu.getItem(i).getLabel());
        }
        prefs.put("menu.size", Integer.toString(fontSize));
    }

    static {
        demoImagesTable = new Hashtable();
        shortcuts = new Hashtable();
        pluginsPrefs = new Vector();
        fontSize = Prefs.getInt("menu.size", 14);
    }
}

