/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IStringSpectrum;
import fr.esrf.tangoatk.core.IStringSpectrumListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import java.io.Serializable;

public class StringSpectrumHelper
implements Serializable {
    IAttribute attribute;
    EventSupport propChanges;

    public StringSpectrumHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    void init(IAttribute iAttribute) {
        this.setAttribute(iAttribute);
        this.propChanges = ((AAttribute)iAttribute).getPropChanges();
    }

    public void setAttribute(IAttribute iAttribute) {
        this.attribute = iAttribute;
    }

    public IAttribute getAttribute() {
        return this.attribute;
    }

    protected void setProperty(String string, Number number) {
        this.attribute.setProperty(string, number);
        this.attribute.storeConfig();
    }

    protected void setProperty(String string, Number number, boolean bl) {
        this.attribute.setProperty(string, number, bl);
    }

    void fireValueChanged(String[] stringArray, long l) {
        this.propChanges.fireStringSpectrumEvent((IStringSpectrum)this.attribute, stringArray, l);
    }

    void insert(String[] stringArray) {
        this.attribute.getAttribute().insert(stringArray);
    }

    String[] extract() throws DevFailed {
        return this.attribute.getAttribute().extractStringArray();
    }

    String[] getStringSpectrumValue(DeviceAttribute deviceAttribute) throws DevFailed {
        return deviceAttribute.extractStringArray();
    }

    void addStringSpectrumListener(IStringSpectrumListener iStringSpectrumListener) {
        this.propChanges.addStringSpectrumListener(iStringSpectrumListener);
    }

    void removeStringSpectrumListener(IStringSpectrumListener iStringSpectrumListener) {
        this.propChanges.removeStringSpectrumListener(iStringSpectrumListener);
    }

    public String getVersion() {
        return "$Id: StringSpectrumHelper.java,v 1.5 2006/10/11 15:21:39 jlpons Exp $";
    }
}

