/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarHistory;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.IScalarAttribute;
import fr.esrf.tangoatk.core.attribute.ANumber;
import fr.esrf.tangoatk.core.attribute.ANumberScalarHelper;
import fr.esrf.tangoatk.core.attribute.NumberScalarHistory;
import java.io.IOException;
import java.io.ObjectInputStream;

public class NumberScalar
extends ANumber
implements INumberScalar {
    double scalarValue;
    double setPointValue;
    double devScalarValue;
    double devSetPointValue;
    double[] possibleValues = null;

    public ANumberScalarHelper getNumberScalarHelper() {
        return (ANumberScalarHelper)this.getNumberHelper();
    }

    public IScalarAttribute getWritableAttribute() {
        return null;
    }

    public IScalarAttribute getReadableAttribute() {
        return null;
    }

    public int getXDimension() {
        return 1;
    }

    public int getMaxXDimension() {
        return 1;
    }

    public void addNumberScalarListener(INumberScalarListener iNumberScalarListener) {
        this.getNumberScalarHelper().addNumberScalarListener(iNumberScalarListener);
        this.addStateListener(iNumberScalarListener);
    }

    public void removeNumberScalarListener(INumberScalarListener iNumberScalarListener) {
        this.getNumberScalarHelper().removeNumberScalarListener(iNumberScalarListener);
        this.removeStateListener(iNumberScalarListener);
    }

    public double[][] getNumberValue() {
        double[][] dArray = new double[1][1];
        dArray[0][0] = this.getNumberScalarValue();
        return dArray;
    }

    public double[] getSpectrumValue() {
        double[] dArray = new double[]{this.getNumberScalarValue()};
        return dArray;
    }

    public Number getNumber() {
        try {
            return new Double(this.getNumberScalarValue());
        }
        catch (Exception exception) {
            this.readAttError("Couldn't read from network", new ConnectionException(exception));
            return new Double(Double.NaN);
        }
    }

    public void setNumber(Number number) throws IllegalArgumentException {
        double d = number.doubleValue();
        this.setValue(d);
    }

    public void setValue(double[] dArray) {
        this.setValue(dArray[0]);
    }

    public void setValue(double[][] dArray) {
        this.setValue(dArray[0][0]);
    }

    public final void refresh() {
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        if (this.skippingRefresh) {
            return;
        }
        ++this.refreshCount;
        this.trace(4, "NumberScalar.refresh() method called for " + this.getName(), l);
        try {
            try {
                deviceAttribute = this.readValueFromNetwork();
                if (deviceAttribute == null) {
                    return;
                }
                this.scalarValue = this.getNumberScalarHelper().getNumberScalarDisplayValue(deviceAttribute);
                this.setPointValue = this.getNumberScalarHelper().getNumberScalarDisplaySetPoint(deviceAttribute);
                this.getNumberScalarHelper().fireScalarValueChanged(this.scalarValue, this.timeStamp);
            }
            catch (DevFailed devFailed) {
                this.scalarValue = Double.NaN;
                this.setPointValue = Double.NaN;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
        }
        catch (Exception exception) {
            this.scalarValue = Double.NaN;
            this.setPointValue = Double.NaN;
            System.out.println("NumberScalar.refresh() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("NumberScalar.refresh()------------------------------------------------");
        }
    }

    public void dispatch(DeviceAttribute deviceAttribute) {
        if (this.skippingRefresh) {
            return;
        }
        ++this.refreshCount;
        try {
            try {
                if (deviceAttribute == null) {
                    return;
                }
                this.attribute = deviceAttribute;
                this.setState(deviceAttribute);
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.scalarValue = this.getNumberScalarHelper().getNumberScalarDisplayValue(deviceAttribute);
                this.setPointValue = this.getNumberScalarHelper().getNumberScalarDisplaySetPoint(deviceAttribute);
                this.getNumberScalarHelper().fireScalarValueChanged(this.scalarValue, this.timeStamp);
            }
            catch (DevFailed devFailed) {
                this.dispatchError(devFailed);
            }
        }
        catch (Exception exception) {
            this.scalarValue = Double.NaN;
            this.setPointValue = Double.NaN;
            System.out.println("NumberScalar.dispatch() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("NumberScalar.dispatch()------------------------------------------------");
        }
    }

    public void dispatchError(DevFailed devFailed) {
        this.scalarValue = Double.NaN;
        this.setPointValue = Double.NaN;
        this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
    }

    public void setValue(double d) {
        try {
            this.insert(d);
            this.writeAtt();
        }
        catch (DevFailed devFailed) {
            this.setAttError("Couldn't set value", new AttributeSetException(devFailed));
        }
        catch (Exception exception) {
            System.out.println("Received un exception other than DevFailed while setting a numberScalar");
            this.setAttError("Couldn't set value", new AttributeSetException("Set Exception other than DevFailed."));
        }
    }

    protected DeviceAttribute scalarInsert(String string) throws DevFailed {
        this.insert(string);
        return this.attribute;
    }

    protected void insert(double[] dArray) {
        this.insert(dArray[0]);
    }

    protected void insert(double d) {
        this.getNumberScalarHelper().insert(d);
    }

    protected void insert(String string) {
        this.insert(Double.parseDouble(string));
    }

    public double getNumberScalarValue() {
        return this.scalarValue;
    }

    public double getNumberScalarDeviceValue() {
        double d = 1.0;
        d = this.getDisplayUnitFactor();
        if (d <= 0.0) {
            d = 1.0;
        }
        this.devScalarValue = this.scalarValue / d;
        return this.devScalarValue;
    }

    public double getNumberScalarStandardValue() {
        double d = 1.0;
        double d2 = this.getNumberScalarDeviceValue();
        d = this.getStandardUnitFactor();
        if (d <= 0.0) {
            d = 1.0;
        }
        if (d == 1.0) {
            return d2;
        }
        double d3 = d2 * d;
        return d3;
    }

    public double getNumberScalarSetPoint() {
        return this.setPointValue;
    }

    public double getNumberScalarDeviceSetPoint() {
        double d = 1.0;
        d = this.getDisplayUnitFactor();
        if (d <= 0.0) {
            d = 1.0;
        }
        this.devSetPointValue = this.setPointValue / d;
        return this.devSetPointValue;
    }

    public double getNumberScalarStandardSetPoint() {
        double d = 1.0;
        double d2 = this.getNumberScalarDeviceSetPoint();
        d = this.getStandardUnitFactor();
        if (d <= 0.0) {
            d = 1.0;
        }
        if (d == 1.0) {
            return d2;
        }
        double d3 = d2 * d;
        return d3;
    }

    public double getNumberScalarSetPointFromDevice() {
        double d;
        try {
            this.setPointValue = d = this.getNumberScalarHelper().getNumberScalarDisplaySetPoint(this.readDeviceValueFromNetwork());
        }
        catch (DevFailed devFailed) {
            this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            d = Double.NaN;
            this.setPointValue = Double.NaN;
        }
        catch (Exception exception) {
            this.readAttError(exception.getMessage(), exception);
            d = Double.NaN;
            this.setPointValue = Double.NaN;
        }
        return d;
    }

    public INumberScalarHistory[] getNumberScalarHistory() {
        INumberScalarHistory[] iNumberScalarHistoryArray = null;
        try {
            iNumberScalarHistoryArray = (NumberScalarHistory[])this.getNumberScalarHelper().getScalarAttHistory(this.readAttHistoryFromNetwork());
        }
        catch (DevFailed devFailed) {
            this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            iNumberScalarHistoryArray = null;
        }
        catch (Exception exception) {
            this.readAttError(exception.getMessage(), exception);
            iNumberScalarHistoryArray = null;
        }
        return iNumberScalarHistoryArray;
    }

    public INumberScalarHistory[] getNumberScalarDeviceHistory() {
        INumberScalarHistory[] iNumberScalarHistoryArray = null;
        try {
            iNumberScalarHistoryArray = (NumberScalarHistory[])this.getNumberScalarHelper().getScalarDeviceAttHistory(this.readAttHistoryFromNetwork());
        }
        catch (DevFailed devFailed) {
            this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            iNumberScalarHistoryArray = null;
        }
        catch (Exception exception) {
            this.readAttError(exception.getMessage(), exception);
            iNumberScalarHistoryArray = null;
        }
        return iNumberScalarHistoryArray;
    }

    public void setPossibleValues(double[] dArray) {
        if (dArray == null) {
            return;
        }
        if (this.possibleValues == null && dArray.length > 0) {
            this.possibleValues = dArray;
        }
    }

    public double[] getPossibleValues() {
        return this.possibleValues;
    }

    public void periodic(TangoPeriodicEvent tangoPeriodicEvent) {
        ++this.periodicCount;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(128, "NumberScalar.periodic method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoPeriodicEvent.getValue();
            this.trace(128, "NumberScalar.periodicEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(128, "NumberScalar.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.scalarValue = Double.NaN;
                this.setPointValue = Double.NaN;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(128, "NumberScalar.periodicEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.scalarValue = Double.NaN;
                this.setPointValue = Double.NaN;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(128, "NumberScalar.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            this.scalarValue = Double.NaN;
            this.setPointValue = Double.NaN;
            System.out.println("NumberScalar.periodic.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("NumberScalar.periodic.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.scalarValue = this.getNumberScalarHelper().getNumberScalarDisplayValue(deviceAttribute);
                this.setPointValue = this.getNumberScalarHelper().getNumberScalarDisplaySetPoint(deviceAttribute);
                this.getNumberScalarHelper().fireScalarValueChanged(this.scalarValue, this.timeStamp);
            }
            catch (DevFailed devFailed) {
                this.scalarValue = Double.NaN;
                this.setPointValue = Double.NaN;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.scalarValue = Double.NaN;
                this.setPointValue = Double.NaN;
                System.out.println("NumberScalar.periodic.getNumberScalarDisplayValue() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("NumberScalar.periodic.getNumberScalarDisplayValue()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent tangoChangeEvent) {
        ++this.changeCount;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(32, "NumberScalar.change method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoChangeEvent.getValue();
            this.trace(32, "NumberScalar.changeEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(32, "NumberScalar.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "NumberScalar.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.scalarValue = Double.NaN;
                this.setPointValue = Double.NaN;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(32, "NumberScalar.changeEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.scalarValue = Double.NaN;
                this.setPointValue = Double.NaN;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(32, "NumberScalar.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            this.scalarValue = Double.NaN;
            this.setPointValue = Double.NaN;
            System.out.println("NumberScalar.change.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("NumberScalar.change.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.scalarValue = this.getNumberScalarHelper().getNumberScalarDisplayValue(deviceAttribute);
                this.setPointValue = this.getNumberScalarHelper().getNumberScalarDisplaySetPoint(deviceAttribute);
                this.getNumberScalarHelper().fireScalarValueChanged(this.scalarValue, this.timeStamp);
            }
            catch (DevFailed devFailed) {
                this.scalarValue = Double.NaN;
                this.setPointValue = Double.NaN;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.scalarValue = Double.NaN;
                this.setPointValue = Double.NaN;
                System.out.println("NumberScalar.change.getNumberScalarDisplayValue() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("NumberScalar.change.getNumberScalarDisplayValue()------------------------------------------------");
            }
        }
    }

    private void trace(int n, String string, long l) {
        DeviceFactory.getInstance().trace(n, string, l);
    }

    public String getVersion() {
        return "$Id: NumberScalar.java,v 1.32 2008/11/19 10:14:24 poncet Exp $";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        objectInputStream.defaultReadObject();
        this.serializeInit();
    }
}

