/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberImageHelper;
import fr.esrf.tangoatk.core.attribute.NumberAttributeHelper;

class FloatImageHelper
extends ANumberImageHelper {
    public FloatImageHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    protected void insert(double[][] dArray) {
        double d = 1.0;
        DeviceAttribute deviceAttribute = this.attribute.getAttribute();
        d = this.attribute.getDisplayUnitFactor();
        double[] dArray2 = NumberAttributeHelper.flatten(dArray);
        float[] fArray = new float[dArray2.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = (float)(dArray2[i] / d);
        }
        deviceAttribute.insert(fArray, dArray.length, dArray[0].length);
    }

    void setMinAlarm(double d, boolean bl) {
        this.setProperty("min_alarm", new Float(d), bl);
    }

    void setMaxAlarm(double d, boolean bl) {
        this.setProperty("max_alarm", new Float(d), bl);
    }

    void setMinValue(double d, boolean bl) {
        this.setProperty("min_value", new Float(d), bl);
    }

    void setMaxValue(double d, boolean bl) {
        this.setProperty("max_value", new Float(d), bl);
    }

    void setMinWarning(double d, boolean bl) {
        this.setProperty("min_warning", new Float(d), bl);
    }

    void setMaxWarning(double d, boolean bl) {
        this.setProperty("max_warning", new Float(d), bl);
    }

    void setDeltaT(double d, boolean bl) {
        this.setProperty("delta_t", new Float(d), bl);
    }

    void setDeltaVal(double d, boolean bl) {
        this.setProperty("delta_val", new Float(d), bl);
    }

    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Float(d));
    }

    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Float(d));
    }

    void setMinValue(double d) {
        this.setProperty("min_value", new Float(d));
    }

    void setMaxValue(double d) {
        this.setProperty("max_value", new Float(d));
    }

    void setMinWarning(double d) {
        this.setProperty("min_warning", new Float(d));
    }

    void setMaxWarning(double d) {
        this.setProperty("max_warning", new Float(d));
    }

    void setDeltaT(double d) {
        this.setProperty("delta_t", new Float(d));
    }

    void setDeltaVal(double d) {
        this.setProperty("delta_val", new Float(d));
    }

    double[][] getNumberImageValue(DeviceAttribute deviceAttribute) throws DevFailed {
        float[] fArray = deviceAttribute.extractFloatArray();
        int n = this.attribute.getYDimension();
        int n2 = this.attribute.getXDimension();
        if (n != this.retval.length || n2 != this.retval[0].length) {
            this.retval = new double[n][n2];
        }
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.retval[i][j] = fArray[n3++];
            }
        }
        return this.retval;
    }

    double[][] getNumberImageDisplayValue(DeviceAttribute deviceAttribute) throws DevFailed {
        float[] fArray = deviceAttribute.extractFloatArray();
        double d = this.attribute.getDisplayUnitFactor();
        int n = this.attribute.getYDimension();
        int n2 = this.attribute.getXDimension();
        if (n != this.retval.length || n2 != this.retval[0].length) {
            this.retval = new double[n][n2];
        }
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.retval[i][j] = (double)fArray[n3++] * d;
            }
        }
        return this.retval;
    }

    String[][] getImageValue(DeviceAttribute deviceAttribute) throws DevFailed {
        float[] fArray = deviceAttribute.extractFloatArray();
        int n = this.attribute.getYDimension();
        int n2 = this.attribute.getXDimension();
        String[][] stringArray = new String[n][n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                stringArray[i][j] = Float.toString(fArray[n3++]);
            }
        }
        return stringArray;
    }

    public String getVersion() {
        return "$Id: FloatImageHelper.java,v 1.5 2008/06/13 17:26:58 poncet Exp $";
    }
}

