/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoApi.events.EventDispatcher;
import fr.esrf.TangoApi.events.ITangoChangeListener;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import java.io.Serializable;
import javax.swing.SwingUtilities;

public class TangoChange
extends EventDispatcher
implements Serializable {
    String attr_name;
    int event_identifier;
    String[] filters;

    public TangoChange(DeviceProxy deviceProxy, String string, String[] stringArray) {
        super(deviceProxy);
        this.attr_name = string;
        this.filters = stringArray;
        this.event_identifier = -1;
    }

    public void addTangoChangeListener(ITangoChangeListener iTangoChangeListener, boolean bl) throws DevFailed {
        this.event_listeners.add(ITangoChangeListener.class, iTangoChangeListener);
        this.event_identifier = this.subscribe_change_event(this.attr_name, this.filters, bl);
    }

    public void removeTangoChangeListener(ITangoChangeListener iTangoChangeListener) throws DevFailed {
        this.event_listeners.remove(ITangoChangeListener.class, iTangoChangeListener);
        if (this.event_listeners.getListenerCount() == 0) {
            this.unsubscribe_event(this.event_identifier);
        }
    }

    public void dispatch_event(final EventData eventData) {
        final TangoChange tangoChange = this;
        Runnable runnable = new Runnable(){

            public void run() {
                TangoChangeEvent tangoChangeEvent = new TangoChangeEvent(tangoChange, eventData);
                TangoChange.this.fireTangoChangeEvent(tangoChangeEvent);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void fireTangoChangeEvent(TangoChangeEvent tangoChangeEvent) {
        Object[] objectArray = this.event_listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ITangoChangeListener.class) continue;
            ((ITangoChangeListener)objectArray[i + 1]).change(tangoChangeEvent);
        }
    }
}

