/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttributeDim;
import fr.esrf.Tango.AttributeValue_3;
import fr.esrf.Tango.DevAttrHistory;
import fr.esrf.Tango.DevAttrHistory_3;
import fr.esrf.Tango.DevBooleanHelper;
import fr.esrf.Tango.DevCmdHistory;
import fr.esrf.Tango.DevDoubleHelper;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevFloatHelper;
import fr.esrf.Tango.DevLongHelper;
import fr.esrf.Tango.DevShortHelper;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevStateHelper;
import fr.esrf.Tango.DevStringHelper;
import fr.esrf.Tango.DevULongHelper;
import fr.esrf.Tango.DevUShortHelper;
import fr.esrf.Tango.DevVarBooleanArrayHelper;
import fr.esrf.Tango.DevVarCharArrayHelper;
import fr.esrf.Tango.DevVarDoubleArrayHelper;
import fr.esrf.Tango.DevVarDoubleStringArray;
import fr.esrf.Tango.DevVarDoubleStringArrayHelper;
import fr.esrf.Tango.DevVarFloatArrayHelper;
import fr.esrf.Tango.DevVarLongArrayHelper;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.Tango.DevVarLongStringArrayHelper;
import fr.esrf.Tango.DevVarShortArrayHelper;
import fr.esrf.Tango.DevVarStringArrayHelper;
import fr.esrf.Tango.DevVarULongArrayHelper;
import fr.esrf.Tango.DevVarUShortArrayHelper;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.TangoApi.IDeviceDataHistoryDAO;
import fr.esrf.TangoDs.Except;
import org.omg.CORBA.Any;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;

public class DeviceDataHistoryDAODefaultImpl
implements IDeviceDataHistoryDAO {
    private Any any;
    private DevCmdHistory cmd_histo;
    private AttributeValue_3 attrval;
    private TimeVal tval;

    public void init(DeviceDataHistory deviceDataHistory, String cmdname, DevCmdHistory cmd_hist) throws DevFailed {
        this.any = cmd_hist.value;
        deviceDataHistory.source = 0;
        this.cmd_histo = cmd_hist;
        deviceDataHistory.name = cmdname;
        this.tval = this.cmd_histo.time;
        deviceDataHistory.failed = this.cmd_histo.cmd_failed;
        deviceDataHistory.errors = this.cmd_histo.errors;
    }

    public void init(DeviceDataHistory deviceDataHistory, DevAttrHistory att_histo) throws DevFailed {
        this.any = att_histo.value.value;
        deviceDataHistory.source = 1;
        this.attrval = new AttributeValue_3(this.any, att_histo.value.quality, att_histo.value.time, att_histo.value.name, new AttributeDim(att_histo.value.dim_x, att_histo.value.dim_y), new AttributeDim(0, 0), att_histo.errors);
        deviceDataHistory.name = att_histo.value.name;
        this.tval = att_histo.value.time;
        deviceDataHistory.failed = att_histo.attr_failed;
        deviceDataHistory.errors = att_histo.errors;
    }

    public void init(DeviceDataHistory deviceDataHistory, DevAttrHistory_3 att_histo) throws DevFailed {
        this.any = att_histo.value.value;
        deviceDataHistory.source = 1;
        this.attrval = att_histo.value;
        deviceDataHistory.name = att_histo.value.name;
        this.tval = att_histo.value.time;
        deviceDataHistory.failed = att_histo.attr_failed;
        deviceDataHistory.errors = att_histo.value.err_list;
    }

    public TimeVal getTimeVal(DeviceDataHistory deviceDataHistory) {
        return this.tval;
    }

    public long getTimeValSec(DeviceDataHistory deviceDataHistory) {
        return this.tval.tv_sec;
    }

    public long getTime(DeviceDataHistory deviceDataHistory) {
        return (long)this.tval.tv_sec * 1000L + (long)(this.tval.tv_usec / 1000);
    }

    public AttrQuality getAttrQuality(DeviceDataHistory deviceDataHistory) throws DevFailed {
        if (deviceDataHistory.source == 0) {
            Except.throw_non_supported_exception("TangoApi_NOT_AVAILABLE", "Method not avalaible for command", "DeviceDataHistory.getAttrQuality()");
        }
        return this.attrval.quality;
    }

    public int getDimX(DeviceDataHistory deviceDataHistory) throws DevFailed {
        if (deviceDataHistory.source == 0) {
            Except.throw_non_supported_exception("TangoApi_NOT_AVAILABLE", "Method not avalaible for command", "DeviceDataHistory.getDimX()");
        }
        return this.attrval.r_dim.dim_x;
    }

    public int getDimY(DeviceDataHistory deviceDataHistory) throws DevFailed {
        if (deviceDataHistory.source == 0) {
            Except.throw_non_supported_exception("TangoApi_NOT_AVAILABLE", "Method not avalaible for command", "DeviceDataHistory.getDimY()");
        }
        return this.attrval.r_dim.dim_y;
    }

    public Any extractAny(DeviceDataHistory deviceDataHistory) {
        return this.any;
    }

    public boolean extractBoolean(DeviceDataHistory deviceDataHistory) {
        return DevBooleanHelper.extract(this.any);
    }

    public short extractUChar(DeviceDataHistory deviceDataHistory) throws DevFailed {
        short[] array = this.extractUCharArray(deviceDataHistory);
        return array[0];
    }

    public short extractShort(DeviceDataHistory deviceDataHistory) {
        if (deviceDataHistory.source == 1) {
            short[] array = this.extractShortArray(deviceDataHistory);
            return array[0];
        }
        return DevShortHelper.extract(this.any);
    }

    public short extractUShort(DeviceDataHistory deviceDataHistory) {
        return DevUShortHelper.extract(this.any);
    }

    public int extractLong(DeviceDataHistory deviceDataHistory) {
        if (deviceDataHistory.source == 1) {
            int[] array = this.extractLongArray(deviceDataHistory);
            return array[0];
        }
        return DevLongHelper.extract(this.any);
    }

    public int extractULong(DeviceDataHistory deviceDataHistory) {
        return DevULongHelper.extract(this.any);
    }

    public float extractFloat(DeviceDataHistory deviceDataHistory) {
        return DevFloatHelper.extract(this.any);
    }

    public double extractDouble(DeviceDataHistory deviceDataHistory) {
        if (deviceDataHistory.source == 1) {
            double[] array = this.extractDoubleArray(deviceDataHistory);
            return array[0];
        }
        return DevDoubleHelper.extract(this.any);
    }

    public String extractString(DeviceDataHistory deviceDataHistory) {
        if (deviceDataHistory.source == 1) {
            String[] array = this.extractStringArray(deviceDataHistory);
            return array[0];
        }
        return DevStringHelper.extract(this.any);
    }

    public DevState extractDevState(DeviceDataHistory deviceDataHistory) {
        return DevStateHelper.extract(this.any);
    }

    public boolean[] extractBooleanArray(DeviceDataHistory deviceDataHistory) {
        return DevVarBooleanArrayHelper.extract(this.any);
    }

    public byte[] extractByteArray(DeviceDataHistory deviceDataHistory) {
        return DevVarCharArrayHelper.extract(this.any);
    }

    public short[] extractUCharArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        byte[] argout = DevVarCharArrayHelper.extract(this.attrval.value);
        short[] val = new short[argout.length];
        int mask = 255;
        for (int i = 0; i < argout.length; ++i) {
            val[i] = (short)(mask & argout[i]);
        }
        return val;
    }

    public short[] extractShortArray(DeviceDataHistory deviceDataHistory) {
        return DevVarShortArrayHelper.extract(this.any);
    }

    public short[] extractUShortArray(DeviceDataHistory deviceDataHistory) {
        return DevVarUShortArrayHelper.extract(this.any);
    }

    public int[] extractLongArray(DeviceDataHistory deviceDataHistory) {
        return DevVarLongArrayHelper.extract(this.any);
    }

    public int[] extractULongArray(DeviceDataHistory deviceDataHistory) {
        return DevVarULongArrayHelper.extract(this.any);
    }

    public float[] extractFloatArray(DeviceDataHistory deviceDataHistory) {
        return DevVarFloatArrayHelper.extract(this.any);
    }

    public double[] extractDoubleArray(DeviceDataHistory deviceDataHistory) {
        return DevVarDoubleArrayHelper.extract(this.any);
    }

    public String[] extractStringArray(DeviceDataHistory deviceDataHistory) {
        if (this.any == null) {
            System.out.println("any = null !!");
        }
        return DevVarStringArrayHelper.extract(this.any);
    }

    public DevVarLongStringArray extractLongStringArray(DeviceDataHistory deviceDataHistory) {
        return DevVarLongStringArrayHelper.extract(this.any);
    }

    public DevVarDoubleStringArray extractDoubleStringArray(DeviceDataHistory deviceDataHistory) {
        return DevVarDoubleStringArrayHelper.extract(this.any);
    }

    public DevError[] getErrStack(DeviceDataHistory deviceDataHistory) {
        return this.attrval.err_list;
    }

    public TypeCode type(DeviceDataHistory deviceDataHistory) {
        return this.any.type();
    }

    public String getName(DeviceDataHistory deviceDataHistory) {
        return this.attrval.name;
    }

    private int DIM_MINI(int x) {
        return x == 0 ? 1 : x;
    }

    public int getNbRead(DeviceDataHistory deviceDataHistory) {
        return this.attrval.r_dim.dim_x * this.DIM_MINI(this.attrval.r_dim.dim_y);
    }

    public int getNbWritten(DeviceDataHistory deviceDataHistory) {
        return this.attrval.w_dim.dim_x * this.DIM_MINI(this.attrval.w_dim.dim_y);
    }

    public int getWrittenDimX(DeviceDataHistory deviceDataHistory) {
        return this.attrval.w_dim.dim_x;
    }

    public int getWrittenDimY(DeviceDataHistory deviceDataHistory) {
        return this.attrval.w_dim.dim_y;
    }

    public int getType(DeviceDataHistory deviceDataHistory) throws DevFailed {
        int type = -1;
        try {
            TypeCode tc = this.attrval.value.type();
            if (tc.kind().value() == 17) {
                return 19;
            }
            TypeCode tc_alias = tc.content_type();
            TypeCode tc_seq = tc_alias.content_type();
            TCKind kind = tc_seq.kind();
            switch (kind.value()) {
                case 1: {
                    type = 0;
                    break;
                }
                case 8: {
                    type = 1;
                    break;
                }
                case 9: {
                    type = 21;
                    break;
                }
                case 10: {
                    type = 22;
                    break;
                }
                case 2: {
                    type = 2;
                    break;
                }
                case 4: {
                    type = 6;
                    break;
                }
                case 3: {
                    type = 3;
                    break;
                }
                case 5: {
                    type = 7;
                    break;
                }
                case 6: {
                    type = 4;
                    break;
                }
                case 7: {
                    type = 5;
                    break;
                }
                case 18: {
                    type = 8;
                }
            }
        }
        catch (BadKind e) {
            Except.throw_exception("Api_TypeCodePackage.BadKind", "Bad or unknown type ", "DeviceDataHistory.getType()");
        }
        return type;
    }
}

