/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevExportInfo;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbDevInfo;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.TangoUrl;
import fr.esrf.TangoDs.Except;
import java.io.Serializable;

public class DbDevice
implements Serializable {
    private Database dbase;
    private String devname;

    public DbDevice(String devname) throws DevFailed {
        TangoUrl url = new TangoUrl(devname);
        if (!url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + devname + " do not use database", "DbDevice.DbDevice()");
        }
        this.dbase = ApiUtil.get_db_obj();
        this.devname = new String(devname);
    }

    public DbDevice(String devname, String host, String port) throws DevFailed {
        this.dbase = host == null || port == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(host, port);
        this.devname = new String(devname);
    }

    public DeviceInfo get_info() throws DevFailed {
        return this.dbase.get_device_info(this.devname);
    }

    public DbDevImportInfo import_device() throws DevFailed {
        return this.dbase.import_device(this.devname);
    }

    public void export_device(DbDevExportInfo devinfo) throws DevFailed {
        this.dbase.export_device(devinfo);
    }

    public void unexport_device() throws DevFailed {
        this.dbase.unexport_device(this.devname);
    }

    public void add_device(DbDevInfo devinfo) throws DevFailed {
        this.dbase.add_device(devinfo);
    }

    public void delete_device() throws DevFailed {
        this.dbase.delete_device(this.devname);
    }

    public String get_class() throws DevFailed {
        return this.dbase.get_class_for_device(this.devname);
    }

    public String[] get_class_inheritance() throws DevFailed {
        return this.dbase.get_class_inheritance_for_device(this.devname);
    }

    public void put_alias(String aliasname) throws DevFailed {
        this.dbase.put_device_alias(this.devname, aliasname);
    }

    public String get_alias() throws DevFailed {
        if (this.devname.indexOf("/") < 0) {
            this.devname = ApiUtil.get_db_obj().get_alias_device(this.devname);
        }
        String alias = this.dbase.get_device_alias(this.devname);
        return alias;
    }

    public String[] get_property_list(String wildcard) throws DevFailed {
        return this.dbase.get_device_property_list(this.devname, wildcard);
    }

    public DbDatum[] get_property(String[] propnames) throws DevFailed {
        return this.dbase.get_device_property(this.devname, propnames);
    }

    public DbDatum get_property(String propname) throws DevFailed {
        return this.dbase.get_device_property(this.devname, propname);
    }

    public DbDatum[] get_property(DbDatum[] properties) throws DevFailed {
        return this.dbase.get_device_property(this.devname, properties);
    }

    public void put_property(DbDatum[] properties) throws DevFailed {
        this.dbase.put_device_property(this.devname, properties);
    }

    public void delete_property(String[] propnames) throws DevFailed {
        this.dbase.delete_device_property(this.devname, propnames);
    }

    public void delete_property(String propname) throws DevFailed {
        this.dbase.delete_device_property(this.devname, propname);
    }

    public void delete_property(DbDatum[] properties) throws DevFailed {
        this.dbase.delete_device_property(this.devname, properties);
    }

    public void put_attribute_property(DbAttribute[] attr) throws DevFailed {
        this.dbase.put_device_attribute_property(this.devname, attr);
    }

    public void put_attribute_property(DbAttribute attr) throws DevFailed {
        this.dbase.put_device_attribute_property(this.devname, attr);
    }

    public void delete_attribute_property(String attname, String[] propnames) throws DevFailed {
        this.dbase.delete_device_attribute_property(this.devname, attname, propnames);
    }

    public void delete_attribute_property(String attname, String propname) throws DevFailed {
        this.dbase.delete_device_attribute_property(this.devname, attname, propname);
    }

    public void delete_attribute_property(DbAttribute attr) throws DevFailed {
        this.dbase.delete_device_attribute_property(this.devname, attr);
    }

    public void delete_attribute_property(DbAttribute[] attr) throws DevFailed {
        this.dbase.delete_device_attribute_property(this.devname, attr);
    }

    public String[] get_attribute_list() throws DevFailed {
        return this.dbase.get_device_attribute_list(this.devname);
    }

    public DbAttribute[] get_attribute_property(String[] attnames) throws DevFailed {
        return this.dbase.get_device_attribute_property(this.devname, attnames);
    }

    public DbAttribute get_attribute_property(String attname) throws DevFailed {
        return this.dbase.get_device_attribute_property(this.devname, attname);
    }

    public void delete_attribute(String attname) throws DevFailed {
        this.dbase.delete_device_attribute(this.devname, attname);
    }

    public String name() {
        return this.devname;
    }
}

