/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.IORdump;
import fr.esrf.TangoDs.Except;
import java.io.Serializable;

public class DbDevImportInfo
implements Serializable {
    public String name = null;
    public String ior = null;
    public String version = null;
    public boolean exported;
    public int pid = 0;
    public String server = "unknown";
    public boolean is_taco = false;
    public String taco_info;

    public DbDevImportInfo() {
    }

    public DbDevImportInfo(DevVarLongStringArray info) {
        this.name = new String(info.svalue[0]);
        this.ior = new String(info.svalue[1]);
        this.version = new String(info.svalue[2]);
        boolean bl = this.exported = info.lvalue[0] == 1;
        if (info.lvalue.length > 1) {
            this.pid = info.lvalue[1];
        }
        if (info.svalue.length > 3) {
            this.server = new String(info.svalue[3]);
        }
        this.is_taco = this.ior.startsWith("rpc:");
    }

    public DbDevImportInfo(String[] taco_info) {
        this.is_taco = true;
        if (taco_info.length < 6) {
            this.taco_info = "";
            for (int i = 0; i < taco_info.length; ++i) {
                this.taco_info = this.taco_info + taco_info[i] + "\n";
            }
        } else {
            this.taco_info = "Device:        " + taco_info[0] + "\n" + "type_id:       " + "taco:" + taco_info[2] + "\n" + "host:          " + taco_info[4] + "\n" + "Class:         " + taco_info[1] + "\n" + "Server:        " + taco_info[3] + "\n" + "NETHOST:       " + taco_info[5];
        }
    }

    public String toString() {
        String result;
        if (this.is_taco) {
            result = this.taco_info;
        } else {
            try {
                IORdump id = new IORdump(this.name, this.ior);
                result = id.toString();
                result = result + "\nServer:          " + this.server;
                if (this.pid != 0) {
                    result = result + "\nServer PID:      " + this.pid;
                }
                result = result + "\nExported:        " + this.exported;
            }
            catch (DevFailed e) {
                StringBuffer sb = new StringBuffer(e.toString() + ":\n");
                for (int i = 0; i < e.errors.length; ++i) {
                    sb.append(e.errors[i].reason + " from " + e.errors[i].origin + "\n");
                    sb.append(e.errors[i].desc + "\n");
                    if (i >= e.errors.length - 1) continue;
                    sb.append("-------------------------------------------------------------\n");
                }
                result = sb.toString();
            }
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            String devname = args[0];
            Database db = ApiUtil.get_db_obj();
            DbDevImportInfo info = db.import_device(devname);
            System.out.println(info);
        }
        catch (DevFailed e) {
            if (args.length < 2 || !args[1].equals("-no_exception")) {
                Except.print_exception(e);
            }
            System.exit(1);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Device name ?");
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

