/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevCmdInfo;
import fr.esrf.Tango.DevCmdInfo_2;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevInfo;
import fr.esrf.Tango.DevInfo_3;
import fr.esrf.Tango.DevSource;
import fr.esrf.Tango.Device;
import fr.esrf.Tango.DeviceHelper;
import fr.esrf.Tango.Device_2Helper;
import fr.esrf.Tango.Device_3Helper;
import fr.esrf.TangoApi.ApiDefs;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.Connection;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbRedundancy;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.IConnectionDAO;
import fr.esrf.TangoApi.TacoTangoDevice;
import fr.esrf.TangoApi.TangoUrl;
import fr.esrf.TangoDs.Except;
import org.jacorb.orb.policies.RelativeRoundtripTimeoutPolicy;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.SystemException;

public class ConnectionDAODefaultImpl
implements ApiDefs,
IConnectionDAO {
    public Device get_device(Connection connection) {
        return connection.device;
    }

    private String buildUrlName(Connection connection, String host, String port) {
        return new String("tango://" + host + ":" + port);
    }

    private String buildUrlName(Connection connection, String host, String port, String devname) {
        return new String("tango://" + host + ":" + port + "/" + devname);
    }

    public void init(Connection connection) throws DevFailed {
        connection.url = new TangoUrl();
        connection.setDevice_is_dbase(true);
        connection.transparent_reconnection = true;
        ApiUtil.get_orb();
        this.connect_to_dbase(connection);
        connection.devname = connection.device.name();
        connection.setAlready_connected(true);
    }

    public void init(Connection connection, String host, String port) throws DevFailed {
        connection.url = new TangoUrl(this.buildUrlName(connection, host, port));
        connection.setDevice_is_dbase(true);
        connection.transparent_reconnection = true;
        ApiUtil.get_orb();
        this.connect_to_dbase(connection);
        connection.devname = connection.device.name();
        connection.setAlready_connected(true);
    }

    public void init(Connection connection, String host, String port, boolean auto_reconnect) throws DevFailed {
        connection.url = new TangoUrl(this.buildUrlName(connection, host, port));
        connection.setDevice_is_dbase(true);
        connection.transparent_reconnection = auto_reconnect;
        ApiUtil.get_orb();
        this.connect_to_dbase(connection);
        connection.devname = connection.device.name();
        connection.setAlready_connected(true);
    }

    public void init(Connection connection, String devname) throws DevFailed {
        connection.url = new TangoUrl(devname);
        connection.setDevice_is_dbase(false);
        connection.devname = connection.url.devname;
        if (connection.url.protocol == 0 && connection.url.use_db) {
            connection.ior = this.get_exported_ior(connection);
        }
    }

    public void init(Connection connection, String devname, boolean check_access) throws DevFailed {
        connection.url = new TangoUrl(devname);
        connection.setDevice_is_dbase(false);
        connection.devname = connection.url.devname;
        connection.check_access = check_access;
        if (connection.url.protocol == 0 && connection.url.use_db) {
            connection.ior = this.get_exported_ior(connection);
        }
    }

    public void init(Connection connection, String devname, String param, int src) throws DevFailed {
        connection.devname = devname;
        connection.setDevice_is_dbase(false);
        if (src == 1) {
            connection.ior = param;
            connection.url = new TangoUrl();
            connection.url.protocol = 0;
        } else {
            String reason = "TangoApi_INVALID_ARGS";
            String desc = new String("Invalid argument");
            String origin = new String("Connection.Connemction()");
            Except.throw_wrong_syntax_exception(reason, desc, origin);
        }
    }

    public void init(Connection connection, String devname, String host, String port) throws DevFailed {
        connection.url = new TangoUrl(this.buildUrlName(connection, host, port, devname));
        connection.devname = connection.url.devname;
        connection.setDevice_is_dbase(false);
        if (connection.url.protocol == 0) {
            connection.ior = this.get_exported_ior(connection);
        }
    }

    public synchronized void build_connection(Connection connection) throws DevFailed {
        long t = System.currentTimeMillis();
        long delay = t - connection.getPrev_failed_t0();
        boolean try_reconnection = true;
        if (connection.isDevice_is_dbase()) {
            this.connect_to_dbase(connection);
        } else {
            try {
                if (connection.url.protocol == 0) {
                    if (connection.isPrev_failed() && delay < (long)ApiUtil.getReconnectionDelay()) {
                        try_reconnection = false;
                        throw connection.getPrev_failed();
                    }
                    connection.setPrev_failed_t0(t);
                    if (connection.url.use_db) {
                        this.dev_import(connection);
                    } else {
                        this.dev_import_without_dbase(connection);
                    }
                    connection.setPrev_failed(null);
                } else if (connection.url.protocol == 1 && connection.taco_device == null) {
                    connection.taco_device = new TacoTangoDevice(connection.devname, connection.url.host);
                }
            }
            catch (DevFailed e) {
                if (try_reconnection) {
                    connection.setPrev_failed_t0(t);
                    connection.setPrev_failed(e);
                }
                connection.ior = null;
                String reason = "TangoApi_CANNOT_IMPORT_DEVICE";
                String desc = new String("Cannot import " + connection.devname);
                String origin = new String("Connection.build_connection(" + connection.devname + ")");
                Except.throw_communication_failed(e, reason, desc, origin);
            }
        }
    }

    private void createDevice(Connection connection, String corba_str) throws DevFailed {
        try {
            ORB orb = ApiUtil.get_orb();
            connection.setObj(orb.string_to_object(corba_str));
        }
        catch (RuntimeException e) {
            Except.throw_connection_failed("TangoApi_TANGO_HOST_NOT_VALID", e.toString().substring(e.toString().indexOf(":") + 2), "Connection.createDevice()");
        }
        String strTimeout = System.getProperty("TANGO_TIMEOUT");
        if (strTimeout == null) {
            strTimeout = "3000";
        }
        try {
            connection.setDev_timeout(Integer.parseInt(strTimeout));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.set_obj_timeout(connection, connection.getDev_timeout());
        if (connection.getObj()._is_a("IDL:Tango/Device_3:1.0")) {
            connection.device_3 = Device_3Helper.narrow(connection.getObj());
            connection.device_2 = connection.device_3;
            connection.device = connection.device_3;
            connection.idl_version = 3;
        } else if (connection.getObj()._is_a("IDL:Tango/Device_2:1.0")) {
            connection.device_2 = Device_2Helper.narrow(connection.getObj());
            connection.device = connection.device_2;
            connection.idl_version = 2;
        } else if (connection.getObj()._is_a("IDL:Tango/Device:1.0")) {
            connection.device = DeviceHelper.narrow(connection.getObj());
            connection.idl_version = 1;
        } else {
            Except.throw_non_supported_exception("TangoApi_DEVICE_IDL_UNKNOWN", connection.devname + " has an IDL revision not supported !", "Connection.createDevice(" + connection.devname + ")");
        }
        connection.getObj()._is_a("Dummy");
    }

    public String get_ior(Connection connection) throws DevFailed {
        Database db = connection.url.host == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(connection.url.host, connection.url.strport);
        DbDevImportInfo info = db.import_device(connection.devname);
        return info.ior;
    }

    private String get_exported_ior(Connection connection) throws DevFailed {
        Database db = connection.url.host == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(connection.url.host, connection.url.strport);
        DbDevImportInfo info = db.import_device(connection.devname);
        String result = null;
        if (info.exported) {
            result = info.ior;
        }
        if (info.is_taco) {
            connection.url.protocol = 1;
        } else {
            connection.access = connection.url.use_db && connection.check_access ? ApiUtil.get_db_obj(connection.url.host, connection.url.strport).checkAccessControl(connection.devname) : 1;
        }
        return result;
    }

    public void dev_import(Connection connection) throws DevFailed {
        String local_ior = null;
        Database db = connection.url.host == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(connection.url.host, connection.url.strport);
        if (connection.ior == null) {
            DbDevImportInfo info = db.import_device(connection.devname);
            if (!info.exported) {
                Except.throw_connection_failed("TangoApi_DEVICE_NOT_EXPORTED", connection.devname + " Not Exported !", "Connection(" + connection.devname + ")");
            }
            local_ior = info.ior;
        } else {
            local_ior = connection.ior;
        }
        try {
            this.createDevice(connection, local_ior);
            connection.setAlready_connected(true);
        }
        catch (DevFailed e) {
            connection.device = null;
            connection.ior = null;
            throw e;
        }
        catch (Exception e) {
            connection.device = null;
            connection.ior = null;
            String reason = "TangoApi_CANNOT_IMPORT_DEVICE";
            String s = connection.isAlready_connected() ? "Re-" : "";
            String desc = new String("Cannot " + s + "import " + connection.devname + " :\n\t" + e.toString());
            String origin = new String("Connection.dev_import(" + connection.devname + ")");
            Except.throw_connection_failed(reason, desc, origin);
        }
    }

    private void connect_to_dbase(Connection connection) throws DevFailed {
        if (connection.device == null) {
            try {
                String db_corbaloc = new String("corbaloc:iiop:" + connection.url.host + ":" + connection.url.strport + "/database");
                this.createDevice(connection, db_corbaloc);
            }
            catch (SystemException ex) {
                if (connection.transparent_reconnection) {
                    try {
                        DbRedundancy dbr = DbRedundancy.get_instance();
                        String th2 = dbr.get(connection.url.host + ":" + connection.url.port);
                        String db_corbaloc = new String("corbaloc:iiop:" + th2 + "/database");
                        this.createDevice(connection, db_corbaloc);
                    }
                    catch (SystemException e) {
                        connection.device = null;
                        connection.ior = null;
                        Except.throw_connection_failed("TangoApi_DATABASE_CONNECTION_FAILED", "Connection to database failed  !\n" + e, "connect_to_dbase(" + connection.url.host + "," + connection.url.strport + ")");
                    }
                }
                connection.device = null;
                connection.ior = null;
                Except.throw_connection_failed("TangoApi_DATABASE_CONNECTION_FAILED", "Connection to database failed  !\n" + ex, "connect_to_dbase(" + connection.url.host + "," + connection.url.strport + ")");
            }
        }
    }

    private void dev_import_without_dbase(Connection connection) throws DevFailed {
        if (connection.device == null) {
            try {
                String db_corbaloc = new String("corbaloc:iiop:" + connection.url.host + ":" + connection.url.strport + "/" + connection.devname.toLowerCase());
                this.createDevice(connection, db_corbaloc);
                connection.access = 1;
            }
            catch (SystemException e) {
                connection.device = null;
                connection.ior = null;
                e.printStackTrace();
                Except.throw_connection_failed("TangoApi_DEVICE_CONNECTION_FAILED", "Connection to device without database failed  !\n" + e, "Connection.dev_import_without_dbase(" + connection.url.host + "," + connection.url.strport + ")");
            }
        }
    }

    private void set_obj_timeout(Connection connection, int millis) {
        RelativeRoundtripTimeoutPolicy p = new RelativeRoundtripTimeoutPolicy(10000 * millis);
        connection.getObj()._set_policy_override(new Policy[]{p}, SetOverrideType.ADD_OVERRIDE);
        connection.setDev_timeout(millis);
    }

    public void set_timeout_millis(Connection connection, int millis) throws DevFailed {
        if (connection.device == null && connection.devname != null) {
            this.build_connection(connection);
        }
        if (connection.url.protocol == 1) {
            connection.taco_device.set_rpc_timeout(millis);
            return;
        }
        this.set_obj_timeout(connection, millis);
    }

    public int get_timeout(Connection connection) {
        return connection.getDev_timeout();
    }

    public int get_timeout_millis(Connection connection) throws DevFailed {
        if (connection.device == null && connection.devname != null) {
            this.build_connection(connection);
        }
        if (connection.url.protocol == 1) {
            return connection.taco_device.get_rpc_timeout();
        }
        return connection.getDev_timeout();
    }

    public void throw_dev_failed(Connection connection, Exception e, String command, boolean from_inout_cmd) throws DevFailed {
        String origin;
        if (e instanceof DevFailed) {
            throw (DevFailed)e;
        }
        String string = origin = from_inout_cmd ? new String(connection.devname + ".command_inout(" + command + ")") : new String(connection.devname + "." + command + ")");
        if (e.toString().indexOf("org.omg.CORBA.NO_RESPONSE") >= 0 || e.toString().indexOf("org.omg.CORBA.TIMEOUT") >= 0 || e.toString().indexOf("org.omg.CORBA.IMP_LIMIT") >= 0) {
            String desc = new String("Device (" + connection.devname + ") timed out (>" + connection.getDev_timeout() + " ms)!");
            Except.throw_communication_timeout(new String(e.toString()), desc, origin);
        } else if (e.toString().indexOf("org.omg.CORBA.BAD_INV_ORDER") >= 0) {
            String desc = new String("Lost Connection during command : " + command);
            connection.device = null;
            connection.ior = null;
            Except.throw_connection_failed(new String(e.toString()), desc, origin);
        } else if (e.toString().indexOf("org.omg.CORBA.TRANSIENT") >= 0 || e.toString().indexOf("org.omg.CORBA.UNKNOWN") >= 0 || e.toString().indexOf("org.omg.CORBA.COMM_FAILURE") >= 0 || e.toString().indexOf("org.omg.CORBA.OBJECT_NOT_EXIST") >= 0) {
            String desc = new String("Lost Connection during command : " + command);
            connection.device = null;
            connection.ior = null;
            Except.throw_connection_failed(new String(e.toString()), desc, origin);
        } else if (e.toString().startsWith("java.lang.RuntimeException")) {
            String desc = new String("API has catched a RuntimeException" + command);
            connection.device = null;
            connection.ior = null;
            Except.throw_connection_failed(new String(e.toString()), desc, origin);
        } else {
            System.out.println("API has catched an exception for " + origin + " : \n" + e);
            String desc = new String(e.getMessage());
            e.printStackTrace();
            Except.throw_communication_failed(new String(e.toString()), desc, origin);
        }
    }

    public DeviceData command_inout(Connection connection, String command, DeviceData argin) throws DevFailed {
        Database db;
        Any received = null;
        if (connection.device == null && connection.devname != null) {
            this.build_connection(connection);
        }
        if (connection.url.protocol == 1) {
            return connection.taco_device.command_inout(command, argin);
        }
        if (connection.access == 0 && !(db = ApiUtil.get_db_obj(connection.url.host, connection.url.strport)).isCommandAllowed(connection.devname, command)) {
            if (db.access_devfailed != null) {
                throw db.access_devfailed;
            }
            System.out.println(connection.devname + "." + command + "  -> TangoApi_READ_ONLY_MODE");
            Except.throw_connection_failed("TangoApi_READ_ONLY_MODE", connection.devname + ".command_inout(" + command + ")  is not authorized !", "Connection.command_inout()");
        }
        boolean done = false;
        int retries = connection.transparent_reconnection ? 2 : 1;
        for (int i = 0; i < retries && !done; ++i) {
            try {
                received = connection.device_2 != null ? connection.device_2.command_inout_2(command, argin.extractAny(), connection.dev_src) : connection.device.command_inout(command, argin.extractAny());
                done = true;
                continue;
            }
            catch (DevFailed e) {
                String reason = "TangoApi_CANNOT_EXECUTE_COMMAND";
                String desc = new String("Cannot execute command " + command + " on " + connection.devname);
                String origin = new String("Connection.command_inout()");
                if (e.errors[0].reason.equals("DB_DeviceNotDefined")) {
                    String d = e.errors[0].desc;
                    int idx = d.lastIndexOf("!");
                    if (idx > 0) {
                        d = d.substring(0, idx);
                    }
                    e.errors[0].desc = d = d + "  " + connection.url.host + ":" + connection.url.port + " !";
                }
                Except.throw_connection_failed(e, reason, desc, origin);
                continue;
            }
            catch (Exception e) {
                if (e.toString().indexOf("org.omg.CORBA.TRANSIENT") >= 0 && i == 0) {
                    connection.device = null;
                    connection.ior = null;
                    this.build_connection(connection);
                    if (i != retries - 1) continue;
                    this.throw_dev_failed(connection, e, command, true);
                    continue;
                }
                this.throw_dev_failed(connection, e, command, true);
            }
        }
        return new DeviceData(received);
    }

    public DeviceData command_inout(Connection connection, String command) throws DevFailed {
        DeviceData argin = new DeviceData();
        return this.command_inout(connection, command, argin);
    }

    public long ping(Connection connection) throws DevFailed {
        this.checkIfTango(connection, "ping");
        if (connection.device == null && connection.devname != null) {
            this.build_connection(connection);
        }
        long t0 = System.currentTimeMillis();
        try {
            connection.device.ping();
        }
        catch (DevFailed e) {
            String reason = "TangoApi_CANNOT_PING_DEVICE";
            String desc = new String("Cannot ping " + connection.devname);
            String origin = new String("Connection.ping()");
            Except.throw_connection_failed(e, reason, desc, origin);
        }
        catch (Exception e) {
            this.throw_dev_failed(connection, e, "ping", false);
        }
        long t1 = System.currentTimeMillis();
        return (int)(t1 - t0) * 1000;
    }

    public String[] black_box(Connection connection, int length) throws DevFailed {
        this.checkIfTango(connection, "black_box");
        if (connection.device == null && connection.devname != null) {
            this.build_connection(connection);
        }
        try {
            String[] result = connection.device.black_box(length);
            return result;
        }
        catch (DevFailed e) {
            String reason = "TangoApi_CANNOT_READ_BLACK BOX";
            String desc = new String("Cannot read black box on " + connection.devname);
            String origin = new String("Connection.black_box()");
            Except.throw_connection_failed(e, reason, desc, origin);
        }
        catch (Exception e) {
            this.throw_dev_failed(connection, e, "black_box", false);
        }
        return null;
    }

    public DevInfo_3 info_3(Connection connection) throws DevFailed {
        this.checkIfTango(connection, "info");
        if (connection.device == null && connection.devname != null) {
            this.build_connection(connection);
        }
        try {
            DevInfo_3 info_3;
            if (connection.device_3 != null) {
                info_3 = connection.device_3.info_3();
            } else {
                DevInfo info = connection.device.info();
                info_3 = new DevInfo_3(info.dev_class, info.server_id, info.server_host, info.server_version, info.doc_url, "");
            }
            return info_3;
        }
        catch (DevFailed e) {
            String reason = "TangoApi_CANNOT_READ _DEVICE_INFO";
            String desc = new String("Cannot read device info on " + connection.devname);
            String origin = new String("Connection.info()");
            Except.throw_connection_failed(e, reason, desc, origin);
        }
        catch (Exception e) {
            this.throw_dev_failed(connection, e, "info", false);
        }
        return null;
    }

    public DevInfo info(Connection connection) throws DevFailed {
        this.checkIfTango(connection, "info");
        if (connection.device == null && connection.devname != null) {
            this.build_connection(connection);
        }
        try {
            DevInfo info = connection.device.info();
            return info;
        }
        catch (DevFailed e) {
            String reason = "TangoApi_CANNOT_READ _DEVICE_INFO";
            String desc = new String("Cannot read device info on " + connection.devname);
            String origin = new String("Connection.info()");
            Except.throw_connection_failed(e, reason, desc, origin);
        }
        catch (Exception e) {
            this.throw_dev_failed(connection, e, "info", false);
        }
        return null;
    }

    public CommandInfo[] command_list_query(Connection connection) throws DevFailed {
        if (connection.device == null && connection.devname != null) {
            this.build_connection(connection);
        }
        try {
            CommandInfo[] result;
            if (connection.url.protocol == 1) {
                result = connection.taco_device.commandListQuery();
            } else if (connection.device_2 != null) {
                DevCmdInfo_2[] tmp = connection.device_2.command_list_query_2();
                result = new CommandInfo[tmp.length];
                for (int i = 0; i < tmp.length; ++i) {
                    result[i] = new CommandInfo(tmp[i]);
                }
            } else {
                DevCmdInfo[] tmp = connection.device.command_list_query();
                result = new CommandInfo[tmp.length];
                for (int i = 0; i < tmp.length; ++i) {
                    result[i] = new CommandInfo(tmp[i]);
                }
            }
            return result;
        }
        catch (DevFailed e) {
            String reason = "TangoApi_CANNOT__READ_CMD_LIST";
            String desc = new String("Cannot read command list for " + connection.devname);
            String origin = new String("Connection.command_list_query()");
            Except.throw_connection_failed(e, reason, desc, origin);
        }
        catch (Exception e) {
            this.throw_dev_failed(connection, e, "command_list_query", false);
        }
        return null;
    }

    public int get_idl_version(Connection connection) throws DevFailed {
        if (connection.device == null && connection.devname != null) {
            this.build_connection(connection);
        }
        return connection.idl_version;
    }

    public DevSource get_source(Connection connection) throws DevFailed {
        if (this.is_taco(connection)) {
            if (connection.taco_device == null) {
                connection.taco_device = new TacoTangoDevice(connection.devname, connection.url.host);
            }
            return connection.taco_device.get_source();
        }
        return connection.dev_src;
    }

    public void set_source(Connection connection, DevSource new_src) throws DevFailed {
        if (this.is_taco(connection)) {
            if (connection.taco_device == null) {
                connection.taco_device = new TacoTangoDevice(connection.devname, connection.url.host);
            }
            connection.taco_device.set_source(new_src);
        } else {
            connection.dev_src = new_src;
        }
    }

    public String get_name(Connection connection) {
        return connection.devname;
    }

    public String description(Connection connection) throws DevFailed {
        if (connection.device == null && connection.devname != null) {
            this.build_connection(connection);
        }
        return connection.device.description();
    }

    public String adm_name(Connection connection) throws DevFailed {
        this.checkIfTango(connection, "adm_name");
        if (connection.device == null && connection.devname != null) {
            this.build_connection(connection);
        }
        String name = null;
        try {
            name = connection.device.adm_name();
        }
        catch (Exception e) {
            this.throw_dev_failed(connection, e, "adm_name", false);
        }
        if (!connection.url.use_db) {
            name = "tango://" + connection.url.host + ":" + connection.url.port + "/" + name + "#dbase=no";
        }
        return name;
    }

    public String get_tango_host(Connection connection) throws DevFailed {
        this.checkIfTango(connection, "get_tango_host");
        return new String(connection.url.host + ":" + connection.url.strport);
    }

    public boolean is_taco(Connection connection) {
        return connection.url.protocol == 1;
    }

    public void checkIfTaco(Connection connection, String cmdname) throws DevFailed {
        if (!this.is_taco(connection)) {
            Except.throw_non_supported_exception("TangoApi_NOT_TANGO_CMD", new String(cmdname + " is NOT a TANGO command."), new String(cmdname + "()"));
        }
    }

    public void checkIfTango(Connection connection, String cmdname) throws DevFailed {
        if (this.is_taco(connection)) {
            Except.throw_non_supported_exception("TangoApi_NOT_TACO_CMD", new String(cmdname + " is NOT a TACO command."), new String(cmdname + "()"));
        }
    }

    public boolean get_transparency_reconnection(Connection connection) {
        return connection.transparent_reconnection;
    }

    public void set_transparency_reconnection(Connection connection, boolean val) {
        connection.transparent_reconnection = val;
    }

    public int getAccessControl(Connection connection) {
        return connection.access;
    }

    public void setAccessControl(Connection connection, int access) {
        connection.access = access;
    }

    public boolean isAllowedCommand(Connection connection, String cmd) throws DevFailed {
        return ApiUtil.get_db_obj(connection.url.host, connection.url.strport).isCommandAllowed(connection.devname, cmd);
    }
}

