/*
 * Decompiled with CFR 0.152.
 */
package explorer;

import explorer.Main;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.IScalarAttribute;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.widget.attribute.NumberScalarWheelEditor;
import fr.esrf.tangoatk.widget.util.ButtonBar;
import fr.esrf.tangoatk.widget.util.HelpWindow;
import fr.esrf.tangoatk.widget.util.IApplicable;
import fr.esrf.tangoatk.widget.util.IControlee;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SetDialog
extends JDialog
implements IApplicable {
    ButtonBar bb;
    JTextField value;
    JLabel label;
    IScalarAttribute attribute;
    String helpUrl;
    NumberScalarWheelEditor setter;

    public SetDialog(IScalarAttribute model) {
        this.initComponents(model instanceof INumberScalar);
        this.setModel(model);
    }

    public void apply() {
        if (this.attribute instanceof IStringScalar) {
            try {
                ((IStringScalar)this.attribute).setValue(this.value.getText());
            }
            catch (AttributeSetException e) {
                Main.status(this.getRootPane().getParent(), "Cannot set attribute " + this.attribute.getName(), (Exception)((Object)e));
            }
        }
    }

    public void ok() {
        this.apply();
        this.cancel();
    }

    public void cancel() {
        this.getRootPane().getParent().setVisible(false);
    }

    protected void initComponents(boolean useWheel) {
        this.helpUrl = "/explorer/html/SetDialogHelp.html";
        this.bb = new ButtonBar();
        this.bb.setControlee((IControlee)this);
        this.bb.setHelpUrl(this.getClass().getResource(this.helpUrl));
        if (useWheel) {
            this.setter = new NumberScalarWheelEditor();
        } else {
            this.value = new JTextField();
            this.value.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SetDialog.this.ok();
                }
            });
        }
        this.label = new JLabel("New value: ");
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.5;
        c.insets = new Insets(11, 10, 0, 0);
        this.getContentPane().add((Component)this.label, c);
        c.gridx = 1;
        c.insets = new Insets(10, 0, 0, 10);
        if (useWheel) {
            this.getContentPane().add((Component)this.setter, c);
        } else {
            this.getContentPane().add((Component)this.value, c);
        }
        c.insets = new Insets(0, 0, 0, 0);
        c.gridy = 1;
        c.gridx = 0;
        c.gridwidth = 2;
        this.getContentPane().add((Component)this.bb, c);
        HelpWindow.getInstance().addCategory("Attribute Table", "Set dialog", this.getClass().getResource(this.helpUrl));
    }

    public void setModel(IScalarAttribute attribute) {
        this.setTitle(attribute.getName());
        this.attribute = attribute;
        if (attribute instanceof INumberScalar) {
            INumberScalar scalar = (INumberScalar)attribute;
            this.setter.setModel(scalar);
        } else {
            IStringScalar scalar = (IStringScalar)attribute;
            this.value.setText(scalar.getStringValue());
        }
        this.pack();
    }
}

