/*
 * Decompiled with CFR 0.152.
 */
package explorer;

import explorer.AttributeTable;
import explorer.AttributeTableModel;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.IScalarAttribute;
import fr.esrf.tangoatk.widget.attribute.NumberImageJTableAdapter;
import fr.esrf.tangoatk.widget.attribute.NumberImageViewer;
import fr.esrf.tangoatk.widget.attribute.NumberSpectrumViewer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;

public class AttributePanel
extends JTabbedPane {
    protected AttributeTableModel tableModel;
    protected Map attributes = new HashMap();
    protected JScrollPane scroll;
    protected AttributeTable attributeTable;

    public AttributePanel() {
        this.initBorder();
    }

    public void setTable(AttributeTable table) {
        this.tableModel = (AttributeTableModel)table.getModel();
        this.tableModel.setPanel(this);
        this.attributeTable = table;
        this.scroll = new JScrollPane(table);
        this.add((Component)this.attributeTable, "Attributes");
    }

    public void clear() {
        this.attributes.clear();
        Component[] components = this.getComponents();
        int i = 0;
        while (i < components.length) {
            if (components[i] != this.attributeTable) {
                this.remove(components[i]);
            }
            ++i;
        }
    }

    public void addEntity(IEntity entity) {
        if (entity instanceof IScalarAttribute) {
            return;
        }
        if (entity instanceof INumberSpectrum) {
            this.addAttribute((INumberSpectrum)entity);
            return;
        }
        if (entity instanceof INumberImage) {
            this.addAttribute((INumberImage)entity);
            return;
        }
    }

    public void addAttribute(INumberImage image) {
        if (this.attributes.containsKey(image)) {
            return;
        }
        String alias = image.getAlias();
        if (alias == null) {
            alias = image.getName();
        }
        NumberImageViewer viewer = new NumberImageViewer();
        viewer.setModel(image);
        this.attributes.put(image, viewer);
        this.addTab(alias, new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/icons/numberimage.gif")), (Component)viewer, image.getName());
    }

    public void addAttribute(INumberSpectrum spectrum) {
        if (this.attributes.containsKey(spectrum)) {
            return;
        }
        SpectrumViewer viewer = new SpectrumViewer(spectrum);
        String alias = spectrum.getAlias();
        if (alias == null) {
            alias = spectrum.getName();
        }
        this.attributes.put(spectrum, viewer);
        this.addTab(alias, new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/icons/numberspectrum.gif")), viewer, spectrum.getName());
    }

    public void removeAttribute(IEntity entity) {
        JComponent component = (JComponent)this.attributes.get(entity);
        this.attributes.remove(entity);
        this.remove(component);
    }

    public Dimension getPreferredSize() {
        return new Dimension(0, 0);
    }

    public String getSpectrumGraphSettings(IEntity entity) {
        if (entity instanceof INumberSpectrum && this.attributes.containsKey(entity)) {
            SpectrumViewer v = (SpectrumViewer)this.attributes.get(entity);
            return v.getSpectrumViewer().getSettings();
        }
        return "";
    }

    public String setSpectrumGraphSettings(IEntity entity, String cfg) {
        if (entity instanceof INumberSpectrum && this.attributes.containsKey(entity)) {
            SpectrumViewer v = (SpectrumViewer)this.attributes.get(entity);
            return v.getSpectrumViewer().setSettings(cfg);
        }
        return "";
    }

    private void initBorder() {
        TitledBorder tb;
        Color color = new Color(0, 120, 0);
        Font font = new Font("Arial", 0, 10);
        String title = "Attribute Panel";
        TitledBorder border = tb = BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, color), title, 2, 2, font, color);
        this.setBorder(border);
    }

    class SpectrumViewer
    extends JPanel {
        JTable table;
        NumberSpectrumViewer chart;
        NumberImageJTableAdapter tableAdapter;
        JCheckBox viewTable;
        JScrollPane scroll;

        SpectrumViewer(INumberSpectrum attribute) {
            GridBagConstraints c = new GridBagConstraints();
            this.viewTable = new JCheckBox("View Table");
            this.table = new JTable();
            this.chart = new NumberSpectrumViewer();
            this.tableAdapter = new NumberImageJTableAdapter();
            this.chart.setModel(attribute);
            this.tableAdapter.setViewer(this.table);
            this.tableAdapter.setModel((INumberImage)attribute);
            this.viewTable.addActionListener(new ActionListener(this){
                private final /* synthetic */ SpectrumViewer this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent evt) {
                    this.this$1.scroll.setVisible(this.this$1.viewTable.isSelected());
                }
            });
            Enumeration<TableColumn> columns = this.table.getColumnModel().getColumns();
            while (columns.hasMoreElements()) {
                columns.nextElement().setMinWidth(40);
            }
            Dimension tableDim = new Dimension(attribute.getXDimension() * 60, 17);
            this.table.setPreferredSize(tableDim);
            this.scroll = new JScrollPane();
            this.scroll.setViewportView(this.table);
            Dimension scrollDim = this.scroll.getPreferredSize();
            Dimension newScrollDim = new Dimension((int)scrollDim.getWidth(), 50);
            this.scroll.setPreferredSize(newScrollDim);
            scrollDim = this.scroll.getPreferredSize();
            if (scrollDim.getWidth() <= tableDim.getWidth()) {
                this.table.setAutoResizeMode(0);
            }
            this.scroll.setHorizontalScrollBarPolicy(32);
            this.setLayout(new GridBagLayout());
            c.gridx = 0;
            c.gridy = 0;
            c.fill = 1;
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 0.9;
            this.add((Component)this.chart, c);
            c.fill = 2;
            c.gridy = 1;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.weightx = 0.1;
            c.insets = new Insets(13, 45, 13, 0);
            this.add((Component)this.viewTable, c);
            c.insets = new Insets(0, 0, 0, 25);
            c.gridx = 1;
            c.weightx = 0.9;
            c.weighty = 0.0;
            c.fill = 2;
            this.add((Component)this.scroll, c);
            this.viewTable.setSelected(true);
        }

        public NumberSpectrumViewer getSpectrumViewer() {
            return this.chart;
        }
    }
}

