/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.xjep.function;

import java.util.Stack;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.EvaluatorI;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.CallbackEvaluationI;
import org.nfunk.jep.function.PostfixMathCommand;

public abstract class SumType
extends PostfixMathCommand
implements CallbackEvaluationI {
    protected String name;

    public SumType(String string) {
        this.numberOfParameters = -1;
        this.name = string;
    }

    public SumType() {
        this.numberOfParameters = -1;
    }

    public boolean checkNumberOfParameters(int n) {
        return n == 4 || n == 5;
    }

    public Object evaluate(Node node, EvaluatorI evaluatorI) throws ParseException {
        int n = node.jjtGetNumChildren();
        if (!this.checkNumberOfParameters(n)) {
            throw new ParseException(this.name + ": called with invalid number of parameters: " + n + " it should be either 4 or 5.");
        }
        Node node2 = node.jjtGetChild(1);
        Variable variable = null;
        if (!(node2 instanceof ASTVarNode)) {
            throw new ParseException(this.name + ": second argument should be a variable");
        }
        variable = ((ASTVarNode)node2).getVar();
        Object object = evaluatorI.eval(node.jjtGetChild(2));
        if (!(object instanceof Number)) {
            throw new ParseException(this.name + ": third argument (min) should evaluate to a number it is " + object.toString());
        }
        double d = ((Number)object).doubleValue();
        Object object2 = evaluatorI.eval(node.jjtGetChild(3));
        if (!(object2 instanceof Number)) {
            throw new ParseException(this.name + ": forth argument (max) should evaluate to a number it is " + object.toString());
        }
        double d2 = ((Number)object2).doubleValue();
        if (d > d2) {
            throw new ParseException(this.name + ": min value should be smaller than max value they are " + d + " and " + d2 + ".");
        }
        if (n == 5) {
            Object object3 = evaluatorI.eval(node.jjtGetChild(4));
            if (!(object3 instanceof Number)) {
                throw new ParseException(this.name + ": fifth argument (steps) should evaluate to a number it is " + object.toString());
            }
            double d3 = ((Number)object3).doubleValue();
            return this.evaluate(node.jjtGetChild(0), variable, d, d2, d3, evaluatorI);
        }
        return this.evaluate(node.jjtGetChild(0), variable, d, d2, 1.0, evaluatorI);
    }

    public Object evaluate(Node node, Variable variable, double d, double d2, double d3, EvaluatorI evaluatorI) throws ParseException {
        int n = 0;
        Object[] objectArray = new Object[(int)((d2 - d) / d3) + 1];
        n = 0;
        double d4 = d;
        while (d4 <= d2) {
            variable.setValue(new Double(d4));
            objectArray[n] = evaluatorI.eval(node);
            d4 = d + (double)(++n) * d3;
        }
        Object object = this.evaluate(objectArray);
        return object;
    }

    public abstract Object evaluate(Object[] var1) throws ParseException;

    public void run(Stack stack) throws ParseException {
        throw new ParseException(this.name + ": run method called should not normally happen.");
    }
}

