/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.mrpe;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import org.lsmp.djep.matrixJep.MatrixJep;
import org.lsmp.djep.matrixJep.MatrixOperatorSet;
import org.lsmp.djep.matrixJep.MatrixSpecialEvaluationI;
import org.lsmp.djep.matrixJep.MatrixVariable;
import org.lsmp.djep.matrixJep.MatrixVariableI;
import org.lsmp.djep.matrixJep.nodeTypes.ASTMFunNode;
import org.lsmp.djep.matrixJep.nodeTypes.ASTMVarNode;
import org.lsmp.djep.matrixJep.nodeTypes.MatrixNodeI;
import org.lsmp.djep.mrpe.MRpCommandList;
import org.lsmp.djep.mrpe.MRpRes;
import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.values.MVector;
import org.lsmp.djep.vectorJep.values.Matrix;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.lsmp.djep.vectorJep.values.Scaler;
import org.lsmp.djep.xjep.XOperator;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTStart;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.ParserVisitor;
import org.nfunk.jep.SimpleNode;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.SpecialEvaluationI;

public final class MRpEval
implements ParserVisitor {
    private MatrixOperatorSet opSet;
    static final short CONST = 0;
    static final short VAR = 1;
    static final short ADD = 2;
    static final short SUB = 3;
    static final short MUL = 4;
    static final short DIV = 5;
    static final short MOD = 6;
    static final short POW = 7;
    static final short AND = 8;
    static final short OR = 9;
    static final short NOT = 10;
    static final short LT = 11;
    static final short LE = 12;
    static final short GT = 13;
    static final short GE = 14;
    static final short NE = 15;
    static final short EQ = 16;
    static final short LIST = 17;
    static final short DOT = 18;
    static final short CROSS = 19;
    static final short ASSIGN = 20;
    static final short VLIST = 21;
    static final short MLIST = 22;
    static final short FUN = 23;
    static final short UMINUS = 24;
    private static final short SCALER = 0;
    private static final short V2 = 2;
    private static final short V3 = 3;
    private static final short V4 = 4;
    private static final short Vn = 5;
    private static final short M22 = 6;
    private static final short M23 = 7;
    private static final short M24 = 8;
    private static final short M32 = 9;
    private static final short M33 = 10;
    private static final short M34 = 11;
    private static final short M42 = 12;
    private static final short M43 = 13;
    private static final short M44 = 14;
    private static final short Mnn = 15;
    private static final short Dtens = 16;
    private static final short SIN = 1;
    private static final short COS = 2;
    private static final short TAN = 3;
    private static final short ASIN = 4;
    private static final short ACOS = 5;
    private static final short ATAN = 6;
    private static final short SINH = 7;
    private static final short COSH = 8;
    private static final short TANH = 9;
    private static final short ASINH = 10;
    private static final short ACOSH = 11;
    private static final short ATANH = 12;
    private static final short ABS = 13;
    private static final short EXP = 14;
    private static final short LOG = 15;
    private static final short LN = 16;
    private static final short SQRT = 17;
    private static final short SEC = 18;
    private static final short COSEC = 19;
    private static final short COT = 20;
    private static final Hashtable functionHash = new Hashtable();
    private double[] constVals;
    private ScalerObj scalerRes;
    ScalerStore scalerStore;
    private V2Store v2Store;
    private V3Store v3Store;
    private V4Store v4Store;
    private VnStore vnStore;
    private M22Store m22Store;
    private M23Store m23Store;
    private M24Store m24Store;
    private M32Store m32Store;
    private M33Store m33Store;
    private M34Store m34Store;
    private M42Store m42Store;
    private M43Store m43Store;
    private M44Store m44Store;
    private MnnStore mnnStore;
    private MRpCommandList curCommandList;
    private static double LOG10 = Math.log(10.0);

    public MRpEval(MatrixJep matrixJep) {
        functionHash.put("sin", new Short(1));
        functionHash.put("cos", new Short(2));
        functionHash.put("tan", new Short(3));
        functionHash.put("asin", new Short(4));
        functionHash.put("acos", new Short(5));
        functionHash.put("atan", new Short(6));
        functionHash.put("sinh", new Short(7));
        functionHash.put("cosh", new Short(8));
        functionHash.put("tanh", new Short(9));
        functionHash.put("asinh", new Short(10));
        functionHash.put("acosh", new Short(11));
        functionHash.put("atanh", new Short(12));
        functionHash.put("abs", new Short(13));
        functionHash.put("exp", new Short(14));
        functionHash.put("log", new Short(15));
        functionHash.put("ln", new Short(16));
        functionHash.put("sqrt", new Short(17));
        functionHash.put("sec", new Short(18));
        functionHash.put("cosec", new Short(19));
        functionHash.put("cot", new Short(20));
        this.constVals = new double[0];
        this.scalerRes = new ScalerObj(0.0);
        this.scalerStore = new ScalerStore();
        this.v2Store = new V2Store();
        this.v3Store = new V3Store();
        this.v4Store = new V4Store();
        this.vnStore = new VnStore();
        this.m22Store = new M22Store();
        this.m23Store = new M23Store();
        this.m24Store = new M24Store();
        this.m32Store = new M32Store();
        this.m33Store = new M33Store();
        this.m34Store = new M34Store();
        this.m42Store = new M42Store();
        this.m43Store = new M43Store();
        this.m44Store = new M44Store();
        this.mnnStore = new MnnStore();
        this.opSet = (MatrixOperatorSet)matrixJep.getOperatorSet();
    }

    private MRpEval() {
        functionHash.put("sin", new Short(1));
        functionHash.put("cos", new Short(2));
        functionHash.put("tan", new Short(3));
        functionHash.put("asin", new Short(4));
        functionHash.put("acos", new Short(5));
        functionHash.put("atan", new Short(6));
        functionHash.put("sinh", new Short(7));
        functionHash.put("cosh", new Short(8));
        functionHash.put("tanh", new Short(9));
        functionHash.put("asinh", new Short(10));
        functionHash.put("acosh", new Short(11));
        functionHash.put("atanh", new Short(12));
        functionHash.put("abs", new Short(13));
        functionHash.put("exp", new Short(14));
        functionHash.put("log", new Short(15));
        functionHash.put("ln", new Short(16));
        functionHash.put("sqrt", new Short(17));
        functionHash.put("sec", new Short(18));
        functionHash.put("cosec", new Short(19));
        functionHash.put("cot", new Short(20));
        this.constVals = new double[0];
        this.scalerRes = new ScalerObj(0.0);
        this.scalerStore = new ScalerStore();
        this.v2Store = new V2Store();
        this.v3Store = new V3Store();
        this.v4Store = new V4Store();
        this.vnStore = new VnStore();
        this.m22Store = new M22Store();
        this.m23Store = new M23Store();
        this.m24Store = new M24Store();
        this.m32Store = new M32Store();
        this.m33Store = new M33Store();
        this.m34Store = new M34Store();
        this.m42Store = new M42Store();
        this.m43Store = new M43Store();
        this.m44Store = new M44Store();
        this.mnnStore = new MnnStore();
    }

    public final MRpCommandList compile(MatrixVariableI matrixVariableI, Node node) throws ParseException {
        MRpCommandList mRpCommandList = this.compile(node);
        ObjStore objStore = this.getStoreByDim(matrixVariableI.getDimensions());
        short s = (short)objStore.addVar(matrixVariableI);
        objStore.decStack();
        mRpCommandList.addCommand((short)20, MRpEval.getDimType(matrixVariableI.getDimensions()), s);
        return mRpCommandList;
    }

    public final MRpCommandList compile(Node node) throws ParseException {
        this.curCommandList = new MRpCommandList();
        node.jjtAccept(this, null);
        this.scalerStore.alloc();
        this.v2Store.alloc();
        this.v3Store.alloc();
        this.v4Store.alloc();
        this.vnStore.alloc();
        this.m22Store.alloc();
        this.m23Store.alloc();
        this.m24Store.alloc();
        this.m32Store.alloc();
        this.m33Store.alloc();
        this.m34Store.alloc();
        this.m42Store.alloc();
        this.m43Store.alloc();
        this.m44Store.alloc();
        this.mnnStore.alloc();
        Dimensions dimensions = ((MatrixNodeI)node).getDim();
        this.curCommandList.setFinalType(MRpEval.getDimType(dimensions));
        return this.curCommandList;
    }

    public int getVarRef(Variable variable) throws ParseException {
        Dimensions dimensions = ((MatrixVariableI)((Object)variable)).getDimensions();
        ObjStore objStore = this.getStoreByDim(dimensions);
        int n = objStore.addVar((MatrixVariableI)((Object)variable));
        return n;
    }

    public int getVarRef(MatrixVariableI matrixVariableI) throws ParseException {
        Dimensions dimensions = matrixVariableI.getDimensions();
        ObjStore objStore = this.getStoreByDim(dimensions);
        int n = objStore.addVar(matrixVariableI);
        return n;
    }

    public final void setVarValue(int n, MatrixValueI matrixValueI) throws ParseException {
        ObjStore objStore = this.getStoreByDim(matrixValueI.getDim());
        objStore.setVarValue(n, matrixValueI);
    }

    public final void setVarValue(int n, double d) {
        this.scalerStore.setVarValue(n, d);
    }

    static final Dimensions dimTypeToDimension(int n) {
        switch (n) {
            case 0: {
                return Dimensions.ONE;
            }
            case 2: {
                return Dimensions.TWO;
            }
            case 3: {
                return Dimensions.THREE;
            }
            case 4: {
                return Dimensions.valueOf(4);
            }
            case 6: {
                return Dimensions.valueOf(2, 2);
            }
            case 7: {
                return Dimensions.valueOf(2, 3);
            }
            case 8: {
                return Dimensions.valueOf(2, 4);
            }
            case 9: {
                return Dimensions.valueOf(3, 2);
            }
            case 10: {
                return Dimensions.valueOf(3, 3);
            }
            case 11: {
                return Dimensions.valueOf(3, 4);
            }
            case 12: {
                return Dimensions.valueOf(4, 2);
            }
            case 13: {
                return Dimensions.valueOf(4, 3);
            }
            case 14: {
                return Dimensions.valueOf(4, 4);
            }
        }
        return null;
    }

    private static final short getDimType(Dimensions dimensions) {
        if (dimensions.is0D()) {
            return 0;
        }
        if (dimensions.is1D()) {
            switch (dimensions.getFirstDim()) {
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
            }
            return 5;
        }
        if (dimensions.is2D()) {
            switch (dimensions.getFirstDim()) {
                case 2: {
                    switch (dimensions.getLastDim()) {
                        case 2: {
                            return 6;
                        }
                        case 3: {
                            return 7;
                        }
                        case 4: {
                            return 8;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (dimensions.getLastDim()) {
                        case 2: {
                            return 9;
                        }
                        case 3: {
                            return 10;
                        }
                        case 4: {
                            return 11;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (dimensions.getLastDim()) {
                        case 2: {
                            return 12;
                        }
                        case 3: {
                            return 13;
                        }
                        case 4: {
                            return 14;
                        }
                    }
                }
            }
            return 15;
        }
        return 16;
    }

    private final ObjStore getStoreByDim(Dimensions dimensions) throws ParseException {
        switch (MRpEval.getDimType(dimensions)) {
            case 0: {
                return this.scalerStore;
            }
            case 2: {
                return this.v2Store;
            }
            case 3: {
                return this.v3Store;
            }
            case 4: {
                return this.v4Store;
            }
            case 5: {
                return this.vnStore;
            }
            case 6: {
                return this.m22Store;
            }
            case 7: {
                return this.m23Store;
            }
            case 8: {
                return this.m24Store;
            }
            case 9: {
                return this.m32Store;
            }
            case 10: {
                return this.m33Store;
            }
            case 11: {
                return this.m34Store;
            }
            case 12: {
                return this.m42Store;
            }
            case 13: {
                return this.m43Store;
            }
            case 14: {
                return this.m44Store;
            }
            case 15: {
                return this.mnnStore;
            }
        }
        throw new ParseException("Sorry, can only handle scaler, 2, 3 and 4 dimensional vectors and matrices");
    }

    private final void incByDim(Dimensions dimensions) throws ParseException {
        this.getStoreByDim(dimensions).incStack();
    }

    private final void decByDim(Dimensions dimensions) throws ParseException {
        this.getStoreByDim(dimensions).decStack();
    }

    private final void incheapByDim(Dimensions dimensions) throws ParseException {
        this.getStoreByDim(dimensions).incHeap();
    }

    public final Object visit(ASTStart aSTStart, Object object) throws ParseException {
        throw new ParseException("RpeEval: Start node encountered");
    }

    public final Object visit(SimpleNode simpleNode, Object object) throws ParseException {
        throw new ParseException("RpeEval: Simple node encountered");
    }

    final void addConstant(Object object) throws ParseException {
        if (!(object instanceof Number)) {
            throw new ParseException("RpeEval: only constants of double type allowed");
        }
        double d = ((Number)object).doubleValue();
        this.scalerStore.incStack();
        for (short s = 0; s < this.constVals.length; s = (short)(s + 1)) {
            if (d != this.constVals[s]) continue;
            this.curCommandList.addCommand((short)0, s);
            return;
        }
        double[] dArray = new double[this.constVals.length + 1];
        System.arraycopy(this.constVals, 0, dArray, 0, this.constVals.length);
        dArray[this.constVals.length] = d;
        this.curCommandList.addCommand((short)0, (short)this.constVals.length);
        this.constVals = dArray;
    }

    public final Object visit(ASTConstant aSTConstant, Object object) throws ParseException {
        this.addConstant(aSTConstant.getValue());
        return null;
    }

    public final Object visit(ASTVarNode aSTVarNode, Object object) throws ParseException {
        MatrixVariableI matrixVariableI = (MatrixVariableI)((Object)aSTVarNode.getVar());
        if (matrixVariableI.isConstant()) {
            this.addConstant(matrixVariableI.getMValue());
            return null;
        }
        Dimensions dimensions = matrixVariableI.getDimensions();
        ObjStore objStore = this.getStoreByDim(dimensions);
        short s = (short)objStore.addVar(matrixVariableI);
        objStore.incStack();
        this.curCommandList.addCommand((short)1, MRpEval.getDimType(dimensions), s);
        return null;
    }

    public final Object visit(ASTFunNode aSTFunNode, Object object) throws ParseException {
        ASTMFunNode aSTMFunNode = (ASTMFunNode)aSTFunNode;
        MatrixNodeI matrixNodeI = null;
        MatrixNodeI matrixNodeI2 = null;
        int n = aSTMFunNode.jjtGetNumChildren();
        Dimensions dimensions = aSTMFunNode.getDim();
        Dimensions dimensions2 = null;
        Dimensions dimensions3 = null;
        if (!(aSTMFunNode.getPFMC() instanceof MatrixSpecialEvaluationI) && !(aSTMFunNode.getPFMC() instanceof SpecialEvaluationI)) {
            aSTFunNode.childrenAccept(this, null);
        }
        if (n >= 1) {
            matrixNodeI = (MatrixNodeI)aSTFunNode.jjtGetChild(0);
            dimensions2 = matrixNodeI.getDim();
        }
        if (n >= 2) {
            matrixNodeI2 = (MatrixNodeI)aSTFunNode.jjtGetChild(1);
            dimensions3 = matrixNodeI2.getDim();
        }
        if (aSTMFunNode.isOperator()) {
            XOperator xOperator = (XOperator)aSTMFunNode.getOperator();
            if (xOperator.isBinary() && n != 2) {
                throw new ParseException("RpeEval: binary operator must have two children, but it has " + n);
            }
            if (xOperator.isUnary() && n != 1) {
                throw new ParseException("RpeEval: unary operator must have one child, but it has " + n);
            }
            if (xOperator == this.opSet.getAdd()) {
                if (!dimensions.equals(dimensions2) || !dimensions.equals(dimensions3)) {
                    throw new ParseException("RpeEval: dims for add must be equal");
                }
                this.curCommandList.addCommand((short)2, MRpEval.getDimType(dimensions));
                this.decByDim(dimensions);
                this.incheapByDim(dimensions);
                return null;
            }
            if (xOperator == this.opSet.getSubtract()) {
                if (!dimensions.equals(dimensions2) || !dimensions.equals(dimensions3)) {
                    throw new ParseException("RpeEval: dims for add must be equal");
                }
                this.curCommandList.addCommand((short)3, MRpEval.getDimType(dimensions));
                this.decByDim(dimensions);
                this.incheapByDim(dimensions);
                return null;
            }
            if (xOperator == this.opSet.getUMinus()) {
                this.curCommandList.addCommand((short)24, MRpEval.getDimType(dimensions));
                this.incheapByDim(dimensions);
                return null;
            }
            if (xOperator == this.opSet.getMultiply()) {
                this.decByDim(dimensions3);
                this.decByDim(dimensions2);
                this.incByDim(dimensions);
                this.incheapByDim(dimensions);
                this.curCommandList.addCommand((short)4, MRpEval.getDimType(dimensions2), MRpEval.getDimType(dimensions3));
                return null;
            }
            if (xOperator == this.opSet.getMList()) {
                int n2;
                this.incByDim(dimensions);
                this.incheapByDim(dimensions);
                for (n2 = 0; n2 < dimensions.numEles(); ++n2) {
                    this.scalerStore.decStack();
                }
                n2 = MRpEval.getDimType(dimensions);
                if (n2 == 5) {
                    this.curCommandList.addCommand((short)21, (short)dimensions.getFirstDim());
                } else if (n2 == 15) {
                    this.curCommandList.addCommand((short)22, (short)dimensions.getFirstDim(), (short)dimensions.getLastDim());
                } else {
                    this.curCommandList.addCommand((short)17, MRpEval.getDimType(dimensions));
                }
                return null;
            }
            if (xOperator == this.opSet.getDot()) {
                this.scalerStore.incStack();
                this.decByDim(dimensions3);
                this.decByDim(dimensions2);
                this.curCommandList.addCommand((short)18, MRpEval.getDimType(dimensions2));
                return null;
            }
            if (xOperator == this.opSet.getCross()) {
                if (dimensions2.equals(Dimensions.THREE) && dimensions3.equals(Dimensions.THREE)) {
                    this.v3Store.decStack();
                    this.v3Store.incHeap();
                    this.curCommandList.addCommand((short)19, (short)3);
                    return null;
                }
                if (dimensions2.equals(Dimensions.TWO) && dimensions3.equals(Dimensions.TWO)) {
                    this.scalerStore.incStack();
                    this.decByDim(dimensions2);
                    this.decByDim(dimensions3);
                    this.curCommandList.addCommand((short)19, (short)2);
                    return null;
                }
                throw new ParseException("Bad dimensions for cross product " + dimensions2 + " " + dimensions3);
            }
            if (xOperator == this.opSet.getAssign()) {
                matrixNodeI2.jjtAccept(this, null);
                MatrixVariableI matrixVariableI = (MatrixVariableI)((Object)((ASTMVarNode)aSTFunNode.jjtGetChild(0)).getVar());
                ObjStore objStore = this.getStoreByDim(dimensions);
                short s = (short)objStore.addVar(matrixVariableI);
                objStore.decStack();
                this.curCommandList.addCommand((short)20, MRpEval.getDimType(dimensions), s);
                return null;
            }
            if (xOperator == this.opSet.getEQ()) {
                if (!dimensions2.equals(dimensions3)) {
                    throw new ParseException("Dimensions of operands for equals operator must be the same");
                }
                this.scalerStore.incStack();
                this.decByDim(dimensions2);
                this.decByDim(dimensions3);
                this.curCommandList.addCommand((short)16, MRpEval.getDimType(dimensions2));
                return null;
            }
            if (xOperator == this.opSet.getNE()) {
                if (!dimensions2.equals(dimensions3)) {
                    throw new ParseException("Dimensions of operands for not-equals operator must be the same");
                }
                this.scalerStore.incStack();
                this.decByDim(dimensions2);
                this.decByDim(dimensions3);
                this.curCommandList.addCommand((short)15, MRpEval.getDimType(dimensions2));
                return null;
            }
            if (xOperator == this.opSet.getLT()) {
                if (!dimensions2.is0D() || !dimensions3.is0D()) {
                    throw new ParseException("Dimensions of operands for < operator must both be one");
                }
                this.scalerStore.incStack();
                this.decByDim(dimensions2);
                this.decByDim(dimensions3);
                this.curCommandList.addCommand((short)11, (short)0);
                return null;
            }
            if (xOperator == this.opSet.getGT()) {
                if (!dimensions2.is0D() || !dimensions3.is0D()) {
                    throw new ParseException("Dimensions of operands for > operator must both be one");
                }
                this.scalerStore.incStack();
                this.decByDim(dimensions2);
                this.decByDim(dimensions3);
                this.curCommandList.addCommand((short)13, (short)0);
                return null;
            }
            if (xOperator == this.opSet.getLE()) {
                if (!dimensions2.is0D() || !dimensions3.is0D()) {
                    throw new ParseException("Dimensions of operands for <= operator must both be one");
                }
                this.scalerStore.incStack();
                this.decByDim(dimensions2);
                this.decByDim(dimensions3);
                this.curCommandList.addCommand((short)12, (short)0);
                return null;
            }
            if (xOperator == this.opSet.getGE()) {
                if (!dimensions2.is0D() || !dimensions3.is0D()) {
                    throw new ParseException("Dimensions of operands for >= operator must both be one");
                }
                this.scalerStore.incStack();
                this.decByDim(dimensions2);
                this.decByDim(dimensions3);
                this.curCommandList.addCommand((short)14, (short)0);
                return null;
            }
            if (xOperator == this.opSet.getAnd()) {
                if (!dimensions2.is0D() || !dimensions3.is0D()) {
                    throw new ParseException("Dimensions of operands for && operator must both be one");
                }
                this.scalerStore.incStack();
                this.decByDim(dimensions2);
                this.decByDim(dimensions3);
                this.curCommandList.addCommand((short)8, (short)0);
                return null;
            }
            if (xOperator == this.opSet.getOr()) {
                if (!dimensions2.is0D() || !dimensions3.is0D()) {
                    throw new ParseException("Dimensions of operands for || operator must both be one");
                }
                this.scalerStore.incStack();
                this.decByDim(dimensions2);
                this.decByDim(dimensions3);
                this.curCommandList.addCommand((short)9, (short)0);
                return null;
            }
            if (xOperator == this.opSet.getNot()) {
                if (!dimensions2.is0D()) {
                    throw new ParseException("Dimension of operand for not operator must be one");
                }
                this.scalerStore.incStack();
                this.decByDim(dimensions3);
                this.curCommandList.addCommand((short)10, (short)0);
                return null;
            }
            if (xOperator == this.opSet.getDivide()) {
                if (!dimensions3.is0D()) {
                    throw new ParseException("RHS operands of / operator must be a Scaler");
                }
                this.decByDim(dimensions3);
                this.decByDim(dimensions2);
                this.incByDim(dimensions);
                this.incheapByDim(dimensions);
                this.curCommandList.addCommand((short)5, MRpEval.getDimType(dimensions2), MRpEval.getDimType(dimensions3));
                return null;
            }
            if (xOperator == this.opSet.getMod()) {
                if (!dimensions2.is0D() || !dimensions3.is0D()) {
                    throw new ParseException("Dimensions of operands for || operator must both be one");
                }
                this.scalerStore.incStack();
                this.decByDim(dimensions2);
                this.decByDim(dimensions3);
                this.curCommandList.addCommand((short)6, (short)0);
                return null;
            }
            if (xOperator == this.opSet.getPower()) {
                if (!dimensions2.is0D() || !dimensions3.is0D()) {
                    throw new ParseException("Dimensions of operands for || operator must both be one");
                }
                this.scalerStore.incStack();
                this.decByDim(dimensions2);
                this.decByDim(dimensions3);
                this.curCommandList.addCommand((short)7, (short)0);
                return null;
            }
            throw new ParseException("RpeEval: Sorry unsupported operator/function: " + aSTMFunNode.getName());
        }
        Short s = (Short)functionHash.get(aSTMFunNode.getName());
        if (s == null) {
            throw new ParseException("RpeEval: Sorry unsupported operator/function: " + aSTMFunNode.getName());
        }
        if (aSTMFunNode.getPFMC().getNumberOfParameters() == 1 && n == 1) {
            this.scalerStore.incStack();
            this.decByDim(dimensions2);
            this.curCommandList.addCommand((short)23, s);
            return null;
        }
        throw new ParseException("RpeEval: Sorry unsupported operator/function: " + aSTMFunNode.getName());
    }

    public final MRpRes evaluate(MRpCommandList mRpCommandList) {
        this.scalerStore.reset();
        this.v2Store.reset();
        this.v3Store.reset();
        this.v4Store.reset();
        this.vnStore.reset();
        this.m22Store.reset();
        this.m23Store.reset();
        this.m24Store.reset();
        this.m32Store.reset();
        this.m33Store.reset();
        this.m34Store.reset();
        this.m42Store.reset();
        this.m43Store.reset();
        this.m44Store.reset();
        this.mnnStore.reset();
        int n = mRpCommandList.getNumCommands();
        block350: for (int n2 = 0; n2 < n; n2 = (int)((short)(n2 + 1))) {
            MRpCommandList.MRpCommand mRpCommand = mRpCommandList.commands[n2];
            short s = mRpCommand.aux1;
            short s2 = mRpCommand.aux2;
            block0 : switch (mRpCommand.command) {
                case 0: {
                    this.scalerStore.stack[this.scalerStore.sp++] = this.constVals[s];
                    continue block350;
                }
                case 1: {
                    switch (s) {
                        case 0: {
                            this.scalerStore.stack[this.scalerStore.sp++] = this.scalerStore.vars[s2];
                            break;
                        }
                        case 2: {
                            this.v2Store.stack[this.v2Store.sp++] = this.v2Store.vars[s2];
                            break;
                        }
                        case 3: {
                            this.v3Store.stack[this.v3Store.sp++] = this.v3Store.vars[s2];
                            break;
                        }
                        case 4: {
                            this.v4Store.stack[this.v4Store.sp++] = this.v4Store.vars[s2];
                            break;
                        }
                        case 5: {
                            this.vnStore.stack[this.vnStore.sp++] = this.vnStore.vars[s2];
                            break;
                        }
                        case 6: {
                            this.m22Store.stack[this.m22Store.sp++] = this.m22Store.vars[s2];
                            break;
                        }
                        case 7: {
                            this.m23Store.stack[this.m23Store.sp++] = this.m23Store.vars[s2];
                            break;
                        }
                        case 8: {
                            this.m24Store.stack[this.m24Store.sp++] = this.m24Store.vars[s2];
                            break;
                        }
                        case 9: {
                            this.m32Store.stack[this.m32Store.sp++] = this.m32Store.vars[s2];
                            break;
                        }
                        case 10: {
                            this.m33Store.stack[this.m33Store.sp++] = this.m33Store.vars[s2];
                            break;
                        }
                        case 11: {
                            this.m34Store.stack[this.m34Store.sp++] = this.m34Store.vars[s2];
                            break;
                        }
                        case 12: {
                            this.m42Store.stack[this.m42Store.sp++] = this.m42Store.vars[s2];
                            break;
                        }
                        case 13: {
                            this.m43Store.stack[this.m43Store.sp++] = this.m43Store.vars[s2];
                            break;
                        }
                        case 14: {
                            this.m44Store.stack[this.m44Store.sp++] = this.m44Store.vars[s2];
                            break;
                        }
                        case 15: {
                            this.mnnStore.stack[this.mnnStore.sp++] = this.mnnStore.vars[s2];
                        }
                    }
                    continue block350;
                }
                case 2: {
                    switch (s) {
                        case 0: {
                            this.scalerStore.add();
                            break;
                        }
                        case 2: {
                            this.v2Store.add();
                            break;
                        }
                        case 3: {
                            this.v3Store.add();
                            break;
                        }
                        case 4: {
                            this.v4Store.add();
                            break;
                        }
                        case 5: {
                            this.vnStore.add();
                            break;
                        }
                        case 6: {
                            this.m22Store.add();
                            break;
                        }
                        case 7: {
                            this.m23Store.add();
                            break;
                        }
                        case 8: {
                            this.m24Store.add();
                            break;
                        }
                        case 9: {
                            this.m32Store.add();
                            break;
                        }
                        case 10: {
                            this.m33Store.add();
                            break;
                        }
                        case 11: {
                            this.m34Store.add();
                            break;
                        }
                        case 12: {
                            this.m42Store.add();
                            break;
                        }
                        case 13: {
                            this.m43Store.add();
                            break;
                        }
                        case 14: {
                            this.m44Store.add();
                            break;
                        }
                        case 15: {
                            this.mnnStore.add();
                        }
                    }
                    continue block350;
                }
                case 3: {
                    switch (s) {
                        case 0: {
                            this.scalerStore.sub();
                            break;
                        }
                        case 2: {
                            this.v2Store.sub();
                            break;
                        }
                        case 3: {
                            this.v3Store.sub();
                            break;
                        }
                        case 4: {
                            this.v4Store.sub();
                            break;
                        }
                        case 5: {
                            this.vnStore.sub();
                            break;
                        }
                        case 6: {
                            this.m22Store.sub();
                            break;
                        }
                        case 7: {
                            this.m23Store.sub();
                            break;
                        }
                        case 8: {
                            this.m24Store.sub();
                            break;
                        }
                        case 9: {
                            this.m32Store.sub();
                            break;
                        }
                        case 10: {
                            this.m33Store.sub();
                            break;
                        }
                        case 11: {
                            this.m34Store.sub();
                            break;
                        }
                        case 12: {
                            this.m42Store.sub();
                            break;
                        }
                        case 13: {
                            this.m43Store.sub();
                            break;
                        }
                        case 14: {
                            this.m44Store.sub();
                            break;
                        }
                        case 15: {
                            this.mnnStore.sub();
                        }
                    }
                    continue block350;
                }
                case 4: {
                    block78 : switch (s) {
                        case 0: {
                            switch (s2) {
                                case 0: {
                                    this.scalerStore.mulS();
                                    break;
                                }
                                case 2: {
                                    this.v2Store.mulS();
                                    break;
                                }
                                case 3: {
                                    this.v3Store.mulS();
                                    break;
                                }
                                case 4: {
                                    this.v4Store.mulS();
                                    break;
                                }
                                case 5: {
                                    this.vnStore.mulS();
                                    break;
                                }
                                case 6: {
                                    this.m22Store.mulS();
                                    break;
                                }
                                case 7: {
                                    this.m23Store.mulS();
                                    break;
                                }
                                case 8: {
                                    this.m24Store.mulS();
                                    break;
                                }
                                case 9: {
                                    this.m32Store.mulS();
                                    break;
                                }
                                case 10: {
                                    this.m33Store.mulS();
                                    break;
                                }
                                case 11: {
                                    this.m34Store.mulS();
                                    break;
                                }
                                case 12: {
                                    this.m42Store.mulS();
                                    break;
                                }
                                case 13: {
                                    this.m43Store.mulS();
                                    break;
                                }
                                case 14: {
                                    this.m44Store.mulS();
                                    break;
                                }
                                case 15: {
                                    this.mnnStore.mulS();
                                }
                            }
                            break;
                        }
                        case 2: {
                            switch (s2) {
                                case 0: {
                                    this.v2Store.mulS();
                                    break;
                                }
                                case 2: {
                                    this.v2Store.mulV2();
                                    break;
                                }
                                case 6: {
                                    this.mulV2M22();
                                    break;
                                }
                                case 7: {
                                    this.mulV2M23();
                                    break;
                                }
                                case 8: {
                                    this.mulV2M24();
                                    break;
                                }
                                case 15: {
                                    this.mulVnMnn(this.v2Store.stack[--this.v2Store.sp], this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 3: {
                            switch (s2) {
                                case 0: {
                                    this.v3Store.mulS();
                                    break;
                                }
                                case 9: {
                                    this.mulV3M32();
                                    break;
                                }
                                case 10: {
                                    this.mulV3M33();
                                    break;
                                }
                                case 11: {
                                    this.mulV3M34();
                                    break;
                                }
                                case 15: {
                                    this.mulVnMnn(this.v3Store.stack[--this.v3Store.sp], this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 4: {
                            switch (s2) {
                                case 0: {
                                    this.v4Store.mulS();
                                    break;
                                }
                                case 12: {
                                    this.mulV4M42();
                                    break;
                                }
                                case 13: {
                                    this.mulV4M43();
                                    break;
                                }
                                case 14: {
                                    this.mulV4M44();
                                    break;
                                }
                                case 15: {
                                    this.mulVnMnn(this.v4Store.stack[--this.v4Store.sp], this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 5: {
                            switch (s2) {
                                case 0: {
                                    this.mnnStore.mulS();
                                    break;
                                }
                                case 15: {
                                    this.mulVnMnn(this.vnStore.stack[--this.vnStore.sp], this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 6: {
                            switch (s2) {
                                case 0: {
                                    this.m22Store.mulS();
                                    break;
                                }
                                case 2: {
                                    this.mulM22V2();
                                    break;
                                }
                                case 6: {
                                    this.mulM22M22();
                                    break;
                                }
                                case 7: {
                                    this.mulM22M23();
                                    break;
                                }
                                case 8: {
                                    this.mulM22M24();
                                    break;
                                }
                                case 15: {
                                    this.mulMnnMnn(this.m22Store.stack[--this.m22Store.sp], this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 7: {
                            switch (s2) {
                                case 0: {
                                    this.m23Store.mulS();
                                    break;
                                }
                                case 3: {
                                    this.mulM23V3();
                                    break;
                                }
                                case 9: {
                                    this.mulM23M32();
                                    break;
                                }
                                case 10: {
                                    this.mulM23M33();
                                    break;
                                }
                                case 11: {
                                    this.mulM23M34();
                                    break;
                                }
                                case 15: {
                                    this.mulMnnMnn(this.m23Store.stack[--this.m23Store.sp], this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 8: {
                            switch (s2) {
                                case 0: {
                                    this.m24Store.mulS();
                                    break;
                                }
                                case 4: {
                                    this.mulM24V4();
                                    break;
                                }
                                case 12: {
                                    this.mulM24M42();
                                    break;
                                }
                                case 13: {
                                    this.mulM24M43();
                                    break;
                                }
                                case 14: {
                                    this.mulM24M44();
                                    break;
                                }
                                case 15: {
                                    this.mulMnnMnn(this.m24Store.stack[--this.m24Store.sp], this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 9: {
                            switch (s2) {
                                case 0: {
                                    this.m32Store.mulS();
                                    break;
                                }
                                case 2: {
                                    this.mulM32V2();
                                    break;
                                }
                                case 6: {
                                    this.mulM32M22();
                                    break;
                                }
                                case 7: {
                                    this.mulM32M23();
                                    break;
                                }
                                case 8: {
                                    this.mulM32M24();
                                    break;
                                }
                                case 15: {
                                    this.mulMnnMnn(this.m32Store.stack[--this.m32Store.sp], this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 10: {
                            switch (s2) {
                                case 0: {
                                    this.m33Store.mulS();
                                    break;
                                }
                                case 3: {
                                    this.mulM33V3();
                                    break;
                                }
                                case 9: {
                                    this.mulM33M32();
                                    break;
                                }
                                case 10: {
                                    this.mulM33M33();
                                    break;
                                }
                                case 11: {
                                    this.mulM33M34();
                                    break;
                                }
                                case 15: {
                                    this.mulMnnMnn(this.m33Store.stack[--this.m33Store.sp], this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 11: {
                            switch (s2) {
                                case 0: {
                                    this.m34Store.mulS();
                                    break;
                                }
                                case 4: {
                                    this.mulM34V4();
                                    break;
                                }
                                case 12: {
                                    this.mulM34M42();
                                    break;
                                }
                                case 13: {
                                    this.mulM34M43();
                                    break;
                                }
                                case 14: {
                                    this.mulM34M44();
                                    break;
                                }
                                case 15: {
                                    this.mulMnnMnn(this.m34Store.stack[--this.m34Store.sp], this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 12: {
                            switch (s2) {
                                case 0: {
                                    this.m42Store.mulS();
                                    break;
                                }
                                case 2: {
                                    this.mulM42V2();
                                    break;
                                }
                                case 6: {
                                    this.mulM42M22();
                                    break;
                                }
                                case 7: {
                                    this.mulM42M23();
                                    break;
                                }
                                case 8: {
                                    this.mulM42M24();
                                    break;
                                }
                                case 15: {
                                    this.mulMnnMnn(this.m42Store.stack[--this.m42Store.sp], this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 13: {
                            switch (s2) {
                                case 0: {
                                    this.m43Store.mulS();
                                    break;
                                }
                                case 3: {
                                    this.mulM43V3();
                                    break;
                                }
                                case 9: {
                                    this.mulM43M32();
                                    break;
                                }
                                case 10: {
                                    this.mulM43M33();
                                    break;
                                }
                                case 11: {
                                    this.mulM43M34();
                                    break;
                                }
                                case 15: {
                                    this.mulMnnMnn(this.m43Store.stack[--this.m43Store.sp], this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 14: {
                            switch (s2) {
                                case 0: {
                                    this.m44Store.mulS();
                                    break;
                                }
                                case 4: {
                                    this.mulM44V4();
                                    break;
                                }
                                case 12: {
                                    this.mulM44M42();
                                    break;
                                }
                                case 13: {
                                    this.mulM44M43();
                                    break;
                                }
                                case 14: {
                                    this.mulM44M44();
                                    break;
                                }
                                case 15: {
                                    this.mulMnnMnn(this.m44Store.stack[--this.m44Store.sp], this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 15: {
                            switch (s2) {
                                case 0: {
                                    this.mnnStore.mulS();
                                    break block78;
                                }
                                case 2: {
                                    this.mulMnnVn(this.mnnStore.stack[--this.mnnStore.sp], this.v2Store.stack[--this.v2Store.sp]);
                                    break block78;
                                }
                                case 3: {
                                    this.mulMnnVn(this.mnnStore.stack[--this.mnnStore.sp], this.v3Store.stack[--this.v3Store.sp]);
                                    break block78;
                                }
                                case 4: {
                                    this.mulMnnVn(this.mnnStore.stack[--this.mnnStore.sp], this.v4Store.stack[--this.v4Store.sp]);
                                    break block78;
                                }
                                case 5: {
                                    this.mulMnnVn(this.mnnStore.stack[--this.mnnStore.sp], this.vnStore.stack[--this.vnStore.sp]);
                                    break block78;
                                }
                                case 6: {
                                    this.mulMnnMnn(this.mnnStore.stack[--this.mnnStore.sp], this.m22Store.stack[--this.m22Store.sp]);
                                    break block78;
                                }
                                case 7: {
                                    this.mulMnnMnn(this.mnnStore.stack[--this.mnnStore.sp], this.m23Store.stack[--this.m23Store.sp]);
                                    break block78;
                                }
                                case 8: {
                                    this.mulMnnMnn(this.mnnStore.stack[--this.mnnStore.sp], this.m24Store.stack[--this.m24Store.sp]);
                                    break block78;
                                }
                                case 9: {
                                    this.mulMnnMnn(this.mnnStore.stack[--this.mnnStore.sp], this.m32Store.stack[--this.m32Store.sp]);
                                    break block78;
                                }
                                case 10: {
                                    this.mulMnnMnn(this.mnnStore.stack[--this.mnnStore.sp], this.m33Store.stack[--this.m33Store.sp]);
                                    break block78;
                                }
                                case 11: {
                                    this.mulMnnMnn(this.mnnStore.stack[--this.mnnStore.sp], this.m34Store.stack[--this.m34Store.sp]);
                                    break block78;
                                }
                                case 12: {
                                    this.mulMnnMnn(this.mnnStore.stack[--this.mnnStore.sp], this.m42Store.stack[--this.m42Store.sp]);
                                    break block78;
                                }
                                case 13: {
                                    this.mulMnnMnn(this.mnnStore.stack[--this.mnnStore.sp], this.m43Store.stack[--this.m43Store.sp]);
                                    break block78;
                                }
                                case 14: {
                                    this.mulMnnMnn(this.mnnStore.stack[--this.mnnStore.sp], this.m44Store.stack[--this.m44Store.sp]);
                                    break block78;
                                }
                                case 15: {
                                    MnnObj mnnObj = this.mnnStore.stack[--this.mnnStore.sp];
                                    MnnObj mnnObj2 = this.mnnStore.stack[--this.mnnStore.sp];
                                    this.mulMnnMnn(mnnObj2, mnnObj);
                                }
                            }
                        }
                    }
                    continue block350;
                }
                case 5: {
                    switch (s) {
                        case 0: {
                            this.scalerStore.divS();
                            break;
                        }
                        case 2: {
                            this.v2Store.divS();
                            break;
                        }
                        case 3: {
                            this.v3Store.divS();
                            break;
                        }
                        case 4: {
                            this.v4Store.divS();
                            break;
                        }
                        case 5: {
                            this.vnStore.divS();
                            break;
                        }
                        case 6: {
                            this.m22Store.divS();
                            break;
                        }
                        case 7: {
                            this.m23Store.divS();
                            break;
                        }
                        case 8: {
                            this.m24Store.divS();
                            break;
                        }
                        case 9: {
                            this.m32Store.divS();
                            break;
                        }
                        case 10: {
                            this.m33Store.divS();
                            break;
                        }
                        case 11: {
                            this.m34Store.divS();
                            break;
                        }
                        case 12: {
                            this.m42Store.divS();
                            break;
                        }
                        case 13: {
                            this.m43Store.divS();
                            break;
                        }
                        case 14: {
                            this.m44Store.divS();
                            break;
                        }
                        case 15: {
                            this.mnnStore.divS();
                        }
                    }
                    continue block350;
                }
                case 6: {
                    this.scalerStore.mod();
                    continue block350;
                }
                case 7: {
                    this.scalerStore.pow();
                    continue block350;
                }
                case 8: {
                    this.scalerStore.and();
                    continue block350;
                }
                case 9: {
                    this.scalerStore.or();
                    continue block350;
                }
                case 10: {
                    this.scalerStore.not();
                    continue block350;
                }
                case 11: {
                    this.scalerStore.lt();
                    continue block350;
                }
                case 12: {
                    this.scalerStore.le();
                    continue block350;
                }
                case 13: {
                    this.scalerStore.gt();
                    continue block350;
                }
                case 14: {
                    this.scalerStore.ge();
                    continue block350;
                }
                case 15: {
                    switch (s) {
                        case 0: {
                            this.scalerStore.neq();
                            break;
                        }
                        case 2: {
                            this.v2Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 3: {
                            this.v3Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 4: {
                            this.v4Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 6: {
                            this.m22Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 7: {
                            this.m23Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 8: {
                            this.m24Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 9: {
                            this.m32Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 10: {
                            this.m33Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 11: {
                            this.m34Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 12: {
                            this.m42Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 13: {
                            this.m43Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 14: {
                            this.m44Store.eq();
                            this.scalerStore.not();
                        }
                    }
                    continue block350;
                }
                case 16: {
                    switch (s) {
                        case 0: {
                            this.scalerStore.eq();
                            break;
                        }
                        case 2: {
                            this.v2Store.eq();
                            break;
                        }
                        case 3: {
                            this.v3Store.eq();
                            break;
                        }
                        case 4: {
                            this.v4Store.eq();
                            break;
                        }
                        case 6: {
                            this.m22Store.eq();
                            break;
                        }
                        case 7: {
                            this.m23Store.eq();
                            break;
                        }
                        case 8: {
                            this.m24Store.eq();
                            break;
                        }
                        case 9: {
                            this.m32Store.eq();
                            break;
                        }
                        case 10: {
                            this.m33Store.eq();
                            break;
                        }
                        case 11: {
                            this.m34Store.eq();
                            break;
                        }
                        case 12: {
                            this.m42Store.eq();
                            break;
                        }
                        case 13: {
                            this.m43Store.eq();
                            break;
                        }
                        case 14: {
                            this.m44Store.eq();
                        }
                    }
                    continue block350;
                }
                case 20: {
                    switch (s) {
                        case 0: {
                            this.scalerStore.assign(s2);
                            break;
                        }
                        case 2: {
                            this.v2Store.assign(s2);
                            break;
                        }
                        case 3: {
                            this.v3Store.assign(s2);
                            break;
                        }
                        case 4: {
                            this.v4Store.assign(s2);
                            break;
                        }
                        case 5: {
                            this.vnStore.assign(s2);
                            break;
                        }
                        case 6: {
                            this.m22Store.assign(s2);
                            break;
                        }
                        case 7: {
                            this.m23Store.assign(s2);
                            break;
                        }
                        case 8: {
                            this.m24Store.assign(s2);
                            break;
                        }
                        case 9: {
                            this.m32Store.assign(s2);
                            break;
                        }
                        case 10: {
                            this.m33Store.assign(s2);
                            break;
                        }
                        case 11: {
                            this.m34Store.assign(s2);
                            break;
                        }
                        case 12: {
                            this.m42Store.assign(s2);
                            break;
                        }
                        case 13: {
                            this.m43Store.assign(s2);
                            break;
                        }
                        case 14: {
                            this.m44Store.assign(s2);
                            break;
                        }
                        case 15: {
                            this.mnnStore.assign(s2);
                        }
                    }
                    continue block350;
                }
                case 17: {
                    switch (s) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            this.v2Store.makeList();
                            break;
                        }
                        case 3: {
                            this.v3Store.makeList();
                            break;
                        }
                        case 4: {
                            this.v4Store.makeList();
                            break;
                        }
                        case 6: {
                            this.m22Store.makeList();
                            break;
                        }
                        case 7: {
                            this.m23Store.makeList();
                            break;
                        }
                        case 8: {
                            this.m24Store.makeList();
                            break;
                        }
                        case 9: {
                            this.m32Store.makeList();
                            break;
                        }
                        case 10: {
                            this.m33Store.makeList();
                            break;
                        }
                        case 11: {
                            this.m34Store.makeList();
                            break;
                        }
                        case 12: {
                            this.m42Store.makeList();
                            break;
                        }
                        case 13: {
                            this.m43Store.makeList();
                            break;
                        }
                        case 14: {
                            this.m44Store.makeList();
                        }
                    }
                    continue block350;
                }
                case 21: {
                    this.vnStore.makeList(s);
                    continue block350;
                }
                case 22: {
                    this.mnnStore.makeList(s, s2);
                    continue block350;
                }
                case 18: {
                    switch (s) {
                        case 2: {
                            this.dotV2();
                            break;
                        }
                        case 3: {
                            this.dotV3();
                            break;
                        }
                        case 4: {
                            this.dotV4();
                            break;
                        }
                        case 5: {
                            this.dotVn();
                        }
                    }
                    continue block350;
                }
                case 19: {
                    switch (s) {
                        case 2: {
                            this.crossV2();
                            break;
                        }
                        case 3: {
                            this.crossV3();
                        }
                    }
                    continue block350;
                }
                case 23: {
                    this.unitaryFunction(s);
                    continue block350;
                }
                case 24: {
                    switch (s) {
                        case 0: {
                            this.scalerStore.uminus();
                            break block0;
                        }
                        case 2: {
                            this.v2Store.uminus();
                            break block0;
                        }
                        case 3: {
                            this.v3Store.uminus();
                            break block0;
                        }
                        case 4: {
                            this.v4Store.uminus();
                            break block0;
                        }
                        case 5: {
                            this.vnStore.uminus();
                            break block0;
                        }
                        case 6: {
                            this.m22Store.uminus();
                            break block0;
                        }
                        case 7: {
                            this.m23Store.uminus();
                            break block0;
                        }
                        case 8: {
                            this.m24Store.uminus();
                            break block0;
                        }
                        case 9: {
                            this.m32Store.uminus();
                            break block0;
                        }
                        case 10: {
                            this.m33Store.uminus();
                            break block0;
                        }
                        case 11: {
                            this.m34Store.uminus();
                            break block0;
                        }
                        case 12: {
                            this.m42Store.uminus();
                            break block0;
                        }
                        case 13: {
                            this.m43Store.uminus();
                            break block0;
                        }
                        case 14: {
                            this.m44Store.uminus();
                            break block0;
                        }
                        case 15: {
                            this.mnnStore.uminus();
                        }
                    }
                }
            }
        }
        switch (mRpCommandList.getFinalType()) {
            case 0: {
                this.scalerRes.a = this.scalerStore.stack[--this.scalerStore.sp];
                return this.scalerRes;
            }
            case 2: {
                return this.v2Store.stack[--this.v2Store.sp];
            }
            case 3: {
                return this.v3Store.stack[--this.v3Store.sp];
            }
            case 4: {
                return this.v4Store.stack[--this.v4Store.sp];
            }
            case 5: {
                return this.vnStore.stack[--this.vnStore.sp];
            }
            case 6: {
                return this.m22Store.stack[--this.m22Store.sp];
            }
            case 7: {
                return this.m23Store.stack[--this.m23Store.sp];
            }
            case 8: {
                return this.m24Store.stack[--this.m24Store.sp];
            }
            case 9: {
                return this.m32Store.stack[--this.m32Store.sp];
            }
            case 10: {
                return this.m33Store.stack[--this.m33Store.sp];
            }
            case 11: {
                return this.m34Store.stack[--this.m34Store.sp];
            }
            case 12: {
                return this.m42Store.stack[--this.m42Store.sp];
            }
            case 13: {
                return this.m43Store.stack[--this.m43Store.sp];
            }
            case 14: {
                return this.m44Store.stack[--this.m44Store.sp];
            }
            case 15: {
                return this.mnnStore.stack[--this.mnnStore.sp];
            }
        }
        return null;
    }

    private final void dotV2() {
        V2Obj v2Obj = this.v2Store.stack[--this.v2Store.sp];
        V2Obj v2Obj2 = this.v2Store.stack[--this.v2Store.sp];
        this.scalerStore.stack[this.scalerStore.sp++] = v2Obj2.a * v2Obj.a + v2Obj2.b * v2Obj.b;
    }

    private final void crossV2() {
        V2Obj v2Obj = this.v2Store.stack[--this.v2Store.sp];
        V2Obj v2Obj2 = this.v2Store.stack[--this.v2Store.sp];
        this.scalerStore.stack[this.scalerStore.sp++] = v2Obj2.a * v2Obj.b - v2Obj2.b * v2Obj.a;
    }

    private final void dotV3() {
        V3Obj v3Obj = this.v3Store.stack[--this.v3Store.sp];
        V3Obj v3Obj2 = this.v3Store.stack[--this.v3Store.sp];
        this.scalerStore.stack[this.scalerStore.sp++] = v3Obj2.a * v3Obj.a + v3Obj2.b * v3Obj.b + v3Obj2.c * v3Obj.c;
    }

    private final void crossV3() {
        V3Obj v3Obj = this.v3Store.stack[--this.v3Store.sp];
        V3Obj v3Obj2 = this.v3Store.stack[--this.v3Store.sp];
        V3Obj v3Obj3 = this.v3Store.heap[this.v3Store.hp++];
        v3Obj3.a = v3Obj2.b * v3Obj.c - v3Obj2.c * v3Obj.b;
        v3Obj3.b = v3Obj2.c * v3Obj.a - v3Obj2.a * v3Obj.c;
        v3Obj3.c = v3Obj2.a * v3Obj.b - v3Obj2.b * v3Obj.a;
        this.v3Store.stack[this.v3Store.sp++] = v3Obj3;
    }

    private final void dotV4() {
        V4Obj v4Obj = this.v4Store.stack[--this.v4Store.sp];
        V4Obj v4Obj2 = this.v4Store.stack[--this.v4Store.sp];
        this.scalerStore.stack[this.scalerStore.sp++] = v4Obj2.a * v4Obj.a + v4Obj2.b * v4Obj.b + v4Obj2.c * v4Obj.c + v4Obj2.d * v4Obj.d;
    }

    private final void dotVn() {
        VnObj vnObj = this.vnStore.stack[--this.vnStore.sp];
        VnObj vnObj2 = this.vnStore.stack[--this.vnStore.sp];
        double d = vnObj2.data[0] * vnObj.data[0];
        for (int i = 1; i < vnObj2.data.length; ++i) {
            d += vnObj2.data[i] * vnObj.data[i];
        }
        this.scalerStore.stack[this.scalerStore.sp++] = d;
    }

    private final void mulM22V2() {
        V2Obj v2Obj = this.v2Store.stack[--this.v2Store.sp];
        M22Obj m22Obj = this.m22Store.stack[--this.m22Store.sp];
        V2Obj v2Obj2 = this.v2Store.heap[this.v2Store.hp++];
        v2Obj2.a = m22Obj.a * v2Obj.a + m22Obj.b * v2Obj.b;
        v2Obj2.b = m22Obj.c * v2Obj.a + m22Obj.d * v2Obj.b;
        this.v2Store.stack[this.v2Store.sp++] = v2Obj2;
    }

    private final void mulV2M22() {
        M22Obj m22Obj = this.m22Store.stack[--this.m22Store.sp];
        V2Obj v2Obj = this.v2Store.stack[--this.v2Store.sp];
        V2Obj v2Obj2 = this.v2Store.heap[this.v2Store.hp++];
        v2Obj2.a = v2Obj.a * m22Obj.a + v2Obj.b * m22Obj.c;
        v2Obj2.b = v2Obj.a * m22Obj.b + v2Obj.b * m22Obj.d;
        this.v2Store.stack[this.v2Store.sp++] = v2Obj2;
    }

    private final void mulM32V2() {
        V2Obj v2Obj = this.v2Store.stack[--this.v2Store.sp];
        M32Obj m32Obj = this.m32Store.stack[--this.m32Store.sp];
        V3Obj v3Obj = this.v3Store.heap[this.v3Store.hp++];
        v3Obj.a = m32Obj.a * v2Obj.a + m32Obj.b * v2Obj.b;
        v3Obj.b = m32Obj.c * v2Obj.a + m32Obj.d * v2Obj.b;
        v3Obj.c = m32Obj.e * v2Obj.a + m32Obj.f * v2Obj.b;
        this.v3Store.stack[this.v3Store.sp++] = v3Obj;
    }

    private final void mulV2M23() {
        M23Obj m23Obj = this.m23Store.stack[--this.m23Store.sp];
        V2Obj v2Obj = this.v2Store.stack[--this.v2Store.sp];
        V3Obj v3Obj = this.v3Store.heap[this.v3Store.hp++];
        v3Obj.a = v2Obj.a * m23Obj.a + v2Obj.b * m23Obj.d;
        v3Obj.b = v2Obj.a * m23Obj.b + v2Obj.b * m23Obj.e;
        v3Obj.c = v2Obj.a * m23Obj.c + v2Obj.b * m23Obj.f;
        this.v3Store.stack[this.v3Store.sp++] = v3Obj;
    }

    private final void mulM42V2() {
        V2Obj v2Obj = this.v2Store.stack[--this.v2Store.sp];
        M42Obj m42Obj = this.m42Store.stack[--this.m42Store.sp];
        V4Obj v4Obj = this.v4Store.heap[this.v4Store.hp++];
        v4Obj.a = m42Obj.a * v2Obj.a + m42Obj.b * v2Obj.b;
        v4Obj.b = m42Obj.c * v2Obj.a + m42Obj.d * v2Obj.b;
        v4Obj.c = m42Obj.e * v2Obj.a + m42Obj.f * v2Obj.b;
        v4Obj.d = m42Obj.g * v2Obj.a + m42Obj.h * v2Obj.b;
        this.v4Store.stack[this.v4Store.sp++] = v4Obj;
    }

    private final void mulV2M24() {
        M24Obj m24Obj = this.m24Store.stack[--this.m24Store.sp];
        V2Obj v2Obj = this.v2Store.stack[--this.v2Store.sp];
        V4Obj v4Obj = this.v4Store.heap[this.v4Store.hp++];
        v4Obj.a = v2Obj.a * m24Obj.a + v2Obj.b * m24Obj.e;
        v4Obj.b = v2Obj.a * m24Obj.b + v2Obj.b * m24Obj.f;
        v4Obj.c = v2Obj.a * m24Obj.c + v2Obj.b * m24Obj.g;
        v4Obj.d = v2Obj.a * m24Obj.d + v2Obj.b * m24Obj.h;
        this.v4Store.stack[this.v4Store.sp++] = v4Obj;
    }

    private final void mulM23V3() {
        V3Obj v3Obj = this.v3Store.stack[--this.v3Store.sp];
        M23Obj m23Obj = this.m23Store.stack[--this.m23Store.sp];
        V2Obj v2Obj = this.v2Store.heap[this.v2Store.hp++];
        v2Obj.a = m23Obj.a * v3Obj.a + m23Obj.b * v3Obj.b + m23Obj.c * v3Obj.c;
        v2Obj.b = m23Obj.d * v3Obj.a + m23Obj.e * v3Obj.b + m23Obj.f * v3Obj.c;
        this.v2Store.stack[this.v2Store.sp++] = v2Obj;
    }

    private final void mulV3M32() {
        M32Obj m32Obj = this.m32Store.stack[--this.m32Store.sp];
        V3Obj v3Obj = this.v3Store.stack[--this.v3Store.sp];
        V2Obj v2Obj = this.v2Store.heap[this.v2Store.hp++];
        v2Obj.a = v3Obj.a * m32Obj.a + v3Obj.b * m32Obj.c + v3Obj.c * m32Obj.e;
        v2Obj.b = v3Obj.a * m32Obj.b + v3Obj.b * m32Obj.d + v3Obj.c * m32Obj.f;
        this.v2Store.stack[this.v2Store.sp++] = v2Obj;
    }

    private final void mulM33V3() {
        V3Obj v3Obj = this.v3Store.stack[--this.v3Store.sp];
        M33Obj m33Obj = this.m33Store.stack[--this.m33Store.sp];
        V3Obj v3Obj2 = this.v3Store.heap[this.v3Store.hp++];
        v3Obj2.a = m33Obj.a * v3Obj.a + m33Obj.b * v3Obj.b + m33Obj.c * v3Obj.c;
        v3Obj2.b = m33Obj.d * v3Obj.a + m33Obj.e * v3Obj.b + m33Obj.f * v3Obj.c;
        v3Obj2.c = m33Obj.g * v3Obj.a + m33Obj.h * v3Obj.b + m33Obj.i * v3Obj.c;
        this.v3Store.stack[this.v3Store.sp++] = v3Obj2;
    }

    private final void mulV3M33() {
        M33Obj m33Obj = this.m33Store.stack[--this.m33Store.sp];
        V3Obj v3Obj = this.v3Store.stack[--this.v3Store.sp];
        V3Obj v3Obj2 = this.v3Store.heap[this.v3Store.hp++];
        v3Obj2.a = v3Obj.a * m33Obj.a + v3Obj.b * m33Obj.d + v3Obj.c * m33Obj.g;
        v3Obj2.b = v3Obj.a * m33Obj.b + v3Obj.b * m33Obj.e + v3Obj.c * m33Obj.h;
        v3Obj2.c = v3Obj.a * m33Obj.c + v3Obj.b * m33Obj.f + v3Obj.c * m33Obj.i;
        this.v3Store.stack[this.v3Store.sp++] = v3Obj2;
    }

    private final void mulM43V3() {
        V3Obj v3Obj = this.v3Store.stack[--this.v3Store.sp];
        M43Obj m43Obj = this.m43Store.stack[--this.m43Store.sp];
        V4Obj v4Obj = this.v4Store.heap[this.v4Store.hp++];
        v4Obj.a = m43Obj.a * v3Obj.a + m43Obj.b * v3Obj.b + m43Obj.c * v3Obj.c;
        v4Obj.b = m43Obj.d * v3Obj.a + m43Obj.e * v3Obj.b + m43Obj.f * v3Obj.c;
        v4Obj.c = m43Obj.g * v3Obj.a + m43Obj.h * v3Obj.b + m43Obj.i * v3Obj.c;
        v4Obj.d = m43Obj.j * v3Obj.a + m43Obj.k * v3Obj.b + m43Obj.l * v3Obj.c;
        this.v4Store.stack[this.v4Store.sp++] = v4Obj;
    }

    private final void mulV3M34() {
        M34Obj m34Obj = this.m34Store.stack[--this.m34Store.sp];
        V3Obj v3Obj = this.v3Store.stack[--this.v3Store.sp];
        V4Obj v4Obj = this.v4Store.heap[this.v4Store.hp++];
        v4Obj.a = v3Obj.a * m34Obj.a + v3Obj.b * m34Obj.e + v3Obj.c * m34Obj.i;
        v4Obj.b = v3Obj.a * m34Obj.b + v3Obj.b * m34Obj.f + v3Obj.c * m34Obj.j;
        v4Obj.c = v3Obj.a * m34Obj.c + v3Obj.b * m34Obj.g + v3Obj.c * m34Obj.k;
        v4Obj.d = v3Obj.a * m34Obj.d + v3Obj.b * m34Obj.h + v3Obj.c * m34Obj.l;
        this.v4Store.stack[this.v4Store.sp++] = v4Obj;
    }

    private final void mulM24V4() {
        V4Obj v4Obj = this.v4Store.stack[--this.v4Store.sp];
        M24Obj m24Obj = this.m24Store.stack[--this.m24Store.sp];
        V2Obj v2Obj = this.v2Store.heap[this.v2Store.hp++];
        v2Obj.a = m24Obj.a * v4Obj.a + m24Obj.b * v4Obj.b + m24Obj.c * v4Obj.c + m24Obj.d * v4Obj.d;
        v2Obj.b = m24Obj.e * v4Obj.a + m24Obj.f * v4Obj.b + m24Obj.g * v4Obj.c + m24Obj.h * v4Obj.d;
        this.v2Store.stack[this.v2Store.sp++] = v2Obj;
    }

    private final void mulV4M42() {
        M42Obj m42Obj = this.m42Store.stack[--this.m42Store.sp];
        V4Obj v4Obj = this.v4Store.stack[--this.v4Store.sp];
        V2Obj v2Obj = this.v2Store.heap[this.v2Store.hp++];
        v2Obj.a = v4Obj.a * m42Obj.a + v4Obj.b * m42Obj.c + v4Obj.c * m42Obj.e + v4Obj.d * m42Obj.g;
        v2Obj.b = v4Obj.a * m42Obj.b + v4Obj.b * m42Obj.d + v4Obj.c * m42Obj.f + v4Obj.d * m42Obj.h;
        this.v2Store.stack[this.v2Store.sp++] = v2Obj;
    }

    private final void mulM34V4() {
        V4Obj v4Obj = this.v4Store.stack[--this.v4Store.sp];
        M34Obj m34Obj = this.m34Store.stack[--this.m34Store.sp];
        V3Obj v3Obj = this.v3Store.heap[this.v3Store.hp++];
        v3Obj.a = m34Obj.a * v4Obj.a + m34Obj.b * v4Obj.b + m34Obj.c * v4Obj.c + m34Obj.d * v4Obj.d;
        v3Obj.b = m34Obj.e * v4Obj.a + m34Obj.f * v4Obj.b + m34Obj.g * v4Obj.c + m34Obj.h * v4Obj.d;
        v3Obj.c = m34Obj.i * v4Obj.a + m34Obj.j * v4Obj.b + m34Obj.k * v4Obj.c + m34Obj.l * v4Obj.d;
        this.v3Store.stack[this.v3Store.sp++] = v3Obj;
    }

    private final void mulV4M43() {
        M43Obj m43Obj = this.m43Store.stack[--this.m43Store.sp];
        V4Obj v4Obj = this.v4Store.stack[--this.v4Store.sp];
        V3Obj v3Obj = this.v3Store.heap[this.v3Store.hp++];
        v3Obj.a = v4Obj.a * m43Obj.a + v4Obj.b * m43Obj.d + v4Obj.c * m43Obj.g + v4Obj.d * m43Obj.j;
        v3Obj.b = v4Obj.a * m43Obj.b + v4Obj.b * m43Obj.e + v4Obj.c * m43Obj.h + v4Obj.d * m43Obj.k;
        v3Obj.c = v4Obj.a * m43Obj.c + v4Obj.b * m43Obj.f + v4Obj.c * m43Obj.i + v4Obj.d * m43Obj.l;
        this.v3Store.stack[this.v3Store.sp++] = v3Obj;
    }

    private final void mulM44V4() {
        V4Obj v4Obj = this.v4Store.stack[--this.v4Store.sp];
        M44Obj m44Obj = this.m44Store.stack[--this.m44Store.sp];
        V4Obj v4Obj2 = this.v4Store.heap[this.v4Store.hp++];
        v4Obj2.a = m44Obj.a * v4Obj.a + m44Obj.b * v4Obj.b + m44Obj.c * v4Obj.c + m44Obj.d * v4Obj.d;
        v4Obj2.b = m44Obj.e * v4Obj.a + m44Obj.f * v4Obj.b + m44Obj.g * v4Obj.c + m44Obj.h * v4Obj.d;
        v4Obj2.c = m44Obj.i * v4Obj.a + m44Obj.j * v4Obj.b + m44Obj.k * v4Obj.c + m44Obj.l * v4Obj.d;
        v4Obj2.d = m44Obj.m * v4Obj.a + m44Obj.n * v4Obj.b + m44Obj.o * v4Obj.c + m44Obj.p * v4Obj.d;
        this.v4Store.stack[this.v4Store.sp++] = v4Obj2;
    }

    private final void mulV4M44() {
        M44Obj m44Obj = this.m44Store.stack[--this.m44Store.sp];
        V4Obj v4Obj = this.v4Store.stack[--this.v4Store.sp];
        V4Obj v4Obj2 = this.v4Store.heap[this.v4Store.hp++];
        v4Obj2.a = v4Obj.a * m44Obj.a + v4Obj.b * m44Obj.e + v4Obj.c * m44Obj.i + v4Obj.d * m44Obj.m;
        v4Obj2.b = v4Obj.a * m44Obj.b + v4Obj.b * m44Obj.f + v4Obj.c * m44Obj.j + v4Obj.d * m44Obj.n;
        v4Obj2.c = v4Obj.a * m44Obj.c + v4Obj.b * m44Obj.g + v4Obj.c * m44Obj.k + v4Obj.d * m44Obj.o;
        v4Obj2.d = v4Obj.a * m44Obj.d + v4Obj.b * m44Obj.h + v4Obj.c * m44Obj.l + v4Obj.d * m44Obj.p;
        this.v4Store.stack[this.v4Store.sp++] = v4Obj2;
    }

    private final void mulM22M22() {
        M22Obj m22Obj = this.m22Store.stack[--this.m22Store.sp];
        M22Obj m22Obj2 = this.m22Store.stack[--this.m22Store.sp];
        M22Obj m22Obj3 = this.m22Store.heap[this.m22Store.hp++];
        m22Obj3.a = m22Obj2.a * m22Obj.a + m22Obj2.b * m22Obj.c;
        m22Obj3.b = m22Obj2.a * m22Obj.b + m22Obj2.b * m22Obj.d;
        m22Obj3.c = m22Obj2.c * m22Obj.a + m22Obj2.d * m22Obj.c;
        m22Obj3.d = m22Obj2.c * m22Obj.b + m22Obj2.d * m22Obj.d;
        this.m22Store.stack[this.m22Store.sp++] = m22Obj3;
    }

    private final void mulM22M23() {
        M23Obj m23Obj = this.m23Store.stack[--this.m23Store.sp];
        M22Obj m22Obj = this.m22Store.stack[--this.m22Store.sp];
        M23Obj m23Obj2 = this.m23Store.heap[this.m23Store.hp++];
        m23Obj2.a = m22Obj.a * m23Obj.a + m22Obj.b * m23Obj.d;
        m23Obj2.b = m22Obj.a * m23Obj.b + m22Obj.b * m23Obj.e;
        m23Obj2.c = m22Obj.a * m23Obj.c + m22Obj.b * m23Obj.f;
        m23Obj2.d = m22Obj.c * m23Obj.a + m22Obj.d * m23Obj.d;
        m23Obj2.e = m22Obj.c * m23Obj.b + m22Obj.d * m23Obj.e;
        m23Obj2.f = m22Obj.c * m23Obj.c + m22Obj.d * m23Obj.f;
        this.m23Store.stack[this.m23Store.sp++] = m23Obj2;
    }

    private final void mulM22M24() {
        M24Obj m24Obj = this.m24Store.stack[--this.m24Store.sp];
        M22Obj m22Obj = this.m22Store.stack[--this.m22Store.sp];
        M24Obj m24Obj2 = this.m24Store.heap[this.m24Store.hp++];
        m24Obj2.a = m22Obj.a * m24Obj.a + m22Obj.b * m24Obj.e;
        m24Obj2.b = m22Obj.a * m24Obj.b + m22Obj.b * m24Obj.f;
        m24Obj2.c = m22Obj.a * m24Obj.c + m22Obj.b * m24Obj.g;
        m24Obj2.d = m22Obj.a * m24Obj.d + m22Obj.b * m24Obj.h;
        m24Obj2.e = m22Obj.c * m24Obj.a + m22Obj.d * m24Obj.e;
        m24Obj2.f = m22Obj.c * m24Obj.b + m22Obj.d * m24Obj.f;
        m24Obj2.g = m22Obj.c * m24Obj.c + m22Obj.d * m24Obj.g;
        m24Obj2.h = m22Obj.c * m24Obj.d + m22Obj.d * m24Obj.h;
        this.m24Store.stack[this.m24Store.sp++] = m24Obj2;
    }

    private final void mulM23M32() {
        M32Obj m32Obj = this.m32Store.stack[--this.m32Store.sp];
        M23Obj m23Obj = this.m23Store.stack[--this.m23Store.sp];
        M22Obj m22Obj = this.m22Store.heap[this.m22Store.hp++];
        m22Obj.a = m23Obj.a * m32Obj.a + m23Obj.b * m32Obj.c + m23Obj.c * m32Obj.e;
        m22Obj.b = m23Obj.a * m32Obj.b + m23Obj.b * m32Obj.d + m23Obj.c * m32Obj.f;
        m22Obj.c = m23Obj.d * m32Obj.a + m23Obj.e * m32Obj.c + m23Obj.f * m32Obj.e;
        m22Obj.d = m23Obj.d * m32Obj.b + m23Obj.e * m32Obj.d + m23Obj.f * m32Obj.f;
        this.m22Store.stack[this.m22Store.sp++] = m22Obj;
    }

    private final void mulM23M33() {
        M33Obj m33Obj = this.m33Store.stack[--this.m33Store.sp];
        M23Obj m23Obj = this.m23Store.stack[--this.m23Store.sp];
        M23Obj m23Obj2 = this.m23Store.heap[this.m23Store.hp++];
        m23Obj2.a = m23Obj.a * m33Obj.a + m23Obj.b * m33Obj.d + m23Obj.c * m33Obj.g;
        m23Obj2.b = m23Obj.a * m33Obj.b + m23Obj.b * m33Obj.e + m23Obj.c * m33Obj.h;
        m23Obj2.c = m23Obj.a * m33Obj.c + m23Obj.b * m33Obj.f + m23Obj.c * m33Obj.i;
        m23Obj2.d = m23Obj.d * m33Obj.a + m23Obj.e * m33Obj.d + m23Obj.f * m33Obj.g;
        m23Obj2.e = m23Obj.d * m33Obj.b + m23Obj.e * m33Obj.e + m23Obj.f * m33Obj.h;
        m23Obj2.f = m23Obj.d * m33Obj.c + m23Obj.e * m33Obj.f + m23Obj.f * m33Obj.i;
        this.m23Store.stack[this.m23Store.sp++] = m23Obj2;
    }

    private final void mulM23M34() {
        M34Obj m34Obj = this.m34Store.stack[--this.m34Store.sp];
        M23Obj m23Obj = this.m23Store.stack[--this.m23Store.sp];
        M24Obj m24Obj = this.m24Store.heap[this.m24Store.hp++];
        m24Obj.a = m23Obj.a * m34Obj.a + m23Obj.b * m34Obj.e + m23Obj.c * m34Obj.i;
        m24Obj.b = m23Obj.a * m34Obj.b + m23Obj.b * m34Obj.f + m23Obj.c * m34Obj.j;
        m24Obj.c = m23Obj.a * m34Obj.c + m23Obj.b * m34Obj.g + m23Obj.c * m34Obj.k;
        m24Obj.d = m23Obj.a * m34Obj.d + m23Obj.b * m34Obj.h + m23Obj.c * m34Obj.l;
        m24Obj.e = m23Obj.d * m34Obj.a + m23Obj.e * m34Obj.e + m23Obj.f * m34Obj.i;
        m24Obj.f = m23Obj.d * m34Obj.b + m23Obj.e * m34Obj.f + m23Obj.f * m34Obj.j;
        m24Obj.g = m23Obj.d * m34Obj.c + m23Obj.e * m34Obj.g + m23Obj.f * m34Obj.k;
        m24Obj.h = m23Obj.d * m34Obj.d + m23Obj.e * m34Obj.h + m23Obj.f * m34Obj.l;
        this.m24Store.stack[this.m24Store.sp++] = m24Obj;
    }

    private final void mulM24M42() {
        M42Obj m42Obj = this.m42Store.stack[--this.m42Store.sp];
        M24Obj m24Obj = this.m24Store.stack[--this.m24Store.sp];
        M22Obj m22Obj = this.m22Store.heap[this.m22Store.hp++];
        m22Obj.a = m24Obj.a * m42Obj.a + m24Obj.b * m42Obj.c + m24Obj.c * m42Obj.e + m24Obj.d * m42Obj.g;
        m22Obj.b = m24Obj.a * m42Obj.b + m24Obj.b * m42Obj.d + m24Obj.c * m42Obj.f + m24Obj.d * m42Obj.h;
        m22Obj.c = m24Obj.e * m42Obj.a + m24Obj.f * m42Obj.c + m24Obj.g * m42Obj.e + m24Obj.h * m42Obj.g;
        m22Obj.d = m24Obj.e * m42Obj.b + m24Obj.f * m42Obj.d + m24Obj.g * m42Obj.f + m24Obj.h * m42Obj.h;
        this.m22Store.stack[this.m22Store.sp++] = m22Obj;
    }

    private final void mulM24M43() {
        M43Obj m43Obj = this.m43Store.stack[--this.m43Store.sp];
        M24Obj m24Obj = this.m24Store.stack[--this.m24Store.sp];
        M23Obj m23Obj = this.m23Store.heap[this.m23Store.hp++];
        m23Obj.a = m24Obj.a * m43Obj.a + m24Obj.b * m43Obj.d + m24Obj.c * m43Obj.g + m24Obj.d * m43Obj.j;
        m23Obj.b = m24Obj.a * m43Obj.b + m24Obj.b * m43Obj.e + m24Obj.c * m43Obj.h + m24Obj.d * m43Obj.k;
        m23Obj.c = m24Obj.a * m43Obj.c + m24Obj.b * m43Obj.f + m24Obj.c * m43Obj.i + m24Obj.d * m43Obj.l;
        m23Obj.d = m24Obj.e * m43Obj.a + m24Obj.f * m43Obj.d + m24Obj.g * m43Obj.g + m24Obj.h * m43Obj.j;
        m23Obj.e = m24Obj.e * m43Obj.b + m24Obj.f * m43Obj.e + m24Obj.g * m43Obj.h + m24Obj.h * m43Obj.k;
        m23Obj.f = m24Obj.e * m43Obj.c + m24Obj.f * m43Obj.f + m24Obj.g * m43Obj.i + m24Obj.h * m43Obj.l;
        this.m23Store.stack[this.m23Store.sp++] = m23Obj;
    }

    private final void mulM24M44() {
        M44Obj m44Obj = this.m44Store.stack[--this.m44Store.sp];
        M24Obj m24Obj = this.m24Store.stack[--this.m24Store.sp];
        M24Obj m24Obj2 = this.m24Store.heap[this.m24Store.hp++];
        m24Obj2.a = m24Obj.a * m44Obj.a + m24Obj.b * m44Obj.e + m24Obj.c * m44Obj.i + m24Obj.d * m44Obj.m;
        m24Obj2.b = m24Obj.a * m44Obj.b + m24Obj.b * m44Obj.f + m24Obj.c * m44Obj.j + m24Obj.d * m44Obj.n;
        m24Obj2.c = m24Obj.a * m44Obj.c + m24Obj.b * m44Obj.g + m24Obj.c * m44Obj.k + m24Obj.d * m44Obj.o;
        m24Obj2.d = m24Obj.a * m44Obj.d + m24Obj.b * m44Obj.h + m24Obj.c * m44Obj.l + m24Obj.d * m44Obj.p;
        m24Obj2.e = m24Obj.e * m44Obj.a + m24Obj.f * m44Obj.e + m24Obj.g * m44Obj.i + m24Obj.h * m44Obj.m;
        m24Obj2.f = m24Obj.e * m44Obj.b + m24Obj.f * m44Obj.f + m24Obj.g * m44Obj.j + m24Obj.h * m44Obj.n;
        m24Obj2.g = m24Obj.e * m44Obj.c + m24Obj.f * m44Obj.g + m24Obj.g * m44Obj.k + m24Obj.h * m44Obj.o;
        m24Obj2.h = m24Obj.e * m44Obj.d + m24Obj.f * m44Obj.h + m24Obj.g * m44Obj.l + m24Obj.h * m44Obj.p;
        this.m24Store.stack[this.m24Store.sp++] = m24Obj2;
    }

    private final void mulM32M22() {
        M22Obj m22Obj = this.m22Store.stack[--this.m22Store.sp];
        M32Obj m32Obj = this.m32Store.stack[--this.m32Store.sp];
        M32Obj m32Obj2 = this.m32Store.heap[this.m32Store.hp++];
        m32Obj2.a = m32Obj.a * m22Obj.a + m32Obj.b * m22Obj.c;
        m32Obj2.b = m32Obj.a * m22Obj.b + m32Obj.b * m22Obj.d;
        m32Obj2.c = m32Obj.c * m22Obj.a + m32Obj.d * m22Obj.c;
        m32Obj2.d = m32Obj.c * m22Obj.b + m32Obj.d * m22Obj.d;
        m32Obj2.e = m32Obj.e * m22Obj.a + m32Obj.f * m22Obj.c;
        m32Obj2.f = m32Obj.e * m22Obj.b + m32Obj.f * m22Obj.d;
        this.m32Store.stack[this.m32Store.sp++] = m32Obj2;
    }

    private final void mulM32M23() {
        M23Obj m23Obj = this.m23Store.stack[--this.m23Store.sp];
        M32Obj m32Obj = this.m32Store.stack[--this.m32Store.sp];
        M33Obj m33Obj = this.m33Store.heap[this.m33Store.hp++];
        m33Obj.a = m32Obj.a * m23Obj.a + m32Obj.b * m23Obj.d;
        m33Obj.b = m32Obj.a * m23Obj.b + m32Obj.b * m23Obj.e;
        m33Obj.c = m32Obj.a * m23Obj.c + m32Obj.b * m23Obj.f;
        m33Obj.d = m32Obj.c * m23Obj.a + m32Obj.d * m23Obj.d;
        m33Obj.e = m32Obj.c * m23Obj.b + m32Obj.d * m23Obj.e;
        m33Obj.f = m32Obj.c * m23Obj.c + m32Obj.d * m23Obj.f;
        m33Obj.g = m32Obj.e * m23Obj.a + m32Obj.f * m23Obj.d;
        m33Obj.h = m32Obj.e * m23Obj.b + m32Obj.f * m23Obj.e;
        m33Obj.i = m32Obj.e * m23Obj.c + m32Obj.f * m23Obj.f;
        this.m33Store.stack[this.m33Store.sp++] = m33Obj;
    }

    private final void mulM32M24() {
        M24Obj m24Obj = this.m24Store.stack[--this.m24Store.sp];
        M32Obj m32Obj = this.m32Store.stack[--this.m32Store.sp];
        M34Obj m34Obj = this.m34Store.heap[this.m34Store.hp++];
        m34Obj.a = m32Obj.a * m24Obj.a + m32Obj.b * m24Obj.e;
        m34Obj.b = m32Obj.a * m24Obj.b + m32Obj.b * m24Obj.f;
        m34Obj.c = m32Obj.a * m24Obj.c + m32Obj.b * m24Obj.g;
        m34Obj.d = m32Obj.a * m24Obj.d + m32Obj.b * m24Obj.h;
        m34Obj.e = m32Obj.c * m24Obj.a + m32Obj.d * m24Obj.e;
        m34Obj.f = m32Obj.c * m24Obj.b + m32Obj.d * m24Obj.f;
        m34Obj.g = m32Obj.c * m24Obj.c + m32Obj.d * m24Obj.g;
        m34Obj.h = m32Obj.c * m24Obj.d + m32Obj.d * m24Obj.h;
        m34Obj.i = m32Obj.e * m24Obj.a + m32Obj.f * m24Obj.e;
        m34Obj.j = m32Obj.e * m24Obj.b + m32Obj.f * m24Obj.f;
        m34Obj.k = m32Obj.e * m24Obj.c + m32Obj.f * m24Obj.g;
        m34Obj.l = m32Obj.e * m24Obj.d + m32Obj.f * m24Obj.h;
        this.m34Store.stack[this.m34Store.sp++] = m34Obj;
    }

    private final void mulM33M32() {
        M32Obj m32Obj = this.m32Store.stack[--this.m32Store.sp];
        M33Obj m33Obj = this.m33Store.stack[--this.m33Store.sp];
        M32Obj m32Obj2 = this.m32Store.heap[this.m32Store.hp++];
        m32Obj2.a = m33Obj.a * m32Obj.a + m33Obj.b * m32Obj.c + m33Obj.c * m32Obj.e;
        m32Obj2.b = m33Obj.a * m32Obj.b + m33Obj.b * m32Obj.d + m33Obj.c * m32Obj.f;
        m32Obj2.c = m33Obj.d * m32Obj.a + m33Obj.e * m32Obj.c + m33Obj.f * m32Obj.e;
        m32Obj2.d = m33Obj.d * m32Obj.b + m33Obj.e * m32Obj.d + m33Obj.f * m32Obj.f;
        m32Obj2.e = m33Obj.g * m32Obj.a + m33Obj.h * m32Obj.c + m33Obj.i * m32Obj.e;
        m32Obj2.f = m33Obj.g * m32Obj.b + m33Obj.h * m32Obj.d + m33Obj.i * m32Obj.f;
        this.m32Store.stack[this.m32Store.sp++] = m32Obj2;
    }

    private final void mulM33M33() {
        M33Obj m33Obj = this.m33Store.stack[--this.m33Store.sp];
        M33Obj m33Obj2 = this.m33Store.stack[--this.m33Store.sp];
        M33Obj m33Obj3 = this.m33Store.heap[this.m33Store.hp++];
        m33Obj3.a = m33Obj2.a * m33Obj.a + m33Obj2.b * m33Obj.d + m33Obj2.c * m33Obj.g;
        m33Obj3.b = m33Obj2.a * m33Obj.b + m33Obj2.b * m33Obj.e + m33Obj2.c * m33Obj.h;
        m33Obj3.c = m33Obj2.a * m33Obj.c + m33Obj2.b * m33Obj.f + m33Obj2.c * m33Obj.i;
        m33Obj3.d = m33Obj2.d * m33Obj.a + m33Obj2.e * m33Obj.d + m33Obj2.f * m33Obj.g;
        m33Obj3.e = m33Obj2.d * m33Obj.b + m33Obj2.e * m33Obj.e + m33Obj2.f * m33Obj.h;
        m33Obj3.f = m33Obj2.d * m33Obj.c + m33Obj2.e * m33Obj.f + m33Obj2.f * m33Obj.i;
        m33Obj3.g = m33Obj2.g * m33Obj.a + m33Obj2.h * m33Obj.d + m33Obj2.i * m33Obj.g;
        m33Obj3.h = m33Obj2.g * m33Obj.b + m33Obj2.h * m33Obj.e + m33Obj2.i * m33Obj.h;
        m33Obj3.i = m33Obj2.g * m33Obj.c + m33Obj2.h * m33Obj.f + m33Obj2.i * m33Obj.i;
        this.m33Store.stack[this.m33Store.sp++] = m33Obj3;
    }

    private final void mulM33M34() {
        M34Obj m34Obj = this.m34Store.stack[--this.m34Store.sp];
        M33Obj m33Obj = this.m33Store.stack[--this.m33Store.sp];
        M34Obj m34Obj2 = this.m34Store.heap[this.m34Store.hp++];
        m34Obj2.a = m33Obj.a * m34Obj.a + m33Obj.b * m34Obj.e + m33Obj.c * m34Obj.i;
        m34Obj2.b = m33Obj.a * m34Obj.b + m33Obj.b * m34Obj.f + m33Obj.c * m34Obj.j;
        m34Obj2.c = m33Obj.a * m34Obj.c + m33Obj.b * m34Obj.g + m33Obj.c * m34Obj.k;
        m34Obj2.d = m33Obj.a * m34Obj.d + m33Obj.b * m34Obj.h + m33Obj.c * m34Obj.l;
        m34Obj2.e = m33Obj.d * m34Obj.a + m33Obj.e * m34Obj.e + m33Obj.f * m34Obj.i;
        m34Obj2.f = m33Obj.d * m34Obj.b + m33Obj.e * m34Obj.f + m33Obj.f * m34Obj.j;
        m34Obj2.g = m33Obj.d * m34Obj.c + m33Obj.e * m34Obj.g + m33Obj.f * m34Obj.k;
        m34Obj2.h = m33Obj.d * m34Obj.d + m33Obj.e * m34Obj.h + m33Obj.f * m34Obj.l;
        m34Obj2.i = m33Obj.g * m34Obj.a + m33Obj.h * m34Obj.e + m33Obj.i * m34Obj.i;
        m34Obj2.j = m33Obj.g * m34Obj.b + m33Obj.h * m34Obj.f + m33Obj.i * m34Obj.j;
        m34Obj2.k = m33Obj.g * m34Obj.c + m33Obj.h * m34Obj.g + m33Obj.i * m34Obj.k;
        m34Obj2.l = m33Obj.g * m34Obj.d + m33Obj.h * m34Obj.h + m33Obj.i * m34Obj.l;
        this.m34Store.stack[this.m34Store.sp++] = m34Obj2;
    }

    private final void mulM34M42() {
        M42Obj m42Obj = this.m42Store.stack[--this.m42Store.sp];
        M34Obj m34Obj = this.m34Store.stack[--this.m34Store.sp];
        M32Obj m32Obj = this.m32Store.heap[this.m32Store.hp++];
        m32Obj.a = m34Obj.a * m42Obj.a + m34Obj.b * m42Obj.c + m34Obj.c * m42Obj.e + m34Obj.d * m42Obj.g;
        m32Obj.b = m34Obj.a * m42Obj.b + m34Obj.b * m42Obj.d + m34Obj.c * m42Obj.f + m34Obj.d * m42Obj.h;
        m32Obj.c = m34Obj.e * m42Obj.a + m34Obj.f * m42Obj.c + m34Obj.g * m42Obj.e + m34Obj.h * m42Obj.g;
        m32Obj.d = m34Obj.e * m42Obj.b + m34Obj.f * m42Obj.d + m34Obj.g * m42Obj.f + m34Obj.h * m42Obj.h;
        m32Obj.e = m34Obj.i * m42Obj.a + m34Obj.j * m42Obj.c + m34Obj.k * m42Obj.e + m34Obj.l * m42Obj.g;
        m32Obj.f = m34Obj.i * m42Obj.b + m34Obj.j * m42Obj.d + m34Obj.k * m42Obj.f + m34Obj.l * m42Obj.h;
        this.m32Store.stack[this.m32Store.sp++] = m32Obj;
    }

    private final void mulM34M43() {
        M43Obj m43Obj = this.m43Store.stack[--this.m43Store.sp];
        M34Obj m34Obj = this.m34Store.stack[--this.m34Store.sp];
        M33Obj m33Obj = this.m33Store.heap[this.m33Store.hp++];
        m33Obj.a = m34Obj.a * m43Obj.a + m34Obj.b * m43Obj.d + m34Obj.c * m43Obj.g + m34Obj.d * m43Obj.j;
        m33Obj.b = m34Obj.a * m43Obj.b + m34Obj.b * m43Obj.e + m34Obj.c * m43Obj.h + m34Obj.d * m43Obj.k;
        m33Obj.c = m34Obj.a * m43Obj.c + m34Obj.b * m43Obj.f + m34Obj.c * m43Obj.i + m34Obj.d * m43Obj.l;
        m33Obj.d = m34Obj.e * m43Obj.a + m34Obj.f * m43Obj.d + m34Obj.g * m43Obj.g + m34Obj.h * m43Obj.j;
        m33Obj.e = m34Obj.e * m43Obj.b + m34Obj.f * m43Obj.e + m34Obj.g * m43Obj.h + m34Obj.h * m43Obj.k;
        m33Obj.f = m34Obj.e * m43Obj.c + m34Obj.f * m43Obj.f + m34Obj.g * m43Obj.i + m34Obj.h * m43Obj.l;
        m33Obj.g = m34Obj.i * m43Obj.a + m34Obj.j * m43Obj.d + m34Obj.k * m43Obj.g + m34Obj.l * m43Obj.j;
        m33Obj.h = m34Obj.i * m43Obj.b + m34Obj.j * m43Obj.e + m34Obj.k * m43Obj.h + m34Obj.l * m43Obj.k;
        m33Obj.i = m34Obj.i * m43Obj.c + m34Obj.j * m43Obj.f + m34Obj.k * m43Obj.i + m34Obj.l * m43Obj.l;
        this.m33Store.stack[this.m33Store.sp++] = m33Obj;
    }

    private final void mulM34M44() {
        M44Obj m44Obj = this.m44Store.stack[--this.m44Store.sp];
        M34Obj m34Obj = this.m34Store.stack[--this.m34Store.sp];
        M34Obj m34Obj2 = this.m34Store.heap[this.m34Store.hp++];
        m34Obj2.a = m34Obj.a * m44Obj.a + m34Obj.b * m44Obj.e + m34Obj.c * m44Obj.i + m34Obj.d * m44Obj.m;
        m34Obj2.b = m34Obj.a * m44Obj.b + m34Obj.b * m44Obj.f + m34Obj.c * m44Obj.j + m34Obj.d * m44Obj.n;
        m34Obj2.c = m34Obj.a * m44Obj.c + m34Obj.b * m44Obj.g + m34Obj.c * m44Obj.k + m34Obj.d * m44Obj.o;
        m34Obj2.d = m34Obj.a * m44Obj.d + m34Obj.b * m44Obj.h + m34Obj.c * m44Obj.l + m34Obj.d * m44Obj.p;
        m34Obj2.e = m34Obj.e * m44Obj.a + m34Obj.f * m44Obj.e + m34Obj.g * m44Obj.i + m34Obj.h * m44Obj.m;
        m34Obj2.f = m34Obj.e * m44Obj.b + m34Obj.f * m44Obj.f + m34Obj.g * m44Obj.j + m34Obj.h * m44Obj.n;
        m34Obj2.g = m34Obj.e * m44Obj.c + m34Obj.f * m44Obj.g + m34Obj.g * m44Obj.k + m34Obj.h * m44Obj.o;
        m34Obj2.h = m34Obj.e * m44Obj.d + m34Obj.f * m44Obj.h + m34Obj.g * m44Obj.l + m34Obj.h * m44Obj.p;
        m34Obj2.i = m34Obj.i * m44Obj.a + m34Obj.j * m44Obj.e + m34Obj.k * m44Obj.i + m34Obj.l * m44Obj.m;
        m34Obj2.j = m34Obj.i * m44Obj.b + m34Obj.j * m44Obj.f + m34Obj.k * m44Obj.j + m34Obj.l * m44Obj.n;
        m34Obj2.k = m34Obj.i * m44Obj.c + m34Obj.j * m44Obj.g + m34Obj.k * m44Obj.k + m34Obj.l * m44Obj.o;
        m34Obj2.l = m34Obj.i * m44Obj.d + m34Obj.j * m44Obj.h + m34Obj.k * m44Obj.l + m34Obj.l * m44Obj.p;
        this.m34Store.stack[this.m34Store.sp++] = m34Obj2;
    }

    private final void mulM42M22() {
        M22Obj m22Obj = this.m22Store.stack[--this.m22Store.sp];
        M42Obj m42Obj = this.m42Store.stack[--this.m42Store.sp];
        M42Obj m42Obj2 = this.m42Store.heap[this.m42Store.hp++];
        m42Obj2.a = m42Obj.a * m22Obj.a + m42Obj.b * m22Obj.c;
        m42Obj2.b = m42Obj.a * m22Obj.b + m42Obj.b * m22Obj.d;
        m42Obj2.c = m42Obj.c * m22Obj.a + m42Obj.d * m22Obj.c;
        m42Obj2.d = m42Obj.c * m22Obj.b + m42Obj.d * m22Obj.d;
        m42Obj2.e = m42Obj.e * m22Obj.a + m42Obj.f * m22Obj.c;
        m42Obj2.f = m42Obj.e * m22Obj.b + m42Obj.f * m22Obj.d;
        m42Obj2.g = m42Obj.g * m22Obj.a + m42Obj.h * m22Obj.c;
        m42Obj2.h = m42Obj.g * m22Obj.b + m42Obj.h * m22Obj.d;
        this.m42Store.stack[this.m42Store.sp++] = m42Obj2;
    }

    private final void mulM42M23() {
        M23Obj m23Obj = this.m23Store.stack[--this.m23Store.sp];
        M42Obj m42Obj = this.m42Store.stack[--this.m42Store.sp];
        M43Obj m43Obj = this.m43Store.heap[this.m43Store.hp++];
        m43Obj.a = m42Obj.a * m23Obj.a + m42Obj.b * m23Obj.d;
        m43Obj.b = m42Obj.a * m23Obj.b + m42Obj.b * m23Obj.e;
        m43Obj.c = m42Obj.a * m23Obj.c + m42Obj.b * m23Obj.f;
        m43Obj.d = m42Obj.c * m23Obj.a + m42Obj.d * m23Obj.d;
        m43Obj.e = m42Obj.c * m23Obj.b + m42Obj.d * m23Obj.e;
        m43Obj.f = m42Obj.c * m23Obj.c + m42Obj.d * m23Obj.f;
        m43Obj.g = m42Obj.e * m23Obj.a + m42Obj.f * m23Obj.d;
        m43Obj.h = m42Obj.e * m23Obj.b + m42Obj.f * m23Obj.e;
        m43Obj.i = m42Obj.e * m23Obj.c + m42Obj.f * m23Obj.f;
        m43Obj.j = m42Obj.g * m23Obj.a + m42Obj.h * m23Obj.d;
        m43Obj.k = m42Obj.g * m23Obj.b + m42Obj.h * m23Obj.e;
        m43Obj.l = m42Obj.g * m23Obj.c + m42Obj.h * m23Obj.f;
        this.m43Store.stack[this.m43Store.sp++] = m43Obj;
    }

    private final void mulM42M24() {
        M24Obj m24Obj = this.m24Store.stack[--this.m24Store.sp];
        M42Obj m42Obj = this.m42Store.stack[--this.m42Store.sp];
        M44Obj m44Obj = this.m44Store.heap[this.m44Store.hp++];
        m44Obj.a = m42Obj.a * m24Obj.a + m42Obj.b * m24Obj.e;
        m44Obj.b = m42Obj.a * m24Obj.b + m42Obj.b * m24Obj.f;
        m44Obj.c = m42Obj.a * m24Obj.c + m42Obj.b * m24Obj.g;
        m44Obj.d = m42Obj.a * m24Obj.d + m42Obj.b * m24Obj.h;
        m44Obj.e = m42Obj.c * m24Obj.a + m42Obj.d * m24Obj.e;
        m44Obj.f = m42Obj.c * m24Obj.b + m42Obj.d * m24Obj.f;
        m44Obj.g = m42Obj.c * m24Obj.c + m42Obj.d * m24Obj.g;
        m44Obj.h = m42Obj.c * m24Obj.d + m42Obj.d * m24Obj.h;
        m44Obj.i = m42Obj.e * m24Obj.a + m42Obj.f * m24Obj.e;
        m44Obj.j = m42Obj.e * m24Obj.b + m42Obj.f * m24Obj.f;
        m44Obj.k = m42Obj.e * m24Obj.c + m42Obj.f * m24Obj.g;
        m44Obj.l = m42Obj.e * m24Obj.d + m42Obj.f * m24Obj.h;
        m44Obj.m = m42Obj.g * m24Obj.a + m42Obj.h * m24Obj.e;
        m44Obj.n = m42Obj.g * m24Obj.b + m42Obj.h * m24Obj.f;
        m44Obj.o = m42Obj.g * m24Obj.c + m42Obj.h * m24Obj.g;
        m44Obj.p = m42Obj.g * m24Obj.d + m42Obj.h * m24Obj.h;
        this.m44Store.stack[this.m44Store.sp++] = m44Obj;
    }

    private final void mulM43M32() {
        M32Obj m32Obj = this.m32Store.stack[--this.m32Store.sp];
        M43Obj m43Obj = this.m43Store.stack[--this.m43Store.sp];
        M42Obj m42Obj = this.m42Store.heap[this.m42Store.hp++];
        m42Obj.a = m43Obj.a * m32Obj.a + m43Obj.b * m32Obj.c + m43Obj.c * m32Obj.e;
        m42Obj.b = m43Obj.a * m32Obj.b + m43Obj.b * m32Obj.d + m43Obj.c * m32Obj.f;
        m42Obj.c = m43Obj.d * m32Obj.a + m43Obj.e * m32Obj.c + m43Obj.f * m32Obj.e;
        m42Obj.d = m43Obj.d * m32Obj.b + m43Obj.e * m32Obj.d + m43Obj.f * m32Obj.f;
        m42Obj.e = m43Obj.g * m32Obj.a + m43Obj.h * m32Obj.c + m43Obj.i * m32Obj.e;
        m42Obj.f = m43Obj.g * m32Obj.b + m43Obj.h * m32Obj.d + m43Obj.i * m32Obj.f;
        m42Obj.g = m43Obj.j * m32Obj.a + m43Obj.k * m32Obj.c + m43Obj.l * m32Obj.e;
        m42Obj.h = m43Obj.j * m32Obj.b + m43Obj.k * m32Obj.d + m43Obj.l * m32Obj.f;
        this.m42Store.stack[this.m42Store.sp++] = m42Obj;
    }

    private final void mulM43M33() {
        M33Obj m33Obj = this.m33Store.stack[--this.m33Store.sp];
        M43Obj m43Obj = this.m43Store.stack[--this.m43Store.sp];
        M43Obj m43Obj2 = this.m43Store.heap[this.m43Store.hp++];
        m43Obj2.a = m43Obj.a * m33Obj.a + m43Obj.b * m33Obj.d + m43Obj.c * m33Obj.g;
        m43Obj2.b = m43Obj.a * m33Obj.b + m43Obj.b * m33Obj.e + m43Obj.c * m33Obj.h;
        m43Obj2.c = m43Obj.a * m33Obj.c + m43Obj.b * m33Obj.f + m43Obj.c * m33Obj.i;
        m43Obj2.d = m43Obj.d * m33Obj.a + m43Obj.e * m33Obj.d + m43Obj.f * m33Obj.g;
        m43Obj2.e = m43Obj.d * m33Obj.b + m43Obj.e * m33Obj.e + m43Obj.f * m33Obj.h;
        m43Obj2.f = m43Obj.d * m33Obj.c + m43Obj.e * m33Obj.f + m43Obj.f * m33Obj.i;
        m43Obj2.g = m43Obj.g * m33Obj.a + m43Obj.h * m33Obj.d + m43Obj.i * m33Obj.g;
        m43Obj2.h = m43Obj.g * m33Obj.b + m43Obj.h * m33Obj.e + m43Obj.i * m33Obj.h;
        m43Obj2.i = m43Obj.g * m33Obj.c + m43Obj.h * m33Obj.f + m43Obj.i * m33Obj.i;
        m43Obj2.j = m43Obj.j * m33Obj.a + m43Obj.k * m33Obj.d + m43Obj.l * m33Obj.g;
        m43Obj2.k = m43Obj.j * m33Obj.b + m43Obj.k * m33Obj.e + m43Obj.l * m33Obj.h;
        m43Obj2.l = m43Obj.j * m33Obj.c + m43Obj.k * m33Obj.f + m43Obj.l * m33Obj.i;
        this.m43Store.stack[this.m43Store.sp++] = m43Obj2;
    }

    private final void mulM43M34() {
        M34Obj m34Obj = this.m34Store.stack[--this.m34Store.sp];
        M43Obj m43Obj = this.m43Store.stack[--this.m43Store.sp];
        M44Obj m44Obj = this.m44Store.heap[this.m44Store.hp++];
        m44Obj.a = m43Obj.a * m34Obj.a + m43Obj.b * m34Obj.e + m43Obj.c * m34Obj.i;
        m44Obj.b = m43Obj.a * m34Obj.b + m43Obj.b * m34Obj.f + m43Obj.c * m34Obj.j;
        m44Obj.c = m43Obj.a * m34Obj.c + m43Obj.b * m34Obj.g + m43Obj.c * m34Obj.k;
        m44Obj.d = m43Obj.a * m34Obj.d + m43Obj.b * m34Obj.h + m43Obj.c * m34Obj.l;
        m44Obj.e = m43Obj.d * m34Obj.a + m43Obj.e * m34Obj.e + m43Obj.f * m34Obj.i;
        m44Obj.f = m43Obj.d * m34Obj.b + m43Obj.e * m34Obj.f + m43Obj.f * m34Obj.j;
        m44Obj.g = m43Obj.d * m34Obj.c + m43Obj.e * m34Obj.g + m43Obj.f * m34Obj.k;
        m44Obj.h = m43Obj.d * m34Obj.d + m43Obj.e * m34Obj.h + m43Obj.f * m34Obj.l;
        m44Obj.i = m43Obj.g * m34Obj.a + m43Obj.h * m34Obj.e + m43Obj.i * m34Obj.i;
        m44Obj.j = m43Obj.g * m34Obj.b + m43Obj.h * m34Obj.f + m43Obj.i * m34Obj.j;
        m44Obj.k = m43Obj.g * m34Obj.c + m43Obj.h * m34Obj.g + m43Obj.i * m34Obj.k;
        m44Obj.l = m43Obj.g * m34Obj.d + m43Obj.h * m34Obj.h + m43Obj.i * m34Obj.l;
        m44Obj.m = m43Obj.j * m34Obj.a + m43Obj.k * m34Obj.e + m43Obj.l * m34Obj.i;
        m44Obj.n = m43Obj.j * m34Obj.b + m43Obj.k * m34Obj.f + m43Obj.l * m34Obj.j;
        m44Obj.o = m43Obj.j * m34Obj.c + m43Obj.k * m34Obj.g + m43Obj.l * m34Obj.k;
        m44Obj.p = m43Obj.j * m34Obj.d + m43Obj.k * m34Obj.h + m43Obj.l * m34Obj.l;
        this.m44Store.stack[this.m44Store.sp++] = m44Obj;
    }

    private final void mulM44M42() {
        M42Obj m42Obj = this.m42Store.stack[--this.m42Store.sp];
        M44Obj m44Obj = this.m44Store.stack[--this.m44Store.sp];
        M42Obj m42Obj2 = this.m42Store.heap[this.m42Store.hp++];
        m42Obj2.a = m44Obj.a * m42Obj.a + m44Obj.b * m42Obj.c + m44Obj.c * m42Obj.e + m44Obj.d * m42Obj.g;
        m42Obj2.b = m44Obj.a * m42Obj.b + m44Obj.b * m42Obj.d + m44Obj.c * m42Obj.f + m44Obj.d * m42Obj.h;
        m42Obj2.c = m44Obj.e * m42Obj.a + m44Obj.f * m42Obj.c + m44Obj.g * m42Obj.e + m44Obj.h * m42Obj.g;
        m42Obj2.d = m44Obj.e * m42Obj.b + m44Obj.f * m42Obj.d + m44Obj.g * m42Obj.f + m44Obj.h * m42Obj.h;
        m42Obj2.e = m44Obj.i * m42Obj.a + m44Obj.j * m42Obj.c + m44Obj.k * m42Obj.e + m44Obj.l * m42Obj.g;
        m42Obj2.f = m44Obj.i * m42Obj.b + m44Obj.j * m42Obj.d + m44Obj.k * m42Obj.f + m44Obj.l * m42Obj.h;
        m42Obj2.g = m44Obj.m * m42Obj.a + m44Obj.n * m42Obj.c + m44Obj.o * m42Obj.e + m44Obj.p * m42Obj.g;
        m42Obj2.h = m44Obj.m * m42Obj.b + m44Obj.n * m42Obj.d + m44Obj.o * m42Obj.f + m44Obj.p * m42Obj.h;
        this.m42Store.stack[this.m42Store.sp++] = m42Obj2;
    }

    private final void mulM44M43() {
        M43Obj m43Obj = this.m43Store.stack[--this.m43Store.sp];
        M44Obj m44Obj = this.m44Store.stack[--this.m44Store.sp];
        M43Obj m43Obj2 = this.m43Store.heap[this.m43Store.hp++];
        m43Obj2.a = m44Obj.a * m43Obj.a + m44Obj.b * m43Obj.d + m44Obj.c * m43Obj.g + m44Obj.d * m43Obj.j;
        m43Obj2.b = m44Obj.a * m43Obj.b + m44Obj.b * m43Obj.e + m44Obj.c * m43Obj.h + m44Obj.d * m43Obj.k;
        m43Obj2.c = m44Obj.a * m43Obj.c + m44Obj.b * m43Obj.f + m44Obj.c * m43Obj.i + m44Obj.d * m43Obj.l;
        m43Obj2.d = m44Obj.e * m43Obj.a + m44Obj.f * m43Obj.d + m44Obj.g * m43Obj.g + m44Obj.h * m43Obj.j;
        m43Obj2.e = m44Obj.e * m43Obj.b + m44Obj.f * m43Obj.e + m44Obj.g * m43Obj.h + m44Obj.h * m43Obj.k;
        m43Obj2.f = m44Obj.e * m43Obj.c + m44Obj.f * m43Obj.f + m44Obj.g * m43Obj.i + m44Obj.h * m43Obj.l;
        m43Obj2.g = m44Obj.i * m43Obj.a + m44Obj.j * m43Obj.d + m44Obj.k * m43Obj.g + m44Obj.l * m43Obj.j;
        m43Obj2.h = m44Obj.i * m43Obj.b + m44Obj.j * m43Obj.e + m44Obj.k * m43Obj.h + m44Obj.l * m43Obj.k;
        m43Obj2.i = m44Obj.i * m43Obj.c + m44Obj.j * m43Obj.f + m44Obj.k * m43Obj.i + m44Obj.l * m43Obj.l;
        m43Obj2.j = m44Obj.m * m43Obj.a + m44Obj.n * m43Obj.d + m44Obj.o * m43Obj.g + m44Obj.p * m43Obj.j;
        m43Obj2.k = m44Obj.m * m43Obj.b + m44Obj.n * m43Obj.e + m44Obj.o * m43Obj.h + m44Obj.p * m43Obj.k;
        m43Obj2.l = m44Obj.m * m43Obj.c + m44Obj.n * m43Obj.f + m44Obj.o * m43Obj.i + m44Obj.p * m43Obj.l;
        this.m43Store.stack[this.m43Store.sp++] = m43Obj2;
    }

    private final void mulM44M44() {
        M44Obj m44Obj = this.m44Store.stack[--this.m44Store.sp];
        M44Obj m44Obj2 = this.m44Store.stack[--this.m44Store.sp];
        M44Obj m44Obj3 = this.m44Store.heap[this.m44Store.hp++];
        m44Obj3.a = m44Obj2.a * m44Obj.a + m44Obj2.b * m44Obj.e + m44Obj2.c * m44Obj.i + m44Obj2.d * m44Obj.m;
        m44Obj3.b = m44Obj2.a * m44Obj.b + m44Obj2.b * m44Obj.f + m44Obj2.c * m44Obj.j + m44Obj2.d * m44Obj.n;
        m44Obj3.c = m44Obj2.a * m44Obj.c + m44Obj2.b * m44Obj.g + m44Obj2.c * m44Obj.k + m44Obj2.d * m44Obj.o;
        m44Obj3.d = m44Obj2.a * m44Obj.d + m44Obj2.b * m44Obj.h + m44Obj2.c * m44Obj.l + m44Obj2.d * m44Obj.p;
        m44Obj3.e = m44Obj2.e * m44Obj.a + m44Obj2.f * m44Obj.e + m44Obj2.g * m44Obj.i + m44Obj2.h * m44Obj.m;
        m44Obj3.f = m44Obj2.e * m44Obj.b + m44Obj2.f * m44Obj.f + m44Obj2.g * m44Obj.j + m44Obj2.h * m44Obj.n;
        m44Obj3.g = m44Obj2.e * m44Obj.c + m44Obj2.f * m44Obj.g + m44Obj2.g * m44Obj.k + m44Obj2.h * m44Obj.o;
        m44Obj3.h = m44Obj2.e * m44Obj.d + m44Obj2.f * m44Obj.h + m44Obj2.g * m44Obj.l + m44Obj2.h * m44Obj.p;
        m44Obj3.i = m44Obj2.i * m44Obj.a + m44Obj2.j * m44Obj.e + m44Obj2.k * m44Obj.i + m44Obj2.l * m44Obj.m;
        m44Obj3.j = m44Obj2.i * m44Obj.b + m44Obj2.j * m44Obj.f + m44Obj2.k * m44Obj.j + m44Obj2.l * m44Obj.n;
        m44Obj3.k = m44Obj2.i * m44Obj.c + m44Obj2.j * m44Obj.g + m44Obj2.k * m44Obj.k + m44Obj2.l * m44Obj.o;
        m44Obj3.l = m44Obj2.i * m44Obj.d + m44Obj2.j * m44Obj.h + m44Obj2.k * m44Obj.l + m44Obj2.l * m44Obj.p;
        m44Obj3.m = m44Obj2.m * m44Obj.a + m44Obj2.n * m44Obj.e + m44Obj2.o * m44Obj.i + m44Obj2.p * m44Obj.m;
        m44Obj3.n = m44Obj2.m * m44Obj.b + m44Obj2.n * m44Obj.f + m44Obj2.o * m44Obj.j + m44Obj2.p * m44Obj.n;
        m44Obj3.o = m44Obj2.m * m44Obj.c + m44Obj2.n * m44Obj.g + m44Obj2.o * m44Obj.k + m44Obj2.p * m44Obj.o;
        m44Obj3.p = m44Obj2.m * m44Obj.d + m44Obj2.n * m44Obj.h + m44Obj2.o * m44Obj.l + m44Obj2.p * m44Obj.p;
        this.m44Store.stack[this.m44Store.sp++] = m44Obj3;
    }

    private final void mulVnMnn(VecObj vecObj, MatObj matObj) {
        double[] dArray = vecObj.toArrayVec();
        double[][] dArray2 = matObj.toArrayMat();
        int n = dArray2.length;
        int n2 = dArray2[0].length;
        double[] dArray3 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            double d = dArray[0] * dArray2[0][i];
            for (int j = 1; j < n; ++j) {
                d += dArray[j] * dArray2[j][i];
            }
            dArray3[i] = d;
        }
        this.pushVec(dArray3);
    }

    private final void mulMnnVn(MatObj matObj, VecObj vecObj) {
        double[][] dArray = matObj.toArrayMat();
        double[] dArray2 = vecObj.toArrayVec();
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = dArray[i][0] * dArray2[0];
            for (int j = 1; j < n2; ++j) {
                d += dArray[i][j] * dArray2[j];
            }
            dArray3[i] = d;
        }
        this.pushVec(dArray3);
    }

    private final void mulMnnMnn(MatObj matObj, MatObj matObj2) {
        double[][] dArray = matObj.toArrayMat();
        double[][] dArray2 = matObj2.toArrayMat();
        int n = dArray.length;
        int n2 = dArray2.length;
        int n3 = dArray2[0].length;
        double[][] dArray3 = new double[n][n3];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                double d = dArray[i][0] * dArray2[0][j];
                for (int k = 1; k < n2; ++k) {
                    d += dArray[i][k] * dArray2[k][j];
                }
                dArray3[i][j] = d;
            }
        }
        this.pushMat(dArray3);
    }

    private final void pushVec(double[] dArray) {
        switch (dArray.length) {
            case 2: {
                V2Obj v2Obj = this.v2Store.heap[this.v2Store.hp++];
                v2Obj.a = dArray[0];
                v2Obj.b = dArray[1];
                this.v2Store.stack[this.v2Store.sp++] = v2Obj;
                break;
            }
            case 3: {
                V3Obj v3Obj = this.v3Store.heap[this.v3Store.hp++];
                v3Obj.a = dArray[0];
                v3Obj.b = dArray[1];
                v3Obj.c = dArray[2];
                this.v3Store.stack[this.v3Store.sp++] = v3Obj;
                break;
            }
            case 4: {
                V4Obj v4Obj = this.v4Store.heap[this.v4Store.hp++];
                v4Obj.a = dArray[0];
                v4Obj.b = dArray[1];
                v4Obj.c = dArray[2];
                v4Obj.d = dArray[3];
                this.v4Store.stack[this.v4Store.sp++] = v4Obj;
                break;
            }
            default: {
                this.vnStore.stack[this.vnStore.sp++] = new VnObj(dArray);
            }
        }
    }

    private final void pushMat(double[][] dArray) {
        switch (dArray.length) {
            case 2: {
                switch (dArray[0].length) {
                    case 2: {
                        M22Obj m22Obj = this.m22Store.heap[this.m22Store.hp++];
                        m22Obj.a = dArray[0][0];
                        m22Obj.b = dArray[0][1];
                        m22Obj.c = dArray[1][0];
                        m22Obj.d = dArray[1][1];
                        this.m22Store.stack[this.m22Store.sp++] = m22Obj;
                        return;
                    }
                    case 3: {
                        M23Obj m23Obj = this.m23Store.heap[this.m23Store.hp++];
                        m23Obj.a = dArray[0][0];
                        m23Obj.b = dArray[0][1];
                        m23Obj.c = dArray[0][2];
                        m23Obj.d = dArray[1][0];
                        m23Obj.e = dArray[1][1];
                        m23Obj.f = dArray[1][2];
                        this.m23Store.stack[this.m23Store.sp++] = m23Obj;
                        return;
                    }
                    case 4: {
                        M24Obj m24Obj = this.m24Store.heap[this.m24Store.hp++];
                        m24Obj.a = dArray[0][0];
                        m24Obj.b = dArray[0][1];
                        m24Obj.c = dArray[0][2];
                        m24Obj.d = dArray[0][3];
                        m24Obj.e = dArray[1][0];
                        m24Obj.f = dArray[1][1];
                        m24Obj.g = dArray[1][2];
                        m24Obj.h = dArray[1][3];
                        this.m24Store.stack[this.m24Store.sp++] = m24Obj;
                        return;
                    }
                }
                break;
            }
            case 3: {
                switch (dArray[0].length) {
                    case 2: {
                        M32Obj m32Obj = this.m32Store.heap[this.m32Store.hp++];
                        m32Obj.a = dArray[0][0];
                        m32Obj.b = dArray[0][1];
                        m32Obj.c = dArray[1][0];
                        m32Obj.d = dArray[1][1];
                        m32Obj.e = dArray[2][0];
                        m32Obj.f = dArray[2][1];
                        this.m32Store.stack[this.m32Store.sp++] = m32Obj;
                        return;
                    }
                    case 3: {
                        M33Obj m33Obj = this.m33Store.heap[this.m33Store.hp++];
                        m33Obj.a = dArray[0][0];
                        m33Obj.b = dArray[0][1];
                        m33Obj.c = dArray[0][2];
                        m33Obj.d = dArray[1][0];
                        m33Obj.e = dArray[1][1];
                        m33Obj.f = dArray[1][2];
                        m33Obj.g = dArray[2][0];
                        m33Obj.h = dArray[2][1];
                        m33Obj.i = dArray[2][2];
                        this.m33Store.stack[this.m33Store.sp++] = m33Obj;
                        return;
                    }
                    case 4: {
                        M34Obj m34Obj = this.m34Store.heap[this.m34Store.hp++];
                        m34Obj.a = dArray[0][0];
                        m34Obj.b = dArray[0][1];
                        m34Obj.c = dArray[0][2];
                        m34Obj.d = dArray[0][3];
                        m34Obj.e = dArray[1][0];
                        m34Obj.f = dArray[1][1];
                        m34Obj.g = dArray[1][2];
                        m34Obj.h = dArray[1][3];
                        m34Obj.i = dArray[2][0];
                        m34Obj.j = dArray[2][1];
                        m34Obj.k = dArray[2][2];
                        m34Obj.l = dArray[2][3];
                        this.m34Store.stack[this.m34Store.sp++] = m34Obj;
                        return;
                    }
                }
                break;
            }
            case 4: {
                switch (dArray[0].length) {
                    case 2: {
                        M42Obj m42Obj = this.m42Store.heap[this.m42Store.hp++];
                        m42Obj.a = dArray[0][0];
                        m42Obj.b = dArray[0][1];
                        m42Obj.c = dArray[1][0];
                        m42Obj.d = dArray[1][1];
                        m42Obj.e = dArray[2][0];
                        m42Obj.f = dArray[2][1];
                        m42Obj.g = dArray[3][0];
                        m42Obj.h = dArray[3][1];
                        this.m42Store.stack[this.m42Store.sp++] = m42Obj;
                        return;
                    }
                    case 3: {
                        M43Obj m43Obj = this.m43Store.heap[this.m43Store.hp++];
                        m43Obj.a = dArray[0][0];
                        m43Obj.b = dArray[0][1];
                        m43Obj.c = dArray[0][2];
                        m43Obj.d = dArray[1][0];
                        m43Obj.e = dArray[1][1];
                        m43Obj.f = dArray[1][2];
                        m43Obj.g = dArray[2][0];
                        m43Obj.h = dArray[2][1];
                        m43Obj.i = dArray[2][2];
                        m43Obj.j = dArray[3][0];
                        m43Obj.k = dArray[3][1];
                        m43Obj.l = dArray[3][2];
                        this.m43Store.stack[this.m43Store.sp++] = m43Obj;
                        return;
                    }
                    case 4: {
                        M44Obj m44Obj = this.m44Store.heap[this.m44Store.hp++];
                        m44Obj.a = dArray[0][0];
                        m44Obj.b = dArray[0][1];
                        m44Obj.c = dArray[0][2];
                        m44Obj.d = dArray[0][3];
                        m44Obj.e = dArray[1][0];
                        m44Obj.f = dArray[1][1];
                        m44Obj.g = dArray[1][2];
                        m44Obj.h = dArray[1][3];
                        m44Obj.i = dArray[2][0];
                        m44Obj.j = dArray[2][1];
                        m44Obj.k = dArray[2][2];
                        m44Obj.l = dArray[2][3];
                        m44Obj.m = dArray[3][0];
                        m44Obj.n = dArray[3][1];
                        m44Obj.o = dArray[3][2];
                        m44Obj.p = dArray[3][3];
                        this.m44Store.stack[this.m44Store.sp++] = m44Obj;
                        return;
                    }
                }
            }
        }
        this.mnnStore.stack[this.mnnStore.sp++] = new MnnObj(dArray);
    }

    private final void unitaryFunction(short s) {
        double d = this.scalerStore.stack[--this.scalerStore.sp];
        switch (s) {
            case 1: {
                d = Math.sin(d);
                break;
            }
            case 2: {
                d = Math.cos(d);
                break;
            }
            case 3: {
                d = Math.tan(d);
                break;
            }
            case 4: {
                d = Math.asin(d);
                break;
            }
            case 5: {
                d = Math.acos(d);
                break;
            }
            case 6: {
                d = Math.atan(d);
                break;
            }
            case 7: {
                d = (Math.exp(d) - Math.exp(-d)) / 2.0;
                break;
            }
            case 8: {
                d = (Math.exp(d) + Math.exp(-d)) / 2.0;
                break;
            }
            case 9: {
                double d2 = Math.exp(d * 2.0);
                d = (d2 - 1.0) / (d2 + 1.0);
                break;
            }
            case 10: {
                d = Math.log(d + Math.sqrt(1.0 + d * d));
                break;
            }
            case 11: {
                d = Math.log(d + Math.sqrt(d * d - 1.0));
                break;
            }
            case 12: {
                d = Math.log((1.0 + d) / (1.0 - d)) / 2.0;
                break;
            }
            case 13: {
                d = Math.abs(d);
                break;
            }
            case 14: {
                d = Math.exp(d);
                break;
            }
            case 15: {
                d = Math.log(d) / LOG10;
                break;
            }
            case 16: {
                d = Math.log(d);
                break;
            }
            case 17: {
                d = Math.sqrt(d);
                break;
            }
            case 18: {
                d = 1.0 / Math.cos(d);
                break;
            }
            case 19: {
                d = 1.0 / Math.sin(d);
                break;
            }
            case 20: {
                d = 1.0 / Math.tan(d);
            }
        }
        this.scalerStore.stack[this.scalerStore.sp++] = d;
    }

    public void cleanUp() {
        this.scalerStore.cleanUp();
        this.v2Store.cleanUp();
        this.v3Store.cleanUp();
        this.v4Store.cleanUp();
        this.vnStore.cleanUp();
        this.m22Store.cleanUp();
        this.m23Store.cleanUp();
        this.m24Store.cleanUp();
        this.m32Store.cleanUp();
        this.m33Store.cleanUp();
        this.m34Store.cleanUp();
        this.m42Store.cleanUp();
        this.m43Store.cleanUp();
        this.m44Store.cleanUp();
        this.mnnStore.cleanUp();
    }

    private final class MnnStore
    extends MatStore {
        MnnObj[] stack;
        MnnObj[] vars = new MnnObj[0];

        private MnnStore() {
        }

        final void alloc() {
            this.stack = new MnnObj[this.stackMax];
        }

        final void expandVarArray(MatrixVariableI matrixVariableI) {
            MnnObj[] mnnObjArray = new MnnObj[this.vars.length + 1];
            System.arraycopy(this.vars, 0, mnnObjArray, 0, this.vars.length);
            Dimensions dimensions = matrixVariableI.getDimensions();
            mnnObjArray[this.vars.length] = new MnnObj(dimensions.getFirstDim(), dimensions.getLastDim());
            this.vars = mnnObjArray;
        }

        final void copyVar(int n, Matrix matrix) {
            this.vars[n].fromMat(matrix);
        }

        final void add() {
            MnnObj mnnObj = this.stack[--this.sp];
            MnnObj mnnObj2 = this.stack[--this.sp];
            MnnObj mnnObj3 = new MnnObj(mnnObj2.rows, mnnObj2.cols);
            for (int i = 0; i < mnnObj2.rows; ++i) {
                for (int j = 0; j < mnnObj2.cols; ++j) {
                    mnnObj3.data[i][j] = mnnObj2.data[i][j] + mnnObj.data[i][j];
                }
            }
            this.stack[this.sp++] = mnnObj3;
        }

        final void sub() {
            MnnObj mnnObj = this.stack[--this.sp];
            MnnObj mnnObj2 = this.stack[--this.sp];
            MnnObj mnnObj3 = new MnnObj(mnnObj2.rows, mnnObj2.cols);
            for (int i = 0; i < mnnObj2.rows; ++i) {
                for (int j = 0; j < mnnObj2.cols; ++j) {
                    mnnObj3.data[i][j] = mnnObj2.data[i][j] - mnnObj.data[i][j];
                }
            }
            this.stack[this.sp++] = mnnObj3;
        }

        final void uminus() {
            MnnObj mnnObj = this.stack[--this.sp];
            MnnObj mnnObj2 = new MnnObj(mnnObj.rows, mnnObj.cols);
            for (int i = 0; i < mnnObj.rows; ++i) {
                for (int j = 0; j < mnnObj.cols; ++j) {
                    mnnObj2.data[i][j] = -mnnObj.data[i][j];
                }
            }
            this.stack[this.sp++] = mnnObj2;
        }

        final void mulS() {
            MnnObj mnnObj = this.stack[--this.sp];
            double d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            MnnObj mnnObj2 = new MnnObj(mnnObj.rows, mnnObj.cols);
            for (int i = 0; i < mnnObj.rows; ++i) {
                for (int j = 0; j < mnnObj.cols; ++j) {
                    mnnObj2.data[i][j] = d * mnnObj.data[i][j];
                }
            }
            this.stack[this.sp++] = mnnObj2;
        }

        final void divS() {
            MnnObj mnnObj = this.stack[--this.sp];
            double d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            MnnObj mnnObj2 = new MnnObj(mnnObj.rows, mnnObj.cols);
            for (int i = 0; i < mnnObj.rows; ++i) {
                for (int j = 0; j < mnnObj.cols; ++j) {
                    mnnObj2.data[i][j] = mnnObj.data[i][j] / d;
                }
            }
            this.stack[this.sp++] = mnnObj2;
        }

        final void makeList(int n, int n2) {
            MnnObj mnnObj = new MnnObj(n, n2);
            for (int i = n - 1; i >= 0; --i) {
                for (int j = n2 - 1; j >= 0; --j) {
                    mnnObj.data[i][j] = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
                }
            }
            this.stack[this.sp++] = mnnObj;
        }

        final void makeList() {
            throw new UnsupportedOperationException("VnObj: makeList cannot be called with no arguments");
        }

        final void assign(int n) {
            MnnObj mnnObj = this.stack[this.sp - 1];
            MnnObj mnnObj2 = this.vars[n];
            for (int i = 0; i < mnnObj.rows; ++i) {
                for (int j = 0; j < mnnObj.cols; ++j) {
                    mnnObj2.data[i][j] = mnnObj.data[i][j];
                }
            }
        }

        final void eq() {
            MnnObj mnnObj = this.stack[--this.sp];
            MnnObj mnnObj2 = this.stack[--this.sp];
            for (int i = 0; i < mnnObj.rows; ++i) {
                for (int j = 0; j < mnnObj.cols; ++j) {
                    if (mnnObj2.data[i][j] == mnnObj.data[i][j]) continue;
                    MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = 0.0;
                    return;
                }
            }
            MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = 1.0;
        }
    }

    private static final class MnnObj
    extends MatObj {
        double[][] data;
        int rows;
        int cols;

        MnnObj(int n, int n2) {
            this.data = new double[n][n2];
            this.rows = n;
            this.cols = n2;
        }

        MnnObj(double[][] dArray) {
            this.data = dArray;
            this.rows = dArray.length;
            this.cols = dArray[0].length;
        }

        public Dimensions getDims() {
            return Dimensions.valueOf(this.rows, this.cols);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("[");
            for (int i = 0; i < this.rows; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append('[');
                for (int j = 0; j < this.cols; ++j) {
                    if (j > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(this.data[i][j]);
                }
                stringBuffer.append(']');
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }

        public void fromMat(Matrix matrix) {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.cols; ++j) {
                    this.data[i][j] = (Double)matrix.getEle(i, j);
                }
            }
        }

        public void copyToMat(Matrix matrix) {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.cols; ++j) {
                    matrix.setEle(i, j, new Double(this.data[i][j]));
                }
            }
        }

        double[][] toArrayMat() {
            return this.data;
        }

        public Object toArray() {
            double[][] dArray = new double[this.rows][this.cols];
            for (int i = 0; i < this.rows; ++i) {
                System.arraycopy(this.data[i], 0, dArray[i], 0, this.cols);
            }
            return dArray;
        }
    }

    private final class M44Store
    extends MatStore {
        M44Obj[] stack;
        M44Obj[] heap;
        M44Obj[] vars = new M44Obj[0];

        private M44Store() {
        }

        final void alloc() {
            int n;
            this.heap = new M44Obj[this.hp];
            for (n = 0; n < this.hp; ++n) {
                this.heap[n] = new M44Obj();
            }
            this.stack = new M44Obj[this.stackMax];
            for (n = 0; n < this.stackMax; ++n) {
                this.stack[n] = new M44Obj();
            }
            M44Obj[] m44ObjArray = new M44Obj[this.varRefs.size()];
            System.arraycopy(this.vars, 0, m44ObjArray, 0, this.vars.length);
            for (int i = this.vars.length; i < this.varRefs.size(); ++i) {
                m44ObjArray[i] = new M44Obj();
            }
            this.vars = m44ObjArray;
        }

        final void expandVarArray(MatrixVariableI matrixVariableI) {
            M44Obj[] m44ObjArray = new M44Obj[this.vars.length + 1];
            System.arraycopy(this.vars, 0, m44ObjArray, 0, this.vars.length);
            m44ObjArray[this.vars.length] = new M44Obj();
            this.vars = m44ObjArray;
        }

        final void copyVar(int n, Matrix matrix) {
            this.vars[n].fromMat(matrix);
        }

        final void add() {
            M44Obj m44Obj = this.stack[--this.sp];
            M44Obj m44Obj2 = this.stack[--this.sp];
            M44Obj m44Obj3 = this.heap[this.hp++];
            m44Obj3.a = m44Obj2.a + m44Obj.a;
            m44Obj3.b = m44Obj2.b + m44Obj.b;
            m44Obj3.c = m44Obj2.c + m44Obj.c;
            m44Obj3.d = m44Obj2.d + m44Obj.d;
            m44Obj3.e = m44Obj2.e + m44Obj.e;
            m44Obj3.f = m44Obj2.f + m44Obj.f;
            m44Obj3.g = m44Obj2.g + m44Obj.g;
            m44Obj3.h = m44Obj2.h + m44Obj.h;
            m44Obj3.i = m44Obj2.i + m44Obj.i;
            m44Obj3.j = m44Obj2.j + m44Obj.j;
            m44Obj3.k = m44Obj2.k + m44Obj.k;
            m44Obj3.l = m44Obj2.l + m44Obj.l;
            m44Obj3.m = m44Obj2.m + m44Obj.m;
            m44Obj3.n = m44Obj2.n + m44Obj.n;
            m44Obj3.o = m44Obj2.o + m44Obj.o;
            m44Obj3.p = m44Obj2.p + m44Obj.p;
            this.stack[this.sp++] = m44Obj3;
        }

        final void sub() {
            M44Obj m44Obj = this.stack[--this.sp];
            M44Obj m44Obj2 = this.stack[--this.sp];
            M44Obj m44Obj3 = this.heap[this.hp++];
            m44Obj3.a = m44Obj2.a - m44Obj.a;
            m44Obj3.b = m44Obj2.b - m44Obj.b;
            m44Obj3.c = m44Obj2.c - m44Obj.c;
            m44Obj3.d = m44Obj2.d - m44Obj.d;
            m44Obj3.e = m44Obj2.e - m44Obj.e;
            m44Obj3.f = m44Obj2.f - m44Obj.f;
            m44Obj3.g = m44Obj2.g - m44Obj.g;
            m44Obj3.h = m44Obj2.h - m44Obj.h;
            m44Obj3.i = m44Obj2.i - m44Obj.i;
            m44Obj3.j = m44Obj2.j - m44Obj.j;
            m44Obj3.k = m44Obj2.k - m44Obj.k;
            m44Obj3.l = m44Obj2.l - m44Obj.l;
            m44Obj3.m = m44Obj2.m - m44Obj.m;
            m44Obj3.n = m44Obj2.n - m44Obj.n;
            m44Obj3.o = m44Obj2.o - m44Obj.o;
            m44Obj3.p = m44Obj2.p - m44Obj.p;
            this.stack[this.sp++] = m44Obj3;
        }

        final void uminus() {
            M44Obj m44Obj = this.stack[--this.sp];
            M44Obj m44Obj2 = this.heap[this.hp++];
            m44Obj2.a = -m44Obj.a;
            m44Obj2.b = -m44Obj.b;
            m44Obj2.c = -m44Obj.c;
            m44Obj2.d = -m44Obj.d;
            m44Obj2.e = -m44Obj.e;
            m44Obj2.f = -m44Obj.f;
            m44Obj2.g = -m44Obj.g;
            m44Obj2.h = -m44Obj.h;
            m44Obj2.i = -m44Obj.i;
            m44Obj2.j = -m44Obj.j;
            m44Obj2.k = -m44Obj.k;
            m44Obj2.l = -m44Obj.l;
            m44Obj2.m = -m44Obj.m;
            m44Obj2.n = -m44Obj.n;
            m44Obj2.o = -m44Obj.o;
            m44Obj2.p = -m44Obj.p;
            this.stack[this.sp++] = m44Obj2;
        }

        final void mulS() {
            M44Obj m44Obj = this.stack[--this.sp];
            double d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M44Obj m44Obj2 = this.heap[this.hp++];
            m44Obj2.a = d * m44Obj.a;
            m44Obj2.b = d * m44Obj.b;
            m44Obj2.c = d * m44Obj.c;
            m44Obj2.d = d * m44Obj.d;
            m44Obj2.e = d * m44Obj.e;
            m44Obj2.f = d * m44Obj.f;
            m44Obj2.g = d * m44Obj.g;
            m44Obj2.h = d * m44Obj.h;
            m44Obj2.i = d * m44Obj.i;
            m44Obj2.j = d * m44Obj.j;
            m44Obj2.k = d * m44Obj.k;
            m44Obj2.l = d * m44Obj.l;
            m44Obj2.m = d * m44Obj.m;
            m44Obj2.n = d * m44Obj.n;
            m44Obj2.o = d * m44Obj.o;
            m44Obj2.p = d * m44Obj.p;
            this.stack[this.sp++] = m44Obj2;
        }

        final void divS() {
            M44Obj m44Obj = this.stack[--this.sp];
            double d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M44Obj m44Obj2 = this.heap[this.hp++];
            m44Obj2.a = m44Obj.a / d;
            m44Obj2.b = m44Obj.b / d;
            m44Obj2.c = m44Obj.c / d;
            m44Obj2.d = m44Obj.d / d;
            m44Obj2.e = m44Obj.e / d;
            m44Obj2.f = m44Obj.f / d;
            m44Obj2.g = m44Obj.g / d;
            m44Obj2.h = m44Obj.h / d;
            m44Obj2.i = m44Obj.i / d;
            m44Obj2.j = m44Obj.j / d;
            m44Obj2.k = m44Obj.k / d;
            m44Obj2.l = m44Obj.l / d;
            m44Obj2.m = m44Obj.m / d;
            m44Obj2.n = m44Obj.n / d;
            m44Obj2.o = m44Obj.o / d;
            m44Obj2.p = m44Obj.p / d;
            this.stack[this.sp++] = m44Obj2;
        }

        final void makeList() {
            M44Obj m44Obj = this.heap[this.hp++];
            m44Obj.p = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m44Obj.o = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m44Obj.n = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m44Obj.m = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m44Obj.l = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m44Obj.k = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m44Obj.j = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m44Obj.i = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m44Obj.h = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m44Obj.g = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m44Obj.f = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m44Obj.e = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m44Obj.d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m44Obj.c = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m44Obj.b = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m44Obj.a = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            this.stack[this.sp++] = m44Obj;
        }

        final void assign(int n) {
            M44Obj m44Obj = this.stack[this.sp - 1];
            M44Obj m44Obj2 = this.vars[n];
            m44Obj2.a = m44Obj.a;
            m44Obj2.b = m44Obj.b;
            m44Obj2.c = m44Obj.c;
            m44Obj2.d = m44Obj.d;
            m44Obj2.e = m44Obj.e;
            m44Obj2.f = m44Obj.f;
            m44Obj2.g = m44Obj.g;
            m44Obj2.h = m44Obj.h;
            m44Obj2.i = m44Obj.i;
            m44Obj2.j = m44Obj.j;
            m44Obj2.k = m44Obj.k;
            m44Obj2.l = m44Obj.l;
            m44Obj2.m = m44Obj.m;
            m44Obj2.n = m44Obj.n;
            m44Obj2.o = m44Obj.o;
            m44Obj2.p = m44Obj.p;
        }

        final void eq() {
            M44Obj m44Obj = this.stack[--this.sp];
            M44Obj m44Obj2 = this.stack[--this.sp];
            MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = m44Obj2.a == m44Obj.a && m44Obj2.b == m44Obj.b && m44Obj2.c == m44Obj.c && m44Obj2.d == m44Obj.d && m44Obj2.e == m44Obj.e && m44Obj2.f == m44Obj.f && m44Obj2.g == m44Obj.g && m44Obj2.h == m44Obj.h && m44Obj2.i == m44Obj.i && m44Obj2.j == m44Obj.j && m44Obj2.k == m44Obj.k && m44Obj2.l == m44Obj.l && m44Obj2.m == m44Obj.m && m44Obj2.n == m44Obj.n && m44Obj2.o == m44Obj.o && m44Obj2.p == m44Obj.p ? 1.0 : 0.0;
        }
    }

    private static final class M44Obj
    extends MatObj {
        double a;
        double b;
        double c;
        double d;
        double e;
        double f;
        double g;
        double h;
        double i;
        double j;
        double k;
        double l;
        double m;
        double n;
        double o;
        double p;
        private static Dimensions dims = Dimensions.valueOf(4, 4);

        private M44Obj() {
        }

        public Dimensions getDims() {
            return dims;
        }

        public void copyToMat(Matrix matrix) {
            matrix.setEle(0, 0, new Double(this.a));
            matrix.setEle(0, 1, new Double(this.b));
            matrix.setEle(0, 2, new Double(this.c));
            matrix.setEle(0, 3, new Double(this.d));
            matrix.setEle(1, 0, new Double(this.e));
            matrix.setEle(1, 1, new Double(this.f));
            matrix.setEle(1, 2, new Double(this.g));
            matrix.setEle(1, 3, new Double(this.h));
            matrix.setEle(2, 0, new Double(this.i));
            matrix.setEle(2, 1, new Double(this.j));
            matrix.setEle(2, 2, new Double(this.k));
            matrix.setEle(2, 3, new Double(this.l));
            matrix.setEle(3, 0, new Double(this.m));
            matrix.setEle(3, 1, new Double(this.n));
            matrix.setEle(3, 2, new Double(this.o));
            matrix.setEle(3, 3, new Double(this.p));
        }

        public String toString() {
            return "[[" + this.a + "," + this.b + "," + this.c + "," + this.d + "]," + "[" + this.e + "," + this.f + "," + this.g + "," + this.h + "]," + "[" + this.i + "," + this.j + "," + this.k + "," + this.l + "]," + "[" + this.m + "," + this.n + "," + this.o + "," + this.p + "]]";
        }

        final void fromMat(Matrix matrix) {
            this.a = (Double)matrix.getEle(0, 0);
            this.b = (Double)matrix.getEle(0, 1);
            this.c = (Double)matrix.getEle(0, 2);
            this.d = (Double)matrix.getEle(0, 3);
            this.e = (Double)matrix.getEle(1, 0);
            this.f = (Double)matrix.getEle(1, 1);
            this.g = (Double)matrix.getEle(1, 2);
            this.h = (Double)matrix.getEle(1, 3);
            this.i = (Double)matrix.getEle(2, 0);
            this.j = (Double)matrix.getEle(2, 1);
            this.k = (Double)matrix.getEle(2, 2);
            this.l = (Double)matrix.getEle(2, 3);
            this.m = (Double)matrix.getEle(3, 0);
            this.n = (Double)matrix.getEle(3, 1);
            this.o = (Double)matrix.getEle(3, 2);
            this.p = (Double)matrix.getEle(3, 3);
        }

        public double[][] toArrayMat() {
            return new double[][]{{this.a, this.b, this.c, this.d}, {this.e, this.f, this.g, this.h}, {this.i, this.j, this.k, this.l}, {this.m, this.n, this.o, this.p}};
        }
    }

    private final class M43Store
    extends MatStore {
        M43Obj[] stack;
        M43Obj[] heap;
        M43Obj[] vars = new M43Obj[0];

        private M43Store() {
        }

        final void alloc() {
            int n;
            this.heap = new M43Obj[this.hp];
            for (n = 0; n < this.hp; ++n) {
                this.heap[n] = new M43Obj();
            }
            this.stack = new M43Obj[this.stackMax];
            for (n = 0; n < this.stackMax; ++n) {
                this.stack[n] = new M43Obj();
            }
        }

        final void expandVarArray(MatrixVariableI matrixVariableI) {
            M43Obj[] m43ObjArray = new M43Obj[this.vars.length + 1];
            System.arraycopy(this.vars, 0, m43ObjArray, 0, this.vars.length);
            m43ObjArray[this.vars.length] = new M43Obj();
            this.vars = m43ObjArray;
        }

        final void copyVar(int n, Matrix matrix) {
            this.vars[n].fromMat(matrix);
        }

        final void add() {
            M43Obj m43Obj = this.stack[--this.sp];
            M43Obj m43Obj2 = this.stack[--this.sp];
            M43Obj m43Obj3 = this.heap[this.hp++];
            m43Obj3.a = m43Obj2.a + m43Obj.a;
            m43Obj3.b = m43Obj2.b + m43Obj.b;
            m43Obj3.c = m43Obj2.c + m43Obj.c;
            m43Obj3.d = m43Obj2.d + m43Obj.d;
            m43Obj3.e = m43Obj2.e + m43Obj.e;
            m43Obj3.f = m43Obj2.f + m43Obj.f;
            m43Obj3.g = m43Obj2.g + m43Obj.g;
            m43Obj3.h = m43Obj2.h + m43Obj.h;
            m43Obj3.i = m43Obj2.i + m43Obj.i;
            m43Obj3.j = m43Obj2.j + m43Obj.j;
            m43Obj3.k = m43Obj2.k + m43Obj.k;
            m43Obj3.l = m43Obj2.l + m43Obj.l;
            this.stack[this.sp++] = m43Obj3;
        }

        final void sub() {
            M43Obj m43Obj = this.stack[--this.sp];
            M43Obj m43Obj2 = this.stack[--this.sp];
            M43Obj m43Obj3 = this.heap[this.hp++];
            m43Obj3.a = m43Obj2.a - m43Obj.a;
            m43Obj3.b = m43Obj2.b - m43Obj.b;
            m43Obj3.c = m43Obj2.c - m43Obj.c;
            m43Obj3.d = m43Obj2.d - m43Obj.d;
            m43Obj3.e = m43Obj2.e - m43Obj.e;
            m43Obj3.f = m43Obj2.f - m43Obj.f;
            m43Obj3.g = m43Obj2.g - m43Obj.g;
            m43Obj3.h = m43Obj2.h - m43Obj.h;
            m43Obj3.i = m43Obj2.i - m43Obj.i;
            m43Obj3.j = m43Obj2.j - m43Obj.j;
            m43Obj3.k = m43Obj2.k - m43Obj.k;
            m43Obj3.l = m43Obj2.l - m43Obj.l;
            this.stack[this.sp++] = m43Obj3;
        }

        final void uminus() {
            M43Obj m43Obj = this.stack[--this.sp];
            M43Obj m43Obj2 = this.heap[this.hp++];
            m43Obj2.a = -m43Obj.a;
            m43Obj2.b = -m43Obj.b;
            m43Obj2.c = -m43Obj.c;
            m43Obj2.d = -m43Obj.d;
            m43Obj2.e = -m43Obj.e;
            m43Obj2.f = -m43Obj.f;
            m43Obj2.g = -m43Obj.g;
            m43Obj2.h = -m43Obj.h;
            m43Obj2.i = -m43Obj.i;
            m43Obj2.j = -m43Obj.j;
            m43Obj2.k = -m43Obj.k;
            m43Obj2.l = -m43Obj.l;
            this.stack[this.sp++] = m43Obj2;
        }

        final void mulS() {
            M43Obj m43Obj = this.stack[--this.sp];
            double d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M43Obj m43Obj2 = this.heap[this.hp++];
            m43Obj2.a = d * m43Obj.a;
            m43Obj2.b = d * m43Obj.b;
            m43Obj2.c = d * m43Obj.c;
            m43Obj2.d = d * m43Obj.d;
            m43Obj2.e = d * m43Obj.e;
            m43Obj2.f = d * m43Obj.f;
            m43Obj2.g = d * m43Obj.g;
            m43Obj2.h = d * m43Obj.h;
            m43Obj2.i = d * m43Obj.i;
            m43Obj2.j = d * m43Obj.j;
            m43Obj2.k = d * m43Obj.k;
            m43Obj2.l = d * m43Obj.l;
            this.stack[this.sp++] = m43Obj2;
        }

        final void divS() {
            M43Obj m43Obj = this.stack[--this.sp];
            double d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M43Obj m43Obj2 = this.heap[this.hp++];
            m43Obj2.a = m43Obj.a / d;
            m43Obj2.b = m43Obj.b / d;
            m43Obj2.c = m43Obj.c / d;
            m43Obj2.d = m43Obj.d / d;
            m43Obj2.e = m43Obj.e / d;
            m43Obj2.f = m43Obj.f / d;
            m43Obj2.g = m43Obj.g / d;
            m43Obj2.h = m43Obj.h / d;
            m43Obj2.i = m43Obj.i / d;
            m43Obj2.j = m43Obj.j / d;
            m43Obj2.k = m43Obj.k / d;
            m43Obj2.l = m43Obj.l / d;
            this.stack[this.sp++] = m43Obj2;
        }

        final void makeList() {
            M43Obj m43Obj = this.heap[this.hp++];
            m43Obj.l = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m43Obj.k = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m43Obj.j = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m43Obj.i = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m43Obj.h = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m43Obj.g = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m43Obj.f = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m43Obj.e = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m43Obj.d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m43Obj.c = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m43Obj.b = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m43Obj.a = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            this.stack[this.sp++] = m43Obj;
        }

        final void assign(int n) {
            M43Obj m43Obj = this.stack[this.sp - 1];
            M43Obj m43Obj2 = this.vars[n];
            m43Obj2.a = m43Obj.a;
            m43Obj2.b = m43Obj.b;
            m43Obj2.c = m43Obj.c;
            m43Obj2.d = m43Obj.d;
            m43Obj2.e = m43Obj.e;
            m43Obj2.f = m43Obj.f;
            m43Obj2.g = m43Obj.g;
            m43Obj2.h = m43Obj.h;
            m43Obj2.i = m43Obj.i;
            m43Obj2.j = m43Obj.j;
            m43Obj2.k = m43Obj.k;
            m43Obj2.l = m43Obj.l;
        }

        final void eq() {
            M43Obj m43Obj = this.stack[--this.sp];
            M43Obj m43Obj2 = this.stack[--this.sp];
            MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = m43Obj2.a == m43Obj.a && m43Obj2.b == m43Obj.b && m43Obj2.c == m43Obj.c && m43Obj2.d == m43Obj.d && m43Obj2.e == m43Obj.e && m43Obj2.f == m43Obj.f && m43Obj2.g == m43Obj.g && m43Obj2.h == m43Obj.h && m43Obj2.i == m43Obj.i && m43Obj2.j == m43Obj.j && m43Obj2.k == m43Obj.k && m43Obj2.l == m43Obj.l ? 1.0 : 0.0;
        }
    }

    private static final class M43Obj
    extends MatObj {
        double a;
        double b;
        double c;
        double d;
        double e;
        double f;
        double g;
        double h;
        double i;
        double j;
        double k;
        double l;
        private static Dimensions dims = Dimensions.valueOf(4, 3);

        private M43Obj() {
        }

        public Dimensions getDims() {
            return dims;
        }

        public void copyToMat(Matrix matrix) {
            matrix.setEle(0, 0, new Double(this.a));
            matrix.setEle(0, 1, new Double(this.b));
            matrix.setEle(0, 2, new Double(this.c));
            matrix.setEle(1, 0, new Double(this.d));
            matrix.setEle(1, 1, new Double(this.e));
            matrix.setEle(1, 2, new Double(this.f));
            matrix.setEle(2, 0, new Double(this.g));
            matrix.setEle(2, 1, new Double(this.h));
            matrix.setEle(2, 2, new Double(this.i));
            matrix.setEle(3, 0, new Double(this.j));
            matrix.setEle(3, 1, new Double(this.k));
            matrix.setEle(3, 2, new Double(this.l));
        }

        public String toString() {
            return "[[" + this.a + "," + this.b + "," + this.c + "]," + "[" + this.d + "," + this.e + "," + this.f + "]," + "[" + this.g + "," + this.h + "," + this.i + "]," + "[" + this.j + "," + this.k + "," + this.l + "]]";
        }

        final void fromMat(Matrix matrix) {
            this.a = (Double)matrix.getEle(0, 0);
            this.b = (Double)matrix.getEle(0, 1);
            this.c = (Double)matrix.getEle(0, 2);
            this.d = (Double)matrix.getEle(1, 0);
            this.e = (Double)matrix.getEle(1, 1);
            this.f = (Double)matrix.getEle(1, 2);
            this.g = (Double)matrix.getEle(2, 0);
            this.h = (Double)matrix.getEle(2, 1);
            this.i = (Double)matrix.getEle(2, 2);
            this.j = (Double)matrix.getEle(3, 0);
            this.k = (Double)matrix.getEle(3, 1);
            this.l = (Double)matrix.getEle(3, 2);
        }

        public double[][] toArrayMat() {
            return new double[][]{{this.a, this.b, this.c}, {this.d, this.e, this.f}, {this.g, this.h, this.i}, {this.j, this.k, this.l}};
        }
    }

    private final class M42Store
    extends MatStore {
        M42Obj[] stack;
        M42Obj[] heap;
        M42Obj[] vars = new M42Obj[0];

        private M42Store() {
        }

        final void alloc() {
            int n;
            this.heap = new M42Obj[this.hp];
            for (n = 0; n < this.hp; ++n) {
                this.heap[n] = new M42Obj();
            }
            this.stack = new M42Obj[this.stackMax];
            for (n = 0; n < this.stackMax; ++n) {
                this.stack[n] = new M42Obj();
            }
        }

        final void expandVarArray(MatrixVariableI matrixVariableI) {
            M42Obj[] m42ObjArray = new M42Obj[this.vars.length + 1];
            System.arraycopy(this.vars, 0, m42ObjArray, 0, this.vars.length);
            m42ObjArray[this.vars.length] = new M42Obj();
            this.vars = m42ObjArray;
        }

        final void copyVar(int n, Matrix matrix) {
            this.vars[n].fromMat(matrix);
        }

        final void add() {
            M42Obj m42Obj = this.stack[--this.sp];
            M42Obj m42Obj2 = this.stack[--this.sp];
            M42Obj m42Obj3 = this.heap[this.hp++];
            m42Obj3.a = m42Obj2.a + m42Obj.a;
            m42Obj3.b = m42Obj2.b + m42Obj.b;
            m42Obj3.c = m42Obj2.c + m42Obj.c;
            m42Obj3.d = m42Obj2.d + m42Obj.d;
            m42Obj3.e = m42Obj2.e + m42Obj.e;
            m42Obj3.f = m42Obj2.f + m42Obj.f;
            m42Obj3.g = m42Obj2.g + m42Obj.g;
            m42Obj3.h = m42Obj2.h + m42Obj.h;
            this.stack[this.sp++] = m42Obj3;
        }

        final void sub() {
            M42Obj m42Obj = this.stack[--this.sp];
            M42Obj m42Obj2 = this.stack[--this.sp];
            M42Obj m42Obj3 = this.heap[this.hp++];
            m42Obj3.a = m42Obj2.a - m42Obj.a;
            m42Obj3.b = m42Obj2.b - m42Obj.b;
            m42Obj3.c = m42Obj2.c - m42Obj.c;
            m42Obj3.d = m42Obj2.d - m42Obj.d;
            m42Obj3.e = m42Obj2.e - m42Obj.e;
            m42Obj3.f = m42Obj2.f - m42Obj.f;
            m42Obj3.g = m42Obj2.g - m42Obj.g;
            m42Obj3.h = m42Obj2.h - m42Obj.h;
            this.stack[this.sp++] = m42Obj3;
        }

        final void uminus() {
            M42Obj m42Obj = this.stack[--this.sp];
            M42Obj m42Obj2 = this.heap[this.hp++];
            m42Obj2.a = -m42Obj.a;
            m42Obj2.b = -m42Obj.b;
            m42Obj2.c = -m42Obj.c;
            m42Obj2.d = -m42Obj.d;
            m42Obj2.e = -m42Obj.e;
            m42Obj2.f = -m42Obj.f;
            m42Obj2.g = -m42Obj.g;
            m42Obj2.h = -m42Obj.h;
            this.stack[this.sp++] = m42Obj2;
        }

        final void mulS() {
            M42Obj m42Obj = this.stack[--this.sp];
            double d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M42Obj m42Obj2 = this.heap[this.hp++];
            m42Obj2.a = d * m42Obj.a;
            m42Obj2.b = d * m42Obj.b;
            m42Obj2.c = d * m42Obj.c;
            m42Obj2.d = d * m42Obj.d;
            m42Obj2.e = d * m42Obj.e;
            m42Obj2.f = d * m42Obj.f;
            m42Obj2.g = d * m42Obj.g;
            m42Obj2.h = d * m42Obj.h;
            this.stack[this.sp++] = m42Obj2;
        }

        final void divS() {
            M42Obj m42Obj = this.stack[--this.sp];
            double d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M42Obj m42Obj2 = this.heap[this.hp++];
            m42Obj2.a = m42Obj.a / d;
            m42Obj2.b = m42Obj.b / d;
            m42Obj2.c = m42Obj.c / d;
            m42Obj2.d = m42Obj.d / d;
            m42Obj2.e = m42Obj.e / d;
            m42Obj2.f = m42Obj.f / d;
            m42Obj2.g = m42Obj.g / d;
            m42Obj2.h = m42Obj.h / d;
            this.stack[this.sp++] = m42Obj2;
        }

        final void makeList() {
            M42Obj m42Obj = this.heap[this.hp++];
            m42Obj.h = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m42Obj.g = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m42Obj.f = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m42Obj.e = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m42Obj.d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m42Obj.c = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m42Obj.b = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m42Obj.a = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            this.stack[this.sp++] = m42Obj;
        }

        final void assign(int n) {
            M42Obj m42Obj = this.stack[this.sp - 1];
            M42Obj m42Obj2 = this.vars[n];
            m42Obj2.a = m42Obj.a;
            m42Obj2.b = m42Obj.b;
            m42Obj2.c = m42Obj.c;
            m42Obj2.d = m42Obj.d;
            m42Obj2.e = m42Obj.e;
            m42Obj2.f = m42Obj.f;
            m42Obj2.g = m42Obj.g;
            m42Obj2.h = m42Obj.h;
        }

        final void eq() {
            M42Obj m42Obj = this.stack[--this.sp];
            M42Obj m42Obj2 = this.stack[--this.sp];
            MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = m42Obj2.a == m42Obj.a && m42Obj2.b == m42Obj.b && m42Obj2.c == m42Obj.c && m42Obj2.d == m42Obj.d && m42Obj2.e == m42Obj.e && m42Obj2.f == m42Obj.f && m42Obj2.g == m42Obj.g && m42Obj2.h == m42Obj.h ? 1.0 : 0.0;
        }
    }

    private static final class M42Obj
    extends MatObj {
        double a;
        double b;
        double c;
        double d;
        double e;
        double f;
        double g;
        double h;
        private static Dimensions dims = Dimensions.valueOf(4, 2);

        private M42Obj() {
        }

        public Dimensions getDims() {
            return dims;
        }

        public void copyToMat(Matrix matrix) {
            matrix.setEle(0, 0, new Double(this.a));
            matrix.setEle(0, 1, new Double(this.b));
            matrix.setEle(1, 0, new Double(this.c));
            matrix.setEle(1, 1, new Double(this.d));
            matrix.setEle(2, 0, new Double(this.e));
            matrix.setEle(2, 1, new Double(this.f));
            matrix.setEle(3, 0, new Double(this.g));
            matrix.setEle(3, 1, new Double(this.h));
        }

        public String toString() {
            return "[[" + this.a + "," + this.b + "]," + "[" + this.c + "," + this.d + "]," + "[" + this.e + "," + this.f + "]," + "[" + this.g + "," + this.h + "]]";
        }

        final void fromMat(Matrix matrix) {
            this.a = (Double)matrix.getEle(0, 0);
            this.b = (Double)matrix.getEle(0, 1);
            this.c = (Double)matrix.getEle(1, 0);
            this.d = (Double)matrix.getEle(1, 1);
            this.e = (Double)matrix.getEle(2, 0);
            this.f = (Double)matrix.getEle(2, 1);
            this.g = (Double)matrix.getEle(3, 0);
            this.h = (Double)matrix.getEle(3, 1);
        }

        public double[][] toArrayMat() {
            return new double[][]{{this.a, this.b}, {this.c, this.d}, {this.e, this.f}, {this.g, this.h}};
        }
    }

    private final class M34Store
    extends MatStore {
        M34Obj[] stack;
        M34Obj[] heap;
        M34Obj[] vars = new M34Obj[0];

        private M34Store() {
        }

        final void alloc() {
            int n;
            this.heap = new M34Obj[this.hp];
            for (n = 0; n < this.hp; ++n) {
                this.heap[n] = new M34Obj();
            }
            this.stack = new M34Obj[this.stackMax];
            for (n = 0; n < this.stackMax; ++n) {
                this.stack[n] = new M34Obj();
            }
        }

        final void expandVarArray(MatrixVariableI matrixVariableI) {
            M34Obj[] m34ObjArray = new M34Obj[this.vars.length + 1];
            System.arraycopy(this.vars, 0, m34ObjArray, 0, this.vars.length);
            m34ObjArray[this.vars.length] = new M34Obj();
            this.vars = m34ObjArray;
        }

        final void copyVar(int n, Matrix matrix) {
            this.vars[n].fromMat(matrix);
        }

        final void add() {
            M34Obj m34Obj = this.stack[--this.sp];
            M34Obj m34Obj2 = this.stack[--this.sp];
            M34Obj m34Obj3 = this.heap[this.hp++];
            m34Obj3.a = m34Obj2.a + m34Obj.a;
            m34Obj3.b = m34Obj2.b + m34Obj.b;
            m34Obj3.c = m34Obj2.c + m34Obj.c;
            m34Obj3.d = m34Obj2.d + m34Obj.d;
            m34Obj3.e = m34Obj2.e + m34Obj.e;
            m34Obj3.f = m34Obj2.f + m34Obj.f;
            m34Obj3.g = m34Obj2.g + m34Obj.g;
            m34Obj3.h = m34Obj2.h + m34Obj.h;
            m34Obj3.i = m34Obj2.i + m34Obj.i;
            m34Obj3.j = m34Obj2.j + m34Obj.j;
            m34Obj3.k = m34Obj2.k + m34Obj.k;
            m34Obj3.l = m34Obj2.l + m34Obj.l;
            this.stack[this.sp++] = m34Obj3;
        }

        final void sub() {
            M34Obj m34Obj = this.stack[--this.sp];
            M34Obj m34Obj2 = this.stack[--this.sp];
            M34Obj m34Obj3 = this.heap[this.hp++];
            m34Obj3.a = m34Obj2.a - m34Obj.a;
            m34Obj3.b = m34Obj2.b - m34Obj.b;
            m34Obj3.c = m34Obj2.c - m34Obj.c;
            m34Obj3.d = m34Obj2.d - m34Obj.d;
            m34Obj3.e = m34Obj2.e - m34Obj.e;
            m34Obj3.f = m34Obj2.f - m34Obj.f;
            m34Obj3.g = m34Obj2.g - m34Obj.g;
            m34Obj3.h = m34Obj2.h - m34Obj.h;
            m34Obj3.i = m34Obj2.i - m34Obj.i;
            m34Obj3.j = m34Obj2.j - m34Obj.j;
            m34Obj3.k = m34Obj2.k - m34Obj.k;
            m34Obj3.l = m34Obj2.l - m34Obj.l;
            this.stack[this.sp++] = m34Obj3;
        }

        final void uminus() {
            M34Obj m34Obj = this.stack[--this.sp];
            M34Obj m34Obj2 = this.heap[this.hp++];
            m34Obj2.a = -m34Obj.a;
            m34Obj2.b = -m34Obj.b;
            m34Obj2.c = -m34Obj.c;
            m34Obj2.d = -m34Obj.d;
            m34Obj2.e = -m34Obj.e;
            m34Obj2.f = -m34Obj.f;
            m34Obj2.g = -m34Obj.g;
            m34Obj2.h = -m34Obj.h;
            m34Obj2.i = -m34Obj.i;
            m34Obj2.j = -m34Obj.j;
            m34Obj2.k = -m34Obj.k;
            m34Obj2.l = -m34Obj.l;
            this.stack[this.sp++] = m34Obj2;
        }

        final void mulS() {
            M34Obj m34Obj = this.stack[--this.sp];
            double d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M34Obj m34Obj2 = this.heap[this.hp++];
            m34Obj2.a = d * m34Obj.a;
            m34Obj2.b = d * m34Obj.b;
            m34Obj2.c = d * m34Obj.c;
            m34Obj2.d = d * m34Obj.d;
            m34Obj2.e = d * m34Obj.e;
            m34Obj2.f = d * m34Obj.f;
            m34Obj2.g = d * m34Obj.g;
            m34Obj2.h = d * m34Obj.h;
            m34Obj2.i = d * m34Obj.i;
            m34Obj2.j = d * m34Obj.j;
            m34Obj2.k = d * m34Obj.k;
            m34Obj2.l = d * m34Obj.l;
            this.stack[this.sp++] = m34Obj2;
        }

        final void divS() {
            M34Obj m34Obj = this.stack[--this.sp];
            double d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M34Obj m34Obj2 = this.heap[this.hp++];
            m34Obj2.a = m34Obj.a / d;
            m34Obj2.b = m34Obj.b / d;
            m34Obj2.c = m34Obj.c / d;
            m34Obj2.d = m34Obj.d / d;
            m34Obj2.e = m34Obj.e / d;
            m34Obj2.f = m34Obj.f / d;
            m34Obj2.g = m34Obj.g / d;
            m34Obj2.h = m34Obj.h / d;
            m34Obj2.i = m34Obj.i / d;
            m34Obj2.j = m34Obj.j / d;
            m34Obj2.k = m34Obj.k / d;
            m34Obj2.l = m34Obj.l / d;
            this.stack[this.sp++] = m34Obj2;
        }

        final void makeList() {
            M34Obj m34Obj = this.heap[this.hp++];
            m34Obj.l = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m34Obj.k = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m34Obj.j = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m34Obj.i = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m34Obj.h = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m34Obj.g = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m34Obj.f = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m34Obj.e = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m34Obj.d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m34Obj.c = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m34Obj.b = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m34Obj.a = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            this.stack[this.sp++] = m34Obj;
        }

        final void assign(int n) {
            M34Obj m34Obj = this.stack[this.sp - 1];
            M34Obj m34Obj2 = this.vars[n];
            m34Obj2.a = m34Obj.a;
            m34Obj2.b = m34Obj.b;
            m34Obj2.c = m34Obj.c;
            m34Obj2.d = m34Obj.d;
            m34Obj2.e = m34Obj.e;
            m34Obj2.f = m34Obj.f;
            m34Obj2.g = m34Obj.g;
            m34Obj2.h = m34Obj.h;
            m34Obj2.i = m34Obj.i;
            m34Obj2.j = m34Obj.j;
            m34Obj2.k = m34Obj.k;
            m34Obj2.l = m34Obj.l;
        }

        final void eq() {
            M34Obj m34Obj = this.stack[--this.sp];
            M34Obj m34Obj2 = this.stack[--this.sp];
            MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = m34Obj2.a == m34Obj.a && m34Obj2.b == m34Obj.b && m34Obj2.c == m34Obj.c && m34Obj2.d == m34Obj.d && m34Obj2.e == m34Obj.e && m34Obj2.f == m34Obj.f && m34Obj2.g == m34Obj.g && m34Obj2.h == m34Obj.h && m34Obj2.i == m34Obj.i && m34Obj2.j == m34Obj.j && m34Obj2.k == m34Obj.k && m34Obj2.l == m34Obj.l ? 1.0 : 0.0;
        }
    }

    private static final class M34Obj
    extends MatObj {
        double a;
        double b;
        double c;
        double d;
        double e;
        double f;
        double g;
        double h;
        double i;
        double j;
        double k;
        double l;
        private static Dimensions dims = Dimensions.valueOf(3, 4);

        private M34Obj() {
        }

        public Dimensions getDims() {
            return dims;
        }

        public void copyToMat(Matrix matrix) {
            matrix.setEle(0, 0, new Double(this.a));
            matrix.setEle(0, 1, new Double(this.b));
            matrix.setEle(0, 2, new Double(this.c));
            matrix.setEle(0, 3, new Double(this.d));
            matrix.setEle(1, 0, new Double(this.e));
            matrix.setEle(1, 1, new Double(this.f));
            matrix.setEle(1, 2, new Double(this.g));
            matrix.setEle(1, 3, new Double(this.h));
            matrix.setEle(2, 0, new Double(this.i));
            matrix.setEle(2, 1, new Double(this.j));
            matrix.setEle(2, 2, new Double(this.k));
            matrix.setEle(2, 3, new Double(this.l));
        }

        public String toString() {
            return "[[" + this.a + "," + this.b + "," + this.c + "," + this.d + "]," + "[" + this.e + "," + this.f + "," + this.g + "," + this.h + "]," + "[" + this.i + "," + this.j + "," + this.k + "," + this.l + "]]";
        }

        final void fromMat(Matrix matrix) {
            this.a = (Double)matrix.getEle(0, 0);
            this.b = (Double)matrix.getEle(0, 1);
            this.c = (Double)matrix.getEle(0, 2);
            this.d = (Double)matrix.getEle(0, 3);
            this.e = (Double)matrix.getEle(1, 0);
            this.f = (Double)matrix.getEle(1, 1);
            this.g = (Double)matrix.getEle(1, 2);
            this.h = (Double)matrix.getEle(1, 3);
            this.i = (Double)matrix.getEle(2, 0);
            this.j = (Double)matrix.getEle(2, 1);
            this.k = (Double)matrix.getEle(2, 2);
            this.l = (Double)matrix.getEle(2, 3);
        }

        public double[][] toArrayMat() {
            return new double[][]{{this.a, this.b, this.c, this.d}, {this.e, this.f, this.g, this.h}, {this.i, this.j, this.k, this.l}};
        }
    }

    private final class M33Store
    extends MatStore {
        M33Obj[] stack;
        M33Obj[] heap;
        M33Obj[] vars = new M33Obj[0];

        private M33Store() {
        }

        final void alloc() {
            int n;
            this.heap = new M33Obj[this.hp];
            for (n = 0; n < this.hp; ++n) {
                this.heap[n] = new M33Obj();
            }
            this.stack = new M33Obj[this.stackMax];
            for (n = 0; n < this.stackMax; ++n) {
                this.stack[n] = new M33Obj();
            }
        }

        final void expandVarArray(MatrixVariableI matrixVariableI) {
            M33Obj[] m33ObjArray = new M33Obj[this.vars.length + 1];
            System.arraycopy(this.vars, 0, m33ObjArray, 0, this.vars.length);
            m33ObjArray[this.vars.length] = new M33Obj();
            this.vars = m33ObjArray;
        }

        final void copyVar(int n, Matrix matrix) {
            this.vars[n].fromMat(matrix);
        }

        final void add() {
            M33Obj m33Obj = this.stack[--this.sp];
            M33Obj m33Obj2 = this.stack[--this.sp];
            M33Obj m33Obj3 = this.heap[this.hp++];
            m33Obj3.a = m33Obj2.a + m33Obj.a;
            m33Obj3.b = m33Obj2.b + m33Obj.b;
            m33Obj3.c = m33Obj2.c + m33Obj.c;
            m33Obj3.d = m33Obj2.d + m33Obj.d;
            m33Obj3.e = m33Obj2.e + m33Obj.e;
            m33Obj3.f = m33Obj2.f + m33Obj.f;
            m33Obj3.g = m33Obj2.g + m33Obj.g;
            m33Obj3.h = m33Obj2.h + m33Obj.h;
            m33Obj3.i = m33Obj2.i + m33Obj.i;
            this.stack[this.sp++] = m33Obj3;
        }

        final void sub() {
            M33Obj m33Obj = this.stack[--this.sp];
            M33Obj m33Obj2 = this.stack[--this.sp];
            M33Obj m33Obj3 = this.heap[this.hp++];
            m33Obj3.a = m33Obj2.a - m33Obj.a;
            m33Obj3.b = m33Obj2.b - m33Obj.b;
            m33Obj3.c = m33Obj2.c - m33Obj.c;
            m33Obj3.d = m33Obj2.d - m33Obj.d;
            m33Obj3.e = m33Obj2.e - m33Obj.e;
            m33Obj3.f = m33Obj2.f - m33Obj.f;
            m33Obj3.g = m33Obj2.g - m33Obj.g;
            m33Obj3.h = m33Obj2.h - m33Obj.h;
            m33Obj3.i = m33Obj2.i - m33Obj.i;
            this.stack[this.sp++] = m33Obj3;
        }

        final void uminus() {
            M33Obj m33Obj = this.stack[--this.sp];
            M33Obj m33Obj2 = this.heap[this.hp++];
            m33Obj2.a = -m33Obj.a;
            m33Obj2.b = -m33Obj.b;
            m33Obj2.c = -m33Obj.c;
            m33Obj2.d = -m33Obj.d;
            m33Obj2.e = -m33Obj.e;
            m33Obj2.f = -m33Obj.f;
            m33Obj2.g = -m33Obj.g;
            m33Obj2.h = -m33Obj.h;
            m33Obj2.i = -m33Obj.i;
            this.stack[this.sp++] = m33Obj2;
        }

        final void mulS() {
            M33Obj m33Obj = this.stack[--this.sp];
            double d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M33Obj m33Obj2 = this.heap[this.hp++];
            m33Obj2.a = d * m33Obj.a;
            m33Obj2.b = d * m33Obj.b;
            m33Obj2.c = d * m33Obj.c;
            m33Obj2.d = d * m33Obj.d;
            m33Obj2.e = d * m33Obj.e;
            m33Obj2.f = d * m33Obj.f;
            m33Obj2.g = d * m33Obj.g;
            m33Obj2.h = d * m33Obj.h;
            m33Obj2.i = d * m33Obj.i;
            this.stack[this.sp++] = m33Obj2;
        }

        final void divS() {
            M33Obj m33Obj = this.stack[--this.sp];
            double d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M33Obj m33Obj2 = this.heap[this.hp++];
            m33Obj2.a = m33Obj.a / d;
            m33Obj2.b = m33Obj.b / d;
            m33Obj2.c = m33Obj.c / d;
            m33Obj2.d = m33Obj.d / d;
            m33Obj2.e = m33Obj.e / d;
            m33Obj2.f = m33Obj.f / d;
            m33Obj2.g = m33Obj.g / d;
            m33Obj2.h = m33Obj.h / d;
            m33Obj2.i = m33Obj.i / d;
            this.stack[this.sp++] = m33Obj2;
        }

        final void makeList() {
            M33Obj m33Obj = this.heap[this.hp++];
            m33Obj.i = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m33Obj.h = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m33Obj.g = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m33Obj.f = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m33Obj.e = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m33Obj.d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m33Obj.c = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m33Obj.b = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m33Obj.a = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            this.stack[this.sp++] = m33Obj;
        }

        final void assign(int n) {
            M33Obj m33Obj = this.stack[this.sp - 1];
            M33Obj m33Obj2 = this.vars[n];
            m33Obj2.a = m33Obj.a;
            m33Obj2.b = m33Obj.b;
            m33Obj2.c = m33Obj.c;
            m33Obj2.d = m33Obj.d;
            m33Obj2.e = m33Obj.e;
            m33Obj2.f = m33Obj.f;
            m33Obj2.g = m33Obj.g;
            m33Obj2.h = m33Obj.h;
            m33Obj2.i = m33Obj.i;
        }

        final void eq() {
            M33Obj m33Obj = this.stack[--this.sp];
            M33Obj m33Obj2 = this.stack[--this.sp];
            MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = m33Obj2.a == m33Obj.a && m33Obj2.b == m33Obj.b && m33Obj2.c == m33Obj.c && m33Obj2.d == m33Obj.d && m33Obj2.e == m33Obj.e && m33Obj2.f == m33Obj.f && m33Obj2.g == m33Obj.g && m33Obj2.h == m33Obj.h && m33Obj2.i == m33Obj.i ? 1.0 : 0.0;
        }
    }

    private static final class M33Obj
    extends MatObj {
        double a;
        double b;
        double c;
        double d;
        double e;
        double f;
        double g;
        double h;
        double i;
        static Dimensions dims = Dimensions.valueOf(3, 3);

        private M33Obj() {
        }

        public Dimensions getDims() {
            return dims;
        }

        public void copyToMat(Matrix matrix) {
            matrix.setEle(0, 0, new Double(this.a));
            matrix.setEle(0, 1, new Double(this.b));
            matrix.setEle(0, 2, new Double(this.c));
            matrix.setEle(1, 0, new Double(this.d));
            matrix.setEle(1, 1, new Double(this.e));
            matrix.setEle(1, 2, new Double(this.f));
            matrix.setEle(2, 0, new Double(this.g));
            matrix.setEle(2, 1, new Double(this.h));
            matrix.setEle(2, 2, new Double(this.i));
        }

        public String toString() {
            return "[[" + this.a + "," + this.b + "," + this.c + "]," + "[" + this.d + "," + this.e + "," + this.f + "]," + "[" + this.g + "," + this.h + "," + this.i + "]]";
        }

        final void fromMat(Matrix matrix) {
            this.a = (Double)matrix.getEle(0, 0);
            this.b = (Double)matrix.getEle(0, 1);
            this.c = (Double)matrix.getEle(0, 2);
            this.d = (Double)matrix.getEle(1, 0);
            this.e = (Double)matrix.getEle(1, 1);
            this.f = (Double)matrix.getEle(1, 2);
            this.g = (Double)matrix.getEle(2, 0);
            this.h = (Double)matrix.getEle(2, 1);
            this.i = (Double)matrix.getEle(2, 2);
        }

        public double[][] toArrayMat() {
            return new double[][]{{this.a, this.b, this.c}, {this.d, this.e, this.f}, {this.g, this.h, this.i}};
        }
    }

    private final class M32Store
    extends MatStore {
        M32Obj[] stack;
        M32Obj[] heap;
        M32Obj[] vars = new M32Obj[0];

        private M32Store() {
        }

        final void alloc() {
            int n;
            this.heap = new M32Obj[this.hp];
            for (n = 0; n < this.hp; ++n) {
                this.heap[n] = new M32Obj();
            }
            this.stack = new M32Obj[this.stackMax];
            for (n = 0; n < this.stackMax; ++n) {
                this.stack[n] = new M32Obj();
            }
        }

        final void expandVarArray(MatrixVariableI matrixVariableI) {
            M32Obj[] m32ObjArray = new M32Obj[this.vars.length + 1];
            System.arraycopy(this.vars, 0, m32ObjArray, 0, this.vars.length);
            m32ObjArray[this.vars.length] = new M32Obj();
            this.vars = m32ObjArray;
        }

        final void copyVar(int n, Matrix matrix) {
            this.vars[n].fromMat(matrix);
        }

        final void add() {
            M32Obj m32Obj = this.stack[--this.sp];
            M32Obj m32Obj2 = this.stack[--this.sp];
            M32Obj m32Obj3 = this.heap[this.hp++];
            m32Obj3.a = m32Obj2.a + m32Obj.a;
            m32Obj3.b = m32Obj2.b + m32Obj.b;
            m32Obj3.c = m32Obj2.c + m32Obj.c;
            m32Obj3.d = m32Obj2.d + m32Obj.d;
            m32Obj3.e = m32Obj2.e + m32Obj.e;
            m32Obj3.f = m32Obj2.f + m32Obj.f;
            this.stack[this.sp++] = m32Obj3;
        }

        final void sub() {
            M32Obj m32Obj = this.stack[--this.sp];
            M32Obj m32Obj2 = this.stack[--this.sp];
            M32Obj m32Obj3 = this.heap[this.hp++];
            m32Obj3.a = m32Obj2.a - m32Obj.a;
            m32Obj3.b = m32Obj2.b - m32Obj.b;
            m32Obj3.c = m32Obj2.c - m32Obj.c;
            m32Obj3.d = m32Obj2.d - m32Obj.d;
            m32Obj3.e = m32Obj2.e - m32Obj.e;
            m32Obj3.f = m32Obj2.f - m32Obj.f;
            this.stack[this.sp++] = m32Obj3;
        }

        final void uminus() {
            M32Obj m32Obj = this.stack[--this.sp];
            M32Obj m32Obj2 = this.heap[this.hp++];
            m32Obj2.a = -m32Obj.a;
            m32Obj2.b = -m32Obj.b;
            m32Obj2.c = -m32Obj.c;
            m32Obj2.d = -m32Obj.d;
            m32Obj2.e = -m32Obj.e;
            m32Obj2.f = -m32Obj.f;
            this.stack[this.sp++] = m32Obj2;
        }

        final void mulS() {
            M32Obj m32Obj = this.stack[--this.sp];
            double d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M32Obj m32Obj2 = this.heap[this.hp++];
            m32Obj2.a = d * m32Obj.a;
            m32Obj2.b = d * m32Obj.b;
            m32Obj2.c = d * m32Obj.c;
            m32Obj2.d = d * m32Obj.d;
            m32Obj2.e = d * m32Obj.e;
            m32Obj2.f = d * m32Obj.f;
            this.stack[this.sp++] = m32Obj2;
        }

        final void divS() {
            M32Obj m32Obj = this.stack[--this.sp];
            double d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M32Obj m32Obj2 = this.heap[this.hp++];
            m32Obj2.a = m32Obj.a / d;
            m32Obj2.b = m32Obj.b / d;
            m32Obj2.c = m32Obj.c / d;
            m32Obj2.d = m32Obj.d / d;
            m32Obj2.e = m32Obj.e / d;
            m32Obj2.f = m32Obj.f / d;
            this.stack[this.sp++] = m32Obj2;
        }

        final void makeList() {
            M32Obj m32Obj = this.heap[this.hp++];
            m32Obj.f = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m32Obj.e = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m32Obj.d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m32Obj.c = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m32Obj.b = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m32Obj.a = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            this.stack[this.sp++] = m32Obj;
        }

        final void assign(int n) {
            M32Obj m32Obj = this.stack[this.sp - 1];
            M32Obj m32Obj2 = this.vars[n];
            m32Obj2.a = m32Obj.a;
            m32Obj2.b = m32Obj.b;
            m32Obj2.c = m32Obj.c;
            m32Obj2.d = m32Obj.d;
            m32Obj2.e = m32Obj.e;
            m32Obj2.f = m32Obj.f;
        }

        final void eq() {
            M32Obj m32Obj = this.stack[--this.sp];
            M32Obj m32Obj2 = this.stack[--this.sp];
            MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = m32Obj2.a == m32Obj.a && m32Obj2.b == m32Obj.b && m32Obj2.c == m32Obj.c && m32Obj2.d == m32Obj.d && m32Obj2.e == m32Obj.e && m32Obj2.f == m32Obj.f ? 1.0 : 0.0;
        }
    }

    private static final class M32Obj
    extends MatObj {
        double a;
        double b;
        double c;
        double d;
        double e;
        double f;
        static Dimensions dims = Dimensions.valueOf(3, 2);

        private M32Obj() {
        }

        public Dimensions getDims() {
            return dims;
        }

        public String toString() {
            return "[[" + this.a + "," + this.b + "]," + "[" + this.c + "," + this.d + "]," + "[" + this.e + "," + this.f + "]]";
        }

        final void fromMat(Matrix matrix) {
            this.a = (Double)matrix.getEle(0, 0);
            this.b = (Double)matrix.getEle(0, 1);
            this.c = (Double)matrix.getEle(1, 0);
            this.d = (Double)matrix.getEle(1, 1);
            this.e = (Double)matrix.getEle(2, 0);
            this.f = (Double)matrix.getEle(2, 1);
        }

        public void copyToMat(Matrix matrix) {
            matrix.setEle(0, 0, new Double(this.a));
            matrix.setEle(0, 1, new Double(this.b));
            matrix.setEle(1, 0, new Double(this.c));
            matrix.setEle(1, 1, new Double(this.d));
            matrix.setEle(2, 0, new Double(this.e));
            matrix.setEle(2, 1, new Double(this.f));
        }

        public double[][] toArrayMat() {
            return new double[][]{{this.a, this.b}, {this.c, this.d}, {this.e, this.f}};
        }
    }

    private final class M24Store
    extends MatStore {
        M24Obj[] stack;
        M24Obj[] heap;
        M24Obj[] vars = new M24Obj[0];

        private M24Store() {
        }

        final void alloc() {
            int n;
            this.heap = new M24Obj[this.hp];
            for (n = 0; n < this.hp; ++n) {
                this.heap[n] = new M24Obj();
            }
            this.stack = new M24Obj[this.stackMax];
            for (n = 0; n < this.stackMax; ++n) {
                this.stack[n] = new M24Obj();
            }
        }

        final void expandVarArray(MatrixVariableI matrixVariableI) {
            M24Obj[] m24ObjArray = new M24Obj[this.vars.length + 1];
            System.arraycopy(this.vars, 0, m24ObjArray, 0, this.vars.length);
            m24ObjArray[this.vars.length] = new M24Obj();
            this.vars = m24ObjArray;
        }

        final void copyVar(int n, Matrix matrix) {
            this.vars[n].fromMat(matrix);
        }

        final void add() {
            M24Obj m24Obj = this.stack[--this.sp];
            M24Obj m24Obj2 = this.stack[--this.sp];
            M24Obj m24Obj3 = this.heap[this.hp++];
            m24Obj3.a = m24Obj2.a + m24Obj.a;
            m24Obj3.b = m24Obj2.b + m24Obj.b;
            m24Obj3.c = m24Obj2.c + m24Obj.c;
            m24Obj3.d = m24Obj2.d + m24Obj.d;
            m24Obj3.e = m24Obj2.e + m24Obj.e;
            m24Obj3.f = m24Obj2.f + m24Obj.f;
            m24Obj3.g = m24Obj2.g + m24Obj.g;
            m24Obj3.h = m24Obj2.h + m24Obj.h;
            this.stack[this.sp++] = m24Obj3;
        }

        final void sub() {
            M24Obj m24Obj = this.stack[--this.sp];
            M24Obj m24Obj2 = this.stack[--this.sp];
            M24Obj m24Obj3 = this.heap[this.hp++];
            m24Obj3.a = m24Obj2.a - m24Obj.a;
            m24Obj3.b = m24Obj2.b - m24Obj.b;
            m24Obj3.c = m24Obj2.c - m24Obj.c;
            m24Obj3.d = m24Obj2.d - m24Obj.d;
            m24Obj3.e = m24Obj2.e - m24Obj.e;
            m24Obj3.f = m24Obj2.f - m24Obj.f;
            m24Obj3.g = m24Obj2.g - m24Obj.g;
            m24Obj3.h = m24Obj2.h - m24Obj.h;
            this.stack[this.sp++] = m24Obj3;
        }

        final void uminus() {
            M24Obj m24Obj = this.stack[--this.sp];
            M24Obj m24Obj2 = this.heap[this.hp++];
            m24Obj2.a = -m24Obj.a;
            m24Obj2.b = -m24Obj.b;
            m24Obj2.c = -m24Obj.c;
            m24Obj2.d = -m24Obj.d;
            m24Obj2.e = -m24Obj.e;
            m24Obj2.f = -m24Obj.f;
            m24Obj2.g = -m24Obj.g;
            m24Obj2.h = -m24Obj.h;
            this.stack[this.sp++] = m24Obj2;
        }

        final void mulS() {
            M24Obj m24Obj = this.stack[--this.sp];
            double d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M24Obj m24Obj2 = this.heap[this.hp++];
            m24Obj2.a = d * m24Obj.a;
            m24Obj2.b = d * m24Obj.b;
            m24Obj2.c = d * m24Obj.c;
            m24Obj2.d = d * m24Obj.d;
            m24Obj2.e = d * m24Obj.e;
            m24Obj2.f = d * m24Obj.f;
            m24Obj2.g = d * m24Obj.g;
            m24Obj2.h = d * m24Obj.h;
            this.stack[this.sp++] = m24Obj2;
        }

        final void divS() {
            M24Obj m24Obj = this.stack[--this.sp];
            double d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M24Obj m24Obj2 = this.heap[this.hp++];
            m24Obj2.a = m24Obj.a / d;
            m24Obj2.b = m24Obj.b / d;
            m24Obj2.c = m24Obj.c / d;
            m24Obj2.d = m24Obj.d / d;
            m24Obj2.e = m24Obj.e / d;
            m24Obj2.f = m24Obj.f / d;
            m24Obj2.g = m24Obj.g / d;
            m24Obj2.h = m24Obj.h / d;
            this.stack[this.sp++] = m24Obj2;
        }

        final void makeList() {
            M24Obj m24Obj = this.heap[this.hp++];
            m24Obj.h = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m24Obj.g = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m24Obj.f = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m24Obj.e = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m24Obj.d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m24Obj.c = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m24Obj.b = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m24Obj.a = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            this.stack[this.sp++] = m24Obj;
        }

        final void assign(int n) {
            M24Obj m24Obj = this.stack[this.sp - 1];
            M24Obj m24Obj2 = this.vars[n];
            m24Obj2.a = m24Obj.a;
            m24Obj2.b = m24Obj.b;
            m24Obj2.c = m24Obj.c;
            m24Obj2.d = m24Obj.d;
            m24Obj2.e = m24Obj.e;
            m24Obj2.f = m24Obj.f;
            m24Obj2.g = m24Obj.g;
            m24Obj2.h = m24Obj.h;
        }

        final void eq() {
            M24Obj m24Obj = this.stack[--this.sp];
            M24Obj m24Obj2 = this.stack[--this.sp];
            MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = m24Obj2.a == m24Obj.a && m24Obj2.b == m24Obj.b && m24Obj2.c == m24Obj.c && m24Obj2.d == m24Obj.d && m24Obj2.e == m24Obj.e && m24Obj2.f == m24Obj.f && m24Obj2.g == m24Obj.g && m24Obj2.h == m24Obj.h ? 1.0 : 0.0;
        }
    }

    private static final class M24Obj
    extends MatObj {
        double a;
        double b;
        double c;
        double d;
        double e;
        double f;
        double g;
        double h;
        static Dimensions dims = Dimensions.valueOf(2, 4);

        private M24Obj() {
        }

        public Dimensions getDims() {
            return dims;
        }

        public String toString() {
            return "[[" + this.a + "," + this.b + "," + this.c + "," + this.d + "]," + "[" + this.e + "," + this.f + "," + this.g + "," + this.h + "]]";
        }

        final void fromMat(Matrix matrix) {
            this.a = (Double)matrix.getEle(0, 0);
            this.b = (Double)matrix.getEle(0, 1);
            this.c = (Double)matrix.getEle(0, 2);
            this.d = (Double)matrix.getEle(0, 3);
            this.e = (Double)matrix.getEle(1, 0);
            this.f = (Double)matrix.getEle(1, 1);
            this.g = (Double)matrix.getEle(1, 2);
            this.h = (Double)matrix.getEle(1, 3);
        }

        public void copyToMat(Matrix matrix) {
            matrix.setEle(0, 0, new Double(this.a));
            matrix.setEle(0, 1, new Double(this.b));
            matrix.setEle(0, 2, new Double(this.c));
            matrix.setEle(0, 3, new Double(this.d));
            matrix.setEle(1, 0, new Double(this.e));
            matrix.setEle(1, 1, new Double(this.f));
            matrix.setEle(1, 2, new Double(this.g));
            matrix.setEle(1, 3, new Double(this.h));
        }

        public double[][] toArrayMat() {
            return new double[][]{{this.a, this.b, this.c, this.d}, {this.e, this.f, this.g, this.h}};
        }
    }

    private final class M23Store
    extends MatStore {
        M23Obj[] stack;
        M23Obj[] heap;
        M23Obj[] vars = new M23Obj[0];

        private M23Store() {
        }

        final void alloc() {
            int n;
            this.heap = new M23Obj[this.hp];
            for (n = 0; n < this.hp; ++n) {
                this.heap[n] = new M23Obj();
            }
            this.stack = new M23Obj[this.stackMax];
            for (n = 0; n < this.stackMax; ++n) {
                this.stack[n] = new M23Obj();
            }
        }

        final void expandVarArray(MatrixVariableI matrixVariableI) {
            M23Obj[] m23ObjArray = new M23Obj[this.vars.length + 1];
            System.arraycopy(this.vars, 0, m23ObjArray, 0, this.vars.length);
            m23ObjArray[this.vars.length] = new M23Obj();
            this.vars = m23ObjArray;
        }

        final void copyVar(int n, Matrix matrix) {
            this.vars[n].fromMat(matrix);
        }

        final void add() {
            M23Obj m23Obj = this.stack[--this.sp];
            M23Obj m23Obj2 = this.stack[--this.sp];
            M23Obj m23Obj3 = this.heap[this.hp++];
            m23Obj3.a = m23Obj2.a + m23Obj.a;
            m23Obj3.b = m23Obj2.b + m23Obj.b;
            m23Obj3.c = m23Obj2.c + m23Obj.c;
            m23Obj3.d = m23Obj2.d + m23Obj.d;
            m23Obj3.e = m23Obj2.e + m23Obj.e;
            m23Obj3.f = m23Obj2.f + m23Obj.f;
            this.stack[this.sp++] = m23Obj3;
        }

        final void sub() {
            M23Obj m23Obj = this.stack[--this.sp];
            M23Obj m23Obj2 = this.stack[--this.sp];
            M23Obj m23Obj3 = this.heap[this.hp++];
            m23Obj3.a = m23Obj2.a - m23Obj.a;
            m23Obj3.b = m23Obj2.b - m23Obj.b;
            m23Obj3.c = m23Obj2.c - m23Obj.c;
            m23Obj3.d = m23Obj2.d - m23Obj.d;
            m23Obj3.e = m23Obj2.e - m23Obj.e;
            m23Obj3.f = m23Obj2.f - m23Obj.f;
            this.stack[this.sp++] = m23Obj3;
        }

        final void uminus() {
            M23Obj m23Obj = this.stack[--this.sp];
            M23Obj m23Obj2 = this.heap[this.hp++];
            m23Obj2.a = -m23Obj.a;
            m23Obj2.b = -m23Obj.b;
            m23Obj2.c = -m23Obj.c;
            m23Obj2.d = -m23Obj.d;
            m23Obj2.e = -m23Obj.e;
            m23Obj2.f = -m23Obj.f;
            this.stack[this.sp++] = m23Obj2;
        }

        final void mulS() {
            M23Obj m23Obj = this.stack[--this.sp];
            double d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M23Obj m23Obj2 = this.heap[this.hp++];
            m23Obj2.a = d * m23Obj.a;
            m23Obj2.b = d * m23Obj.b;
            m23Obj2.c = d * m23Obj.c;
            m23Obj2.d = d * m23Obj.d;
            m23Obj2.e = d * m23Obj.e;
            m23Obj2.f = d * m23Obj.f;
            this.stack[this.sp++] = m23Obj2;
        }

        final void divS() {
            M23Obj m23Obj = this.stack[--this.sp];
            double d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M23Obj m23Obj2 = this.heap[this.hp++];
            m23Obj2.a = m23Obj.a / d;
            m23Obj2.b = m23Obj.b / d;
            m23Obj2.c = m23Obj.c / d;
            m23Obj2.d = m23Obj.d / d;
            m23Obj2.e = m23Obj.e / d;
            m23Obj2.f = m23Obj.f / d;
            this.stack[this.sp++] = m23Obj2;
        }

        final void makeList() {
            M23Obj m23Obj = this.heap[this.hp++];
            m23Obj.f = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m23Obj.e = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m23Obj.d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m23Obj.c = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m23Obj.b = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m23Obj.a = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            this.stack[this.sp++] = m23Obj;
        }

        final void assign(int n) {
            M23Obj m23Obj = this.stack[this.sp - 1];
            M23Obj m23Obj2 = this.vars[n];
            m23Obj2.a = m23Obj.a;
            m23Obj2.b = m23Obj.b;
            m23Obj2.c = m23Obj.c;
            m23Obj2.d = m23Obj.d;
            m23Obj2.e = m23Obj.e;
            m23Obj2.f = m23Obj.f;
        }

        final void eq() {
            M23Obj m23Obj = this.stack[--this.sp];
            M23Obj m23Obj2 = this.stack[--this.sp];
            MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = m23Obj2.a == m23Obj.a && m23Obj2.b == m23Obj.b && m23Obj2.c == m23Obj.c && m23Obj2.d == m23Obj.d && m23Obj2.e == m23Obj.e && m23Obj2.f == m23Obj.f ? 1.0 : 0.0;
        }
    }

    private static final class M23Obj
    extends MatObj {
        double a;
        double b;
        double c;
        double d;
        double e;
        double f;
        static Dimensions dims = Dimensions.valueOf(2, 3);

        private M23Obj() {
        }

        public Dimensions getDims() {
            return dims;
        }

        public String toString() {
            return "[[" + this.a + "," + this.b + "," + this.c + "]," + "[" + this.d + "," + this.e + "," + this.f + "]]";
        }

        final void fromMat(Matrix matrix) {
            this.a = (Double)matrix.getEle(0, 0);
            this.b = (Double)matrix.getEle(0, 1);
            this.c = (Double)matrix.getEle(0, 2);
            this.d = (Double)matrix.getEle(1, 0);
            this.e = (Double)matrix.getEle(1, 1);
            this.f = (Double)matrix.getEle(1, 2);
        }

        public void copyToMat(Matrix matrix) {
            matrix.setEle(0, 0, new Double(this.a));
            matrix.setEle(0, 1, new Double(this.b));
            matrix.setEle(0, 2, new Double(this.c));
            matrix.setEle(1, 0, new Double(this.d));
            matrix.setEle(1, 1, new Double(this.e));
            matrix.setEle(1, 2, new Double(this.f));
        }

        public double[][] toArrayMat() {
            return new double[][]{{this.a, this.b, this.c}, {this.d, this.e, this.f}};
        }
    }

    private final class M22Store
    extends MatStore {
        M22Obj[] stack;
        M22Obj[] heap;
        M22Obj[] vars = new M22Obj[0];

        private M22Store() {
        }

        final void alloc() {
            int n;
            this.heap = new M22Obj[this.hp];
            for (n = 0; n < this.hp; ++n) {
                this.heap[n] = new M22Obj();
            }
            this.stack = new M22Obj[this.stackMax];
            for (n = 0; n < this.stackMax; ++n) {
                this.stack[n] = new M22Obj();
            }
        }

        final void expandVarArray(MatrixVariableI matrixVariableI) {
            M22Obj[] m22ObjArray = new M22Obj[this.vars.length + 1];
            System.arraycopy(this.vars, 0, m22ObjArray, 0, this.vars.length);
            m22ObjArray[this.vars.length] = new M22Obj();
            this.vars = m22ObjArray;
        }

        final void copyVar(int n, Matrix matrix) {
            this.vars[n].fromMat(matrix);
        }

        final void add() {
            M22Obj m22Obj = this.stack[--this.sp];
            M22Obj m22Obj2 = this.stack[--this.sp];
            M22Obj m22Obj3 = this.heap[this.hp++];
            m22Obj3.a = m22Obj2.a + m22Obj.a;
            m22Obj3.b = m22Obj2.b + m22Obj.b;
            m22Obj3.c = m22Obj2.c + m22Obj.c;
            m22Obj3.d = m22Obj2.d + m22Obj.d;
            this.stack[this.sp++] = m22Obj3;
        }

        final void sub() {
            M22Obj m22Obj = this.stack[--this.sp];
            M22Obj m22Obj2 = this.stack[--this.sp];
            M22Obj m22Obj3 = this.heap[this.hp++];
            m22Obj3.a = m22Obj2.a - m22Obj.a;
            m22Obj3.b = m22Obj2.b - m22Obj.b;
            m22Obj3.c = m22Obj2.c - m22Obj.c;
            m22Obj3.d = m22Obj2.d - m22Obj.d;
            this.stack[this.sp++] = m22Obj3;
        }

        final void uminus() {
            M22Obj m22Obj = this.stack[--this.sp];
            M22Obj m22Obj2 = this.heap[this.hp++];
            m22Obj2.a = -m22Obj.a;
            m22Obj2.b = -m22Obj.b;
            m22Obj2.c = -m22Obj.c;
            m22Obj2.d = -m22Obj.d;
            this.stack[this.sp++] = m22Obj2;
        }

        final void mulS() {
            M22Obj m22Obj = this.stack[--this.sp];
            double d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M22Obj m22Obj2 = this.heap[this.hp++];
            m22Obj2.a = d * m22Obj.a;
            m22Obj2.b = d * m22Obj.b;
            m22Obj2.c = d * m22Obj.c;
            m22Obj2.d = d * m22Obj.d;
            this.stack[this.sp++] = m22Obj2;
        }

        final void divS() {
            M22Obj m22Obj = this.stack[--this.sp];
            double d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M22Obj m22Obj2 = this.heap[this.hp++];
            m22Obj2.a = m22Obj.a / d;
            m22Obj2.b = m22Obj.b / d;
            m22Obj2.c = m22Obj.c / d;
            m22Obj2.d = m22Obj.d / d;
            this.stack[this.sp++] = m22Obj2;
        }

        final void assign(int n) {
            M22Obj m22Obj = this.stack[--this.sp];
            ++this.sp;
            M22Obj m22Obj2 = this.vars[n];
            m22Obj2.a = m22Obj.a;
            m22Obj2.b = m22Obj.b;
            m22Obj2.c = m22Obj.c;
            m22Obj2.d = m22Obj.d;
        }

        final void makeList() {
            M22Obj m22Obj = this.heap[this.hp++];
            m22Obj.d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m22Obj.c = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m22Obj.b = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            m22Obj.a = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            this.stack[this.sp++] = m22Obj;
        }

        final void eq() {
            M22Obj m22Obj = this.stack[--this.sp];
            M22Obj m22Obj2 = this.stack[--this.sp];
            MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = m22Obj2.a == m22Obj.a && m22Obj2.b == m22Obj.b && m22Obj2.c == m22Obj.c && m22Obj2.d == m22Obj.d ? 1.0 : 0.0;
        }
    }

    private static final class M22Obj
    extends MatObj {
        double a;
        double b;
        double c;
        double d;
        static Dimensions dims = Dimensions.valueOf(2, 2);

        private M22Obj() {
        }

        public Dimensions getDims() {
            return dims;
        }

        public String toString() {
            return "[[" + this.a + "," + this.b + "]," + "[" + this.c + "," + this.d + "]]";
        }

        public void fromMat(Matrix matrix) {
            this.a = (Double)matrix.getEle(0, 0);
            this.b = (Double)matrix.getEle(0, 1);
            this.c = (Double)matrix.getEle(1, 0);
            this.d = (Double)matrix.getEle(1, 1);
        }

        public void copyToMat(Matrix matrix) {
            matrix.setEle(0, 0, new Double(this.a));
            matrix.setEle(0, 1, new Double(this.b));
            matrix.setEle(1, 0, new Double(this.c));
            matrix.setEle(1, 1, new Double(this.d));
        }

        public double[][] toArrayMat() {
            return new double[][]{{this.a, this.b}, {this.c, this.d}};
        }
    }

    private static abstract class MatStore
    extends ObjStore {
        private MatStore() {
        }

        abstract void copyVar(int var1, Matrix var2);

        final void copyFromVar(MatrixVariableI matrixVariableI, int n) {
            if (matrixVariableI.hasValidValue()) {
                Matrix matrix = (Matrix)((MatrixVariable)matrixVariableI).getMValue();
                this.copyVar(n, matrix);
            }
        }

        public final void setVarValue(int n, MatrixValueI matrixValueI) {
            this.copyVar(n, (Matrix)matrixValueI);
        }
    }

    private final class VnStore
    extends VecStore {
        VnObj[] stack;
        VnObj[] vars = new VnObj[0];

        private VnStore() {
        }

        final void alloc() {
            this.stack = new VnObj[this.stackMax];
        }

        final void expandVarArray(MatrixVariableI matrixVariableI) {
            VnObj[] vnObjArray = new VnObj[this.vars.length + 1];
            System.arraycopy(this.vars, 0, vnObjArray, 0, this.vars.length);
            vnObjArray[this.vars.length] = new VnObj(matrixVariableI.getDimensions().getFirstDim());
            this.vars = vnObjArray;
        }

        final void copyVar(int n, MVector mVector) {
            this.vars[n].fromVec(mVector);
        }

        final void add() {
            VnObj vnObj = this.stack[--this.sp];
            VnObj vnObj2 = this.stack[--this.sp];
            VnObj vnObj3 = new VnObj(vnObj2.data.length);
            for (int i = 0; i < vnObj2.data.length; ++i) {
                vnObj3.data[i] = vnObj2.data[i] + vnObj.data[i];
            }
            this.stack[this.sp++] = vnObj3;
        }

        final void sub() {
            VnObj vnObj = this.stack[--this.sp];
            VnObj vnObj2 = this.stack[--this.sp];
            VnObj vnObj3 = new VnObj(vnObj2.data.length);
            for (int i = 0; i < vnObj2.data.length; ++i) {
                vnObj3.data[i] = vnObj2.data[i] - vnObj.data[i];
            }
            this.stack[this.sp++] = vnObj3;
        }

        final void uminus() {
            VnObj vnObj = this.stack[--this.sp];
            VnObj vnObj2 = new VnObj(vnObj.data.length);
            for (int i = 0; i < vnObj.data.length; ++i) {
                vnObj2.data[i] = -vnObj.data[i];
            }
            this.stack[this.sp++] = vnObj2;
        }

        final void mulS() {
            VnObj vnObj = this.stack[--this.sp];
            double d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            VnObj vnObj2 = new VnObj(vnObj.data.length);
            for (int i = 0; i < vnObj.data.length; ++i) {
                vnObj2.data[i] = d * vnObj.data[i];
            }
            this.stack[this.sp++] = vnObj2;
        }

        final void divS() {
            VnObj vnObj = this.stack[--this.sp];
            double d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            VnObj vnObj2 = new VnObj(vnObj.data.length);
            for (int i = 0; i < vnObj.data.length; ++i) {
                vnObj2.data[i] = vnObj.data[i] / d;
            }
            this.stack[this.sp++] = vnObj2;
        }

        final void makeList(int n) {
            VnObj vnObj = new VnObj(n);
            for (int i = n - 1; i >= 0; --i) {
                vnObj.data[i] = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            }
            this.stack[this.sp++] = vnObj;
        }

        final void makeList() {
            throw new UnsupportedOperationException("VnObj: makeList cannot be called with no arguments");
        }

        final void assign(int n) {
            VnObj vnObj = this.stack[this.sp - 1];
            VnObj vnObj2 = this.vars[n];
            for (int i = 0; i < vnObj.data.length; ++i) {
                vnObj2.data[i] = vnObj.data[i];
            }
        }

        final void eq() {
            VnObj vnObj = this.stack[--this.sp];
            VnObj vnObj2 = this.stack[--this.sp];
            for (int i = 0; i < vnObj.data.length; ++i) {
                if (vnObj2.data[i] == vnObj.data[i]) continue;
                MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = 0.0;
                return;
            }
            MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = 1.0;
        }
    }

    private static final class VnObj
    extends VecObj {
        double[] data;

        VnObj(int n) {
            this.data = new double[n];
        }

        VnObj(double[] dArray) {
            this.data = dArray;
        }

        public Dimensions getDims() {
            return Dimensions.valueOf(this.data.length);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("[");
            for (int i = 0; i < this.data.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.data[i]);
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        public void fromVec(MVector mVector) {
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = (Double)mVector.getEle(i);
            }
        }

        public void copyToVec(MVector mVector) {
            for (int i = 0; i < this.data.length; ++i) {
                mVector.setEle(i, new Double(this.data[i]));
            }
        }

        double[] toArrayVec() {
            return this.data;
        }

        public Object toArray() {
            double[] dArray = new double[this.data.length];
            System.arraycopy(this.data, 0, dArray, 0, this.data.length);
            return dArray;
        }
    }

    private final class V4Store
    extends VecStore {
        V4Obj[] stack;
        V4Obj[] heap;
        V4Obj[] vars = new V4Obj[0];

        private V4Store() {
        }

        final void alloc() {
            int n;
            this.heap = new V4Obj[this.hp];
            for (n = 0; n < this.hp; ++n) {
                this.heap[n] = new V4Obj();
            }
            this.stack = new V4Obj[this.stackMax];
            for (n = 0; n < this.stackMax; ++n) {
                this.stack[n] = new V4Obj();
            }
        }

        final void expandVarArray(MatrixVariableI matrixVariableI) {
            V4Obj[] v4ObjArray = new V4Obj[this.vars.length + 1];
            System.arraycopy(this.vars, 0, v4ObjArray, 0, this.vars.length);
            v4ObjArray[this.vars.length] = new V4Obj();
            this.vars = v4ObjArray;
        }

        final void copyVar(int n, MVector mVector) {
            this.vars[n].fromVec(mVector);
        }

        final void add() {
            V4Obj v4Obj = this.stack[--this.sp];
            V4Obj v4Obj2 = this.stack[--this.sp];
            V4Obj v4Obj3 = this.heap[this.hp++];
            v4Obj3.a = v4Obj2.a + v4Obj.a;
            v4Obj3.b = v4Obj2.b + v4Obj.b;
            v4Obj3.c = v4Obj2.c + v4Obj.c;
            v4Obj3.d = v4Obj2.d + v4Obj.d;
            this.stack[this.sp++] = v4Obj3;
        }

        final void sub() {
            V4Obj v4Obj = this.stack[--this.sp];
            V4Obj v4Obj2 = this.stack[--this.sp];
            V4Obj v4Obj3 = this.heap[this.hp++];
            v4Obj3.a = v4Obj2.a - v4Obj.a;
            v4Obj3.b = v4Obj2.b - v4Obj.b;
            v4Obj3.c = v4Obj2.c - v4Obj.c;
            v4Obj3.d = v4Obj2.d - v4Obj.d;
            this.stack[this.sp++] = v4Obj3;
        }

        final void uminus() {
            V4Obj v4Obj = this.stack[--this.sp];
            V4Obj v4Obj2 = this.heap[this.hp++];
            v4Obj2.a = -v4Obj.a;
            v4Obj2.b = -v4Obj.b;
            v4Obj2.c = -v4Obj.c;
            v4Obj2.d = -v4Obj.d;
            this.stack[this.sp++] = v4Obj2;
        }

        final void mulS() {
            V4Obj v4Obj = this.stack[--this.sp];
            double d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            V4Obj v4Obj2 = this.heap[this.hp++];
            v4Obj2.a = d * v4Obj.a;
            v4Obj2.b = d * v4Obj.b;
            v4Obj2.c = d * v4Obj.c;
            v4Obj2.d = d * v4Obj.d;
            this.stack[this.sp++] = v4Obj2;
        }

        final void divS() {
            V4Obj v4Obj = this.stack[--this.sp];
            double d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            V4Obj v4Obj2 = this.heap[this.hp++];
            v4Obj2.a = v4Obj.a / d;
            v4Obj2.b = v4Obj.b / d;
            v4Obj2.c = v4Obj.c / d;
            v4Obj2.d = v4Obj.d / d;
            this.stack[this.sp++] = v4Obj2;
        }

        final void makeList() {
            V4Obj v4Obj = this.heap[this.hp++];
            v4Obj.d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            v4Obj.c = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            v4Obj.b = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            v4Obj.a = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            this.stack[this.sp++] = v4Obj;
        }

        final void assign(int n) {
            V4Obj v4Obj = this.stack[--this.sp];
            ++this.sp;
            V4Obj v4Obj2 = this.vars[n];
            v4Obj2.a = v4Obj.a;
            v4Obj2.b = v4Obj.b;
            v4Obj2.c = v4Obj.c;
            v4Obj2.d = v4Obj.d;
        }

        final void eq() {
            V4Obj v4Obj = this.stack[--this.sp];
            V4Obj v4Obj2 = this.stack[--this.sp];
            MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = v4Obj2.a == v4Obj.a && v4Obj2.b == v4Obj.b && v4Obj2.c == v4Obj.c && v4Obj2.d == v4Obj.d ? 1.0 : 0.0;
        }
    }

    private static final class V4Obj
    extends VecObj {
        double a;
        double b;
        double c;
        double d;
        private static Dimensions dims = Dimensions.valueOf(4);

        private V4Obj() {
        }

        public Dimensions getDims() {
            return dims;
        }

        public String toString() {
            return "[" + this.a + "," + this.b + "," + this.c + "," + this.d + "]";
        }

        public void fromVec(MVector mVector) {
            this.a = (Double)mVector.getEle(0);
            this.b = (Double)mVector.getEle(1);
            this.c = (Double)mVector.getEle(2);
            this.d = (Double)mVector.getEle(3);
        }

        public void copyToVec(MVector mVector) {
            mVector.setEle(0, new Double(this.a));
            mVector.setEle(1, new Double(this.b));
            mVector.setEle(2, new Double(this.c));
            mVector.setEle(3, new Double(this.d));
        }

        public double[] toArrayVec() {
            return new double[]{this.a, this.b, this.c, this.d};
        }
    }

    private final class V3Store
    extends VecStore {
        V3Obj[] stack;
        V3Obj[] heap;
        V3Obj[] vars = new V3Obj[0];

        private V3Store() {
        }

        final void alloc() {
            int n;
            this.heap = new V3Obj[this.hp];
            for (n = 0; n < this.hp; ++n) {
                this.heap[n] = new V3Obj();
            }
            this.stack = new V3Obj[this.stackMax];
            for (n = 0; n < this.stackMax; ++n) {
                this.stack[n] = new V3Obj();
            }
        }

        final void expandVarArray(MatrixVariableI matrixVariableI) {
            V3Obj[] v3ObjArray = new V3Obj[this.vars.length + 1];
            System.arraycopy(this.vars, 0, v3ObjArray, 0, this.vars.length);
            v3ObjArray[this.vars.length] = new V3Obj();
            this.vars = v3ObjArray;
        }

        final void copyVar(int n, MVector mVector) {
            this.vars[n].fromVec(mVector);
        }

        final void add() {
            V3Obj v3Obj = this.stack[--this.sp];
            V3Obj v3Obj2 = this.stack[--this.sp];
            V3Obj v3Obj3 = this.heap[this.hp++];
            v3Obj3.a = v3Obj2.a + v3Obj.a;
            v3Obj3.b = v3Obj2.b + v3Obj.b;
            v3Obj3.c = v3Obj2.c + v3Obj.c;
            this.stack[this.sp++] = v3Obj3;
        }

        final void sub() {
            V3Obj v3Obj = this.stack[--this.sp];
            V3Obj v3Obj2 = this.stack[--this.sp];
            V3Obj v3Obj3 = this.heap[this.hp++];
            v3Obj3.a = v3Obj2.a - v3Obj.a;
            v3Obj3.b = v3Obj2.b - v3Obj.b;
            v3Obj3.c = v3Obj2.c - v3Obj.c;
            this.stack[this.sp++] = v3Obj3;
        }

        final void uminus() {
            V3Obj v3Obj = this.stack[--this.sp];
            V3Obj v3Obj2 = this.heap[this.hp++];
            v3Obj2.a = -v3Obj.a;
            v3Obj2.b = -v3Obj.b;
            v3Obj2.c = -v3Obj.c;
            this.stack[this.sp++] = v3Obj2;
        }

        final void mulS() {
            V3Obj v3Obj = this.stack[--this.sp];
            double d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            V3Obj v3Obj2 = this.heap[this.hp++];
            v3Obj2.a = d * v3Obj.a;
            v3Obj2.b = d * v3Obj.b;
            v3Obj2.c = d * v3Obj.c;
            this.stack[this.sp++] = v3Obj2;
        }

        final void divS() {
            V3Obj v3Obj = this.stack[--this.sp];
            double d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            V3Obj v3Obj2 = this.heap[this.hp++];
            v3Obj2.a = v3Obj.a / d;
            v3Obj2.b = v3Obj.b / d;
            v3Obj2.c = v3Obj.c / d;
            this.stack[this.sp++] = v3Obj2;
        }

        final void makeList() {
            V3Obj v3Obj = this.heap[this.hp++];
            v3Obj.c = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            v3Obj.b = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            v3Obj.a = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            this.stack[this.sp++] = v3Obj;
        }

        final void assign(int n) {
            V3Obj v3Obj = this.stack[--this.sp];
            ++this.sp;
            V3Obj v3Obj2 = this.vars[n];
            v3Obj2.a = v3Obj.a;
            v3Obj2.b = v3Obj.b;
            v3Obj2.c = v3Obj.c;
        }

        final void eq() {
            V3Obj v3Obj = this.stack[--this.sp];
            V3Obj v3Obj2 = this.stack[--this.sp];
            MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = v3Obj2.a == v3Obj.a && v3Obj2.b == v3Obj.b && v3Obj2.c == v3Obj.c ? 1.0 : 0.0;
        }
    }

    private static final class V3Obj
    extends VecObj {
        double a;
        double b;
        double c;
        private static Dimensions dims = Dimensions.THREE;

        private V3Obj() {
        }

        public Dimensions getDims() {
            return dims;
        }

        public String toString() {
            return "[" + this.a + "," + this.b + "," + this.c + "]";
        }

        public void fromVec(MVector mVector) {
            this.a = (Double)mVector.getEle(0);
            this.b = (Double)mVector.getEle(1);
            this.c = (Double)mVector.getEle(2);
        }

        public void copyToVec(MVector mVector) {
            mVector.setEle(0, new Double(this.a));
            mVector.setEle(1, new Double(this.b));
            mVector.setEle(2, new Double(this.c));
        }

        public double[] toArrayVec() {
            return new double[]{this.a, this.b, this.c};
        }
    }

    private final class V2Store
    extends VecStore {
        V2Obj[] stack;
        V2Obj[] heap;
        V2Obj[] vars = new V2Obj[0];

        private V2Store() {
        }

        final void alloc() {
            int n;
            this.heap = new V2Obj[this.hp];
            for (n = 0; n < this.hp; ++n) {
                this.heap[n] = new V2Obj();
            }
            this.stack = new V2Obj[this.stackMax];
            for (n = 0; n < this.stackMax; ++n) {
                this.stack[n] = new V2Obj();
            }
        }

        final void expandVarArray(MatrixVariableI matrixVariableI) {
            V2Obj[] v2ObjArray = new V2Obj[this.vars.length + 1];
            System.arraycopy(this.vars, 0, v2ObjArray, 0, this.vars.length);
            v2ObjArray[this.vars.length] = new V2Obj();
            this.vars = v2ObjArray;
        }

        final void copyVar(int n, MVector mVector) {
            this.vars[n].fromVec(mVector);
        }

        final void add() {
            V2Obj v2Obj = this.stack[--this.sp];
            V2Obj v2Obj2 = this.stack[--this.sp];
            V2Obj v2Obj3 = this.heap[this.hp++];
            v2Obj3.a = v2Obj2.a + v2Obj.a;
            v2Obj3.b = v2Obj2.b + v2Obj.b;
            this.stack[this.sp++] = v2Obj3;
        }

        final void sub() {
            V2Obj v2Obj = this.stack[--this.sp];
            V2Obj v2Obj2 = this.stack[--this.sp];
            V2Obj v2Obj3 = this.heap[this.hp++];
            v2Obj3.a = v2Obj2.a - v2Obj.a;
            v2Obj3.b = v2Obj2.b - v2Obj.b;
            this.stack[this.sp++] = v2Obj3;
        }

        final void uminus() {
            V2Obj v2Obj = this.stack[--this.sp];
            V2Obj v2Obj2 = this.heap[this.hp++];
            v2Obj2.a = -v2Obj.a;
            v2Obj2.b = -v2Obj.b;
            this.stack[this.sp++] = v2Obj2;
        }

        final void mulS() {
            V2Obj v2Obj = this.stack[--this.sp];
            double d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            V2Obj v2Obj2 = this.heap[this.hp++];
            v2Obj2.a = d * v2Obj.a;
            v2Obj2.b = d * v2Obj.b;
            this.stack[this.sp++] = v2Obj2;
        }

        final void divS() {
            V2Obj v2Obj = this.stack[--this.sp];
            double d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            V2Obj v2Obj2 = this.heap[this.hp++];
            v2Obj2.a = v2Obj.a / d;
            v2Obj2.b = v2Obj.b / d;
            this.stack[this.sp++] = v2Obj2;
        }

        final void mulV2() {
            V2Obj v2Obj = this.stack[--this.sp];
            V2Obj v2Obj2 = this.stack[--this.sp];
            V2Obj v2Obj3 = this.heap[this.hp++];
            v2Obj3.a = v2Obj2.a * v2Obj.a - v2Obj2.a * v2Obj.b;
            v2Obj3.b = v2Obj2.a * v2Obj.b + v2Obj2.b * v2Obj.a;
            this.stack[this.sp++] = v2Obj3;
        }

        final void makeList() {
            V2Obj v2Obj = this.heap[this.hp++];
            v2Obj.b = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            v2Obj.a = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            this.stack[this.sp++] = v2Obj;
        }

        final void assign(int n) {
            V2Obj v2Obj = this.stack[--this.sp];
            ++this.sp;
            V2Obj v2Obj2 = this.vars[n];
            v2Obj2.a = v2Obj.a;
            v2Obj2.b = v2Obj.b;
        }

        final void eq() {
            V2Obj v2Obj = this.stack[--this.sp];
            V2Obj v2Obj2 = this.stack[--this.sp];
            MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = v2Obj2.a == v2Obj.a && v2Obj2.b == v2Obj.b ? 1.0 : 0.0;
        }
    }

    private static final class V2Obj
    extends VecObj {
        double a;
        double b;
        private static Dimensions dims = Dimensions.TWO;

        private V2Obj() {
        }

        public Dimensions getDims() {
            return dims;
        }

        public String toString() {
            return "[" + this.a + "," + this.b + "]";
        }

        public void fromVec(MVector mVector) {
            this.a = (Double)mVector.getEle(0);
            this.b = (Double)mVector.getEle(1);
        }

        public void copyToVec(MVector mVector) {
            mVector.setEle(0, new Double(this.a));
            mVector.setEle(1, new Double(this.b));
        }

        public double[] toArrayVec() {
            return new double[]{this.a, this.b};
        }
    }

    private abstract class VecStore
    extends ObjStore {
        private VecStore() {
        }

        abstract void copyVar(int var1, MVector var2);

        final void copyFromVar(MatrixVariableI matrixVariableI, int n) {
            if (matrixVariableI.hasValidValue()) {
                MVector mVector = (MVector)((MatrixVariable)matrixVariableI).getMValue();
                this.copyVar(n, mVector);
            }
        }

        public final void setVarValue(int n, MatrixValueI matrixValueI) {
            this.copyVar(n, (MVector)matrixValueI);
        }
    }

    private final class ScalerStore
    extends ObjStore {
        double[] stack = new double[0];
        double[] vars = new double[0];

        private ScalerStore() {
        }

        final void alloc() {
            this.stack = new double[this.stackMax];
        }

        final void expandVarArray(MatrixVariableI matrixVariableI) {
            double[] dArray = new double[this.vars.length + 1];
            System.arraycopy(this.vars, 0, dArray, 0, this.vars.length);
            this.vars = dArray;
        }

        final void copyFromVar(MatrixVariableI matrixVariableI, int n) {
            if (matrixVariableI.hasValidValue()) {
                Scaler scaler = (Scaler)matrixVariableI.getMValue();
                this.vars[n] = scaler.doubleValue();
            }
        }

        public void setVarValue(int n, double d) {
            this.vars[n] = d;
        }

        public final void setVarValue(int n, MatrixValueI matrixValueI) {
            this.vars[n] = ((Scaler)matrixValueI).doubleValue();
        }

        final void add() {
            double d = this.stack[--this.sp];
            int n = this.sp - 1;
            this.stack[n] = this.stack[n] + d;
        }

        final void sub() {
            double d = this.stack[--this.sp];
            int n = this.sp - 1;
            this.stack[n] = this.stack[n] - d;
        }

        final void uminus() {
            double d = this.stack[--this.sp];
            this.stack[this.sp++] = -d;
        }

        final void mulS() {
            double d = this.stack[--this.sp];
            int n = this.sp - 1;
            this.stack[n] = this.stack[n] * d;
        }

        final void divS() {
            double d = this.stack[--this.sp];
            int n = this.sp - 1;
            this.stack[n] = this.stack[n] / d;
        }

        final void mod() {
            double d = this.stack[--this.sp];
            int n = this.sp - 1;
            this.stack[n] = this.stack[n] % d;
        }

        final void pow() {
            double d = this.stack[--this.sp];
            double d2 = this.stack[--this.sp];
            this.stack[this.sp++] = Math.pow(d2, d);
        }

        final void powN(int n) {
            double d = this.stack[--this.sp];
            switch (n) {
                case 0: {
                    d = 1.0;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    d *= d;
                    break;
                }
                case 3: {
                    d *= d * d;
                    break;
                }
                case 4: {
                    d *= d * d * d;
                    break;
                }
                case 5: {
                    d *= d * d * d * d;
                    break;
                }
                default: {
                    d = Math.pow(d, n);
                }
            }
            this.stack[this.sp++] = d;
        }

        final void makeList() {
        }

        final void assign(int n) {
            this.vars[n] = this.stack[--this.sp];
            ++this.sp;
        }

        final void and() {
            double d;
            double d2 = this.stack[--this.sp];
            this.stack[this.sp++] = (d = this.stack[--this.sp]) != 0.0 && d2 != 0.0 ? 1.0 : 0.0;
        }

        final void or() {
            double d;
            double d2 = this.stack[--this.sp];
            this.stack[this.sp++] = (d = this.stack[--this.sp]) != 0.0 || d2 != 0.0 ? 1.0 : 0.0;
        }

        final void not() {
            double d;
            this.stack[this.sp++] = (d = this.stack[--this.sp]) == 0.0 ? 1.0 : 0.0;
        }

        final void lt() {
            double d;
            double d2;
            this.stack[this.sp++] = (d2 = this.stack[--this.sp]) < (d = this.stack[--this.sp]) ? 1.0 : 0.0;
        }

        final void gt() {
            double d;
            double d2;
            this.stack[this.sp++] = (d2 = this.stack[--this.sp]) > (d = this.stack[--this.sp]) ? 1.0 : 0.0;
        }

        final void le() {
            double d;
            double d2;
            this.stack[this.sp++] = (d2 = this.stack[--this.sp]) <= (d = this.stack[--this.sp]) ? 1.0 : 0.0;
        }

        final void ge() {
            double d;
            double d2;
            this.stack[this.sp++] = (d2 = this.stack[--this.sp]) >= (d = this.stack[--this.sp]) ? 1.0 : 0.0;
        }

        final void eq() {
            double d;
            double d2;
            this.stack[this.sp++] = (d2 = this.stack[--this.sp]) == (d = this.stack[--this.sp]) ? 1.0 : 0.0;
        }

        final void neq() {
            double d;
            double d2;
            this.stack[this.sp++] = (d2 = this.stack[--this.sp]) != (d = this.stack[--this.sp]) ? 1.0 : 0.0;
        }
    }

    private static abstract class ObjStore
    implements Observer {
        Hashtable varRefs = new Hashtable();
        int sp = 0;
        int stackMax = 0;
        int hp = 0;

        private ObjStore() {
        }

        final void incStack() {
            ++this.sp;
            if (this.sp > this.stackMax) {
                this.stackMax = this.sp;
            }
        }

        final void incHeap() {
            ++this.hp;
        }

        final void decStack() throws ParseException {
            --this.sp;
            if (this.sp < 0) {
                throw new ParseException("RPEval: stack error");
            }
        }

        final void reset() {
            this.sp = 0;
            this.hp = 0;
        }

        final int addVar(MatrixVariableI matrixVariableI) {
            Object v = this.varRefs.get(matrixVariableI);
            if (v == null) {
                int n = this.varRefs.size();
                this.expandVarArray(matrixVariableI);
                this.varRefs.put(matrixVariableI, new Integer(n));
                this.copyFromVar(matrixVariableI, n);
                ((Variable)((Object)matrixVariableI)).addObserver(this);
                return n;
            }
            return (Integer)v;
        }

        public final void update(Observable observable, Object object) {
            MatrixVariableI matrixVariableI = (MatrixVariableI)((Object)observable);
            Object v = this.varRefs.get(matrixVariableI);
            this.copyFromVar(matrixVariableI, (Integer)v);
        }

        public abstract void setVarValue(int var1, MatrixValueI var2);

        abstract void alloc();

        final void cleanUp() {
            Enumeration enumeration = this.varRefs.keys();
            while (enumeration.hasMoreElements()) {
                Variable variable = (Variable)enumeration.nextElement();
                variable.deleteObserver(this);
            }
            this.varRefs.clear();
        }

        abstract void copyFromVar(MatrixVariableI var1, int var2);

        abstract void expandVarArray(MatrixVariableI var1);

        abstract void add();

        abstract void sub();

        abstract void uminus();

        abstract void mulS();

        abstract void makeList();

        abstract void assign(int var1);
    }

    private static abstract class MatObj
    extends MRpRes {
        private MatObj() {
        }

        public final void copyToVecMat(MatrixValueI matrixValueI) throws ParseException {
            if (!this.getDims().equals(matrixValueI.getDim())) {
                throw new ParseException("CopyToVecMat: dimension of argument " + matrixValueI.getDim() + " is not equal to dimension of object " + this.getDims());
            }
            this.copyToMat((Matrix)matrixValueI);
        }

        public abstract void copyToMat(Matrix var1);

        abstract double[][] toArrayMat();

        public Object toArray() {
            return this.toArrayMat();
        }
    }

    private static abstract class VecObj
    extends MRpRes {
        private VecObj() {
        }

        public final void copyToVecMat(MatrixValueI matrixValueI) throws ParseException {
            if (!this.getDims().equals(matrixValueI.getDim())) {
                throw new ParseException("CopyToVecMat: dimension of argument " + matrixValueI.getDim() + " is not equal to dimension of object " + this.getDims());
            }
            this.copyToVec((MVector)matrixValueI);
        }

        public abstract void copyToVec(MVector var1);

        abstract double[] toArrayVec();

        public Object toArray() {
            return this.toArrayVec();
        }
    }

    private static final class ScalerObj
    extends MRpRes {
        double a;

        private ScalerObj(double d) {
            this.a = d;
        }

        public final Dimensions getDims() {
            return Dimensions.ONE;
        }

        public final void copyToVecMat(MatrixValueI matrixValueI) throws ParseException {
            if (!matrixValueI.getDim().is0D()) {
                throw new ParseException("CopyToVecMat: dimension of argument " + matrixValueI.getDim() + " is not equal to dimension of object " + this.getDims());
            }
            matrixValueI.setEle(0, new Double(this.a));
        }

        public final String toString() {
            return String.valueOf(this.a);
        }

        public Object toArray() {
            return new double[]{this.a};
        }
    }
}

