/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Polygon;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;

public class ThresholdToSelection
implements PlugInFilter {
    ImagePlus image;
    ImageProcessor ip;
    float min;
    float max;
    int w;
    int h;

    public void run(ImageProcessor ip) {
        this.ip = ip;
        this.min = (float)ip.getMinThreshold();
        this.max = (float)ip.getMaxThreshold();
        this.w = ip.getWidth();
        this.h = ip.getHeight();
        this.image.setRoi(this.getRoi());
    }

    final boolean selected(int x, int y) {
        float v = this.ip.getf(x, y);
        return v >= this.min && v <= this.max;
    }

    Roi getRoi() {
        IJ.showStatus("Converting threshold to selection");
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        int progressInc = Math.max(this.h / 50, 1);
        boolean[] prevRow = new boolean[this.w + 2];
        boolean[] thisRow = new boolean[this.w + 2];
        Outline[] outline = new Outline[this.w + 1];
        for (int y = 0; y <= this.h; ++y) {
            boolean[] b2 = prevRow;
            prevRow = thisRow;
            thisRow = b2;
            for (int x = 0; x <= this.w; ++x) {
                int x1;
                thisRow[x + 1] = y < this.h && x < this.w ? this.selected(x, y) : false;
                if (thisRow[x + 1]) {
                    if (!prevRow[x + 1]) {
                        if (outline[x] == null) {
                            if (outline[x + 1] == null) {
                                outline[x + 1] = outline[x] = new Outline();
                                outline[x].push(x + 1, y);
                                outline[x].push(x, y);
                            } else {
                                outline[x] = outline[x + 1];
                                outline[x + 1] = null;
                                outline[x].push(x, y);
                            }
                        } else if (outline[x + 1] == null) {
                            outline[x + 1] = outline[x];
                            outline[x] = null;
                            outline[x + 1].shift(x + 1, y);
                        } else if (outline[x + 1] == outline[x]) {
                            polygons.add(outline[x].getPolygon());
                            outline[x + 1] = null;
                            outline[x] = null;
                        } else {
                            outline[x].shift(outline[x + 1]);
                            for (x1 = 0; x1 <= this.w; ++x1) {
                                if (x1 == x + 1 || outline[x1] != outline[x + 1]) continue;
                                outline[x1] = outline[x];
                                outline[x + 1] = null;
                                outline[x] = null;
                                break;
                            }
                            if (outline[x] != null) {
                                throw new RuntimeException("assertion failed");
                            }
                        }
                    }
                    if (thisRow[x]) continue;
                    if (outline[x] == null) {
                        throw new RuntimeException("assertion failed!");
                    }
                    outline[x].push(x, y + 1);
                    continue;
                }
                if (prevRow[x + 1]) {
                    if (outline[x] == null) {
                        if (outline[x + 1] == null) {
                            Outline outline2 = new Outline();
                            outline[x + 1] = outline2;
                            outline[x] = outline2;
                            outline[x].push(x, y);
                            outline[x].push(x + 1, y);
                        } else {
                            outline[x] = outline[x + 1];
                            outline[x + 1] = null;
                            outline[x].shift(x, y);
                        }
                    } else if (outline[x + 1] == null) {
                        outline[x + 1] = outline[x];
                        outline[x] = null;
                        outline[x + 1].push(x + 1, y);
                    } else if (outline[x + 1] == outline[x]) {
                        polygons.add(outline[x].getPolygon());
                        outline[x + 1] = null;
                        outline[x] = null;
                    } else {
                        outline[x].push(outline[x + 1]);
                        for (x1 = 0; x1 <= this.w; ++x1) {
                            if (x1 == x + 1 || outline[x1] != outline[x + 1]) continue;
                            outline[x1] = outline[x];
                            outline[x + 1] = null;
                            outline[x] = null;
                            break;
                        }
                        if (outline[x] != null) {
                            throw new RuntimeException("assertion failed");
                        }
                    }
                }
                if (!thisRow[x]) continue;
                if (outline[x] == null) {
                    throw new RuntimeException("assertion failed");
                }
                outline[x].shift(x, y + 1);
            }
            if ((y & progressInc) != 0) continue;
            IJ.showProgress(y + 1, this.h + 1);
        }
        GeneralPath path = new GeneralPath(0);
        for (int i = 0; i < polygons.size(); ++i) {
            path.append((Polygon)polygons.get(i), false);
        }
        ShapeRoi shape = new ShapeRoi(path);
        Roi roi = shape != null ? shape.shapeToRoi() : null;
        IJ.showProgress(1, 1);
        if (roi != null) {
            return roi;
        }
        return shape;
    }

    public int setup(String arg, ImagePlus imp) {
        this.image = imp;
        return 141;
    }

    static class Outline {
        int[] x = new int[this.reserved];
        int[] y = new int[this.reserved];
        int first = 5;
        int last = 5;
        int reserved = 10;
        final int GROW = 10;

        private void needs(int newCount, int offset) {
            if (newCount > this.reserved || offset > this.first) {
                if (newCount < this.reserved + 10 + 1) {
                    newCount = this.reserved + 10 + 1;
                }
                int[] newX = new int[newCount];
                int[] newY = new int[newCount];
                System.arraycopy(this.x, 0, newX, offset, this.last);
                System.arraycopy(this.y, 0, newY, offset, this.last);
                this.x = newX;
                this.y = newY;
                this.first += offset;
                this.last += offset;
                this.reserved = newCount;
            }
        }

        public void push(int x, int y) {
            this.needs(this.last + 1, 0);
            this.x[this.last] = x;
            this.y[this.last] = y;
            ++this.last;
        }

        public void shift(int x, int y) {
            this.needs(this.last + 1, 10);
            --this.first;
            this.x[this.first] = x;
            this.y[this.first] = y;
        }

        public void push(Outline o) {
            int count = o.last - o.first;
            this.needs(this.last + count, 0);
            System.arraycopy(o.x, o.first, this.x, this.last, count);
            System.arraycopy(o.y, o.first, this.y, this.last, count);
            this.last += count;
        }

        public void shift(Outline o) {
            int count = o.last - o.first;
            this.needs(this.last + count + 10, count + 10);
            this.first -= count;
            System.arraycopy(o.x, o.first, this.x, this.first, count);
            System.arraycopy(o.y, o.first, this.y, this.first, count);
        }

        public Polygon getPolygon() {
            int y1;
            int x2;
            int y2;
            int x1;
            int j = this.first + 1;
            int i = this.first + 1;
            while (i + 1 < this.last) {
                x1 = this.x[j] - this.x[j - 1];
                y2 = this.y[j + 1] - this.y[j];
                x2 = this.x[j + 1] - this.x[j];
                y1 = this.y[j] - this.y[j - 1];
                if (x1 * y2 == x2 * y1) {
                    --this.last;
                } else {
                    if (i != j) {
                        this.x[i] = this.x[j];
                        this.y[i] = this.y[j];
                    }
                    ++i;
                }
                ++j;
            }
            x1 = this.x[j] - this.x[j - 1];
            y2 = this.y[this.first] - this.y[j];
            x2 = this.x[this.first] - this.x[j];
            y1 = this.y[j] - this.y[j - 1];
            if (x1 * y2 == x2 * y1) {
                --this.last;
            } else {
                this.x[i] = this.x[j];
                this.y[i] = this.y[j];
            }
            int count = this.last - this.first;
            int[] xNew = new int[count];
            int[] yNew = new int[count];
            System.arraycopy(this.x, this.first, xNew, 0, count);
            System.arraycopy(this.y, this.first, yNew, 0, count);
            return new Polygon(xNew, yNew, count);
        }

        public String toString() {
            String res = "(first:" + this.first + ",last:" + this.last + ",reserved:" + this.reserved + ":";
            if (this.last > this.x.length) {
                System.err.println("ERROR!");
            }
            for (int i = this.first; i < this.last && i < this.x.length; ++i) {
                res = res + "(" + this.x[i] + "," + this.y[i] + ")";
            }
            return res + ")";
        }
    }
}

