/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.plugin.filter.MaximumFinder;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;

public class EDM
implements PlugInFilter {
    public static final int ONE = 41;
    public static final int SQRT2 = 58;
    public static final int SQRT5 = 92;
    ImagePlus imp;
    String arg;
    int slice;
    boolean invertImage;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        this.arg = arg;
        if (imp != null) {
            boolean invertedLut = imp.isInvertedLut();
            this.invertImage = invertedLut && Prefs.blackBackground || !invertedLut && !Prefs.blackBackground;
        }
        return IJ.setupDialog(imp, 1);
    }

    public void run(ImageProcessor ip) {
        this.imp.killRoi();
        ++this.slice;
        ImageStatistics stats = this.imp.getStatistics();
        if (this.slice == 1 && stats.histogram[0] + stats.histogram[255] != stats.pixelCount) {
            IJ.error("8-bit binary image (0 and 255) required.");
            return;
        }
        if (this.invertImage) {
            ip.invert();
        }
        if (this.arg.equals("points") || this.arg.equals("watershed")) {
            int outputType = this.arg.equals("watershed") ? 2 : 0;
            MaximumFinder fm = new MaximumFinder();
            ShortProcessor ip16 = this.make16bitEDM(ip);
            ByteProcessor maxIp = fm.findMaxima(ip16, 20.5, -808080.0, outputType, false, true);
            if (maxIp != null) {
                if (this.arg.equals("watershed")) {
                    ip.copyBits(maxIp, 0, 0, 0);
                } else {
                    byte[] image8 = (byte[])ip.getPixels();
                    short[] image16 = (short[])((ImageProcessor)ip16).getPixels();
                    this.convertToBytes(image16, image8);
                    ip.copyBits(maxIp, 0, 0, 9);
                }
            }
        } else {
            this.toEDM(ip);
        }
        if (this.invertImage) {
            ip.invert();
        }
    }

    public void toEDM(ImageProcessor ip) {
        ShortProcessor ip16 = this.make16bitEDM(ip);
        byte[] image8 = (byte[])ip.getPixels();
        short[] image16 = (short[])((ImageProcessor)ip16).getPixels();
        this.convertToBytes(image16, image8);
    }

    public ShortProcessor make16bitEDM(ImageProcessor ip) {
        int offset;
        int x;
        int y;
        IJ.showStatus("Generating EDM");
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        int rowsize = width;
        int xmax = width - 2;
        int ymax = height - 2;
        ShortProcessor ip16 = (ShortProcessor)ip.convertToShort(false);
        ip16.multiply(128.0);
        short[] image16 = (short[])ip16.getPixels();
        int inc = Math.max(height / 50, 1);
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                offset = x + y * rowsize;
                if (image16[offset] <= 0) continue;
                if (x <= 1 || x >= xmax || y <= 1 || y >= ymax) {
                    this.setEdgeValue(offset, rowsize, image16, x, y, xmax, ymax);
                    continue;
                }
                this.setValue(offset, rowsize, image16);
            }
            if ((inc & 0) != 0) continue;
            IJ.showProgress(y / 2, height);
        }
        for (y = height - 1; y >= 0; --y) {
            for (x = width - 1; x >= 0; --x) {
                offset = x + y * rowsize;
                if (image16[offset] <= 0) continue;
                if (x <= 1 || x >= xmax || y <= 1 || y >= ymax) {
                    this.setEdgeValue(offset, rowsize, image16, x, y, xmax, ymax);
                    continue;
                }
                this.setValue(offset, rowsize, image16);
            }
            if ((inc & 0) != 0) continue;
            IJ.showProgress(height / 2 + (height - y) / 2, height);
        }
        IJ.showProgress(1, 1);
        return ip16;
    }

    void setValue(int offset, int rowsize, short[] image16) {
        int r1 = offset - rowsize - rowsize - 2;
        int r2 = r1 + rowsize;
        int r3 = r2 + rowsize;
        int r4 = r3 + rowsize;
        int r5 = r4 + rowsize;
        int v = image16[r2 + 2] + 41;
        int min = Short.MAX_VALUE;
        if (v < min) {
            min = v;
        }
        if ((v = image16[r3 + 1] + 41) < min) {
            min = v;
        }
        if ((v = image16[r3 + 3] + 41) < min) {
            min = v;
        }
        if ((v = image16[r4 + 2] + 41) < min) {
            min = v;
        }
        if ((v = image16[r2 + 1] + 58) < min) {
            min = v;
        }
        if ((v = image16[r2 + 3] + 58) < min) {
            min = v;
        }
        if ((v = image16[r4 + 1] + 58) < min) {
            min = v;
        }
        if ((v = image16[r4 + 3] + 58) < min) {
            min = v;
        }
        if ((v = image16[r1 + 1] + 92) < min) {
            min = v;
        }
        if ((v = image16[r1 + 3] + 92) < min) {
            min = v;
        }
        if ((v = image16[r2 + 4] + 92) < min) {
            min = v;
        }
        if ((v = image16[r4 + 4] + 92) < min) {
            min = v;
        }
        if ((v = image16[r5 + 3] + 92) < min) {
            min = v;
        }
        if ((v = image16[r5 + 1] + 92) < min) {
            min = v;
        }
        if ((v = image16[r4] + 92) < min) {
            min = v;
        }
        if ((v = image16[r2] + 92) < min) {
            min = v;
        }
        image16[offset] = (short)min;
    }

    void setEdgeValue(int offset, int rowsize, short[] image16, int x, int y, int xmax, int ymax) {
        int r1 = offset - rowsize - rowsize - 2;
        int r2 = r1 + rowsize;
        int r3 = r2 + rowsize;
        int r4 = r3 + rowsize;
        int r5 = r4 + rowsize;
        int min = Short.MAX_VALUE;
        short offimage = image16[r3 + 2];
        int v = y < 1 ? offimage + 41 : image16[r2 + 2] + 41;
        if (v < min) {
            min = v;
        }
        if ((v = x < 1 ? offimage + 41 : image16[r3 + 1] + 41) < min) {
            min = v;
        }
        if ((v = x > xmax ? offimage + 41 : image16[r3 + 3] + 41) < min) {
            min = v;
        }
        if ((v = y > ymax ? offimage + 41 : image16[r4 + 2] + 41) < min) {
            min = v;
        }
        if ((v = x < 1 || y < 1 ? offimage + 58 : image16[r2 + 1] + 58) < min) {
            min = v;
        }
        if ((v = x > xmax || y < 1 ? offimage + 58 : image16[r2 + 3] + 58) < min) {
            min = v;
        }
        if ((v = x < 1 || y > ymax ? offimage + 58 : image16[r4 + 1] + 58) < min) {
            min = v;
        }
        if ((v = x > xmax || y > ymax ? offimage + 58 : image16[r4 + 3] + 58) < min) {
            min = v;
        }
        if ((v = x < 1 || y <= 1 ? offimage + 92 : image16[r1 + 1] + 92) < min) {
            min = v;
        }
        if ((v = x > xmax || y <= 1 ? offimage + 92 : image16[r1 + 3] + 92) < min) {
            min = v;
        }
        if ((v = x >= xmax || y < 1 ? offimage + 92 : image16[r2 + 4] + 92) < min) {
            min = v;
        }
        if ((v = x >= xmax || y > ymax ? offimage + 92 : image16[r4 + 4] + 92) < min) {
            min = v;
        }
        if ((v = x > xmax || y >= ymax ? offimage + 92 : image16[r5 + 3] + 92) < min) {
            min = v;
        }
        if ((v = x < 1 || y >= ymax ? offimage + 92 : image16[r5 + 1] + 92) < min) {
            min = v;
        }
        if ((v = x <= 1 || y > ymax ? offimage + 92 : image16[r4] + 92) < min) {
            min = v;
        }
        if ((v = x <= 1 || y < 1 ? offimage + 92 : image16[r2] + 92) < min) {
            min = v;
        }
        image16[offset] = (short)min;
    }

    void convertToBytes(short[] image16, byte[] image8) {
        int round = 20;
        for (int i = 0; i < image16.length; ++i) {
            int v = (image16[i] + round) / 41;
            if (v > 255) {
                v = 255;
            }
            image8[i] = (byte)v;
        }
    }
}

