/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.ImagePlus;
import ij.gui.Toolbar;
import ij.process.ColorProcessor;
import java.awt.Color;

class ColorGenerator
extends ColorProcessor {
    int w;
    int h;
    ImagePlus imp;
    int[] colors = new int[]{0xFF0000, 65280, 255, 0xFFFFFF, 65535, 0xFF00FF, 0xFFFF00, 0};

    public ColorGenerator(int width, int height, int[] pixels, ImagePlus imp) {
        super(width, height, pixels);
        this.imp = imp;
    }

    void drawColors(int colorWidth, int colorHeight, int columns, int rows) {
        this.w = colorWidth;
        this.h = colorHeight;
        this.setColor(0xFFFFFF);
        this.setRoi(0, 0, 110, 320);
        this.fill();
        this.drawRamp();
        this.resetBW();
        this.flipper();
        this.drawLine(0, 256, 110, 256);
        int x = 1;
        int y = 0;
        this.refreshBackground();
        this.refreshForeground();
        float saturation = 1.0f;
        float brightness = 1.0f;
        double w = colorWidth;
        double h = colorHeight;
        for (x = 2; x < 10; ++x) {
            for (y = 0; y < 32; ++y) {
                float hue = (float)((double)y / (2.0 * h) - 0.15);
                if (x < 6) {
                    saturation = 1.0f;
                    brightness = (float)((double)(x * 4) / w);
                } else {
                    saturation = 1.0f - (float)((double)((5 - x) * -4) / w);
                    brightness = 1.0f;
                }
                Color c2 = Color.getHSBColor(hue, saturation, brightness);
                this.setRoi(x * (int)(w / 2.0), y * (int)(h / 2.0), (int)w / 2, (int)h / 2);
                this.setColor(c2);
                this.fill();
            }
        }
        this.drawSpectrum(h);
        this.resetRoi();
    }

    void drawColor(int x, int y, Color c2) {
        this.setRoi(x * this.w, y * this.h, this.w, this.h);
        this.setColor(c2);
        this.fill();
    }

    public void refreshBackground() {
        this.setColor(0x444444);
        this.drawRect(this.w * 2 - 12, 276, this.w * 2 + 4, this.h * 2 + 4);
        this.setColor(0x999999);
        this.drawRect(this.w * 2 - 11, 277, this.w * 2 + 2, this.h * 2 + 2);
        this.setRoi(this.w * 2 - 10, 278, this.w * 2, this.h * 2);
        this.setColor(Toolbar.getBackgroundColor());
        this.fill();
        this.imp.updateAndDraw();
    }

    public void refreshForeground() {
        this.setColor(0x444444);
        this.drawRect(8, 266, this.w * 2 + 4, this.h * 2 + 4);
        this.setColor(0x999999);
        this.drawRect(9, 267, this.w * 2 + 2, this.h * 2 + 2);
        this.setRoi(10, 268, this.w * 2, this.h * 2);
        this.setColor(Toolbar.getForegroundColor());
        this.fill();
        this.imp.updateAndDraw();
    }

    void drawSpectrum(double h) {
        for (int x = 5; x < 7; ++x) {
            for (int y = 0; y < 32; ++y) {
                float hue = (float)((double)y / (2.0 * h) - 0.15);
                Color c2 = Color.getHSBColor(hue, 1.0f, 1.0f);
                this.setRoi(x * (this.w / 2), y * (int)(h / 2.0), this.w / 2, (int)h / 2);
                this.setColor(c2);
                this.fill();
            }
        }
        this.setRoi(55, 32, 22, 16);
        this.setColor(0xFF0000);
        this.fill();
        this.setRoi(55, 120, 22, 16);
        this.setColor(65280);
        this.fill();
        this.setRoi(55, 208, 22, 16);
        this.setColor(255);
        this.fill();
        this.setRoi(55, 80, 22, 8);
        this.setColor(0xFFFF00);
        this.fill();
        this.setRoi(55, 168, 22, 8);
        this.setColor(65535);
        this.fill();
        this.setRoi(55, 248, 22, 8);
        this.setColor(0xFF00FF);
        this.fill();
    }

    void drawRamp() {
        for (int x = 0; x < this.w; ++x) {
            for (double y = 0.0; y < (double)(this.h * 16); y += 1.0) {
                byte b2;
                byte g = b2 = (byte)y;
                byte r = b2;
                this.pixels[(int)y * this.width + x] = 0xFF000000 | r << 16 & 0xFF0000 | g << 8 & 0xFF00 | b2 & 0xFF;
            }
        }
    }

    void resetBW() {
        this.setColor(0);
        this.drawRect(92, 300, 9, 7);
        this.setColor(0);
        this.setRoi(88, 297, 9, 7);
        this.fill();
    }

    void flipper() {
        int xa = 90;
        int ya = 272;
        this.setColor(0);
        this.drawLine(xa, ya, xa + 9, ya + 9);
        this.drawLine(xa + 1, ya, xa + 9, ya + 8);
        this.drawLine(xa, ya + 1, xa + 8, ya + 9);
        this.drawLine(xa, ya, xa, ya + 5);
        this.drawLine(xa + 1, ya + 1, xa + 1, ya + 6);
        this.drawLine(xa, ya, xa + 5, ya);
        this.drawLine(xa + 1, ya + 1, xa + 6, ya + 1);
        this.drawLine(xa + 9, ya + 9, xa + 9, ya + 4);
        this.drawLine(xa + 8, ya + 8, xa + 8, ya + 3);
        this.drawLine(xa + 9, ya + 9, xa + 4, ya + 9);
        this.drawLine(xa + 8, ya + 8, xa + 3, ya + 8);
    }
}

