/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IRawImage;
import fr.esrf.tangoatk.core.IRawImageListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import java.io.Serializable;

class RawImageHelper
implements Serializable {
    IAttribute attribute;
    EventSupport propChanges;
    byte[][] retval = new byte[1][1];

    public RawImageHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    void init(IAttribute iAttribute) {
        this.setAttribute(iAttribute);
        this.propChanges = ((AAttribute)iAttribute).getPropChanges();
    }

    public void setAttribute(IAttribute iAttribute) {
        this.attribute = iAttribute;
    }

    public IAttribute getAttribute() {
        return this.attribute;
    }

    protected void setProperty(String string, Number number) {
        this.attribute.setProperty(string, number);
        this.attribute.storeConfig();
    }

    protected void setProperty(String string, Number number, boolean bl) {
        this.attribute.setProperty(string, number, bl);
    }

    void fireImageValueChanged(byte[][] byArray, long l) {
        this.propChanges.fireRawImageEvent((IRawImage)this.attribute, byArray, l);
    }

    byte[][] getRawImageValue(DeviceAttribute deviceAttribute) throws DevFailed {
        byte[] byArray = deviceAttribute.extractCharArray();
        int n = this.attribute.getYDimension();
        int n2 = this.attribute.getXDimension();
        if (n != this.retval.length || n2 != this.retval[0].length) {
            this.retval = new byte[n][n2];
        }
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            System.arraycopy(byArray, n3, this.retval[i], 0, n2);
            n3 += n2;
        }
        return this.retval;
    }

    void addRawImageListener(IRawImageListener iRawImageListener) {
        this.propChanges.addRawImageListener(iRawImageListener);
    }

    void removeRawImageListener(IRawImageListener iRawImageListener) {
        this.propChanges.removeRawImageListener(iRawImageListener);
    }

    public String getVersion() {
        return "$Id: RawImageHelper.java,v 1.1 2006/10/10 14:42:08 jlpons Exp $";
    }
}

