/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DispLevel;
import fr.esrf.tangoatk.core.DisplayLevelProperty;
import fr.esrf.tangoatk.core.FormatProperty;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.NumberProperty;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.core.StringProperty;
import fr.esrf.tangoatk.core.WritableProperty;
import fr.esrf.tangoatk.util.AtkTimer;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyStorage {
    protected Map<String, Property> propertyMap = new HashMap<String, Property>();

    public void setProperty(String string, Number number) {
        NumberProperty numberProperty = (NumberProperty)this.propertyMap.get(string);
        if (numberProperty == null) {
            AtkTimer.getInstance().endTimer(Thread.currentThread());
            return;
        }
        numberProperty.setValue(number);
    }

    public void setProperty(IEntity iEntity, String string, Object object, boolean bl) {
        this.propertyMap.put(string, new Property(iEntity, string, object, bl));
    }

    public void setProperty(IEntity iEntity, String string, Number number, boolean bl) {
        Property property = this.propertyMap.get(string);
        if (property == null) {
            this.propertyMap.put(string, new NumberProperty(iEntity, string, number, bl));
        } else {
            property.setValue(number);
        }
    }

    public void setProperty(IAttribute iAttribute, String string, AttrWriteType attrWriteType, boolean bl) {
        Property property = this.propertyMap.get(string);
        if (property == null) {
            this.propertyMap.put(string, new WritableProperty(iAttribute, string, attrWriteType, bl));
        } else {
            property.setValue(attrWriteType);
        }
    }

    public void setProperty(IAttribute iAttribute, String string, AttrDataFormat attrDataFormat, boolean bl) {
        AtkTimer.getInstance().startTimer(Thread.currentThread());
        Property property = this.propertyMap.get(string);
        if (property == null) {
            this.propertyMap.put(string, new FormatProperty(iAttribute, string, attrDataFormat, bl));
        } else {
            property.setValue(attrDataFormat);
        }
        AtkTimer.getInstance().endTimer(Thread.currentThread());
    }

    public void setProperty(IEntity iEntity, String string, DispLevel dispLevel, boolean bl) {
        Property property = this.propertyMap.get(string);
        if (property == null) {
            this.propertyMap.put(string, new DisplayLevelProperty(iEntity, string, dispLevel, bl));
        } else {
            property.setValue(dispLevel);
        }
    }

    public void setProperty(IEntity iEntity, String string, String string2, boolean bl) {
        Property property = this.propertyMap.get(string);
        if (property == null) {
            this.propertyMap.put(string, new StringProperty(iEntity, string, string2, bl));
        } else {
            property.setValue(string2);
        }
    }

    public void setProperty(IEntity iEntity, String string, Object object) {
        Property property = this.propertyMap.get(string);
        property.setValue(object);
    }

    public Map<String, Property> getPropertyMap() {
        return this.propertyMap;
    }

    public void refreshProperties() {
        for (Property property : this.getPropertyMap().values()) {
            property.refresh();
        }
    }

    public Property getProperty(String string) {
        AtkTimer.getInstance().startTimer(Thread.currentThread());
        Property property = null;
        if (this.propertyMap != null) {
            property = this.propertyMap.get(string);
        }
        AtkTimer.getInstance().endTimer(Thread.currentThread());
        return property;
    }

    public double getNumberProperty(String string) {
        NumberProperty numberProperty = (NumberProperty)this.getProperty(string);
        if (numberProperty != null && numberProperty.isSpecified()) {
            if (numberProperty.getValue() instanceof Number) {
                return ((Number)numberProperty.getValue()).doubleValue();
            }
            if (numberProperty.getValue() instanceof String) {
                try {
                    double d = Double.parseDouble((String)numberProperty.getValue());
                    return d;
                }
                catch (NumberFormatException numberFormatException) {
                    return Double.NaN;
                }
            }
        }
        return Double.NaN;
    }
}

