/*
 * Decompiled with CFR 0.152.
 */
package pogo.servers2www;

import java.io.File;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import pogo.gene.PogoClass;
import pogo.gene.PogoUtil;

public class CheckNews {
    private String old_list;
    private String new_list;
    private static final String title_news = "Tango Device Server Classes";
    private static final String title_list = "Tango Device Server Classes List";
    private static final String separator = "\n<Br /><Br /><HR WIDTH=\"100%\" />\n";
    private String mail_tmp_file;
    private boolean check_news = true;

    public CheckNews(String[] filenames) throws Exception {
        this.old_list = PogoUtil.readFile(filenames[0]);
        this.new_list = PogoUtil.readFile(filenames[1]);
        this.mail_tmp_file = filenames[2];
        this.check_news = true;
    }

    public CheckNews(String infile, String outfile) throws Exception {
        this.new_list = PogoUtil.readFile(infile);
        this.mail_tmp_file = outfile;
        this.check_news = false;
    }

    public void checkData() throws Exception {
        Vector<String> v = new Vector<String>();
        StringTokenizer new_stk = new StringTokenizer(this.new_list, "\n");
        while (new_stk.hasMoreTokens()) {
            String classname = new_stk.nextToken();
            boolean found = false;
            if (this.check_news) {
                StringTokenizer old_stk = new StringTokenizer(this.old_list, "\n");
                while (!found && old_stk.hasMoreTokens()) {
                    found = classname.equals(old_stk.nextToken());
                }
            }
            if (found) continue;
            int pos = classname.indexOf("/");
            if (pos > 0) {
                classname = classname.substring(0, pos);
            }
            v.add(classname);
        }
        System.out.println(v.size() + " new classes found !");
        if (v.size() == 0) {
            return;
        }
        Vector classes = this.getNewPogoClasses(v);
        if (classes.size() > 0) {
            this.buildMailFile(classes);
        }
    }

    private String alphabeticLink(Vector classes) {
        char c = '0';
        String str = "<Center>\n";
        str = str + "Class Index :<Br />\n";
        for (int i = 0; i < classes.size(); ++i) {
            PogoClass _class = (PogoClass)classes.elementAt(i);
            if (_class.class_name.indexOf(c) == 0) continue;
            c = _class.class_name.charAt(0);
            str = str + "<a href=\"#" + c + "\"> " + c + " </a>\n";
        }
        str = str + "</Center>\n";
        return str;
    }

    private void buildMailFile(Vector classes) throws Exception {
        String templ_dir = System.getProperty("TEMPL_HOME");
        String code = PogoUtil.readFile(templ_dir + "/html/header.html");
        int position = code.indexOf("</Body>");
        String new_code = code.substring(0, position);
        new_code = new_code + "<Center><h1><u>";
        new_code = this.check_news ? new_code + title_news : new_code + title_list;
        new_code = new_code + "</u></h1></Center><Br /><Br />";
        new_code = new_code + separator;
        if (this.check_news) {
            new_code = new_code + "<b>" + classes.size();
            new_code = classes.size() > 1 ? new_code + " new classes have " : new_code + " new class has ";
            new_code = new_code + "been found during tango-cs, tango-ds and ESRF CVS repositories scan.\n</b>";
        } else {
            new_code = new_code + this.alphabeticLink(classes);
        }
        char c = '0';
        for (int i = 0; i < classes.size(); ++i) {
            PogoClass _class = (PogoClass)classes.elementAt(i);
            if (!this.check_news && _class.class_name.indexOf(c) != 0) {
                c = _class.class_name.charAt(0);
                new_code = new_code + "<A Name=\"" + c + "\" />\n";
            }
            new_code = new_code + separator;
            String tmp_lnk = "http://www.esrf.fr/computing/cs/tango/tango_doc/ds_doc/" + _class.class_name + "/doc_html/";
            new_code = new_code + "<b>" + _class.class_name + " :</b> " + _class.title + "\n";
            new_code = new_code + "<ul>\n";
            new_code = new_code + "\t<a HREF=\"" + tmp_lnk + "\">" + tmp_lnk + " </a><Br />\n";
            new_code = new_code + "\t" + _class.class_desc + "\n";
            new_code = new_code + "</ul>\n";
        }
        new_code = new_code + separator;
        new_code = new_code + "\n<Br /><Br />";
        if (this.check_news) {
            new_code = new_code + "This is an automatic generated mail (" + new Date() + ").<Br />\n";
            new_code = new_code + "All device servers user's guide at <a HREF=\"http://www.esrf.fr/computing/cs/tango/tango_doc/ds_doc/\"> http://www.esrf.fr/computing/cs/tango/tango_doc/ds_doc/</a>\n<Br />\n";
        } else {
            new_code = new_code + "<Center>Last Update " + new Date() + ".</Center><Br />\n";
        }
        new_code = new_code + code.substring(position);
        PogoUtil.writeFile(this.mail_tmp_file, new_code);
    }

    private String getFileName(String classname) {
        String filename = classname + ".h";
        File file = new File(classname + "/" + classname + ".h");
        if (file.exists()) {
            return file.toString();
        }
        file = new File(classname + "/src/" + classname + ".h");
        if (file.exists()) {
            file.toString();
        } else {
            file = new File(classname + "/" + classname + ".java");
            if (file.exists()) {
                filename = file.toString();
            } else {
                file = new File(classname + "/" + classname + ".py");
                if (file.exists()) {
                    filename = file.toString();
                }
            }
        }
        return filename;
    }

    private Vector getNewPogoClasses(Vector classnames) throws Exception {
        Vector<PogoClass> classes = new Vector<PogoClass>();
        String warnings = "";
        for (int i = 0; i < classnames.size(); ++i) {
            String classname = (String)classnames.elementAt(i);
            String cmd = "tar -xzf " + classname + "/" + classname + ".tar.gz";
            System.out.println(cmd);
            PogoUtil.executeShellCmd(cmd);
            PogoUtil.executeShellCmd("ls -l");
            PogoClass _class = null;
            try {
                _class = new PogoClass(this.getFileName(classname));
                if (_class.except != null) {
                    warnings = warnings + _class.except.toString() + "\n";
                }
            }
            catch (Exception e) {
                System.out.println(e);
                warnings = warnings + "***************** " + classname + " ***************\n" + e.toString() + "\n*******************************************\n";
            }
            if (_class != null) {
                classes.add(_class);
            }
            File f = new File(classname);
            String[] files = f.list();
            for (int j = 0; j < files.length; ++j) {
                File f1 = new File(classname + "/" + files[j]);
                if (!f1.isFile() || files[j].indexOf("tar.gz") >= 0) continue;
                f1.delete();
            }
        }
        if (warnings.length() > 0) {
            try {
                PogoUtil.writeFile("/tmp/servers2www.warn", warnings);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return classes;
    }

    public static void main(String[] args) {
        CheckNews client = null;
        try {
            switch (args.length) {
                case 3: {
                    client = new CheckNews(args);
                    client.checkData();
                    break;
                }
                case 2: {
                    client = new CheckNews(args[0], args[1]);
                    client.checkData();
                    System.out.println("Creating Alphabetic list of device servers");
                    break;
                }
                default: {
                    System.out.println("Old_file_names  new_file_names  mail_file_name ?");
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

