/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.Vector;
import pogo.gene.Attrib;
import pogo.gene.Cmd;
import pogo.gene.CmdTable;
import pogo.gene.DevState;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;
import pogo.gene.Property;
import pogo.gene.ServerDefinitions;

public class PogoUtil
implements PogoDefs {
    private static PogoUtil instance = null;
    static final String[] cpp_target = new String[]{"Inherited from class ", ": public Tango::Device_3Impl", ": public Tango::Device_2Impl", ": public Tango::DeviceImpl"};
    private static final String[] java_target = new String[]{" extends DeviceImpl"};
    static final String[] py_target = new String[]{"(PyTango.Device_3Impl):"};
    private static String attrSoleil = null;
    private static boolean test_mode = false;
    private static boolean test_mode_read = false;
    private static final String logfile = "/tmp/pogo.log";
    private static final int DATE = 1;
    private static final int TIME = 2;
    private static final int USER = 4;
    private static final int MODULE = 5;
    private static final int TAGNAME = 6;
    private static final int NB_PARAM = 7;

    private PogoUtil() {
    }

    public static PogoUtil getInstance() {
        if (instance == null) {
            instance = new PogoUtil();
        }
        return instance;
    }

    public static boolean isDeviceImplClass(String filename) {
        try {
            int i;
            String readcode = PogoUtil.readFile(filename);
            for (i = 0; i < cpp_target.length; ++i) {
                if (readcode.indexOf(cpp_target[i]) <= 0) continue;
                return true;
            }
            for (i = 0; i < java_target.length; ++i) {
                if (readcode.indexOf(java_target[i]) <= 0) continue;
                return true;
            }
            for (i = 0; i < py_target.length; ++i) {
                if (readcode.indexOf(py_target[i]) <= 0) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean checkIfSuperclass(String filename, CmdTable commands) {
        try {
            String readcode = PogoUtil.readFile(filename);
            int start = readcode.indexOf("virtual void read_attr_hardware(vector<long> &attr_list)");
            if (start > 0) {
                int end = readcode.indexOf("\n", start);
                if (readcode.substring(start, end).indexOf("NULL") > 0) {
                    return true;
                }
                return readcode.substring(start, end).indexOf("0") > 0;
            }
            if (commands.size() > 2) {
                int end;
                Cmd cmd = commands.cmdAt(2);
                String proto = cmd.buildCppCmdProtypesLine();
                start = readcode.indexOf(proto = proto.substring(0, proto.length() - 2));
                if (readcode.substring(start, end = readcode.indexOf("\n", start)).indexOf("NULL") > 0) {
                    return true;
                }
                return readcode.substring(start, end).indexOf("0") > 0;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int deviceImplRevisionNumber(String filename) {
        try {
            String ext = filename.substring(filename.lastIndexOf("."));
            if (ext.equals(".c")) {
                return cpp_target.length;
            }
            if (ext.equals(".py")) {
                String readcode = PogoUtil.readFile(filename);
                String dev_impl = py_target[0];
                for (int i = 0; i < py_target.length; ++i) {
                    if (readcode.indexOf(cpp_target[i]) <= 0) continue;
                    dev_impl = py_target[i];
                }
                int end = dev_impl.indexOf("Impl");
                int start = dev_impl.lastIndexOf("_", end) + 1;
                try {
                    return Integer.parseInt(dev_impl.substring(start, end));
                }
                catch (NumberFormatException e) {
                    System.out.println(e);
                    return 1;
                }
            }
            if (ext.equals(".cpp")) {
                filename = filename.substring(0, filename.lastIndexOf(".")) + ".h";
            }
            String readcode = PogoUtil.readFile(filename);
            for (int i = 0; i < cpp_target.length; ++i) {
                if (readcode.indexOf(cpp_target[i]) <= 0) continue;
                if (i == 0) {
                    return cpp_target.length - 1;
                }
                return cpp_target.length - i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return -1;
    }

    public String getInheritance(String classname, String filename) throws PogoException, FileNotFoundException, SecurityException, IOException {
        String path;
        String readcode = PogoUtil.readFile(filename);
        if (readcode.indexOf(cpp_target[1]) > 0) {
            return "Device_3Impl";
        }
        String target = "class " + classname + ": public ";
        int start = readcode.indexOf(target);
        int end = readcode.indexOf("//", start += target.length());
        if (end < 0) {
            throw new PogoException("Inheritance syntax error");
        }
        String abstractclass = readcode.substring(start, end).trim();
        if ((start = abstractclass.indexOf("::")) < 0) {
            throw new PogoException("Inheritance syntax error");
        }
        abstractclass = abstractclass.substring(start + 2);
        String[] cl_list = this.abstractClassList();
        boolean found = false;
        System.out.println(cl_list.length + " Super Classes available:");
        for (int i = 0; !found && i < cl_list.length; ++i) {
            String _class;
            System.out.println(cl_list[i]);
            start = cl_list[i].lastIndexOf("/");
            if (start <= 0 || !(found = (_class = cl_list[i].substring(start + 1, cl_list[i].lastIndexOf("."))).equals(abstractclass))) continue;
            abstractclass = cl_list[i].substring(0, cl_list[i].lastIndexOf("."));
        }
        if (!found && (path = System.getProperty("SUPER_HOME")) != null) {
            abstractclass = path + "/" + abstractclass;
        }
        return abstractclass;
    }

    public static String[] getTangoFilesList(String dirname) {
        int i;
        String[] ext = new String[]{".java", ".h", ".py"};
        String[] list = PogoUtil.getFilesList(dirname, ext);
        Vector<String> v = new Vector<String>();
        for (i = 0; i < list.length; ++i) {
            if (!PogoUtil.isDeviceImplClass(list[i])) continue;
            v.add(list[i]);
        }
        list = new String[v.size()];
        for (i = 0; i < v.size(); ++i) {
            list[i] = (String)v.elementAt(i);
        }
        return list;
    }

    public static String[] getCvsTangoFilesList(String dirname) {
        int i;
        String[] ext = new String[]{".java,v", ".h,v", ".py,v"};
        String[] list = PogoUtil.getFilesList(dirname, ext);
        Vector<String> v = new Vector<String>();
        for (i = 0; i < list.length; ++i) {
            if (!PogoUtil.isDeviceImplClass(list[i])) continue;
            v.add(list[i]);
        }
        list = new String[v.size()];
        for (i = 0; i < v.size(); ++i) {
            list[i] = (String)v.elementAt(i);
        }
        return list;
    }

    public static String[] getFilesList(String dirname, String[] ext) {
        File d = new File(dirname);
        String[] filenames = d.list();
        Vector<String> v = new Vector<String>();
        if (filenames == null) {
            return new String[0];
        }
        for (int i = 0; i < filenames.length; ++i) {
            String filename = dirname + "/" + filenames[i];
            File f = new File(filename);
            if (!f.isFile()) continue;
            for (int n = 0; n < ext.length; ++n) {
                int start_ext = filename.length() - ext[n].length();
                if (start_ext <= 0 || !filename.substring(start_ext).equals(ext[n])) continue;
                v.add(filename);
            }
        }
        String[] list = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            list[i] = (String)v.elementAt(i);
        }
        return list;
    }

    public static String readFile(String filename) throws FileNotFoundException, SecurityException, IOException {
        FileInputStream fid = new FileInputStream(filename);
        int nb = fid.available();
        byte[] inStr = new byte[nb];
        PogoString pgs = (nb = fid.read(inStr)) > 0 ? new PogoString(inStr) : new PogoString("");
        fid.close();
        return pgs.str;
    }

    public static String readFile(String filename, String src, String target) throws FileNotFoundException, SecurityException, IOException {
        PogoString pgs = new PogoString(PogoUtil.readFile(filename));
        while (pgs.indexOf(src) >= 0) {
            pgs.replace(src, target);
        }
        return pgs.str;
    }

    private static String checkOsFormat(String code) {
        if (!PogoUtil.osIsUnix()) {
            return PogoUtil.setWindowsFileFormat(code);
        }
        return code;
    }

    public static String setWindowsFileFormat(String code) {
        byte[] b = new byte[]{13, 10};
        String lsp = new String(b);
        code = code.replaceAll("\n", lsp);
        return code;
    }

    public static void writeFile(String filename, String str) throws FileNotFoundException, SecurityException, IOException {
        str = PogoUtil.checkOsFormat(str);
        FileOutputStream fidout = new FileOutputStream(filename);
        fidout.write(str.getBytes());
        fidout.close();
    }

    public static String replaceAll(String str, String src, String target) {
        PogoString pgs = new PogoString(str);
        while (pgs.str.indexOf(src) >= 0) {
            pgs.replace(src, target);
        }
        return pgs.str;
    }

    public static String enteringTrace(String methodname) {
        int i = methodname.indexOf("::");
        if (i > 0) {
            while (i > 0 && methodname.charAt(i) != ' ') {
                --i;
            }
            if (methodname.charAt(i) == ' ') {
                ++i;
            }
            methodname = methodname.substring(i);
        }
        return "\tDEBUG_STREAM << \"" + methodname + " entering... \"<< endl;\n";
    }

    public static String checkCmdAttrName(String name, Vector existingCmd, Vector existingAttr, int editingIdx, int family) throws PogoException {
        int i;
        if (name.length() <= 0) {
            throw new PogoException("Name field must be filled in !");
        }
        if (attrSoleil == null) {
            attrSoleil = System.getProperty("ATTR_SOLEIL");
            attrSoleil = attrSoleil == null ? "false" : attrSoleil.toLowerCase();
        }
        StringTokenizer stk = new StringTokenizer(name);
        StringBuffer sb = new StringBuffer();
        while (stk.hasMoreTokens()) {
            String word = stk.nextToken();
            word = family == 3 && attrSoleil.equals("true") ? word.substring(0, 1) + word.substring(1) : word.substring(0, 1).toUpperCase() + word.substring(1);
            sb.append(word);
        }
        name = sb.toString();
        for (i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (!(c < '0' || c > '9' && c < 'A' || c > 'Z' && c < 'a') && c <= 'z' || c == '_') continue;
            throw new PogoException("Syntax error in name !\nDo not use '" + c + "' char.");
        }
        for (i = 0; i < existingCmd.size(); ++i) {
            if (i == editingIdx) continue;
            Cmd cmd = (Cmd)existingCmd.elementAt(i);
            if (!name.toLowerCase().equals(cmd.name.toLowerCase())) continue;
            throw new PogoException(name + " already exists as command !");
        }
        for (i = 0; i < existingAttr.size(); ++i) {
            if (i == editingIdx) continue;
            Attrib attr = (Attrib)existingAttr.elementAt(i);
            if (!name.toLowerCase().equals(attr.name.toLowerCase())) continue;
            throw new PogoException(name + " already exists as attribute !");
        }
        return name;
    }

    public static String getHelpMessage(String itemStr) {
        String templates_dir = System.getProperty("TEMPL_HOME");
        if (templates_dir == null) {
            return "No Template Property (TEMPL_HOME) Fixed !";
        }
        try {
            String filename = templates_dir + "/txt/";
            filename = itemStr.startsWith("What's New") ? filename + "WhatIsNew" : filename + itemStr;
            filename = filename + ".txt";
            return PogoUtil.readFile(filename);
        }
        catch (FileNotFoundException e) {
            return e.toString();
        }
        catch (IOException e) {
            return e.toString();
        }
    }

    public static String executeShellCmd(String cmd) throws Exception {
        String str;
        Process proc = Runtime.getRuntime().exec(cmd);
        InputStream istr = proc.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(istr));
        String sb = "";
        while ((str = br.readLine()) != null) {
            sb = sb + str + "\n";
        }
        proc.waitFor();
        int retVal = proc.exitValue();
        if (retVal != 0) {
            InputStream errstr = proc.getErrorStream();
            br = new BufferedReader(new InputStreamReader(errstr));
            while ((str = br.readLine()) != null) {
                System.out.println(str);
                sb = sb + str + "\n";
            }
            throw new PogoException("the shell command\n" + cmd + "\nreturns : " + retVal + " !\n\n" + sb);
        }
        return sb;
    }

    public static String osName() {
        return System.getProperty("os.name");
    }

    public static boolean osIsUnix() {
        String os = PogoUtil.osName();
        return os.equals("Linux") || os.equals("SunOS") || os.equals("HP-UX");
    }

    static PogoString removeLogMessages(String code) {
        return PogoUtil.removeLogMessages(new PogoString(code));
    }

    private static void removeLogInfo(PogoString pgs) {
        int start = 0;
        Vector<String> v = new Vector<String>();
        while ((start = pgs.str.indexOf("$", start)) > 0) {
            int endline = pgs.nextCr(start);
            String line = pgs.substring(start, endline);
            start = line.indexOf(":");
            int end = line.indexOf("$", ++start);
            String info = line.substring(start, end).trim();
            start = endline + 1;
            v.add(info);
        }
        for (int i = 0; i < v.size(); ++i) {
            pgs.remove((String)v.elementAt(i));
        }
    }

    static PogoString removeLogMessages(PogoString code) {
        String line;
        int start = 0;
        int end = -1;
        while ((start = code.str.indexOf("namespace ", start + 1)) > 0 && ((line = code.substring(start = code.previousCr(start), end = code.nextCr(start + 1))).indexOf("//") >= 0 || line.indexOf("using ") >= 0)) {
            start = end;
        }
        if (start < 0) {
            end = -1;
        }
        if (end < 0 && (end = code.str.indexOf("public class")) < 0 && (end = code.str.indexOf("This file is generated by POGO")) < 0) {
            return code;
        }
        String header = code.substring(0, end);
        PogoString new_header = new PogoString(header);
        end = code.str.indexOf("copyleft");
        end = code.previousCr(end);
        end -= 2;
        end = code.previousCr(end);
        start = code.str.indexOf("// $Log: ");
        if (start < 0 && (start = code.str.indexOf("# $Log: ")) < 0) {
            return code;
        }
        start = code.nextCr(start + 1);
        String log_part = new_header.substring(++start, end);
        new_header.remove(log_part);
        PogoUtil.removeLogInfo(new_header);
        code.replace(header, new_header.str);
        return code;
    }

    public static boolean is_test_mode() {
        if (!test_mode_read) {
            String test = System.getProperty("POGO_TEST");
            if (test != null && test.toLowerCase().equals("true")) {
                test_mode = true;
            }
            test_mode_read = true;
        }
        return test_mode;
    }

    private Vector searchAbstractClassList(String dirname) {
        String[] ext = new String[]{".java", ".h"};
        Vector v = new Vector();
        if (dirname == null) {
            return v;
        }
        File d = new File(dirname);
        String[] filenames = d.list();
        if (filenames == null) {
            return v;
        }
        for (int i = 0; i < filenames.length; ++i) {
            String filename = dirname + "/" + filenames[i];
            File f = new File(filename);
            if (f.isDirectory()) {
                Vector vd = this.searchAbstractClassList(f.toString());
                for (int n = 0; n < vd.size(); ++n) {
                    v.add(vd.elementAt(n));
                }
                continue;
            }
            for (int n = 0; n < ext.length; ++n) {
                int start_ext = filename.length() - ext[n].length();
                if (start_ext <= 0 || !filename.substring(start_ext).equals(ext[n]) || !PogoUtil.isDeviceImplClass(filename)) continue;
                v.add(filename);
            }
        }
        MyCompare compare = new MyCompare();
        Collections.sort(v, compare);
        return v;
    }

    public String[] abstractClassList() {
        String super_home = System.getProperty("SUPER_HOME");
        System.out.println("Searching in " + super_home);
        Vector v = this.searchAbstractClassList(super_home);
        String[] cl_list = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            cl_list[i] = (String)v.elementAt(i);
        }
        return cl_list;
    }

    public static String getCvsRepository(String path) {
        try {
            String filename = path + "/CVS/Root";
            String code = PogoUtil.readFile(filename).trim();
            String repository = "ESRF";
            if (code.lastIndexOf("tango-cs") > 0) {
                repository = "tango-cs";
            } else if (code.lastIndexOf("tango-ds") > 0) {
                repository = "tango-ds";
            }
            if (code.indexOf("sourceforge") > 0) {
                repository = "sourceforge(" + repository + ")";
            }
            return repository;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getTagRevision(String filename, String class_name) {
        try {
            int end;
            String line;
            String code = PogoUtil.readFile(filename);
            int start = code.indexOf("$Name:");
            if (start < 0) {
                return null;
            }
            if ((line = code.substring(start += "$Name:".length(), end = code.indexOf("$", start)).trim()).startsWith(class_name = class_name + "-")) {
                line = line.substring(class_name.length());
            }
            return line;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String checkFileName(String filename) {
        System.out.println(filename);
        byte[] chars = new byte[filename.length()];
        for (int i = 0; i < filename.length(); ++i) {
            int c = filename.charAt(i);
            chars[i] = c >= 65 && c <= 90 || c >= 97 && c <= 122 || c >= 48 && c <= 57 || c == 46 ? c : 95;
        }
        return new String(chars);
    }

    public static void logString(String str) {
        String log = System.getProperty("LOG");
        if (log == null) {
            return;
        }
        if (!log.equals("true")) {
            return;
        }
        try {
            String logstr = "";
            try {
                logstr = PogoUtil.readFile(logfile);
            }
            catch (Exception exception) {
                // empty catch block
            }
            logstr = logstr + str + "\n";
            PogoUtil.writeFile(logfile, logstr);
        }
        catch (Exception e) {
            System.out.println(e + " in writing " + str);
        }
    }

    public static String pythonUserPart(String method) {
        int start = method.indexOf("End of Generated Code");
        int end = method.indexOf("Start of Generated Code");
        if (end < 0 || start < 0) {
            return "";
        }
        start = method.indexOf("\n", start) + 1;
        end = method.lastIndexOf("\n", end) + 1;
        return method.substring(start, end);
    }

    public static String pythonMethod(String str, String signature) {
        return PogoUtil.pythonMethod(str, signature, 0);
    }

    public static String pythonMethod(String str, String signature, int idx) {
        int start = str.indexOf(signature, idx);
        if (start < 0) {
            return null;
        }
        int end = PogoUtil.endOfPythonMethod(str, start);
        start = str.lastIndexOf("\n", start);
        boolean found = false;
        while (!found && (start = str.lastIndexOf("\n", start - 1)) > 0) {
            found = str.charAt(start + 1) != '#' || str.substring(start + 1).startsWith("#==============");
        }
        if (str.substring(start + 1).startsWith("#==============")) {
            start = str.indexOf("\n", start + 1) + 1;
        }
        return str.substring(start, end).trim();
    }

    public static int endOfPythonMethod(String str, int idx) {
        String def = "def ";
        int end = str.indexOf("\n", idx);
        int start = str.indexOf(def, idx);
        if (start < 0 || start > end) {
            start = str.lastIndexOf(def, idx);
        }
        String indentation = str.substring(str.lastIndexOf("\n", start) + 1, start);
        def = indentation + def;
        idx = str.indexOf("\n", idx);
        int next_class = str.indexOf("\nclass ", idx);
        int next_main = str.indexOf("\nif __name__ == '__main__':", idx);
        int next_method = str.indexOf(def, idx);
        if (next_class < 0) {
            next_class = str.length() - 1;
        }
        if (next_main < 0) {
            next_main = str.length() - 1;
        }
        if (next_method < 0) {
            next_method = str.length() - 1;
        }
        if (next_class < (end = next_method)) {
            end = next_class;
        }
        if (next_main < end) {
            end = next_main;
        }
        end = str.lastIndexOf("\n", end);
        boolean found = false;
        while (!found && (end = str.lastIndexOf("\n", end - 1)) > 0) {
            found = str.charAt(end + 1) != '\n' && str.charAt(end + 1) != '#';
        }
        end = str.indexOf("\n", end + 1) + 1;
        return end;
    }

    static String[] getPyMethodList(String code) {
        Vector<String> v = new Vector<String>();
        int start = 0;
        while ((start = code.indexOf("def ", start)) > 0) {
            int line_start;
            int end = start + 4;
            if ((code.charAt(start - 1) == '\t' || code.charAt(start - 1) == ' ') && code.charAt(line_start = code.lastIndexOf("\n", start) + 1) != '#') {
                end = code.indexOf("\n", start);
                if (end < 0) {
                    end = code.length() - 1;
                }
                v.add(code.substring(start, end));
            }
            start = end;
        }
        String[] list = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            list[i] = (String)v.get(i);
        }
        return list;
    }

    public static Vector getCvsTags(String cvsroot) throws Exception {
        String cmd_tags = "cvs  -d " + cvsroot + " history -T -a";
        System.out.println(cmd_tags);
        String result = PogoUtil.executeShellCmd(cmd_tags);
        Vector<String[]> retVect = new Vector<String[]>();
        StringTokenizer stk = new StringTokenizer(result, "\n");
        while (stk.hasMoreTokens()) {
            String line = stk.nextToken();
            StringTokenizer stk2 = new StringTokenizer(line);
            Vector<String> v = new Vector<String>();
            while (stk2.hasMoreTokens()) {
                v.add(stk2.nextToken());
            }
            if (v.size() <= 6) continue;
            String[] param = new String[7];
            for (int i = 0; i < v.size() && i < 7; ++i) {
                param[i] = (String)v.get(i);
            }
            param[6] = PogoUtil.getTagName(param[6]);
            if (param[6] == null) continue;
            retVect.add(param);
        }
        return retVect;
    }

    public static Vector getLastCvsTags(String cvsroot) throws Exception {
        int j;
        int i;
        Vector<String> names = new Vector<String>();
        Vector<String[]> retVect = new Vector<String[]>();
        Vector tags = PogoUtil.getCvsTags(cvsroot);
        for (i = 0; i < tags.size(); ++i) {
            String[] tag = (String[])tags.get(i);
            boolean exists = false;
            for (j = 0; !exists && j < names.size(); ++j) {
                String modname = (String)names.get(j);
                exists = modname.equals(tag[5]);
            }
            if (exists) continue;
            names.add(tag[5]);
        }
        for (i = 0; i < names.size(); ++i) {
            String modname = (String)names.get(i);
            boolean found = false;
            for (j = tags.size() - 1; !found && j >= 0; --j) {
                String[] tag = (String[])tags.get(j);
                if (!modname.equals(tag[5])) continue;
                found = true;
                retVect.add(tag);
            }
        }
        return retVect;
    }

    public static String getLastCvsTag(Vector tags, String module_name) {
        try {
            for (int i = 0; i < tags.size(); ++i) {
                String[] tag = (String[])tags.get(i);
                if (!tag[5].equals(module_name)) continue;
                return tag[6];
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return null;
    }

    private static String getTagName(String str) {
        int idx = str.indexOf(58);
        if (idx < 0) {
            return null;
        }
        if (str.substring(idx).equals(":D]")) {
            return null;
        }
        return str.substring(1, idx);
    }

    public static void main(String[] args) {
        try {
            Vector v = PogoUtil.getLastCvsTags("/segfs/tango/cvsroot");
            System.out.println(PogoUtil.getLastCvsTag(v, "hdbaccess"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int instanceOf(Object obj) {
        if (obj instanceof ServerDefinitions) {
            return -1;
        }
        if (obj instanceof Property) {
            return 0;
        }
        if (obj instanceof Cmd) {
            return 2;
        }
        if (obj instanceof Attrib) {
            return 3;
        }
        if (obj instanceof DevState) {
            return 4;
        }
        if (obj instanceof String) {
            return 5;
        }
        return -1;
    }

    class MyCompare
    implements Comparator {
        MyCompare() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = o1.toString().toLowerCase();
            String s2 = o2.toString().toLowerCase();
            if (s1 == null) {
                return 1;
            }
            if (s2 == null) {
                return -1;
            }
            return s1.compareTo(s2);
        }
    }
}

