/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import fr.esrf.TangoDs.TangoConst;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import pogo.gene.Attrib;
import pogo.gene.Cmd;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;
import pogo.gene.PogoUtil;

public class PogoGene
implements PogoDefs,
TangoConst {
    PogoClass pogo;
    protected String strTrace;

    public PogoGene(PogoClass pogo) {
        this.pogo = pogo;
    }

    public String getTrace() {
        return this.strTrace;
    }

    protected static boolean mustGenerate(String filename) {
        return !PogoGene.already_exists(filename);
    }

    protected static boolean already_exists(String filename) {
        return new File(filename).exists();
    }

    protected String setMethodInComments(PogoString pgs, int startline) {
        int end_bl = pgs.inMethod(startline);
        end_bl = pgs.outMethod(end_bl);
        PogoString pgs1 = new PogoString(pgs.str.substring(startline, end_bl));
        StringBuffer sb = new StringBuffer("//");
        for (int i = 0; i < pgs1.str.length(); ++i) {
            sb.append(pgs1.str.charAt(i));
            if (pgs1.str.charAt(i) != '\n') continue;
            sb.append("//");
        }
        return sb.toString();
    }

    public static void copyFile(String f_in, String f_out) throws FileNotFoundException, IOException {
        PogoGene.copyFile(f_in, f_out, true);
    }

    public static void copyFile(String f_in, String f_out, boolean remove) throws FileNotFoundException, IOException {
        if (remove) {
            PogoString readcode = new PogoString(PogoUtil.readFile(f_in));
            readcode = PogoUtil.removeLogMessages(readcode);
            PogoUtil.writeFile(f_out, readcode.str);
        } else {
            FileInputStream fid = new FileInputStream(f_in);
            FileOutputStream fidout = new FileOutputStream(f_out);
            int nb = fid.available();
            byte[] inStr = new byte[nb];
            if (fid.read(inStr) > 0) {
                fidout.write(inStr);
            }
            fid.close();
            fidout.close();
        }
    }

    public static void copyDirectory(String src, String target) throws FileNotFoundException, IOException {
        File src_dir = new File(src);
        File target_dir = new File(target);
        if (!target_dir.exists()) {
            target_dir.mkdir();
        }
        System.out.println("Copiing " + src + " to " + target);
        String[] src_files = src_dir.list();
        if (src_files == null) {
            System.out.println("\tERROR");
            return;
        }
        for (int i = 0; i < src_files.length; ++i) {
            String src_file = src + "/" + src_files[i];
            if (new File(src_file).isDirectory()) continue;
            String target_file = target_dir + "/" + src_files[i];
            PogoGene.copyFile(src_file, target_file, false);
        }
    }

    protected void replacePatternFile(String f_in, String f_out, String to_find, String target) throws FileNotFoundException, SecurityException, IOException {
        PogoString pgs = new PogoString(PogoUtil.readFile(f_in));
        pgs = PogoUtil.removeLogMessages(pgs);
        int start = 0;
        while ((start = pgs.str.indexOf(to_find, start)) >= 0) {
            pgs.replace(start, to_find, target);
            start += target.length();
        }
        PogoUtil.writeFile(f_out, pgs.str);
    }

    protected String changeExeMethodArgs(Cmd cmd, String str, int idx, int lang) {
        StringBuffer sb = new StringBuffer(str);
        boolean in_method = false;
        int cnt = 0;
        sb.insert(idx, "//");
        while (!in_method || cnt > 0) {
            char c;
            if ((c = sb.charAt(idx++)) == '\n') {
                sb.insert(idx, "//");
            }
            if (c == '{') {
                ++cnt;
                in_method = true;
                continue;
            }
            if (c != '}') continue;
            --cnt;
        }
        switch (lang) {
            case 0: {
                String description = cmd.buildJavaExecCmdMethodComments();
                sb.insert(idx, description);
                sb.insert(idx += description.length(), cmd.buildJavaExecCmdMethod());
                break;
            }
        }
        return sb.toString();
    }

    protected String checkForExecMethodModif(PogoString readcode, int lang) throws PogoException {
        Cmd cmd;
        int i;
        if (lang == 1) {
            for (i = 0; i < this.pogo.commands.size(); ++i) {
                cmd = this.pogo.commands.cmdAt(i);
                if (cmd.virtual_method) continue;
                cmd.updateCppExecCmdMethodComments(readcode, this.pogo.class_name);
            }
        }
        for (i = 0; i < this.pogo.commands.size(); ++i) {
            int startmethod;
            cmd = this.pogo.commands.cmdAt(i);
            if (cmd.virtual_method) continue;
            String pattern = lang == 1 ? this.pogo.class_name + "::" + cmd.exec_method + "(" : cmd.exec_method + "(";
            int endline = 0;
            boolean done = false;
            while (!done && (startmethod = readcode.str.indexOf(pattern, endline)) >= 0) {
                int sl;
                int startline = readcode.previousCr(startmethod);
                String line = readcode.str.substring(startline, endline = readcode.nextCr(startline));
                int el = line.indexOf(")", sl = line.indexOf("("));
                if (el < 0) {
                    el = sl + 1;
                }
                line = line.substring(0, el);
                if (!cmd.isExecMethod(readcode.str.substring(startmethod, endline)) || line.indexOf("//") >= 0 || line.indexOf("\"") >= 0 || line.indexOf("<<") >= 0 || line.indexOf("println") >= 0) continue;
                if (cmd.execMethodArgsChanged(line, lang)) {
                    String s = this.changeExeMethodArgs(cmd, readcode.str, startline, lang);
                    readcode = new PogoString(s);
                }
                done = true;
            }
        }
        return readcode.str;
    }

    protected String setProjectTitle(String header) {
        int start = header.indexOf("project :");
        if (start < 0) {
            return header;
        }
        int end = header.indexOf("\n", start += "project :".length());
        return header.substring(0, start) + "\t" + this.pogo.title + header.substring(end);
    }

    protected String readAttributeTemplate(String f_in, int part) throws FileNotFoundException, SecurityException, IOException, PogoException {
        PogoString rw = new PogoString(PogoUtil.readFile(f_in));
        rw = PogoUtil.removeLogMessages(rw);
        while (rw.str.indexOf("TemplateDevServ") >= 0) {
            rw.replace("TemplateDevServ", this.pogo.class_name);
        }
        int end = rw.str.indexOf("WRITE ATTRIBUTE");
        if (end < 0) {
            throw new PogoException("'WRITE ATTRIBUTE' method not found");
        }
        end = rw.previousCr(end);
        String str = null;
        switch (part) {
            case 0: {
                str = rw.str.substring(0, end);
                break;
            }
            case 1: {
                int start = rw.nextCr(end) + 1;
                str = rw.str.substring(start);
            }
        }
        return str;
    }

    protected String buildAttributesMethods(PogoString pgs, int lang) throws PogoException, IOException, FileNotFoundException {
        int i;
        int ptr;
        int end;
        int start;
        String tab;
        String string = tab = lang == 0 ? "\t\t" : "\t";
        if (lang == 0) {
            start = pgs.str.indexOf("//--------- Start of attributes data members ----------");
            if (start < 0) {
                throw new PogoException("Input File Syntax error !\n//--------- Start of attributes data members ----------\nNot Found !");
            }
            end = pgs.str.indexOf("//--------- End of attributes data members ----------");
            if (end < 0) {
                throw new PogoException("Input File Syntax error !\n//--------- End of attributes data members ----------\n Not found !");
            }
            String prev_declar = pgs.str.substring(start, end);
            StringBuffer sb = new StringBuffer("//--------- Start of attributes data members ----------");
            sb.append("\n\n");
            for (int i2 = 0; i2 < this.pogo.attributes.size(); ++i2) {
                Attrib attr = this.pogo.attributes.attributeAt(i2);
                sb.append(attr.javaMemberData());
            }
            sb.append("\n");
            pgs.replace(prev_declar, sb.toString());
        }
        String rwAttr = lang == 0 ? this.pogo.templates_dir + "/java/ReadWriteAttr.java" : this.pogo.templates_dir + "/cpp/ReadHardwareAttr.cpp";
        String read = this.readAttributeTemplate(rwAttr, 0);
        String write = this.readAttributeTemplate(rwAttr, 1);
        String pattern = lang == 0 ? "public void read_attr_hardware" : "::read_attr_hardware";
        if (pgs.str.indexOf(pattern) < 0) {
            pattern = lang == 0 ? "always_executed_hook()" : "::always_executed_hook";
            ptr = pgs.str.indexOf(pattern);
            if (ptr < 0) {
                throw new PogoException("'" + pattern + "()' method not found");
            }
            ptr = pgs.inMethod(ptr) + 1;
            ptr = pgs.outMethod(ptr) + 1;
            pgs.insert(ptr, read);
        }
        boolean writable = false;
        for (int i3 = 0; i3 < this.pogo.attributes.size(); ++i3) {
            Attrib attr = this.pogo.attributes.attributeAt(i3);
            if (!attr.getWritable()) continue;
            writable = true;
        }
        pattern = lang == 0 ? "public void write_attr_hardware" : "::write_attr_hardware";
        if (writable && pgs.str.indexOf(pattern) < 0) {
            pattern = lang == 0 ? "public void always_executed_hook()" : "::always_executed_hook()";
            ptr = pgs.str.indexOf(pattern);
            ptr = pgs.inMethod(ptr) + 1;
            ptr = pgs.outMethod(ptr) + 1;
            pgs.insert(ptr, write);
        }
        if ((start = pgs.str.indexOf(pattern = lang == 0 ? "public void read_attr(" : "::read_attr(")) < 0) {
            throw new PogoException("'" + pattern + ")' method not found");
        }
        start = pgs.inMethod(start) + 1;
        end = pgs.outMethod(start);
        end = pgs.str.lastIndexOf(125, end);
        PogoString method = new PogoString(pgs.str.substring(start, end));
        String oldmethod = method.str;
        ptr = method.str.indexOf("Switch on attribute name");
        if (ptr < 0) {
            System.out.println(method);
            throw new PogoException("'Switch on attribute name' not found");
        }
        ptr = method.nextCr(ptr) + 1;
        ptr = method.nextCr(ptr) + 1;
        for (i = 0; i < this.pogo.attributes.size(); ++i) {
            String target;
            Attrib attr = this.pogo.attributes.attributeAt(i);
            if (attr.rwType == 1 || method.str.indexOf(target = "\"" + attr.name + "\"", ptr) >= 0) continue;
            String str = "";
            if (i != 0) {
                str = str + tab + "else\n";
            }
            str = str + tab + "if (attr_name == " + target + ")\n" + tab + "{\n" + tab + "\t//\tAdd your own code here\n" + tab + "}\n";
            int here = i != 0 ? method.str.lastIndexOf("}", method.str.length()) + "}\n".length() : ptr;
            method.insert(here, str);
        }
        pgs.replace(oldmethod, method.str);
        if (writable) {
            pattern = lang == 0 ? "public void write_attr_hardware(" : "::write_attr_hardware";
            start = pgs.str.indexOf(pattern);
            if (start < 0) {
                throw new PogoException("'" + pattern + "' method not found");
            }
            start = pgs.inMethod(start) + 1;
            end = pgs.outMethod(start) - 2;
            method = new PogoString(pgs.str.substring(start, end));
            oldmethod = method.str;
            ptr = method.str.indexOf("Switch on attribute name");
            if (ptr < 0) {
                throw new PogoException("'Switch on attribute name' not found");
            }
            ptr = method.nextCr(ptr) + 1;
            ptr = method.nextCr(ptr) + 1;
            int n = 0;
            for (i = 0; i < this.pogo.attributes.size(); ++i) {
                Attrib attr = this.pogo.attributes.attributeAt(i);
                String string2 = tab = lang == 0 ? "\t\t\t" : "\t\t";
                if (!attr.getWritable()) continue;
                String target = "\"" + attr.name + "\"";
                if (method.str.indexOf(target, ptr) < 0) {
                    int here;
                    String str = "";
                    if (n != 0) {
                        str = str + tab + "else\n";
                    }
                    str = str + tab + "if (attr_name == " + target + ")\n" + tab + "{\n" + tab + "\t//\tAdd your own code here\n" + tab + "}\n";
                    if (n != 0) {
                        here = method.str.lastIndexOf("}", method.str.length());
                        here = method.str.lastIndexOf("}", here - 1) + "}\n".length();
                    } else {
                        here = ptr;
                    }
                    method.insert(here, str);
                }
                ++n;
            }
            pgs.replace(oldmethod, method.str);
        }
        return pgs.toString();
    }

    protected void buildReadMeFile(String f_in, String f_out) {
        try {
            PogoString pgs = new PogoString(PogoUtil.readFile(f_in));
            pgs = PogoUtil.removeLogMessages(pgs);
            while (pgs.str.indexOf("TemplateDevServ") > 0) {
                pgs.replace("TemplateDevServ", this.pogo.class_name);
            }
            FileOutputStream fidout = new FileOutputStream(f_out);
            fidout.write(pgs.str.getBytes());
            if (this.pogo.language == 0) {
                for (int i = 0; i < this.pogo.commands.size(); ++i) {
                    Cmd cmd = this.pogo.commands.cmdAt(i);
                    if (cmd.virtual_method) continue;
                    String str = cmd.name + "Cmd" + ".java" + ":\n\t" + "Java source code for the command " + cmd.name + "\n\t" + cmd.description + "\n\n";
                    fidout.write(str.getBytes());
                }
            }
            fidout.close();
        }
        catch (Exception ex) {
            System.out.println("README Cannot be generated\n" + ex.toString());
        }
    }

    private String buildProxyMethods() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.pogo.commands.size(); ++i) {
            Cmd cmd = this.pogo.commands.cmdAt(i);
            sb.append(cmd.buildJavaExecCmdMethodComments());
            sb.append(cmd.buildJavaExecCmdMethodSignature(1));
        }
        sb.append("\n\n");
        return sb.toString();
    }

    protected void buildClientProxyFile(String template, String proxyfile, String proxyclass) throws PogoException, IOException, FileNotFoundException {
        PogoString pgs;
        if (PogoGene.mustGenerate(proxyfile)) {
            System.out.println("Generating " + proxyfile);
            pgs = new PogoString(PogoUtil.readFile(template));
            pgs = PogoUtil.removeLogMessages(pgs);
            while (pgs.str.indexOf("TangoclassProxy") >= 0) {
                pgs.replace("TangoclassProxy", proxyclass);
            }
            PogoUtil.writeFile(proxyfile, pgs.str);
        }
        pgs = new PogoString(PogoUtil.readFile(proxyfile));
        String constructor = "public " + proxyclass + "(String devname) throws DevFailed";
        int end = pgs.str.indexOf(constructor);
        end = pgs.inMethod(end);
        end = pgs.outMethod(end) + 1;
        constructor = pgs.str.substring(0, end);
        int start = pgs.str.indexOf("public static void main(String[] argv)");
        start = pgs.str.lastIndexOf("/**", start);
        start = pgs.str.lastIndexOf("//==========", start);
        String main = pgs.str.substring(start);
        PogoUtil.writeFile(proxyfile, constructor + this.buildProxyMethods() + main);
    }
}

