/*
 * Decompiled with CFR 0.152.
 */
package tool_panels.atktable;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.tree.TreePath;
import tool_panels.atktable.DevBrowser;
import tool_panels.atktable.DevBrowserTree;
import tool_panels.atktable.TableScalarViewer;

public class TablePopupMenu
extends JPopupMenu {
    private TableScalarViewer panel;
    private JTable table = null;
    private DevBrowserTree tree = null;
    private JLabel titleLbl;
    private static String[] pMenuLabels;
    private static String[] tableLabels;
    private static String[] treeLabels;
    private static final int OFFSET = 2;
    static final int TABLE_CHANGE_NAME = 0;
    static final int TABLE_ADD_COLUMN = 1;
    static final int TABLE_ADD_ROW = 2;
    static final int TABLE_REMOVE = 3;
    static final int TREE_ADD_ATTRIBUTE = 0;
    int selected_row;
    int selected_col;

    public TablePopupMenu(TableScalarViewer panel, JTable table) {
        this.panel = panel;
        this.table = table;
        pMenuLabels = tableLabels;
        this.buildBtnPopupMenu();
    }

    public TablePopupMenu(DevBrowserTree tree) {
        this.tree = tree;
        pMenuLabels = treeLabels;
        this.buildBtnPopupMenu();
    }

    private void buildBtnPopupMenu() {
        this.titleLbl = new JLabel("Viewer Edition");
        this.titleLbl.setFont(new Font("Dialog", 1, 16));
        this.add(this.titleLbl);
        this.add(new JPopupMenu.Separator());
        for (int i = 0; i < pMenuLabels.length; ++i) {
            JMenuItem btn = new JMenuItem(pMenuLabels[i]);
            btn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    TablePopupMenu.this.executeActionPerformed(evt);
                }
            });
            this.add(btn);
        }
    }

    public void showMenu(MouseEvent evt, int row, int col, String objname) {
        this.selected_row = row;
        this.selected_col = col;
        this.titleLbl.setText(objname);
        JMenuItem ch_item = (JMenuItem)this.getComponent(2);
        JMenuItem del_item = (JMenuItem)this.getComponent(5);
        if (col == 0) {
            ch_item.setText("Change Row Name");
            del_item.setText("Remove Row");
        } else {
            ch_item.setText("Set Attribute");
        }
        this.show(this.table, evt.getX(), evt.getY());
    }

    public void showMenu(MouseEvent evt, int col, String colname) {
        this.selected_row = -1;
        this.selected_col = col;
        this.titleLbl.setText(colname);
        JMenuItem ch_item = (JMenuItem)this.getComponent(2);
        JMenuItem del_item = (JMenuItem)this.getComponent(5);
        ch_item.setText("Change Column Name");
        del_item.setText("Remove Column");
        this.selected_row = -1;
        this.show(this.table, evt.getX(), evt.getY());
    }

    public void showTreeMenu(MouseEvent evt, String attname, DevBrowser.TargetPosition tp) {
        TreePath selectedPath = this.tree.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            return;
        }
        this.tree.setSelectionPath(selectedPath);
        String txt = treeLabels[0] + " " + attname;
        ((JMenuItem)this.getComponent(2)).setText(txt);
        this.titleLbl.setText("At  [" + tp.rowname + "] [" + tp.colname + "]");
        this.show(this.tree, evt.getX(), evt.getY());
    }

    private void executeActionPerformed(ActionEvent evt) {
        Object obj = evt.getSource();
        int cmdidx = 0;
        for (int i = 0; i < pMenuLabels.length; ++i) {
            if (this.getComponent(2 + i) != obj) continue;
            cmdidx = i;
        }
        if (this.table != null) {
            this.manageTableMenu(cmdidx);
        } else if (this.tree != null) {
            this.manageTreeMenu(cmdidx);
        }
    }

    private void manageTreeMenu(int cmdidx) {
        switch (cmdidx) {
            case 0: {
                this.tree.addAttribute();
            }
        }
    }

    private void manageTableMenu(int cmdidx) {
        switch (cmdidx) {
            case 0: {
                if (this.selected_row == -1) {
                    this.panel.changeColumnName(this.selected_col);
                    break;
                }
                if (this.selected_col == 0) {
                    this.panel.changeRowName(this.selected_row);
                    break;
                }
                this.panel.changeAttributeAt(this.selected_row, this.selected_col);
                break;
            }
            case 3: {
                if (this.selected_row == -1) {
                    this.panel.deleteColumn(this.selected_col);
                    break;
                }
                this.panel.deleteRow(this.selected_row);
                break;
            }
            case 1: {
                this.panel.addColumn();
                break;
            }
            case 2: {
                this.panel.addRow();
            }
        }
    }

    static {
        tableLabels = new String[]{"Change Name", "Add Column", "Add Row", "Remove "};
        treeLabels = new String[]{"Set attribute"};
    }
}

