/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.FileFinder;
import fr.esrf.tangoatk.widget.util.jdraw.JDCreationMenu;
import fr.esrf.tangoatk.widget.util.jdraw.JDLibraryViewer;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDValueListener;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditorListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class JDrawEditorFrame
extends JFrame
implements ActionListener,
JDrawEditorListener,
JDValueListener {
    public JScrollPane theEditorView;
    public JLabel statusLabel;
    public JMenu fileMenu;
    public JMenuItem fileOpenMenuItem;
    public JMenuItem fileImportMenuItem;
    public JMenuItem fileSaveMenuItem;
    public JMenuItem fileSaveasMenuItem;
    public JMenuItem fileExitMenuItem;
    public JMenu editMenu;
    public JMenuItem editUndoMenuItem;
    public JMenuItem editRedoMenuItem;
    public JMenuItem editCutMenuItem;
    public JMenuItem editCopyMenuItem;
    public JMenuItem editPasteMenuItem;
    public JMenuItem editDeleteMenuItem;
    public JMenuItem editSelectAllMenuItem;
    public JMenuItem editSelectNVMenuItem;
    public JMenuItem editSelectNoneMenuItem;
    public JMenu viewsMenu;
    public JMenuItem viewsTransformMenuItem;
    public JMenuItem viewsPlayMenuItem;
    public JMenuItem viewsOptionMenuItem;
    public JMenuItem viewsBrowseMenuItem;
    private JMenuItem viewsGroupEditMenuItem;
    private JMenuItem viewsJavaMenuItem;
    private JMenuItem viewsGlobalMenuItem;
    public JMenu toolsMenu;
    public JMenuItem toolsHMirrorMenuItem;
    public JMenuItem toolsVMirrorMenuItem;
    public JMenuItem toolsAligntopMenuItem;
    public JMenuItem toolsAlignleftMenuItem;
    public JMenuItem toolsAlignbottomMenuItem;
    public JMenuItem toolsAlignrightMenuItem;
    private JMenuItem toolsRaiseMenuItem;
    private JMenuItem toolsLowerMenuItem;
    private JMenuItem toolsFrontMenuItem;
    private JMenuItem toolsBackMenuItem;
    private JMenuItem toolsConvertPolyMenuItem;
    private JCheckBoxMenuItem toolsGridVisible;
    private JCheckBoxMenuItem toolsAlignToGrid;
    private JMenuItem toolsGridSettings;
    private JMenuItem toolsFitToGraph;
    public JDCreationMenu createMenu;
    public JToolBar editToolBar;
    public JButton editToolFileOpenBtn;
    public JButton editToolFileSaveBtn;
    public JButton editToolUndoBtn;
    public JButton editToolRedoBtn;
    public JButton editToolCutBtn;
    public JButton editToolCopyBtn;
    public JButton editToolPasteBtn;
    public JButton editToolZoomInBtn;
    public JButton editToolZoomOutBtn;
    public JLabel editToolZoomLabel;
    public JButton editToolOptionBtn;
    public JButton editToolTransformBtn;
    public JButton editToolHMirrorBtn;
    public JButton editToolVMirrorBtn;
    public JButton editToolAlignLeftBtn;
    public JButton editToolAlignTopBtn;
    public JButton editToolAlignRightBtn;
    public JButton editToolAlignBottomBtn;
    private JDrawEditor theEditor;
    private JDrawEditor thePlayer;
    private JFrame framePlayer;
    private JScrollPane fpTextView;
    private JTextArea fpText;
    private JMenuItem viewDebugOutput;
    private JMenuItem hideDebugOutput;
    private JMenuItem clearDebugOutput;
    private StringBuffer fpStr;
    private JPanel statusLine;
    private JMenuBar theMenu;
    private String APP_RELEASE;
    private JSplitPane splitPane;
    private JButton[] libButton;
    private JComboBox libCombo;
    private JDLibraryViewer[] libViewer;
    private int nLibs;

    public JDrawEditorFrame() {
        this.setTitle(this.APP_RELEASE);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.statusLine = new JPanel(new GridLayout(1, 1));
        container.add((Component)this.statusLine, "South");
        this.statusLabel = new JLabel();
        this.statusLabel.setFont(JDUtils.labelFont);
        this.statusLabel.setHorizontalAlignment(2);
        this.statusLine.add(this.statusLabel);
        this.createMenu = new JDCreationMenu();
        container.add((Component)this.createMenu.getToolbar(), "West");
        this.editToolBar = new JToolBar();
        this.editToolZoomLabel = new JLabel();
        this.editToolZoomLabel.setFont(JDUtils.labelFont);
        this.editToolZoomLabel.setText("100%");
        this.editToolZoomLabel.setHorizontalAlignment(0);
        this.editToolZoomLabel.setMaximumSize(new Dimension(50, 32));
        this.editToolZoomLabel.setPreferredSize(new Dimension(50, 32));
        this.editToolZoomLabel.setMinimumSize(new Dimension(50, 32));
        this.editToolFileOpenBtn = JDUtils.createIconButton("jdraw_fileopen", true, "Open File", this);
        this.editToolFileSaveBtn = JDUtils.createIconButton("jdraw_filesave", true, "Save File", this);
        this.editToolUndoBtn = JDUtils.createIconButton("jdraw_undo", true, "Undo the last action", this);
        this.editToolRedoBtn = JDUtils.createIconButton("jdraw_redo", true, "Redo the last canceled action", this);
        this.editToolCutBtn = JDUtils.createIconButton("jdraw_cut", true, "Cut selection", this);
        this.editToolCopyBtn = JDUtils.createIconButton("jdraw_copy", true, "Copy selection to clipboard", this);
        this.editToolPasteBtn = JDUtils.createIconButton("jdraw_paste", true, "Paste selection", this);
        this.editToolZoomInBtn = JDUtils.createIconButton("jdraw_zoom", true, "Zoom In", this);
        this.editToolZoomOutBtn = JDUtils.createIconButton("jdraw_zoomm", true, "Zoom Out", this);
        this.editToolOptionBtn = JDUtils.createIconButton("jdraw_option", true, "Show selected object(s) properties", this);
        this.editToolTransformBtn = JDUtils.createIconButton("jdraw_transform", true, "Show transformation dialog", this);
        this.editToolHMirrorBtn = JDUtils.createIconButton("jdraw_hmirror", true, "Horizontal mirror on selected object(s)", this);
        this.editToolVMirrorBtn = JDUtils.createIconButton("jdraw_vmirror", true, "Vertical mirror on selected object(s)", this);
        this.editToolAlignTopBtn = JDUtils.createIconButton("jdraw_aligntop", true, "Align selected objects", this);
        this.editToolAlignLeftBtn = JDUtils.createIconButton("jdraw_alignleft", true, "Align selected objects", this);
        this.editToolAlignBottomBtn = JDUtils.createIconButton("jdraw_alignbottom", true, "Align selected objects", this);
        this.editToolAlignRightBtn = JDUtils.createIconButton("jdraw_alignright", true, "Align selected objects", this);
        this.editToolBar.add(this.editToolFileOpenBtn);
        this.editToolBar.add(this.editToolFileSaveBtn);
        this.editToolBar.add(new JLabel(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/jdraw/gif/jdraw_separator.gif"))));
        this.editToolBar.add(this.editToolUndoBtn);
        this.editToolBar.add(this.editToolRedoBtn);
        this.editToolBar.add(new JLabel(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/jdraw/gif/jdraw_separator.gif"))));
        this.editToolBar.add(this.editToolCutBtn);
        this.editToolBar.add(this.editToolCopyBtn);
        this.editToolBar.add(this.editToolPasteBtn);
        this.editToolBar.add(new JLabel(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/jdraw/gif/jdraw_separator.gif"))));
        this.editToolBar.add(this.editToolZoomInBtn);
        this.editToolBar.add(this.editToolZoomOutBtn);
        this.editToolBar.add(this.editToolZoomLabel);
        this.editToolBar.add(new JLabel(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/jdraw/gif/jdraw_separator.gif"))));
        this.editToolBar.add(this.editToolOptionBtn);
        this.editToolBar.add(this.editToolTransformBtn);
        this.editToolBar.add(new JLabel(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/jdraw/gif/jdraw_separator.gif"))));
        this.editToolBar.add(this.editToolHMirrorBtn);
        this.editToolBar.add(this.editToolVMirrorBtn);
        this.editToolBar.add(this.editToolAlignTopBtn);
        this.editToolBar.add(this.editToolAlignLeftBtn);
        this.editToolBar.add(this.editToolAlignBottomBtn);
        this.editToolBar.add(this.editToolAlignRightBtn);
        this.editToolBar.setOrientation(0);
        container.add((Component)this.editToolBar, "North");
        this.theMenu = new JMenuBar();
        this.fileExitMenuItem = new JMenuItem("Exit");
        this.fileExitMenuItem.addActionListener(this);
        this.fileOpenMenuItem = new JMenuItem("Open...");
        this.fileOpenMenuItem.addActionListener(this);
        this.fileImportMenuItem = new JMenuItem("Import...");
        this.fileImportMenuItem.addActionListener(this);
        this.fileSaveMenuItem = new JMenuItem("Save");
        this.fileSaveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.fileSaveMenuItem.addActionListener(this);
        this.fileSaveasMenuItem = new JMenuItem("Save as...");
        this.fileSaveasMenuItem.addActionListener(this);
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic('F');
        this.fileMenu.add(this.fileOpenMenuItem);
        this.fileMenu.add(this.fileImportMenuItem);
        this.fileMenu.add(this.fileSaveMenuItem);
        this.fileMenu.add(this.fileSaveasMenuItem);
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(this.fileExitMenuItem);
        this.theMenu.add(this.fileMenu);
        this.editUndoMenuItem = new JMenuItem("Undo");
        this.editUndoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.editUndoMenuItem.addActionListener(this);
        this.editRedoMenuItem = new JMenuItem("Redo");
        this.editRedoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 3));
        this.editRedoMenuItem.addActionListener(this);
        this.editCutMenuItem = new JMenuItem("Cut");
        this.editCutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.editCutMenuItem.addActionListener(this);
        this.editCopyMenuItem = new JMenuItem("Copy");
        this.editCopyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.editCopyMenuItem.addActionListener(this);
        this.editPasteMenuItem = new JMenuItem("Paste");
        this.editPasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.editPasteMenuItem.addActionListener(this);
        this.editDeleteMenuItem = new JMenuItem("Delete");
        this.editDeleteMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.editDeleteMenuItem.addActionListener(this);
        this.editSelectAllMenuItem = new JMenuItem("Select all");
        this.editSelectAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.editSelectAllMenuItem.addActionListener(this);
        this.editSelectNoneMenuItem = new JMenuItem("Select none");
        this.editSelectNoneMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.editSelectNoneMenuItem.addActionListener(this);
        this.editSelectNVMenuItem = new JMenuItem("Select not visible");
        this.editSelectNVMenuItem.addActionListener(this);
        this.editMenu = new JMenu("Edit");
        this.editMenu.setMnemonic('E');
        this.editMenu.add(this.editUndoMenuItem);
        this.editMenu.add(this.editRedoMenuItem);
        this.editMenu.add(new JSeparator());
        this.editMenu.add(this.editCutMenuItem);
        this.editMenu.add(this.editCopyMenuItem);
        this.editMenu.add(this.editPasteMenuItem);
        this.editMenu.add(this.editDeleteMenuItem);
        this.editMenu.add(new JSeparator());
        this.editMenu.add(this.editSelectAllMenuItem);
        this.editMenu.add(this.editSelectNoneMenuItem);
        this.editMenu.add(this.editSelectNVMenuItem);
        this.theMenu.add(this.editMenu);
        this.theMenu.add(this.createMenu.getMenu());
        this.viewsPlayMenuItem = new JMenuItem("Player view");
        this.viewsPlayMenuItem.addActionListener(this);
        this.viewsOptionMenuItem = new JMenuItem("Object properties...");
        this.viewsOptionMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.viewsOptionMenuItem.addActionListener(this);
        this.viewsTransformMenuItem = new JMenuItem("Transform view...");
        this.viewsTransformMenuItem.addActionListener(this);
        this.viewsBrowseMenuItem = new JMenuItem("Selection browser...");
        this.viewsBrowseMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.viewsBrowseMenuItem.addActionListener(this);
        this.viewsGroupEditMenuItem = new JMenuItem("Group editor...");
        this.viewsGroupEditMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.viewsGroupEditMenuItem.addActionListener(this);
        this.viewsJavaMenuItem = new JMenuItem("Java code generator...");
        this.viewsJavaMenuItem.addActionListener(this);
        this.viewsGlobalMenuItem = new JMenuItem("Global properties...");
        this.viewsGlobalMenuItem.addActionListener(this);
        this.viewsMenu = new JMenu("Views");
        this.viewsMenu.setMnemonic('V');
        this.viewsMenu.add(this.viewsPlayMenuItem);
        this.viewsMenu.add(this.viewsGlobalMenuItem);
        this.viewsMenu.add(this.viewsTransformMenuItem);
        this.viewsMenu.add(this.viewsOptionMenuItem);
        this.viewsMenu.add(this.viewsBrowseMenuItem);
        this.viewsMenu.add(this.viewsGroupEditMenuItem);
        this.viewsMenu.add(this.viewsJavaMenuItem);
        this.theMenu.add(this.viewsMenu);
        this.toolsHMirrorMenuItem = new JMenuItem("Horizontal mirror");
        this.toolsHMirrorMenuItem.addActionListener(this);
        this.toolsVMirrorMenuItem = new JMenuItem("Vertical mirror");
        this.toolsVMirrorMenuItem.addActionListener(this);
        this.toolsAligntopMenuItem = new JMenuItem("Align top");
        this.toolsAligntopMenuItem.addActionListener(this);
        this.toolsAlignleftMenuItem = new JMenuItem("Align left");
        this.toolsAlignleftMenuItem.addActionListener(this);
        this.toolsAlignbottomMenuItem = new JMenuItem("Align bottom");
        this.toolsAlignbottomMenuItem.addActionListener(this);
        this.toolsAlignrightMenuItem = new JMenuItem("Align right");
        this.toolsAlignrightMenuItem.addActionListener(this);
        this.toolsConvertPolyMenuItem = new JMenuItem("Convert to Polyline");
        this.toolsConvertPolyMenuItem.addActionListener(this);
        this.toolsRaiseMenuItem = new JMenuItem("Raise");
        this.toolsRaiseMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 3));
        this.toolsRaiseMenuItem.addActionListener(this);
        this.toolsLowerMenuItem = new JMenuItem("Lower");
        this.toolsLowerMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 3));
        this.toolsLowerMenuItem.addActionListener(this);
        this.toolsFrontMenuItem = new JMenuItem("Bring to front");
        this.toolsFrontMenuItem.addActionListener(this);
        this.toolsBackMenuItem = new JMenuItem("Send to back");
        this.toolsBackMenuItem.addActionListener(this);
        this.toolsAlignToGrid = new JCheckBoxMenuItem("Align to grid");
        this.toolsAlignToGrid.setAccelerator(KeyStroke.getKeyStroke(65, 3));
        this.toolsAlignToGrid.setSelected(false);
        this.toolsAlignToGrid.addActionListener(this);
        this.toolsGridVisible = new JCheckBoxMenuItem("Show grid");
        this.toolsGridVisible.setSelected(false);
        this.toolsGridVisible.addActionListener(this);
        this.toolsGridSettings = new JMenuItem("Grid settings...");
        this.toolsGridSettings.addActionListener(this);
        this.toolsFitToGraph = new JMenuItem("Fit view to graph");
        this.toolsFitToGraph.addActionListener(this);
        this.toolsMenu = new JMenu("Tools");
        this.toolsMenu.setMnemonic('T');
        this.toolsMenu.add(this.toolsHMirrorMenuItem);
        this.toolsMenu.add(this.toolsVMirrorMenuItem);
        this.toolsMenu.add(new JSeparator());
        this.toolsMenu.add(this.toolsAligntopMenuItem);
        this.toolsMenu.add(this.toolsAlignleftMenuItem);
        this.toolsMenu.add(this.toolsAlignbottomMenuItem);
        this.toolsMenu.add(this.toolsAlignrightMenuItem);
        this.toolsMenu.add(new JSeparator());
        this.toolsMenu.add(this.toolsRaiseMenuItem);
        this.toolsMenu.add(this.toolsLowerMenuItem);
        this.toolsMenu.add(this.toolsFrontMenuItem);
        this.toolsMenu.add(this.toolsBackMenuItem);
        this.toolsMenu.add(new JSeparator());
        this.toolsMenu.add(this.toolsConvertPolyMenuItem);
        this.toolsMenu.add(new JSeparator());
        this.toolsMenu.add(this.toolsAlignToGrid);
        this.toolsMenu.add(this.toolsGridVisible);
        this.toolsMenu.add(this.toolsGridSettings);
        this.toolsMenu.add(new JSeparator());
        this.toolsMenu.add(this.toolsFitToGraph);
        this.theMenu.add(this.toolsMenu);
        this.setJMenuBar(this.theMenu);
    }

    public void setEditor(JDrawEditor jDrawEditor) {
        this.theEditor = jDrawEditor;
        this.theEditor.setStatusLabel(this.statusLabel);
        this.theEditor.setStatus("");
        this.theEditor.addEditorListener(this);
        this.createMenu.setEditor(jDrawEditor);
        this.theEditor.setBorder(BorderFactory.createEtchedBorder());
        this.theEditorView = new JScrollPane(jDrawEditor);
        this.theEditorView.setWheelScrollingEnabled(true);
        this.getContentPane().add((Component)this.theEditorView, "Center");
        this.selectionChanged();
        this.valueChanged();
        this.clipboardChanged();
    }

    public void setPlayer(JDrawEditor jDrawEditor) {
        this.framePlayer = new JFrame();
        this.framePlayer.getContentPane().setLayout(new BorderLayout());
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Debug");
        this.viewDebugOutput = new JMenuItem("View output");
        this.viewDebugOutput.addActionListener(this);
        jMenu.add(this.viewDebugOutput);
        this.hideDebugOutput = new JMenuItem("Hide output");
        this.hideDebugOutput.addActionListener(this);
        jMenu.add(this.hideDebugOutput);
        this.clearDebugOutput = new JMenuItem("Clear history");
        this.clearDebugOutput.addActionListener(this);
        jMenu.add(this.clearDebugOutput);
        jMenuBar.add(jMenu);
        this.splitPane = new JSplitPane(0);
        this.fpText = new JTextArea();
        this.fpText.setEditable(false);
        this.fpText.setFont(JDUtils.labelFont);
        this.fpTextView = new JScrollPane(this.fpText);
        this.thePlayer = new JDrawEditor(3);
        this.splitPane.add(this.thePlayer);
        this.splitPane.add(this.fpTextView);
        this.framePlayer.getContentPane().add((Component)this.splitPane, "Center");
        this.fpTextView.setPreferredSize(new Dimension(0, 60));
        this.framePlayer.setTitle("Play mode");
        this.framePlayer.setJMenuBar(jMenuBar);
        this.framePlayer.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JDrawEditorFrame.this.fpStr = new StringBuffer();
                JDrawEditorFrame.this.fpText.setText("");
            }
        });
    }

    public void setAppTitle(String string) {
        this.APP_RELEASE = string;
    }

    public void setLibraries(String string) {
        FileFinder fileFinder;
        String[] stringArray;
        String string2 = string == null ? System.getProperty("LIBPATH", "null") : string;
        if (string2.equals("null")) {
            System.out.println("Warning LIBPATH is not defined.");
        }
        if ((stringArray = (fileFinder = new FileFinder(string2, ".lib", 12)).getList(true)) == null) {
            System.out.println("No libraries found in " + string2);
            return;
        }
        this.nLibs = stringArray.length;
        this.libViewer = new JDLibraryViewer[this.nLibs];
        this.libButton = new JButton[this.nLibs];
        this.libCombo = new JComboBox();
        this.libCombo.addItem("Palette Libraries");
        for (int i = 0; i < this.nLibs; ++i) {
            this.libViewer[i] = new JDLibraryViewer(string2 + (!string2.endsWith("/") ? "/" : "") + stringArray[i], this.theEditor, false);
            this.libViewer[i].setTitle("JDraw library: " + stringArray[i]);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.libViewer[i].pack();
            this.libViewer[i].setBounds(dimension.width - this.libViewer[i].getPreferredSize().width - 15, (dimension.height - this.libViewer[i].getPreferredSize().height) / 2, this.libViewer[i].getPreferredSize().width < dimension.width ? this.libViewer[i].getPreferredSize().width : dimension.width, this.libViewer[i].getPreferredSize().height < dimension.height ? this.libViewer[i].getPreferredSize().height : dimension.width);
            this.libCombo.addItem(stringArray[i]);
        }
        this.libCombo.addItem("Choose a file ...");
        this.libCombo.setSelectedIndex(0);
        this.libCombo.addActionListener(this);
        this.editToolBar.add(new JLabel(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/jdraw/gif/jdraw_separator.gif"))));
        this.editToolBar.add(this.libCombo);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.fileExitMenuItem) {
            this.exitApp();
        } else if (object == this.editToolPasteBtn || object == this.editPasteMenuItem) {
            this.theEditor.create(7);
        } else if (object == this.editToolCopyBtn || object == this.editCopyMenuItem) {
            this.theEditor.copySelection();
        } else if (object == this.editToolCutBtn || object == this.editCutMenuItem) {
            this.theEditor.cutSelection();
        } else if (object == this.editDeleteMenuItem) {
            this.theEditor.deleteSelection();
        } else if (object == this.editToolOptionBtn || object == this.viewsOptionMenuItem) {
            this.theEditor.showPropertyWindow();
        } else if (object == this.editToolTransformBtn || object == this.viewsTransformMenuItem) {
            this.theEditor.showTransformWindow();
        } else if (object == this.editToolHMirrorBtn || object == this.toolsHMirrorMenuItem) {
            this.theEditor.scaleSelection(-1.0, 1.0);
        } else if (object == this.editToolVMirrorBtn || object == this.toolsVMirrorMenuItem) {
            this.theEditor.scaleSelection(1.0, -1.0);
        } else if (object == this.editToolFileSaveBtn || object == this.fileSaveasMenuItem) {
            this.theEditor.showSaveDialog(".");
        } else if (object == this.editToolFileOpenBtn || object == this.fileOpenMenuItem) {
            this.theEditor.showOpenDialog(".");
        } else if (object == this.fileSaveMenuItem) {
            this.theEditor.instantSave(".");
        } else if (object == this.editToolZoomInBtn) {
            this.theEditor.zoomIn();
        } else if (object == this.editToolZoomOutBtn) {
            this.theEditor.zoomOut();
        } else if (object == this.editSelectAllMenuItem) {
            this.theEditor.selectAll();
        } else if (object == this.editSelectNVMenuItem) {
            this.theEditor.selectNotVisible();
        } else if (object == this.editSelectNoneMenuItem) {
            this.theEditor.unselectAll();
        } else if (object == this.editToolUndoBtn || object == this.editUndoMenuItem) {
            this.theEditor.undo();
        } else if (object == this.editToolRedoBtn || object == this.editRedoMenuItem) {
            this.theEditor.redo();
        } else if (object == this.editToolAlignTopBtn || object == this.toolsAligntopMenuItem) {
            this.theEditor.aligntopSelection();
        } else if (object == this.editToolAlignLeftBtn || object == this.toolsAlignleftMenuItem) {
            this.theEditor.alignleftSelection();
        } else if (object == this.editToolAlignBottomBtn || object == this.toolsAlignbottomMenuItem) {
            this.theEditor.alignbottomSelection();
        } else if (object == this.editToolAlignRightBtn || object == this.toolsAlignrightMenuItem) {
            this.theEditor.alignrightSelection();
        } else if (object == this.viewsBrowseMenuItem) {
            this.theEditor.showBrowserWindow();
        } else if (object == this.viewsPlayMenuItem) {
            this.showPlayer();
        } else if (object == this.viewsGroupEditMenuItem) {
            this.theEditor.showGroupEditorWindow();
        } else if (object == this.viewsJavaMenuItem) {
            this.theEditor.showGroupJavaWindow();
        } else if (object == this.viewsGlobalMenuItem) {
            JDUtils.showGlobalDialog(this.theEditor);
        } else if (object == this.toolsConvertPolyMenuItem) {
            this.theEditor.convertToPolyline();
        } else if (object == this.toolsRaiseMenuItem) {
            this.theEditor.raiseObject();
        } else if (object == this.toolsLowerMenuItem) {
            this.theEditor.lowerObject();
        } else if (object == this.toolsFrontMenuItem) {
            this.theEditor.frontSelection();
        } else if (object == this.toolsBackMenuItem) {
            this.theEditor.backSelection();
        } else if (object == this.viewDebugOutput) {
            this.fpTextView.setVisible(true);
            this.splitPane.setDividerLocation(this.splitPane.getHeight() - 80);
            this.splitPane.revalidate();
        } else if (object == this.hideDebugOutput) {
            this.fpTextView.setVisible(false);
            this.splitPane.revalidate();
        } else if (object == this.clearDebugOutput) {
            this.fpStr = new StringBuffer();
            this.fpText.setText("");
        } else if (object == this.toolsAlignToGrid) {
            this.theEditor.setAlignToGrid(this.toolsAlignToGrid.isSelected());
        } else if (object == this.toolsGridVisible) {
            this.theEditor.setGridVisible(this.toolsGridVisible.isSelected());
        } else if (object == this.toolsGridSettings) {
            String string = JOptionPane.showInputDialog("Enter Grid Size", (Object)new Integer(this.theEditor.getGridSize()));
            if (string != null) {
                try {
                    int n = Integer.parseInt(string);
                    this.theEditor.setGridSize(n);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, "Wrong integer value\n" + numberFormatException.getMessage());
                }
            }
        } else if (object == this.toolsFitToGraph) {
            this.theEditor.computePreferredSize();
        } else if (object == this.libCombo) {
            if (this.libCombo.getSelectedIndex() > this.libViewer.length) {
                JFileChooser jFileChooser = new JFileChooser(".");
                jFileChooser.setDialogTitle("[SimpleSynopticAppli] Open a synoptic file.");
                int n = jFileChooser.showOpenDialog(null);
                if (n != 0) {
                    return;
                }
                Serializable serializable = jFileChooser.getSelectedFile();
                String string = ((File)serializable).getAbsolutePath();
                serializable = new JDLibraryViewer(string, this.theEditor, false);
                ((Frame)serializable).setTitle("JDraw library: " + string);
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                ((Window)serializable).pack();
                ((Window)serializable).setBounds(dimension.width - ((Container)serializable).getPreferredSize().width - 15, (dimension.height - ((Container)serializable).getPreferredSize().height) / 2, ((Container)serializable).getPreferredSize().width < dimension.width ? ((Container)serializable).getPreferredSize().width : dimension.width, ((Container)serializable).getPreferredSize().height < dimension.height ? ((Container)serializable).getPreferredSize().height : dimension.width);
                ((Window)serializable).setVisible(true);
                this.libCombo.setSelectedIndex(0);
                return;
            }
            if (this.libCombo.getSelectedIndex() > 0) {
                this.libViewer[this.libCombo.getSelectedIndex() - 1].setVisible(true);
                this.libCombo.setSelectedIndex(0);
                return;
            }
        }
    }

    public void creationDone() {
    }

    public void selectionChanged() {
        int n = this.theEditor.getSelectionLength();
        this.editToolCutBtn.setEnabled(n > 0);
        this.editCutMenuItem.setEnabled(n > 0);
        this.editToolCopyBtn.setEnabled(n > 0);
        this.editCopyMenuItem.setEnabled(n > 0);
        this.editDeleteMenuItem.setEnabled(n > 0);
        this.editToolOptionBtn.setEnabled(n > 0);
        this.viewsOptionMenuItem.setEnabled(n > 0);
        this.editToolTransformBtn.setEnabled(n > 0);
        this.viewsTransformMenuItem.setEnabled(n > 0);
        this.editToolHMirrorBtn.setEnabled(n > 0);
        this.toolsHMirrorMenuItem.setEnabled(n > 0);
        this.editToolVMirrorBtn.setEnabled(n > 0);
        this.toolsVMirrorMenuItem.setEnabled(n > 0);
        this.editToolAlignLeftBtn.setEnabled(n > 1);
        this.toolsAlignleftMenuItem.setEnabled(n > 1);
        this.editToolAlignTopBtn.setEnabled(n > 1);
        this.toolsAligntopMenuItem.setEnabled(n > 1);
        this.editToolAlignRightBtn.setEnabled(n > 1);
        this.toolsAlignrightMenuItem.setEnabled(n > 1);
        this.editToolAlignBottomBtn.setEnabled(n > 1);
        this.toolsAlignbottomMenuItem.setEnabled(n > 1);
        this.editSelectAllMenuItem.setEnabled(n < this.theEditor.getObjectNumber());
        this.editSelectNVMenuItem.setEnabled(n < this.theEditor.getObjectNumber());
        this.editSelectNoneMenuItem.setEnabled(n > 0);
        this.viewsBrowseMenuItem.setEnabled(n > 0);
        this.toolsConvertPolyMenuItem.setEnabled(this.theEditor.canConvertToPolyline());
        this.viewsGroupEditMenuItem.setEnabled(this.theEditor.canEditGroup());
        this.viewsJavaMenuItem.setEnabled(n > 0);
        this.toolsRaiseMenuItem.setEnabled(n == 1);
        this.toolsLowerMenuItem.setEnabled(n == 1);
        this.toolsFrontMenuItem.setEnabled(n >= 1);
        this.toolsBackMenuItem.setEnabled(n >= 1);
        this.toolsAlignToGrid.setSelected(this.theEditor.isAlignToGrid());
        this.toolsGridVisible.setSelected(this.theEditor.isGridVisible());
    }

    public void clipboardChanged() {
        int n = this.theEditor.getClipboardLength();
        this.editToolPasteBtn.setEnabled(n > 0);
        this.editPasteMenuItem.setEnabled(n > 0);
    }

    public void valueChanged() {
        this.editUndoMenuItem.setText("Undo " + this.theEditor.getLastActionName());
        this.editUndoMenuItem.setEnabled(this.theEditor.canUndo());
        this.editRedoMenuItem.setText("Redo " + this.theEditor.getNextActionName());
        this.editRedoMenuItem.setEnabled(this.theEditor.canRedo());
        this.editToolUndoBtn.setEnabled(this.theEditor.canUndo());
        this.editToolRedoBtn.setEnabled(this.theEditor.canRedo());
        String string = this.APP_RELEASE;
        if (this.theEditor.getFileName().length() > 0) {
            string = string + " [" + this.theEditor.getFileName() + "]";
        }
        if (this.theEditor.getNeedToSaveState()) {
            this.setTitle(string + "*");
        } else {
            this.setTitle(string);
        }
    }

    public void sizeChanged() {
        this.theEditorView.revalidate();
        this.repaint();
        this.editToolZoomLabel.setText(this.theEditor.getZoomFactorPercent() + "%");
    }

    public void valueChanged(JDObject jDObject) {
        if (this.fpTextView.isVisible()) {
            this.fpStr.append(jDObject.getName() + " valueChanged(value=" + jDObject.getValue() + ")\n");
            this.fpText.setText(this.fpStr.toString());
        }
    }

    public void valueExceedBounds(JDObject jDObject) {
        if (this.fpTextView.isVisible()) {
            this.fpStr.append(jDObject.getName() + " valueExceedBounds(value=" + jDObject.getValue() + ")\n");
            this.fpText.setText(this.fpStr.toString());
        }
    }

    private void showPlayer() {
        Object object;
        int n;
        this.thePlayer.clearObjects();
        this.thePlayer.setBackground(this.theEditor.getBackground());
        this.fpStr = new StringBuffer();
        for (n = 0; n < this.theEditor.getObjectNumber(); ++n) {
            object = this.theEditor.getObjectAt(n).copy(0, 0);
            this.thePlayer.addObject((JDObject)object);
            if (!((JDObject)object).isProgrammed()) continue;
            this.fpStr.append(((JDObject)object).getName() + " is programmed.\n");
        }
        this.thePlayer.initPlayer();
        this.thePlayer.computePreferredSize();
        object = this.thePlayer.getInteractiveObjects();
        for (n = 0; n < ((Vector)object).size(); ++n) {
            JDObject jDObject = (JDObject)((Vector)object).get(n);
            this.fpStr.append(jDObject.getName() + " has user value enabled.\n");
            jDObject.addValueListener(this);
        }
        this.fpText.setText(this.fpStr.toString());
        ATKGraphicsUtils.centerFrameOnScreen(this.framePlayer);
        this.framePlayer.setVisible(true);
    }

    public void exitApp() {
        int n = 0;
        if (this.theEditor.getNeedToSaveState() && (n = JOptionPane.showConfirmDialog(this, "Your changes will be lost , save before exiting ?", "Exit confirmation", 1)) == 0) {
            this.theEditor.instantSave(".");
        }
        if (n != 2) {
            System.exit(0);
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.exitApp();
        } else {
            super.processWindowEvent(windowEvent);
        }
    }

    public static void main(String[] stringArray) {
        JDrawEditor jDrawEditor = new JDrawEditor(1);
        JDrawEditor jDrawEditor2 = new JDrawEditor(3);
        JDrawEditorFrame jDrawEditorFrame = new JDrawEditorFrame();
        jDrawEditorFrame.setAppTitle("JDraw Editor 1.11");
        jDrawEditorFrame.setEditor(jDrawEditor);
        jDrawEditorFrame.setPlayer(jDrawEditor2);
        jDrawEditorFrame.setLibraries(null);
        if (stringArray.length == 1) {
            try {
                jDrawEditor.loadFile(stringArray[0]);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, "Error, cannot load " + stringArray[0] + "\n" + iOException.getMessage(), "JDrawEditor", 0);
            }
        }
        ATKGraphicsUtils.centerFrameOnScreen(jDrawEditorFrame);
        jDrawEditorFrame.setVisible(true);
    }
}

