/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDAxis;
import fr.esrf.tangoatk.widget.util.jdraw.JDBar;
import fr.esrf.tangoatk.widget.util.jdraw.JDEllipse;
import fr.esrf.tangoatk.widget.util.jdraw.JDFileFilter;
import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDGroup;
import fr.esrf.tangoatk.widget.util.jdraw.JDImage;
import fr.esrf.tangoatk.widget.util.jdraw.JDLabel;
import fr.esrf.tangoatk.widget.util.jdraw.JDLine;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyConvert;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangle;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangular;
import fr.esrf.tangoatk.widget.util.jdraw.JDRoundRectangle;
import fr.esrf.tangoatk.widget.util.jdraw.JDSlider;
import fr.esrf.tangoatk.widget.util.jdraw.JDSpline;
import fr.esrf.tangoatk.widget.util.jdraw.JDSwingObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditorListener;
import fr.esrf.tangoatk.widget.util.jdraw.JLXFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.LXFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.UndoBuffer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class JDrawEditor
extends JComponent
implements MouseMotionListener,
MouseListener,
ActionListener,
KeyListener,
ComponentListener {
    public static final int MODE_EDIT = 1;
    public static final int MODE_EDIT_GROUP = 2;
    public static final int MODE_PLAY = 3;
    public static final int MODE_LIB = 4;
    public static final int CREATE_RECTANGLE = 1;
    public static final int CREATE_LINE = 2;
    public static final int CREATE_ELLIPSE = 3;
    public static final int CREATE_POLYLINE = 4;
    public static final int CREATE_LABEL = 5;
    public static final int CREATE_SPLINE = 6;
    public static final int CREATE_CLIPBOARD = 7;
    public static final int CREATE_RRECTANGLE = 8;
    public static final int CREATE_IMAGE = 9;
    public static final int CREATE_SWINGOBJECT = 10;
    public static final int CREATE_AXIS = 11;
    public static final int CREATE_BAR = 12;
    public static final int CREATE_SLIDER = 13;
    static final int CREATE_SLIDER_CURSOR = 14;
    static final int CREATE_CONNECT_POLY = 15;
    private static final int undoLength = 20;
    private Vector objects;
    private Vector clipboard;
    private Vector undo;
    private int undoPos;
    private int curObject;
    private Vector selObjects;
    private boolean isDraggingSummits;
    private int[] selSummits;
    private boolean isDraggingSummit;
    private int selSummit;
    private boolean isDraggingObject;
    private boolean isDraggingSelection;
    private boolean hasMoved;
    private int lastX;
    private int lastY;
    private int selX1;
    private int selY1;
    private int selX2;
    private int selY2;
    private int creationMode;
    private JDObject lastCreatedObject = null;
    private Vector tmpPoints;
    private JPopupMenu objMenu;
    private JPopupMenu polyMenu;
    private JDPolyline editedPolyline;
    private int zoomFactor = 0;
    private double autoZoomFactor = 1.0;
    private boolean autoZoom = false;
    private int sizeX;
    private int sizeY;
    private String lastFileName = "";
    private boolean needToSave = false;
    Vector listeners;
    private int mode;
    private int transx;
    private int transy;
    private JDObject pressedObject = null;
    private JDObject motionObject = null;
    private boolean alignToGrid = false;
    private int GRID_SIZE = 16;
    private boolean gridVisible = false;
    private String creationParam = null;
    boolean resizeLabelOnFontChange = true;
    boolean resizeLabelOnTextChange = true;
    private JDSlider sliderRef;
    private JDPolyline connectPolyline;
    private JLabel statusLabel = null;
    private String currentStatus = "";
    private JSeparator sep1;
    private JSeparator sep2;
    private JSeparator sep3;
    private JSeparator sep4;
    private JSeparator sep5;
    private JMenuItem infoMenuItem;
    private JMenuItem cutMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem pasteMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenuItem zoomInMenuItem;
    private JMenuItem zoomOutMenuItem;
    private JMenuItem groupMenuItem;
    private JMenuItem ungroupMenuItem;
    private JMenuItem editShapeMenuItem;
    private JMenuItem connectShapeMenuItem;
    private JMenuItem raiseMenuItem;
    private JMenuItem lowerMenuItem;
    private JMenuItem frontMenuItem;
    private JMenuItem backMenuItem;
    private JMenuItem infoPolyMenuItem;
    private JMenuItem delSummitMenuItem;
    private JMenuItem brkShapeMenuItem;
    private JMenuItem set0ShapeMenuItem;
    private JMenuItem reorderShapeMenuItem;
    private JMenuItem cancelShapeMenuItem;
    private static Cursor hCursor = Cursor.getPredefinedCursor(10);
    private static Cursor vCursor = Cursor.getPredefinedCursor(8);
    private static Cursor nwCursor = Cursor.getPredefinedCursor(6);
    private static Cursor neCursor = Cursor.getPredefinedCursor(7);
    private static Cursor seCursor = Cursor.getPredefinedCursor(5);
    private static Cursor swCursor = Cursor.getPredefinedCursor(4);
    private static Cursor bCursor = Cursor.getPredefinedCursor(13);
    private static Cursor dCursor = Cursor.getPredefinedCursor(0);
    static final Color defaultBackground = new Color(230, 230, 230);

    public JDrawEditor(int n) {
        this.setLayout(null);
        this.mode = n;
        this.initComponents();
    }

    private void initComponents() {
        this.objects = new Vector();
        this.selObjects = new Vector();
        this.sizeX = 800;
        this.sizeY = 600;
        this.setBackground(defaultBackground);
        this.setOpaque(true);
        this.isDraggingSummit = false;
        this.isDraggingSummits = false;
        this.isDraggingObject = false;
        this.isDraggingSelection = false;
        this.hasMoved = false;
        this.selY2 = 0;
        this.selY1 = 0;
        this.selX2 = 0;
        this.selX1 = 0;
        this.creationMode = 0;
        this.transy = 0;
        this.transx = 0;
        this.listeners = new Vector();
        this.needToSave = false;
        this.editedPolyline = null;
        this.selSummits = new int[0];
        switch (this.mode) {
            case 1: {
                this.clipboard = new Vector();
                this.tmpPoints = new Vector();
                this.undo = new Vector();
                this.clearUndo();
                this.createContextualMenu();
                break;
            }
            case 2: {
                this.tmpPoints = new Vector();
                this.clipboard = new Vector();
                this.createContextualMenu();
                break;
            }
        }
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setGridVisible(boolean bl) {
        this.gridVisible = bl;
        this.repaint();
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setGridSize(int n) {
        if (n > 1) {
            this.GRID_SIZE = n;
            this.repaint();
        }
    }

    public int getGridSize() {
        return this.GRID_SIZE;
    }

    public void setAlignToGrid(boolean bl) {
        this.alignToGrid = bl;
    }

    public boolean isAlignToGrid() {
        return this.alignToGrid;
    }

    public int getMode() {
        return this.mode;
    }

    public void selectObject(JDObject jDObject) {
        if (jDObject != null && this.mode != 3) {
            if (!this.isSelected(jDObject)) {
                this.selObjects.add(jDObject);
            }
            this.repaint(jDObject.getRepaintRect());
        }
    }

    public void unselectObject(JDObject jDObject) {
        if (jDObject != null && this.mode != 3) {
            this.selObjects.remove(jDObject);
            this.repaint(jDObject.getRepaintRect());
        }
    }

    public boolean isSelected(JDObject jDObject) {
        if (this.mode == 3) {
            return false;
        }
        return this.selObjects.contains(jDObject);
    }

    public void selectObjects(JDObject[] jDObjectArray) {
        if (jDObjectArray.length > 0 && this.mode != 3 && this.selObjects.size() == 0) {
            for (int i = 0; i < jDObjectArray.length; ++i) {
                this.selObjects.add(jDObjectArray[i]);
            }
            this.repaint(this.buildRepaintRect(this.selObjects));
        }
    }

    public int getObjectNumber() {
        return this.objects.size();
    }

    public JDObject getObjectAt(int n) {
        return (JDObject)this.objects.get(n);
    }

    public Vector getObjects() {
        return this.objects;
    }

    public Vector getSelectedObjects() {
        return this.selObjects;
    }

    public Vector getClipboardObjects() {
        return this.clipboard;
    }

    void setClipboard(Vector vector) {
        this.clipboard.clear();
        this.clipboard.addAll(vector);
    }

    public void unselectAll() {
        this.unselectAll(true);
    }

    private void unselectAll(boolean bl) {
        if (this.mode == 3) {
            return;
        }
        this.repaint(this.buildRepaintRect(this.selObjects));
        this.selObjects.clear();
        this.editedPolyline = null;
        if (bl) {
            this.fireSelectionChange();
        }
    }

    public void selectAll() {
        this.selectAll(true);
    }

    public void selectNotVisible() {
        if (this.mode == 3) {
            return;
        }
        this.selObjects.clear();
        int n = this.objects.size();
        for (int i = 0; i < n; ++i) {
            JDObject jDObject = (JDObject)this.objects.get(i);
            if (jDObject.isVisible()) continue;
            this.selObjects.add(jDObject);
        }
        this.editedPolyline = null;
        this.repaint();
        this.fireSelectionChange();
    }

    private void selectAll(boolean bl) {
        if (this.mode == 3) {
            return;
        }
        this.selObjects.clear();
        this.selObjects.addAll(this.objects);
        this.editedPolyline = null;
        this.repaint(this.buildRepaintRect(this.objects));
        if (bl) {
            this.fireSelectionChange();
        }
    }

    public void create(int n) {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        this.initCreate(n);
    }

    public void create(int n, String string) {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        this.initCreate(n);
        this.creationParam = string;
    }

    void pickCursor(JDSlider jDSlider) {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (jDSlider == null) {
            return;
        }
        this.initCreate(14);
        this.sliderRef = jDSlider;
    }

    void pickPolyline() {
        JDObject jDObject;
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.selObjects.size() > 0 && (jDObject = (JDObject)this.selObjects.get(0)) instanceof JDPolyline) {
            this.initCreate(15);
            this.connectPolyline = (JDPolyline)jDObject;
        }
    }

    public int getSelectionLength() {
        if (this.mode == 3) {
            return 0;
        }
        return this.selObjects.size();
    }

    public int getClipboardLength() {
        if (this.mode == 3) {
            return 0;
        }
        if (this.mode == 4) {
            return 0;
        }
        return this.clipboard.size();
    }

    public void showPropertyWindow() {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        JDUtils.showPropertyDialog(this, this.selObjects);
    }

    public void showTransformWindow() {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        boolean bl = JDUtils.showTransformDialog(this, this.selObjects);
        if (bl) {
            this.setNeedToSave(true, "transform");
        }
    }

    public void showBrowserWindow() {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        boolean bl = JDUtils.showBrowserDialog(this, this.selObjects);
        if (bl) {
            this.setNeedToSave(true, "Property change");
        }
    }

    public void showGroupEditorWindow() {
        JDObject jDObject;
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.selObjects.size() == 1 && (jDObject = (JDObject)this.selObjects.get(0)) instanceof JDGroup) {
            boolean bl;
            if (this.mode == 1) {
                JDUtils.modified = false;
            }
            if (bl = JDUtils.showGroupEditorDialog(this, (JDGroup)jDObject)) {
                this.setNeedToSave(true, "Group edit");
            }
        }
    }

    public void generateJavaClasses(String string) throws IOException {
        String string2 = "Destination directory: " + string + "\n\n";
        for (int i = 0; i < this.selObjects.size(); ++i) {
            JDObject jDObject = (JDObject)this.selObjects.get(i);
            String string3 = string + "\\" + jDObject.getName() + ".java";
            FileWriter fileWriter = new FileWriter(string3);
            fileWriter.write("/* Class generated by JDraw */\n\n");
            fileWriter.write("import java.awt.*;\n\n");
            if (jDObject instanceof JDGroup) {
                ((JDGroup)jDObject).generateJavaClass(fileWriter);
                string2 = string2 + "   " + jDObject.getName() + ".java" + " : OK\n";
            } else {
                string2 = string2 + "   " + jDObject.getName() + ".java" + " : generation failed (Invalid object type)\n";
            }
            fileWriter.close();
        }
        JOptionPane.showMessageDialog(this, string2, "Message", 1);
    }

    public void showGroupJavaWindow() {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.selObjects.size() >= 1) {
            JFileChooser jFileChooser = new JFileChooser(".");
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setDialogTitle("Choose directory for java classes generation");
            if (jFileChooser.showSaveDialog(this) == 0) {
                try {
                    this.generateJavaClasses(jFileChooser.getSelectedFile().getAbsolutePath());
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this, "Error during java code generation.\n" + iOException.getMessage());
                }
            }
        }
    }

    void addObjectToClipboard(Vector vector) {
        this.clipboard.clear();
        for (int i = 0; i < vector.size(); ++i) {
            this.clipboard.add(((JDObject)vector.get(i)).copy(0, 0));
        }
        this.fireClipboardChange();
    }

    public void copySelection() {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.selObjects.size() == 0) {
            return;
        }
        this.addObjectToClipboard(this.selObjects);
    }

    public void pasteClipboard(int n, int n2) {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.clipboard.size() == 0) {
            return;
        }
        this.unselectAll(false);
        Point point = JDUtils.getTopLeftCorner(this.clipboard);
        int n3 = n - point.x;
        int n4 = n2 - point.y;
        if (this.alignToGrid) {
            n3 = (n3 + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
            n4 = (n4 + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
        }
        boolean bl = false;
        for (int i = 0; i < this.clipboard.size(); ++i) {
            JDObject jDObject = ((JDObject)this.clipboard.get(i)).copy(n3, n4);
            bl = jDObject instanceof JDSwingObject || bl;
            this.objects.add(jDObject);
            this.selObjects.add(jDObject);
        }
        this.setNeedToSave(true, "Paste");
        if (!bl) {
            this.repaint(this.buildRepaintRect(this.selObjects));
        } else {
            this.repaintLater();
        }
        this.fireSelectionChange();
    }

    public void scaleSelection(double d, double d2) {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        this.repaint(this.buildRepaintRect(this.selObjects));
        Point point = JDUtils.getCenter(this.selObjects);
        for (int i = 0; i < this.selObjects.size(); ++i) {
            ((JDObject)this.selObjects.get(i)).scale(point.x, point.y, d, d2);
        }
        this.setNeedToSave(true, "Scale");
        this.repaint(this.buildRepaintRect(this.selObjects));
    }

    public void cutSelection() {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.selObjects.size() == 0) {
            return;
        }
        this.clipboard.clear();
        this.objects.removeAll(this.selObjects);
        this.clipboard.addAll(this.selObjects);
        this.repaint(this.buildRepaintRect(this.selObjects));
        this.selObjects.clear();
        this.editedPolyline = null;
        this.setNeedToSave(true, "Cut");
        this.fireSelectionChange();
        this.fireClipboardChange();
    }

    public void deleteSelection() {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.selObjects.size() == 0) {
            return;
        }
        this.objects.removeAll(this.selObjects);
        this.repaint(this.buildRepaintRect(this.selObjects));
        this.selObjects.clear();
        this.editedPolyline = null;
        this.setNeedToSave(true, "Delete");
        this.fireSelectionChange();
    }

    public void showSaveDialog(String string) {
        File file;
        int n;
        int n2 = 0;
        JFileChooser jFileChooser = new JFileChooser(string);
        if (this.lastFileName.length() > 0) {
            jFileChooser.setSelectedFile(new File(this.lastFileName));
        }
        if ((n = jFileChooser.showSaveDialog(this)) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            if (file.exists()) {
                n2 = JOptionPane.showConfirmDialog(this, "Do you want to overwrite " + file.getName() + " ?", "Confirm overwrite", 0);
            }
            if (n2 == 0) {
                try {
                    this.saveFile(file.getAbsolutePath());
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, "Error during saving file.\n" + exception.getMessage());
                }
            }
        }
    }

    public void saveFile(String string) throws IOException {
        Object object;
        if (string.endsWith(".jlx")) {
            object = string.substring(0, string.lastIndexOf(46));
            if (JOptionPane.showConfirmDialog(this, "Cannot save to JLoox (.jlx) format , save to jdw format ?\n" + (String)object + ".jdw", "Save confirmation", 0) == 1) {
                return;
            }
            string = (String)object + ".jdw";
        }
        if (string.endsWith(".g")) {
            object = string.substring(0, string.lastIndexOf(46));
            if (JOptionPane.showConfirmDialog(this, "Cannot save to Loox (.g) format , save to jdw format ?\n" + (String)object + ".jdw", "Save confirmation", 0) == 1) {
                return;
            }
            string = (String)object + ".jdw";
        }
        object = new FileWriter(string);
        try {
            ((Writer)object).write("JDFile v11 {\n");
            ((Writer)object).write("  Global {\n");
            if (this.getBackground().getRGB() != defaultBackground.getRGB()) {
                ((Writer)object).write("background:" + this.getBackground().getRed() + "," + this.getBackground().getGreen() + "," + this.getBackground().getBlue());
            }
            ((Writer)object).write("  }\n");
            for (int i = 0; i < this.objects.size(); ++i) {
                ((JDObject)this.objects.get(i)).saveObject((FileWriter)object, 1);
            }
            ((Writer)object).write("}\n");
            ((OutputStreamWriter)object).close();
        }
        catch (IOException iOException) {
            ((OutputStreamWriter)object).close();
            throw iOException;
        }
        this.lastFileName = string;
        this.setNeedToSave(false, "Save");
    }

    public void instantSave(String string) {
        if (this.lastFileName.length() > 0) {
            try {
                this.saveFile(this.lastFileName);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Error during saving file.\n" + exception.getMessage());
            }
        } else {
            this.showSaveDialog(string);
        }
    }

    protected void loadFromStream(InputStreamReader inputStreamReader) throws IOException {
        Vector vector;
        Object var3_2 = null;
        if (this.mode != 3) {
            return;
        }
        JDFileLoader jDFileLoader = new JDFileLoader(inputStreamReader);
        try {
            vector = jDFileLoader.parseFile();
            inputStreamReader.close();
        }
        catch (IOException iOException) {
            inputStreamReader.close();
            throw iOException;
        }
        this.applyGlobalOption(jDFileLoader);
        this.clearObjects();
        this.editedPolyline = null;
        this.objects = vector;
        for (int i = 0; i < this.objects.size(); ++i) {
            ((JDObject)this.objects.get(i)).setParent(this);
        }
        this.initPlayer();
        this.computePreferredSize();
        this.repaintLater();
    }

    public void loadFile(String string) throws IOException {
        Vector vector;
        Object object;
        FileReader fileReader = new FileReader(string);
        if (string.endsWith(".jlx")) {
            object = new JLXFileLoader(fileReader);
            try {
                vector = ((JLXFileLoader)object).parseFile();
                fileReader.close();
            }
            catch (IOException iOException) {
                fileReader.close();
                throw iOException;
            }
        }
        if (string.endsWith(".g")) {
            object = new LXFileLoader(fileReader);
            try {
                vector = ((LXFileLoader)object).parseFile();
                fileReader.close();
            }
            catch (IOException iOException) {
                fileReader.close();
                throw iOException;
            }
        }
        object = new JDFileLoader(fileReader);
        try {
            vector = ((JDFileLoader)object).parseFile();
            fileReader.close();
        }
        catch (IOException iOException) {
            fileReader.close();
            throw iOException;
        }
        this.applyGlobalOption((JDFileLoader)object);
        this.clearObjects();
        this.editedPolyline = null;
        this.objects = vector;
        for (int i = 0; i < this.objects.size(); ++i) {
            ((JDObject)this.objects.get(i)).setParent(this);
        }
        this.lastFileName = string;
        if (this.mode != 3) {
            this.clearUndo();
            this.setNeedToSave(false, "Load");
            this.fireSelectionChange();
        } else {
            this.initPlayer();
        }
        this.computePreferredSize();
        this.repaintLater();
    }

    public void showOpenDialog(String string) {
        int n = 1;
        if (this.needToSave) {
            n = JOptionPane.showConfirmDialog(this, "Your changes will be lost , save before opening a new file ?", "Open confirmation", 1);
        }
        if (n == 0) {
            this.instantSave(".");
        }
        if (n == 0 || n == 1) {
            JFileChooser jFileChooser = new JFileChooser(string);
            if (this.lastFileName.length() > 0) {
                jFileChooser.setSelectedFile(new File(this.lastFileName));
            }
            JDFileFilter jDFileFilter = new JDFileFilter("JLoox vectorial draw", new String[]{"jlx"});
            jFileChooser.addChoosableFileFilter(jDFileFilter);
            JDFileFilter jDFileFilter2 = new JDFileFilter("Loox vectorial draw", new String[]{"g"});
            jFileChooser.addChoosableFileFilter(jDFileFilter2);
            JDFileFilter jDFileFilter3 = new JDFileFilter("JDraw graphics program", new String[]{"jdw"});
            jFileChooser.addChoosableFileFilter(jDFileFilter3);
            int n2 = jFileChooser.showOpenDialog(this);
            File file = jFileChooser.getSelectedFile();
            if (n2 == 0) {
                try {
                    this.loadFile(file.getAbsolutePath());
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this, "Error during reading file: " + file.getName() + "\n" + iOException.getMessage());
                }
            }
        }
    }

    public void frontSelection() {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        Vector<JDObject> vector = new Vector<JDObject>();
        for (int i = 0; i < this.objects.size(); ++i) {
            JDObject jDObject = (JDObject)this.objects.get(i);
            if (!this.isSelected(jDObject)) continue;
            vector.add(jDObject);
        }
        this.objects.removeAll(vector);
        this.objects.addAll(vector);
        this.setNeedToSave(true, "Bring to front");
        this.repaint(this.buildRepaintRect(this.selObjects));
    }

    public void backSelection() {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        Vector<JDObject> vector = new Vector<JDObject>();
        for (int i = 0; i < this.objects.size(); ++i) {
            JDObject jDObject = (JDObject)this.objects.get(i);
            if (!this.isSelected(jDObject)) continue;
            vector.add(jDObject);
        }
        this.objects.removeAll(vector);
        this.objects.addAll(0, vector);
        this.setNeedToSave(true, "Send to back");
        this.repaint(this.buildRepaintRect(this.selObjects));
    }

    public void groupSelection() {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        Vector<JDObject> vector = new Vector<JDObject>();
        for (int i = 0; i < this.objects.size(); ++i) {
            JDObject jDObject = (JDObject)this.objects.get(i);
            if (!this.isSelected(jDObject)) continue;
            vector.add(jDObject);
        }
        if (vector.size() > 0) {
            this.selObjects.clear();
            this.objects.removeAll(vector);
            JDGroup jDGroup = new JDGroup("JDGroup", vector);
            this.selObjects.add(jDGroup);
            this.objects.add(jDGroup);
            this.editedPolyline = null;
            this.fireSelectionChange();
            this.setNeedToSave(true, "Group");
            this.repaint(jDGroup.getRepaintRect());
        }
    }

    public void ungroupSelection() {
        JDObject jDObject;
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.selObjects.size() == 1 && (jDObject = (JDObject)this.selObjects.get(0)) instanceof JDGroup) {
            JDGroup jDGroup = (JDGroup)jDObject;
            this.repaint(jDGroup.getRepaintRect());
            int n = this.objects.indexOf(jDGroup);
            this.objects.remove(jDGroup);
            this.selObjects.clear();
            this.selObjects.addAll(jDGroup.getChildren());
            this.objects.addAll(n, jDGroup.getChildren());
            this.editedPolyline = null;
            this.fireSelectionChange();
            this.setNeedToSave(true, "Ungroup");
        }
    }

    public void zoomIn() {
        ++this.zoomFactor;
        this.invalidate();
        this.fireSizeChanged();
        this.focusZoomSelection();
    }

    public void zoomOut() {
        --this.zoomFactor;
        this.invalidate();
        this.fireSizeChanged();
        this.focusZoomSelection();
    }

    private void focusZoomSelection() {
        Container container;
        if (this.selObjects.size() > 0 && (container = this.getParent()) instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            Rectangle rectangle = this.buildRepaintRect(this.selObjects);
            Rectangle rectangle2 = new Rectangle(this.zbconvert(rectangle.x, this.transx), this.zbconvert(rectangle.y, this.transy), this.zbconvert(rectangle.width, 0), this.zbconvert(rectangle.height, 0));
            jViewport.validate();
            Dimension dimension = jViewport.getSize();
            Rectangle rectangle3 = new Rectangle(rectangle2.x - (dimension.width - rectangle2.width) / 2, rectangle2.y - (dimension.height - rectangle2.height) / 2, dimension.width, dimension.height);
            jViewport.setViewPosition(new Point(0, 0));
            jViewport.scrollRectToVisible(rectangle3);
        }
    }

    public int getZoomFactorPercent() {
        return this.zbconvert(100, 0);
    }

    public int getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(int n) {
        this.zoomFactor = n;
        this.invalidate();
        this.fireSizeChanged();
    }

    public void setAutoZoom(boolean bl) {
        this.autoZoom = bl;
        if (this.autoZoom) {
            this.addComponentListener(this);
        } else {
            this.removeComponentListener(this);
        }
    }

    public void setAutoZoomFactor(double d) {
        this.autoZoomFactor = d;
    }

    public boolean isAutoZoom() {
        return this.autoZoom;
    }

    public void translateSelection(int n, int n2) {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.selObjects.size() > 0 && (n != 0 || n2 != 0)) {
            Rectangle rectangle = this.buildRepaintRect(this.selObjects);
            this.repaint(rectangle);
            for (int i = 0; i < this.selObjects.size(); ++i) {
                ((JDObject)this.selObjects.get(i)).translate(n, n2);
            }
            rectangle.translate(n, n2);
            this.repaint(rectangle);
            if (this.isDraggingObject) {
                this.hasMoved = true;
            }
        }
    }

    public boolean canUndo() {
        return this.mode == 1 && this.undoPos >= 2;
    }

    public boolean canRedo() {
        return this.mode == 1 && this.undoPos < this.undo.size();
    }

    public String getLastActionName() {
        if (this.canUndo()) {
            return ((UndoBuffer)this.undo.get(this.undoPos - 1)).getName();
        }
        return "";
    }

    public String getNextActionName() {
        if (this.canRedo()) {
            return ((UndoBuffer)this.undo.get(this.undoPos)).getName();
        }
        return "";
    }

    public void undo() {
        if (this.canUndo()) {
            --this.undoPos;
            this.rebuildBackup(this.undoPos - 1);
        }
    }

    public void redo() {
        if (this.canRedo()) {
            ++this.undoPos;
            this.rebuildBackup(this.undoPos - 1);
        }
    }

    public void clearUndo() {
        if (this.mode == 1) {
            this.undo.clear();
            this.undo.add(new UndoBuffer(this.objects, "Init"));
            this.undoPos = 1;
        }
    }

    public void aligntopSelection() {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.selObjects.size() == 0) {
            return;
        }
        this.repaint(this.buildRepaintRect(this.selObjects));
        JDObject jDObject = (JDObject)this.selObjects.get(0);
        int n = jDObject.getBoundRect().y;
        for (int i = 0; i < this.selObjects.size(); ++i) {
            JDObject jDObject2 = (JDObject)this.selObjects.get(i);
            double d = jDObject2.boundRect.y;
            jDObject2.translate(0.0, (double)n - d);
        }
        this.setNeedToSave(true, "Align");
        this.repaint(this.buildRepaintRect(this.selObjects));
    }

    public void alignleftSelection() {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.selObjects.size() == 0) {
            return;
        }
        this.repaint(this.buildRepaintRect(this.selObjects));
        JDObject jDObject = (JDObject)this.selObjects.get(0);
        int n = jDObject.getBoundRect().x;
        for (int i = 0; i < this.selObjects.size(); ++i) {
            JDObject jDObject2 = (JDObject)this.selObjects.get(i);
            double d = jDObject2.boundRect.x;
            jDObject2.translate((double)n - d, 0.0);
        }
        this.setNeedToSave(true, "Align");
        this.repaint(this.buildRepaintRect(this.selObjects));
    }

    public void alignbottomSelection() {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.selObjects.size() == 0) {
            return;
        }
        this.repaint(this.buildRepaintRect(this.selObjects));
        JDObject jDObject = (JDObject)this.selObjects.get(0);
        int n = jDObject.getBoundRect().y + jDObject.getBoundRect().height;
        for (int i = 0; i < this.selObjects.size(); ++i) {
            JDObject jDObject2 = (JDObject)this.selObjects.get(i);
            double d = jDObject2.boundRect.y + jDObject2.boundRect.height;
            jDObject2.translate(0.0, (double)n - d);
        }
        this.setNeedToSave(true, "Align");
        this.repaint(this.buildRepaintRect(this.selObjects));
    }

    public void alignrightSelection() {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.selObjects.size() == 0) {
            return;
        }
        this.repaint(this.buildRepaintRect(this.selObjects));
        JDObject jDObject = (JDObject)this.selObjects.get(0);
        int n = jDObject.getBoundRect().x + jDObject.getBoundRect().width;
        for (int i = 0; i < this.selObjects.size(); ++i) {
            JDObject jDObject2 = (JDObject)this.selObjects.get(i);
            double d = jDObject2.boundRect.x + jDObject2.boundRect.width;
            jDObject2.translate((double)n - d, 0.0);
        }
        this.setNeedToSave(true, "Align");
        this.repaint(this.buildRepaintRect(this.selObjects));
    }

    public void addEditorListener(JDrawEditorListener jDrawEditorListener) {
        this.listeners.add(jDrawEditorListener);
    }

    public void removeEditorListener(JDrawEditorListener jDrawEditorListener) {
        this.listeners.remove(jDrawEditorListener);
    }

    public void clearEditorListener() {
        this.listeners.clear();
    }

    public boolean getNeedToSaveState() {
        return this.needToSave;
    }

    public String getFileName() {
        return this.lastFileName;
    }

    public void addObject(JDObject jDObject) {
        this.objects.add(jDObject);
        jDObject.setParent(this);
    }

    public void clearObjects() {
        this.objects.clear();
        if (this.mode == 3) {
            return;
        }
        this.selObjects.clear();
    }

    public void setTranslation(int n, int n2) {
        this.transx = n;
        this.transy = n2;
    }

    public void computePreferredSize() {
        Dimension dimension = new Dimension();
        Rectangle rectangle = null;
        for (int i = 0; i < this.objects.size(); ++i) {
            rectangle = rectangle == null ? this.getObjectAt(i).getBoundRect() : rectangle.union(this.getObjectAt(i).getBoundRect());
        }
        if (rectangle == null) {
            dimension.width = 320;
            dimension.height = 200;
        } else {
            dimension.width = rectangle.x + rectangle.width + 1;
            dimension.height = rectangle.y + rectangle.height + 1;
        }
        this.setPreferredSize(dimension);
        this.fireSizeChanged();
    }

    public void setPreferredSize(Dimension dimension) {
        this.sizeX = dimension.width;
        this.sizeY = dimension.height;
    }

    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        int n = insets.right + insets.left;
        int n2 = insets.bottom + insets.top;
        return new Dimension(this.zbconvert(this.sizeX, 0) + n, this.zbconvert(this.sizeY, 0) + n2);
    }

    public Dimension getMinimumSize() {
        Container container = this.getParent();
        if (container instanceof JSplitPane) {
            return new Dimension(16, 16);
        }
        return this.getPreferredSize();
    }

    public void initPlayer() {
        if (this.mode != 3) {
            return;
        }
        for (int i = 0; i < this.objects.size(); ++i) {
            this.getObjectAt(i).saveTransform();
            this.getObjectAt(i).initValue();
        }
        this.removeAll();
        Vector vector = this.getObjectsOfClass(JDSwingObject.class);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            this.add(((JDSwingObject)vector.get(n - i - 1)).getComponent());
        }
    }

    public Vector getObjectsOfClass(Class clazz) {
        Vector vector = new Vector();
        for (int i = 0; i < this.objects.size(); ++i) {
            ((JDObject)this.objects.get(i)).getObjectsByClassList(vector, clazz);
        }
        return vector;
    }

    public Vector getObjectsByName(String string, boolean bl) {
        Vector vector = new Vector();
        for (int i = 0; i < this.objects.size(); ++i) {
            ((JDObject)this.objects.get(i)).getObjectsByName(vector, string, bl);
        }
        return vector;
    }

    public void convertToPolyline() {
        for (int i = 0; i < this.selObjects.size(); ++i) {
            JDObject jDObject = (JDObject)this.selObjects.get(i);
            if (jDObject instanceof JDPolyConvert) {
                JDPolyline jDPolyline = ((JDPolyConvert)((Object)jDObject)).convertToPolyline();
                int n = this.objects.indexOf(jDObject);
                this.objects.remove(n);
                this.selObjects.clear();
                this.objects.add(n, jDPolyline);
                this.selObjects.add(jDPolyline);
                this.repaint(jDObject.getRepaintRect());
                this.repaint(jDPolyline.getRepaintRect());
            }
            this.setNeedToSave(true, "Convert to polyline");
        }
    }

    boolean canConvertToPolyline() {
        boolean bl = this.selObjects.size() > 0;
        for (int i = 0; i < this.selObjects.size(); ++i) {
            bl = bl && this.selObjects.get(i) instanceof JDPolyConvert;
        }
        return bl;
    }

    boolean canEditGroup() {
        return this.selObjects.size() == 1 && this.selObjects.get(0) instanceof JDGroup;
    }

    public void raiseObject() {
        JDObject jDObject;
        int n;
        if (this.selObjects.size() == 1 && (n = this.objects.indexOf(jDObject = (JDObject)this.selObjects.get(0))) < this.objects.size() - 1) {
            this.objects.remove(n);
            this.objects.add(n + 1, jDObject);
            this.setNeedToSave(true, "Raise");
            this.repaint(jDObject.getRepaintRect());
        }
    }

    public void lowerObject() {
        JDObject jDObject;
        int n;
        if (this.selObjects.size() == 1 && (n = this.objects.indexOf(jDObject = (JDObject)this.selObjects.get(0))) > 0) {
            this.objects.remove(n);
            this.objects.add(n - 1, jDObject);
            this.setNeedToSave(true, "Lower");
            this.repaint(jDObject.getRepaintRect());
        }
    }

    public Vector getInteractiveObjects() {
        Vector vector = new Vector();
        for (int i = 0; i < this.objects.size(); ++i) {
            ((JDObject)this.objects.get(i)).getUserValueList(vector);
        }
        return vector;
    }

    public void setStatusLabel(JLabel jLabel) {
        this.statusLabel = jLabel;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        int n = this.alignToGrid ? this.GRID_SIZE : 1;
        switch (keyEvent.getKeyCode()) {
            case 38: {
                if (this.editedPolyline != null) {
                    Rectangle rectangle = this.editedPolyline.getRepaintRect();
                    this.editedPolyline.translateSummits(this.selSummits, 0.0, -n);
                    this.repaint(rectangle.union(this.editedPolyline.getRepaintRect()));
                    this.setNeedToSave(true, "Shape edit");
                } else {
                    this.translateSelection(0, -n);
                    this.setNeedToSave(true, "Translate");
                }
                keyEvent.consume();
                break;
            }
            case 40: {
                if (this.editedPolyline != null) {
                    Rectangle rectangle = this.editedPolyline.getRepaintRect();
                    this.editedPolyline.translateSummits(this.selSummits, 0.0, n);
                    this.repaint(rectangle.union(this.editedPolyline.getRepaintRect()));
                    this.setNeedToSave(true, "Shape edit");
                } else {
                    this.translateSelection(0, n);
                    this.setNeedToSave(true, "Translate");
                }
                keyEvent.consume();
                break;
            }
            case 37: {
                if (this.editedPolyline != null) {
                    Rectangle rectangle = this.editedPolyline.getRepaintRect();
                    this.editedPolyline.translateSummits(this.selSummits, -n, 0.0);
                    this.repaint(rectangle.union(this.editedPolyline.getRepaintRect()));
                    this.setNeedToSave(true, "Shape edit");
                } else {
                    this.translateSelection(-n, 0);
                    this.setNeedToSave(true, "Translate");
                }
                keyEvent.consume();
                break;
            }
            case 39: {
                if (this.editedPolyline != null) {
                    Rectangle rectangle = this.editedPolyline.getRepaintRect();
                    this.editedPolyline.translateSummits(this.selSummits, n, 0.0);
                    this.repaint(rectangle.union(this.editedPolyline.getRepaintRect()));
                    this.setNeedToSave(true, "Shape edit");
                } else {
                    this.translateSelection(n, 0);
                    this.setNeedToSave(true, "Translate");
                }
                keyEvent.consume();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.mode == 3) {
            this.relayPlayerMouseMoveEvent(mouseEvent);
            this.mouseDraggedPlayer(mouseEvent);
        } else {
            this.mouseDraggedEditor(mouseEvent);
        }
    }

    private void mouseDraggedPlayer(MouseEvent mouseEvent) {
        int n = this.zconvert(mouseEvent.getX(), this.transx);
        int n2 = this.zconvert(mouseEvent.getY(), this.transy);
        if (this.selObjects.size() > 0) {
            this.repaint(this.buildRepaintRect(this.selObjects));
            for (int i = 0; i < this.selObjects.size(); ++i) {
                ((JDObject)this.selObjects.get(i)).processValue(3, n, n2);
            }
            this.repaint(this.buildRepaintRect(this.selObjects));
        }
    }

    private void mouseDraggedEditor(MouseEvent mouseEvent) {
        Object object;
        int n = this.zconvert(mouseEvent.getX(), this.transx);
        int n2 = this.zconvert(mouseEvent.getY(), this.transy);
        if (this.isDraggingSelection) {
            Rectangle rectangle = this.buildSelectionRect();
            this.selX2 = n;
            this.selY2 = n2;
            this.repaint(rectangle.union(this.buildSelectionRect()));
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.isDraggingSummits) {
            if (this.alignToGrid) {
                n = (n + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
                n2 = (n2 + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
            }
            object = this.editedPolyline.getRepaintRect();
            this.editedPolyline.translateSummits(this.selSummits, n - this.lastX, n2 - this.lastY);
            this.repaint(((Rectangle)object).union(this.editedPolyline.getRepaintRect()));
            this.hasMoved = true;
            this.lastX = n;
            this.lastY = n2;
        }
        if (this.isDraggingSummit) {
            if (this.alignToGrid) {
                n = (n + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
                n2 = (n2 + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
            }
            object = (JDObject)this.selObjects.get(this.curObject);
            Rectangle rectangle = ((JDObject)object).getRepaintRect();
            switch (((JDObject)object).getSummitMotion(this.selSummit)) {
                case 3: {
                    ((JDObject)object).moveSummit(this.selSummit, n, n2);
                    break;
                }
                case 1: {
                    ((JDObject)object).moveSummit(this.selSummit, n, ((JDObject)object).getSummit((int)this.selSummit).y);
                    break;
                }
                case 2: {
                    ((JDObject)object).moveSummit(this.selSummit, ((JDObject)object).getSummit((int)this.selSummit).x, n2);
                }
            }
            this.addStatus("[" + Integer.toString(this.selSummit) + " @" + Integer.toString(n) + "," + Integer.toString(n2) + " " + " (" + Integer.toString(((JDObject)object).getBoundRect().width - 1) + "," + Integer.toString(((JDObject)object).getBoundRect().height - 1) + ")]");
            this.hasMoved = true;
            this.repaint(rectangle.union(((JDObject)object).getRepaintRect()));
        }
        if (this.isDraggingObject) {
            if (this.alignToGrid) {
                n = (n + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
                n2 = (n2 + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
            }
            this.translateSelection(n - this.lastX, n2 - this.lastY);
            this.lastX = n;
            this.lastY = n2;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.mode == 4) {
            return;
        }
        if (this.mode == 3) {
            this.relayPlayerMouseMoveEvent(mouseEvent);
            return;
        }
        int n = this.zconvert(mouseEvent.getX(), this.transx);
        int n2 = this.zconvert(mouseEvent.getY(), this.transy);
        if ((this.creationMode == 4 || this.creationMode == 6) && this.tmpPoints.size() > 0) {
            if (this.alignToGrid) {
                n = (n + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
                n2 = (n2 + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
            }
            int n3 = this.tmpPoints.size();
            Rectangle rectangle = this.buildRectFromLine((Point)this.tmpPoints.get(n3 - 2), (Point)this.tmpPoints.get(n3 - 1));
            ((Point)this.tmpPoints.get((int)(n3 - 1))).x = n;
            ((Point)this.tmpPoints.get((int)(n3 - 1))).y = n2;
            this.repaint(rectangle.union(this.buildRectFromLine((Point)this.tmpPoints.get(n3 - 2), (Point)this.tmpPoints.get(n3 - 1))));
            return;
        }
        if (!(this.isDraggingSummit || this.isDraggingObject || this.isDraggingSelection || this.isDraggingSummits)) {
            this.findSummit(n, n2);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mode == 3 && this.motionObject != null) {
            this.motionObject.fireMouseEvent(505, mouseEvent);
            this.motionObject = null;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        int n = this.zconvert(mouseEvent.getX(), this.transx);
        int n2 = this.zconvert(mouseEvent.getY(), this.transy);
        if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
            boolean bl = false;
            int n3 = this.selObjects.size() - 1;
            while (!bl && n3 >= 0) {
                bl = ((JDObject)this.selObjects.get(n3)).isInsideObject(n, n2);
                if (bl) continue;
                --n3;
            }
            if (bl) {
                this.showPropertyWindow();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mode == 3) {
            this.relayPlayerMouseReleasedEvent(mouseEvent);
            this.mouseReleasedPlayer(mouseEvent);
        } else {
            this.mouseReleasedEditor(mouseEvent);
        }
    }

    private void mouseReleasedPlayer(MouseEvent mouseEvent) {
        int n = this.zconvert(mouseEvent.getX(), this.transx);
        int n2 = this.zconvert(mouseEvent.getY(), this.transy);
        if (this.selObjects.size() > 0) {
            this.repaint(this.buildRepaintRect(this.selObjects));
            for (int i = 0; i < this.selObjects.size(); ++i) {
                ((JDObject)this.selObjects.get(i)).processValue(2, n, n2);
            }
            this.repaint(this.buildRepaintRect(this.selObjects));
            this.selObjects.clear();
        }
    }

    private void mouseReleasedEditor(MouseEvent mouseEvent) {
        if ((this.isDraggingSummits || this.isDraggingSummit || this.isDraggingObject) && this.hasMoved) {
            if (this.isDraggingSummit) {
                if (this.lastCreatedObject == null) {
                    this.setNeedToSave(true, "Shape edit");
                    this.setStatus("");
                } else {
                    this.setNeedToSave(true, "Object creation");
                    this.fireCreationDone();
                    this.lastCreatedObject.centerOrigin();
                    this.lastCreatedObject = null;
                }
            }
            if (this.isDraggingObject) {
                this.setNeedToSave(true, "Translate");
                this.repaint(this.buildRepaintRect(this.selObjects));
            }
            if (this.isDraggingSummits) {
                this.setNeedToSave(true, "Shape edit");
                this.repaint(this.buildRepaintRect(this.selObjects));
            }
        }
        this.isDraggingSummit = false;
        this.isDraggingSummits = false;
        this.isDraggingObject = false;
        this.hasMoved = false;
        if (this.isDraggingSelection) {
            this.isDraggingSelection = false;
            Rectangle rectangle = this.buildSelectionRect();
            Rectangle rectangle2 = null;
            this.selY2 = 0;
            this.selY1 = 0;
            this.selX2 = 0;
            this.selX1 = 0;
            if (this.editedPolyline != null) {
                int[] nArray = this.editedPolyline.getSummitsInsideRectangle(rectangle);
                for (int i = 0; i < nArray.length; ++i) {
                    this.selectSummit(nArray[i]);
                }
            } else {
                for (int i = 0; i < this.objects.size(); ++i) {
                    JDObject jDObject = (JDObject)this.objects.get(i);
                    if (!jDObject.isVisible() || !rectangle.contains(jDObject.getBoundRect())) continue;
                    if (!this.isSelected(jDObject)) {
                        this.selObjects.add(jDObject);
                    } else if (mouseEvent.isControlDown()) {
                        this.selObjects.remove(jDObject);
                    }
                    rectangle2 = rectangle2 == null ? jDObject.getRepaintRect() : rectangle2.union(jDObject.getRepaintRect());
                }
                this.fireSelectionChange();
            }
            if (rectangle2 != null) {
                this.repaint(rectangle.union(rectangle2));
            } else {
                this.repaint(rectangle);
            }
        }
        this.setCursor(dCursor);
    }

    public void mousePressedEditorB1(MouseEvent mouseEvent) {
        int n = this.zconvert(mouseEvent.getX(), this.transx);
        int n2 = this.zconvert(mouseEvent.getY(), this.transy);
        if (this.editedPolyline != null) {
            this.findSummit(n, n2);
            if (this.selSummit == -1) {
                if (!mouseEvent.isControlDown()) {
                    this.selSummits = new int[0];
                    this.repaint(this.editedPolyline.getRepaintRect());
                }
                this.selX1 = n;
                this.selY1 = n2;
                this.selX2 = n;
                this.selY2 = n2;
                this.isDraggingSelection = true;
            } else {
                if (this.alignToGrid) {
                    n = (n + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
                    n2 = (n2 + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
                }
                this.lastX = n;
                this.lastY = n2;
                if (this.isSelectedSummit(this.selSummit)) {
                    this.isDraggingSummits = true;
                } else {
                    if (mouseEvent.isControlDown()) {
                        this.selectSummit(this.selSummit);
                    } else {
                        this.selSummits = new int[1];
                        this.selSummits[0] = this.selSummit;
                        this.isDraggingSummits = true;
                    }
                    this.repaint(this.editedPolyline.getRepaintRect());
                }
            }
            return;
        }
        if (this.createObject(n, n2)) {
            return;
        }
        if (this.mode != 4 && this.findSummit(n, n2)) {
            this.isDraggingSummit = true;
            return;
        }
        JDObject jDObject = this.findObject(n, n2);
        if (jDObject != null) {
            if (!this.isSelected(jDObject)) {
                if (!mouseEvent.isControlDown()) {
                    this.unselectAll(false);
                }
                this.selObjects.add(jDObject);
                this.repaint(jDObject.getRepaintRect());
                this.fireSelectionChange();
            } else if (mouseEvent.isControlDown()) {
                this.selObjects.remove(jDObject);
                this.repaint(jDObject.getRepaintRect());
                this.fireSelectionChange();
                return;
            }
            if (this.mode != 4) {
                this.curObject = this.selObjects.indexOf(jDObject);
                this.isDraggingObject = true;
                if (this.alignToGrid) {
                    n = (n + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
                    n2 = (n2 + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
                }
                this.lastX = n;
                this.lastY = n2;
                this.setCursor(bCursor);
            }
        } else {
            if (!mouseEvent.isControlDown()) {
                this.unselectAll();
            }
            this.selX1 = n;
            this.selY1 = n2;
            this.selX2 = n;
            this.selY2 = n2;
            this.isDraggingSelection = true;
        }
    }

    public void mousePressedEditorB3(MouseEvent mouseEvent) {
        if (this.creationMode == 0) {
            this.showMenu(mouseEvent);
        }
        if (this.creationMode == 4) {
            if (this.tmpPoints.size() != 0) {
                int n = this.tmpPoints.size();
                Point[] pointArray = new Point[n];
                for (int i = 0; i < n; ++i) {
                    pointArray[i] = (Point)this.tmpPoints.get(i);
                }
                JDPolyline jDPolyline = new JDPolyline("Polyline", pointArray);
                this.selObjects.add(jDPolyline);
                this.objects.add(jDPolyline);
                this.repaint(jDPolyline.getRepaintRect());
                this.fireCreationDone();
                this.fireSelectionChange();
                this.setNeedToSave(true, "Object creation");
            } else {
                this.fireCreationDone();
            }
            this.tmpPoints.clear();
            this.creationMode = 0;
            return;
        }
        if (this.creationMode == 6) {
            int n = this.tmpPoints.size();
            if ((n = (n - 1) / 3 * 3 + 1) >= 4) {
                Point[] pointArray = new Point[n];
                for (int i = 0; i < n; ++i) {
                    pointArray[i] = (Point)this.tmpPoints.get(i);
                }
                JDSpline jDSpline = new JDSpline("Spline", pointArray);
                this.selObjects.add(jDSpline);
                this.objects.add(jDSpline);
                this.repaint(jDSpline.getRepaintRect());
                this.fireCreationDone();
                this.fireSelectionChange();
                this.setNeedToSave(true, "Object creation");
            } else {
                this.fireCreationDone();
                this.repaint();
            }
            this.tmpPoints.clear();
            this.creationMode = 0;
            return;
        }
        if (this.creationMode != 0) {
            this.tmpPoints.clear();
            this.creationMode = 0;
            this.fireCreationDone();
            this.repaint();
            return;
        }
        this.showMenu(mouseEvent);
    }

    public void mousePressedPlayerB1(MouseEvent mouseEvent) {
        int n = this.zconvert(mouseEvent.getX(), this.transx);
        int n2 = this.zconvert(mouseEvent.getY(), this.transy);
        this.selObjects.clear();
        this.selectObjects(n, n2, this.selObjects);
        if (this.selObjects.size() > 0) {
            this.repaint(this.buildRepaintRect(this.selObjects));
            for (int i = 0; i < this.selObjects.size(); ++i) {
                ((JDObject)this.selObjects.get(i)).processValue(1, n, n2);
            }
            this.repaint(this.buildRepaintRect(this.selObjects));
        }
    }

    public void mousePressedPlayerB3(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.grabFocus();
        if (this.mode == 3) {
            this.relayPlayerMousePressedEvent(mouseEvent);
            if (mouseEvent.getButton() == 1) {
                this.mousePressedPlayerB1(mouseEvent);
            }
            if (mouseEvent.getButton() == 3) {
                this.mousePressedPlayerB3(mouseEvent);
            }
        } else {
            if (mouseEvent.getButton() == 1) {
                this.mousePressedEditorB1(mouseEvent);
            }
            if (mouseEvent.getButton() == 3) {
                this.mousePressedEditorB3(mouseEvent);
            }
        }
    }

    private void relayPlayerMouseReleasedEvent(MouseEvent mouseEvent) {
        int n = this.zconvert(mouseEvent.getX(), this.transx);
        int n2 = this.zconvert(mouseEvent.getY(), this.transy);
        if (this.pressedObject != null) {
            if (this.pressedObject.isInsideObject(n, n2)) {
                this.pressedObject.fireMouseEvent(502, mouseEvent);
                this.pressedObject.fireMouseEvent(500, mouseEvent);
            }
            this.pressedObject = null;
        }
    }

    private void relayPlayerMousePressedEvent(MouseEvent mouseEvent) {
        int n = this.zconvert(mouseEvent.getX(), this.transx);
        int n2 = this.zconvert(mouseEvent.getY(), this.transy);
        this.pressedObject = this.findMouseListenerObject(n, n2);
        if (this.pressedObject != null) {
            this.pressedObject.fireMouseEvent(501, mouseEvent);
        }
    }

    private void relayPlayerMouseMoveEvent(MouseEvent mouseEvent) {
        int n = this.zconvert(mouseEvent.getX(), this.transx);
        int n2 = this.zconvert(mouseEvent.getY(), this.transy);
        JDObject jDObject = this.findMouseListenerObject(n, n2);
        if (this.motionObject == null) {
            if (jDObject != null) {
                this.motionObject = jDObject;
                this.motionObject.fireMouseEvent(504, mouseEvent);
            }
        } else if (jDObject == null) {
            this.motionObject.fireMouseEvent(505, mouseEvent);
            this.motionObject = null;
        } else if (jDObject != this.motionObject) {
            this.motionObject.fireMouseEvent(505, mouseEvent);
            this.motionObject = jDObject;
            this.motionObject.fireMouseEvent(504, mouseEvent);
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.autoZoom && this.mode == 3) {
            Dimension dimension = this.getSize();
            double d = (double)dimension.width / (double)this.sizeX;
            double d2 = (double)dimension.height / (double)this.sizeY;
            this.autoZoomFactor = d > d2 ? d2 : d;
            if (this.autoZoomFactor < 0.1) {
                this.autoZoomFactor = 0.1;
            }
            Vector vector = this.getObjectsOfClass(JDSwingObject.class);
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                JDSwingObject jDSwingObject = (JDSwingObject)vector.get(i);
                Rectangle rectangle = new Rectangle(jDSwingObject.getBoundRect());
                rectangle.x = (int)Math.rint((double)rectangle.x * this.autoZoomFactor);
                rectangle.y = (int)Math.rint((double)rectangle.y * this.autoZoomFactor);
                rectangle.width = (int)Math.rint((double)rectangle.width * this.autoZoomFactor);
                rectangle.height = (int)Math.rint((double)rectangle.height * this.autoZoomFactor);
                jDSwingObject.getComponent().setBounds(rectangle);
                jDSwingObject.getComponent().validate();
            }
            this.repaint();
        }
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        Object object = actionEvent.getSource();
        Rectangle rectangle = null;
        if (object == this.delSummitMenuItem) {
            rectangle = this.editedPolyline.getRepaintRect();
            this.editedPolyline.deleteSummit();
            this.selSummits = new int[0];
            this.setNeedToSave(true, "Delete polyline point");
            this.repaint(rectangle.union(this.editedPolyline.getRepaintRect()));
        } else if (object == this.brkShapeMenuItem) {
            rectangle = this.editedPolyline.getRepaintRect();
            this.setNeedToSave(true, "Add polyline point");
            this.editedPolyline.breakShape();
            this.selSummits = new int[0];
            this.repaint(rectangle.union(this.editedPolyline.getRepaintRect()));
        } else if (object == this.set0ShapeMenuItem) {
            rectangle = this.editedPolyline.getRepaintRect();
            this.setNeedToSave(true, "Set starting point");
            this.editedPolyline.setStartingPoint(this.selSummit);
            this.selSummits = new int[0];
            this.repaint(rectangle.union(this.editedPolyline.getRepaintRect()));
        } else if (object == this.reorderShapeMenuItem) {
            rectangle = this.editedPolyline.getRepaintRect();
            this.setNeedToSave(true, "Reorder polyline");
            this.editedPolyline.invertSummitOrder();
            this.selSummits = new int[0];
            this.repaint(rectangle.union(this.editedPolyline.getRepaintRect()));
        } else if (object == this.copyMenuItem) {
            this.copySelection();
        } else if (object == this.pasteMenuItem) {
            this.pasteClipboard(this.lastX, this.lastY);
        } else if (object == this.cutMenuItem) {
            this.cutSelection();
        } else if (object == this.deleteMenuItem) {
            this.deleteSelection();
        } else if (object == this.raiseMenuItem) {
            this.raiseObject();
        } else if (object == this.lowerMenuItem) {
            this.lowerObject();
        } else if (object == this.frontMenuItem) {
            this.frontSelection();
        } else if (object == this.backMenuItem) {
            this.backSelection();
        } else if (object == this.groupMenuItem) {
            this.groupSelection();
        } else if (object == this.ungroupMenuItem) {
            this.ungroupSelection();
        } else if (object == this.zoomInMenuItem) {
            this.zoomIn();
        } else if (object == this.zoomOutMenuItem) {
            this.zoomOut();
        } else if (object == this.editShapeMenuItem) {
            if (this.selObjects.size() > 0) {
                this.selSummits = new int[0];
                this.editedPolyline = (JDPolyline)this.selObjects.get(0);
                this.repaint(this.editedPolyline.getRepaintRect());
            }
        } else if (object == this.connectShapeMenuItem) {
            this.pickPolyline();
        } else if (object == this.cancelShapeMenuItem) {
            rectangle = this.editedPolyline.getRepaintRect();
            this.editedPolyline = null;
            this.repaint(rectangle);
        }
    }

    public void paintObjects(Graphics graphics) {
        for (int i = 0; i < this.objects.size(); ++i) {
            ((JDObject)this.objects.get(i)).paint(this, graphics);
        }
    }

    public void paintSelection(Graphics graphics) {
        if (this.mode != 3) {
            int n;
            if (!this.isDraggingObject || !this.hasMoved) {
                for (n = 0; n < this.selObjects.size(); ++n) {
                    ((JDObject)this.selObjects.get(n)).paintSummit(graphics, this.zdconvert(6.0, 0.0));
                }
            }
            if (this.editedPolyline != null) {
                this.editedPolyline.paintSelectedSummit(graphics, this.selSummits, this.zdconvert(6.0, 0.0));
            }
            if (this.selX1 != this.selX2 && this.selY1 != this.selY2) {
                graphics.setColor(Color.darkGray);
                graphics.drawLine(this.selX1, this.selY1, this.selX2, this.selY1);
                graphics.drawLine(this.selX2, this.selY1, this.selX2, this.selY2);
                graphics.drawLine(this.selX2, this.selY2, this.selX1, this.selY2);
                graphics.drawLine(this.selX1, this.selY2, this.selX1, this.selY1);
            }
            if (this.mode != 4) {
                for (n = 1; n < this.tmpPoints.size(); ++n) {
                    graphics.setColor(Color.darkGray);
                    Point point = (Point)this.tmpPoints.get(n - 1);
                    Point point2 = (Point)this.tmpPoints.get(n);
                    graphics.drawLine(point.x, point.y, point2.x, point2.y);
                }
            }
        }
    }

    private void paintGrid(Graphics graphics) {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.gridVisible) {
            Dimension dimension = this.getSize();
            double d = this.zbdconvert(this.GRID_SIZE, 0.0);
            int n = this.getBackground().getRed() < 128 ? this.getBackground().getRed() + 64 : this.getBackground().getRed() - 64;
            int n2 = this.getBackground().getGreen() < 128 ? this.getBackground().getGreen() + 64 : this.getBackground().getGreen() - 64;
            int n3 = this.getBackground().getBlue() < 128 ? this.getBackground().getBlue() + 64 : this.getBackground().getBlue() - 64;
            Color color = new Color(n, n2, n3);
            graphics.setColor(color);
            for (double d2 = 0.0; d2 <= (double)dimension.width; d2 += d) {
                for (double d3 = 0.0; d3 <= (double)dimension.height; d3 += d) {
                    int n4 = (int)(d2 + 0.5);
                    int n5 = (int)(d3 + 0.5);
                    graphics.drawLine(n4, n5, n4, n5);
                }
            }
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        this.paintGrid(graphics);
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = new AffineTransform(affineTransform);
        double d = this.getZoomScaleRatio();
        affineTransform2.scale(d, d);
        affineTransform2.translate(this.transx, this.transy);
        graphics2D.setTransform(affineTransform2);
        this.paintObjects(graphics);
        this.paintSelection(graphics);
        graphics2D.setTransform(affineTransform);
        boolean bl = this.isOpaque();
        this.setOpaque(false);
        super.paint(graphics);
        this.setOpaque(bl);
    }

    public void repaint(Rectangle rectangle) {
        if (rectangle != null) {
            int n = (int)(this.zdconvert(3.0, 0.0) + 0.5) + 1;
            Rectangle rectangle2 = new Rectangle(this.zbconvert(rectangle.x, this.transx) - n, this.zbconvert(rectangle.y, this.transy) - n, this.zbconvert(rectangle.width, 0) + 2 * n, this.zbconvert(rectangle.height, 0) + 2 * n);
            super.repaint(rectangle2);
        }
    }

    void setNeedToSave(boolean bl, String string) {
        this.needToSave = bl;
        if (this.needToSave && this.mode == 1) {
            for (int i = this.undo.size() - 1; i >= this.undoPos; --i) {
                this.undo.removeElementAt(i);
            }
            this.undo.add(new UndoBuffer(this.objects, string));
            if (this.undo.size() >= 20) {
                this.undo.removeElementAt(0);
            }
            this.undoPos = this.undo.size();
        }
        this.fireValueChanged();
    }

    private double getZoomScaleRatio() {
        if (this.autoZoom) {
            return this.autoZoomFactor;
        }
        double d = 1.0;
        if (this.zoomFactor != 0) {
            d = this.zoomFactor >= 0 ? (double)(this.zoomFactor + 1) : 1.0 / (double)(-this.zoomFactor + 1);
        }
        return d;
    }

    private int zconvert(int n, int n2) {
        if (this.autoZoom) {
            return (int)((double)n / this.autoZoomFactor) - n2;
        }
        if (this.zoomFactor == 0) {
            return n - n2;
        }
        if (this.zoomFactor > 0) {
            return (int)((double)n / (double)(this.zoomFactor + 1)) - n2;
        }
        return n * (-this.zoomFactor + 1) - n2;
    }

    private int zbconvert(int n, int n2) {
        if (this.autoZoom) {
            return (int)((double)(n + n2) * this.autoZoomFactor);
        }
        if (this.zoomFactor == 0) {
            return n + n2;
        }
        if (this.zoomFactor > 0) {
            return (n + n2) * (this.zoomFactor + 1);
        }
        return (int)((double)(n + n2) / (double)(-this.zoomFactor + 1));
    }

    private double zdconvert(double d, double d2) {
        if (this.autoZoom) {
            return (d - d2) / this.autoZoomFactor;
        }
        if (this.zoomFactor == 0) {
            return d - d2;
        }
        if (this.zoomFactor > 0) {
            return (d - d2) / (double)(this.zoomFactor + 1);
        }
        return (d - d2) * (double)(-this.zoomFactor + 1);
    }

    private double zbdconvert(double d, double d2) {
        if (this.autoZoom) {
            return (d + d2) * this.autoZoomFactor;
        }
        if (this.zoomFactor == 0) {
            return d + d2;
        }
        if (this.zoomFactor > 0) {
            return (d + d2) * (double)(this.zoomFactor + 1);
        }
        return (d + d2) / (double)(-this.zoomFactor + 1);
    }

    public void addToMenu(JMenuItem jMenuItem) {
        if (this.objMenu == null) {
            this.objMenu = new JPopupMenu();
            this.infoMenuItem = new JMenuItem();
            this.infoMenuItem.setEnabled(false);
            this.objMenu.add(this.infoMenuItem);
            this.sep1 = new JSeparator();
            this.objMenu.add(this.sep1);
        }
        if (jMenuItem != null) {
            this.objMenu.add(jMenuItem);
        }
    }

    private void showMenu(MouseEvent mouseEvent) {
        int n = this.zconvert(mouseEvent.getX(), this.transx);
        int n2 = this.zconvert(mouseEvent.getY(), this.transy);
        this.findSummit(n, n2);
        if (this.editedPolyline != null && this.mode != 4) {
            this.infoPolyMenuItem.setText("Polyline edition");
            this.delSummitMenuItem.setEnabled(false);
            this.brkShapeMenuItem.setEnabled(false);
            this.set0ShapeMenuItem.setEnabled(this.selSummit != -1);
            if (this.selSummit != -1) {
                this.delSummitMenuItem.setEnabled(this.editedPolyline.canDeleteSummit(this.selSummit));
                String string = this.infoPolyMenuItem.getText();
                string = string + " [Summit: " + this.selSummit + " ]";
                this.infoPolyMenuItem.setText(string);
            } else {
                this.brkShapeMenuItem.setEnabled(this.editedPolyline.canBreakShape(n, n2));
            }
            this.lastX = n;
            this.lastY = n2;
            this.polyMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        } else {
            Component[] componentArray;
            JDObject jDObject = this.findObject(n, n2);
            if (jDObject != null && !this.isSelected(jDObject)) {
                this.unselectAll(false);
                this.selObjects.add(jDObject);
                this.repaint(jDObject.getRepaintRect());
                this.fireSelectionChange();
            }
            int n3 = this.selObjects.size();
            jDObject = null;
            if (n3 > 0) {
                jDObject = (JDObject)this.selObjects.get(0);
            }
            if (this.mode == 4 && this.objMenu == null) {
                this.addToMenu(null);
            }
            this.infoMenuItem.setVisible(n3 >= 1);
            if (n3 == 1) {
                componentArray = this.selSummit != -1 ? " Summit:" + Integer.toString(this.selSummit) : "";
                this.infoMenuItem.setText(jDObject.getName() + " [" + jDObject.toString() + "]" + (String)componentArray);
            } else {
                this.infoMenuItem.setText("Multiple selection");
            }
            if (this.mode == 4) {
                componentArray = this.objMenu.getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    if (i < componentArray.length - 1) {
                        componentArray[i].setEnabled(i > 1 && n3 > 0);
                        componentArray[i].setVisible(n3 > 0);
                        continue;
                    }
                    componentArray[i].setEnabled(i > 1);
                    componentArray[i].setVisible(true);
                }
            } else {
                this.cutMenuItem.setEnabled(n3 > 0);
                this.copyMenuItem.setEnabled(n3 > 0);
                this.pasteMenuItem.setEnabled(this.clipboard.size() > 0);
                this.deleteMenuItem.setEnabled(n3 > 0);
                this.groupMenuItem.setVisible(n3 > 0);
                if (n3 == 1) {
                    this.ungroupMenuItem.setVisible(jDObject instanceof JDGroup);
                } else {
                    this.ungroupMenuItem.setVisible(false);
                }
                this.raiseMenuItem.setVisible(n3 == 1);
                this.lowerMenuItem.setVisible(n3 == 1);
                this.frontMenuItem.setVisible(n3 >= 1);
                this.backMenuItem.setVisible(n3 >= 1);
                if (jDObject != null) {
                    int n4 = this.objects.indexOf(jDObject);
                    this.raiseMenuItem.setEnabled(n4 < this.objects.size() - 1);
                    this.lowerMenuItem.setEnabled(n4 > 0);
                }
                boolean bl = jDObject instanceof JDPolyline && n3 == 1;
                this.editShapeMenuItem.setVisible(bl);
                this.connectShapeMenuItem.setVisible(bl);
                this.sep1.setVisible(this.infoMenuItem.isVisible());
                this.sep2.setVisible(this.editShapeMenuItem.isVisible());
                this.sep3.setVisible(this.groupMenuItem.isVisible() || this.ungroupMenuItem.isVisible());
                this.sep5.setVisible(this.raiseMenuItem.isVisible() || this.frontMenuItem.isVisible());
            }
            this.lastX = n;
            this.lastY = n2;
            this.objMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void initCreate(int n) {
        this.creationMode = n;
        this.creationParam = null;
        this.sliderRef = null;
        this.connectPolyline = null;
        if (this.editedPolyline != null) {
            Rectangle rectangle = this.editedPolyline.getRepaintRect();
            this.editedPolyline = null;
            this.repaint(rectangle);
        }
        this.updateCreationStatus();
    }

    void setStatus(String string) {
        this.currentStatus = string == null ? " " : (string.length() == 0 ? " " : string);
        if (this.statusLabel != null) {
            this.statusLabel.setText(this.currentStatus);
        }
    }

    private void addStatus(String string) {
        if (this.statusLabel != null) {
            this.statusLabel.setText(this.currentStatus + string);
        }
    }

    private Cursor getCursorForMotion(JDObject jDObject, int n) {
        switch (jDObject.getSummitMotion(n)) {
            case 3: {
                if (jDObject instanceof JDRectangular) {
                    double d = jDObject.getSummit(n).getX();
                    double d2 = jDObject.getSummit(n).getY();
                    double d3 = (double)jDObject.getBoundRect().x + (double)jDObject.getBoundRect().width / 2.0;
                    double d4 = (double)jDObject.getBoundRect().y + (double)jDObject.getBoundRect().height / 2.0;
                    if (d < d3) {
                        if (d2 < d4) {
                            return nwCursor;
                        }
                        return swCursor;
                    }
                    if (d2 < d4) {
                        return neCursor;
                    }
                    return seCursor;
                }
                return bCursor;
            }
            case 0: {
                return dCursor;
            }
            case 1: {
                return hCursor;
            }
            case 2: {
                return vCursor;
            }
        }
        return dCursor;
    }

    private Rectangle buildSelectionRect() {
        Point point = new Point(this.selX1, this.selY1);
        Point point2 = new Point(this.selX2, this.selY2);
        return this.buildRectFromLine(point, point2);
    }

    private Rectangle buildRectFromLine(Point point, Point point2) {
        Rectangle rectangle = new Rectangle();
        int n = this.zconvert(1, 0);
        if (n < 1) {
            n = 1;
        }
        if (point.x < point2.x) {
            if (point.y < point2.y) {
                rectangle.setRect(point.x - n, point.y - n, point2.x - point.x + 2 * n, point2.y - point.y + 2 * n);
            } else {
                rectangle.setRect(point.x - n, point2.y - n, point2.x - point.x + 2 * n, point.y - point2.y + 2 * n);
            }
        } else if (point.y < point2.y) {
            rectangle.setRect(point2.x - n, point.y - n, point.x - point2.x + 2 * n, point2.y - point.y + 2 * n);
        } else {
            rectangle.setRect(point2.x - n, point2.y - n, point.x - point2.x + 2 * n, point.y - point2.y + 2 * n);
        }
        return rectangle;
    }

    private boolean findSummit(int n, int n2) {
        boolean bl = false;
        this.curObject = -1;
        this.selSummit = -1;
        if (this.selObjects.size() != 0) {
            int n3 = 0;
            bl = false;
            JDObject jDObject = null;
            while (n3 < this.selObjects.size() && !bl) {
                jDObject = (JDObject)this.selObjects.get(n3);
                this.selSummit = jDObject.getSummit(n, n2, this.zdconvert(6.0, 0.0));
                bl = this.selSummit != -1;
                if (bl) continue;
                ++n3;
            }
            if (bl) {
                this.curObject = n3;
                this.setCursor(this.getCursorForMotion(jDObject, this.selSummit));
            } else {
                this.setCursor(dCursor);
            }
        }
        return bl;
    }

    private JDObject findObject(int n, int n2) {
        boolean bl = false;
        int n3 = this.objects.size() - 1;
        while (!bl && n3 >= 0) {
            bl = ((JDObject)this.objects.get(n3)).isInsideObject(n, n2);
            if (bl) continue;
            --n3;
        }
        if (bl) {
            return (JDObject)this.objects.get(n3);
        }
        return null;
    }

    private JDObject findMouseListenerObject(int n, int n2) {
        boolean bl = false;
        int n3 = this.objects.size() - 1;
        while (!bl && n3 >= 0) {
            JDObject jDObject = (JDObject)this.objects.get(n3);
            if (jDObject.hasMouseListener()) {
                bl = ((JDObject)this.objects.get(n3)).isInsideObject(n, n2);
            }
            if (bl) continue;
            --n3;
        }
        if (bl) {
            return (JDObject)this.objects.get(n3);
        }
        return null;
    }

    private void selectObjects(int n, int n2, Vector vector) {
        for (int i = 0; i < this.objects.size(); ++i) {
            this.getObjectAt(i).findObjectsAt(n, n2, vector);
        }
    }

    private void createObject(JDObject jDObject, int n) {
        this.unselectAll(false);
        this.lastCreatedObject = jDObject;
        this.objects.add(jDObject);
        this.creationMode = 0;
        this.selObjects.add(jDObject);
        this.isDraggingSummit = n >= 0;
        this.curObject = 0;
        this.selSummit = n;
        this.editedPolyline = null;
        this.repaint(jDObject.getRepaintRect());
        this.fireSelectionChange();
        if (!this.isDraggingSummit) {
            this.setNeedToSave(true, "Object creation");
            this.fireCreationDone();
            this.lastCreatedObject = null;
        }
    }

    private void updateCreationStatus() {
        switch (this.creationMode) {
            case 1: {
                this.setStatus("Left click and drag to create a rectangle");
                break;
            }
            case 8: {
                this.setStatus("Left click and drag to create a rounded rectangle");
                break;
            }
            case 2: {
                this.setStatus("Left click and drag to create a line");
                break;
            }
            case 3: {
                this.setStatus("Left click and drag to create an ellipse");
                break;
            }
            case 4: {
                this.setStatus("Left click to create a new point and right click to create the last point");
                break;
            }
            case 5: {
                this.setStatus("Left click to create the label");
                break;
            }
            case 6: {
                this.setStatus("Left click to create a new point and right click to create the last point");
                break;
            }
            case 9: {
                this.setStatus("Left click to create an image");
                break;
            }
            case 11: {
                this.setStatus("Left click to create an axis");
                break;
            }
            case 12: {
                this.setStatus("Left click and drag to create a bar");
                break;
            }
            case 13: {
                this.setStatus("Left click and drag to create a slider");
                break;
            }
            case 14: {
                this.setStatus("Left click on a object to pick up new slider cursor");
                break;
            }
            case 15: {
                this.setStatus("Left click on the polyline to be connected.");
                break;
            }
            case 10: {
                this.setStatus("Left click to create a JDSwingObject : " + JDUtils.buildShortClassName(this.creationParam));
                break;
            }
            case 7: {
                this.setStatus("Left click to paste");
            }
        }
    }

    private void rebuildBackup(int n) {
        this.clearObjects();
        this.editedPolyline = null;
        this.objects = ((UndoBuffer)this.undo.get(n)).rebuild();
        this.repaint();
        this.fireValueChanged();
        this.fireSelectionChange();
    }

    void fireSelectionChange() {
        JDUtils.updatePropertyDialog(this.selObjects);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((JDrawEditorListener)this.listeners.get(i)).selectionChanged();
        }
    }

    private void fireCreationDone() {
        this.setStatus("");
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((JDrawEditorListener)this.listeners.get(i)).creationDone();
        }
    }

    void fireClipboardChange() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((JDrawEditorListener)this.listeners.get(i)).clipboardChanged();
        }
    }

    void fireValueChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((JDrawEditorListener)this.listeners.get(i)).valueChanged();
        }
    }

    private void fireSizeChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((JDrawEditorListener)this.listeners.get(i)).sizeChanged();
        }
    }

    private void applyGlobalOption(JDFileLoader jDFileLoader) {
        this.setBackground(jDFileLoader.globalBackground);
    }

    private void createContextualMenu() {
        this.objMenu = new JPopupMenu();
        this.infoMenuItem = new JMenuItem();
        this.infoMenuItem.setEnabled(false);
        this.cutMenuItem = new JMenuItem("Cut");
        this.cutMenuItem.addActionListener(this);
        this.copyMenuItem = new JMenuItem("Copy");
        this.copyMenuItem.addActionListener(this);
        this.pasteMenuItem = new JMenuItem("Paste");
        this.pasteMenuItem.addActionListener(this);
        this.deleteMenuItem = new JMenuItem("Delete");
        this.deleteMenuItem.addActionListener(this);
        this.editShapeMenuItem = new JMenuItem("Edit polyline");
        this.editShapeMenuItem.addActionListener(this);
        this.connectShapeMenuItem = new JMenuItem("Connect");
        this.connectShapeMenuItem.addActionListener(this);
        this.raiseMenuItem = new JMenuItem("Raise");
        this.raiseMenuItem.addActionListener(this);
        this.lowerMenuItem = new JMenuItem("Lower");
        this.lowerMenuItem.addActionListener(this);
        this.frontMenuItem = new JMenuItem("Bring to front");
        this.frontMenuItem.addActionListener(this);
        this.backMenuItem = new JMenuItem("Send to back");
        this.backMenuItem.addActionListener(this);
        this.groupMenuItem = new JMenuItem("Group");
        this.groupMenuItem.addActionListener(this);
        this.ungroupMenuItem = new JMenuItem("Ungroup");
        this.ungroupMenuItem.addActionListener(this);
        this.zoomInMenuItem = new JMenuItem("Zoom in");
        this.zoomInMenuItem.addActionListener(this);
        this.zoomOutMenuItem = new JMenuItem("Zoom out");
        this.zoomOutMenuItem.addActionListener(this);
        this.objMenu.add(this.infoMenuItem);
        this.sep1 = new JSeparator();
        this.objMenu.add(this.sep1);
        this.objMenu.add(this.cutMenuItem);
        this.objMenu.add(this.copyMenuItem);
        this.objMenu.add(this.pasteMenuItem);
        this.objMenu.add(this.deleteMenuItem);
        this.sep4 = new JSeparator();
        this.objMenu.add(this.sep4);
        this.objMenu.add(this.groupMenuItem);
        this.objMenu.add(this.ungroupMenuItem);
        this.sep3 = new JSeparator();
        this.objMenu.add(this.sep3);
        this.objMenu.add(this.editShapeMenuItem);
        this.objMenu.add(this.connectShapeMenuItem);
        this.sep2 = new JSeparator();
        this.objMenu.add(this.sep2);
        this.objMenu.add(this.raiseMenuItem);
        this.objMenu.add(this.lowerMenuItem);
        this.objMenu.add(this.frontMenuItem);
        this.objMenu.add(this.backMenuItem);
        this.sep5 = new JSeparator();
        this.objMenu.add(this.sep5);
        this.objMenu.add(this.zoomInMenuItem);
        this.objMenu.add(this.zoomOutMenuItem);
        this.polyMenu = new JPopupMenu();
        this.infoPolyMenuItem = new JMenuItem();
        this.infoPolyMenuItem.setEnabled(false);
        this.delSummitMenuItem = new JMenuItem("Delete control point");
        this.delSummitMenuItem.addActionListener(this);
        this.brkShapeMenuItem = new JMenuItem("Add a control point here");
        this.brkShapeMenuItem.addActionListener(this);
        this.set0ShapeMenuItem = new JMenuItem("Set as starting point");
        this.set0ShapeMenuItem.addActionListener(this);
        this.reorderShapeMenuItem = new JMenuItem("Invert order");
        this.reorderShapeMenuItem.addActionListener(this);
        this.cancelShapeMenuItem = new JMenuItem("Return to normal edition mode");
        this.cancelShapeMenuItem.addActionListener(this);
        this.polyMenu.add(this.infoPolyMenuItem);
        this.polyMenu.add(new JSeparator());
        this.polyMenu.add(this.delSummitMenuItem);
        this.polyMenu.add(this.set0ShapeMenuItem);
        this.polyMenu.add(this.brkShapeMenuItem);
        this.polyMenu.add(this.reorderShapeMenuItem);
        this.polyMenu.add(this.cancelShapeMenuItem);
    }

    private boolean isSelectedSummit(int n) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.selSummits.length && !bl) {
            bl = this.selSummits[n2] == n;
            if (bl) continue;
            ++n2;
        }
        return bl;
    }

    private void selectSummit(int n) {
        if (!this.isSelectedSummit(n)) {
            int[] nArray = new int[this.selSummits.length + 1];
            for (int i = 0; i < this.selSummits.length; ++i) {
                nArray[i] = this.selSummits[i];
            }
            nArray[i] = n;
            this.selSummits = nArray;
        }
    }

    private Rectangle buildRepaintRect(Vector vector) {
        Rectangle rectangle = null;
        for (int i = 0; i < vector.size(); ++i) {
            JDObject jDObject = (JDObject)vector.get(i);
            rectangle = rectangle == null ? jDObject.getRepaintRect() : rectangle.union(jDObject.getRepaintRect());
        }
        return rectangle;
    }

    private void repaintLater() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JDrawEditor.this.repaint();
            }
        });
    }

    private boolean createObject(int n, int n2) {
        int n3;
        int n4;
        if (this.alignToGrid) {
            n4 = (n + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
            n3 = (n2 + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
        } else {
            n4 = n;
            n3 = n2;
        }
        switch (this.creationMode) {
            case 1: {
                this.createObject(new JDRectangle("Rectangle", n4, n3, 4, 4), 4);
                return true;
            }
            case 8: {
                this.createObject(new JDRoundRectangle("RoundRectangle", n4, n3, 4, 4), 4);
                return true;
            }
            case 2: {
                this.createObject(new JDLine("Line", n4, n3, n4, n3), 1);
                return true;
            }
            case 3: {
                this.createObject(new JDEllipse("Ellipse", n4, n3, 4, 4), 4);
                return true;
            }
            case 4: 
            case 6: {
                int n5 = this.tmpPoints.size();
                if (n5 == 0) {
                    this.unselectAll(false);
                    this.tmpPoints.clear();
                    this.tmpPoints.add(new Point(n4, n3));
                    this.tmpPoints.add(new Point(n4 + 4, n3 + 4));
                } else {
                    Rectangle rectangle = this.buildRectFromLine((Point)this.tmpPoints.get(n5 - 2), (Point)this.tmpPoints.get(n5 - 1));
                    this.tmpPoints.add(new Point(n4, n3));
                    this.repaint(rectangle.union(this.buildRectFromLine((Point)this.tmpPoints.get(n5 - 1), (Point)this.tmpPoints.get(n5))));
                }
                this.fireSelectionChange();
                return true;
            }
            case 5: {
                String string = JOptionPane.showInputDialog(this, "Enter a text", "Create label", 1);
                if (string != null) {
                    this.createObject(new JDLabel("Label", string, n4, n3), -1);
                } else {
                    this.creationMode = 0;
                    this.fireCreationDone();
                }
                return true;
            }
            case 9: {
                JFileChooser jFileChooser = new JFileChooser(".");
                String[] stringArray = new String[]{"gif", "png", "jpg"};
                jFileChooser.addChoosableFileFilter(new JDFileFilter("Image file", stringArray));
                if (jFileChooser.showOpenDialog(this) != 0) break;
                this.createObject(new JDImage("Image", jFileChooser.getSelectedFile().getAbsolutePath(), n4, n3), -1);
                return true;
            }
            case 10: {
                if (this.creationParam != null) {
                    this.createObject(new JDSwingObject("SwingObject", this.creationParam, n4, n3), -1);
                    this.repaintLater();
                }
                return true;
            }
            case 11: {
                this.createObject(new JDAxis("Axis", n4, n3, 50, 100), -1);
                return true;
            }
            case 12: {
                this.createObject(new JDBar("Bar", n4, n3, 4, 4), 4);
                return true;
            }
            case 13: {
                this.createObject(new JDSlider("Slider", n4, n3, 4, 4), 4);
                return true;
            }
            case 14: {
                JDObject jDObject = this.findObject(n, n2);
                if (jDObject == null) {
                    JOptionPane.showMessageDialog(this, "Cannot pick new cursor for slider:\nNo object found here.");
                } else if (jDObject instanceof JDSlider) {
                    JOptionPane.showMessageDialog(this, "Cannot pick new cursor for slider:\n.Slider cannot be taken as cursor.");
                } else {
                    this.sliderRef.setCursor(jDObject.copy(0, 0));
                    this.setNeedToSave(true, "Pick new cursor");
                }
                this.repaint();
                this.creationMode = 0;
                this.fireCreationDone();
                return true;
            }
            case 15: {
                JDObject jDObject = this.findObject(n, n2);
                if (jDObject == null) {
                    JOptionPane.showMessageDialog(this, "No polyline found here.");
                } else if (!(jDObject instanceof JDPolyline)) {
                    JOptionPane.showMessageDialog(this, "This object is not a polyline.");
                } else if (jDObject.equals(this.connectPolyline)) {
                    JOptionPane.showMessageDialog(this, "Cannot connect to itself.");
                } else {
                    this.connectPolyline.connect((JDPolyline)jDObject);
                    this.objects.remove(jDObject);
                    this.setNeedToSave(true, "Connect polyline");
                }
                this.repaint();
                this.creationMode = 0;
                this.fireCreationDone();
                return true;
            }
            case 7: {
                this.creationMode = 0;
                this.pasteClipboard(n4, n3);
                this.fireCreationDone();
                return true;
            }
        }
        return false;
    }
}

