/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.TableRowModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.JobAttributes;
import java.awt.PageAttributes;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class JTableRow
extends JPanel
implements ActionListener,
MouseListener {
    public static final int PRINT_BIG = 0;
    public static final int PRINT_MEDIUM = 1;
    public static final int PRINT_SMALL = 2;
    protected int wT;
    protected int hT;
    protected boolean editable = false;
    protected Font theFont;
    protected File currentFile = null;
    protected JScrollPane tableView;
    protected JTable theTable = null;
    protected TableRowModel dm;
    protected Object[][] theData;
    protected String[] colName = null;
    protected JPanel rowPanel;
    protected JPanel cornerPanel;
    protected JTable rowTable = null;
    protected TableModel dmr;
    protected Object[][] rowData = null;
    protected Point menuLocation;
    protected JPopupMenu tableMenu;
    protected JMenuItem selectAllMenuItem;
    protected JMenuItem selectNoneMenuItem;
    protected JMenuItem selectColumnMenuItem;
    protected JMenuItem selectRowMenuItem;
    protected JMenuItem copyMenuItem;
    protected JMenuItem saveMenuItem;
    protected JMenuItem print1MenuItem;
    protected JMenuItem print2MenuItem;
    protected JMenuItem print3MenuItem;
    protected static final JLabel noDataLabel = new JLabel("No Data");

    public JTableRow() {
        this.setLayout(new BorderLayout());
        this.setBorder(null);
        this.theData = null;
        this.rowData = null;
        this.theFont = ATKConstant.labelFont;
        this.wT = 0;
        this.hT = 0;
        this.dm = new TableRowModel();
        this.tableView = new JScrollPane();
        this.tableView.setPreferredSize(new Dimension(640, 480));
        this.tableView.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                JTableRow.this.placeComponent();
            }
        });
        this.add((Component)this.tableView, "Center");
        this.rowPanel = new JPanel();
        this.rowPanel.setBorder(null);
        this.rowPanel.setLayout(null);
        this.rowPanel.setPreferredSize(new Dimension(45, 0));
        this.add((Component)this.rowPanel, "West");
        this.rowData = null;
        this.dmr = new TableModel(){

            @Override
            public void addTableModelListener(TableModelListener tableModelListener) {
            }

            @Override
            public void removeTableModelListener(TableModelListener tableModelListener) {
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
            }

            @Override
            public Class<?> getColumnClass(int n) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            @Override
            public String getColumnName(int n) {
                return "";
            }

            @Override
            public int getRowCount() {
                return JTableRow.this.hT;
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                if (JTableRow.this.rowData != null) {
                    return JTableRow.this.rowData[n][n2];
                }
                return "";
            }
        };
        this.cornerPanel = new JPanel();
        this.cornerPanel.setBorder(BorderFactory.createEtchedBorder());
        this.rowPanel.add(this.cornerPanel);
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                JTableRow.this.placeComponent();
            }

            public void componentShown(ComponentEvent componentEvent) {
                JTableRow.this.placeComponent();
            }
        });
        this.tableMenu = new JPopupMenu();
        this.menuLocation = new Point(0, 0);
        this.selectNoneMenuItem = new JMenuItem("Clear selection");
        this.selectNoneMenuItem.addActionListener(this);
        this.selectAllMenuItem = new JMenuItem("Select All");
        this.selectAllMenuItem.addActionListener(this);
        this.selectRowMenuItem = new JMenuItem("Select current row");
        this.selectRowMenuItem.addActionListener(this);
        this.selectColumnMenuItem = new JMenuItem("Select current column");
        this.selectColumnMenuItem.addActionListener(this);
        this.copyMenuItem = new JMenuItem("Copy selection to clipboard");
        this.copyMenuItem.addActionListener(this);
        this.saveMenuItem = new JMenuItem("Save selection");
        this.saveMenuItem.addActionListener(this);
        this.print1MenuItem = new JMenuItem("Print table (Big size)");
        this.print1MenuItem.addActionListener(this);
        this.print2MenuItem = new JMenuItem("Print table (Medium size)");
        this.print2MenuItem.addActionListener(this);
        this.print3MenuItem = new JMenuItem("Print table (Small size)");
        this.print3MenuItem.addActionListener(this);
        this.tableMenu.add(this.selectNoneMenuItem);
        this.tableMenu.add(this.selectAllMenuItem);
        this.tableMenu.add(this.selectRowMenuItem);
        this.tableMenu.add(this.selectColumnMenuItem);
        this.tableMenu.add(new JSeparator());
        this.tableMenu.add(this.copyMenuItem);
        this.tableMenu.add(this.saveMenuItem);
        this.tableMenu.add(new JSeparator());
        this.tableMenu.add(this.print1MenuItem);
        this.tableMenu.add(this.print2MenuItem);
        this.tableMenu.add(this.print3MenuItem);
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
        this.dm.setEditable(this.editable);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setData(Object[][] objectArray, int n, int n2) {
        int n3;
        if (objectArray == null) {
            this.clearData();
            return;
        }
        int n4 = objectArray.length;
        if (n4 == 0) {
            this.clearData();
            return;
        }
        int n5 = objectArray[0].length;
        if (n5 == 0) {
            this.clearData();
            return;
        }
        String[] stringArray = new String[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            stringArray[n3] = Integer.toString(n + n3);
        }
        Object[][] objectArray2 = new Object[n4][1];
        for (n3 = 0; n3 < n4; ++n3) {
            objectArray2[n3][0] = Integer.toString(n2 + n3);
        }
        this.theData = objectArray;
        this.rowData = objectArray2;
        this.colName = stringArray;
        this.updateTables(n4, n5);
    }

    public void setData(Object[][] objectArray, String[] stringArray) {
        int n;
        if (stringArray != null) {
            this.colName = stringArray;
        }
        int n2 = (n = objectArray == null ? 0 : objectArray.length) == 0 ? (stringArray == null ? 0 : stringArray.length) : objectArray[0].length;
        if (n2 == 0) {
            this.clearData();
            return;
        }
        this.remove(this.rowPanel);
        this.theData = objectArray;
        this.rowData = null;
        this.updateTables(n, n2);
    }

    protected void updateTables(int n, int n2) {
        boolean bl = false;
        if (this.dm.getData() == null || this.theData == null) {
            bl = true;
        } else if (this.theData.length != this.dm.getData().length) {
            bl = true;
        } else if (this.theData.length > 0) {
            if (this.theData[0] == null) {
                if (this.dm.getData()[0] != null) {
                    bl = true;
                }
            } else if (this.theData[0].length != this.dm.getData()[0].length) {
                bl = true;
            }
        }
        this.dm.setData(this.theData);
        String[] stringArray = this.dm.getColName();
        if (stringArray == null || this.colName == null || stringArray.length != this.colName.length) {
            bl = true;
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.colName[i] != null && this.colName[i].equals(stringArray[i])) continue;
                bl = true;
                break;
            }
        }
        this.dm.setColName(this.colName);
        this.wT = n2;
        this.hT = n;
        if (this.theTable == null) {
            this.createTable();
            this.placeComponent();
        } else {
            if (bl) {
                this.dm.fireTableStructureChanged();
            } else if (this.dm.getRowCount() > 0) {
                this.dm.fireTableRowsUpdated(0, this.dm.getRowCount() - 1);
            }
            if (this.rowTable != null) {
                TableModelEvent tableModelEvent = new TableModelEvent(this.dmr, 0, this.hT - 1);
                this.rowTable.tableChanged(tableModelEvent);
            }
        }
        if (bl) {
            this.adjustColumnSize();
        }
        this.updateViewPortView();
    }

    public Object getObjectAt(int n, int n2) {
        if (this.theData != null) {
            return this.theData[n][n2];
        }
        return null;
    }

    public void clearData() {
        this.theData = null;
        this.rowData = null;
        this.updateTables(0, 0);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.theFont = font;
        noDataLabel.setFont(font);
        noDataLabel.revalidate();
        if (this.theTable != null) {
            if (this.rowTable != null) {
                this.rowTable.setFont(font);
            }
            this.theTable.setFont(font);
            this.tableView.revalidate();
            this.placeComponent();
        }
    }

    public Font getFont() {
        return this.theFont;
    }

    public void adjustSize() {
        if (this.theTable == null) {
            return;
        }
        Dimension dimension = this.theTable.getPreferredSize();
        dimension.width += 4;
        dimension.height += this.theTable.getRowHeight() + 4;
        this.tableView.setPreferredSize(dimension);
    }

    public void adjustColumnSize() {
        if (this.theTable == null) {
            return;
        }
        int[] nArray = this.measureColumns(this.theFont);
        for (int i = 0; i < nArray.length; ++i) {
            this.theTable.getColumnModel().getColumn(i).setPreferredWidth(nArray[i] + 16);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.copyMenuItem) {
            StringSelection stringSelection = new StringSelection(this.makeTabbedString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        } else if (object == this.selectAllMenuItem) {
            this.theTable.selectAll();
        } else if (object == this.selectNoneMenuItem) {
            this.theTable.clearSelection();
        } else if (object == this.selectRowMenuItem) {
            this.theTable.clearSelection();
            int n = this.theTable.rowAtPoint(this.menuLocation);
            this.theTable.setRowSelectionInterval(n, n);
            this.theTable.setColumnSelectionInterval(0, this.wT - 1);
        } else if (object == this.selectColumnMenuItem) {
            this.theTable.clearSelection();
            int n = this.theTable.columnAtPoint(this.menuLocation);
            this.theTable.setColumnSelectionInterval(n, n);
            this.theTable.setRowSelectionInterval(0, this.hT - 1);
        } else if (object == this.print1MenuItem) {
            this.printTable(0);
        } else if (object == this.print2MenuItem) {
            this.printTable(1);
        } else if (object == this.print3MenuItem) {
            this.printTable(2);
        } else if (object == this.saveMenuItem) {
            int n;
            JFileChooser jFileChooser = new JFileChooser(".");
            if (this.currentFile != null) {
                jFileChooser.setSelectedFile(this.currentFile);
            }
            if ((n = jFileChooser.showSaveDialog(this)) == 0) {
                this.currentFile = jFileChooser.getSelectedFile();
                try {
                    FileWriter fileWriter = new FileWriter(this.currentFile);
                    fileWriter.write(this.makeTabbedString());
                    fileWriter.close();
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this, iOException, "Error while saving data", 0);
                }
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3) {
            this.menuLocation.x = mouseEvent.getX();
            this.menuLocation.y = mouseEvent.getY();
            this.tableMenu.show(this.theTable, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected void createTable() {
        if (this.theTable != null) {
            this.theTable.removeMouseListener(this);
            if (this.rowTable != null) {
                this.rowPanel.remove(this.rowTable);
            }
        }
        this.theTable = new JTable(this.dm);
        this.theTable.setFont(this.theFont);
        this.theTable.setRowSelectionAllowed(true);
        this.theTable.setColumnSelectionAllowed(true);
        this.theTable.setAutoResizeMode(0);
        this.theTable.addMouseListener(this);
        noDataLabel.setFont(this.theFont);
        if (this.rowData != null) {
            this.rowTable = new JTable(this.dmr);
            this.rowTable.setFont(this.theFont);
            this.rowTable.setAutoResizeMode(0);
            this.rowTable.setBackground(this.getBackground());
            this.rowTable.setEnabled(false);
            this.rowPanel.add(this.rowTable);
        }
    }

    protected void updateViewPortView() {
        if (this.wT == 0 && this.hT == 0) {
            if (this.tableView.getViewport().getView() != noDataLabel) {
                this.tableView.setViewportView(noDataLabel);
            }
        } else if (this.tableView.getViewport().getView() != this.theTable) {
            this.tableView.setViewportView(this.theTable);
        }
    }

    protected void placeComponent() {
        if (this.rowData != null) {
            Dimension dimension = this.getSize();
            int n = 17;
            this.cornerPanel.setBounds(-5, -5, 54, n + 5);
            Rectangle rectangle = this.tableView.getViewport().getViewRect();
            this.rowTable.setBounds(0, -rectangle.y + n, 45, rectangle.y + (int)dimension.getHeight());
            this.rowTable.revalidate();
        }
    }

    protected String makeTabbedString() {
        int n;
        int[] nArray = this.theTable.getSelectedColumns();
        int[] nArray2 = this.theTable.getSelectedRows();
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < nArray.length; ++n) {
            stringBuffer.append(this.theTable.getColumnName(nArray[n]));
            if (n >= nArray.length - 1) continue;
            stringBuffer.append('\t');
        }
        stringBuffer.append('\n');
        for (n = 0; n < nArray2.length; ++n) {
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append(this.theData[nArray2[n]][nArray[i]]);
                if (i >= nArray.length - 1) continue;
                stringBuffer.append('\t');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    protected int[] measureColumns(Font font) {
        Object object;
        int n;
        if (this.theData == null) {
            return new int[0];
        }
        int[] nArray = new int[this.wT];
        for (n = 0; n < this.wT; ++n) {
            object = ATKGraphicsUtils.measureString(this.colName[n], font);
            nArray[n] = ((Dimension)object).width;
        }
        for (n = 0; n < this.wT; ++n) {
            for (int i = 0; i < this.hT; ++i) {
                object = this.theData[i][n].toString();
                Dimension dimension = ATKGraphicsUtils.measureString((String)object, font);
                if (dimension.width <= nArray[n]) continue;
                nArray[n] = dimension.width;
            }
        }
        return nArray;
    }

    public void printTable(int n) {
        PrintJob printJob;
        int n2;
        Font font;
        int n3 = 140;
        int n4 = n3 / 2;
        if (this.theData == null) {
            return;
        }
        switch (n) {
            case 0: {
                font = new Font("Dialog", 0, 16);
                break;
            }
            case 1: {
                font = new Font("Dialog", 0, 12);
                break;
            }
            default: {
                font = new Font("Dialog", 0, 8);
            }
        }
        int[] nArray = this.measureColumns(font);
        int[] nArray2 = new int[this.wT];
        int n5 = (int)(ATKGraphicsUtils.getLineMetrics("Page 000", font).getAscent() + 0.5f);
        Dimension dimension = ATKGraphicsUtils.measureString("Page 000", font);
        int n6 = dimension.height;
        for (n2 = 0; n2 < this.wT; ++n2) {
            Dimension dimension2 = ATKGraphicsUtils.measureString(this.colName[n2], font);
            nArray2[n2] = dimension2.width;
        }
        double d = 11.69291338582677 * (double)(n3 - 1) - 3.0 * (double)n6;
        int n7 = (int)((double)((n6 + 4) * this.hT) / d) + 1;
        PageAttributes pageAttributes = new PageAttributes();
        JobAttributes jobAttributes = new JobAttributes();
        pageAttributes.setPrintQuality(PageAttributes.PrintQualityType.HIGH);
        pageAttributes.setColor(PageAttributes.ColorType.COLOR);
        pageAttributes.setMedia(PageAttributes.MediaType.A4);
        pageAttributes.setOrientationRequested(PageAttributes.OrientationRequestedType.PORTRAIT);
        pageAttributes.setPrinterResolution(n3);
        jobAttributes.setMaxPage(n7);
        jobAttributes.setMinPage(1);
        jobAttributes.setPageRanges(new int[][]{{1, n7}});
        jobAttributes.setDialog(JobAttributes.DialogType.NATIVE);
        Window window = ATKGraphicsUtils.getWindowForComponent(this);
        if (window instanceof Frame) {
            printJob = Toolkit.getDefaultToolkit().getPrintJob((Frame)window, "Print table", jobAttributes, pageAttributes);
        } else {
            Frame frame = new Frame();
            printJob = Toolkit.getDefaultToolkit().getPrintJob(frame, "Print table", jobAttributes, pageAttributes);
        }
        if (printJob != null) {
            try {
                int n8 = printJob.getPageDimension().width - n3;
                int n9 = printJob.getPageDimension().height - n3;
                n7 = 1;
                int n10 = 0;
                int n11 = (n9 - (n6 + 4) * 3) / (n6 + 4);
                int n12 = this.hT / n11 + 1;
                while (n10 < this.hT) {
                    int n13;
                    int n14 = 0;
                    int n15 = 0;
                    Graphics graphics = printJob.getGraphics();
                    graphics.translate(n4, n4);
                    graphics.setFont(font);
                    for (n2 = 0; n2 < this.wT; ++n2) {
                        n13 = (nArray[n2] - nArray2[n2]) / 2;
                        graphics.setColor(Color.LIGHT_GRAY);
                        graphics.fillRect(n14, n15, nArray[n2] + 6, n6 + 2);
                        graphics.setColor(Color.BLACK);
                        graphics.drawString(this.colName[n2], (n14 += 3) + n13, n15 + n5);
                        n14 += nArray[n2] + 3;
                        if (n2 >= this.wT - 1) continue;
                        graphics.drawLine(n14, n15, n14, n15 + n6);
                    }
                    graphics.drawLine(0, n15 += n6 + 2, n14, n15);
                    graphics.drawLine(0, n15 + 1, n14, n15 + 1);
                    n15 += 2;
                    graphics.setColor(Color.BLACK);
                    for (n13 = 0; n10 < this.hT && n13 < n11; ++n10, ++n13) {
                        n14 = 0;
                        for (n2 = 0; n2 < this.wT; ++n2) {
                            for (n2 = 0; n2 < this.wT; ++n2) {
                                graphics.drawString(this.theData[n10][n2].toString(), n14 += 3, n15 + n5);
                                n14 += nArray[n2] + 3;
                                if (n2 >= this.wT - 1) continue;
                                graphics.drawLine(n14, n15, n14, n15 + n6);
                            }
                        }
                        graphics.drawLine(0, n15 += n6 + 2, n14, n15);
                        n15 += 2;
                    }
                    graphics.drawLine(0, 0, n14, 0);
                    graphics.drawLine(n14, 0, n14, n15 -= 2);
                    graphics.drawLine(0, n15, 0, 0);
                    graphics.drawString("Page " + n7 + "/" + n12, n8 - dimension.width, n9 - n6 + n5);
                    graphics.dispose();
                    ++n7;
                }
                printJob.finalize();
                printJob = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(window, "Exception occured while printing\n" + exception.getMessage(), "Print table", 0);
            }
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        String[] stringArray2 = new String[6];
        Object[][] objectArray = new Object[200][6];
        for (int i = 0; i < stringArray2.length; ++i) {
            int n;
            if (i == 0) {
                stringArray2[i] = "Index";
                for (n = 0; n < objectArray.length; ++n) {
                    objectArray[n][i] = new Double(n);
                }
                continue;
            }
            stringArray2[i] = "Column " + i;
            for (n = 0; n < objectArray.length; ++n) {
                objectArray[n][i] = new Double(Math.random());
            }
        }
        JTableRow jTableRow = new JTableRow();
        jTableRow.setData(objectArray, stringArray2);
        jTableRow.adjustColumnSize();
        jFrame.setContentPane(jTableRow);
        ATKGraphicsUtils.centerFrameOnScreen(jFrame);
        jFrame.setVisible(true);
        jFrame.setDefaultCloseOperation(3);
    }
}

