/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.Timer;

public class JArrowButton
extends JComponent
implements MouseListener,
ActionListener {
    public static int UP = 1;
    public static int DOWN = 2;
    private int state;
    private int orientation;
    private Color lightColor;
    private Color darkColor;
    private Timer autoRepeat;
    private int timerDelay;

    public JArrowButton() {
        this.setLayout(null);
        this.setBackground(new Color(200, 200, 200));
        this.setPreferredSize(new Dimension(20, 20));
        this.setOpaque(false);
        this.state = 0;
        this.orientation = UP;
        this.timerDelay = 300;
        this.autoRepeat = new Timer(1000, this);
        this.addMouseListener(this);
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setState(int n) {
        this.state = n;
    }

    public int getState() {
        return this.state;
    }

    public void setBackground(Color color) {
        if (this.getBackground() != null && color.getRGB() == this.getBackground().getRGB()) {
            return;
        }
        this.lightColor = this.computeShadowColor(color, 90.0);
        this.darkColor = this.computeShadowColor(color, -90.0);
        super.setBackground(color);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (actionEvent.getSource() == this.autoRepeat) {
            if (this.autoRepeat.getDelay() != this.timerDelay) {
                this.autoRepeat.setDelay(this.timerDelay);
            }
            MouseListener[] mouseListenerArray = (MouseListener[])this.getListeners(MouseListener.class);
            MouseEvent mouseEvent = new MouseEvent(this, 500, actionEvent.getWhen(), actionEvent.getModifiers(), 3, 3, 1, false);
            for (int i = 0; i < mouseListenerArray.length; ++i) {
                mouseListenerArray[i].mouseClicked(mouseEvent);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.state = 0;
        this.autoRepeat.stop();
        this.autoRepeat.setDelay(1000);
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.state = 1;
        this.autoRepeat.start();
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.state = 0;
        this.autoRepeat.stop();
        this.autoRepeat.setDelay(1000);
        this.repaint();
    }

    protected void paintComponent(Graphics graphics) {
        int n = this.getWidth() - 1;
        int n2 = this.getHeight() - 1;
        int n3 = n / 2;
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        if (this.orientation == UP) {
            nArray[0] = 0;
            nArray2[0] = n2;
            nArray[1] = n3;
            nArray2[1] = 0;
            nArray[2] = n;
            nArray2[2] = n2;
            graphics.setColor(this.getBackground());
            graphics.fillPolygon(nArray, nArray2, 3);
            if (this.state == 0) {
                graphics.setColor(this.lightColor);
                graphics.drawLine(0, n2, n3, 0);
                graphics.setColor(this.darkColor);
                graphics.drawLine(n3, 0, n, n2);
                graphics.drawLine(n, n2, 0, n2);
            } else {
                graphics.setColor(this.darkColor);
                graphics.drawLine(0, n2, n3, 0);
                graphics.setColor(this.lightColor);
                graphics.drawLine(n3, 0, n, n2);
                graphics.drawLine(n, n2, 0, n2);
            }
        } else {
            nArray[0] = 0;
            nArray2[0] = 0;
            nArray[1] = n3;
            nArray2[1] = n2;
            nArray[2] = n;
            nArray2[2] = 0;
            graphics.setColor(this.getBackground());
            graphics.fillPolygon(nArray, nArray2, 3);
            if (this.state == 0) {
                graphics.setColor(this.lightColor);
                graphics.drawLine(0, 0, n3, n2);
                graphics.setColor(this.darkColor);
                graphics.drawLine(n3, n2, n, 0);
                graphics.drawLine(n, 0, 0, 0);
            } else {
                graphics.setColor(this.darkColor);
                graphics.drawLine(0, 0, n3, n2);
                graphics.setColor(this.lightColor);
                graphics.drawLine(n3, n2, n, 0);
                graphics.drawLine(n, 0, 0, 0);
            }
        }
    }

    private void RGBtoYUV(Color color, double[] dArray) {
        double d = color.getRed();
        double d2 = color.getGreen();
        double d3 = color.getBlue();
        dArray[0] = 0.299 * d + 0.587 * d2 + 0.114 * d3;
        dArray[1] = -0.169 * d - 0.331 * d2 + 0.5 * d3 + 128.0;
        dArray[2] = 0.5 * d - 0.419 * d2 - 0.081 * d3 + 128.0;
    }

    private Color createColorFromYUV(double[] dArray) {
        int n = (int)(dArray[0] + 1.4075 * (dArray[2] - 128.0));
        int n2 = (int)(dArray[0] - 0.7169 * (dArray[2] - 128.0) - 0.3455 * (dArray[1] - 128.0));
        int n3 = (int)(dArray[0] + 1.779 * (dArray[1] - 128.0));
        if (n > 255) {
            n = 255;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        return new Color(n, n2, n3);
    }

    private Color computeShadowColor(Color color, double d) {
        double[] dArray = new double[3];
        this.RGBtoYUV(color, dArray);
        dArray[0] = dArray[0] + d;
        return this.createColorFromYUV(dArray);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        JArrowButton jArrowButton = new JArrowButton();
        jFrame.getContentPane().setLayout(null);
        jFrame.getContentPane().add(jArrowButton);
        jArrowButton.setBounds(10, 10, 10, 10);
        jFrame.setSize(200, 100);
        jFrame.setVisible(true);
    }
}

