/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Roi;
import ij.process.ImageProcessor;
import java.awt.Image;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedImagePlus
extends ImagePlus {
    protected Vector<Roi> roiVector = new Vector();
    protected Vector<Roi> selectedRois = new Vector();
    protected Vector<Roi> innerRois = new Vector();
    protected Vector<Roi> outerRois = new Vector();
    protected Roi validatedRoi = null;
    protected boolean allowRoiCreation = true;

    public AdvancedImagePlus() {
    }

    public AdvancedImagePlus(String string, Image image) {
        super(string, image);
    }

    public AdvancedImagePlus(String string, ImageProcessor imageProcessor) {
        super(string, imageProcessor);
    }

    public AdvancedImagePlus(String string, ImageStack imageStack) {
        super(string, imageStack);
    }

    public AdvancedImagePlus(String string) {
        super(string);
    }

    public void setImage(Image image) {
        super.setImage(image);
    }

    public void setRoi(Roi roi) {
        if (roi != null) {
            this.addRoi(roi);
            roi.setImage((ImagePlus)this);
        }
        this.setHandledRoi(roi);
        Roi.previousRoi = null;
    }

    public void killRoi() {
        super.killRoi();
        Roi.previousRoi = null;
    }

    public void setSelectedRoi(Roi roi) {
        if (!this.selectedRois.contains(roi)) {
            this.selectedRois.add(roi);
        }
        this.setHandledRoi(roi);
    }

    public void setHandledRoi(Roi roi) {
        this.roi = roi;
        if (this.getProcessor() != null) {
            this.getProcessor().setRoi(roi);
        }
    }

    public void createNewRoi(int n, int n2) {
        if (this.isAllowRoiCreation()) {
            super.createNewRoi(n, n2);
            if (this.roi != null) {
                this.addRoi(this.roi);
            }
        }
    }

    public void addRoi(Roi roi) {
        if (!this.roiVector.contains(roi)) {
            this.roiVector.add(roi);
        }
    }

    public void removeRoi(Roi roi) {
        this.roiVector.remove(roi);
        this.selectedRois.remove(roi);
        this.innerRois.remove(roi);
        this.outerRois.remove(roi);
        if (this.validatedRoi != null && this.validatedRoi.equals((Object)roi)) {
            this.validatedRoi = null;
        }
        if (this.getRoi() != null && this.getRoi().equals((Object)roi)) {
            this.setRoi(null);
        }
    }

    public Vector<Roi> getAllRois() {
        return this.roiVector;
    }

    public Vector<Roi> getSelectedRois() {
        return this.selectedRois;
    }

    public void setSelectedRois(Vector<Roi> vector) {
        this.selectedRois = vector;
    }

    public void deleteSelectedRois() {
        for (int i = 0; i < this.getSelectedRois().size(); ++i) {
            this.getAllRois().remove(this.getSelectedRois().get(i));
            if (this.getRoi() != null && this.getRoi().equals((Object)this.getSelectedRois().get(i))) {
                this.killRoi();
                this.roi = null;
            }
            this.getInnerRois().remove(this.getSelectedRois().get(i));
            this.getOuterRois().remove(this.getSelectedRois().get(i));
            if (this.validatedRoi != this.getSelectedRois().get(i)) continue;
            this.validatedRoi = null;
        }
        this.getSelectedRois().clear();
        if (this.getAllRois().size() > 0) {
            this.roi = this.getAllRois().get(this.getAllRois().size() - 1);
        }
    }

    public boolean isAllowRoiCreation() {
        return this.allowRoiCreation;
    }

    public void setAllowRoiCreation(boolean bl) {
        this.allowRoiCreation = bl;
    }

    public Vector<Roi> getInnerRois() {
        return this.innerRois;
    }

    public Vector<Roi> getOuterRois() {
        return this.outerRois;
    }

    public Roi getValidatedRoi() {
        return this.validatedRoi;
    }

    public void setValidatedRoi(Roi roi) {
        this.validatedRoi = roi;
    }
}

